--
-- PostgreSQL database dump
--

-- Dumped from database version 9.5.23
-- Dumped by pg_dump version 14.3

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

--
-- Name: agendamentos_atendimentos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.agendamentos_atendimentos (
    id bigint NOT NULL,
    inicio timestamp(0) without time zone NOT NULL,
    fim timestamp(0) without time zone NOT NULL,
    agendavel_type character varying(255) NOT NULL,
    agendavel_id bigint NOT NULL,
    emergencia boolean DEFAULT false,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    prestador_servico_id bigint,
    status smallint,
    tipo character varying(15) NOT NULL,
    em_tratamento boolean DEFAULT false,
    motivo_cancelamento_id bigint,
    observacao_cancelamento character varying(150),
    servico_atendimento_id bigint,
    extraordinario boolean DEFAULT false NOT NULL,
    motivo_extraordinario character varying(100)
);


ALTER TABLE public.agendamentos_atendimentos OWNER TO sindserv;

--
-- Name: agendamentos_atendimentos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.agendamentos_atendimentos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.agendamentos_atendimentos_id_seq OWNER TO sindserv;

--
-- Name: agendamentos_atendimentos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.agendamentos_atendimentos_id_seq OWNED BY public.agendamentos_atendimentos.id;


--
-- Name: anamneses; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.anamneses (
    id bigint NOT NULL,
    agendavel_type character varying(255) NOT NULL,
    agendavel_id bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.anamneses OWNER TO sindserv;

--
-- Name: anamneses_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.anamneses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anamneses_id_seq OWNER TO sindserv;

--
-- Name: anamneses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.anamneses_id_seq OWNED BY public.anamneses.id;


--
-- Name: anexos_processos_juridicos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.anexos_processos_juridicos (
    id bigint NOT NULL,
    processo_juridico_id bigint NOT NULL,
    descricao character varying(50) NOT NULL,
    caminho character varying(150) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.anexos_processos_juridicos OWNER TO sindserv;

--
-- Name: anexos_processos_juridicos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.anexos_processos_juridicos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.anexos_processos_juridicos_id_seq OWNER TO sindserv;

--
-- Name: anexos_processos_juridicos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.anexos_processos_juridicos_id_seq OWNED BY public.anexos_processos_juridicos.id;


--
-- Name: atendimentos_juridicos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.atendimentos_juridicos (
    id bigint NOT NULL,
    agendamento_atendimento_id bigint,
    processo_juridico_id bigint,
    anotacoes text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.atendimentos_juridicos OWNER TO sindserv;

--
-- Name: atendimentos_juridicos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.atendimentos_juridicos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.atendimentos_juridicos_id_seq OWNER TO sindserv;

--
-- Name: atendimentos_juridicos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.atendimentos_juridicos_id_seq OWNED BY public.atendimentos_juridicos.id;


--
-- Name: atendimentos_odontologicos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.atendimentos_odontologicos (
    id bigint NOT NULL,
    agendamento_atendimento_id bigint,
    tratamento_executado text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    prestador_servico_id bigint
);


ALTER TABLE public.atendimentos_odontologicos OWNER TO sindserv;

--
-- Name: atendimentos_odontologicos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.atendimentos_odontologicos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.atendimentos_odontologicos_id_seq OWNER TO sindserv;

--
-- Name: atendimentos_odontologicos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.atendimentos_odontologicos_id_seq OWNED BY public.atendimentos_odontologicos.id;


--
-- Name: audits; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.audits (
    id bigint NOT NULL,
    user_type character varying(255),
    user_id bigint,
    event character varying(255) NOT NULL,
    auditable_type character varying(255) NOT NULL,
    auditable_id bigint NOT NULL,
    old_values text,
    new_values text,
    url text,
    ip_address inet,
    user_agent character varying(1023),
    tags character varying(255),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.audits OWNER TO sindserv;

--
-- Name: audits_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.audits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.audits_id_seq OWNER TO sindserv;

--
-- Name: audits_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.audits_id_seq OWNED BY public.audits.id;


--
-- Name: cargos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.cargos (
    id bigint NOT NULL,
    nome character varying(150) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    nivel_salarial_id smallint
);


ALTER TABLE public.cargos OWNER TO sindserv;

--
-- Name: cargos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.cargos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cargos_id_seq OWNER TO sindserv;

--
-- Name: cargos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.cargos_id_seq OWNED BY public.cargos.id;


--
-- Name: classificacoes_contas; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.classificacoes_contas (
    id bigint NOT NULL,
    nome character varying(100) NOT NULL,
    plano_contas_id bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.classificacoes_contas OWNER TO sindserv;

--
-- Name: classificacoes_contas_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.classificacoes_contas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.classificacoes_contas_id_seq OWNER TO sindserv;

--
-- Name: classificacoes_contas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.classificacoes_contas_id_seq OWNED BY public.classificacoes_contas.id;


--
-- Name: competencias_processos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.competencias_processos (
    id bigint NOT NULL,
    descricao character varying(50) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.competencias_processos OWNER TO sindserv;

--
-- Name: competencias_processos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.competencias_processos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.competencias_processos_id_seq OWNER TO sindserv;

--
-- Name: competencias_processos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.competencias_processos_id_seq OWNED BY public.competencias_processos.id;


--
-- Name: configuracoes; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.configuracoes (
    id bigint NOT NULL,
    categoria character varying(100) NOT NULL,
    nome character varying(100) NOT NULL,
    valor character varying(100) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.configuracoes OWNER TO sindserv;

--
-- Name: configuracoes_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.configuracoes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.configuracoes_id_seq OWNER TO sindserv;

--
-- Name: configuracoes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.configuracoes_id_seq OWNED BY public.configuracoes.id;


--
-- Name: contas_pagar_receber; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.contas_pagar_receber (
    id bigint NOT NULL,
    descricao character varying(255),
    valor numeric(8,2) NOT NULL,
    vencimento date NOT NULL,
    status smallint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    valor_pago numeric(8,2),
    data_pagamento date,
    numero_documento character varying(255),
    forma_pagamento smallint,
    recorrencia smallint,
    tipo_despesa smallint,
    tipo smallint,
    responsavel_despesa character varying(100),
    observacoes character varying(255),
    caminho_documento character varying(255),
    classificacao_conta_id bigint,
    forma_recebimento smallint,
    nota_fiscal character varying(100)
);


ALTER TABLE public.contas_pagar_receber OWNER TO sindserv;

--
-- Name: contas_a_pagar_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.contas_a_pagar_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contas_a_pagar_id_seq OWNER TO sindserv;

--
-- Name: contas_a_pagar_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.contas_a_pagar_id_seq OWNED BY public.contas_pagar_receber.id;


--
-- Name: contatos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.contatos (
    id bigint NOT NULL,
    contatavel_id integer NOT NULL,
    contatavel_type character varying(255) NOT NULL,
    tipo smallint NOT NULL,
    valor character varying(150) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    aceita_mala_direta boolean DEFAULT false NOT NULL,
    observacoes character varying(50)
);


ALTER TABLE public.contatos OWNER TO sindserv;

--
-- Name: contatos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.contatos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contatos_id_seq OWNER TO sindserv;

--
-- Name: contatos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.contatos_id_seq OWNED BY public.contatos.id;


--
-- Name: convenios; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.convenios (
    id bigint NOT NULL,
    nome character varying(50) NOT NULL,
    cpf character varying(11),
    cnpj character varying(14),
    validade date,
    desconto boolean NOT NULL,
    especialidade_id bigint NOT NULL,
    tipo smallint,
    observacoes text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    tipo_beneficiario smallint DEFAULT '1'::smallint NOT NULL
);


ALTER TABLE public.convenios OWNER TO sindserv;

--
-- Name: convenios_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.convenios_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.convenios_id_seq OWNER TO sindserv;

--
-- Name: convenios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.convenios_id_seq OWNED BY public.convenios.id;


--
-- Name: convenios_pessoas; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.convenios_pessoas (
    id bigint NOT NULL,
    conveniavel_type character varying(255) NOT NULL,
    conveniavel_id bigint NOT NULL,
    convenio_id bigint NOT NULL,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    motivo_exclusao smallint
);


ALTER TABLE public.convenios_pessoas OWNER TO sindserv;

--
-- Name: convenios_pessoas_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.convenios_pessoas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.convenios_pessoas_id_seq OWNER TO sindserv;

--
-- Name: convenios_pessoas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.convenios_pessoas_id_seq OWNED BY public.convenios_pessoas.id;


--
-- Name: dependentes; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.dependentes (
    id bigint NOT NULL,
    nome character varying(100) NOT NULL,
    data_nascimento date NOT NULL,
    grau_parentesco smallint NOT NULL,
    dependivel_id integer NOT NULL,
    dependivel_type character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    data_admissao date NOT NULL,
    sexo smallint NOT NULL,
    ativo boolean DEFAULT true NOT NULL,
    observacoes text,
    especial boolean DEFAULT false NOT NULL,
    falecido boolean DEFAULT false NOT NULL
);


ALTER TABLE public.dependentes OWNER TO sindserv;

--
-- Name: dependentes_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.dependentes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dependentes_id_seq OWNER TO sindserv;

--
-- Name: dependentes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.dependentes_id_seq OWNED BY public.dependentes.id;


--
-- Name: documentos_associados; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.documentos_associados (
    id bigint NOT NULL,
    tipo_documento_id bigint NOT NULL,
    servidor_id bigint NOT NULL,
    caminho character varying(255) NOT NULL,
    observacoes character varying(100),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.documentos_associados OWNER TO sindserv;

--
-- Name: documentos_associados_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.documentos_associados_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.documentos_associados_id_seq OWNER TO sindserv;

--
-- Name: documentos_associados_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.documentos_associados_id_seq OWNED BY public.documentos_associados.id;


--
-- Name: enderecos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.enderecos (
    id bigint NOT NULL,
    cep character varying(8) NOT NULL,
    numero integer DEFAULT 0 NOT NULL,
    logradouro character varying(150) NOT NULL,
    bairro character varying(50) NOT NULL,
    cidade character varying(100) NOT NULL,
    estado character varying(2) NOT NULL,
    observacoes character varying(100),
    enderecavel_id integer NOT NULL,
    enderecavel_type character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    aceita_mala_direta boolean DEFAULT false NOT NULL,
    complemento character varying(50)
);


ALTER TABLE public.enderecos OWNER TO sindserv;

--
-- Name: enderecos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.enderecos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.enderecos_id_seq OWNER TO sindserv;

--
-- Name: enderecos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.enderecos_id_seq OWNED BY public.enderecos.id;


--
-- Name: especialidades_convenios; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.especialidades_convenios (
    id bigint NOT NULL,
    nome character varying(50) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.especialidades_convenios OWNER TO sindserv;

--
-- Name: especialidades_convenios_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.especialidades_convenios_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.especialidades_convenios_id_seq OWNER TO sindserv;

--
-- Name: especialidades_convenios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.especialidades_convenios_id_seq OWNED BY public.especialidades_convenios.id;


--
-- Name: feriados; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.feriados (
    id bigint NOT NULL,
    titulo character varying(100) NOT NULL,
    data_inicio date NOT NULL,
    data_fim date NOT NULL,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.feriados OWNER TO sindserv;

--
-- Name: feriados_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.feriados_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.feriados_id_seq OWNER TO sindserv;

--
-- Name: feriados_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.feriados_id_seq OWNED BY public.feriados.id;


--
-- Name: funcionarios; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.funcionarios (
    id bigint NOT NULL,
    nome character varying(150) NOT NULL,
    funcao character varying(50) NOT NULL,
    cpf character varying(11) NOT NULL,
    rg character varying(10) NOT NULL,
    cnh character varying(10),
    data_nascimento date,
    sexo smallint NOT NULL,
    observacoes text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    user_id bigint
);


ALTER TABLE public.funcionarios OWNER TO sindserv;

--
-- Name: funcionarios_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.funcionarios_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.funcionarios_id_seq OWNER TO sindserv;

--
-- Name: funcionarios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.funcionarios_id_seq OWNED BY public.funcionarios.id;


--
-- Name: herdeiros; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.herdeiros (
    id bigint NOT NULL,
    nome character varying(150) NOT NULL,
    servidor_id bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.herdeiros OWNER TO sindserv;

--
-- Name: herdeiros_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.herdeiros_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.herdeiros_id_seq OWNER TO sindserv;

--
-- Name: herdeiros_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.herdeiros_id_seq OWNED BY public.herdeiros.id;


--
-- Name: horarios_trabalho; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.horarios_trabalho (
    id bigint NOT NULL,
    trabalhavel_id bigint NOT NULL,
    trabalhavel_type character varying(255) NOT NULL,
    dia_semana character varying(7) NOT NULL,
    inicio time(0) without time zone NOT NULL,
    fim time(0) without time zone NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.horarios_trabalho OWNER TO sindserv;

--
-- Name: horarios_trabalho_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.horarios_trabalho_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.horarios_trabalho_id_seq OWNER TO sindserv;

--
-- Name: horarios_trabalho_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.horarios_trabalho_id_seq OWNED BY public.horarios_trabalho.id;


--
-- Name: jobs; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.jobs (
    id bigint NOT NULL,
    queue character varying(255) NOT NULL,
    payload text NOT NULL,
    attempts smallint NOT NULL,
    reserved_at integer,
    available_at integer NOT NULL,
    created_at integer NOT NULL
);


ALTER TABLE public.jobs OWNER TO sindserv;

--
-- Name: jobs_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.jobs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.jobs_id_seq OWNER TO sindserv;

--
-- Name: jobs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.jobs_id_seq OWNED BY public.jobs.id;


--
-- Name: log_bairro; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_bairro (
    bai_nu_sequencial integer DEFAULT 0 NOT NULL,
    ufe_sg character varying(2) NOT NULL,
    loc_nu_sequencial integer DEFAULT 0 NOT NULL,
    bai_no character varying(72) NOT NULL,
    bai_no_abrev character varying(36)
);


ALTER TABLE public.log_bairro OWNER TO sindserv;

--
-- Name: log_controle; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_controle (
    versao character varying(4),
    data timestamp without time zone,
    compl1 character varying(50)
);


ALTER TABLE public.log_controle OWNER TO sindserv;

--
-- Name: log_cpc; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_cpc (
    cpc_nu_sequencial integer DEFAULT 0 NOT NULL,
    ufe_sg character varying(2) NOT NULL,
    loc_nu_sequencial integer DEFAULT 0 NOT NULL,
    cep character varying(16) NOT NULL,
    cpc_no character varying(96) NOT NULL,
    cpc_endereco character varying(108) NOT NULL,
    cpc_tipo character varying(2),
    cpc_abrangencia character varying(80),
    temp character varying(8)
);


ALTER TABLE public.log_cpc OWNER TO sindserv;

--
-- Name: log_faixa_bairro; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_faixa_bairro (
    bai_nu_sequencial integer NOT NULL,
    fcb_nu_ordem integer NOT NULL,
    fcb_rad_ini character varying(5) NOT NULL,
    fcb_suf_ini character varying(3) NOT NULL,
    fcb_rad_fim character varying(5) NOT NULL,
    fcb_suf_fim character varying(3) NOT NULL
);


ALTER TABLE public.log_faixa_bairro OWNER TO sindserv;

--
-- Name: log_faixa_cpc; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_faixa_cpc (
    cpc_nu_sequencial integer DEFAULT 0 NOT NULL,
    cpc_nu_inicial integer DEFAULT 0 NOT NULL,
    cpc_nu_final integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.log_faixa_cpc OWNER TO sindserv;

--
-- Name: log_faixa_localidade; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_faixa_localidade (
    loc_nu_sequencial integer DEFAULT 0 NOT NULL,
    loc_rad1_ini character varying(5) NOT NULL,
    loc_suf1_ini character varying(3) NOT NULL,
    loc_rad1_fim character varying(5) NOT NULL,
    loc_suf1_fim character varying(3) NOT NULL,
    loc_rad2_ini character varying(5),
    loc_suf2_ini character varying(3),
    loc_rad2_fim character varying(5),
    loc_suf2_fim character varying(3)
);


ALTER TABLE public.log_faixa_localidade OWNER TO sindserv;

--
-- Name: log_faixa_uf; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_faixa_uf (
    ufe_sg character varying(2) NOT NULL,
    ufe_no character varying(72) NOT NULL,
    ufe_rad1_ini character varying(5) NOT NULL,
    ufe_suf1_ini character varying(3) NOT NULL,
    ufe_rad1_fim character varying(5) NOT NULL,
    ufe_suf1_fim character varying(3) NOT NULL,
    ufe_rad2_ini character varying(5),
    ufe_suf2_ini character varying(3),
    ufe_rad2_fim character varying(5),
    ufe_suf2_fim character varying(3)
);


ALTER TABLE public.log_faixa_uf OWNER TO sindserv;

--
-- Name: log_faixa_uop; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_faixa_uop (
    uop_nu_sequencial integer DEFAULT 0 NOT NULL,
    fnc_nu_inicial integer DEFAULT 0 NOT NULL,
    fnc_nu_final integer,
    fnc_in_tipo character varying(255)
);


ALTER TABLE public.log_faixa_uop OWNER TO sindserv;

--
-- Name: log_grande_usuario; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_grande_usuario (
    gru_nu_sequencial integer DEFAULT 0 NOT NULL,
    ufe_sg character varying(2) NOT NULL,
    loc_nu_sequencial integer DEFAULT 0 NOT NULL,
    log_nu_sequencial integer DEFAULT 0,
    bai_nu_sequencial integer DEFAULT 0 NOT NULL,
    gru_no character varying(96) NOT NULL,
    cep character varying(16) NOT NULL,
    gru_endereco character varying(200) NOT NULL,
    temp character varying(8)
);


ALTER TABLE public.log_grande_usuario OWNER TO sindserv;

--
-- Name: log_localidade; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_localidade (
    loc_nu_sequencial integer DEFAULT 0 NOT NULL,
    loc_nosub character varying(50),
    loc_no character varying(60),
    cep character varying(16),
    ufe_sg character varying(2),
    loc_in_situacao integer DEFAULT 0,
    loc_in_tipo_localidade character varying(1) NOT NULL,
    loc_nu_sequencial_sub integer DEFAULT 0,
    temp character varying(8)
);


ALTER TABLE public.log_localidade OWNER TO sindserv;

--
-- Name: log_logradouro; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_logradouro (
    log_nu_sequencial integer DEFAULT 0 NOT NULL,
    ufe_sg character varying(2) NOT NULL,
    loc_nu_sequencial integer DEFAULT 0 NOT NULL,
    log_no character varying(70) NOT NULL,
    log_nome character varying(125) NOT NULL,
    bai_nu_sequencial_ini integer DEFAULT 0 NOT NULL,
    bai_nu_sequencial_fim integer DEFAULT 0,
    cep character varying(16) NOT NULL,
    log_complemento character varying(100),
    log_tipo_logradouro character varying(72),
    log_status_tipo_log character varying(1) NOT NULL,
    log_no_sem_acento character varying(70) NOT NULL,
    ind_uop character varying(1),
    ind_gru character varying(1),
    temp character varying(8)
);


ALTER TABLE public.log_logradouro OWNER TO sindserv;

--
-- Name: log_tipo_logr; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_tipo_logr (
    tipologradouro character varying(10)
);


ALTER TABLE public.log_tipo_logr OWNER TO sindserv;

--
-- Name: log_unid_oper; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.log_unid_oper (
    uop_nu_sequencial integer DEFAULT 0 NOT NULL,
    ufe_sg character varying(2) NOT NULL,
    loc_nu_sequencial integer DEFAULT 0 NOT NULL,
    log_nu_sequencial integer DEFAULT 0,
    bai_nu_sequencial integer DEFAULT 0 NOT NULL,
    uop_no character varying(100) NOT NULL,
    cep character varying(16) NOT NULL,
    uop_endereco character varying(200) NOT NULL,
    uop_in_cp character varying(1),
    temp character varying(8)
);


ALTER TABLE public.log_unid_oper OWNER TO sindserv;

--
-- Name: malas_diretas; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.malas_diretas (
    id bigint NOT NULL,
    mensagem character varying(150) NOT NULL,
    qtde_contatos integer NOT NULL,
    filtro_servidor smallint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.malas_diretas OWNER TO sindserv;

--
-- Name: malas_diretas_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.malas_diretas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.malas_diretas_id_seq OWNER TO sindserv;

--
-- Name: malas_diretas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.malas_diretas_id_seq OWNED BY public.malas_diretas.id;


--
-- Name: matriculas; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.matriculas (
    id bigint NOT NULL,
    servidor_id bigint NOT NULL,
    data_filiacao date NOT NULL,
    data_desligamento date,
    tipo_desligamento smallint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    motivo_religamento_extraordinario character varying(150),
    data_religamento_extraordinario date,
    religamento_extraordinario boolean DEFAULT false NOT NULL,
    motivo_filiacao_id bigint DEFAULT '1'::bigint NOT NULL,
    motivo_filiacao_outros character varying(100),
    motivo_desligamento bigint,
    data_publicacao_portaria date,
    mes_ano_parou_desconto character varying(7)
);


ALTER TABLE public.matriculas OWNER TO sindserv;

--
-- Name: matriculas_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.matriculas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.matriculas_id_seq OWNER TO sindserv;

--
-- Name: matriculas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.matriculas_id_seq OWNED BY public.matriculas.id;


--
-- Name: mensalidades_niveis; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.mensalidades_niveis (
    id bigint NOT NULL,
    nivel_salarial_id smallint NOT NULL,
    valor numeric(8,2) NOT NULL,
    inicio_vigencia date NOT NULL,
    termino_vigencia date,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.mensalidades_niveis OWNER TO sindserv;

--
-- Name: mensalidades_niveis_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.mensalidades_niveis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mensalidades_niveis_id_seq OWNER TO sindserv;

--
-- Name: mensalidades_niveis_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.mensalidades_niveis_id_seq OWNED BY public.mensalidades_niveis.id;


--
-- Name: migrations; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.migrations (
    id integer NOT NULL,
    migration character varying(255) NOT NULL,
    batch integer NOT NULL
);


ALTER TABLE public.migrations OWNER TO sindserv;

--
-- Name: migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.migrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.migrations_id_seq OWNER TO sindserv;

--
-- Name: migrations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.migrations_id_seq OWNED BY public.migrations.id;


--
-- Name: model_has_permissions; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.model_has_permissions (
    permission_id bigint NOT NULL,
    model_type character varying(255) NOT NULL,
    model_id bigint NOT NULL
);


ALTER TABLE public.model_has_permissions OWNER TO sindserv;

--
-- Name: model_has_roles; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.model_has_roles (
    role_id bigint NOT NULL,
    model_type character varying(255) NOT NULL,
    model_id bigint NOT NULL
);


ALTER TABLE public.model_has_roles OWNER TO sindserv;

--
-- Name: motivos_cancelamentos_agendamentos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.motivos_cancelamentos_agendamentos (
    id bigint NOT NULL,
    descricao character varying(150) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.motivos_cancelamentos_agendamentos OWNER TO sindserv;

--
-- Name: motivos_cancelamentos_agendamentos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.motivos_cancelamentos_agendamentos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.motivos_cancelamentos_agendamentos_id_seq OWNER TO sindserv;

--
-- Name: motivos_cancelamentos_agendamentos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.motivos_cancelamentos_agendamentos_id_seq OWNED BY public.motivos_cancelamentos_agendamentos.id;


--
-- Name: motivos_filiacao; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.motivos_filiacao (
    id bigint NOT NULL,
    descricao character varying(100) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.motivos_filiacao OWNER TO sindserv;

--
-- Name: motivos_filiacao_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.motivos_filiacao_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.motivos_filiacao_id_seq OWNER TO sindserv;

--
-- Name: motivos_filiacao_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.motivos_filiacao_id_seq OWNED BY public.motivos_filiacao.id;


--
-- Name: motivos_registro_atendimento; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.motivos_registro_atendimento (
    id smallint NOT NULL,
    descricao character varying(100) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.motivos_registro_atendimento OWNER TO sindserv;

--
-- Name: motivos_registro_atendimento_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.motivos_registro_atendimento_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.motivos_registro_atendimento_id_seq OWNER TO sindserv;

--
-- Name: motivos_registro_atendimento_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.motivos_registro_atendimento_id_seq OWNED BY public.motivos_registro_atendimento.id;


--
-- Name: movimentacoes_servidores; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.movimentacoes_servidores (
    id bigint NOT NULL,
    servidor_id bigint NOT NULL,
    registro_id bigint,
    descricao character varying(255) NOT NULL,
    payload json,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    evento smallint NOT NULL,
    user_id bigint
);


ALTER TABLE public.movimentacoes_servidores OWNER TO sindserv;

--
-- Name: movimentacoes_servidores_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.movimentacoes_servidores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.movimentacoes_servidores_id_seq OWNER TO sindserv;

--
-- Name: movimentacoes_servidores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.movimentacoes_servidores_id_seq OWNED BY public.movimentacoes_servidores.id;


--
-- Name: niveis_salariais; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.niveis_salariais (
    id smallint NOT NULL,
    nome character varying(50) NOT NULL,
    salario_base numeric(8,2),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.niveis_salariais OWNER TO sindserv;

--
-- Name: niveis_salariais_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.niveis_salariais_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.niveis_salariais_id_seq OWNER TO sindserv;

--
-- Name: niveis_salariais_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.niveis_salariais_id_seq OWNED BY public.niveis_salariais.id;


--
-- Name: password_resets; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.password_resets (
    email character varying(255) NOT NULL,
    token character varying(255) NOT NULL,
    created_at timestamp(0) without time zone
);


ALTER TABLE public.password_resets OWNER TO sindserv;

--
-- Name: perguntas_anamnese; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.perguntas_anamnese (
    id bigint NOT NULL,
    descricao character varying(150) NOT NULL,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.perguntas_anamnese OWNER TO sindserv;

--
-- Name: perguntas_anamnese_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.perguntas_anamnese_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.perguntas_anamnese_id_seq OWNER TO sindserv;

--
-- Name: perguntas_anamnese_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.perguntas_anamnese_id_seq OWNED BY public.perguntas_anamnese.id;


--
-- Name: permissions; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.permissions (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    guard_name character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.permissions OWNER TO sindserv;

--
-- Name: permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permissions_id_seq OWNER TO sindserv;

--
-- Name: permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.permissions_id_seq OWNED BY public.permissions.id;


--
-- Name: planos_contas; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.planos_contas (
    id bigint NOT NULL,
    nome character varying(100) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.planos_contas OWNER TO sindserv;

--
-- Name: planos_contas_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.planos_contas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.planos_contas_id_seq OWNER TO sindserv;

--
-- Name: planos_contas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.planos_contas_id_seq OWNED BY public.planos_contas.id;


--
-- Name: prestadores_servicos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.prestadores_servicos (
    id bigint NOT NULL,
    nome character varying(150) NOT NULL,
    funcao character varying(50),
    cpf character varying(11),
    rg character varying(10),
    cnpj character varying(14),
    sexo smallint,
    observacoes text,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    tipo smallint,
    user_id bigint,
    especialidade smallint
);


ALTER TABLE public.prestadores_servicos OWNER TO sindserv;

--
-- Name: prestadores_servicos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.prestadores_servicos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.prestadores_servicos_id_seq OWNER TO sindserv;

--
-- Name: prestadores_servicos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.prestadores_servicos_id_seq OWNED BY public.prestadores_servicos.id;


--
-- Name: processos_juridicos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.processos_juridicos (
    id bigint NOT NULL,
    numero character varying(30) NOT NULL,
    vara character varying(10),
    agendavel_id bigint NOT NULL,
    agendavel_type character varying(255) NOT NULL,
    competencia_id bigint NOT NULL,
    tipo_acao_id bigint NOT NULL,
    extinto boolean NOT NULL,
    resultado smallint,
    anotacoes text,
    data_pagamento date,
    pago boolean NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    valor_pago numeric(10,2)
);


ALTER TABLE public.processos_juridicos OWNER TO sindserv;

--
-- Name: processos_juridicos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.processos_juridicos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.processos_juridicos_id_seq OWNER TO sindserv;

--
-- Name: processos_juridicos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.processos_juridicos_id_seq OWNED BY public.processos_juridicos.id;


--
-- Name: registros_atendimentos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.registros_atendimentos (
    id bigint NOT NULL,
    atendimento text NOT NULL,
    user_id bigint NOT NULL,
    servidor_id bigint NOT NULL,
    resolvido boolean NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    motivo_id smallint
);


ALTER TABLE public.registros_atendimentos OWNER TO sindserv;

--
-- Name: registros_atendimentos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.registros_atendimentos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.registros_atendimentos_id_seq OWNER TO sindserv;

--
-- Name: registros_atendimentos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.registros_atendimentos_id_seq OWNED BY public.registros_atendimentos.id;


--
-- Name: registros_servidores; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.registros_servidores (
    id bigint NOT NULL,
    numero character varying(6) NOT NULL,
    data_admissao date,
    cargo_id integer,
    readaptado boolean,
    cargoreadaptado_id bigint,
    unidadeorganizacional_id integer,
    servidor_id bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    data_desligamento date,
    regime smallint DEFAULT '1'::smallint NOT NULL,
    data_aposentadoria date,
    paridade boolean,
    proventos smallint,
    tipo_aposentadoria smallint,
    portaria_aposentadoria character varying(20),
    nivel_salarial_id smallint
);


ALTER TABLE public.registros_servidores OWNER TO sindserv;

--
-- Name: registros_servidores_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.registros_servidores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.registros_servidores_id_seq OWNER TO sindserv;

--
-- Name: registros_servidores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.registros_servidores_id_seq OWNED BY public.registros_servidores.id;


--
-- Name: respostas_anamnese; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.respostas_anamnese (
    id bigint NOT NULL,
    pergunta_anamnese_id bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    resposta boolean DEFAULT false NOT NULL,
    qual character varying(255),
    anamnese_id bigint
);


ALTER TABLE public.respostas_anamnese OWNER TO sindserv;

--
-- Name: respostas_anamnese_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.respostas_anamnese_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.respostas_anamnese_id_seq OWNER TO sindserv;

--
-- Name: respostas_anamnese_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.respostas_anamnese_id_seq OWNED BY public.respostas_anamnese.id;


--
-- Name: role_has_permissions; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.role_has_permissions (
    permission_id bigint NOT NULL,
    role_id bigint NOT NULL
);


ALTER TABLE public.role_has_permissions OWNER TO sindserv;

--
-- Name: roles; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.roles (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    guard_name character varying(255) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.roles OWNER TO sindserv;

--
-- Name: roles_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.roles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roles_id_seq OWNER TO sindserv;

--
-- Name: roles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.roles_id_seq OWNED BY public.roles.id;


--
-- Name: servicos_atendimento; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.servicos_atendimento (
    id bigint NOT NULL,
    descricao character varying(50) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.servicos_atendimento OWNER TO sindserv;

--
-- Name: servicos_atendimento_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.servicos_atendimento_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.servicos_atendimento_id_seq OWNER TO sindserv;

--
-- Name: servicos_atendimento_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.servicos_atendimento_id_seq OWNED BY public.servicos_atendimento.id;


--
-- Name: servidores; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.servidores (
    id bigint NOT NULL,
    nome character varying(150) NOT NULL,
    nome_social character varying(150),
    cpf character varying(11),
    rg character varying(15),
    data_nascimento date,
    nome_mae character varying(150),
    nome_pai character varying(150),
    naturalidade character varying(150),
    observacoes character varying(150),
    estado_civil smallint,
    sexo smallint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    nacionalidade character varying(150),
    nao_perturbe boolean DEFAULT false NOT NULL,
    deleted_at timestamp(0) without time zone,
    imagem character varying(100),
    naturalidade_uf character varying(2),
    nivel_ensino smallint,
    falecido boolean DEFAULT false NOT NULL,
    data_falecimento date,
    observacao_falecimento character varying(255)
);


ALTER TABLE public.servidores OWNER TO sindserv;

--
-- Name: servidores_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.servidores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.servidores_id_seq OWNER TO sindserv;

--
-- Name: servidores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.servidores_id_seq OWNED BY public.servidores.id;


--
-- Name: tipos_acoes_processos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.tipos_acoes_processos (
    id bigint NOT NULL,
    descricao character varying(50) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.tipos_acoes_processos OWNER TO sindserv;

--
-- Name: tipos_acoes_processos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.tipos_acoes_processos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tipos_acoes_processos_id_seq OWNER TO sindserv;

--
-- Name: tipos_acoes_processos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.tipos_acoes_processos_id_seq OWNED BY public.tipos_acoes_processos.id;


--
-- Name: tipos_documentos; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.tipos_documentos (
    id bigint NOT NULL,
    nome character varying(30) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.tipos_documentos OWNER TO sindserv;

--
-- Name: tipos_documentos_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.tipos_documentos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tipos_documentos_id_seq OWNER TO sindserv;

--
-- Name: tipos_documentos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.tipos_documentos_id_seq OWNED BY public.tipos_documentos.id;


--
-- Name: unidades_organizacionais; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.unidades_organizacionais (
    id bigint NOT NULL,
    nome character varying(100) NOT NULL,
    sigla character varying(15),
    centro_custo character varying(11),
    observacoes character varying(100),
    superior_id bigint,
    deleted_at timestamp(0) without time zone,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    nivel smallint,
    hierarquia character varying(255)
);


ALTER TABLE public.unidades_organizacionais OWNER TO sindserv;

--
-- Name: unidades_organizacionais_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.unidades_organizacionais_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.unidades_organizacionais_id_seq OWNER TO sindserv;

--
-- Name: unidades_organizacionais_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.unidades_organizacionais_id_seq OWNED BY public.unidades_organizacionais.id;


--
-- Name: users; Type: TABLE; Schema: public; Owner: sindserv
--

CREATE TABLE public.users (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    email character varying(255) NOT NULL,
    email_verified_at timestamp(0) without time zone,
    password character varying(255) NOT NULL,
    remember_token character varying(100),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone
);


ALTER TABLE public.users OWNER TO sindserv;

--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: sindserv
--

CREATE SEQUENCE public.users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_id_seq OWNER TO sindserv;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sindserv
--

ALTER SEQUENCE public.users_id_seq OWNED BY public.users.id;


--
-- Name: agendamentos_atendimentos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.agendamentos_atendimentos ALTER COLUMN id SET DEFAULT nextval('public.agendamentos_atendimentos_id_seq'::regclass);


--
-- Name: anamneses id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.anamneses ALTER COLUMN id SET DEFAULT nextval('public.anamneses_id_seq'::regclass);


--
-- Name: anexos_processos_juridicos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.anexos_processos_juridicos ALTER COLUMN id SET DEFAULT nextval('public.anexos_processos_juridicos_id_seq'::regclass);


--
-- Name: atendimentos_juridicos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.atendimentos_juridicos ALTER COLUMN id SET DEFAULT nextval('public.atendimentos_juridicos_id_seq'::regclass);


--
-- Name: atendimentos_odontologicos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.atendimentos_odontologicos ALTER COLUMN id SET DEFAULT nextval('public.atendimentos_odontologicos_id_seq'::regclass);


--
-- Name: audits id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.audits ALTER COLUMN id SET DEFAULT nextval('public.audits_id_seq'::regclass);


--
-- Name: cargos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.cargos ALTER COLUMN id SET DEFAULT nextval('public.cargos_id_seq'::regclass);


--
-- Name: classificacoes_contas id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.classificacoes_contas ALTER COLUMN id SET DEFAULT nextval('public.classificacoes_contas_id_seq'::regclass);


--
-- Name: competencias_processos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.competencias_processos ALTER COLUMN id SET DEFAULT nextval('public.competencias_processos_id_seq'::regclass);


--
-- Name: configuracoes id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.configuracoes ALTER COLUMN id SET DEFAULT nextval('public.configuracoes_id_seq'::regclass);


--
-- Name: contas_pagar_receber id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.contas_pagar_receber ALTER COLUMN id SET DEFAULT nextval('public.contas_a_pagar_id_seq'::regclass);


--
-- Name: contatos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.contatos ALTER COLUMN id SET DEFAULT nextval('public.contatos_id_seq'::regclass);


--
-- Name: convenios id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.convenios ALTER COLUMN id SET DEFAULT nextval('public.convenios_id_seq'::regclass);


--
-- Name: convenios_pessoas id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.convenios_pessoas ALTER COLUMN id SET DEFAULT nextval('public.convenios_pessoas_id_seq'::regclass);


--
-- Name: dependentes id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.dependentes ALTER COLUMN id SET DEFAULT nextval('public.dependentes_id_seq'::regclass);


--
-- Name: documentos_associados id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.documentos_associados ALTER COLUMN id SET DEFAULT nextval('public.documentos_associados_id_seq'::regclass);


--
-- Name: enderecos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.enderecos ALTER COLUMN id SET DEFAULT nextval('public.enderecos_id_seq'::regclass);


--
-- Name: especialidades_convenios id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.especialidades_convenios ALTER COLUMN id SET DEFAULT nextval('public.especialidades_convenios_id_seq'::regclass);


--
-- Name: feriados id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.feriados ALTER COLUMN id SET DEFAULT nextval('public.feriados_id_seq'::regclass);


--
-- Name: funcionarios id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.funcionarios ALTER COLUMN id SET DEFAULT nextval('public.funcionarios_id_seq'::regclass);


--
-- Name: herdeiros id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.herdeiros ALTER COLUMN id SET DEFAULT nextval('public.herdeiros_id_seq'::regclass);


--
-- Name: horarios_trabalho id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.horarios_trabalho ALTER COLUMN id SET DEFAULT nextval('public.horarios_trabalho_id_seq'::regclass);


--
-- Name: jobs id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.jobs ALTER COLUMN id SET DEFAULT nextval('public.jobs_id_seq'::regclass);


--
-- Name: malas_diretas id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.malas_diretas ALTER COLUMN id SET DEFAULT nextval('public.malas_diretas_id_seq'::regclass);


--
-- Name: matriculas id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.matriculas ALTER COLUMN id SET DEFAULT nextval('public.matriculas_id_seq'::regclass);


--
-- Name: mensalidades_niveis id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.mensalidades_niveis ALTER COLUMN id SET DEFAULT nextval('public.mensalidades_niveis_id_seq'::regclass);


--
-- Name: migrations id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.migrations ALTER COLUMN id SET DEFAULT nextval('public.migrations_id_seq'::regclass);


--
-- Name: motivos_cancelamentos_agendamentos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.motivos_cancelamentos_agendamentos ALTER COLUMN id SET DEFAULT nextval('public.motivos_cancelamentos_agendamentos_id_seq'::regclass);


--
-- Name: motivos_filiacao id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.motivos_filiacao ALTER COLUMN id SET DEFAULT nextval('public.motivos_filiacao_id_seq'::regclass);


--
-- Name: motivos_registro_atendimento id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.motivos_registro_atendimento ALTER COLUMN id SET DEFAULT nextval('public.motivos_registro_atendimento_id_seq'::regclass);


--
-- Name: movimentacoes_servidores id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.movimentacoes_servidores ALTER COLUMN id SET DEFAULT nextval('public.movimentacoes_servidores_id_seq'::regclass);


--
-- Name: niveis_salariais id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.niveis_salariais ALTER COLUMN id SET DEFAULT nextval('public.niveis_salariais_id_seq'::regclass);


--
-- Name: perguntas_anamnese id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.perguntas_anamnese ALTER COLUMN id SET DEFAULT nextval('public.perguntas_anamnese_id_seq'::regclass);


--
-- Name: permissions id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.permissions ALTER COLUMN id SET DEFAULT nextval('public.permissions_id_seq'::regclass);


--
-- Name: planos_contas id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.planos_contas ALTER COLUMN id SET DEFAULT nextval('public.planos_contas_id_seq'::regclass);


--
-- Name: prestadores_servicos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.prestadores_servicos ALTER COLUMN id SET DEFAULT nextval('public.prestadores_servicos_id_seq'::regclass);


--
-- Name: processos_juridicos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.processos_juridicos ALTER COLUMN id SET DEFAULT nextval('public.processos_juridicos_id_seq'::regclass);


--
-- Name: registros_atendimentos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.registros_atendimentos ALTER COLUMN id SET DEFAULT nextval('public.registros_atendimentos_id_seq'::regclass);


--
-- Name: registros_servidores id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.registros_servidores ALTER COLUMN id SET DEFAULT nextval('public.registros_servidores_id_seq'::regclass);


--
-- Name: respostas_anamnese id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.respostas_anamnese ALTER COLUMN id SET DEFAULT nextval('public.respostas_anamnese_id_seq'::regclass);


--
-- Name: roles id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.roles ALTER COLUMN id SET DEFAULT nextval('public.roles_id_seq'::regclass);


--
-- Name: servicos_atendimento id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.servicos_atendimento ALTER COLUMN id SET DEFAULT nextval('public.servicos_atendimento_id_seq'::regclass);


--
-- Name: servidores id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.servidores ALTER COLUMN id SET DEFAULT nextval('public.servidores_id_seq'::regclass);


--
-- Name: tipos_acoes_processos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.tipos_acoes_processos ALTER COLUMN id SET DEFAULT nextval('public.tipos_acoes_processos_id_seq'::regclass);


--
-- Name: tipos_documentos id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.tipos_documentos ALTER COLUMN id SET DEFAULT nextval('public.tipos_documentos_id_seq'::regclass);


--
-- Name: unidades_organizacionais id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.unidades_organizacionais ALTER COLUMN id SET DEFAULT nextval('public.unidades_organizacionais_id_seq'::regclass);


--
-- Name: users id; Type: DEFAULT; Schema: public; Owner: sindserv
--

ALTER TABLE ONLY public.users ALTER COLUMN id SET DEFAULT nextval('public.users_id_seq'::regclass);


--
-- Data for Name: agendamentos_atendimentos; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.agendamentos_atendimentos (id, inicio, fim, agendavel_type, agendavel_id, emergencia, created_at, updated_at, prestador_servico_id, status, tipo, em_tratamento, motivo_cancelamento_id, observacao_cancelamento, servico_atendimento_id, extraordinario, motivo_extraordinario) FROM stdin;
1	2022-02-18 09:00:00	2022-02-18 10:00:00	App\\Models\\Servidor	1	f	2022-02-15 16:46:31	2022-02-15 16:46:31	3	4	odontologico	f	\N	\N	\N	f	\N
2	2022-02-17 16:00:00	2022-02-17 16:30:00	App\\Models\\Servidor	3	f	2022-02-17 15:35:10	2022-02-17 15:37:01	4	1	odontologico	f	\N	\N	\N	f	\N
3	2022-02-17 16:30:00	2022-02-17 17:00:00	App\\Models\\Servidor	9	f	2022-02-17 15:42:25	2022-02-17 15:45:55	4	1	odontologico	f	\N	\N	\N	f	\N
4	2022-02-17 17:00:00	2022-02-17 17:30:00	App\\Models\\Servidor	6	f	2022-02-17 15:50:29	2022-02-17 15:50:29	4	4	odontologico	f	\N	\N	\N	f	\N
5	2022-03-03 11:00:00	2022-03-03 11:30:00	App\\Models\\Servidor	9	f	2022-03-03 10:52:18	2022-03-03 10:52:47	\N	5	juridico	f	\N	\N	1	f	\N
6	2022-03-04 10:00:00	2022-03-04 10:30:00	App\\Models\\Servidor	4	f	2022-03-04 09:14:00	2022-03-04 09:14:00	\N	4	juridico	f	\N	\N	1	f	\N
7	2022-03-07 11:00:00	2022-03-07 11:30:00	App\\Models\\Servidor	2	f	2022-03-07 10:46:44	2022-03-07 10:47:12	\N	5	juridico	f	\N	\N	1	f	\N
8	2022-03-07 11:00:00	2022-03-07 11:30:00	App\\Models\\Servidor	2	f	2022-03-07 10:48:28	2022-03-07 10:48:55	2	5	odontologico	f	\N	\N	\N	f	\N
9	2022-06-13 10:00:00	2022-06-13 10:30:00	App\\Models\\Servidor	2	f	2022-03-15 17:21:11	2022-03-15 17:21:11	\N	4	juridico	f	\N	\N	1	f	\N
10	2022-06-02 10:00:00	2022-06-02 10:30:00	App\\Models\\Servidor	4	f	2022-03-15 17:22:47	2022-03-15 17:22:47	\N	4	juridico	f	\N	\N	1	f	\N
12	2022-03-24 10:00:00	2022-03-24 10:30:00	App\\Models\\Servidor	23	f	2022-03-24 09:28:25	2022-03-24 09:28:58	\N	5	juridico	f	\N	\N	1	f	\N
13	2022-03-24 15:00:00	2022-03-24 15:30:00	App\\Models\\Servidor	3	f	2022-03-24 09:53:45	2022-03-24 09:53:45	4	4	odontologico	f	\N	\N	\N	f	\N
14	2022-03-24 15:30:00	2022-03-24 16:00:00	App\\Models\\Servidor	1	f	2022-03-24 09:56:04	2022-03-24 09:56:04	4	4	odontologico	f	\N	\N	\N	f	\N
15	2022-03-25 08:00:00	2022-03-25 08:30:00	App\\Models\\Servidor	3	f	2022-03-24 09:56:45	2022-03-24 09:56:45	3	4	odontologico	f	\N	\N	\N	f	\N
16	2022-03-24 14:00:00	2022-03-24 14:30:00	App\\Models\\Dependente	1	t	2022-03-24 09:59:02	2022-03-24 09:59:02	4	4	odontologico	f	\N	\N	\N	f	\N
17	2022-03-24 16:00:00	2022-03-24 16:30:00	App\\Models\\Funcionario	2	f	2022-03-24 10:00:40	2022-03-24 10:00:40	4	4	odontologico	f	\N	\N	\N	f	\N
18	2022-03-28 09:00:00	2022-03-28 09:30:00	App\\Models\\Dependente	8	f	2022-03-24 10:01:57	2022-03-24 10:01:57	2	4	odontologico	t	\N	\N	\N	f	\N
19	2022-03-29 10:00:00	2022-03-29 10:30:00	App\\Models\\Funcionario	2	f	2022-03-24 10:03:01	2022-03-24 10:03:01	1	4	odontologico	f	\N	\N	\N	f	\N
20	2022-03-30 10:30:00	2022-03-30 11:00:00	App\\Models\\Servidor	31	f	2022-03-25 10:25:10	2022-03-25 13:53:16	\N	5	juridico	f	\N	\N	1	f	\N
21	2022-04-05 08:00:00	2022-04-05 08:30:00	App\\Models\\Servidor	5	f	2022-03-29 20:06:23	2022-03-29 20:06:23	1	4	odontologico	f	\N	\N	\N	f	\N
11	2022-04-11 10:00:00	2022-04-11 10:30:00	App\\Models\\Servidor	9	f	2022-03-15 17:25:16	2022-04-11 11:16:38	\N	5	juridico	f	\N	\N	1	f	\N
22	2022-04-19 15:00:00	2022-04-19 15:30:00	App\\Models\\Servidor	27	f	2022-04-19 14:52:06	2022-04-19 14:52:34	\N	5	juridico	f	\N	\N	1	f	\N
23	2022-04-27 15:00:00	2022-04-27 15:30:00	App\\Models\\Servidor	34	f	2022-04-27 14:39:37	2022-04-27 14:40:05	\N	5	juridico	f	\N	\N	1	f	\N
24	2022-05-05 10:30:00	2022-05-05 11:00:00	App\\Models\\Servidor	4	f	2022-05-05 10:07:36	2022-05-05 10:07:36	\N	4	juridico	f	\N	\N	1	f	\N
26	2022-05-06 11:00:00	2022-05-06 11:30:00	App\\Models\\Servidor	4	f	2022-05-05 10:12:24	2022-05-05 10:12:24	\N	4	juridico	f	\N	\N	1	f	PROCESSO NOVO
25	2022-05-05 11:00:00	2022-05-05 11:30:00	App\\Models\\Servidor	4	f	2022-05-05 10:10:29	2022-05-05 10:12:53	\N	5	juridico	f	\N	\N	1	f	\N
27	2022-05-24 11:30:00	2022-05-24 12:00:00	App\\Models\\Servidor	37	f	2022-05-24 11:13:04	2022-05-24 11:13:42	\N	5	juridico	f	\N	\N	1	f	\N
\.


--
-- Data for Name: anamneses; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.anamneses (id, agendavel_type, agendavel_id, created_at, updated_at) FROM stdin;
1	App\\Models\\Servidor	3	2022-02-17 15:36:24	2022-02-17 15:36:24
2	App\\Models\\Servidor	9	2022-02-17 15:45:23	2022-02-17 15:45:23
\.


--
-- Data for Name: anexos_processos_juridicos; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.anexos_processos_juridicos (id, processo_juridico_id, descricao, caminho, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: atendimentos_juridicos; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.atendimentos_juridicos (id, agendamento_atendimento_id, processo_juridico_id, anotacoes, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: atendimentos_odontologicos; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.atendimentos_odontologicos (id, agendamento_atendimento_id, tratamento_executado, created_at, updated_at, prestador_servico_id) FROM stdin;
1	2	RC DENTE 14	2022-02-17 15:37:00	2022-02-17 15:37:00	4
2	3	RC DENTE 12	2022-02-17 15:45:55	2022-02-17 15:45:55	4
\.


--
-- Data for Name: audits; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.audits (id, user_type, user_id, event, auditable_type, auditable_id, old_values, new_values, url, ip_address, user_agent, tags, created_at, updated_at) FROM stdin;
1	App\\Models\\User	1	updated	App\\Models\\User	1	[]	[]	http://dev-sindserv.herokuapp.com/login	10.1.42.236	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36	\N	2022-02-08 09:49:10	2022-02-08 09:49:10
2	App\\Models\\User	1	created	App\\Models\\Servidor	1	[]	{"nome":"MARIA DE FATIMA FERNANDES BENJAMIM","nome_social":null,"cpf":"07334309880","rg":null,"nao_perturbe":"0","nacionalidade":null,"naturalidade":null,"naturalidade_uf":null,"nome_pai":null,"nome_mae":null,"observacoes":null,"id":1}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.17.99	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36	\N	2022-02-08 10:01:20	2022-02-08 10:01:20
3	App\\Models\\User	1	created	App\\Models\\PlanoConta	1	[]	{"nome":"APOIO FINANCEIRO","id":1}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.10.79	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-11 15:40:44	2022-02-11 15:40:44
4	App\\Models\\User	1	created	App\\Models\\Cargo	1	[]	{"nome":"AGENTE COMUNITARIO DE SAUDE","nivel_salarial_id":1,"id":1}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.12.108	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:07:32	2022-02-14 15:07:32
5	App\\Models\\User	1	created	App\\Models\\Cargo	2	[]	{"nome":"AGENTE DE COMBATE AS ENDEMIAS","nivel_salarial_id":1,"id":2}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.12.108	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:08:03	2022-02-14 15:08:03
6	App\\Models\\User	1	created	App\\Models\\Cargo	3	[]	{"nome":"AJUDANTE DE COZINHA","nivel_salarial_id":1,"id":3}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.12.108	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:08:27	2022-02-14 15:08:27
7	App\\Models\\User	1	created	App\\Models\\Cargo	4	[]	{"nome":"AUXILIAR DE SERVICOS GERAIS","nivel_salarial_id":1,"id":4}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.12.108	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:08:53	2022-02-14 15:08:53
8	App\\Models\\User	1	created	App\\Models\\Cargo	5	[]	{"nome":"AGENTE DE PORTARIA","nivel_salarial_id":2,"id":5}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.12.108	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:10:00	2022-02-14 15:10:00
9	App\\Models\\User	1	created	App\\Models\\Cargo	6	[]	{"nome":"ASCENSORISTA","nivel_salarial_id":2,"id":6}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.12.108	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:10:47	2022-02-14 15:10:47
10	App\\Models\\User	1	created	App\\Models\\Cargo	7	[]	{"nome":"OFICIAL DE CONTROLE ANIMAL","nivel_salarial_id":2,"id":7}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.12.108	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:11:23	2022-02-14 15:11:23
11	App\\Models\\User	1	created	App\\Models\\Cargo	8	[]	{"nome":"TRATADOR DE ANIMAIS","nivel_salarial_id":2,"id":8}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.28.115	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:13:25	2022-02-14 15:13:25
12	App\\Models\\User	1	created	App\\Models\\Cargo	9	[]	{"nome":"GUARDA MUNICIPAL I","nivel_salarial_id":5,"id":9}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.28.115	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:14:18	2022-02-14 15:14:18
13	App\\Models\\User	1	created	App\\Models\\Cargo	10	[]	{"nome":"AUXILIAR DE SAUDE BUCAL","nivel_salarial_id":5,"id":10}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.28.115	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:14:50	2022-02-14 15:14:50
14	App\\Models\\User	1	updated	App\\Models\\Cargo	10	{"nivel_salarial_id":5}	{"nivel_salarial_id":6}	http://dev-sindserv.herokuapp.com/admin/cargos/10	10.1.89.67	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:15:27	2022-02-14 15:15:27
15	App\\Models\\User	1	created	App\\Models\\Cargo	11	[]	{"nome":"INSPETOR DE ALUNOS","nivel_salarial_id":6,"id":11}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.5.240	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:19:08	2022-02-14 15:19:08
16	App\\Models\\User	1	created	App\\Models\\Cargo	12	[]	{"nome":"GUARDA MUNICIPAL II","nivel_salarial_id":7,"id":12}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.5.240	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:20:03	2022-02-14 15:20:03
17	App\\Models\\User	1	created	App\\Models\\Cargo	13	[]	{"nome":"INSPETOR DE ZOONOSES","nivel_salarial_id":8,"id":13}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.5.240	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:20:37	2022-02-14 15:20:37
18	App\\Models\\User	1	created	App\\Models\\Cargo	14	[]	{"nome":"AGENTE ADMINISTRATIVO","nivel_salarial_id":8,"id":14}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.5.240	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:21:16	2022-02-14 15:21:16
19	App\\Models\\User	1	created	App\\Models\\Cargo	15	[]	{"nome":"GUARDA MUNICIPAL III - INSPETOR","nivel_salarial_id":9,"id":15}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.5.240	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:22:00	2022-02-14 15:22:00
20	App\\Models\\User	1	created	App\\Models\\Cargo	16	[]	{"nome":"TECNICO DE RAIO X","nivel_salarial_id":9,"id":16}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:23:40	2022-02-14 15:23:40
21	App\\Models\\User	1	created	App\\Models\\Cargo	17	[]	{"nome":"SECRETARIO DE UNIDADE ESCOLAR","nivel_salarial_id":10,"id":17}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:24:17	2022-02-14 15:24:17
22	App\\Models\\User	1	created	App\\Models\\Cargo	18	[]	{"nome":"TECNICO DE ENFERMAGEM","nivel_salarial_id":10,"id":18}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:24:56	2022-02-14 15:24:56
23	App\\Models\\User	1	created	App\\Models\\Cargo	19	[]	{"nome":"PROFESSOR ADJUNTO I","nivel_salarial_id":13,"id":19}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:25:38	2022-02-14 15:25:38
24	App\\Models\\User	1	created	App\\Models\\Cargo	20	[]	{"nome":"PROFESSOR DE EDUCACAO BASICA I","nivel_salarial_id":12,"id":20}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:26:21	2022-02-14 15:26:21
25	App\\Models\\User	1	created	App\\Models\\Cargo	21	[]	{"nome":"ESPEC. DE EDUC. I - COORDENADOR PEDAGOGICO","nivel_salarial_id":15,"id":21}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:27:05	2022-02-14 15:27:05
26	App\\Models\\User	1	created	App\\Models\\Cargo	22	[]	{"nome":"PROFESSOR ADJUNTO II","nivel_salarial_id":16,"id":22}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:27:38	2022-02-14 15:27:38
27	App\\Models\\User	1	created	App\\Models\\Cargo	23	[]	{"nome":"PROFESSOR DE EDUCACAO BASICA II","nivel_salarial_id":15,"id":23}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:28:12	2022-02-14 15:28:12
28	App\\Models\\User	1	created	App\\Models\\Cargo	24	[]	{"nome":"ENFERMEIRO","nivel_salarial_id":17,"id":24}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:28:43	2022-02-14 15:28:43
29	App\\Models\\User	1	created	App\\Models\\Cargo	25	[]	{"nome":"ANALISTA DE SISTEMAS","nivel_salarial_id":18,"id":25}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:29:16	2022-02-14 15:29:16
30	App\\Models\\User	1	created	App\\Models\\Cargo	26	[]	{"nome":"BIOLOGO","nivel_salarial_id":18,"id":26}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:30:06	2022-02-14 15:30:06
31	App\\Models\\User	1	created	App\\Models\\Cargo	27	[]	{"nome":"MEDICO","nivel_salarial_id":19,"id":27}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.10.140	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:30:36	2022-02-14 15:30:36
32	App\\Models\\User	1	deleted	App\\Models\\PlanoConta	1	{"id":1,"nome":"APOIO FINANCEIRO"}	[]	http://dev-sindserv.herokuapp.com/admin/planos-contas/1	10.1.5.240	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 15:47:02	2022-02-14 15:47:02
33	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	1	[]	{"descricao":"130006239","numero_documento":null,"observacoes":null,"tipo":2,"status":1,"forma_recebimento":1,"valor_pago":"175.35","valor":"175.35","vencimento":"2021-02-01T19:07:02.000000Z","data_pagamento":"2021-02-01T19:07:02.000000Z","id":1}	http://dev-sindserv.herokuapp.com/admin/contas-receber	10.1.92.135	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 16:07:02	2022-02-14 16:07:02
34	App\\Models\\User	1	updated	App\\Models\\ContaPagarReceber	1	{"vencimento":"2021-02-01","status":1,"data_pagamento":"2021-02-01"}	{"vencimento":"2021-02-01T19:18:35.000000Z","status":2,"data_pagamento":"2021-02-01T19:18:35.000000Z"}	http://dev-sindserv.herokuapp.com/admin/contas-receber/1	10.1.22.178	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 16:18:35	2022-02-14 16:18:35
35	App\\Models\\User	1	created	App\\Models\\PlanoConta	2	[]	{"nome":"DESPESA FIXA","id":2}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.26.47	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 16:22:55	2022-02-14 16:22:55
36	App\\Models\\User	1	created	App\\Models\\Servidor	2	[]	{"nome":"ANDREA BRAGA SALGUEIRO","nome_social":null,"cpf":"10527520802","rg":"17.173.356-","nao_perturbe":"0","data_nascimento":"1967-12-13T02:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SAO PAULO","naturalidade_uf":"SP","nome_pai":"IVAN JOSE SIMES SALGUEIRO","nome_mae":"MARIA AUGUSTA B SALGUEIRO","observacoes":null,"estado_civil":3,"sexo":2,"nivel_ensino":4,"id":2}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.21.118	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-14 16:45:38	2022-02-14 16:45:38
37	App\\Models\\User	1	created	App\\Models\\Servidor	3	[]	{"nome":"LILIANA MARINA AYALA FERNANDES CRUZ","nome_social":null,"cpf":"10198908865","rg":null,"nao_perturbe":"0","nacionalidade":null,"naturalidade":null,"naturalidade_uf":null,"nome_pai":null,"nome_mae":null,"observacoes":null,"id":3}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.12.61	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 16:58:11	2022-02-14 16:58:11
38	App\\Models\\User	1	created	App\\Models\\Servidor	4	[]	{"nome":"ANDREA DE ARAUJO SILVA","nome_social":null,"cpf":"25664866896","rg":"28.208.759-","nao_perturbe":"0","data_nascimento":"1977-08-23T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SAO VICENTE","naturalidade_uf":"SP","nome_pai":"ANTONIO LOPES DA SILVA","nome_mae":"JOVINA DE ARAUJO SILVA","observacoes":null,"estado_civil":1,"sexo":2,"id":4}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.10.140	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-14 17:15:43	2022-02-14 17:15:43
39	App\\Models\\User	1	created	App\\Models\\Servidor	5	[]	{"nome":"AFFONSO DIAS FILHO","nome_social":null,"cpf":"54528046849","rg":"3.952.110-2","nao_perturbe":"0","data_nascimento":"1938-02-14T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"AFONSO DIAS FILHO","nome_mae":"TEREZA SEBASTIANA DE JESUS","observacoes":null,"estado_civil":2,"sexo":1,"id":5}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.5.217	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-14 17:23:47	2022-02-14 17:23:47
40	App\\Models\\User	1	created	App\\Models\\Funcionario	1	[]	{"nome":"APARECIDA DORALICE DE LIMA","funcao":"FAXINEIRA","rg":"157374324","cnh":null,"cpf":"04494160890","data_nascimento":"1967-11-15T11:08:58.000000Z","observacoes":null,"sexo":2,"id":1}	http://dev-sindserv.herokuapp.com/admin/funcionarios	10.1.42.105	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:08:59	2022-02-15 09:08:59
41	App\\Models\\User	1	created	App\\Models\\Funcionario	2	[]	{"nome":"ALESSANDRA CALAZANS DE FREITAS","funcao":"ASSISTENTE ADMINISTRATIVO","rg":"422374714","cnh":null,"cpf":"30949359823","data_nascimento":"1981-10-03T12:14:40.000000Z","observacoes":null,"sexo":2,"id":2}	http://dev-sindserv.herokuapp.com/admin/funcionarios	10.1.20.158	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:14:40	2022-02-15 09:14:40
42	App\\Models\\User	1	created	App\\Models\\Funcionario	3	[]	{"nome":"KELLY CRISTINA DE BRITO ABENZA","funcao":"ENCARREGADO DE TESOURARIA","rg":"271653851","cnh":null,"cpf":"33402848813","data_nascimento":"1986-03-21T12:18:31.000000Z","observacoes":null,"sexo":1,"id":3}	http://dev-sindserv.herokuapp.com/admin/funcionarios	10.1.29.75	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:18:31	2022-02-15 09:18:31
43	App\\Models\\User	1	created	App\\Models\\Funcionario	4	[]	{"nome":"CASSIO RAIMUNDO SIMOES CANHOTO","funcao":"DIRETOR SINDICAL","rg":"32102880","cnh":null,"cpf":"28457123831","data_nascimento":"1980-05-22T12:22:48.000000Z","observacoes":"CADASTRO P\\/ AGENDA DIRETORIA","sexo":1,"id":4}	http://dev-sindserv.herokuapp.com/admin/funcionarios	10.1.29.75	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:22:49	2022-02-15 09:22:49
44	App\\Models\\User	1	created	App\\Models\\Funcionario	5	[]	{"nome":"MARCIA ESTER CALDAS DOS SANTOS","funcao":"DIRETORA SINDICAL","rg":"25003970","cnh":null,"cpf":"25288775877","data_nascimento":"1975-06-07T12:24:33.000000Z","observacoes":"CADASTRO P\\/ AGENDA DIRETORIA","sexo":2,"id":5}	http://dev-sindserv.herokuapp.com/admin/funcionarios	10.1.41.11	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:24:34	2022-02-15 09:24:34
45	App\\Models\\User	1	updated	App\\Models\\Funcionario	4	{"data_nascimento":"1980-05-22"}	{"data_nascimento":"1980-05-22T12:25:23.000000Z"}	http://dev-sindserv.herokuapp.com/admin/funcionarios/4	10.1.41.11	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:25:23	2022-02-15 09:25:23
46	App\\Models\\User	1	created	App\\Models\\PrestadorServico	1	[]	{"nome":"CARLOS ROGERIO R. DE ALMEIDA","funcao":"CIRURGI\\u00c3O DENTISTA","rg":"","cpf":"","cnpj":"","observacoes":null,"sexo":null,"tipo":1,"especialidade":1,"id":1}	http://dev-sindserv.herokuapp.com/admin/prestadores-servicos	10.1.41.11	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:27:03	2022-02-15 09:27:03
47	App\\Models\\User	1	created	App\\Models\\PrestadorServico	2	[]	{"nome":"JULIANA CURY LACERDA","funcao":"CIRURGI\\u00c3 DENTISTA","rg":"","cpf":"","cnpj":"","observacoes":null,"sexo":null,"tipo":1,"especialidade":2,"id":2}	http://dev-sindserv.herokuapp.com/admin/prestadores-servicos	10.1.41.11	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:28:21	2022-02-15 09:28:21
48	App\\Models\\User	1	created	App\\Models\\PrestadorServico	3	[]	{"nome":"LILIAN NARCISO SANCHES","funcao":"CIRURGI\\u00c3 DENTISTA","rg":"","cpf":"","cnpj":"","observacoes":null,"sexo":null,"tipo":1,"especialidade":3,"id":3}	http://dev-sindserv.herokuapp.com/admin/prestadores-servicos	10.1.41.11	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:31:17	2022-02-15 09:31:17
49	App\\Models\\User	1	created	App\\Models\\PrestadorServico	4	[]	{"nome":"VIVIANE ANTUNES DA SILVA","funcao":"CIRURGI\\u00c3 DENTISTA","rg":"","cpf":"","cnpj":"","observacoes":null,"sexo":null,"tipo":1,"especialidade":1,"id":4}	http://dev-sindserv.herokuapp.com/admin/prestadores-servicos	10.1.41.11	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:32:35	2022-02-15 09:32:35
50	App\\Models\\User	1	created	App\\Models\\Servidor	6	[]	{"nome":"MARIA GENI DOS SANTOS SOUZA","nome_social":null,"cpf":"26208868807","rg":"52.199.821-","nao_perturbe":"0","data_nascimento":"1977-01-25T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"CALDAS DE CIPO","naturalidade_uf":"BA","nome_pai":null,"nome_mae":"MARIA ALDENORA DOS SANTOS","observacoes":null,"estado_civil":1,"sexo":2,"id":6}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.41.11	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 09:45:54	2022-02-15 09:45:54
51	App\\Models\\User	1	created	App\\Models\\Servidor	7	[]	{"nome":"JOSE LUIZ VIEIRA","nome_social":null,"cpf":"06994542807","rg":"_1.899.450-","nao_perturbe":"0","data_nascimento":"1968-12-26T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"SEBASTIAO TIMOTEO VIEIRA","nome_mae":"NEUZA DA SILVA VIEIRA","observacoes":"SERVIDOR DE LCV(LICEN\\u00c7A COM VENCIMENTOS) - TRABALHANDO NA CAMARA MUNICIPAL DE SANTOS - PORTARIA 123\\/2021 DEGEPAT PUBLICADADA 01012021","estado_civil":2,"sexo":1,"id":7}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.93.218	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 10:43:46	2022-02-15 10:43:46
52	App\\Models\\User	1	created	App\\Models\\Cargo	28	[]	{"nome":"AGENTE DE DEFESA CIVIL","nivel_salarial_id":6,"id":28}	http://dev-sindserv.herokuapp.com/admin/cargos	10.1.91.235	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 13:34:20	2022-02-15 13:34:20
53	App\\Models\\User	1	created	App\\Models\\Servidor	8	[]	{"nome":"ROSEVALDO SANTANA SANTOS","nome_social":null,"cpf":"65447948568","rg":"34.450.363-","nao_perturbe":"0","data_nascimento":"1974-04-10T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"PACATUABA","naturalidade_uf":"SE","nome_pai":"ANTONIO DOS SANTOS","nome_mae":"MARIA VALDETE SANTANA","observacoes":null,"estado_civil":4,"sexo":1,"id":8}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.38.143	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 13:49:24	2022-02-15 13:49:24
54	App\\Models\\User	1	created	App\\Models\\Servidor	9	[]	{"nome":"MARIA DOS SANTOS SILVA CAMARA","nome_social":null,"cpf":"73354902868","rg":"71376628","nao_perturbe":"0","data_nascimento":"1955-03-25T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"PRESIDENTE VENCESLAU","naturalidade_uf":"SP","nome_pai":"JOSE TERTO DA SILVA","nome_mae":"ERMIZIA DOS SANTOS SILVA","observacoes":null,"estado_civil":2,"sexo":2,"nivel_ensino":4,"id":9}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.17.97	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-15 15:09:44	2022-02-15 15:09:44
55	App\\Models\\User	1	created	App\\Models\\Servidor	10	[]	{"nome":"CAMILA CHIARA","nome_social":null,"cpf":"30762231866","rg":"307722375","nao_perturbe":"0","data_nascimento":"1980-08-03T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"ANTONIO FLAVIO CHIARA","nome_mae":"ELIANA APARECIDA CHIARA","observacoes":null,"estado_civil":1,"sexo":2,"nivel_ensino":4,"id":10}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.4.204	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-15 15:47:24	2022-02-15 15:47:24
71	App\\Models\\User	1	created	App\\Models\\User	2	[]	{"name":"ALESSANDRA","email":"sind_serv@uol.com.br","id":2}	http://dev-sindserv.herokuapp.com/admin/usuarios	10.1.82.193	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-17 13:04:43	2022-02-17 13:04:43
56	App\\Models\\User	1	created	App\\Models\\Servidor	11	[]	{"nome":"VICTOR BRUNELLI","nome_social":null,"cpf":"41020379855","rg":"391416601","nao_perturbe":"0","data_nascimento":"1991-06-14T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"SERGIO BRUNELLI","nome_mae":"TERESA CRISTINA VENTURA BRENELLI","observacoes":null,"estado_civil":1,"sexo":1,"nivel_ensino":2,"id":11}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.5.240	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-15 16:01:02	2022-02-15 16:01:02
57	App\\Models\\User	1	created	App\\Models\\Servidor	12	[]	{"nome":"SEVERINO MANOEL DA SILVA","nome_social":null,"cpf":"92712770820","rg":"10416375","nao_perturbe":"0","data_nascimento":"1957-10-17T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"MANOEL DA SILVA","nome_mae":"COLA\\u00c7A MARIA DA CONCEI\\u00c7\\u00c3O","observacoes":null,"id":12}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.13.96	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 16:19:15	2022-02-15 16:19:15
58	App\\Models\\User	1	created	App\\Models\\Servidor	13	[]	{"nome":"WALMIR BRUNETTO","nome_social":null,"cpf":"92680216849","rg":"105512102","nao_perturbe":"0","data_nascimento":"1958-01-09T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"JOAO BRUNETTO","nome_mae":"MARIA JOSE NOGUEIRA BRUNETTO","observacoes":null,"estado_civil":3,"sexo":1,"id":13}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.42.105	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 16:30:32	2022-02-15 16:30:32
59	App\\Models\\User	1	updated	App\\Models\\Servidor	13	{"falecido":false,"data_falecimento":null,"observacao_falecimento":null}	{"falecido":true,"data_falecimento":"2020-11-22T03:00:00.000000Z","observacao_falecimento":"VIUVA"}	http://dev-sindserv.herokuapp.com/admin/servidores/13/falecimento	10.1.41.11	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 16:37:33	2022-02-15 16:37:33
60	App\\Models\\User	1	created	App\\Models\\Feriado	1	[]	{"data_inicio":"2022-03-02T19:41:43.000000Z","data_fim":"2022-03-02T19:41:43.000000Z","titulo":"CARNAVAL","id":1}	http://dev-sindserv.herokuapp.com/admin/feriados	10.1.7.244	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 16:41:44	2022-02-15 16:41:44
61	App\\Models\\User	1	created	App\\Models\\Feriado	2	[]	{"data_inicio":"2022-02-28T19:42:50.000000Z","data_fim":"2022-02-28T19:42:50.000000Z","titulo":"PONTO FACULTATIVO","id":2}	http://dev-sindserv.herokuapp.com/admin/feriados	10.1.12.108	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 16:42:50	2022-02-15 16:42:50
62	App\\Models\\User	1	created	App\\Models\\Feriado	3	[]	{"data_inicio":"2022-03-01T19:43:20.000000Z","data_fim":"2022-03-01T19:43:20.000000Z","titulo":"PONTO FACULTATIVO","id":3}	http://dev-sindserv.herokuapp.com/admin/feriados	10.1.7.244	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36	\N	2022-02-15 16:43:21	2022-02-15 16:43:21
63	App\\Models\\User	1	created	App\\Models\\Servidor	14	[]	{"nome":"GUIOMAR MACHADO GONZALEZ","nome_social":null,"cpf":"15212898838","rg":"8.008.063-7","nao_perturbe":"0","data_nascimento":"1937-12-25T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"RICARDO MACHADO ALONSO","nome_mae":"THEREZA PERES MACHADO","observacoes":null,"estado_civil":4,"sexo":2,"id":14}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.45.103	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-15 16:53:06	2022-02-15 16:53:06
64	App\\Models\\User	1	created	App\\Models\\Servidor	15	[]	{"nome":"SERGIO DA SILVA","nome_social":null,"cpf":"73116912815","rg":"6365202","nao_perturbe":"0","data_nascimento":"1947-11-05T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"OSWALDO DA SILVA","nome_mae":"CECILIA PAPINI DA SILVA","observacoes":null,"nivel_ensino":2,"id":15}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.39.9	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-16 09:27:07	2022-02-16 09:27:07
65	App\\Models\\User	1	created	App\\Models\\Servidor	16	[]	{"nome":"MARIA BENEDITA","nome_social":null,"cpf":"","rg":null,"nao_perturbe":"0","nacionalidade":null,"naturalidade":null,"naturalidade_uf":null,"nome_pai":null,"nome_mae":null,"observacoes":"N\\u00c3O S\\u00d3CIA VEIO TIRAR D\\u00daVIDAS COM DIRETORIA","id":16}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.7.3	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-16 15:08:12	2022-02-16 15:08:12
66	App\\Models\\User	1	created	App\\Models\\Servidor	17	[]	{"nome":"TATIANA DIP ROSSI MORAES","nome_social":null,"cpf":"07227821870","rg":"13.622.334-","nao_perturbe":"0","data_nascimento":"1967-01-04T02:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"BRASILIA","naturalidade_uf":"DF","nome_pai":"ANTONIO DE ARAUJO ROSSI","nome_mae":"RUTH DIP ROSSI","observacoes":null,"estado_civil":2,"sexo":2,"id":17}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.5.210	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-17 09:49:53	2022-02-17 09:49:53
67	App\\Models\\User	1	created	App\\Models\\Servidor	18	[]	{"nome":"SERGIO TEIXEIRA PINTO","nome_social":null,"cpf":"97181218891","rg":"11271972","nao_perturbe":"0","data_nascimento":"1957-08-26T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"ARISTIDES","nome_mae":"JOZELITA TEIXEIRA PINTO","observacoes":null,"estado_civil":2,"sexo":1,"nivel_ensino":2,"id":18}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.24.197	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-17 10:57:20	2022-02-17 10:57:20
68	App\\Models\\User	1	created	App\\Models\\Servidor	19	[]	{"nome":"ADALBERTO PINTO JOAO","nome_social":null,"cpf":"73012971815","rg":"66.189.287","nao_perturbe":"0","data_nascimento":"1952-05-10T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"JOSE JOAO","nome_mae":"MARIA APARECIDA PINTO JOAO","observacoes":null,"estado_civil":2,"sexo":1,"id":19}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.17.97	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-17 11:11:14	2022-02-17 11:11:14
72	App\\Models\\User	1	updated	App\\Models\\Funcionario	2	{"user_id":null}	{"user_id":2}	http://dev-sindserv.herokuapp.com/admin/usuarios	10.1.82.193	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-17 13:04:45	2022-02-17 13:04:45
79	App\\Models\\User	1	created	App\\Models\\PerguntaAnamnese	3	[]	{"descricao":"\\u00c9 CARDIACO?","id":3}	http://dev-sindserv.herokuapp.com/admin/perguntas-anamnese	10.1.5.210	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-17 15:43:40	2022-02-17 15:43:40
69	App\\Models\\User	1	created	App\\Models\\Servidor	20	[]	{"nome":"LUCIANA DE PAULA BERNARDO","nome_social":null,"cpf":"10828263833","rg":"197566832","nao_perturbe":"0","data_nascimento":"1972-07-25T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"FRANCISCO DE PAULA DA SILVA","nome_mae":"ARIMAR AUGUSTA OLIVEIRA DA SILVA","observacoes":null,"estado_civil":2,"sexo":2,"nivel_ensino":2,"id":20}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.89.67	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-17 11:52:48	2022-02-17 11:52:48
70	App\\Models\\User	1	created	App\\Models\\Servidor	21	[]	{"nome":"JOSIANE CRISTINA COSTA SARAIVA","nome_social":null,"cpf":"27464438809","rg":"25415972","nao_perturbe":"0","data_nascimento":"1976-02-28T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SAO PAULO","naturalidade_uf":"SP","nome_pai":"GESSI DA COSTA RODRIGUES","nome_mae":"ANELISE TOMAZIA DA CONCEI\\u00c7\\u00c3O COSTA","observacoes":null,"estado_civil":2,"sexo":2,"nivel_ensino":4,"id":21}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.39.9	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-17 12:36:03	2022-02-17 12:36:03
80	App\\Models\\User	1	created	App\\Models\\Servidor	26	[]	{"nome":"MARIA BENEDITA GON\\u00c7ALVES","nome_social":null,"cpf":"","rg":null,"nao_perturbe":"0","nacionalidade":null,"naturalidade":null,"naturalidade_uf":null,"nome_pai":null,"nome_mae":null,"observacoes":"VEIO TIRAR DUVIDAS COM DIRETORIA SOBRE ESTATUTO MAGISTERIO","sexo":2,"id":26}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.81.122	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-18 09:28:10	2022-02-18 09:28:10
81	App\\Models\\User	1	created	App\\Models\\Servidor	27	[]	{"nome":"VERA LUCIA PEREIRA AQUINO","nome_social":null,"cpf":"09482905873","rg":"165906236","nao_perturbe":"0","data_nascimento":"1963-12-05T02:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"S.M. PAULISTA","naturalidade_uf":"SP","nome_pai":"RICARDO AQUINO","nome_mae":"IRENE PEREIRA AQUINO","observacoes":null,"estado_civil":3,"sexo":2,"nivel_ensino":4,"id":27}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.82.193	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-21 10:46:52	2022-02-21 10:46:52
82	App\\Models\\User	1	created	App\\Models\\Servidor	28	[]	{"nome":"WAGNER EDUARDO NOBREGA","nome_social":null,"cpf":"02556220821","rg":"133594452","nao_perturbe":"0","data_nascimento":"1961-11-09T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SAO VICENTE","naturalidade_uf":"SP","nome_pai":"LOUREN\\u00c7O NOBREGA RIBEIRO","nome_mae":"HELENICE FREIRE NOBREGA","observacoes":null,"estado_civil":1,"sexo":1,"nivel_ensino":2,"id":28}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.10.92	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-21 11:02:55	2022-02-21 11:02:55
83	App\\Models\\User	1	updated	App\\Models\\User	1	[]	[]	http://dev-sindserv.herokuapp.com/logout	10.1.29.125	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-22 13:38:45	2022-02-22 13:38:45
84	App\\Models\\User	1	updated	App\\Models\\Servidor	22	{"estado_civil":null,"sexo":null}	{"estado_civil":2,"sexo":1}	http://dev-sindserv.herokuapp.com/admin/servidores/22	10.1.14.237	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-08 10:19:00	2022-03-08 10:19:00
85	App\\Models\\User	1	created	App\\Models\\Servidor	29	[]	{"nome":"JOAO DA MATA","nome_social":null,"cpf":"72913940820","rg":null,"nao_perturbe":"0","data_nascimento":"1947-02-08T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"PEDRO HIGINO","nome_mae":"ADELAIDE MARCELINO N HIGINO","observacoes":null,"estado_civil":2,"sexo":1,"id":29}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.6.97	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-08 13:35:19	2022-03-08 13:35:19
86	App\\Models\\User	1	created	App\\Models\\PlanoConta	3	[]	{"nome":"KELLY BRITO","id":3}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.18.111	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-09 14:25:29	2022-03-09 14:25:29
87	App\\Models\\User	1	deleted	App\\Models\\PlanoConta	3	{"id":3,"nome":"KELLY BRITO"}	[]	http://dev-sindserv.herokuapp.com/admin/planos-contas/3	10.1.18.96	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 09:11:23	2022-03-15 09:11:23
88	App\\Models\\User	1	deleted	App\\Models\\PlanoConta	2	{"id":2,"nome":"DESPESA FIXA"}	[]	http://dev-sindserv.herokuapp.com/admin/planos-contas/2	10.1.4.236	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 09:20:54	2022-03-15 09:20:54
89	App\\Models\\User	1	created	App\\Models\\PlanoConta	4	[]	{"nome":"DESP. FUNCIONARIOS \\/SUPORTE\\/PREST.SERVI\\u00c7OS","id":4}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.1.57	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 09:50:13	2022-03-15 09:50:13
90	App\\Models\\User	1	created	App\\Models\\PlanoConta	5	[]	{"nome":"ENCARGOS","id":5}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.4.236	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:02:26	2022-03-15 10:02:26
91	App\\Models\\User	1	created	App\\Models\\PlanoConta	6	[]	{"nome":"SEGURAN\\u00c7A \\/ SEGURO \\/ AUX.FUNERAL","id":6}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.81.20	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:08:28	2022-03-15 10:08:28
92	App\\Models\\User	1	created	App\\Models\\PlanoConta	7	[]	{"nome":"MANUTEN\\u00c7OES \\/ CONTRATOS","id":7}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.46.27	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:13:44	2022-03-15 10:13:44
93	App\\Models\\User	1	created	App\\Models\\PlanoConta	8	[]	{"nome":"MANUTEN\\u00c7\\u00d5ES \\/ CONTRATOS","id":8}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.32.116	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:14:26	2022-03-15 10:14:26
94	App\\Models\\User	1	deleted	App\\Models\\PlanoConta	8	{"id":8,"nome":"MANUTEN\\u00c7\\u00d5ES \\/ CONTRATOS"}	[]	http://dev-sindserv.herokuapp.com/admin/planos-contas/8	10.1.32.116	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:14:43	2022-03-15 10:14:43
95	App\\Models\\User	1	created	App\\Models\\PlanoConta	9	[]	{"nome":"MATERIAIS","id":9}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.37.182	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:20:55	2022-03-15 10:20:55
73	App\\Models\\User	1	created	App\\Models\\Servidor	22	[]	{"nome":"DEUSDETE ALVES DE OLIVEIRA","nome_social":null,"cpf":"41538315653","rg":"246807933","nao_perturbe":"0","data_nascimento":"1955-12-30T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"TEOFILOOTONI","naturalidade_uf":"SP","nome_pai":"MANOEL ALVES DE OLIVEIRA","nome_mae":"SEBASTIANA ESTEVES DE OLIVEIRA","observacoes":null,"nivel_ensino":2,"id":22}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.41.162	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-17 13:06:14	2022-02-17 13:06:14
74	App\\Models\\User	1	created	App\\Models\\Servidor	23	[]	{"nome":"CELIA REGINA GONCALVES FUGAZZA","nome_social":null,"cpf":"02559500809","rg":"1.412.311-4","nao_perturbe":"0","data_nascimento":"1961-11-05T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"JOS\\u00c9 LUIZ GON\\u00c7ALVES","nome_mae":"ARMINDA DE OLIVEIRA GON\\u00c7ALVES","observacoes":null,"estado_civil":2,"sexo":2,"id":23}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.6.100	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-17 13:38:55	2022-02-17 13:38:55
75	App\\Models\\User	1	created	App\\Models\\Servidor	24	[]	{"nome":"DANIEL EVARISTO DOS SANTOS","nome_social":null,"cpf":"19752548806","rg":"254158596","nao_perturbe":"0","data_nascimento":"1974-04-30T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SAO VICENTE","naturalidade_uf":"SP","nome_pai":"AMANCIO EVARISTO DOS SANTOS","nome_mae":"VERA LUCIA ISIDORO","observacoes":null,"estado_civil":1,"sexo":1,"nivel_ensino":4,"id":24}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.82.193	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-17 14:35:11	2022-02-17 14:35:11
76	App\\Models\\User	1	created	App\\Models\\Servidor	25	[]	{"nome":"ANDREA DOS SANTOS SILVA","nome_social":null,"cpf":"91141621568","rg":"36.026.329-","nao_perturbe":"0","data_nascimento":"1976-04-23T03:00:00.000000Z","nacionalidade":"BARSILEIRA","naturalidade":"CONCEI\\u00c7\\u00c3O DE COITE","naturalidade_uf":"BA","nome_pai":"AMBROSIO EVANGELISTA DOS SANTOS","nome_mae":"JOANA LEONILDA DOS SANTOS","observacoes":null,"estado_civil":3,"sexo":2,"nivel_ensino":4,"id":25}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.41.11	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-02-17 14:44:11	2022-02-17 14:44:11
77	App\\Models\\User	1	created	App\\Models\\PerguntaAnamnese	1	[]	{"descricao":"QUANDO FOI SEU \\u00daLTIMO TRATAMENTO DENT\\u00c1RIO?","id":1}	http://dev-sindserv.herokuapp.com/admin/perguntas-anamnese	10.1.7.3	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-17 15:41:15	2022-02-17 15:41:15
78	App\\Models\\User	1	created	App\\Models\\PerguntaAnamnese	2	[]	{"descricao":"TEM ALGUM PROBLEMA RESPIRATORIO?","id":2}	http://dev-sindserv.herokuapp.com/admin/perguntas-anamnese	10.1.22.114	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36	\N	2022-02-17 15:43:19	2022-02-17 15:43:19
96	App\\Models\\User	1	created	App\\Models\\PlanoConta	10	[]	{"nome":"COMUNICA\\u00c7\\u00c3O \\/ CONFEC\\u00c7\\u00c3O DE MATERIAL","id":10}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.16.198	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:23:14	2022-03-15 10:23:14
97	App\\Models\\User	1	created	App\\Models\\PlanoConta	11	[]	{"nome":"DESPESA FIXA","id":11}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.47.178	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:27:20	2022-03-15 10:27:20
98	App\\Models\\User	1	created	App\\Models\\PlanoConta	12	[]	{"nome":"MANUTEN\\u00c7\\u00c3O PREDIAL","id":12}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.47.178	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:28:36	2022-03-15 10:28:36
99	App\\Models\\User	1	created	App\\Models\\PlanoConta	13	[]	{"nome":"OUTROS","id":13}	http://dev-sindserv.herokuapp.com/admin/planos-contas	10.1.47.178	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:29:08	2022-03-15 10:29:08
100	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	2	[]	{"descricao":"130006239","numero_documento":null,"observacoes":null,"tipo":2,"status":2,"forma_recebimento":1,"valor_pago":"1323.00","valor":"1323.00","vencimento":"2022-03-02T13:47:32.000000Z","data_pagamento":"2022-03-02T13:47:32.000000Z","id":2}	http://dev-sindserv.herokuapp.com/admin/contas-receber	10.1.47.178	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:47:32	2022-03-15 10:47:32
101	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	3	[]	{"descricao":"CLEUSA CONSORTI S MOREIRA","numero_documento":null,"nota_fiscal":"015.124","valor":"1323.00","vencimento":"2022-03-02T13:51:23.000000Z","observacoes":"REF A MATERIAL DE LIMPEZA","tipo":1,"status":2,"tipo_despesa":1,"recorrencia":1,"valor_pago":"1323.00","data_pagamento":"2022-03-02T13:51:23.000000Z","forma_pagamento":1,"responsavel_despesa":null,"classificacao_conta_id":40,"id":3}	http://dev-sindserv.herokuapp.com/admin/contas-pagar	10.1.6.29	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:51:24	2022-03-15 10:51:24
102	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	4	[]	{"descricao":"13000623-9","numero_documento":null,"observacoes":null,"tipo":2,"status":2,"forma_recebimento":1,"valor_pago":"294.10","valor":"294.10","vencimento":"2022-03-03T13:52:52.000000Z","data_pagamento":"2022-03-03T13:52:52.000000Z","id":4}	http://dev-sindserv.herokuapp.com/admin/contas-receber	10.1.6.29	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:52:52	2022-03-15 10:52:52
103	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	5	[]	{"descricao":"L L DE MARCO CUNHA","numero_documento":null,"nota_fiscal":"823","valor":"294.10","vencimento":"2022-03-03T13:57:21.000000Z","observacoes":"REF A COMPRA DE CART\\u00c3O SSD NOTBOOK QUE UTILIZA COM O TELEPRONPOTER","tipo":1,"status":2,"tipo_despesa":2,"recorrencia":null,"valor_pago":"294.10","data_pagamento":"2022-03-03T13:57:21.000000Z","forma_pagamento":1,"responsavel_despesa":"EMANOEL","classificacao_conta_id":41,"id":5}	http://dev-sindserv.herokuapp.com/admin/contas-pagar	10.1.9.60	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 10:57:22	2022-03-15 10:57:22
104	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	6	[]	{"descricao":"13000623-9","numero_documento":null,"observacoes":null,"tipo":2,"status":2,"forma_recebimento":1,"valor_pago":"749.00","valor":"749.00","vencimento":"2022-03-04T14:02:05.000000Z","data_pagamento":"2022-03-04T14:02:05.000000Z","id":6}	http://dev-sindserv.herokuapp.com/admin/contas-receber	10.1.81.4	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 11:02:06	2022-03-15 11:02:06
105	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	7	[]	{"descricao":"VIVO","numero_documento":null,"nota_fiscal":null,"valor":"749.00","vencimento":"2022-03-04T14:03:35.000000Z","observacoes":"CONTA DE TELEFONE IP DEDICADO","tipo":1,"status":2,"tipo_despesa":1,"recorrencia":1,"valor_pago":"749.00","data_pagamento":"2022-03-04T14:03:35.000000Z","forma_pagamento":1,"responsavel_despesa":null,"classificacao_conta_id":13,"id":7}	http://dev-sindserv.herokuapp.com/admin/contas-pagar	10.1.12.217	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 11:03:35	2022-03-15 11:03:35
106	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	8	[]	{"descricao":"VIVO","numero_documento":null,"nota_fiscal":null,"valor":"99.99","vencimento":"2022-03-15T14:07:38.000000Z","observacoes":"INTERNET BANDA LARGA","tipo":1,"status":2,"tipo_despesa":1,"recorrencia":1,"valor_pago":"99.99","data_pagamento":"2022-03-04T14:07:38.000000Z","forma_pagamento":1,"responsavel_despesa":null,"classificacao_conta_id":13,"id":8}	http://dev-sindserv.herokuapp.com/admin/contas-pagar	10.1.90.34	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 11:07:39	2022-03-15 11:07:39
107	App\\Models\\User	1	deleted	App\\Models\\ContaPagarReceber	8	{"id":8,"descricao":"VIVO","valor":"99.99","vencimento":"2022-03-15","status":2,"valor_pago":"99.99","data_pagamento":"2022-03-04","numero_documento":null,"forma_pagamento":1,"recorrencia":1,"tipo_despesa":1,"tipo":1,"responsavel_despesa":null,"observacoes":"INTERNET BANDA LARGA","caminho_documento":null,"classificacao_conta_id":13,"forma_recebimento":null,"nota_fiscal":null}	[]	http://dev-sindserv.herokuapp.com/admin/contas-pagar-receber/8	10.1.20.140	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 11:12:16	2022-03-15 11:12:16
108	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	9	[]	{"descricao":"13000623-9","numero_documento":null,"observacoes":null,"tipo":2,"status":2,"forma_recebimento":1,"valor_pago":"99.99","valor":"99.99","vencimento":"2022-03-04T14:14:06.000000Z","data_pagamento":"2022-03-04T14:14:06.000000Z","id":9}	http://dev-sindserv.herokuapp.com/admin/contas-receber	10.1.81.4	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 11:14:07	2022-03-15 11:14:07
109	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	10	[]	{"descricao":"VIVO","numero_documento":null,"nota_fiscal":null,"valor":"99.99","vencimento":"2022-03-04T14:18:31.000000Z","observacoes":"REF A INTERNET BANDA LARGA 1360034192","tipo":1,"status":2,"tipo_despesa":1,"recorrencia":1,"valor_pago":"99.99","data_pagamento":"2022-03-04T14:18:31.000000Z","forma_pagamento":1,"responsavel_despesa":null,"classificacao_conta_id":13,"id":10}	http://dev-sindserv.herokuapp.com/admin/contas-pagar	10.1.2.110	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 11:18:32	2022-03-15 11:18:32
110	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	11	[]	{"descricao":"13000623-9","numero_documento":null,"observacoes":null,"tipo":2,"status":2,"forma_recebimento":1,"valor_pago":"50.00","valor":"50.00","vencimento":"2022-03-04T14:26:05.000000Z","data_pagamento":"2022-03-04T14:26:05.000000Z","id":11}	http://dev-sindserv.herokuapp.com/admin/contas-receber	10.1.36.133	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 11:26:05	2022-03-15 11:26:05
111	App\\Models\\User	1	created	App\\Models\\ContaPagarReceber	12	[]	{"descricao":"VIVO","numero_documento":null,"nota_fiscal":null,"valor":"50.00","vencimento":"2022-03-05T14:28:41.000000Z","observacoes":"CONTA DE TELEFONE - MONITORA DADOS","tipo":1,"status":2,"tipo_despesa":1,"recorrencia":1,"valor_pago":"50.00","data_pagamento":"2022-03-04T14:28:41.000000Z","forma_pagamento":1,"responsavel_despesa":null,"classificacao_conta_id":13,"id":12}	http://dev-sindserv.herokuapp.com/admin/contas-pagar	10.1.94.198	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36	\N	2022-03-15 11:28:42	2022-03-15 11:28:42
112	App\\Models\\User	1	updated	App\\Models\\Servidor	5	{"estado_civil":2}	{"estado_civil":1}	http://dev-sindserv.herokuapp.com/admin/servidores/5	10.1.14.58	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.82 Safari/537.36	\N	2022-03-24 13:00:33	2022-03-24 13:00:33
113	App\\Models\\User	1	updated	App\\Models\\Servidor	2	{"rg":"17.173.356-"}	{"rg":"17.173.356-X"}	http://dev-sindserv.herokuapp.com/admin/servidores/2	10.1.29.122	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.82 Safari/537.36	\N	2022-03-24 13:25:54	2022-03-24 13:25:54
114	App\\Models\\User	1	updated	App\\Models\\Servidor	1	{"rg":null,"data_nascimento":null,"nome_mae":null,"nome_pai":null,"naturalidade":null,"estado_civil":null,"sexo":null,"nacionalidade":null,"naturalidade_uf":null,"nivel_ensino":null}	{"rg":"15.146.010-3","data_nascimento":"1960-10-20T03:00:00.000000Z","nome_mae":"MARINA FERNANDES DE OLIVEIRA","nome_pai":"FRANCISCO NETO SOBRINHO","naturalidade":"ALEXANDRIA","estado_civil":2,"sexo":2,"nacionalidade":"BRASILEIRA","naturalidade_uf":"RN","nivel_ensino":4}	http://dev-sindserv.herokuapp.com/admin/servidores/1	10.1.80.29	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.82 Safari/537.36	\N	2022-03-24 14:45:30	2022-03-24 14:45:30
115	App\\Models\\User	1	created	App\\Models\\Servidor	30	[]	{"nome":"ALEXANDRE ABDO FILHO","nome_social":null,"cpf":"03382568810","rg":"141416178","nao_perturbe":"0","data_nascimento":"1960-10-29T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SAO PAULO","naturalidade_uf":"SP","nome_pai":"ALEXANDRE ABDO","nome_mae":"JANDIRA DA SILVA BRUNHARA","observacoes":null,"estado_civil":5,"sexo":1,"id":30}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.11.75	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.82 Safari/537.36	\N	2022-03-24 15:46:01	2022-03-24 15:46:01
116	App\\Models\\User	1	created	App\\Models\\Servidor	31	[]	{"nome":"LUIZ ANTONIO SIMOES DOS SANTOS SILVA","nome_social":null,"cpf":"03513400845","rg":"1.273.681-6","nao_perturbe":"0","data_nascimento":"1959-04-10T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"MANOEL SIMOES DA SILVA","nome_mae":"MARCELINA JOSEFA S. SILVA","observacoes":null,"estado_civil":2,"sexo":1,"id":31}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.40.97	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.82 Safari/537.36	\N	2022-03-25 09:34:07	2022-03-25 09:34:07
117	App\\Models\\User	1	updated	App\\Models\\Servidor	31	{"observacoes":null}	{"observacoes":"LIC"}	http://dev-sindserv.herokuapp.com/admin/servidores/31	10.1.40.97	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.82 Safari/537.36	\N	2022-03-25 11:36:59	2022-03-25 11:36:59
118	App\\Models\\User	1	updated	App\\Models\\Servidor	31	{"observacoes":"LIC"}	{"observacoes":null}	http://dev-sindserv.herokuapp.com/admin/servidores/31	10.1.40.97	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.82 Safari/537.36	\N	2022-03-25 11:39:12	2022-03-25 11:39:12
119	App\\Models\\User	1	created	App\\Models\\Servidor	32	[]	{"nome":"CELSO PEREIRA COSTA","nome_social":null,"cpf":"04941404882","rg":"141238057","nao_perturbe":"0","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"BENEDITO COSTA","nome_mae":"NILZA DE JESUS PEREIRA","observacoes":null,"estado_civil":4,"sexo":1,"id":32}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.19.135	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.82 Safari/537.36	\N	2022-03-25 13:05:28	2022-03-25 13:05:28
120	App\\Models\\User	1	updated	App\\Models\\Servidor	32	{"data_nascimento":null}	{"data_nascimento":"1956-03-18T03:00:00.000000Z"}	http://dev-sindserv.herokuapp.com/admin/servidores/32	10.1.19.135	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.82 Safari/537.36	\N	2022-03-25 13:07:08	2022-03-25 13:07:08
121	App\\Models\\User	1	created	App\\Models\\Servidor	33	[]	{"nome":"ROMELIA FIRMO","nome_social":null,"cpf":"33965889753","rg":"59.177.711-3","nao_perturbe":"0","data_nascimento":"1956-04-21T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"DUQUE DE CAXIAS","naturalidade_uf":"RJ","nome_pai":"ANTONIO FIRMO","nome_mae":"LUZIA FIRMO","observacoes":null,"estado_civil":3,"sexo":2,"id":33}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.10.83	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.82 Safari/537.36	\N	2022-03-25 13:15:18	2022-03-25 13:15:18
122	App\\Models\\User	1	created	App\\Models\\Servidor	34	[]	{"nome":"ALINE DA SILVA HONORIO ALVES","nome_social":null,"cpf":"27286319809","rg":"28.962.806-4","nao_perturbe":"0","data_nascimento":"1980-02-26T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"DAMIAO HONORIO ALVES","nome_mae":"ROSEMARY DA SILVA ALVES","observacoes":null,"estado_civil":2,"sexo":2,"id":34}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.35.180	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.75 Safari/537.36	\N	2022-04-11 11:47:15	2022-04-11 11:47:15
123	App\\Models\\User	1	created	App\\Models\\RegistroServidor	37	[]	{"cargo_id":21,"readaptado":"0","data_admissao":"2012-08-29T14:47:14.000000Z","unidadeorganizacional_id":"47","nivel_salarial_id":"15","numero":"311985","regime":1,"portaria_aposentadoria":null,"paridade":null,"servidor_id":34,"id":37}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.35.180	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.75 Safari/537.36	\N	2022-04-11 11:47:18	2022-04-11 11:47:18
124	App\\Models\\User	1	created	App\\Models\\Servidor	35	[]	{"nome":"MICHEL DE JESUS DA SILVA","nome_social":null,"cpf":"30351400818","rg":"333699622","nao_perturbe":"0","data_nascimento":"1981-09-01T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"CUBATAO","naturalidade_uf":"SP","nome_pai":"MARINALDO JESUS DA SILVA","nome_mae":"ESPERAN\\u00c7A DE JESUS DA SILVA","observacoes":"EMPATIA","estado_civil":2,"sexo":1,"id":35}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.95.214	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-04-11 14:55:13	2022-04-11 14:55:13
125	App\\Models\\User	1	created	App\\Models\\RegistroServidor	38	[]	{"cargo_id":9,"readaptado":"0","data_admissao":"2014-09-02T17:55:12.000000Z","unidadeorganizacional_id":"28","nivel_salarial_id":"5","numero":"333419","regime":1,"portaria_aposentadoria":null,"paridade":null,"servidor_id":35,"id":38}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.95.214	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-04-11 14:55:16	2022-04-11 14:55:16
126	App\\Models\\User	1	created	App\\Models\\Servidor	36	[]	{"nome":"NIVALDO VIEIRA DE MELO","nome_social":null,"cpf":"92734022834","rg":"99964892","nao_perturbe":"0","data_nascimento":"1957-01-22T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"ANTONIO VIEIRA DE MELO","nome_mae":"MARIA DOS SANTOS MELO","observacoes":"EMPATIA","estado_civil":2,"sexo":1,"id":36}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.10.43	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-04-11 15:35:10	2022-04-11 15:35:10
127	App\\Models\\User	1	created	App\\Models\\RegistroServidor	39	[]	{"cargo_id":14,"readaptado":"0","data_admissao":"2012-06-14T18:35:09.000000Z","unidadeorganizacional_id":"27","nivel_salarial_id":null,"numero":"155424","regime":3,"data_aposentadoria":"2018-02-01T17:35:10.000000Z","portaria_aposentadoria":"068\\/18","paridade":null,"tipo_aposentadoria":1,"proventos":2,"servidor_id":36,"id":39}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.10.43	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-04-11 15:35:14	2022-04-11 15:35:14
128	App\\Models\\User	1	created	App\\Models\\Servidor	37	[]	{"nome":"GISELLE APARECIDA DE SOUZA SILVA","nome_social":null,"cpf":"19293883813","rg":"253933171","nao_perturbe":"0","data_nascimento":"1975-01-20T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"JOSE DE SOUZA SILVA","nome_mae":"MARIA ANGELICA BASTOS SILVA","observacoes":"EMPATIA","estado_civil":3,"sexo":2,"id":37}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.9.113	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-04-11 15:54:15	2022-04-11 15:54:15
129	App\\Models\\User	1	created	App\\Models\\RegistroServidor	40	[]	{"cargo_id":20,"readaptado":"0","data_admissao":"1996-10-10T17:54:14.000000Z","unidadeorganizacional_id":"12","nivel_salarial_id":"11","numero":"221531","regime":1,"portaria_aposentadoria":null,"paridade":null,"servidor_id":37,"id":40}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.9.113	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-04-11 15:54:18	2022-04-11 15:54:18
130	App\\Models\\User	1	created	App\\Models\\Servidor	38	[]	{"nome":"BRUNA MARIA MANTELLI MARQUE","nome_social":null,"cpf":"27408951865","rg":"287452621","nao_perturbe":"0","data_nascimento":"1978-05-28T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SAO PAULO","naturalidade_uf":"SP","nome_pai":"SIDNEY MARA MANTELLI MARQUES","nome_mae":"MAGDA MARA MANTELLI MARQUES","observacoes":"JURIDICO","estado_civil":1,"sexo":2,"id":38}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.6.253	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-04-11 16:29:04	2022-04-11 16:29:04
131	App\\Models\\User	1	created	App\\Models\\RegistroServidor	41	[]	{"cargo_id":19,"readaptado":"0","data_admissao":"2019-08-01T19:29:03.000000Z","unidadeorganizacional_id":"16","nivel_salarial_id":"13","numero":"368555","regime":1,"portaria_aposentadoria":null,"paridade":null,"servidor_id":38,"id":41}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.6.253	Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36	\N	2022-04-11 16:29:07	2022-04-11 16:29:07
132	App\\Models\\User	1	created	App\\Models\\Servidor	39	[]	{"nome":"FELIPE DE JESUS SILVA","nome_social":null,"cpf":"36973277802","rg":"450551179","nao_perturbe":"0","data_nascimento":"1989-02-17T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"CUBATAO","naturalidade_uf":"SP","nome_pai":null,"nome_mae":"RAIMUNDA DE JESUS SILVA","observacoes":null,"estado_civil":1,"sexo":1,"id":39}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.31.151	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.88 Safari/537.36	\N	2022-04-19 15:14:42	2022-04-19 15:14:42
133	App\\Models\\User	1	created	App\\Models\\RegistroServidor	42	[]	{"cargo_id":14,"readaptado":"0","data_admissao":"2019-08-01T18:14:41.000000Z","unidadeorganizacional_id":"53","nivel_salarial_id":"6","numero":"368456","regime":1,"portaria_aposentadoria":null,"paridade":null,"servidor_id":39,"id":42}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.31.151	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.88 Safari/537.36	\N	2022-04-19 15:14:45	2022-04-19 15:14:45
134	App\\Models\\User	1	created	App\\Models\\Servidor	40	[]	{"nome":"MARIA DO SOCORRO ALVES DE SOUSA","nome_social":null,"cpf":"07028112896","rg":"1.726.118-2","nao_perturbe":"0","data_nascimento":"1945-07-30T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"URUBURETAMA","naturalidade_uf":"CE","nome_pai":"LUIS ALVES DE SOUZA","nome_mae":"MARIA LOPES DE SOUZA","observacoes":null,"estado_civil":1,"sexo":2,"id":40}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.15.132	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.41 Safari/537.36	\N	2022-04-27 15:35:27	2022-04-27 15:35:27
135	App\\Models\\User	1	created	App\\Models\\RegistroServidor	43	[]	{"cargo_id":4,"readaptado":"0","data_admissao":"1989-01-13T17:35:26.000000Z","unidadeorganizacional_id":"50","nivel_salarial_id":"1","numero":"162446","regime":1,"portaria_aposentadoria":null,"paridade":null,"servidor_id":40,"id":43}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.15.132	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.41 Safari/537.36	\N	2022-04-27 15:35:30	2022-04-27 15:35:30
136	App\\Models\\User	1	created	App\\Models\\Servidor	41	[]	{"nome":"MARISA REQUEJO ROCHA","nome_social":null,"cpf":"10624133850","rg":"20.586.823-X","nao_perturbe":"0","data_nascimento":"1968-03-29T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"JOSE ROBERTO MIRANDA ROCHA","nome_mae":"EULAMPIA REQUEJO ROCHA","observacoes":null,"estado_civil":1,"sexo":2,"nivel_ensino":6,"id":41}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.90.231	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.54 Safari/537.36	\N	2022-05-05 10:40:29	2022-05-05 10:40:29
137	App\\Models\\User	1	created	App\\Models\\RegistroServidor	44	[]	{"cargo_id":19,"readaptado":"0","data_admissao":"2019-05-23T13:40:28.000000Z","unidadeorganizacional_id":"26","nivel_salarial_id":"13","numero":"367102","regime":1,"portaria_aposentadoria":null,"paridade":null,"servidor_id":41,"id":44}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.90.231	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.54 Safari/537.36	\N	2022-05-05 10:40:32	2022-05-05 10:40:32
138	App\\Models\\User	1	created	App\\Models\\Servidor	42	[]	{"nome":"KATIA REGINA ARAUJO DOMENES","nome_social":null,"cpf":"06993547813","rg":"18.991.379-4","nao_perturbe":"0","data_nascimento":"1967-08-15T03:00:00.000000Z","nacionalidade":"BRASILEIRA","naturalidade":"SANTOS","naturalidade_uf":"SP","nome_pai":"FRANCISCO DOMENES DONATON","nome_mae":"BEATRIZ ARAUJO DOMENES","observacoes":null,"estado_civil":3,"sexo":2,"id":42}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.45.249	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.54 Safari/537.36	\N	2022-05-05 11:04:33	2022-05-05 11:04:33
139	App\\Models\\User	1	created	App\\Models\\RegistroServidor	45	[]	{"cargo_id":23,"readaptado":"0","data_admissao":"1988-10-05T14:04:32.000000Z","unidadeorganizacional_id":"12","nivel_salarial_id":"15","numero":"231910","regime":1,"portaria_aposentadoria":null,"paridade":null,"servidor_id":42,"id":45}	http://dev-sindserv.herokuapp.com/admin/servidores	10.1.45.249	Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.54 Safari/537.36	\N	2022-05-05 11:04:36	2022-05-05 11:04:36
\.


--
-- Data for Name: cargos; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.cargos (id, nome, created_at, updated_at, nivel_salarial_id) FROM stdin;
1	AGENTE COMUNITARIO DE SAUDE	2022-02-14 15:07:32	2022-02-14 15:07:32	1
2	AGENTE DE COMBATE AS ENDEMIAS	2022-02-14 15:08:03	2022-02-14 15:08:03	1
3	AJUDANTE DE COZINHA	2022-02-14 15:08:26	2022-02-14 15:08:26	1
4	AUXILIAR DE SERVICOS GERAIS	2022-02-14 15:08:53	2022-02-14 15:08:53	1
5	AGENTE DE PORTARIA	2022-02-14 15:09:59	2022-02-14 15:09:59	2
6	ASCENSORISTA	2022-02-14 15:10:46	2022-02-14 15:10:46	2
7	OFICIAL DE CONTROLE ANIMAL	2022-02-14 15:11:23	2022-02-14 15:11:23	2
8	TRATADOR DE ANIMAIS	2022-02-14 15:13:24	2022-02-14 15:13:24	2
9	GUARDA MUNICIPAL I	2022-02-14 15:14:18	2022-02-14 15:14:18	5
10	AUXILIAR DE SAUDE BUCAL	2022-02-14 15:14:50	2022-02-14 15:15:26	6
11	INSPETOR DE ALUNOS	2022-02-14 15:19:08	2022-02-14 15:19:08	6
12	GUARDA MUNICIPAL II	2022-02-14 15:20:03	2022-02-14 15:20:03	7
13	INSPETOR DE ZOONOSES	2022-02-14 15:20:36	2022-02-14 15:20:36	8
14	AGENTE ADMINISTRATIVO	2022-02-14 15:21:16	2022-02-14 15:21:16	8
15	GUARDA MUNICIPAL III - INSPETOR	2022-02-14 15:22:00	2022-02-14 15:22:00	9
16	TECNICO DE RAIO X	2022-02-14 15:23:39	2022-02-14 15:23:39	9
17	SECRETARIO DE UNIDADE ESCOLAR	2022-02-14 15:24:17	2022-02-14 15:24:17	10
18	TECNICO DE ENFERMAGEM	2022-02-14 15:24:56	2022-02-14 15:24:56	10
19	PROFESSOR ADJUNTO I	2022-02-14 15:25:38	2022-02-14 15:25:38	13
20	PROFESSOR DE EDUCACAO BASICA I	2022-02-14 15:26:20	2022-02-14 15:26:20	12
21	ESPEC. DE EDUC. I - COORDENADOR PEDAGOGICO	2022-02-14 15:27:05	2022-02-14 15:27:05	15
22	PROFESSOR ADJUNTO II	2022-02-14 15:27:38	2022-02-14 15:27:38	16
23	PROFESSOR DE EDUCACAO BASICA II	2022-02-14 15:28:11	2022-02-14 15:28:11	15
24	ENFERMEIRO	2022-02-14 15:28:42	2022-02-14 15:28:42	17
25	ANALISTA DE SISTEMAS	2022-02-14 15:29:16	2022-02-14 15:29:16	18
26	BIOLOGO	2022-02-14 15:30:05	2022-02-14 15:30:05	18
27	MEDICO	2022-02-14 15:30:36	2022-02-14 15:30:36	19
28	AGENTE DE DEFESA CIVIL	2022-02-15 13:34:20	2022-02-15 13:34:20	6
\.


--
-- Data for Name: classificacoes_contas; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.classificacoes_contas (id, nome, plano_contas_id, created_at, updated_at) FROM stdin;
1	CALCULOS JUDICIAIS	4	2022-03-15 09:51:04	2022-03-15 09:51:04
2	CONTADOR	4	2022-03-15 09:51:39	2022-03-15 09:51:39
3	CONVENIO MEDICO / FUNCIONARIOS	4	2022-03-15 09:52:05	2022-03-15 09:52:05
4	CORREIOS	4	2022-03-15 09:52:35	2022-03-15 09:52:35
5	DENTISTAS	4	2022-03-15 09:53:00	2022-03-15 09:53:00
6	ESTACIONAMENTO	4	2022-03-15 09:53:24	2022-03-15 09:53:24
7	JORNALISTAS	4	2022-03-15 09:53:45	2022-03-15 09:53:45
8	LOCACAO DE VEICULO	4	2022-03-15 09:54:15	2022-03-15 09:54:15
9	LOCACAO STUDIO / SINDSERV	4	2022-03-15 09:54:43	2022-03-15 09:54:43
10	MANUT.VEICULO / MULTA / COMBUSTIVEL / PEDAGIO	4	2022-03-15 09:55:23	2022-03-15 09:55:23
11	PROVEDOR DE INTERNET	4	2022-03-15 09:57:48	2022-03-15 09:57:48
12	SALARIO / FUNCIONARIOS	4	2022-03-15 09:58:08	2022-03-15 09:58:44
13	TELEFONES	4	2022-03-15 09:59:09	2022-03-15 09:59:09
14	VALE TRANSPORTE / FUNCIONARIOS	4	2022-03-15 09:59:40	2022-03-15 10:00:06
15	VALE REFEICAO / FUNCIONARIOS	4	2022-03-15 10:00:38	2022-03-15 10:00:38
16	FGTS	5	2022-03-15 10:04:52	2022-03-15 10:04:52
17	INSS - FUNCIONARIOS / DENTISTAS	5	2022-03-15 10:05:10	2022-03-15 10:05:30
18	IR (FUNCIONARIOS)	5	2022-03-15 10:05:57	2022-03-15 10:05:57
19	IR (PREST.SERVIÇO)	5	2022-03-15 10:06:14	2022-03-15 10:06:14
20	IR (P.JURÍDICA)	5	2022-03-15 10:06:30	2022-03-15 10:06:30
21	ISS(PREST. DE SERVIÇO)	5	2022-03-15 10:06:46	2022-03-15 10:06:46
22	PIS / COFINS	5	2022-03-15 10:07:02	2022-03-15 10:07:02
23	PIS / FUNCIONÁRIOS	5	2022-03-15 10:07:24	2022-03-15 10:07:24
24	GPS-PCLTO RAT E FAP 32/58	5	2022-03-15 10:07:49	2022-03-15 10:07:49
25	ALARME, MONITORAMENTO	6	2022-03-15 10:09:03	2022-03-15 10:09:03
26	AUXILIO FUNERAL / ASSOCIADOS (01/22)	6	2022-03-15 10:09:20	2022-03-15 10:09:20
27	AUXILIO FUNERAL / DEP.ASSOCIADOS	6	2022-03-15 10:10:05	2022-03-15 10:10:05
28	SEGURO EQUIOPAMENTO	6	2022-03-15 10:10:35	2022-03-15 10:10:35
29	SEGURO EQUIPAMENTO	6	2022-03-15 10:10:55	2022-03-15 10:10:55
30	SEGURO/CONTRIBUTARIO	6	2022-03-15 10:11:30	2022-03-15 10:11:30
31	SEGURO DE VIDA/ASSOCIADOS	6	2022-03-15 10:12:53	2022-03-15 10:12:53
32	AR CONDICIONADO	7	2022-03-15 10:19:02	2022-03-15 10:19:02
33	COMPUTADORES	7	2022-03-15 10:19:18	2022-03-15 10:19:18
34	COPIADORAS	7	2022-03-15 10:19:32	2022-03-15 10:19:32
35	ELEVADOR	7	2022-03-15 10:19:48	2022-03-15 10:19:48
36	SUPORTE/FOLHA DE PAGAMENTO	7	2022-03-15 10:20:03	2022-03-15 10:20:03
37	TELEFONIA	7	2022-03-15 10:20:20	2022-03-15 10:20:20
38	ESCRITORIO	9	2022-03-15 10:21:29	2022-03-15 10:21:29
39	ODONTOLOGICO	9	2022-03-15 10:21:52	2022-03-15 10:21:52
40	LIMPEZA	9	2022-03-15 10:22:09	2022-03-15 10:22:09
41	EQUIPAMENTO INFORMATICA	9	2022-03-15 10:22:36	2022-03-15 10:22:36
42	BOLETINS	10	2022-03-15 10:24:47	2022-03-15 10:24:47
43	COMUNICADOS ATIVIDADES / SMS	10	2022-03-15 10:25:09	2022-03-15 10:25:09
44	DIAGRAMAÇÃO	10	2022-03-15 10:25:28	2022-03-15 10:25:28
45	EDITAIS	10	2022-03-15 10:25:44	2022-03-15 10:25:44
46	IMPULSIONAMENTO FACEBOOK	10	2022-03-15 10:25:59	2022-03-15 10:25:59
47	SOM / VÍDEO E AUDIO	10	2022-03-15 10:26:31	2022-03-15 10:26:31
48	XEROCOPIA DE MATERIAL	10	2022-03-15 10:26:46	2022-03-15 10:26:46
49	AGUA	11	2022-03-15 10:27:50	2022-03-15 10:27:50
50	LUZ	11	2022-03-15 10:28:06	2022-03-15 10:28:06
51	ATIVIDADES EVENTUAIS	13	2022-03-15 10:42:51	2022-03-15 10:42:51
52	DIVERSOS	13	2022-03-15 10:46:11	2022-03-15 10:46:11
\.


--
-- Data for Name: competencias_processos; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.competencias_processos (id, descricao, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: configuracoes; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.configuracoes (id, categoria, nome, valor, created_at, updated_at) FROM stdin;
1	AGENDAMENTOJURIDICO	DIAS_ENTRE_AGENDAMENTOS	90	2022-03-08 19:19:54	2022-03-15 17:12:29
2	AGENDAMENTOODONTOLOGICO	DIAS_ENTRE_AGENDAMENTOS	0	2022-03-08 19:19:55	2022-03-15 17:12:57
\.


--
-- Data for Name: contas_pagar_receber; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.contas_pagar_receber (id, descricao, valor, vencimento, status, created_at, updated_at, valor_pago, data_pagamento, numero_documento, forma_pagamento, recorrencia, tipo_despesa, tipo, responsavel_despesa, observacoes, caminho_documento, classificacao_conta_id, forma_recebimento, nota_fiscal) FROM stdin;
1	130006239	175.35	2021-02-01	2	2022-02-14 16:07:02	2022-02-14 16:18:35	175.35	2021-02-01	\N	\N	\N	\N	2	\N	\N	\N	\N	1	\N
2	130006239	1323.00	2022-03-02	2	2022-03-15 10:47:32	2022-03-15 10:47:32	1323.00	2022-03-02	\N	\N	\N	\N	2	\N	\N	\N	\N	1	\N
3	CLEUSA CONSORTI S MOREIRA	1323.00	2022-03-02	2	2022-03-15 10:51:24	2022-03-15 10:51:24	1323.00	2022-03-02	\N	1	1	1	1	\N	REF A MATERIAL DE LIMPEZA	\N	40	\N	015.124
4	13000623-9	294.10	2022-03-03	2	2022-03-15 10:52:52	2022-03-15 10:52:52	294.10	2022-03-03	\N	\N	\N	\N	2	\N	\N	\N	\N	1	\N
5	L L DE MARCO CUNHA	294.10	2022-03-03	2	2022-03-15 10:57:21	2022-03-15 10:57:21	294.10	2022-03-03	\N	1	\N	2	1	EMANOEL	REF A COMPRA DE CARTÃO SSD NOTBOOK QUE UTILIZA COM O TELEPRONPOTER	\N	41	\N	823
6	13000623-9	749.00	2022-03-04	2	2022-03-15 11:02:05	2022-03-15 11:02:05	749.00	2022-03-04	\N	\N	\N	\N	2	\N	\N	\N	\N	1	\N
7	VIVO	749.00	2022-03-04	2	2022-03-15 11:03:35	2022-03-15 11:03:35	749.00	2022-03-04	\N	1	1	1	1	\N	CONTA DE TELEFONE IP DEDICADO	\N	13	\N	\N
9	13000623-9	99.99	2022-03-04	2	2022-03-15 11:14:06	2022-03-15 11:14:06	99.99	2022-03-04	\N	\N	\N	\N	2	\N	\N	\N	\N	1	\N
10	VIVO	99.99	2022-03-04	2	2022-03-15 11:18:32	2022-03-15 11:18:32	99.99	2022-03-04	\N	1	1	1	1	\N	REF A INTERNET BANDA LARGA 1360034192	\N	13	\N	\N
11	13000623-9	50.00	2022-03-04	2	2022-03-15 11:26:05	2022-03-15 11:26:05	50.00	2022-03-04	\N	\N	\N	\N	2	\N	\N	\N	\N	1	\N
12	VIVO	50.00	2022-03-05	2	2022-03-15 11:28:41	2022-03-15 11:28:41	50.00	2022-03-04	\N	1	1	1	1	\N	CONTA DE TELEFONE - MONITORA DADOS	\N	13	\N	\N
\.


--
-- Data for Name: contatos; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.contatos (id, contatavel_id, contatavel_type, tipo, valor, created_at, updated_at, aceita_mala_direta, observacoes) FROM stdin;
130	34	App\\Models\\Servidor	2	(13) 98111-1742	2022-04-11 11:47:16	2022-04-11 11:47:16	t	\N
2	1	App\\Models\\UnidadeOrganizacional	1	(133	2022-02-14 14:55:57	2022-02-14 14:55:57	f	\N
3	2	App\\Models\\UnidadeOrganizacional	1	(13) 3226-8000	2022-02-14 15:04:58	2022-02-14 15:04:58	f	\N
4	3	App\\Models\\UnidadeOrganizacional	1	(13) 3211-1818	2022-02-14 15:08:12	2022-02-14 15:08:12	f	\N
5	5	App\\Models\\UnidadeOrganizacional	1	(13) 3201-8000	2022-02-14 15:20:18	2022-02-14 15:20:18	f	\N
6	6	App\\Models\\UnidadeOrganizacional	1	(13) 3201-5025	2022-02-14 15:24:09	2022-02-14 15:24:09	f	\N
7	7	App\\Models\\UnidadeOrganizacional	1	(13) 3201-5225	2022-02-14 15:27:56	2022-02-14 15:27:56	f	\N
8	8	App\\Models\\UnidadeOrganizacional	1	(13) 3201-2525	2022-02-14 15:31:15	2022-02-14 15:31:15	f	\N
9	9	App\\Models\\UnidadeOrganizacional	1	(13) 3201-5006	2022-02-14 15:38:02	2022-02-14 15:38:02	f	\N
10	12	App\\Models\\UnidadeOrganizacional	1	(13) 3234-9009	2022-02-14 15:55:15	2022-02-14 15:55:15	f	\N
29	1	App\\Models\\Funcionario	2	(13) 99135-8223	2022-02-15 09:09:00	2022-02-15 09:09:00	f	\N
12	13	App\\Models\\UnidadeOrganizacional	1	(13) 3231-1379	2022-02-14 16:01:04	2022-02-14 16:01:04	f	\N
13	15	App\\Models\\UnidadeOrganizacional	1	(13) 3235-1695	2022-02-14 16:05:47	2022-02-14 16:05:47	f	\N
30	2	App\\Models\\Funcionario	2	(13) 99794-3749	2022-02-15 09:14:41	2022-02-15 09:14:41	f	\N
31	3	App\\Models\\Funcionario	2	(13) 99717-4117	2022-02-15 09:18:32	2022-02-15 09:18:32	f	\N
69	15	App\\Models\\Servidor	2	(13) 98808-5184	2022-02-16 09:27:09	2022-02-16 09:27:09	t	\N
17	5	App\\Models\\Convenio	1	(13) 3228-8000	2022-02-14 16:35:04	2022-02-14 16:35:04	f	\N
18	6	App\\Models\\Convenio	1	(11) 3219-1008	2022-02-14 16:40:02	2022-02-14 16:40:02	f	\N
33	5	App\\Models\\Funcionario	2	(13) 98139-7902	2022-02-15 09:24:35	2022-02-15 09:24:35	f	\N
34	5	App\\Models\\Funcionario	3	MARCIA.PSI38@YAHOO.COM.BR	2022-02-15 09:24:36	2022-02-15 09:24:36	f	\N
131	34	App\\Models\\Servidor	3	ALINEALVES@SANTOS.SP.GOV.BR	2022-04-11 11:47:17	2022-04-11 11:47:17	t	\N
23	3	App\\Models\\Servidor	2	(13) 98153-3535	2022-02-14 16:58:12	2022-02-14 16:58:12	t	\N
24	27	App\\Models\\UnidadeOrganizacional	1	(13) 3202-9099	2022-02-14 17:00:39	2022-02-14 17:00:39	f	\N
25	4	App\\Models\\Servidor	2	(13) 99190-2182	2022-02-14 17:15:45	2022-02-14 17:15:45	t	\N
26	4	App\\Models\\Servidor	1	(13) 3561-6875	2022-02-14 17:15:45	2022-02-14 17:15:45	f	\N
70	16	App\\Models\\Servidor	2	(13) 99782-6536	2022-02-16 15:08:13	2022-02-16 15:08:13	f	\N
71	16	App\\Models\\Servidor	3	SIND_SERV@UOL.COM.BR	2022-02-16 15:08:14	2022-02-16 15:08:14	f	\N
35	4	App\\Models\\Funcionario	2	(13) 99123-2832	2022-02-15 09:25:24	2022-02-15 09:25:24	f	\N
36	4	App\\Models\\Funcionario	3	CRSCANHOTO@PROTONMAIL.COM	2022-02-15 09:25:25	2022-02-15 09:25:25	f	\N
37	6	App\\Models\\Servidor	2	(13) 99798-6785	2022-02-15 09:45:55	2022-02-15 09:45:55	t	\N
38	28	App\\Models\\UnidadeOrganizacional	1	(13) 3226-3344	2022-02-15 10:24:12	2022-02-15 10:24:12	f	\N
39	29	App\\Models\\UnidadeOrganizacional	1	(13) 3226-3344	2022-02-15 10:25:33	2022-02-15 10:25:33	f	\N
40	30	App\\Models\\UnidadeOrganizacional	1	(13) 3201-5296	2022-02-15 10:29:26	2022-02-15 10:29:26	f	\N
41	31	App\\Models\\UnidadeOrganizacional	1	(13) 3201-5000	2022-02-15 10:31:08	2022-02-15 10:31:08	f	\N
42	32	App\\Models\\UnidadeOrganizacional	1	(13) 3208-1000	2022-02-15 10:33:00	2022-02-15 10:33:00	f	\N
72	17	App\\Models\\Servidor	2	(13) 98181-2087	2022-02-17 09:49:54	2022-02-17 09:49:54	t	\N
73	17	App\\Models\\Servidor	1	(13) 3284-7521	2022-02-17 09:49:54	2022-02-17 09:49:54	f	\N
74	17	App\\Models\\Servidor	2	(13) 99727-5049	2022-02-17 09:49:55	2022-02-17 09:49:55	f	\N
75	18	App\\Models\\Servidor	2	(13) 99146-9899	2022-02-17 10:57:22	2022-02-17 10:57:22	t	\N
76	19	App\\Models\\Servidor	2	(13) 99678-0902	2022-02-17 11:11:16	2022-02-17 11:11:16	t	\N
77	19	App\\Models\\Servidor	1	(13) 3394-0313	2022-02-17 11:11:16	2022-02-17 11:11:16	f	\N
78	20	App\\Models\\Servidor	2	(13) 97414-4818	2022-02-17 11:52:49	2022-02-17 11:52:49	t	\N
97	5	App\\Models\\Servidor	2	(13) 99772-7965	2022-03-24 13:00:35	2022-03-24 13:00:35	t	\N
80	21	App\\Models\\Servidor	2	(11) 39915-9849	2022-02-17 12:52:00	2022-02-17 12:52:00	t	\N
54	8	App\\Models\\Servidor	2	(13) 99626-4716	2022-02-15 13:49:26	2022-02-15 13:49:26	t	\N
55	8	App\\Models\\Servidor	1	(13) 3299-6122	2022-02-15 13:49:26	2022-02-15 13:49:26	f	\N
56	8	App\\Models\\Servidor	3	ROSEVALDO2014@GMAIL.COM	2022-02-15 13:49:27	2022-02-15 13:49:27	t	\N
57	9	App\\Models\\Servidor	2	(13) 99723-2503	2022-02-15 15:09:45	2022-02-15 15:09:45	t	\N
58	7	App\\Models\\Servidor	2	(13) 99616-5179	2022-02-15 15:24:30	2022-02-15 15:24:30	t	\N
59	7	App\\Models\\Servidor	1	(13) 3225-6610	2022-02-15 15:24:30	2022-02-15 15:24:30	f	\N
60	7	App\\Models\\Servidor	2	(13) 99159-7401	2022-02-15 15:24:31	2022-02-15 15:24:31	t	\N
61	7	App\\Models\\Servidor	3	secretaria@sindservsantos.org.br	2022-02-15 15:24:32	2022-02-15 15:24:32	t	\N
62	7	App\\Models\\Servidor	3	sind_serv@uol.com.br	2022-02-15 15:24:32	2022-02-15 15:24:32	t	\N
63	10	App\\Models\\Servidor	2	(13) 99158-7779	2022-02-15 15:47:26	2022-02-15 15:47:26	t	\N
64	11	App\\Models\\Servidor	2	(13) 99655-3790	2022-02-15 16:01:03	2022-02-15 16:01:03	t	\N
65	12	App\\Models\\Servidor	2	(13) 99759-4316	2022-02-15 16:19:16	2022-02-15 16:19:16	t	\N
66	13	App\\Models\\Servidor	2	(13) 98822-8699	2022-02-15 16:30:34	2022-02-15 16:30:34	t	\N
67	1	App\\Models\\Herdeiro	2	(13) 98805-4433	2022-02-15 16:37:32	2022-02-15 16:37:32	f	\N
68	14	App\\Models\\Servidor	2	(13) 98121-7675	2022-02-15 16:53:07	2022-02-15 16:53:07	t	\N
82	47	App\\Models\\UnidadeOrganizacional	1	(13) 3201-5000	2022-02-17 13:20:19	2022-02-17 13:20:19	f	\N
85	23	App\\Models\\Servidor	2	(13) 99168-0004	2022-02-17 13:49:44	2022-02-17 13:49:44	t	\N
86	23	App\\Models\\Servidor	3	RECEGOFU@HOTMAIL.COM	2022-02-17 13:49:45	2022-02-17 13:49:45	t	\N
87	23	App\\Models\\Servidor	3	RECEGOFU@HOTMAIL.COM	2022-02-17 13:49:45	2022-02-17 13:49:45	t	\N
88	24	App\\Models\\Servidor	2	(13) 99776-8758	2022-02-17 14:35:13	2022-02-17 14:35:13	t	\N
89	24	App\\Models\\Servidor	3	DANIEL_EVARISTO@HOTMAIL.COM	2022-02-17 14:35:14	2022-02-17 14:35:14	t	\N
119	31	App\\Models\\Servidor	2	(13) 99762-0615	2022-03-25 11:39:14	2022-03-25 11:39:14	t	\N
120	31	App\\Models\\Servidor	3	LUIZANTONIOS@GMAIL.COM	2022-03-25 11:39:14	2022-03-25 11:39:14	t	\N
123	32	App\\Models\\Servidor	2	(13) 98191-6692	2022-03-25 13:07:09	2022-03-25 13:07:09	t	\N
90	25	App\\Models\\Servidor	2	(13) 98120-9639	2022-02-17 14:44:12	2022-02-17 14:44:12	t	\N
91	26	App\\Models\\Servidor	2	(13) 99638-1452	2022-02-18 09:28:12	2022-02-18 09:28:12	f	\N
92	26	App\\Models\\Servidor	3	M.SCHIAVETTI@GMAIL.COM	2022-02-18 09:28:13	2022-02-18 09:28:13	f	\N
93	27	App\\Models\\Servidor	2	(13) 99661-6486	2022-02-21 10:46:53	2022-02-21 10:46:53	t	\N
94	28	App\\Models\\Servidor	2	(13) 98180-8584	2022-02-21 11:02:56	2022-02-21 11:02:56	t	\N
95	22	App\\Models\\Servidor	2	(13) 99122-2170	2022-03-08 10:19:02	2022-03-08 10:19:02	t	\N
96	29	App\\Models\\Servidor	2	(13) 99155-9097	2022-03-08 13:35:21	2022-03-08 13:35:21	t	\N
98	5	App\\Models\\Servidor	2	(13) 99159-9592	2022-03-24 13:00:35	2022-03-24 13:00:35	f	\N
124	32	App\\Models\\Servidor	3	CELSOPEREIRACOSTA@GMAIL.COM	2022-03-25 13:07:10	2022-03-25 13:07:10	t	\N
125	33	App\\Models\\Servidor	2	(13) 98111-7579	2022-03-25 13:15:19	2022-03-25 13:15:19	t	\N
101	2	App\\Models\\Servidor	2	(13) 97412-2078	2022-03-24 13:36:50	2022-03-24 13:36:50	t	\N
102	2	App\\Models\\Servidor	1	(13) 3296-3428	2022-03-24 13:36:51	2022-03-24 13:36:51	f	\N
103	2	App\\Models\\Servidor	2	(13) 97401-2340	2022-03-24 13:36:51	2022-03-24 13:36:51	t	\N
126	33	App\\Models\\Servidor	3	MANDA.AC@HOTMAIL.COM	2022-03-25 13:15:20	2022-03-25 13:15:20	t	\N
105	1	App\\Models\\Servidor	2	(13) 99742-5399	2022-03-24 14:45:31	2022-03-24 14:45:31	t	\N
106	1	App\\Models\\Servidor	3	fafa.benjamim@gmail.com	2022-03-24 14:45:32	2022-03-24 14:45:32	t	\N
132	35	App\\Models\\Servidor	2	(13) 99783-7882	2022-04-11 14:55:14	2022-04-11 14:55:14	t	\N
133	35	App\\Models\\Servidor	3	MICHELJSILVSA1@GMAIL.COM	2022-04-11 14:55:15	2022-04-11 14:55:15	t	\N
127	30	App\\Models\\Servidor	2	(11) 99657-1962	2022-03-25 14:37:33	2022-03-25 14:37:33	t	\N
128	30	App\\Models\\Servidor	1	(13) 3228-7400	2022-03-25 14:37:33	2022-03-25 14:37:33	f	\N
129	30	App\\Models\\Servidor	3	ABDO_156@HOTMAIL.COM	2022-03-25 14:37:34	2022-03-25 14:37:34	t	\N
134	36	App\\Models\\Servidor	2	(13) 97411-4213	2022-04-11 15:35:11	2022-04-11 15:35:11	t	\N
135	36	App\\Models\\Servidor	1	(13) 3028-0689	2022-04-11 15:35:12	2022-04-11 15:35:12	f	RESIDENCIAL
136	36	App\\Models\\Servidor	3	NIVALDOVIEIRA2157@GMAIL.COM	2022-04-11 15:35:13	2022-04-11 15:35:13	t	\N
137	37	App\\Models\\Servidor	2	(13) 99660-7575	2022-04-11 15:54:17	2022-04-11 15:54:17	t	\N
138	37	App\\Models\\Servidor	3	GISELLEPERSONAL1@GMAIL.COM	2022-04-11 15:54:17	2022-04-11 15:54:17	t	\N
139	38	App\\Models\\Servidor	2	(13) 99709-9783	2022-04-11 16:29:05	2022-04-11 16:29:05	t	\N
140	38	App\\Models\\Servidor	3	BMMM2805@GMAIL.COM	2022-04-11 16:29:06	2022-04-11 16:29:06	t	\N
141	39	App\\Models\\Servidor	2	(13) 99771-0578	2022-04-19 15:14:44	2022-04-19 15:14:44	t	\N
142	39	App\\Models\\Servidor	3	FELIPEGDT@HOTMAIL.COM	2022-04-19 15:14:45	2022-04-19 15:14:45	t	\N
143	40	App\\Models\\Servidor	2	(13) 00000-0000	2022-04-27 15:35:28	2022-04-27 15:35:28	t	\N
144	40	App\\Models\\Servidor	1	(13) 3299-8937	2022-04-27 15:35:29	2022-04-27 15:35:29	f	\N
145	41	App\\Models\\Servidor	2	(13) 99730-9024	2022-05-05 10:40:31	2022-05-05 10:40:31	t	\N
146	41	App\\Models\\Servidor	3	MARI2_ROCHA@YAHOO.COM.BR	2022-05-05 10:40:31	2022-05-05 10:40:31	t	\N
147	42	App\\Models\\Servidor	2	(13) 00000-0000	2022-05-05 11:04:34	2022-05-05 11:04:34	t	\N
148	42	App\\Models\\Servidor	1	(13) 3224-7400	2022-05-05 11:04:34	2022-05-05 11:04:34	f	\N
149	42	App\\Models\\Servidor	3	KATIA.DOMENES@YAHOO.COM.BR	2022-05-05 11:04:35	2022-05-05 11:04:35	t	\N
150	54	App\\Models\\UnidadeOrganizacional	1	(13) 3213-5101	2022-05-24 11:37:02	2022-05-24 11:37:02	f	\N
151	55	App\\Models\\UnidadeOrganizacional	1	(13) 3231-6548	2022-05-24 11:39:29	2022-05-24 11:39:29	f	\N
152	56	App\\Models\\UnidadeOrganizacional	1	(13) 3299-8314	2022-05-24 11:41:20	2022-05-24 11:41:20	f	\N
153	57	App\\Models\\UnidadeOrganizacional	1	(13) 3225-5796	2022-05-24 11:43:37	2022-05-24 11:43:37	f	\N
154	58	App\\Models\\UnidadeOrganizacional	1	(13) 3222-6161	2022-05-24 11:45:15	2022-05-24 11:45:15	f	\N
\.


--
-- Data for Name: convenios; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.convenios (id, nome, cpf, cnpj, validade, desconto, especialidade_id, tipo, observacoes, created_at, updated_at, tipo_beneficiario) FROM stdin;
5	OSAN		21550042000176	2022-01-01	f	1	1	PLANO DE ASSISTENCIA FUNERAL, PARA ASSOCIADOS (SEM CUSTO)COM DIREITO A INCLUSÃO DE FILHOS SOLTEIROS DE QUALQUER IDADE E CONJUGE, MEDIANTE CONTRIBUIÇÃO DE R$2,97 POR DEPENDENTE INCLUSO, COM AUTORIZAÇÃO P/ DESC. EM FOLHA	2022-02-14 16:07:36	2022-02-14 16:35:03	2
6	SEGURO CONTRIBUITÁRIO		67865360000127	2022-01-01	f	2	2	SEGURO DE VIDA EM GRUPO - ESTE SEGURO FOI OFERECIDO NA ÉPOCA DO BANCO BMC, O SERVIDOR É DESCONTADO EM HOLERITE POR ESSE SEGURO.	2022-02-14 16:33:24	2022-02-14 16:40:01	1
\.


--
-- Data for Name: convenios_pessoas; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.convenios_pessoas (id, conveniavel_type, conveniavel_id, convenio_id, deleted_at, created_at, updated_at, motivo_exclusao) FROM stdin;
10	App\\Models\\Dependente	12	5	\N	2022-02-15 09:49:21	2022-02-15 09:49:21	\N
11	App\\Models\\Dependente	13	5	\N	2022-02-15 09:52:24	2022-02-15 09:52:24	\N
1	App\\Models\\Servidor	1	5	2022-02-14 16:14:16	2022-02-14 16:11:41	2022-02-14 16:14:16	1
5	App\\Models\\Dependente	2	5	\N	2022-02-14 16:52:02	2022-02-14 16:52:02	\N
12	App\\Models\\Dependente	14	5	\N	2022-02-15 09:53:08	2022-02-15 09:53:08	\N
4	App\\Models\\Dependente	3	5	2022-02-14 16:58:36	2022-02-14 16:51:00	2022-02-14 16:58:36	1
7	App\\Models\\Servidor	2	5	\N	2022-02-14 17:02:14	2022-02-14 17:02:14	\N
8	App\\Models\\Dependente	4	5	\N	2022-02-14 17:25:42	2022-02-14 17:25:42	\N
9	App\\Models\\Dependente	5	5	\N	2022-02-14 17:29:37	2022-02-14 17:29:37	\N
16	App\\Models\\Dependente	17	5	\N	2022-02-17 09:56:57	2022-02-17 09:56:57	\N
14	App\\Models\\Dependente	15	5	2022-02-15 13:57:58	2022-02-15 10:55:06	2022-02-15 13:57:58	1
18	App\\Models\\Dependente	20	5	2022-02-17 11:08:40	2022-02-17 10:38:23	2022-02-17 11:08:40	1
6	App\\Models\\Dependente	3	5	2022-02-21 11:25:22	2022-02-14 17:01:05	2022-02-21 11:25:22	1
20	App\\Models\\Servidor	15	5	2022-02-17 11:15:00	2022-02-17 10:41:52	2022-02-17 11:15:00	2
27	App\\Models\\Servidor	31	6	\N	2022-04-11 11:21:05	2022-04-11 11:21:05	\N
21	App\\Models\\Servidor	15	6	2022-02-17 11:15:00	2022-02-17 10:42:11	2022-02-17 11:15:00	2
28	App\\Models\\Dependente	30	5	\N	2022-04-11 11:22:39	2022-04-11 11:22:39	\N
29	App\\Models\\Dependente	31	5	\N	2022-04-11 11:51:14	2022-04-11 11:51:14	\N
17	App\\Models\\Dependente	18	5	2022-02-17 11:15:00	2022-02-17 10:37:22	2022-02-17 11:15:00	2
2	App\\Models\\Servidor	1	6	\N	2022-02-14 16:36:00	2022-03-24 15:35:27	\N
19	App\\Models\\Dependente	19	5	2022-02-17 11:15:01	2022-02-17 10:40:30	2022-02-17 11:15:01	2
30	App\\Models\\Servidor	35	5	\N	2022-04-11 15:10:53	2022-04-11 15:10:53	\N
24	App\\Models\\Servidor	18	5	2022-02-17 11:25:36	2022-02-17 11:04:38	2022-02-17 11:25:36	2
15	App\\Models\\Servidor	7	6	\N	2022-02-15 10:55:52	2022-03-08 13:00:22	\N
23	App\\Models\\Dependente	21	5	2022-02-17 11:25:36	2022-02-17 11:03:32	2022-02-17 11:25:36	2
3	App\\Models\\Dependente	1	5	\N	2022-02-14 16:37:18	2022-03-24 15:35:28	\N
22	App\\Models\\Dependente	22	5	2022-02-17 11:25:37	2022-02-17 11:02:32	2022-02-17 11:25:37	2
13	App\\Models\\Dependente	16	5	\N	2022-02-15 10:54:25	2022-03-08 13:00:24	\N
31	App\\Models\\Dependente	32	5	\N	2022-04-11 15:12:26	2022-04-11 15:12:26	\N
32	App\\Models\\Servidor	36	5	\N	2022-04-11 15:40:40	2022-04-11 15:40:40	\N
33	App\\Models\\Dependente	35	5	\N	2022-04-11 15:41:54	2022-04-11 15:41:54	\N
34	App\\Models\\Dependente	34	5	\N	2022-04-11 15:42:52	2022-04-11 15:42:52	\N
35	App\\Models\\Dependente	36	5	\N	2022-05-05 10:44:59	2022-05-05 10:44:59	\N
25	App\\Models\\Dependente	30	5	2022-03-25 11:26:51	2022-03-25 09:37:51	2022-03-25 11:26:51	1
36	App\\Models\\Servidor	41	6	\N	2022-05-05 10:45:43	2022-05-05 10:45:43	\N
26	App\\Models\\Servidor	31	6	2022-03-25 11:29:52	2022-03-25 09:38:35	2022-03-25 11:29:52	1
\.


--
-- Data for Name: dependentes; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.dependentes (id, nome, data_nascimento, grau_parentesco, dependivel_id, dependivel_type, created_at, updated_at, data_admissao, sexo, ativo, observacoes, especial, falecido) FROM stdin;
1	FRANCISCO BENJAMIM FILHO	1950-06-12	2	1	App\\Models\\Servidor	2022-02-14 15:55:34	2022-02-14 15:55:34	2013-04-11	1	t	APRESENTOU CERTIDAO CASAMENTO E RG	f	f
2	VINICIUS SALGUEIRO FERREIRA	1993-02-09	1	2	App\\Models\\Servidor	2022-02-14 16:49:17	2022-02-14 16:49:17	2022-02-14	1	t	\N	f	f
6	RAUL ARROJO MARTINEZ	1999-07-03	1	4	App\\Models\\Servidor	2022-02-14 17:24:17	2022-02-14 17:24:17	2022-02-14	1	t	FALTA DOCUMENTAÇÃO	f	f
7	ANTONIO	1976-05-19	2	1	App\\Models\\Funcionario	2022-02-15 09:11:36	2022-02-15 09:11:36	2022-02-15	1	t	\N	f	f
4	ALICE DE ARAUJO DIAS	2012-06-09	1	4	App\\Models\\Servidor	2022-02-14 17:18:04	2022-02-14 17:24:57	2022-02-14	2	t	COPIA DA CERTIDÃO DE NASCIMENTO	f	f
5	DOUGLAS ALVES DIAS	1974-12-17	2	4	App\\Models\\Servidor	2022-02-14 17:23:16	2022-02-14 17:26:42	2022-02-14	1	t	COPIA DA DECLARAÇÃO ESCRITURA UNIÃO ESTÁVEL	f	f
8	BEATRIZ CALAZANS	2003-08-17	1	2	App\\Models\\Funcionario	2022-02-15 09:15:42	2022-02-15 09:15:42	2022-02-15	2	t	\N	f	f
9	LAURA BRITO	2017-03-25	1	3	App\\Models\\Funcionario	2022-02-15 09:19:40	2022-02-15 09:19:40	2022-02-15	2	t	\N	f	f
10	MARIANA BRITO	2020-02-20	1	3	App\\Models\\Funcionario	2022-02-15 09:20:21	2022-02-15 09:20:21	2022-02-15	2	t	\N	f	f
11	MARCO ANTONIO	1980-08-26	2	3	App\\Models\\Funcionario	2022-02-15 09:21:04	2022-02-15 09:21:04	2022-02-15	1	t	\N	f	f
12	MIQUEIAS JOSE DOS SANTOS	1974-12-04	2	6	App\\Models\\Servidor	2022-02-15 09:48:39	2022-02-15 09:48:39	2022-02-15	1	t	APRESENTOU CERETIDÃO DE UNIÃO ESTÁVEL E RG	f	f
13	FELIPE GABRIEL DOS SANTOS SOUZA	2005-05-13	1	6	App\\Models\\Servidor	2022-02-15 09:50:37	2022-02-15 09:50:37	2022-02-15	1	t	APRESENTOU RG	f	f
14	RAFAEL HENRIQUE DOS SANTOS SOUZA	2004-12-10	1	6	App\\Models\\Servidor	2022-02-15 09:51:45	2022-02-15 09:51:45	2022-02-15	1	t	APRESENTOU RG	f	f
15	ELIVETE CERESSO DE A. VIEIRA	1965-05-27	2	7	App\\Models\\Servidor	2022-02-15 10:53:08	2022-02-15 10:53:08	2022-02-15	2	t	\N	f	f
16	DRIELLY ANDRADE VIEIRA	1995-04-25	1	7	App\\Models\\Servidor	2022-02-15 10:53:49	2022-02-15 10:53:49	2022-02-15	2	t	\N	f	f
17	CARLOS MORAES	1966-10-19	2	17	App\\Models\\Servidor	2022-02-17 09:53:35	2022-02-17 09:53:35	2022-02-17	1	t	FALTA DOCUMENTOS	f	f
18	MARIA JOSE DA SILVA E SILVA	1968-07-28	1	15	App\\Models\\Servidor	2022-02-17 10:32:47	2022-02-17 10:32:47	2022-02-17	2	t	\N	f	f
19	SERGIO RODRIGO DA SILVA	1992-02-28	1	15	App\\Models\\Servidor	2022-02-17 10:33:30	2022-02-17 10:33:30	2022-02-17	1	t	\N	f	f
21	TANIA GIMENES ALVES BARBOSA PINTO	1955-04-09	2	18	App\\Models\\Servidor	2022-02-17 11:00:35	2022-02-17 11:00:35	2022-02-17	2	t	COPIA DO CERTIDÃO DE CASAMENTO E RG	f	f
22	SERGIO TEIXEIRA PINTO JUNIOR	1987-08-10	1	18	App\\Models\\Servidor	2022-02-17 11:01:50	2022-02-17 11:01:50	2022-02-17	1	t	COPIA DO RG	f	f
20	ISABELA DA SILVA	1995-10-13	1	15	App\\Models\\Servidor	2022-02-17 10:36:18	2022-02-17 11:07:32	2022-02-17	2	t	COPIA DO RG	f	t
23	HENRIQUE AUGUSTO BERNARDO JUNIOR	1969-01-09	1	20	App\\Models\\Servidor	2022-02-17 12:08:04	2022-02-17 12:08:04	2022-02-16	1	t	COPIA DO RG E CERTIDÃO DE CASAMENTO	f	f
24	GABRIELA DE PAULA BERNARDO	1993-04-16	1	20	App\\Models\\Servidor	2022-02-17 12:13:07	2022-02-17 12:13:07	2022-02-16	2	t	COPIA DO RG	f	f
25	HELIZA DE PAULA BERNARDO	1997-02-15	1	20	App\\Models\\Servidor	2022-02-17 12:14:05	2022-02-17 12:14:05	2022-02-16	2	t	COPIA DO RG	f	f
26	PEDO HENRIQUE DE PAULA BERNARDO	2000-05-11	1	20	App\\Models\\Servidor	2022-02-17 12:14:58	2022-02-17 12:14:58	2022-02-16	1	t	COPIA DO RG	f	f
27	ALEXANDRE DE OLIVEIRA SARAIVA	1972-03-19	2	21	App\\Models\\Servidor	2022-02-17 12:39:47	2022-02-17 12:39:47	2002-02-20	1	t	\N	f	f
28	ANA CAROLINA COSTA SARAIVA	1997-07-26	1	21	App\\Models\\Servidor	2022-02-17 12:40:51	2022-02-17 12:40:51	2002-06-20	2	t	\N	f	f
29	MARIA LUIZA COSTA SARAIVA	2004-06-05	1	21	App\\Models\\Servidor	2022-02-17 12:41:35	2022-02-17 12:41:35	2002-06-20	2	t	\N	f	f
30	LUZIA MARIA DAS NEVES SILVA	1973-12-25	2	31	App\\Models\\Servidor	2022-03-25 09:37:06	2022-03-25 09:37:06	2022-03-25	2	t	\N	f	f
3	GABRIEL SALGUEIRO FERREIRA	1990-05-04	1	2	App\\Models\\Servidor	2022-02-14 16:50:12	2022-02-21 11:23:05	2022-02-14	1	t	FALECEU EM 20/02/2021- FUNERAL FEITO PELA OSAN	f	t
31	ANDERSON FONTES PEREIRA	1977-08-23	2	34	App\\Models\\Servidor	2022-04-11 11:50:36	2022-04-11 11:50:36	2022-04-11	1	t	APRESENTOU CERT. CASAMENTO E CNH	f	f
32	MARCELA JESUS DE OLIVEIRA	1986-05-25	2	35	App\\Models\\Servidor	2022-04-11 15:03:00	2022-04-11 15:03:00	2022-04-11	2	t	COPIA DO CNH E CERTIDAO DE CASAMENTO	f	f
36	JOSE RICARDO ROCHA	1962-04-05	2	41	App\\Models\\Servidor	2022-05-05 10:44:25	2022-05-05 10:44:25	2022-05-05	1	t	APRESENTOU CERT. CASAMENTO E RG	f	f
34	ELISETE REGINA DE OLIVEIRA MELO	1963-02-09	2	36	App\\Models\\Servidor	2022-04-11 15:38:47	2022-04-11 15:38:47	2022-04-11	2	t	COPIA DA CERTIDAO DE CASAMENTO	f	f
35	BRUNA DE OLIVEIRA MELO	1994-03-20	1	36	App\\Models\\Servidor	2022-04-11 15:39:45	2022-04-11 15:39:45	2022-04-11	2	t	COPIA RG	f	f
\.


--
-- Data for Name: documentos_associados; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.documentos_associados (id, tipo_documento_id, servidor_id, caminho, observacoes, created_at, updated_at) FROM stdin;
1	2	2	documentos-associados/2/PnXcR1y6oEJn6wgM1TXI5pqlB7oOnlRF2jEKsnsm.pdf	\N	2022-03-08 09:48:26	2022-03-08 09:48:26
2	2	31	documentos-associados/31/KlR5k8c7TGPKihJiowd2cateoegqnRY6oSh5a5T7.pdf	\N	2022-03-25 11:13:53	2022-03-25 11:13:53
3	1	5	documentos-associados/5/0N2kSkRZDtXrzWnVWHn2voHv4uLA79CYLJC5M24V.pdf	\N	2022-03-31 11:19:23	2022-03-31 11:19:23
4	3	34	documentos-associados/34/4OZYspzwImEitHIKmpoc7Lq72rpov1iou9OZhp8X.pdf	\N	2022-04-11 14:01:46	2022-04-11 14:01:46
\.


--
-- Data for Name: enderecos; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.enderecos (id, cep, numero, logradouro, bairro, cidade, estado, observacoes, enderecavel_id, enderecavel_type, created_at, updated_at, aceita_mala_direta, complemento) FROM stdin;
1	11714040	1757	Rua Clodoardo Amaral	Ribeirópolis	Praia Grande	SP	\N	1	App\\Models\\Servidor	2022-02-14 15:00:59	2022-02-14 15:00:59	t	CASA 1
2	11010100	25	PÇA DOS ANDRADAS	CENTRO	SANTOS	SP	\N	3	App\\Models\\UnidadeOrganizacional	2022-02-14 15:08:13	2022-02-14 15:08:13	f	\N
3	11010260	0	Praça Marquês de Monte Alegre	Valongo	Santos	SP	\N	5	App\\Models\\UnidadeOrganizacional	2022-02-14 15:20:19	2022-02-14 15:20:19	f	\N
4	11015090	217	Rua Xavier Pinheiro	VILA MATIAS	SANTOS	SP	\N	15	App\\Models\\UnidadeOrganizacional	2022-02-14 16:05:48	2022-02-14 16:05:48	f	\N
5	11010151	165	Rua Quinze de Novembro	Centro	Santos	SP	\N	5	App\\Models\\Convenio	2022-02-14 16:07:38	2022-02-14 16:07:38	f	\N
6	11320200	215	Avenida Manoel da Nóbrega	Itararé	São Vicente	SP	\N	2	App\\Models\\Servidor	2022-02-14 16:45:41	2022-02-14 16:45:41	t	APTO E11
7	11013151	225	Rua Amador Bueno	Centro	Santos	SP	\N	27	App\\Models\\UnidadeOrganizacional	2022-02-14 17:00:40	2022-02-14 17:00:40	f	\N
8	11320160	198	Rua Onze de Junho	Itararé	São Vicente	SP	\N	3	App\\Models\\Servidor	2022-02-14 17:02:37	2022-02-14 17:02:37	t	APTO 23-A
9	11380480	109	Rua General San Martin	Jardim Independência	São Vicente	SP	\N	4	App\\Models\\Servidor	2022-02-14 17:15:47	2022-02-14 17:15:47	t	CASA 09
10	11020060	4	Rua Cidade de Antióquia	Macuco	Santos	SP	\N	5	App\\Models\\Servidor	2022-02-14 17:23:50	2022-02-14 17:23:50	t	ALTOS
11	11088280	147	Rua José Casado Fernandes	Rádio Club	Santos	SP	\N	1	App\\Models\\Funcionario	2022-02-15 09:09:01	2022-02-15 09:09:01	f	\N
12	11081225	294	Rua Quatro	Morro da Penha	Santos	SP	\N	2	App\\Models\\Funcionario	2022-02-15 09:14:43	2022-02-15 09:14:43	f	\N
13	11082780	2304	Rua Santa Clara	Morro de São Bento	Santos	SP	\N	3	App\\Models\\Funcionario	2022-02-15 09:18:34	2022-02-15 09:18:34	f	\N
14	11070400	10	Rua Godofredo Fraga	Marapé	Santos	SP	\N	6	App\\Models\\Servidor	2022-02-15 09:45:57	2022-02-15 09:45:57	t	APTO. 153-C
15	11013310	0	Praça Iguatemi Martins	Vila Nova	Santos	SP	\N	28	App\\Models\\UnidadeOrganizacional	2022-02-15 10:24:13	2022-02-15 10:24:13	f	\N
16	11013310	0	Praça Iguatemi Martins	Vila Nova	Santos	SP	\N	29	App\\Models\\UnidadeOrganizacional	2022-02-15 10:25:34	2022-02-15 10:25:34	f	\N
17	11013002	246	Rua João Pessoa	Paquetá	Santos	SP	\N	30	App\\Models\\UnidadeOrganizacional	2022-02-15 10:29:27	2022-02-15 10:29:27	f	\N
18	11010000	0	Praça Visconde de Mauá	Centro	Santos	SP	\N	31	App\\Models\\UnidadeOrganizacional	2022-02-15 10:31:09	2022-02-15 10:31:09	f	\N
19	11013550	140	Avenida Rangel Pestana	Vila Matias	Santos	SP	\N	32	App\\Models\\UnidadeOrganizacional	2022-02-15 10:33:01	2022-02-15 10:33:01	f	\N
20	11065290	7	Rua Antônio Ribeirão	José Menino	Santos	SP	\N	7	App\\Models\\Servidor	2022-02-15 10:43:50	2022-02-15 10:43:50	t	APTO. 1003
21	11013360	1	Praça Tenente Mauro Batista Miranda	Vila Nova	Santos	SP	\N	34	App\\Models\\UnidadeOrganizacional	2022-02-15 11:36:12	2022-02-15 11:36:12	f	\N
22	11013002	0	Rua João Pessoa	Paquetá	Santos	SP	\N	35	App\\Models\\UnidadeOrganizacional	2022-02-15 13:25:20	2022-02-15 13:25:20	f	\N
23	11010000	0	Praça Visconde de Mauá	Centro	Santos	SP	\N	36	App\\Models\\UnidadeOrganizacional	2022-02-15 13:26:34	2022-02-15 13:26:34	f	\N
24	11013550	140	Avenida Rangel Pestana	Vila Matias	Santos	SP	\N	37	App\\Models\\UnidadeOrganizacional	2022-02-15 13:28:06	2022-02-15 13:28:06	f	\N
25	11013550	140	Avenida Rangel Pestana	Vila Matias	Santos	SP	\N	38	App\\Models\\UnidadeOrganizacional	2022-02-15 13:39:59	2022-02-15 13:39:59	f	\N
26	11090300	0	RUA DOIS - BLOCO C	ILHEU ALTO	SANTOS	SP	\N	8	App\\Models\\Servidor	2022-02-15 13:49:28	2022-02-15 13:49:28	t	APTO. 31
27	11013550	140	Avenida Rangel Pestana	Vila Matias	Santos	SP	\N	44	App\\Models\\UnidadeOrganizacional	2022-02-15 15:03:57	2022-02-15 15:03:57	f	\N
28	11040020	380	Rua Prefeito Antenor Bue	Embaré	Santos	SP	\N	9	App\\Models\\Servidor	2022-02-15 15:09:48	2022-02-15 15:09:48	t	AP. 83
29	11380600	618	Rua Doutor Fernando Costa	Vila Valença	São Vicente	SP	\N	10	App\\Models\\Servidor	2022-02-15 15:47:28	2022-02-15 15:47:28	t	AP. 21
64	11040260	234	Rua Ministro João Mendes	Embaré	Santos	SP	\N	42	App\\Models\\Servidor	2022-05-05 11:04:37	2022-05-05 11:04:37	t	APTO. 01
31	11088450	123	Caminho São Sebastião	Rádio Club	Santos	SP	\N	12	App\\Models\\Servidor	2022-02-15 16:19:18	2022-02-15 16:19:18	t	\N
32	11013350	33	Rua Sete de Setembro	Vila Nova	Santos	SP	\N	13	App\\Models\\Servidor	2022-02-15 16:30:36	2022-02-15 16:30:36	t	\N
33	11065201	132	Avenida Presidente Wilson	José Menino	Santos	SP	\N	1	App\\Models\\Herdeiro	2022-02-15 16:37:32	2022-02-15 16:37:32	f	APTO. 809 BL. 02
34	11040100	84	Rua Delphin Moreira	Embaré	Santos	SP	\N	14	App\\Models\\Servidor	2022-02-15 16:53:09	2022-02-15 16:53:09	t	AP. 26
35	11080180	15	Rua Padre Anchieta	Morro de Nova Cintra	Santos	SP	\N	15	App\\Models\\Servidor	2022-02-16 09:27:11	2022-02-16 09:27:11	t	\N
36	11075721	218	Rua Teixeira de Freitas	CAMPO GRANDE	SANTOS	SP	\N	17	App\\Models\\Servidor	2022-02-17 09:49:57	2022-02-17 09:49:57	t	APTO. 36
37	11015420	149	Rua Pércio de Queiros Filho	Encruzilhada	Santos	SP	\N	18	App\\Models\\Servidor	2022-02-17 10:57:24	2022-02-17 10:57:24	t	APTO. 02
38	11030395	2	Rua Professor Paulo Augusto Bueno Wolf	Ponta da Praia	Santos	SP	\N	19	App\\Models\\Servidor	2022-02-17 11:11:18	2022-02-17 11:11:18	t	APTO. 12 BLOCO B
39	11020000	416	Avenida Afonso Pena	BOQUEIRÃO	SANTOS	SP	\N	20	App\\Models\\Servidor	2022-02-17 11:52:51	2022-02-17 11:52:51	t	APTO. 63
40	11390360	191	Rua Salvador Malaquias Leal	CATIAPOA	SÃO VICENTE	SP	\N	21	App\\Models\\Servidor	2022-02-17 12:36:06	2022-02-17 12:36:06	t	APTO 35
41	11060000	81	Avenida Ana Costa	Vila Matias	Santos	SP	\N	22	App\\Models\\Servidor	2022-02-17 13:06:18	2022-02-17 13:06:18	t	APTO. 14
42	11010000	0	Praça Visconde de Mauá	Centro	Santos	SP	\N	47	App\\Models\\UnidadeOrganizacional	2022-02-17 13:20:20	2022-02-17 13:20:20	f	\N
43	11010000	0	Praça Visconde de Mauá	Centro	Santos	SP	\N	48	App\\Models\\UnidadeOrganizacional	2022-02-17 13:21:50	2022-02-17 13:21:50	f	\N
45	11010150	183	Rua Quinze de Novembro	Centro	Santos	SP	\N	50	App\\Models\\UnidadeOrganizacional	2022-02-17 13:25:25	2022-02-17 13:25:25	f	\N
44	11010150	183	Rua Quinze de Novembro	Centro	Santos	SP	\N	49	App\\Models\\UnidadeOrganizacional	2022-02-17 13:22:58	2022-02-17 13:26:24	f	\N
46	11010080	25	Rua Dom Pedro II	Centro	Santos	SP	\N	51	App\\Models\\UnidadeOrganizacional	2022-02-17 13:28:30	2022-02-17 13:28:30	f	\N
47	11065200	120	Avenida Presidente Wilson	Gonzaga	Santos	SP	\N	23	App\\Models\\Servidor	2022-02-17 13:38:59	2022-02-17 13:38:59	t	APTO. 15
48	11325040	143	Rua Papa João XXIII	Japuí	São Vicente	SP	\N	24	App\\Models\\Servidor	2022-02-17 14:35:15	2022-02-17 14:35:15	t	\N
49	11320400	61	Alameda Ari Barroso	Ilha Porchat	São Vicente	SP	\N	25	App\\Models\\Servidor	2022-02-17 14:44:14	2022-02-17 14:44:14	t	APTO 515
50	11045003	557	Avenida Conselheiro Nébias	Boqueirão	Santos	SP	\N	27	App\\Models\\Servidor	2022-02-21 10:46:55	2022-02-21 10:46:55	t	APTO 42
51	11360070	105	Rua Tamoios	Parque São Vicente	São Vicente	SP	\N	28	App\\Models\\Servidor	2022-02-21 11:02:59	2022-02-21 11:02:59	t	APTO 21
52	05574440	32	Travessa Cachoeira do Arrependido	Conjunto Promorar Raposo Tavares	São Paulo	SP	\N	30	App\\Models\\Servidor	2022-03-24 15:46:05	2022-03-24 15:46:05	t	APTO. 34-B
53	11085560	283	Rua Marcelo Martins Vicente	Caneleira	Santos	SP	\N	31	App\\Models\\Servidor	2022-03-25 09:34:11	2022-03-25 09:34:11	t	FRENTE
54	11089110	528	Rua Adriano de Campos Tourinho	Santa Maria	Santos	SP	\N	32	App\\Models\\Servidor	2022-03-25 13:05:32	2022-03-25 13:05:32	t	\N
55	11040271	365	Rua Vergueiro Steidel	Aparecida	SANTOS	SP	333 RUA FLAMINIO LEVY	33	App\\Models\\Servidor	2022-03-25 13:15:22	2022-03-25 13:15:22	t	APTO. 103 PT. 02
56	11065200	136	Avenida Presidente Wilson	Gonzaga	Santos	SP	\N	34	App\\Models\\Servidor	2022-04-11 11:47:19	2022-04-11 11:47:19	t	APTO. 135
57	11070400	10	Rua Godofredo Fraga	Marapé	Santos	SP	\N	35	App\\Models\\Servidor	2022-04-11 14:55:17	2022-04-11 14:55:17	t	AP. 154 TORRE DALIA
58	11085010	131	Rua Professora Maria Neusa Cunha	SABOÓ	Santos	SP	\N	36	App\\Models\\Servidor	2022-04-11 15:35:15	2022-04-11 15:35:15	t	BL. E AP. 32
59	11025020	255	Rua Torres Homem	Boqueirão	Santos	SP	\N	37	App\\Models\\Servidor	2022-04-11 15:54:20	2022-04-11 15:54:20	t	AP. 82
60	11075340	82	RIO DE JANEIRO	VILA BELMIRO	SANTOS	SP	\N	38	App\\Models\\Servidor	2022-04-11 16:29:08	2022-04-11 16:29:08	t	AP. 86
61	11534540	270	AVENIDA FERNANDO SANTOS OLIVEIRA	JD. NOVA REPUBLICA	CUBATAO	SP	\N	39	App\\Models\\Servidor	2022-04-19 15:14:47	2022-04-19 15:14:47	t	APTO. 12 BL. J3
30	11030320	42	Rua Thiago Tacão	Ponta da Praia	Santos	SP	\N	11	App\\Models\\Servidor	2022-02-15 16:01:05	2022-04-27 15:22:53	t	AP. 23
62	11088180	91	Rua Vereador Alvaro Guimarães	Rádio Club	SANTOS	SP	APTO. 41-A	40	App\\Models\\Servidor	2022-04-27 15:35:31	2022-04-27 15:35:31	t	APTO. 11
63	11320201	451	Avenida Manoel da Nóbrega	Itararé	São Vicente	SP	\N	41	App\\Models\\Servidor	2022-05-05 10:40:34	2022-05-05 10:40:34	t	APTO. 6-D
\.


--
-- Data for Name: especialidades_convenios; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.especialidades_convenios (id, nome, created_at, updated_at) FROM stdin;
1	ASSISTÊNCIA FUNERAL	2022-02-06 15:33:31	2022-02-14 16:28:36
2	SEGURO DE VIDA EM GRUPO	2022-02-14 16:29:01	2022-02-14 16:29:01
\.


--
-- Data for Name: feriados; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.feriados (id, titulo, data_inicio, data_fim, deleted_at, created_at, updated_at) FROM stdin;
1	CARNAVAL	2022-03-02	2022-03-02	\N	2022-02-15 16:41:43	2022-02-15 16:41:43
2	PONTO FACULTATIVO	2022-02-28	2022-02-28	\N	2022-02-15 16:42:50	2022-02-15 16:42:50
3	PONTO FACULTATIVO	2022-03-01	2022-03-01	\N	2022-02-15 16:43:20	2022-02-15 16:43:20
\.


--
-- Data for Name: funcionarios; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.funcionarios (id, nome, funcao, cpf, rg, cnh, data_nascimento, sexo, observacoes, created_at, updated_at, user_id) FROM stdin;
1	APARECIDA DORALICE DE LIMA	FAXINEIRA	04494160890	157374324	\N	1967-11-15	2	\N	2022-02-15 09:08:58	2022-02-15 09:08:58	\N
3	KELLY CRISTINA DE BRITO ABENZA	ENCARREGADO DE TESOURARIA	33402848813	271653851	\N	1986-03-21	1	\N	2022-02-15 09:18:31	2022-02-15 09:18:31	\N
5	MARCIA ESTER CALDAS DOS SANTOS	DIRETORA SINDICAL	25288775877	25003970	\N	1975-06-07	2	CADASTRO P/ AGENDA DIRETORIA	2022-02-15 09:24:34	2022-02-15 09:24:34	\N
4	CASSIO RAIMUNDO SIMOES CANHOTO	DIRETOR SINDICAL	28457123831	32102880	\N	1980-05-22	1	CADASTRO P/ AGENDA DIRETORIA	2022-02-15 09:22:48	2022-02-15 09:25:23	\N
2	ALESSANDRA CALAZANS DE FREITAS	ASSISTENTE ADMINISTRATIVO	30949359823	422374714	\N	1981-10-03	2	\N	2022-02-15 09:14:40	2022-02-17 13:04:44	2
\.


--
-- Data for Name: herdeiros; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.herdeiros (id, nome, servidor_id, created_at, updated_at) FROM stdin;
1	MARIA APARECIDA AUGUSTO	13	2022-02-15 16:37:31	2022-02-15 16:37:31
\.


--
-- Data for Name: horarios_trabalho; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.horarios_trabalho (id, trabalhavel_id, trabalhavel_type, dia_semana, inicio, fim, created_at, updated_at) FROM stdin;
1	2	App\\Models\\PrestadorServico	SEGUNDA	08:00:00	12:00:00	2022-02-15 09:29:17	2022-02-15 09:29:17
2	2	App\\Models\\PrestadorServico	SEGUNDA	14:00:00	18:00:00	2022-02-15 09:29:17	2022-02-15 09:29:17
3	2	App\\Models\\PrestadorServico	QUARTA	08:00:00	12:00:00	2022-02-15 09:29:18	2022-02-15 09:29:18
6	3	App\\Models\\PrestadorServico	SEXTA	08:00:00	12:00:00	2022-02-15 09:31:46	2022-02-15 09:31:46
7	3	App\\Models\\PrestadorServico	SEXTA	14:00:00	18:00:00	2022-02-15 09:31:46	2022-02-15 09:31:46
8	4	App\\Models\\PrestadorServico	QUINTA	08:00:00	12:00:00	2022-02-15 09:33:06	2022-02-15 09:33:06
9	4	App\\Models\\PrestadorServico	QUINTA	14:00:00	18:00:00	2022-02-15 09:33:06	2022-02-15 09:33:06
21	1	App\\Models\\ServicoAtendimento	SEGUNDA	08:00:00	12:00:00	2022-02-22 19:59:59	2022-02-22 19:59:59
22	1	App\\Models\\ServicoAtendimento	SEGUNDA	13:00:00	18:00:00	2022-02-22 19:59:59	2022-02-22 19:59:59
23	1	App\\Models\\ServicoAtendimento	TERCA	08:00:00	12:00:00	2022-02-22 19:59:59	2022-02-22 19:59:59
24	1	App\\Models\\ServicoAtendimento	TERCA	13:00:00	18:00:00	2022-02-22 19:59:59	2022-02-22 19:59:59
25	1	App\\Models\\ServicoAtendimento	QUARTA	08:00:00	12:00:00	2022-02-22 19:59:59	2022-02-22 19:59:59
26	1	App\\Models\\ServicoAtendimento	QUARTA	13:00:00	18:00:00	2022-02-22 19:59:59	2022-02-22 19:59:59
27	1	App\\Models\\ServicoAtendimento	QUINTA	08:00:00	12:00:00	2022-02-22 19:59:59	2022-02-22 19:59:59
28	1	App\\Models\\ServicoAtendimento	QUINTA	13:00:00	18:00:00	2022-02-22 19:59:59	2022-02-22 19:59:59
29	1	App\\Models\\ServicoAtendimento	SEXTA	08:00:00	12:00:00	2022-02-22 19:59:59	2022-02-22 19:59:59
30	1	App\\Models\\ServicoAtendimento	SEXTA	13:00:00	18:00:00	2022-02-22 19:59:59	2022-02-22 19:59:59
36	1	App\\Models\\PrestadorServico	TERCA	08:00:00	12:00:00	2022-03-09 15:23:01	2022-03-09 15:23:01
37	1	App\\Models\\PrestadorServico	TERCA	14:00:00	18:00:00	2022-03-09 15:23:02	2022-03-09 15:23:02
38	1	App\\Models\\PrestadorServico	QUARTA	14:00:00	18:00:00	2022-03-09 15:23:02	2022-03-09 15:23:02
\.


--
-- Data for Name: jobs; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.jobs (id, queue, payload, attempts, reserved_at, available_at, created_at) FROM stdin;
\.


--
-- Data for Name: log_bairro; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.log_bairro (bai_nu_sequencial, ufe_sg, loc_nu_sequencial, bai_no, bai_no_abrev) FROM stdin;
14230	SP	8883	Antônio Zanaga	A Zanaga
14231	SP	8883	Antônio Zanaga I	A Zanaga I
14232	SP	8883	Antônio Zanaga II	A Zanaga II
14233	SP	8883	Balneário Riviera	Bal Riviera
14234	SP	8883	Balneário Salto Grande	Bal S Grande
14236	SP	8883	Bom Recreio	B Recreio
14237	SP	8883	Bosque da Saúde	Bsq Saúde
14238	SP	8883	Bosque dos Ipês	Bsq Ipês
14239	SP	8883	Brieds	\N
14240	SP	8883	Campo Limpo	Cpo Limpo
14241	SP	8883	Campo Verde	Cpo Verde
14242	SP	8883	Carioba	\N
14243	SP	8883	Cariobinha	\N
14244	SP	8883	Catharina Zanaga	C Zanaga
14245	SP	8883	Cechino	\N
14246	SP	8883	Centro	\N
14247	SP	8883	Chácara Letônia	Ch Letônia
14248	SP	8883	Chácara Lucília	Ch Lucília
14249	SP	8883	Chácara Machadinho I	Ch Machadinho I
14250	SP	8883	Chácara Machado	Ch Machado
14251	SP	8883	Chácara Mantovani	Ch Mantovani
14252	SP	8883	Chácara Rodrigues	Ch Rodrigues
14253	SP	8883	Cidade Jardim I	C Jardim I
14254	SP	8883	Conserva	\N
14255	SP	8883	Fazenda Santa Lúcia	Faz Sta Lúcia
14307	SP	8883	Nossa Senhora de Fátima	N Sra Fátima
14308	SP	8883	Nova Americana	N Americana
14309	SP	8883	Paraíso	\N
14310	SP	8883	Parque Liberdade	Prq Liberdade
14311	SP	8883	Parque das Nações	Prq Nações
14312	SP	8883	Parque Dom Pedro II	Prq D Pedro II
14313	SP	8883	Parque Gramado	Prq Gramado
14314	SP	8883	Parque Mangueira	Prq Mangueira
14315	SP	8883	Parque Novo Mundo	Prq N Mundo
14316	SP	8883	Parque Primavera	Prq Primavera
14317	SP	8883	Parque Residencial Jaguari	Prq Res Jaguari
14318	SP	8883	Parque Residencial Nardini	Prq Res Nardini
14319	SP	8883	Parque Residencial Tancredi	Prq Res Tancredi
14320	SP	8883	Parque São Jerônimo	Prq S Jerônimo
14321	SP	8883	Portal dos Nobres	P Nobres
14322	SP	8883	Praia dos Namorados	Pr Namorados
14324	SP	8883	Recanto Azul	Rec Azul
14325	SP	8883	Recanto Jatobá	Rec Jatobá
14326	SP	8883	Recanto Vista Alegre	Rec V Alegre
14327	SP	8883	Remanso Azul	R Azul
14328	SP	8883	Residencial Boa Vista	Res B Vista
14330	SP	8883	Residencial Praia dos Namorados	Res Pr Namorados
14331	SP	8883	Residencial Santa Paula	Res Sta Paula
14332	SP	8883	Residencial Vale das Nogueiras	Res Vle Nogueiras
14333	SP	8883	Riviera Tamborlim	R Tamborlim
14334	SP	8883	Santa Cruz	Sta Cruz
14335	SP	8883	Santa Sofia	Sta Sofia
14336	SP	8883	Santo Antônio	Sto Antônio
14337	SP	8883	São Benedito	S Benedito
14338	SP	8883	São Jerônimo	S Jerônimo
14339	SP	8883	São José	S José
14340	SP	8883	São Luiz	S Luiz
14341	SP	8883	São Manoel	S Manoel
14342	SP	8883	São Sebastião	S Sebastião
14344	SP	8883	Vale das Paineiras	Vle Paineiras
14345	SP	8883	Vila Amorim	Vl Amorim
14346	SP	8883	Vila Bela	Vl Bela
14347	SP	8883	Vila Belvedere	Vl Belvedere
14348	SP	8883	Vila Bertini	Vl Bertini
14349	SP	8883	Vila Biasi	Vl Biasi
14350	SP	8883	Vila Cordenonsi	Vl Cordenonsi
14351	SP	8883	Vila Dainese	Vl Dainese
14352	SP	8883	Vila Frezzarin	Vl Frezzarin
14353	SP	8883	Vila Galo	Vl Galo
14354	SP	8883	Vila Israel	Vl Israel
14355	SP	8883	Vila Jones	Vl Jones
14356	SP	8883	Vila Louricilda	Vl Louricilda
14357	SP	8883	Vila Margarida	Vl Margarida
14358	SP	8883	Vila Mariana	Vl Mariana
14359	SP	8883	Vila Massucheto	Vl Massucheto
14360	SP	8883	Vila Mathiesen	Vl Mathiesen
14412	SP	8886	Jardim Novo Amparo	Jd N Amparo
14413	SP	8886	Loteamento Panorama Tropical	Lot P Tropical
14414	SP	8886	Jardim Primavera	Jd Primavera
14415	SP	8886	Jardim Real	Jd Real
14416	SP	8886	Jardim Santa Cecília	Jd Sta Cecília
14417	SP	8886	Jardim Santa Helena	Jd Sta Helena
14418	SP	8886	Jardim Santa Júlia	Jd Sta Júlia
14419	SP	8886	Jardim Santana	Jd Santana
14420	SP	8886	Jardim Santo Antônio	Jd Sto Antônio
14421	SP	8886	Jardim São Dimas	Jd S Dimas
14422	SP	8886	Jardim São Francisco	Jd S Francisco
14423	SP	8886	Jardim São José	Jd S José
14424	SP	8886	Jardim São Lourenço	Jd S Lourenço
14425	SP	8886	Jardim São Roberto	Jd S Roberto
14426	SP	8886	Jardim São Sebastião (Arcadas)	Jd S Sebastião (Arcadas)
14427	SP	8886	Jardim Seabra	Jd Seabra
14428	SP	8886	Jardim Serra das Estâncias	Jd S Estâncias
14429	SP	8886	Jardim Silmara	Jd Silmara
14430	SP	8886	Jardim Silvana	Jd Silvana
14431	SP	8886	Jardim Silvestre I	Jd Silvestre I
14432	SP	8886	Jardim Silvestre II	Jd Silvestre II
14433	SP	8886	Jardim Vila Rica	Jd Vl Rica
14434	SP	8886	Jardim Vista Alegre (Arcadas)	Jd V Alegre (Arcadas)
14435	SP	8886	Loteamento Alto da Serra	Lot At Serra
14436	SP	8886	Loteamento Estância Netinho	Lot Etn Netinho
14437	SP	8886	Loteamento Nardini	Lot Nardini
14438	SP	8886	Loteamento Marson	Lot Marson
14439	SP	8886	Parque Cecap	Prq Cecap
14440	SP	8886	Parque do Sol	Prq Sol
14441	SP	8886	Parque Dona Virgínia	Prq Da Virgínia
14442	SP	8886	Parque Flamboyant	Prq Flamboyant
14443	SP	8886	Parque Rodrigues	Prq Rodrigues
14444	SP	8886	Planalto da Serra	P Serra
14445	SP	8886	Recanto do Lago	Rec Lago
14446	SP	8886	Recanto Haydee	Rec Haydee
14447	SP	8886	Retiro Luiz Cenati	Rer L Cenati
14448	SP	8886	Ribeirão	\N
14449	SP	8886	São Judas	S Judas
14450	SP	8886	Silvestre	\N
14451	SP	8886	Velhobol	\N
14452	SP	8886	Vila Nova	Vl Nova
14453	SP	8891	Benfica	\N
14454	SP	8891	Centro	\N
14455	SP	8891	Conjunto Habitacional Álvaro Gasparelli I	Cj Hab A Gasparelli I
14456	SP	8891	Conjunto Habitacional Álvaro Gasparelli II	Cj Hab A Gasparelli II
14458	SP	8891	Conjunto Habitacional Antônio Silvio da Cunha Bueno	Cj Hab A S C Bueno
14256	SP	8883	Fazendinha	\N
14257	SP	8883	Iate Clube de Americana	I C Americana
14258	SP	8883	Iate Clube de Campinas	I C Campinas
14259	SP	8883	Jardim Alvorada	Jd Alvorada
14260	SP	8883	Jardim Amélia	Jd Amélia
14261	SP	8883	Jardim América	Jd América
14262	SP	8883	Jardim Bazanelli	Jd Bazanelli
14263	SP	8883	Jardim Bela Vista	Jd B Vista
14264	SP	8883	Jardim Brasil	Jd Brasil
14265	SP	8883	Jardim Brasília	Jd Brasília
14266	SP	8883	Jardim Campo Belo	Jd Cpo Belo
14267	SP	8883	Jardim Colina	Jd Colina
14268	SP	8883	Jardim Paz	Jd Paz
14271	SP	8883	Jardim Girassol	Jd Girassol
14272	SP	8883	Jardim Glória	Jd Glória
14273	SP	8883	Jardim Guanabara	Jd Guanabara
14274	SP	8883	Jardim Helena	Jd Helena
14275	SP	8883	Jardim Ipiranga	Jd Ipiranga
14276	SP	8883	Jardim Jacyra	Jd Jacyra
14277	SP	8883	Jardim Lizandra	Jd Lizandra
14278	SP	8883	Jardim Luciane	Jd Luciane
14279	SP	8883	Jardim Marcia Cristina	Jd M Cristina
14280	SP	8883	Jardim Miriam	Jd Miriam
14281	SP	8883	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
14282	SP	8883	Jardim Nossa Senhora do Carmo	Jd N Sra Carmo
14283	SP	8883	Jardim Paulista	Jd Paulista
14284	SP	8883	Jardim Paulistano	Jd Paulistano
14285	SP	8883	Jardim Planalto	Jd Planalto
14286	SP	8883	Jardim Primavera	Jd Primavera
14287	SP	8883	Jardim Progresso	Jd Progresso
14288	SP	8883	Jardim Santa Eliza	Jd Sta Eliza
14289	SP	8883	Jardim Santana	Jd Santana
14290	SP	8883	Jardim Santarosa	Jd Santarosa
14291	SP	8883	Jardim Santo Antônio	Jd Sto Antônio
14292	SP	8883	Jardim São Domingos	Jd S Domingos
14293	SP	8883	Jardim São José	Jd S José
14294	SP	8883	Jardim São Paulo	Jd S Paulo
14295	SP	8883	Jardim São Roque	Jd S Roque
14296	SP	8883	Jardim São Vito	Jd S Vito
14297	SP	8883	Jardim Thelja	Jd Thelja
14298	SP	8883	Jardim Werner Plaas	Jd W Plaas
14299	SP	8883	Loteamento Industrial Nossa Senhora de Fátima	Lot Ind N Sra Fátima
14301	SP	8883	Loteamento Industrial Salto Grande I	Lot Ind S Grande I
14303	SP	8883	Loteamento Residencial Industrial João Santarosa	Lot Res Ind J Santarosa
14304	SP	8883	Maria Crivellone Abrão	M C Abrão
14305	SP	8883	Monte Carlo	Mte Carlo
14306	SP	8883	Morada do Sol	M Sol
14361	SP	8883	Vila Medon	Vl Medon
14362	SP	8883	Vila Molon	Vl Molon
14363	SP	8883	Vila Omar	Vl Omar
14364	SP	8883	Vila Pavan	Vl Pavan
14365	SP	8883	Vila Rasmussen	Vl Rasmussen
14366	SP	8883	Vila Rehder	Vl Rehder
14367	SP	8883	Vila Rio Branco	Vl R Branco
14368	SP	8883	Vila Santa Catarina	Vl Sta Catarina
14369	SP	8883	Vila Santa Inês	Vl Sta Inês
14370	SP	8883	Vila Santa Maria	Vl Sta Maria
14371	SP	8883	Vila São Pedro	Vl S Pedro
14372	SP	8883	Werner Plaas	W Plaas
14373	SP	8886	Arruda	\N
14374	SP	8886	Brumado	\N
14375	SP	8886	Castelo	\N
14376	SP	8886	Centro	\N
14377	SP	8886	Centro (Arcadas)	\N
14378	SP	8886	Centro (Três Pontes)	Centro (T Pontes)
14379	SP	8886	Chácara Abdalla	Ch Abdalla
14380	SP	8886	Chácara Ancona (Arcadas)	Ch Ancona (Arcadas)
14381	SP	8886	Chácara Bocaina	Ch Bocaina
14382	SP	8886	Chácara Brumado	Ch Brumado
14383	SP	8886	Chácara Flor da Porcelana (Arcadas)	Ch F Porcelana (Arcadas)
14384	SP	8886	Chácara São Francisco	Ch S Francisco
14385	SP	8886	Chácara São João	Ch S João
14386	SP	8886	Chácara Vitória	Ch Vitória
14387	SP	8886	Conjunto Habitacional Alberto Marques	Cj Hab A Marques
16662	SP	9025	Parque Nova Campinas	Prq N Campinas
16663	SP	9025	Parque Prado	Prq Prado
16665	SP	9025	Parque Residencial Beira Rio	Prq Res B Rio
16666	SP	9025	Parque Residencial Campina Grande	Prq Res C Grande
16724	SP	9025	Vila Antônio Vitorino	Vl A Vitorino
16725	SP	9025	Vila Aurocan	Vl Aurocan
16728	SP	9025	Vila Boa Vista	Vl B Vista
16729	SP	9025	Vila Bourbon (Sousas)	Vl Bourbon (Sousas)
16730	SP	9025	Vila Brandina	Vl Brandina
16731	SP	9025	Vila Campos Sales	Vl C Sales
16732	SP	9025	Vila Carlito	Vl Carlito
16733	SP	9025	Vila Carminha	Vl Carminha
16734	SP	9025	Vila Castelo Branco	Vl C Branco
16737	SP	9025	Vila Costa e Silva	Vl C E Silva
16740	SP	9025	Vila Dutra	Vl Dutra
16742	SP	9025	Vila Eliza	Vl Eliza
16744	SP	9025	Vila Elza	Vl Elza
16745	SP	9025	Vila Esmeralda	Vl Esmeralda
16747	SP	9025	Vila Estanislau	Vl Estanislau
16749	SP	9025	Vila Ferreira Jorge	Vl F Jorge
16750	SP	9025	Vila Formosa	Vl Formosa
16751	SP	9025	Vila Fortuna	Vl Fortuna
16752	SP	9025	Vila Georgina	Vl Georgina
16753	SP	9025	Vila Guararapes	Vl Guararapes
16754	SP	9025	Vila Guilherme	Vl Guilherme
16756	SP	9025	Vila Horácio Tulli	Vl H Tulli
16757	SP	9025	Vila Iapi	Vl Iapi
16758	SP	9025	Vila Industrial	Vl Industrial
16759	SP	9025	Vila Ipê	Vl Ipê
16760	SP	9025	Vila Itália	Vl Itália
16761	SP	9025	Vila Itapura	Vl Itapura
16762	SP	9025	Vila Iza	Vl Iza
16763	SP	9025	Vila Janete (Sousas)	Vl Janete (Sousas)
16764	SP	9025	Vila Jequitibás	Vl Jequitibás
16765	SP	9025	Vila Joaquim Inácio	Vl J Inácio
16767	SP	9025	Vila José Iório (Sousas)	Vl J Iório (Sousas)
14388	SP	8886	Conjunto Habitacional Vereador Hermínio Gerbi	Cj Hab Ver H Gerbi
14389	SP	8886	Fazenda do Túnel (Arcadas)	Faz Túnel (Arcadas)
14390	SP	8886	Fazenda São José (Arcadas)	Faz S José (Arcadas)
14391	SP	8886	Fazenda Tamburi	Faz Tamburi
14392	SP	8886	Jardim Adélia	Jd Adélia
14393	SP	8886	Jardim Alberto	Jd Alberto
14394	SP	8886	Jardim América	Jd América
14395	SP	8886	Jardim Andréia	Jd Andréia
14396	SP	8886	Jardim Bandeirantes (Arcadas)	Jd Bandeirantes (Arcadas)
14397	SP	8886	Jardim Bela Vista	Jd B Vista
14398	SP	8886	Jardim Bianca	Jd Bianca
14399	SP	8886	Jardim Brasil	Jd Brasil
14400	SP	8886	Jardim Cachoeira	Jd Cachoeira
14401	SP	8886	Jardim Camandocaia	Jd Camandocaia
14402	SP	8886	Jardim das Aves	Jd Aves
14403	SP	8886	Jardim das Orquídeas	Jd Orquídeas
14404	SP	8886	Jardim Figueira	Jd Figueira
14405	SP	8886	Jardim Flamboyant	Jd Flamboyant
14406	SP	8886	Jardim Itália	Jd Itália
14407	SP	8886	Jardim Juliana	Jd Juliana
14408	SP	8886	Jardim Modelo	Jd Modelo
14409	SP	8886	Jardim Moreirinha	Jd Moreirinha
14411	SP	8886	Jardim Nova Era	Jd N Era
14459	SP	8891	Conjunto Habitacional Belmiro Brunello	Cj Hab B Brunello
14460	SP	8891	Conjunto Habitacional Bonfiglio Barbarotto	Cj Hab B Barbarotto
14461	SP	8891	Conjunto Habitacional Lourival Rabelo dos Santos	Cj Hab L R Santos
14462	SP	8891	Conjunto Habitacional Provido Bernardoni	Cj Hab P Bernardoni
14463	SP	8891	Distrito Industrial	Dt Industrial
14464	SP	8891	Jardim Alvorada	Jd Alvorada
14465	SP	8891	Jardim Brasil	Jd Brasil
14466	SP	8891	Jardim das Águas	Jd Águas
14467	SP	8891	Jardim Europa	Jd Europa
14468	SP	8891	Jardim Pedrina	Jd Pedrina
14469	SP	8891	Jardim Santa Cecília	Jd Sta Cecília
14470	SP	8891	Jardim Santo Antônio	Jd Sto Antônio
14471	SP	8891	Parque Morumbi	Prq Morumbi
14472	SP	8891	Parque Santo Antônio	Prq Sto Antônio
14473	SP	8891	Parque São Gabriel	Prq S Gabriel
14474	SP	8891	Parque Urubupungá	Prq Urubupungá
14475	SP	8891	Piscina	\N
14476	SP	8891	Stella Maris	S Maris
14477	SP	8891	Vila Alpina	Vl Alpina
14478	SP	8891	Vila Botega	Vl Botega
14479	SP	8891	Vila Delmond	Vl Delmond
14480	SP	8891	Vila Feltrini	Vl Feltrini
14481	SP	8891	Vila Rondon	Vl Rondon
14482	SP	8891	Vila Messias	Vl Messias
14483	SP	8891	Vila Mineira	Vl Mineira
14484	SP	8891	Vila Passarelli	Vl Passarelli
14485	SP	8891	Vila Peliciari	Vl Peliciari
14486	SP	8891	Vila Pereira Jordão	Vl P Jordão
14487	SP	8891	Vila Rica	Vl Rica
14488	SP	8891	Vila Sanches	Vl Sanches
14489	SP	8891	Vila São João	Vl S João
14490	SP	8891	Vila São Pedro	Vl S Pedro
14491	SP	8907	Aeroporto	\N
14493	SP	8907	Aviação	\N
14494	SP	8907	Bairro das Bandeiras	B Bandeiras
14495	SP	8907	Boa Vista	B Vista
14496	SP	8907	Campus Universitário	C Universitário
14497	SP	8907	Centro	\N
14498	SP	8907	Chácaras Arco-Íris	C Arco-Íris
14499	SP	8907	Chácaras Bandeirantes	C Bandeirantes
14500	SP	8907	Chácaras Califórnia	C Califórnia
14501	SP	8907	Chácaras de Recreio Alvorada	C Rcr Alvorada
14502	SP	8907	Chácaras de Recreio Monteiro	C Rcr Monteiro
14503	SP	8907	Chácaras de Recreio Tropical	C Rcr Tropical
14505	SP	8907	Chácaras Moema	C Moema
14508	SP	8907	Chácaras Osaka	C Osaka
14509	SP	8907	Chácaras Paraíso	C Paraíso
14510	SP	8907	Chácaras Sossego	C Sossego
14511	SP	8907	Chácaras TV	C TV
14512	SP	8907	Chácaras Versalhes	C Versalhes
14514	SP	8907	Conjunto Habitacional Antônio Pagan	Cj Hab A Pagan
14515	SP	8907	Conjunto Habitacional Claudionor Cinti	Cj Hab C Cinti
14516	SP	8907	Conjunto Habitacional Clóvis Valentin Picolotto	Cj Hab C V Picolotto
14517	SP	8907	Conjunto Habitacional Doutor Antônio Villela Silva	Cj Hab Dr A V Silva
14518	SP	8907	Conjunto Habitacional Etheocle Turrini	Cj Hab E Turrini
14519	SP	8907	Conjunto Habitacional Ezequiel Barbosa	Cj Hab E Barbosa
14520	SP	8907	Conjunto Habitacional Hilda Mandarino	Cj Hab H Mandarino
14521	SP	8907	Conjunto Habitacional João Batista Botelho	Cj Hab J B Botelho
14523	SP	8907	Conjunto Habitacional José Saran	Cj Hab J Saran
14524	SP	8907	Conjunto Habitacional Manoel Pires	Cj Hab M Pires
14525	SP	8907	Conjunto Habitacional Mão Divina	Cj Hab M Divina
14526	SP	8907	Conjunto Habitacional Pedro Perri	Cj Hab P Perri
14528	SP	8907	Conjunto Habitacional Taane Andraus	Cj Hab T Andraus
14529	SP	8907	Conjunto Habitacional Vicente Luiz Grosso	Cj Hab V L Grosso
14532	SP	8907	Distrito Industrial Alexandre Biagi	Dt Ind A Biagi
14533	SP	8907	Engenheiro Taveira	Eng Taveira
14534	SP	8907	Fazenda do Estado	Faz Estado
14535	SP	8907	Higienópolis	\N
14536	SP	8907	Jardim Aclimação	Jd Aclimação
14537	SP	8907	Alto da Boa Vista	At B Vista
14538	SP	8907	Alvorada	\N
14539	SP	8907	Jardim América	Jd América
14540	SP	8907	Vila Bandeirantes	Vl Bandeirantes
16771	SP	9025	Vila Lemos	Vl Lemos
14541	SP	8907	Jardim Brasil	Jd Brasil
14542	SP	8907	Jardim Brasília	Jd Brasília
14544	SP	8907	Casa Nova	C Nova
14546	SP	8907	Palmeiras	\N
14547	SP	8907	Jardim do Prado	Jd Prado
14548	SP	8907	Jardim do Trevo	Jd Trevo
14549	SP	8907	Dona Amélia	Da Amélia
14550	SP	8907	Esplanada	\N
14551	SP	8907	Guanabara	\N
14552	SP	8907	Icaray	\N
14553	SP	8907	Ipanema	\N
14554	SP	8907	Iporã	\N
14555	SP	8907	Jussara	\N
14556	SP	8907	Lago Azul	Lg Azul
14558	SP	8907	Monte Carlo	Mte Carlo
14559	SP	8907	Monterrey	\N
14560	SP	8907	Morumbi	\N
14561	SP	8907	Jardim Nova Yorque	Jd N Yorque
14562	SP	8907	Novo Paraíso	N Paraíso
14563	SP	8907	Novo Umuarama	N Umuarama
14565	SP	8907	Jardim Paulista	Jd Paulista
14566	SP	8907	Petit-Trianon	\N
14567	SP	8907	Pinheiros	\N
14568	SP	8907	Planalto	\N
14627	SP	8912	Jardim Adalberto Frederico de Oliveira Roxo II	Jd A F O Roxo II
14628	SP	8912	Jardim Adalgisa	Jd Adalgisa
14629	SP	8912	Jardim Águas do Paiol	Jd A Paiol
14631	SP	8912	Jardim Almeida	Jd Almeida
14634	SP	8912	Jardim América (Vila Xavier)	Jd América (Vl Xavier)
14635	SP	8912	Jardim Ana Adelaide	Jd A Adelaide
14636	SP	8912	Jardim Arangá	Jd Arangá
14637	SP	8912	Jardim Araraquara	Jd Araraquara
14638	SP	8912	Jardim Arco-Íris	Jd Arco-Íris
14639	SP	8912	Jardim Ártico	Jd Ártico
14641	SP	8912	Jardim Biagioni	Jd Biagioni
14642	SP	8912	Jardim Botânico	Jd Botânico
14643	SP	8912	Jardim Brasil (Vila Xavier)	Jd Brasil (Vl Xavier)
14644	SP	8912	Jardim Brasília (Vila Xavier)	Jd Brasília (Vl Xavier)
14645	SP	8912	Jardim Celiamar	Jd Celiamar
14646	SP	8912	Jardim Cristo Rei (Vila Xavier)	Jd C Rei (Vl Xavier)
14647	SP	8912	Jardim Cruzeiro do Sul I	Jd C Sul I
14648	SP	8912	Jardim Cruzeiro do Sul II	Jd C Sul II
14649	SP	8912	Jardim das Estações (Vila Xavier)	Jd Estações (Vl Xavier)
14650	SP	8912	Jardim das Gaivotas	Jd Gaivotas
14651	SP	8912	Jardim das Paineiras	Jd Paineiras
14652	SP	8912	Jardim das Palmeiras	Jd Palmeiras
14654	SP	8912	Jardim Del Rei	Jd D Rei
14655	SP	8912	Jardim do Carmo	Jd Carmo
14656	SP	8912	Jardim Dom Pedro I	Jd D Pedro I
14657	SP	8912	Jardim Domingos Sávio	Jd D Sávio
14659	SP	8912	Jardim dos Ipês	Jd Ipês
14660	SP	8912	Jardim dos Manacás	Jd Manacás
14661	SP	8912	Jardim Dumont	Jd Dumont
14663	SP	8912	Jardim Eliana	Jd Eliana
14664	SP	8912	Jardim Esplanada	Jd Esplanada
14665	SP	8912	Jardim Europa (Vila Xavier)	Jd Europa (Vl Xavier)
14667	SP	8912	Jardim Floridiana (Vila Xavier)	Jd Floridiana (Vl Xavier)
14668	SP	8912	Jardim Guanabara	Jd Guanabara
14669	SP	8912	Jardim Higienópolis	Jd Higienópolis
14670	SP	8912	Jardim Imperador	Jd Imperador
14671	SP	8912	Jardim Imperial	Jd Imperial
14672	SP	8912	Jardim Indaiá	Jd Indaiá
14673	SP	8912	Jardim Residencial Itália	Jd Res Itália
14675	SP	8912	Jardim Mangiacapra	Jd Mangiacapra
14676	SP	8912	Jardim Maracanã	Jd Maracanã
14677	SP	8912	Jardim Maria Luiza	Jd M Luiza
14678	SP	8912	Jardim Maria Luiza IV	Jd M Luiza IV
14679	SP	8912	Jardim Marivan	Jd Marivan
14722	SP	8912	Jardim Viaduto (Vila Xavier)	Jd Viaduto (Vl Xavier)
14724	SP	8912	Jardim Vitória	Jd Vitória
14725	SP	8912	Jardim Zavanella	Jd Zavanella
14728	SP	8912	Parque Alvorada	Prq Alvorada
14729	SP	8912	Doutor Tancredo de Almeida Neves	Dr T A Neves
14730	SP	8912	Parque das Hortências	Prq Hortências
14732	SP	8912	Parque Gramado (Vila Xavier)	Prq Gramado (Vl Xavier)
14734	SP	8912	Parque Residencial Iguatemi	Prq Res Iguatemi
14735	SP	8912	Parque Laranjeiras	Prq Laranjeiras
14736	SP	8912	Parque Planalto	Prq Planalto
14737	SP	8912	Parque Residencial Vale do Sol	Prq Res Vle Sol
14739	SP	8912	Parque São Paulo (Vila Xavier)	Prq S Paulo (Vl Xavier)
14740	SP	8912	Parque Tropical	Prq Tropical
14742	SP	8912	Portal das Laranjeiras	P Laranjeiras
14743	SP	8912	Recreio Campestre Idanorma	Rcr C Idanorma
14744	SP	8912	Residencial Acapulco	Res Acapulco
14745	SP	8912	Residencial Cambuy	Res Cambuy
14746	SP	8912	São Geraldo	S Geraldo
14749	SP	8912	Vila Bela Vista	Vl B Vista
14750	SP	8912	Vila Biagioni (Vila Xavier)	Vl Biagioni (Vl Xavier)
14751	SP	8912	Vila Cidade Industrial (Vila Xavier)	Vl C Industrial (Vl Xavier)
14752	SP	8912	Vila DER	Vl DER
14753	SP	8912	Vila do Servidor	Vl Servidor
14754	SP	8912	Vila Donofre (Vila Xavier)	Vl Donofre (Vl Xavier)
14755	SP	8912	Vila Esperança (Vila Xavier)	Vl Esperança (Vl Xavier)
14756	SP	8912	Vila Ferroviária	Vl Ferroviária
14757	SP	8912	Vila Furlan	Vl Furlan
14758	SP	8912	Vila Gaspar (Vila Xavier)	Vl Gaspar (Vl Xavier)
14759	SP	8912	Vila Girassol	Vl Girassol
14760	SP	8912	Vila Guaianazes	Vl Guaianazes
14761	SP	8912	Vila Harmonia	Vl Harmonia
14762	SP	8912	Vila Higia	Vl Higia
14763	SP	8912	Vila Independência	Vl Independência
14764	SP	8912	Vila João Godói	Vl J Godói
14765	SP	8912	Vila Joinville (Vila Xavier)	Vl Joinville (Vl Xavier)
14766	SP	8912	Vila José Bonifácio	Vl J Bonifácio
14768	SP	8912	Vila Kátia	Vl Kátia
14769	SP	8912	Vila Melhado	Vl Melhado
14770	SP	8912	Vila Nice	Vl Nice
14772	SP	8912	Vila Normanda	Vl Normanda
14911	SP	8926	Vila Boa Vista	Vl B Vista
14774	SP	8912	Vila Nossa Senhora do Carmo	Vl N Sra Carmo
14775	SP	8912	Vila Oriente	Vl Oriente
14776	SP	8912	Vila Popular (Vila Xavier)	Vl Popular (Vl Xavier)
14829	SP	8913	Jardim Nicolau	Jd Nicolau
14830	SP	8913	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
14831	SP	8913	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
14832	SP	8913	Jardim Nova Araras	Jd N Araras
14833	SP	8913	Jardim Nova Cândida	Jd N Cândida
14834	SP	8913	Jardim Nova Olinda	Jd N Olinda
14835	SP	8913	Jardim Nova Suiça	Jd N Suiça
14837	SP	8913	Jardim Piratininga	Jd Piratininga
14838	SP	8913	Jardim Presidente Tancredo Neves	Jd Pres T Neves
14839	SP	8913	Jardim Residencial Itapuã	Jd Res Itapuã
14840	SP	8913	Jardim Rollo	Jd Rollo
14841	SP	8913	Jardim Rosana	Jd Rosana
14842	SP	8913	Jardim Santa Cruz	Jd Sta Cruz
14843	SP	8913	Jardim Santa Marta	Jd Sta Marta
14844	SP	8913	Jardim Santa Rosa	Jd Sta Rosa
14845	SP	8913	Jardim São João	Jd S João
14846	SP	8913	Jardim São Luiz	Jd S Luiz
14847	SP	8913	Jardim São Pedro	Jd S Pedro
14848	SP	8913	Jardim Sobradinho	Jd Sobradinho
14849	SP	8913	Jardim Tarumã	Jd Tarumã
14850	SP	8913	Jardim Universitário	Jd Universitário
14851	SP	8913	Jardim 15 de Agosto	Jd 15 Agosto
14852	SP	8913	Jardim 8 de Abril	Jd 8 Abril
14853	SP	8913	Parque Alvorada	Prq Alvorada
14854	SP	8913	Parque Cidade Jardim	Prq C Jardim
14855	SP	8913	Parque das Árvores	Prq Árvores
14856	SP	8913	Parque Industrial	Prq Industrial
14857	SP	8913	Parque Santa Cândida	Prq Sta Cândida
14858	SP	8913	Parque Tiradentes	Prq Tiradentes
14859	SP	8913	Residencial Bosque de Versalles	Res Bsq Versalles
14860	SP	8913	Vila Bressan	Vl Bressan
14861	SP	8913	Jardim Cândida	Jd Cândida
14862	SP	8913	Vila Dona Rosa Zurita	Vl Da R Zurita
14863	SP	8913	Vila Europa	Vl Europa
14864	SP	8913	Vila Madalena de Canossa	Vl M Canossa
14865	SP	8913	Vila Michelin	Vl Michelin
14866	SP	8913	Vila Pastorello	Vl Pastorello
14867	SP	8913	Vila Queiroz	Vl Queiroz
14868	SP	8913	Vila Rodini	Vl Rodini
14869	SP	8913	Vila Santo Antônio	Vl Sto Antônio
14870	SP	8913	Vila São Jorge	Vl S Jorge
14871	SP	8926	Aeroporto	\N
14872	SP	8926	Água do Pavão	A Pavão
14873	SP	8926	BNH	\N
14874	SP	8926	CDA	\N
14876	SP	8926	CDA 3	\N
14877	SP	8926	Centro	\N
14879	SP	8926	Chácara Alvorada	Ch Alvorada
14880	SP	8926	Chácara das Rosas	Ch Rosas
14882	SP	8926	Conjunto Habitacional Assis IV	Cj Hab Assis IV
14569	SP	8907	Presidente	\N
14570	SP	8907	Primavera	\N
14571	SP	8907	Rosele	\N
14572	SP	8907	São José	S José
14573	SP	8907	São Rafael	S Rafael
14574	SP	8907	Jardim Sumaré	Jd Sumaré
14575	SP	8907	TV	\N
14576	SP	8907	Umuarama	\N
14577	SP	8907	Morada dos Nobres	M Nobres
14578	SP	8907	Conjunto Habitacional Nossa Senhora Aparecida	Cj Hab N Sra Aparecida
14579	SP	8907	Paraíso	\N
14580	SP	8907	Parque Baguaçu	Prq Baguaçu
14581	SP	8907	Parque Industrial	Prq Industrial
14583	SP	8907	Parque Industrial II	Prq Industrial II
14585	SP	8907	Parque Industrial Maria Isabel de Almeida Prado	Prq Ind M I A Prado
14586	SP	8907	Parque Residencial Aeroporto	Prq Res Aeroporto
14587	SP	8907	Santana	\N
14588	SP	8907	São João	S João
14589	SP	8907	São Joaquim	S Joaquim
14590	SP	8907	São Vicente	S Vicente
14591	SP	8907	Saudade	\N
14592	SP	8907	Vila Aeronáutica	Vl Aeronáutica
14593	SP	8907	Vila Alba	Vl Alba
14594	SP	8907	Vila Carvalho	Vl Carvalho
14595	SP	8907	Conjunto Habitacional Castelo Branco	Cj Hab C Branco
14596	SP	8907	Vila Estádio	Vl Estádio
14597	SP	8907	Vila Industrial	Vl Industrial
14598	SP	8907	Vila Mendonça	Vl Mendonça
14599	SP	8907	Vila Nova	Vl Nova
14600	SP	8907	Panorama	\N
14601	SP	8907	Vila Santa Maria	Vl Sta Maria
14602	SP	8907	Vila Santo Antônio	Vl Sto Antônio
14603	SP	8907	Vila São Paulo	Vl S Paulo
14606	SP	8912	Campos Ville	C Ville
14607	SP	8912	Centro	\N
14608	SP	8912	Centro Empresarial e Industrial Omar Maksoud	C E E Ind O Maksoud
14609	SP	8912	Chácara Flora Araraquara	Ch F Araraquara
14611	SP	8912	Chácara Velosa	Ch Velosa
14612	SP	8912	Cidade Jardim	C Jardim
14613	SP	8912	Cociza	\N
14615	SP	8912	Condomínio Parque dos Sabiás	Cond Prq Sabiás
14618	SP	8912	Conjunto Habitacional Victório de Santi	Cj Hab V Santi
14619	SP	8912	1° Distrito Industrial (Albert Geoges Karam)	1° Dt Industrial (A G Karam)
14620	SP	8912	2° Distrito Industrial (Domingos Ferrari)	2° Dt Industrial (D Ferrari)
14621	SP	8912	3° Distrito Industrial (Virgílio Ometto Pavan)	3° Dt Industrial (V O Pavan)
14625	SP	8912	Jardim Aclimação	Jd Aclimação
14626	SP	8912	Jardim Adalberto Frederico de Oliveira Roxo I	Jd A F O Roxo I
14680	SP	8912	Jardim Martinez	Jd Martinez
14681	SP	8912	Jardim Morada do Sol (Vila Xavier)	Jd M Sol (Vl Xavier)
14682	SP	8912	Jardim Morumbi	Jd Morumbi
14683	SP	8912	Jardim Nova América	Jd N América
14684	SP	8912	Jardim Nova Araraquara	Jd N Araraquara
14685	SP	8912	Jardim Nova Época	Jd N Época
14686	SP	8912	Jardim Padre Anchieta	Jd Pe Anchieta
14687	SP	8912	Jardim Palmares	Jd Palmares
14688	SP	8912	Jardim Panorama	Jd Panorama
14689	SP	8912	Jardim Paulistano (Vila Xavier)	Jd Paulistano (Vl Xavier)
14690	SP	8912	Jardim Pinheiros (Vila Xavier)	Jd Pinheiros (Vl Xavier)
14691	SP	8912	Jardim Portugal	Jd Portugal
14692	SP	8912	Jardim Primavera	Jd Primavera
14693	SP	8912	Jardim Primor	Jd Primor
14694	SP	8912	Jardim Quitandinha	Jd Quitandinha
14695	SP	8912	Jardim Rafaela Amoroso Micelli	Jd R A Micelli
14696	SP	8912	Jardim Regina	Jd Regina
14697	SP	8912	Jardim Residencial Água Branca	Jd Res A Branca
14699	SP	8912	Jardim Residencial Iedda	Jd Res Iedda
14700	SP	8912	Jardim Residencial Paraíso	Jd Res Paraíso
14701	SP	8912	Jardim Residencial Santa Mônica	Jd Res Sta Mônica
14702	SP	8912	Jardim Residencial Silvestre	Jd Res Silvestre
14703	SP	8912	Jardim Roberto Selmi Dei	Jd R S Dei
14704	SP	8912	Jardim Santa Adélia	Jd Sta Adélia
14705	SP	8912	Jardim Santa Angelina	Jd Sta Angelina
14706	SP	8912	Jardim Santa Clara (Vila Xavier)	Jd Sta Clara (Vl Xavier)
14707	SP	8912	Jardim Santa Júlia (Vila Xavier)	Jd Sta Júlia (Vl Xavier)
14708	SP	8912	Jardim Santa Lúcia	Jd Sta Lúcia
14709	SP	8912	Jardim Santa Marta	Jd Sta Marta
14710	SP	8912	Jardim Santa Rita de Cássia	Jd Sta R Cássia
14711	SP	8912	Jardim Santa Rosa	Jd Sta Rosa
14712	SP	8912	Jardim Santo Antônio	Jd Sto Antônio
14713	SP	8912	Jardim São Gabriel	Jd S Gabriel
14714	SP	8912	Jardim São Rafael II	Jd S Rafael II
14715	SP	8912	Jardim Silvânia (Vila Xavier)	Jd Silvânia (Vl Xavier)
14716	SP	8912	Jardim Tabapuã (Vila Xavier)	Jd Tabapuã (Vl Xavier)
14717	SP	8912	Jardim Tamoio	Jd Tamoio
14718	SP	8912	Jardim Tangará	Jd Tangará
14719	SP	8912	Jardim Tinen	Jd Tinen
14720	SP	8912	Jardim Universal	Jd Universal
14721	SP	8912	Jardim Vale das Rosas	Jd Vle Rosas
14777	SP	8912	Vila Progresso	Vl Progresso
14778	SP	8912	Vila Renata (Vila Xavier)	Vl Renata (Vl Xavier)
14780	SP	8912	Vila Santa Maria (Vila Xavier)	Vl Sta Maria (Vl Xavier)
14781	SP	8912	Vila Santana	Vl Santana
14782	SP	8912	Vila Santo Malara (Vila Xavier)	Vl Sto Malara (Vl Xavier)
14783	SP	8912	Vila Sedenho	Vl Sedenho
14784	SP	8912	Vila Standard	Vl Standard
14785	SP	8912	Vila Suconasa	Vl Suconasa
14786	SP	8912	Vila Tito de Carvalho (Vila Xavier)	Vl T Carvalho (Vl Xavier)
14787	SP	8912	Vila Velosa	Vl Velosa
14788	SP	8912	Vila Vieira (Vila Xavier)	Vl Vieira (Vl Xavier)
14789	SP	8912	Vila Xavier (Vila Xavier)	Vl Xavier (Vl Xavier)
14790	SP	8912	Vila Yamada	Vl Yamada
14791	SP	8912	Yolanda Opice	Y Opice
14792	SP	8913	Bom Jesus	B Jesus
14793	SP	8913	Campinho	\N
14794	SP	8913	Center Martini	C Martini
14795	SP	8913	Centro	\N
14797	SP	8913	Chácara Daltro	Ch Daltro
14798	SP	8913	Chácara Heitor Villa Lobos	Ch H V Lobos
14800	SP	8913	Conjunto Habitacional Narciso Gomes	Cj Hab N Gomes
14801	SP	8913	Distrito Industrial II	Dt Industrial II
14802	SP	8913	Jardim Abolição de Lourenço Dias	Jd A L Dias
14803	SP	8913	Jardim Alto das Araras	Jd At Araras
14804	SP	8913	Jardim Anhangüera	Jd Anhangüera
14805	SP	8913	Jardim Belvedere	Jd Belvedere
14806	SP	8913	Jardim Buzolin	Jd Buzolin
14809	SP	8913	Jardim Celina	Jd Celina
14810	SP	8913	Jardim Copacabana	Jd Copacabana
14811	SP	8913	Jardim das Flores	Jd Flores
14812	SP	8913	Jardim das Palmeiras	Jd Palmeiras
14813	SP	8913	Jardim dos Eucalíptos	Jd Eucalíptos
14814	SP	8913	Jardim dos Ypês	Jd Ypês
14815	SP	8913	Jardim Boa Esperança	Jd B Esperança
14816	SP	8913	Jardim Filtro	Jd Filtro
14817	SP	8913	Jardim Francisco Buzolin	Jd F Buzolin
14818	SP	8913	Jardim Geny Mercatelli	Jd G Mercatelli
14820	SP	8913	Jardim Itália	Jd Itália
14821	SP	8913	Jardim José Ometto I	Jd J Ometto I
14822	SP	8913	Jardim José Ometto II	Jd J Ometto II
14823	SP	8913	Jardim José Ometto III	Jd J Ometto III
14824	SP	8913	Jardim Luiza Maria	Jd L Maria
14825	SP	8913	Jardim Marabá	Jd Marabá
14826	SP	8913	Jardim Maria Lúcia	Jd M Lúcia
14827	SP	8913	Jardim Maria Rosa	Jd M Rosa
14828	SP	8913	Jardim Mário Leite de Castro	Jd M L Castro
14884	SP	8926	Conjunto Habitacional Irmã Catarina	Cj Hab Ima Catarina
14885	SP	8926	Conjunto Habitacional Nelson Marcondes	Cj Hab N Marcondes
14886	SP	8926	Vila Jardim Aeroporto	Vl Jd Aeroporto
14887	SP	8926	Jardim Alvorada	Jd Alvorada
14888	SP	8926	Jardim Amaury	Jd Amaury
14889	SP	8926	Jardim América	Jd América
14890	SP	8926	Jardim Canadá	Jd Canadá
14891	SP	8926	Jardim Eldorado	Jd Eldorado
14892	SP	8926	Jardim Europa	Jd Europa
14893	SP	8926	Jardim Faria	Jd Faria
14895	SP	8926	Jardim Paraná	Jd Paraná
14896	SP	8926	Jardim Paulista	Jd Paulista
14897	SP	8926	Jardim Santa Amélia	Jd Sta Amélia
14898	SP	8926	Jardim São Nicolau	Jd S Nicolau
14899	SP	8926	Jardim Taquaral	Jd Taquaral
14900	SP	8926	Jardim 3 Américas I	Jd 3 Américas I
14901	SP	8926	Jardim 3 Américas II	Jd 3 Américas II
14902	SP	8926	Núcleo Habitacional Dirceu Gomes Cervilha	Nuc Hab D G Cervilha
14903	SP	8926	Parque das Acácias	\N
14904	SP	8926	Parque das Flores	Prq Flores
14905	SP	8926	Parque Universitário	Prq Universitário
14906	SP	8926	Posto Modelo	P Modelo
14907	SP	8926	Quinta dos Flamboyants	Qta Flamboyants
14908	SP	8926	San Fernando Valley	S F Valley
14909	SP	8926	Vila Adileta	Vl Adileta
14910	SP	8926	Vila Arlindo Luz	Vl A Luz
14912	SP	8926	Vila Brasileira	Vl Brasileira
14914	SP	8926	Vila Cambuí	Vl Cambuí
14915	SP	8926	Vila Carvalho	Vl Carvalho
14916	SP	8926	Vila Central	Vl Central
14917	SP	8926	Vila Claudia	Vl Claudia
14918	SP	8926	Vila Clementina	Vl Clementina
14919	SP	8926	Vila dos Comerciários	Vl Comerciários
14920	SP	8926	Vila Ebenezer	Vl Ebenezer
14921	SP	8926	Vila Fabiano	Vl Fabiano
14922	SP	8926	Vila Fiuza	Vl Fiuza
14923	SP	8926	Vila Fortuna	Vl Fortuna
14924	SP	8926	Vila Funari	Vl Funari
14926	SP	8926	Vila Independência	Vl Independência
14927	SP	8926	Vila Lúcia Maria	Vl L Maria
14928	SP	8926	Vila Maria	Vl Maria
14929	SP	8926	Vila Maria Izabel	Vl M Izabel
14930	SP	8926	Vila Marialves	Vl Marialves
14931	SP	8926	Vila Mercedes	Vl Mercedes
14932	SP	8926	Vila Moraes Pinto	Vl M Pinto
14933	SP	8926	Vila Nova Florínea	Vl N Florínea
14934	SP	8926	Vila Nova Santana	Vl N Santana
14935	SP	8926	Vila Operária	Vl Operária
15026	SP	8928	Jardim das Flores	Jd Flores
15027	SP	8928	Jardim Alvinópolis	Jd Alvinópolis
15029	SP	8928	Jardim do Lago	Jd Lago
15032	SP	8928	Jardim dos Cambaras	Jd Cambaras
15033	SP	8928	Jardim dos Pinheiros	Jd Pinheiros
15034	SP	8928	Jardim Eneide	Jd Eneide
15036	SP	8928	Jardim Estância Brasil	Jd Etn Brasil
15038	SP	8928	Jardim Flamboyant-B	Jd Flamboyant-B
15039	SP	8928	Jardim Floresta	Jd Floresta
15040	SP	8928	Jardim Imperial	Jd Imperial
15042	SP	8928	Jardim Jaraguá	Jd Jaraguá
15043	SP	8928	Jardim Kanimar	Jd Kanimar
15044	SP	8928	Jardim Maracanã	Jd Maracanã
15045	SP	8928	Jardim Maristela	Jd Maristela
15051	SP	8928	Jardim Paraíso do Tanque	Jd P Tanque
15052	SP	8928	Jardim Parque Real Atibaia	Jd Prq R Atibaia
15053	SP	8928	Jardim Paulista	Jd Paulista
15054	SP	8928	Jardim Planalto	Jd Planalto
15057	SP	8928	Jardim Santa Bárbara	Jd Sta Bárbara
15058	SP	8928	Jardim Santo Antônio	Jd Sto Antônio
15060	SP	8928	Jardim São Bento do Tanque	Jd S B Tanque
15063	SP	8928	Jardim Shangri-Lá	Jd Shangri-Lá
15064	SP	8928	Jardim Siriema	Jd Siriema
15065	SP	8928	Jardim Solaris	Jd Solaris
15066	SP	8928	Jardim Sueli	Jd Sueli
15073	SP	8928	Loanda	\N
15079	SP	8928	Nova Gardênia	N Gardênia
15080	SP	8928	Panorama Parque Residencial	P Prq Residencial
15088	SP	8928	Parque das Nações	Prq Nações
15090	SP	8928	Parque dos Coqueiros	Prq Coqueiros
15091	SP	8928	Parque Fernão Dias	Prq F Dias
15096	SP	8928	Parque Residencial Itaguaçu	Prq Res Itaguaçu
15097	SP	8928	Parque Rio Abaixo	Prq R Abaixo
15100	SP	8928	Pinheiral I	\N
15101	SP	8928	Pinheiral II	\N
15105	SP	8928	Quinta Verdes de Atibaia	Qta V Atibaia
15108	SP	8928	Recanto dos Palmares	Rec Palmares
15109	SP	8928	Loteamento Retiro Recanto Tranquilo	Lot Rer Rec Tranquilo
15110	SP	8928	Recreio Estoril	Rcr Estoril
15111	SP	8928	Recreio Maristela	Rcr Maristela
15113	SP	8928	Refúgio	\N
15115	SP	8928	Retiro das Fontes	Rer Fontes
15122	SP	8928	Vale das Flores	Vle Flores
15123	SP	8928	Vale dos Pinheiros	Vle Pinheiros
15125	SP	8928	Vila Carvalho	Vl Carvalho
15132	SP	8928	Vila Dom Pedro	Vl D Pedro
15135	SP	8928	Loteamento Loanda	Lot Loanda
15141	SP	8928	Vila Petrópolis	Vl Petrópolis
15144	SP	8928	Vila Santa Clara	Vl Sta Clara
15200	SP	8933	Parque de Exposições Doutor Fernando Cruz Pimentel	Prq E Dr F C Pimentel
15201	SP	8933	Parque Industrial Jurumirim	Prq Ind Jurumirim
15202	SP	8933	Parque Residencial Brabância I	Prq Res Brabância I
15203	SP	8933	Parque Residencial Gilberto Filgueiras I	Prq Res G Filgueiras I
15204	SP	8933	Royal Park	R Park
15206	SP	8933	Parque São Jorge	Prq S Jorge
15207	SP	8933	Pinheiro Machado	P Machado
15208	SP	8933	Recanto dos Bem-Te-Vis	Rec Bem-Te-Vis
15209	SP	8933	Recanto Vereda do Sol	Rec Ver Sol
15210	SP	8933	Residencial Armando Paula Assis	Res A P Assis
15211	SP	8933	Residencial Avaré I	Res Avaré I
15213	SP	8933	Residencial Park Ipiranga	Res P Ipiranga
15214	SP	8933	Residencial Village	Res Village
15215	SP	8933	Santana	\N
15216	SP	8933	São Pedro	S Pedro
15217	SP	8933	Vila Aires	Vl Aires
15218	SP	8933	Vila Cidade Jardim	Vl C Jardim
15219	SP	8933	Vila Esperança	Vl Esperança
15220	SP	8933	Vila Jussara Maria	Vl J Maria
15221	SP	8933	Vila Maria	Vl Maria
15224	SP	8933	Vila Nova	Vl Nova
15225	SP	8933	Vila Operária	Vl Operária
15226	SP	8933	Vila Piagentino	Vl Piagentino
15227	SP	8933	Vila Rio Novo	Vl R Novo
15228	SP	8933	Vila Santa Izabel	Vl Sta Izabel
15230	SP	8933	Vila São Felipe	Vl S Felipe
15231	SP	8933	Vila São João	Vl S João
15232	SP	8933	Vila São Judas Tadeu	Vl S J Tadeu
15233	SP	8933	Vila São Luiz	Vl S Luiz
15235	SP	8933	Vila Timóteo	Vl Timóteo
15236	SP	8933	Vila Três Marias	Vl T Marias
15237	SP	8954	Aeroporto	\N
15238	SP	8954	Alpa	\N
15240	SP	8954	Alto Sumaré	At Sumaré
15241	SP	8954	América	\N
15242	SP	8954	Baroni	\N
15243	SP	8954	Bela Vista	\N
15244	SP	8954	Benedito Realindo Corrêa	B R Corrêa
15245	SP	8954	Boa Esperança	B Esperança
15246	SP	8954	Boa Vista	B Vista
15247	SP	8954	Bom Jesus	B Jesus
15248	SP	8954	Cecapinha	\N
15251	SP	8954	Centro	\N
15252	SP	8954	City Barretos	C Barretos
15256	SP	8954	Cristiano de Carvalho	C Carvalho
15257	SP	8954	Derby Clube	D Clube
15258	SP	8954	Distrito Industrial I	Dt Industrial I
15259	SP	8954	Distrito Industrial II	Dt Industrial II
15260	SP	8954	Diva	\N
15261	SP	8954	Dom João Bosco	D J Bosco
15262	SP	8954	Conjunto Habitacional Helly Pimenta	Cj H H Pimenta
15264	SP	8954	Exposição	\N
15266	SP	8954	Fortaleza	\N
15267	SP	8954	Frigorífico	\N
15268	SP	8954	Gomes	\N
15269	SP	8954	Gonçalves	\N
15270	SP	8954	Haddad	\N
15271	SP	8954	Henriqueta	\N
15272	SP	8954	Ibirapuera	\N
15273	SP	8954	Industrial	\N
15274	SP	8954	Jardim Allah	Jd Allah
15275	SP	8954	Jardim Alvorada	Jd Alvorada
15276	SP	8954	Jardim Arizona	Jd Arizona
15277	SP	8954	Jardim Caiçara	Jd Caiçara
15278	SP	8954	Jardim Califórnia	Jd Califórnia
15279	SP	8954	Jardim Campo Redondo	Jd Cpo Redondo
15280	SP	8954	Jardim Estância	Jd Estância
15281	SP	8954	Doutor Paulo Prata	Dr P Prata
15282	SP	8954	Jardim Nova Barretos	Jd N Barretos
15283	SP	8954	Jardim Ramos	Jd Ramos
15284	SP	8954	Jardim São Paulo	Jd S Paulo
15285	SP	8954	Jardim Silvia	Jd Silvia
15286	SP	8954	Jardim Soares	Jd Soares
15288	SP	8954	Joaquim Pereira Mococa	J P Mococa
15289	SP	8954	Jockey Club	J Club
15290	SP	8954	Conjunto Habitacional José Eugênio Abrão Miziara - Jone Miziara	Cj H J E A Miziara - J Miziara
15291	SP	8954	Lícia	\N
15292	SP	8954	Los Angeles	L Angeles
15293	SP	8954	Marchi	\N
15294	SP	8954	Marieta	\N
15295	SP	8954	Marília	\N
15297	SP	8954	Monte Alegre	Mte Alegre
15298	SP	8954	Monte Castelo	Mte Castelo
15299	SP	8954	Nadir Kenan	N Kenan
15300	SP	8954	Nogueira	\N
15301	SP	8954	Nova América	N América
15302	SP	8954	Nova Clementina	N Clementina
15303	SP	8954	Nova Esplanada	N Esplanada
15306	SP	8954	Oriente	\N
15307	SP	8954	Ortega	\N
15308	SP	8954	Parque Residencial Minerva	Prq Res Minerva
15310	SP	8954	Pedro Cavalini	P Cavalini
15311	SP	8954	Pereira	\N
15312	SP	8954	Pimenta	\N
15313	SP	8954	Primavera	\N
15314	SP	8954	Residencial Parque das Flores	Res Prq Flores
15315	SP	8954	Rios	\N
15316	SP	8954	Santa Cecília	Sta Cecília
15317	SP	8954	Santa Helena	Sta Helena
15318	SP	8954	Santa Izabel	Sta Izabel
15319	SP	8954	Santa Terezinha	Sta Terezinha
15320	SP	8954	Santana	\N
15322	SP	8954	São Francisco	S Francisco
15323	SP	8954	São Jorge	S Jorge
15324	SP	8954	São José	S José
15325	SP	8954	São Judas Tadeu	S J Tadeu
15326	SP	8954	São Salvador	S Salvador
15327	SP	8954	São Vicente	S Vicente
15330	SP	8954	Zequinha Amêndola	Z Amêndola
15331	SP	8956	Alphaville Centro de Apoio I	A C Apoio I
15333	SP	8956	Alphaville Comercial	A Comercial
15334	SP	8956	Alphaville Empresarial	A Empresarial
15395	SP	8956	Jardim Tupanci	Jd Tupanci
15396	SP	8956	Loteamento Malavari	Lot Malavari
15397	SP	8956	Morada dos Lagos	M Lagos
15398	SP	8956	Morada dos Pássaros	M Pássaros
15399	SP	8956	Nova Aldeinha	N Aldeinha
15400	SP	8956	Núcleo Residencial Célia Mota	Nuc Res C Mota
15401	SP	8956	Outeiro de São Fernando	O S Fernando
15402	SP	8956	Parque dos Camargos	Prq Camargos
15403	SP	8956	Parque Imperial	Prq Imperial
15404	SP	8956	Parque Santa Luzia	Prq Sta Luzia
15405	SP	8956	Parque Viana	Prq Viana
15406	SP	8956	Recanto das Mimosas	Rec Mimosas
15407	SP	8956	Recanto Phrynea	Rec Phrynea
15408	SP	8956	Recreio Cachoeira	Rcr Cachoeira
15409	SP	8956	Residencial das Estrelas	Res Estrelas
15410	SP	8956	Residencial Morada dos Lagos	Res M Lagos
15411	SP	8956	São Fernando Residência	S F Residência
15412	SP	8956	Residencial Tamboré	Res Tamboré
15413	SP	8956	Residencial 18 do Forte	Res 18 Forte
15414	SP	8956	Tamboré	\N
15415	SP	8956	Tamboré Residencial Três	T Res Três
15416	SP	8956	Vale do Sol	Vle Sol
15418	SP	8956	Vila Aires	Vl Aires
15419	SP	8956	Vila Barbosa	Vl Barbosa
15420	SP	8956	Vila Barros	Vl Barros
15421	SP	8956	Vila Boa Vista	Vl B Vista
15422	SP	8956	Vila Ceres	Vl Ceres
15423	SP	8956	Vila Conceição	Vl Conceição
15424	SP	8956	Vila Creti	Vl Creti
15425	SP	8956	Vila Engenho Novo	Vl E Novo
15426	SP	8956	Vila Industrial	Vl Industrial
15427	SP	8956	Vila Iracema	Vl Iracema
15428	SP	8956	Vila Militar	Vl Militar
15429	SP	8956	Vila Morellato	Vl Morellato
15430	SP	8956	Vila Nilva	Vl Nilva
15431	SP	8956	Vila Nossa Senhora da Escada	Vl N Sra Escada
15432	SP	8956	Vila Nova	Vl Nova
15433	SP	8956	Vila Nova Barueri	Vl N Barueri
15434	SP	8956	Vila Osmany	Vl Osmany
15435	SP	8956	Vila Pindorama	Vl Pindorama
15436	SP	8956	Vila Porto	Vl Porto
15437	SP	8956	Vila Pouso Alegre	Vl P Alegre
15438	SP	8956	Vila Santa Maria	Vl Sta Maria
15439	SP	8956	Vila São Francisco	Vl S Francisco
15440	SP	8956	Vila São João	Vl S João
15441	SP	8956	Vila São Jorge	Vl S Jorge
15442	SP	8956	Vila São Jorge (Jardim Silveira)	Vl S Jorge (Jd Silveira)
15443	SP	8956	Vila São Luiz (Centro)	Vl S Luiz (Centro)
15444	SP	8956	Vila São Luiz (Valparaízo)	Vl S Luiz (Valparaízo)
14936	SP	8926	Vila Orestes	Vl Orestes
14937	SP	8926	Vila Ouro Verde	Vl O Verde
14938	SP	8926	Vila Palhares	Vl Palhares
14939	SP	8926	Vila Paraíso	Vl Paraíso
14941	SP	8926	Vila Progresso	Vl Progresso
14942	SP	8926	Vila Prudenciana	Vl Prudenciana
14943	SP	8926	Vila Ribeiro	Vl Ribeiro
14944	SP	8926	Vila Rodrigues	Vl Rodrigues
14945	SP	8926	Vila Rosangela	Vl Rosangela
14946	SP	8926	Vila Santa Cecília	Vl Sta Cecília
14947	SP	8926	Vila Santa Elisa	Vl Sta Elisa
14948	SP	8926	Vila Santa Rita	Vl Sta Rita
14949	SP	8926	Vila Santana	Vl Santana
14950	SP	8926	Vila Santo Antônio	Vl Sto Antônio
14951	SP	8926	Vila São Benedito	Vl S Benedito
14952	SP	8926	Vila São Cristóvão	Vl S Cristóvão
14953	SP	8926	Vila São João	Vl S João
14954	SP	8926	Vila São Jorge	Vl S Jorge
14955	SP	8926	Vila Silvestre	Vl Silvestre
14956	SP	8926	Vila Soubhie	Vl Soubhie
14957	SP	8926	Vila Souza	Vl Souza
14958	SP	8926	Vila Tênis Clube	Vl T Clube
14960	SP	8926	Vila Triângulo	Vl Triângulo
14961	SP	8926	Vila Xavier	Vl Xavier
14962	SP	8926	Vila Zulmira	Vl Zulmira
14963	SP	8926	Vl Glória	V Glória
14965	SP	8928	Alpes de Atibaia	A Atibaia
14966	SP	8928	Alvinópolis	\N
14967	SP	8928	Atibaia Belvedere	A Belvedere
14968	SP	8928	Atibaia Jardim	A Jardim
14969	SP	8928	Atibaia Vista da Montanha	A V Montanha
14972	SP	8928	Bosque dos Eucalíptos	Bsq Eucalíptos
14975	SP	8928	Caetetuba	\N
14978	SP	8928	Centro	\N
14982	SP	8928	Chácara do Camilo	Ch Camilo
14987	SP	8928	Chácaras Fernão Dias	C F Dias
14990	SP	8928	Chácaras Maringá	C Maringá
14996	SP	8928	Chácaras Pizelli	C Pizelli
15001	SP	8928	Cidade Satélite	C Satélite
15002	SP	8928	Colina Verde	C Verde
15009	SP	8928	Estância Parque de Atibaia	Etn Prq Atibaia
15011	SP	8928	Estância Santa Maria do Laranjal	Etn Sta M Laranjal
15012	SP	8928	Estância Santa Maria do Portão	Etn Sta M Portão
15013	SP	8928	Fazenda do Tanque	Faz Tanque
15015	SP	8928	Jardim América	Jd América
15016	SP	8928	Jardim Aurora	Jd Aurora
15018	SP	8928	Jardim Brasil	Jd Brasil
15020	SP	8928	Jardim Brogotá	Jd Brogotá
15021	SP	8928	Jardim Cambarás	Jd Cambarás
15022	SP	8928	Jardim Centenário	Jd Centenário
15023	SP	8928	Jardim Cilar	Jd Cilar
15025	SP	8928	Jardim das Cerejeiras	Jd Cerejeiras
15145	SP	8928	Vila Santista	Vl Santista
15147	SP	8928	Vila Thais	Vl Thais
15149	SP	8928	Vitória Régia	V Régia
15150	SP	8933	Água Branca	A Branca
15151	SP	8933	Alto	\N
15152	SP	8933	Alto da Colina I	At Colina I
15154	SP	8933	Baixada do Glicério	B Glicério
15156	SP	8933	Centro	\N
15157	SP	8933	Chácara Barrocão	Ch Barrocão
15158	SP	8933	Chácara Rancho Alegre	Ch R Alegre
15159	SP	8933	Chácara Recanto da Vó Pepina	Ch Rec V Pepina
15160	SP	8933	Chácara Santa Cecília	Ch Sta Cecília
15161	SP	8933	Chácara Tinoco	Ch Tinoco
15162	SP	8933	Chácara Varginha	Ch Varginha
15164	SP	8933	Colina da Boa Vista	C B Vista
15165	SP	8933	Colina Verde	C Verde
15166	SP	8933	Conjunto Brasil Novo	Cj B Novo
15167	SP	8933	Conjunto Habitacional Altos da Boa Vista	Cj Hab A B Vista
15168	SP	8933	Conjunto Habitacional Doutor Antônio Francisco Inocêncio	Cj Hab Dr A F Inocêncio
15169	SP	8933	Conjunto Habitacional Duílio Contrucci Gambini	Cj Hab D C Gambini
15170	SP	8933	Conjunto Habitacional Egydio Martins da Costa	Cj Hab E M Costa
15171	SP	8933	Conjunto Habitacional Padre Emílio Immos	Cj Hab Pe E Immos
15172	SP	8933	Conjunto Residencial Doutor Cecílio Jorge Neto	Cj Res Dr C J Neto
15175	SP	8933	Estância Brabância	Etn Brabância
15176	SP	8933	Ipiranga	\N
15177	SP	8933	Jardim América	Jd América
15178	SP	8933	Jardim Boa Vista	Jd B Vista
15179	SP	8933	Jardim Bom Sucesso I	Jd B Sucesso I
15180	SP	8933	Jardim Brabância	Jd Brabância
15181	SP	8933	Jardim Brasil	Jd Brasil
15182	SP	8933	Jardim Europa I	Jd Europa I
15183	SP	8933	Jardim Paineiras	Jd Paineiras
15184	SP	8933	Jardim Paraíso	Jd Paraíso
15185	SP	8933	Jardim Paulista	Jd Paulista
15186	SP	8933	Jardim Paulistano	Jd Paulistano
15187	SP	8933	Jardim Pinheiros	Jd Pinheiros
15189	SP	8933	Jardim Presidencial	Jd Presidencial
15190	SP	8933	Jardim Primavera	Jd Primavera
15191	SP	8933	Jardim Santa Cruz	Jd Sta Cruz
15193	SP	8933	Jardim São Paulo	Jd S Paulo
15194	SP	8933	Jardim São Roque	Jd S Roque
15195	SP	8933	Jardim Tropical	Jd Tropical
15196	SP	8933	Jardim Vera Cruz	Jd V Cruz
15197	SP	8933	Loteamento Terras de São José	Lot T S José
15198	SP	8933	Morada do Sol	M Sol
15336	SP	8956	Alphaville Industrial	A Industrial
15339	SP	8956	Alphaville Residencial Doze	A Res Doze
15340	SP	8956	Alphaville Residencial Dois	A Res Dois
15344	SP	8956	Alphaville Residencial Plus	A Res Plus
15348	SP	8956	Alphaville Residencial Um	A Res Um
15349	SP	8956	Alphaville Residencial Zero	A Res Zero
15350	SP	8956	Centro	\N
15351	SP	8956	Centro Comercial	C Comercial
15353	SP	8956	Centro Empresarial Tamboré	C E Tamboré
15354	SP	8956	Chácara do Peroba	Ch Peroba
15355	SP	8956	Chácaras Marco	C Marco
15356	SP	8956	Cidade Industrial Maria Elisa	C Ind M Elisa
15358	SP	8956	Conjunto Industrial Capia	Cj Ind Capia
15359	SP	8956	Empresarial 18 do Forte	E 18 Forte
15360	SP	8956	Jardim Alberto	Jd Alberto
15361	SP	8956	Jardim Audir	Jd Audir
15362	SP	8956	Jardim Barueri	Jd Barueri
15363	SP	8956	Jardim Belval	Jd Belval
15364	SP	8956	Jardim Califórnia	Jd Califórnia
15365	SP	8956	Jardim Comind	Jd Comind
15366	SP	8956	Jardim do Líbano	Jd Líbano
15367	SP	8956	Jardim dos Camargos	Jd Camargos
15368	SP	8956	Jardim Esperança	Jd Esperança
15369	SP	8956	Jardim Flórida	Jd Flórida
15370	SP	8956	Jardim Gabriela	Jd Gabriela
15371	SP	8956	Jardim Iracema	Jd Iracema
15372	SP	8956	Jardim Itaparica	Jd Itaparica
15373	SP	8956	Jardim Itaquiti	Jd Itaquiti
15374	SP	8956	Jardim Júlio	Jd Júlio
15375	SP	8956	Jardim Maria Cristina	Jd M Cristina
15376	SP	8956	Jardim Maria Helena	Jd M Helena
15377	SP	8956	Jardim Maria Tereza	Jd M Tereza
15378	SP	8956	Jardim Mutinga	Jd Mutinga
15379	SP	8956	Jardim Paraíso	Jd Paraíso
15380	SP	8956	Jardim Paulista	Jd Paulista
15381	SP	8956	Jardim Regina Alice	Jd R Alice
15382	SP	8956	Jardim San Diego	Jd S Diego
15383	SP	8956	Jardim Santa Cecília	Jd Sta Cecília
15384	SP	8956	Jardim Santa Mônica	Jd Sta Mônica
15385	SP	8956	Jardim Santo Antônio	Jd Sto Antônio
15386	SP	8956	Jardim São José	Jd S José
15387	SP	8956	Jardim São Pedro	Jd S Pedro
15388	SP	8956	Jardim São Silvestre	Jd S Silvestre
15389	SP	8956	Jardim São Vicente de Paula	Jd S V Paula
15390	SP	8956	Jardim Silveira	Jd Silveira
15391	SP	8956	Jardim Tatiana	Jd Tatiana
15392	SP	8956	Jardim Timbauhy	Jd Timbauhy
15393	SP	8956	Jardim Tupã	Jd Tupã
15394	SP	8956	Jardim Tupan	Jd Tupan
15445	SP	8956	Vila São Miguel	Vl S Miguel
15446	SP	8956	Vila São Silvestre	Vl S Silvestre
15447	SP	8956	Vila Sargento José de Paula	Vl Srg J Paula
15448	SP	8956	Vila Silveira	Vl Silveira
15449	SP	8956	Vila Universal	Vl Universal
15450	SP	8961	Alto Higienópolis	At Higienópolis
15451	SP	8961	Centro	\N
15452	SP	8961	Chácara das Flores	Ch Flores
15454	SP	8961	Chácara São João	Ch S João
15455	SP	8961	Chácara Terra Branca	Ch T Branca
15456	SP	8961	Chácaras Bauruenses	C Bauruenses
15458	SP	8961	Chácaras Cardoso	C Cardoso
15459	SP	8961	Chácaras Cornélia	C Cornélia
15460	SP	8961	Chácaras Urupês	C Urupês
15461	SP	8961	Cidade Jardim	C Jardim
15463	SP	8961	Conjunto Habitacional Darcy César Improta	Cj Hab D C Improta
15464	SP	8961	Conjunto Habitacional Engenheiro Otávio Rasi	Cj Hab Eng O Rasi
15465	SP	8961	Conjunto Habitacional Joaquim Guilherme de Oliveira	Cj Hab J G Oliveira
15466	SP	8961	Núcleo Leão XIII	Nuc Leão XIII
15467	SP	8961	Conjunto Habitacional Pastor Arlindo Lopes Viana	Cj Hab Pst A L Viana
15468	SP	8961	Conjunto Habitacional Presidente Eurico Gaspar Dutra	Cj Hab Pres E G Dutra
15469	SP	8961	Conjunto Habitacional Primavera	Cj Hab Primavera
15470	SP	8961	Distrito Industrial Domingos Biancardi	Dt Ind D Biancardi
15471	SP	8961	Distrito Industrial Marcus Vinícius Feliz Machado	Dt Ind M V F Machado
15472	SP	8961	Distrito Industrial III	Dt Industrial III
15473	SP	8961	Estância Balneária Águas Virtuosas	Etn B A Virtuosas
15474	SP	8961	Estoril Centreville	E Centreville
15475	SP	8961	Ferradura Mirim	F Mirim
15476	SP	8961	Fundação Casas Populares Salvador Filardi	F C P S Filardi
15477	SP	8961	Jardim Aeroporto	Jd Aeroporto
15478	SP	8961	Jardim Alto Bauru	Jd At Bauru
15479	SP	8961	Jardim Alvorada	Jd Alvorada
15480	SP	8961	Jardim Amália	Jd Amália
15481	SP	8961	Jardim América	Jd América
15482	SP	8961	Jardim Ana Lúcia	Jd A Lúcia
15483	SP	8961	Jardim Andorfato	Jd Andorfato
15485	SP	8961	Jardim Araruna	Jd Araruna
15486	SP	8961	Jardim Auri Verde	Jd A Verde
15488	SP	8961	Jardim Bela Vista	Jd B Vista
15489	SP	8961	Jardim Benícia	Jd Benícia
15490	SP	8961	Jardim Bom Samaritano	Jd B Samaritano
15491	SP	8961	Jardim Brasil	Jd Brasil
15546	SP	8961	Jardim Nasralla	Jd Nasralla
15547	SP	8961	Jardim Nicéia	Jd Nicéia
15549	SP	8961	Jardim Nossa Senhora de Lourdes	Jd N Sra Lourdes
15550	SP	8961	Jardim Nova Bauru	Jd N Bauru
15551	SP	8961	Jardim Nova Esperança	Jd N Esperança
15552	SP	8961	Jardim Olímpico	Jd Olímpico
15553	SP	8961	Jardim Ouro Verde	Jd O Verde
15555	SP	8961	Jardim Panorama	Jd Panorama
15556	SP	8961	Jardim Paulista	Jd Paulista
15557	SP	8961	Jardim Petrópolis	Jd Petrópolis
15558	SP	8961	Jardim Planalto	Jd Planalto
15559	SP	8961	Jardim Progresso	Jd Progresso
15560	SP	8961	Jardim Prudência	Jd Prudência
15561	SP	8961	Jardim Redentor	Jd Redentor
15562	SP	8961	Jardim Rosa Branca	Jd R Branca
15563	SP	8961	Jardim Rosas do Sul	Jd R Sul
15564	SP	8961	Jardim Samburá	Jd Samburá
15565	SP	8961	Jardim Santana	Jd Santana
15566	SP	8961	Jardim Santos Dumont	Jd Stos Dumont
15568	SP	8961	Jardim São Judas	Jd S Judas
15569	SP	8961	Jardim Shangri-Lá	Jd Shangri-Lá
15570	SP	8961	Jardim Silvestri	Jd Silvestri
15571	SP	8961	Jardim Solange	Jd Solange
15572	SP	8961	Jardim Terra Branca	Jd T Branca
15573	SP	8961	Jardim TV	Jd TV
15601	SP	8961	Parque City	Prq City
15574	SP	8961	Jardim Vânia Maria	Jd V Maria
15575	SP	8961	Jardim Vitória	Jd Vitória
15576	SP	8961	Jardim Yolanda	Jd Yolanda
15578	SP	8961	Loteamento Mário Luiz Rodrigues do Prado	Lot M L R Prado
15579	SP	8961	Madureira	\N
15581	SP	8961	Novo Jardim Pagani	N Jd Pagani
15582	SP	8961	Núcleo Eldorado	Nuc Eldorado
15583	SP	8961	Núcleo Habitacional Fortunato Rocha Lima	Nuc Hab F R Lima
15584	SP	8961	Núcleo Habitacional José Regino	Nuc Hab J Regino
15585	SP	8961	Núcleo Habitacional Mary Dota	Nuc Hab M Dota
15587	SP	8961	Núcleo Habitacional Vanuire	Nuc Hab Vanuire
15588	SP	8961	Núcleo Habitacional Vereador Edson Francisco da Silva	Nuc Hab Ver E F Silva
15589	SP	8961	Núcleo Nove de Julho	Nuc N Julho
15590	SP	8961	Núcleo Residencial Alto Alegre	Nuc Res At Alegre
15591	SP	8961	Núcleo Residencial Beija-Flor	Nuc Res Beija-Flor
15592	SP	8961	Núcleo Residencial Edison Bastos Gasparini	Nuc Res E B Gasparini
15593	SP	8961	Núcleo Residencial Perdizes	Nuc Res Perdizes
15594	SP	8961	Núcleo Residencial Presidente Geisel	Nuc Res Pres Geisel
15644	SP	8961	Residencial do Bosque	Res Bosque
15645	SP	8961	Residencial Doutor Manoel Lopes	Res Dr M Lopes
15646	SP	8961	Residencial Jardim Jussara	Res Jd Jussara
15647	SP	8961	Residencial Nova Bauru	Res N Bauru
15650	SP	8961	Residencial Parque Colina Verde	Res Prq C Verde
15653	SP	8961	Residencial Parque Granja Cecília A	Res Prq Gja Cecília A
15654	SP	8961	Residencial Parque Granja Cecília B	Res Prq Gja Cecília B
15655	SP	8961	Residencial Tivoli	Res Tivoli
15656	SP	8961	Samambaia Parque Residencial	S Prq Residencial
15657	SP	8961	Santa Fé	Sta Fé
15658	SP	8961	Sítios Village Paineiras	S V Paineiras
15659	SP	8961	Tangarás	\N
15660	SP	8961	Vale do Igapó	Vle Igapó
15661	SP	8961	Vila Aeroporto Bauru	Vl Aer Bauru
15662	SP	8961	Vila Aimorés	Vl Aimorés
15663	SP	8961	Vila Altinópolis	Vl Altinópolis
15664	SP	8961	Vila Alto Paraíso	Vl At Paraíso
15665	SP	8961	Vila América	Vl América
15666	SP	8961	Vila Antártica	Vl Antártica
15668	SP	8961	Vila Aviação	Vl Aviação
15669	SP	8961	Vila Aviação B	Vl Aviação B
15670	SP	8961	Vila Becheli	Vl Becheli
15671	SP	8961	Vila Bela	Vl Bela
15673	SP	8961	Vila Bom Jesus	Vl B Jesus
15674	SP	8961	Vila Bonfim	Vl Bonfim
15675	SP	8961	Vila Brunhari	Vl Brunhari
15676	SP	8961	Vila Camargo	Vl Camargo
15677	SP	8961	Vila Cardia	Vl Cardia
15678	SP	8961	Vila Carmem	Vl Carmem
15679	SP	8961	Vila Carolina	Vl Carolina
15680	SP	8961	Vila Carvalho	Vl Carvalho
15681	SP	8961	Vila Cidade Universitária	Vl C Universitária
15682	SP	8961	Vila Conceição	Vl Conceição
15683	SP	8961	Vila Coralina	Vl Coralina
15684	SP	8961	Vila Cordeiro	Vl Cordeiro
15685	SP	8961	Vila D'Aro	Vl D'Aro
15687	SP	8961	Vila Dutra	Vl Dutra
15688	SP	8961	Vila Engler	Vl Engler
15690	SP	8961	Vila Falcão	Vl Falcão
15692	SP	8961	Vila Flores	Vl Flores
15693	SP	8961	Vila Formosa	Vl Formosa
15694	SP	8961	Vila Frutuoso Dias	Vl F Dias
15695	SP	8961	Vila Galvão	Vl Galvão
15696	SP	8961	Vila Garcia	Vl Garcia
15697	SP	8961	Vila Gimenes	Vl Gimenes
15698	SP	8961	Vila Giunta	Vl Giunta
15699	SP	8961	Vila Gonçalves	Vl Gonçalves
15701	SP	8961	Vila Guedes de Azevedo	Vl G Azevedo
15702	SP	8961	Vila Independência	Vl Independência
15703	SP	8961	Vila Industrial	Vl Industrial
15762	SP	8961	Vila Tecnológica Engenheiro José Queda	Vl T Eng J Queda
15764	SP	8961	Vila Triagem	Vl Triagem
15765	SP	8961	Vila Vergueiro	Vl Vergueiro
15768	SP	8961	Vila Zillo	Vl Zillo
15769	SP	8962	Centro	\N
15770	SP	8962	Chácaras Parati	C Parati
15771	SP	8962	Cidade Coração	C Coração
15773	SP	8962	Conjunto Primavera	Cj Primavera
15774	SP	8962	Distrito Industrial I	Dt Industrial I
15775	SP	8962	Distrito Industrial II	Dt Industrial II
15776	SP	8962	Distrito Industrial III	Dt Industrial III
15777	SP	8962	Jardim Aeroporto	Jd Aeroporto
15778	SP	8962	Jardim Alvorada	Jd Alvorada
15779	SP	8962	Jardim Califórnia	Jd Califórnia
15780	SP	8962	Jardim Canadá	Jd Canadá
15781	SP	8962	Jardim Casagrande	Jd Casagrande
15782	SP	8962	Jardim Ciranda	Jd Ciranda
15783	SP	8962	Jardim Claudia I	Jd Claudia I
15784	SP	8962	Jardim Claudia II	Jd Claudia II
15785	SP	8962	Jardim Cruzeiro do Sul	Jd C Sul
15786	SP	8962	Jardim das Acácias	Jd Acácias
15787	SP	8962	Jardim das Laranjeiras	Jd Laranjeiras
15788	SP	8962	Jardim de Lúcia	Jd Lúcia
15789	SP	8962	Jardim do Bosque	Jd Bosque
15790	SP	8962	Jardim do Sonho	Jd Sonho
15791	SP	8962	Jardim Esplanada	Jd Esplanada
15792	SP	8962	Jardim Estoril	Jd Estoril
15793	SP	8962	Jardim Júlia	Jd Júlia
15795	SP	8962	Jardim Luciana	Jd Luciana
15796	SP	8962	Jardim Marajá	Jd Marajá
15797	SP	8962	Jardim Menino Deus I	Jd Men Deus I
15798	SP	8962	Jardim Menino Deus II	Jd Men Deus II
15800	SP	8962	Jardim Paraíso	Jd Paraíso
15801	SP	8962	Jardim Parati II	Jd Parati II
15802	SP	8962	Jardim Piratininga	Jd Piratininga
15803	SP	8962	Jardim Progresso	Jd Progresso
15804	SP	8962	Jardim Recanto	Jd Recanto
15805	SP	8962	Jardim Santa Terezinha	Jd Sta Terezinha
15807	SP	8962	Jardim São João	Jd S João
15808	SP	8962	Jardim São Sebastião	Jd S Sebastião
15809	SP	8962	Jardim Souza Lima	Jd S Lima
15810	SP	8962	Jardim Talarico	Jd Talarico
15811	SP	8962	Jardim Tropical	Jd Tropical
15812	SP	8962	Jardim 3 Marias	Jd 3 Marias
15813	SP	8962	Parque Residencial Eldorado	Prq Res Eldorado
15814	SP	8962	Parque Residencial Irmãos Furquim	Prq Res Imos Furquim
15815	SP	8962	Parque Residencial Santo Antônio	Prq Res Sto Antônio
15881	SP	8969	Jardim Primavera	Jd Primavera
15882	SP	8969	Jardim Recanto dos Pássaros	Jd Rec Pássaros
15885	SP	8969	Jardim São Braz	Jd S Braz
15886	SP	8969	Jardim São Conrado	Jd S Conrado
15887	SP	8969	Jardim São Cristóvão	Jd S Cristóvão
15888	SP	8969	Jardim São Genaro	Jd S Genaro
15890	SP	8969	Jardim São Paulo	Jd S Paulo
15891	SP	8969	Jardim Stábile	Jd Stábile
15892	SP	8969	Jardim Sumaré	Jd Sumaré
15893	SP	8969	Jardim Tangará	Jd Tangará
15895	SP	8969	Jardim Toselar	Jd Toselar
15896	SP	8969	Jardim Tropical	Jd Tropical
15897	SP	8969	Jardim Vale do Sol	Jd Vle Sol
15898	SP	8969	Novo Jardim Stábile	N Jd Stábile
15899	SP	8969	Novo Jardim Toselar	N Jd Toselar
15900	SP	8969	Novo Parque São Vicente	N Prq S Vicente
15902	SP	8969	Nucleo Habitacional Ivone Alves Palma	N Hab I A Palma
15903	SP	8969	Núcleo Habitacional Thereza Maria Barbieri	Nuc Hab T M Barbieri
15904	SP	8969	Parque das Nações	Prq Nações
15905	SP	8969	Parque das Paineiras	Prq Paineiras
15906	SP	8969	Parque Residencial América	Prq Res América
15907	SP	8969	Parque Residencial Laluce	Prq Res Laluce
15908	SP	8969	Parque Residencial Nelson Calixto	Prq Res N Calixto
15910	SP	8969	Parque São Vicente	Prq S Vicente
15911	SP	8969	Patrimônio Santo Antônio	P Sto Antônio
15912	SP	8969	Patrimônio Silvares	P Silvares
15913	SP	8969	Perdizes Residencial Parque	P Res Parque
15914	SP	8969	Recanto Verde	Rec Verde
15915	SP	8969	Residencial Alvorada	Res Alvorada
15917	SP	8969	Residencial Capuano	Res Capuano
15918	SP	8969	Residencial Ibisa	Res Ibisa
15919	SP	8969	Residencial Manuela	Res Manuela
15920	SP	8969	Residencial Monte Líbano	Res Mte Líbano
15921	SP	8969	Residencial São Francisco	Res S Francisco
15922	SP	8969	Residencial São José	Res S José
15923	SP	8969	Sítio de Recreio Passaredo	Sit Rcr Passaredo
15925	SP	8969	Vila Angélica	Vl Angélica
15926	SP	8969	Vila Bandeirantes	Vl Bandeirantes
15928	SP	8969	Vila Cortellazi	Vl Cortellazi
15929	SP	8969	Vila Gardenal	Vl Gardenal
15930	SP	8969	Vila Germano	Vl Germano
15931	SP	8969	Vila Giampietro	Vl Giampietro
15932	SP	8969	Vila Guanabara	Vl Guanabara
15933	SP	8969	Vila Guarujá	Vl Guarujá
15935	SP	8969	Vila Isabel Marin	Vl I Marin
15492	SP	8961	Jardim Brasília	Jd Brasília
15493	SP	8961	Jardim Carvalho	Jd Carvalho
15494	SP	8961	Jardim Cecap	Jd Cecap
15495	SP	8961	Jardim Central	Jd Central
15496	SP	8961	Jardim Chapadão	Jd Chapadão
15497	SP	8961	Jardim Colonial	Jd Colonial
15498	SP	8961	Jardim Contorno	Jd Contorno
15499	SP	8961	Jardim Coral	Jd Coral
15500	SP	8961	Jardim Country Club	Jd C Club
15501	SP	8961	Jardim Cruzeiro do Sul	Jd C Sul
15502	SP	8961	Jardim da Grama	Jd Grama
15503	SP	8961	Jardim Dalila	Jd Dalila
15504	SP	8961	Jardim das Orquídeas	Jd Orquídeas
15505	SP	8961	Jardim de Allah	Jd Allah
15507	SP	8961	Jardim Dona Lili	Jd Da Lili
15508	SP	8961	Jardim Dona Sarah	Jd Da Sarah
15509	SP	8961	Jardim Eldorado	Jd Eldorado
15510	SP	8961	Jardim Esplanada	Jd Esplanada
15511	SP	8961	Jardim Estoril	Jd Estoril
15512	SP	8961	Jardim Estoril II	Jd Estoril II
15513	SP	8961	Jardim Estoril III	Jd Estoril III
15514	SP	8961	Jardim Estoril IV	Jd Estoril IV
15515	SP	8961	Jardim Estrela D'Alva	Jd E D'Alva
15516	SP	8961	Jardim Eugênia	Jd Eugênia
15517	SP	8961	Jardim Europa	Jd Europa
15518	SP	8961	Jardim Faria	Jd Faria
15519	SP	8961	Jardim Ferraz	Jd Ferraz
15520	SP	8961	Jardim Flórida	Jd Flórida
15521	SP	8961	Jardim Fonte do Castelo	Jd Fnt Castelo
15522	SP	8961	Jardim Gaivota	Jd Gaivota
15523	SP	8961	Jardim Gerson França	Jd G França
15524	SP	8961	Jardim Godoy	Jd Godoy
15525	SP	8961	Jardim Guadalajara	Jd Guadalajara
15526	SP	8961	Jardim Hojas	Jd Hojas
15528	SP	8961	Jardim Imperial	Jd Imperial
15529	SP	8961	Jardim Infante Dom Henrique	Jd Inf D Henrique
15530	SP	8961	Jardim Ivone	Jd Ivone
15531	SP	8961	Jardim Jacyra	Jd Jacyra
15532	SP	8961	Jardim Jamil	Jd Jamil
15533	SP	8961	Jardim Jandira	Jd Jandira
15534	SP	8961	Jardim José Kalil	Jd J Kalil
15536	SP	8961	Jardim Marabá	Jd Marabá
15537	SP	8961	Jardim Marambá	Jd Marambá
15538	SP	8961	Jardim Maravilha	Jd Maravilha
15539	SP	8961	Jardim Maria Angélica	Jd M Angélica
15540	SP	8961	Jardim Maria Célia	Jd M Célia
15541	SP	8961	Jardim Marília	Jd Marília
15542	SP	8961	Jardim Marilu	Jd Marilu
15543	SP	8961	Jardim Marise	Jd Marise
15544	SP	8961	Jardim Mary	Jd Mary
15545	SP	8961	Jardim Mendonça	Jd Mendonça
15595	SP	8961	Panorama Parque	P Parque
15596	SP	8961	Parque Alto Sumaré	Prq At Sumaré
15597	SP	8961	Parque Bauru	Prq Bauru
15599	SP	8961	Parque Baurulândia	Prq Baurulândia
15600	SP	8961	Parque Boa Vista	Prq B Vista
15602	SP	8961	Parque Continental	Prq Continental
15603	SP	8961	Parque das Nações	Prq Nações
15604	SP	8961	Parque dos Eucaliptos	Prq Eucaliptos
15605	SP	8961	Parque Floresta	Prq Floresta
15606	SP	8961	Parque Fortaleza	Prq Fortaleza
15607	SP	8961	Parque Giansante	Prq Giansante
15608	SP	8961	Parque Hipódromo	Prq Hipódromo
15609	SP	8961	Parque Industrial Manchester	Prq Ind Manchester
15610	SP	8961	Parque Jandaia	Prq Jandaia
15611	SP	8961	Parque Jaraguá	Prq Jaraguá
15612	SP	8961	Parque Jardim Europa	Prq Jd Europa
15613	SP	8961	Parque Júlio Nóbrega	Prq J Nóbrega
15615	SP	8961	Parque Novo São Geraldo	Prq N S Geraldo
15616	SP	8961	Parque Paulista	Prq Paulista
15617	SP	8961	Parque Paulistano	Prq Paulistano
15618	SP	8961	Parque Primavera	Prq Primavera
15619	SP	8961	Parque Real	Prq Real
15620	SP	8961	Parque Residencial Castelo	Prq Res Castelo
15621	SP	8961	Parque Residencial das Camélias	Prq Res Camélias
15623	SP	8961	Parque Residencial Jardim Araruna	Prq Res Jd Araruna
15624	SP	8961	Parque Residencial Paineiras	Prq Res Paineiras
15625	SP	8961	Parque Roosevelt	Prq Roosevelt
15626	SP	8961	Parque Santa Cândida	Prq Sta Cândida
15627	SP	8961	Parque Santa Cecília	Prq Sta Cecília
15628	SP	8961	Parque Santa Edwiges	Prq Sta Edwiges
15629	SP	8961	Parque Santa Rita	Prq Sta Rita
15630	SP	8961	Parque Santa Terezinha	Prq Sta Terezinha
15631	SP	8961	Parque São Cristóvão	Prq S Cristóvão
15632	SP	8961	Parque São Geraldo	Prq S Geraldo
15633	SP	8961	Parque São João	Prq S João
15635	SP	8961	Parque Sergipe	Prq Sergipe
15636	SP	8961	Parque União	Prq União
15637	SP	8961	Parque Val de Palmas	Prq V Palmas
15638	SP	8961	Parque Viaduto	Prq Viaduto
15639	SP	8961	Parque Vista Alegre	Prq V Alegre
15640	SP	8961	Pousada da Esperança I	P Esperança I
15641	SP	8961	Quinta da Bela Olinda	Qta B Olinda
15642	SP	8961	Recanto Aprazível	Rec Aprazível
15643	SP	8961	Recanto Maricel	Rec Maricel
15704	SP	8961	Vila Ipiranga	Vl Ipiranga
15705	SP	8961	Vila Jardim Celina	Vl Jd Celina
15706	SP	8961	Vila Leme da Silva	Vl L Silva
15707	SP	8961	Vila Lemos	Vl Lemos
15708	SP	8961	Vila Maracy	Vl Maracy
15709	SP	8961	Vila Marajoara	Vl Marajoara
15710	SP	8961	Vila Maria	Vl Maria
15711	SP	8961	Vila Mariana	Vl Mariana
15713	SP	8961	Vila Martha	Vl Martha
15714	SP	8961	Vila Mesquita	Vl Mesquita
15715	SP	8961	Vila Monlevade	Vl Monlevade
15716	SP	8961	Vila Nipônica	Vl Nipônica
15717	SP	8961	Vila Noemy	Vl Noemy
15718	SP	8961	Vila Noroeste	Vl Noroeste
15719	SP	8961	Vila Nova Cidade Universitária	Vl N C Universitária
15720	SP	8961	Vila Nova Nipônica	Vl N Nipônica
15721	SP	8961	Vila Nova Paulista	Vl N Paulista
15722	SP	8961	Vila Nova Santa Clara	Vl N Sta Clara
15724	SP	8961	Vila Nova Santa Luzia	Vl N Sta Luzia
15725	SP	8961	Vila Nove de Julho	Vl N Julho
15726	SP	8961	Vila Pacífico	Vl Pacífico
15728	SP	8961	Vila Paulista	Vl Paulista
15729	SP	8961	Vila Pelegrina	Vl Pelegrina
15730	SP	8961	Vila Perroca	Vl Perroca
15731	SP	8961	Vila Popular	Vl Popular
15732	SP	8961	Vila Quaggio	Vl Quaggio
15733	SP	8961	Vila Razuk	Vl Razuk
15734	SP	8961	Vila Regina	Vl Regina
15737	SP	8961	Vila Riachuelo	Vl Riachuelo
15738	SP	8961	Vila Rocha	Vl Rocha
15739	SP	8961	Vila Samaritana	Vl Samaritana
15740	SP	8961	Vila Santa Filomena	Vl Sta Filomena
15741	SP	8961	Vila Santa Inês	Vl Sta Inês
15742	SP	8961	Vila Santa Izabel	Vl Sta Izabel
15743	SP	8961	Vila Santa Lúcia	Vl Sta Lúcia
15744	SP	8961	Vila Santa Luzia	Vl Sta Luzia
15745	SP	8961	Vila Santa Rosa	Vl Sta Rosa
15746	SP	8961	Vila Santa Tereza	Vl Sta Tereza
15747	SP	8961	Vila Santa Terezinha	Vl Sta Terezinha
15748	SP	8961	Vila Santista	Vl Santista
15749	SP	8961	Vila Santo Antônio	Vl Sto Antônio
15750	SP	8961	Vila São Francisco	Vl S Francisco
15752	SP	8961	Vila São João da Boa Vista	Vl S J B Vista
15753	SP	8961	Vila São João do Ipiranga	Vl S J Ipiranga
15754	SP	8961	Vila São Manoel	Vl S Manoel
15755	SP	8961	Vila São Paulo	Vl S Paulo
15757	SP	8961	Vila Seabra	Vl Seabra
15758	SP	8961	Vila Serrão	Vl Serrão
15759	SP	8961	Vila Silva Pinto	Vl S Pinto
15760	SP	8961	Vila Souto	Vl Souto
15816	SP	8962	Residencial Antonia Santaella	Res A Santaella
15817	SP	8962	Residencial Bebedouro	Res Bebedouro
15818	SP	8962	Residencial Candinho	Res Candinho
15819	SP	8962	Residencial Centenário	Res Centenário
15820	SP	8962	Residencial Franciscano	Res Franciscano
15821	SP	8962	Residencial Parati	Res Parati
15822	SP	8962	Residencial Pedro Maia	Res P Maia
15823	SP	8962	Residencial Rassim Dibe	Res R Dibe
15824	SP	8962	Residencial União	Res União
15825	SP	8962	Residencial Vale do Sol	Res Vle Sol
15827	SP	8962	Vila Alto do Sumaré	Vl At Sumaré
15828	SP	8962	Vila Bom Retiro	Vl B Retiro
15829	SP	8962	Vila Califórnia	Vl Califórnia
15830	SP	8962	Vila Elisabeth	Vl Elisabeth
15831	SP	8962	Vila Irmã Antonieta Farani	Vl Ima A Farani
15832	SP	8962	Vila Julieta	Vl Julieta
15833	SP	8962	Vila Lourdes Hortal	Vl L Hortal
15834	SP	8962	Vila Major Cícero de Carvalho	Vl Maj C Carvalho
15835	SP	8962	Vila Maria	Vl Maria
15836	SP	8962	Vila Monte Castelo	Vl Mte Castelo
15837	SP	8962	Vila Novo Lar	Vl N Lar
15838	SP	8962	Vila Paula	Vl Paula
15840	SP	8962	Vila Sanderson	Vl Sanderson
15842	SP	8969	Bosque da Saúde	Bsq Saúde
15843	SP	8969	Centro	\N
15844	SP	8969	Chácaras Caiçara	C Caiçara
15845	SP	8969	Chácara de Recreio Santo Antônio	Ch Rcr Sto Antônio
15848	SP	8969	Chácara de Recreio Terence	Ch Rcr Terence
15850	SP	8969	Cidade Jardim	C Jardim
15853	SP	8969	Distrito Industrial	Dt Industrial
15854	SP	8969	Jandaia Residencial Parque	J Res Parque
15856	SP	8969	Jardim Arco-Íris	Jd Arco-Íris
15857	SP	8969	Jardim Bela Vista	Jd B Vista
15860	SP	8969	Jardim Costa Rica	Jd C Rica
15861	SP	8969	Jardim da Fonte	Jd Fonte
15863	SP	8969	Jardim Estoril	Jd Estoril
15864	SP	8969	Jardim Europa	Jd Europa
15865	SP	8969	Jardim Flamengo	Jd Flamengo
15867	SP	8969	Jardim Icaray	Jd Icaray
15869	SP	8969	Jardim Jussara Maria	Jd J Maria
15870	SP	8969	Jardim Klayton	Jd Klayton
15871	SP	8969	Jardim Marister	Jd Marister
15873	SP	8969	Jardim Morumbi	Jd Morumbi
15874	SP	8969	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
15876	SP	8969	Jardim Pérola	Jd Pérola
15877	SP	8969	Jardim Pinheiros	Jd Pinheiros
15878	SP	8969	Jardim Planalto	Jd Planalto
15879	SP	8969	Jardim Popi	Jd Popi
15936	SP	8969	Vila Maria	Vl Maria
15937	SP	8969	Vila Moimaz	Vl Moimaz
15939	SP	8969	Vila Pontes	Vl Pontes
15940	SP	8969	Vila Roberto	Vl Roberto
15941	SP	8969	Vila Saudades	Vl Saudades
15942	SP	8969	Vila Silvares	Vl Silvares
15943	SP	8969	Vila Staff	Vl Staff
15945	SP	8969	Vila Xavier	Vl Xavier
15946	SP	8989	Alto	\N
15947	SP	8989	Conjunto Habitacional Popular Altos	Cj Hab P Altos
15948	SP	8989	Altos do Paraíso	A Paraíso
15949	SP	8989	Anhumas	\N
15951	SP	8989	Centro	\N
15953	SP	8989	Chácara Capão Bonito	Ch C Bonito
15955	SP	8989	Chácara Floresta	Ch Floresta
15956	SP	8989	Chácara Montagna	Ch Montagna
15957	SP	8989	Chácara Recreio do Havaí	Ch Rcr Havaí
15958	SP	8989	Chácara Recreio Vista Alegre	Ch Rcr V Alegre
15959	SP	8989	Chácaras Reunidas Vista Alegre	C R V Alegre
15960	SP	8989	Conjunto Habitacional Antonio Hermínio Delevedove	Cj Hab A H Delevedove
15961	SP	8989	Conjunto Habitacional Arnaldo Leotta de Mello	Cj Hab A L Mello
15964	SP	8989	Conjunto Habitacional Dom Henrique Goland Trindade	Cj Hab D H G Trindade
15966	SP	8989	Conjunto Habitacional Doutor Antonio Delmanto	Cj Hab Dr A Delmanto
15967	SP	8989	Conjunto Habitacional Engenheiro Francisco Blasi	Cj Hab Eng F Blasi
15968	SP	8989	Conjunto Habitacional Humberto Popolo	Cj Hab H Popolo
15969	SP	8989	Conjunto Habitacional Roque Ortiz Filho	Cj Hab R O Filho
15970	SP	8989	Conjunto Residencial Frei Fidelis	Cj Res Fr Fidelis
15971	SP	8989	Conjunto Residencial Indamar	Cj Res Indamar
15973	SP	8989	Conjunto Residencial Souza Santos	Cj Res S Santos
15974	SP	8989	Distrito Industrial	Dt Industrial
15976	SP	8989	Jardim Aeroporto	Jd Aeroporto
15977	SP	8989	Jardim Alvorada	Jd Alvorada
15978	SP	8989	Jardim Bandeirantes	Jd Bandeirantes
15979	SP	8989	Jardim Bom Pastor	Jd B Pastor
15980	SP	8989	Jardim Brasil	Jd Brasil
15981	SP	8989	Jardim Centenário	Jd Centenário
15982	SP	8989	Jardim Central	Jd Central
15983	SP	8989	Jardim Chácara dos Pinheiros	Jd Ch Pinheiros
15985	SP	8989	Jardim Ciranda	Jd Ciranda
15986	SP	8989	Jardim Continental	Jd Continental
15987	SP	8989	Jardim Cristina	Jd Cristina
15988	SP	8989	Jardim Dom Henrique	Jd D Henrique
15989	SP	8989	Jardim Dona Carolina	Jd Da Carolina
15990	SP	8989	Jardim Dona Nicota de Barros	Jd Da N Barros
15991	SP	8989	Jardim Europa	Jd Europa
15992	SP	8989	Jardim Evelyn	Jd Evelyn
15993	SP	8989	Jardim Flamboyant	Jd Flamboyant
15994	SP	8989	Jardim Ipyranga	Jd Ipyranga
15995	SP	8989	Jardim Itamarati	Jd Itamarati
15996	SP	8989	Jardim Monte Mor	Jd Mte Mor
15997	SP	8989	Jardim Nossa Senhora da Penha	Jd N Sra Penha
15998	SP	8989	Jardim Palos Verdes	Jd P Verdes
15999	SP	8989	Jardim Panorama	Jd Panorama
16000	SP	8989	Jardim Paraíso	Jd Paraíso
16001	SP	8989	Jardim Paraíso II	Jd Paraíso II
16002	SP	8989	Jardim Peabiru	Jd Peabiru
16003	SP	8989	Jardim Planalto	Jd Planalto
16005	SP	8989	Jardim Real Park	Jd R Park
16006	SP	8989	Jardim Reflorenda	Jd Reflorenda
16007	SP	8989	Jardim Riviera	Jd Riviera
16008	SP	8989	Jardim Santa Cecília	Jd Sta Cecília
16009	SP	8989	Jardim Santa Eliza	Jd Sta Eliza
16010	SP	8989	Jardim Santa Mônica	Jd Sta Mônica
16011	SP	8989	Jardim Santa Thereza	Jd Sta Thereza
16012	SP	8989	Jardim São Vicente	Jd S Vicente
16013	SP	8989	Jardim Tropical	Jd Tropical
16014	SP	8989	Jardim Universitário	Jd Universitário
16015	SP	8989	Jardim Vista Linda	Jd V Linda
16017	SP	8989	Loteamento Jardim Eldorado	Lot Jd Eldorado
16018	SP	8989	Park Residencial Convívio	P Res Convívio
16019	SP	8989	Parque das Cascatas	Prq Cascatas
16020	SP	8989	Parque dos Laranjais	Prq Laranjais
16021	SP	8989	Parque dos Pinheiros	Prq Pinheiros
16022	SP	8989	Parque Imperial	Prq Imperial
16023	SP	8989	Parque Marajoara	Prq Marajoara
16024	SP	8989	Parque Residencial Nazaré	Prq Res Nazaré
16025	SP	8989	Parque Residencial Primavera	Prq Res Primavera
16046	SP	8989	Vila Éden	Vl Éden
16027	SP	8989	Parque Residencial Vinte e Quatro de Maio	Prq Res V E Q Maio
16028	SP	8989	Parque São Domingos	Prq S Domingos
16030	SP	8989	Portal das Brisas	P Brisas
16031	SP	8989	Recanto Árvore Grande	Rec A Grande
16032	SP	8989	Recanto Azul	Rec Azul
16033	SP	8989	Recanto da Amizade	Rec Amizade
16034	SP	8989	Vale do Sol	Vle Sol
16035	SP	8989	Vila Angela	Vl Angela
16036	SP	8989	Vila Antártica	Vl Antártica
16038	SP	8989	Vila Assumpção	Vl Assumpção
16039	SP	8989	Vila Auxiliadora	Vl Auxiliadora
16040	SP	8989	Vila Bela Vista	Vl B Vista
16123	SP	8992	Jardim Nova Bragança	Jd N Bragança
16125	SP	8992	Jardim Novo Mundo	Jd N Mundo
16128	SP	8992	Jardim Recreio	Jd Recreio
16129	SP	8992	Residencial Santa Helena	Res Sta Helena
16130	SP	8992	Jardim Santa Rita de Cássia	Jd Sta R Cássia
16133	SP	8992	Jardim São José	Jd S José
16134	SP	8992	Jardim São Lourenço	Jd S Lourenço
16135	SP	8992	Jardim São Miguel	Jd S Miguel
16139	SP	8992	Matadouro	\N
16141	SP	8992	Parque Brasil	Prq Brasil
16144	SP	8992	Penha	\N
16149	SP	8992	Residencial Hípica Jaguari	Res H Jaguari
16150	SP	8992	Residencial Rosário de Fátima	Res R Fátima
16152	SP	8992	Santa Luzia	Sta Luzia
16157	SP	8992	Aparecida	\N
16173	SP	8992	Vila Mota	Vl Mota
16174	SP	8992	Vila Municipal	Vl Municipal
16182	SP	8992	Vila Santa Libânia	Vl Sta Libânia
16188	SP	9005	Caçapava Velha	C Velha
16189	SP	9005	Centro	\N
16190	SP	9005	Chácaras Santa Rita	C Sta Rita
16196	SP	9005	Jardim Caçapava	Jd Caçapava
16197	SP	9005	Jardim Campo Grande	Jd Cpo Grande
16203	SP	9005	Jardim Maria Cândida	Jd M Cândida
16205	SP	9005	Jardim Primavera	Jd Primavera
16206	SP	9005	Jardim Rafael	Jd Rafael
16208	SP	9005	Jardim São José	Jd S José
16211	SP	9005	Parque Maria Elmira	Prq M Elmira
16213	SP	9005	Parque Residencial Alvorada	Prq Res Alvorada
16214	SP	9005	Parque Residencial Eldorado	Prq Res Eldorado
16215	SP	9005	Loteamento Pinus de Iriguassu	Lot P Iriguassu
16216	SP	9005	Parque Residencial Maria Elmira	Prq Res M Elmira
16217	SP	9005	Parque Residencial Nova Caçapava	Prq Res N Caçapava
16218	SP	9005	Piedade	\N
16219	SP	9005	Recanto do Sol	Rec Sol
16223	SP	9005	Sítios de Recreio Mantiqueira	S Rcr Mantiqueira
16224	SP	9005	Vera Cruz	V Cruz
16225	SP	9005	Vila André Martins	Vl A Martins
16226	SP	9005	Vila Antônio Augusto Luiz	Vl A A Luiz
16230	SP	9005	Vila Galvão	Vl Galvão
16231	SP	9005	Vila Henrique	Vl Henrique
16235	SP	9005	Vila Medeiros	Vl Medeiros
16236	SP	9005	Vila Menino Jesus	Vl Men Jesus
16240	SP	9005	Vila Paraíba	Vl Paraíba
16242	SP	9005	Vila Pascoal	Vl Pascoal
16246	SP	9005	Vila Resende	Vl Resende
16248	SP	9005	Vila Santa Izabel	Vl Sta Izabel
16249	SP	9005	Vila Santos	Vl Santos
16251	SP	9005	Vila São João	Vl S João
16331	SP	9025	Dic I (Conjunto Habitacional Monsenhor Luiz Fernando Abreu)	Dic I (Cj Hab Mns L F Abreu)
16333	SP	9025	Dic II (Conj Habitacional Doutor Antônio Mendonça de Barros)	Dic II (C Hab Dr A M Barros)
16334	SP	9025	Dic III (Conjunto Habitacional Ruy Novaes)	Dic III (Cj Hab R Novaes)
16335	SP	9025	Dic IV (Conjunto Habitacional Lech Walesa)	Dic IV (Cj Hab L Walesa)
16336	SP	9025	Dic V (Conjunto Habitacional Chico Mendes)	Dic V (Cj Hab C Mendes)
16337	SP	9025	Dic VI (Conjunto Habitacional Santo Dias Silva)	Dic VI (Cj Hab Sto D Silva)
16339	SP	9025	Distrito Industrial	Dt Industrial
16340	SP	9025	Arruamento Fain José Feres	A F J Feres
16341	SP	9025	Parque Rural Fazenda Santa Cândida	Prq R Faz Sta Cândida
16342	SP	9025	Fazenda Santana (Sousas)	Faz Santana (Sousas)
16343	SP	9025	Fundação da Casa Popular	F C Popular
16348	SP	9025	Imperial Parque (Sousas)	I Parque (Sousas)
16350	SP	9025	Jardim Adhemar de Barros	Jd A Barros
16351	SP	9025	Jardim Aero Continental	Jd A Continental
16352	SP	9025	Jardim Aeronave de Viracopos	Jd A Viracopos
16353	SP	9025	Jardim Aeroporto de Campinas	Jd Aer Campinas
16354	SP	9025	Jardim Afife	Jd Afife
16355	SP	9025	Jardim Aliança	Jd Aliança
16356	SP	9025	Jardim Alto Cambui	Jd At Cambui
16357	SP	9025	Jardim Alto da Barra	Jd At Barra
16358	SP	9025	Jardim Alto da Cidade Universitária	Jd At C Universitária
16359	SP	9025	Jardim Alvorada	Jd Alvorada
16360	SP	9025	Jardim Amazonas	Jd Amazonas
16361	SP	9025	Jardim América	Jd América
16362	SP	9025	Jardim Amoreiras	Jd Amoreiras
16364	SP	9025	Jardim Anchieta	Jd Anchieta
16365	SP	9025	Jardim Antonio Von Zuben	Jd A V Zuben
16366	SP	9025	Jardim Aparecida	Jd Aparecida
16367	SP	9025	Jardim Aruã	Jd Aruã
16368	SP	9025	Jardim Atibaia (Sousas)	Jd Atibaia (Sousas)
16370	SP	9025	Jardim Aurélia	Jd Aurélia
16372	SP	9025	Jardim Aires da Costa	Jd A Costa
16374	SP	9025	Jardim Bandeirantes	Jd Bandeirantes
16376	SP	9025	Jardim Baronesa	Jd Baronesa
16377	SP	9025	Jardim Bela Vista	Jd B Vista
16378	SP	9025	Jardim Belmonte (Sousas)	Jd Belmonte (Sousas)
16379	SP	9025	Jardim Belo Horizonte	Jd B Horizonte
16380	SP	9025	Jardim Boa Esperança	Jd B Esperança
16041	SP	8989	Vila Carmelo	Vl Carmelo
16042	SP	8989	Vila Casa Branca	Vl C Branca
16043	SP	8989	Vila Cidade Jardim	Vl C Jardim
16044	SP	8989	Vila Cintra	Vl Cintra
16045	SP	8989	Vila Contin	Vl Contin
16047	SP	8989	Vila Ema	Vl Ema
16048	SP	8989	Vila Eny	Vl Eny
16049	SP	8989	Vila Esperança	Vl Esperança
16050	SP	8989	Vila Ferroviária	Vl Ferroviária
16053	SP	8989	Vila Guimarães	Vl Guimarães
16054	SP	8989	Vila Jahu	Vl Jahu
16055	SP	8989	Vila Juliana	Vl Juliana
16056	SP	8989	Vila Lavapés	Vl Lavapés
16057	SP	8989	Vila dos Lavradores	Vl Lavradores
16058	SP	8989	Vila Lizzeti	Vl Lizzeti
16059	SP	8989	Vila Longo	Vl Longo
16060	SP	8989	Vila Maria	Vl Maria
16061	SP	8989	Vila Mariana	Vl Mariana
16062	SP	8989	Vila Moreira	Vl Moreira
16063	SP	8989	Vila Nelo Cariola	Vl N Cariola
16064	SP	8989	Vila Nogueira	Vl Nogueira
16065	SP	8989	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
16066	SP	8989	Vila Nova Botucatu	Vl N Botucatu
16067	SP	8989	Vila Operária	Vl Operária
16068	SP	8989	Vila Padovan	Vl Padovan
16069	SP	8989	Vila Paraíso	Vl Paraíso
16070	SP	8989	Vila Paulista	Vl Paulista
16072	SP	8989	Vila Pinheiro Machado	Vl P Machado
16073	SP	8989	Vila Real	Vl Real
16074	SP	8989	Vila Rodrigues Alves	Vl R Alves
16076	SP	8989	Vila Santa Clara	Vl Sta Clara
16077	SP	8989	Vila Santa Luzia	Vl Sta Luzia
16078	SP	8989	Vila Santa Therezinha de Menino Jesus	Vl Sta T Men Jesus
16079	SP	8989	Vila Santana	Vl Santana
16081	SP	8989	Vila São Judas Thadeu	Vl S J Thadeu
16082	SP	8989	Vila São Lúcio	Vl S Lúcio
16083	SP	8989	Vila São Luiz	Vl S Luiz
16084	SP	8989	Vila Silvinha	Vl Silvinha
16085	SP	8989	Vila Sonia	Vl Sonia
16086	SP	8989	Vila Sorocabana	Vl Sorocabana
16090	SP	8992	Centro	\N
16094	SP	8992	Cidade Planejada I	C Planejada I
16095	SP	8992	Cidade Planejada II	C Planejada II
16096	SP	8992	Condomínio Jardim das Palmeiras	Cond Jd Palmeiras
16098	SP	8992	Cruzeiro	\N
16101	SP	8992	Jardim Águas Claras	Jd A Claras
16103	SP	8992	Jardim América	Jd América
16109	SP	8992	Jardim Comendador Cardoso	Jd Cdor Cardoso
16112	SP	8992	Residencial Colinas de São Francisco	Res C S Francisco
16118	SP	8992	Jardim Europa	Jd Europa
16122	SP	8992	Jardim Morumbi	Jd Morumbi
16260	SP	9025	Jardim Metonópolis	Jd Metonópolis
16262	SP	9025	Barão Geraldo	Br Geraldo
16265	SP	9025	Bonfim	\N
16266	SP	9025	Bosque	\N
16267	SP	9025	Bosque das Palmeiras	Bsq Palmeiras
16268	SP	9025	Bosque de Barão Geraldo	Bsq Br Geraldo
16269	SP	9025	Botafogo	\N
16270	SP	9025	Bueno de Miranda	B Miranda
16271	SP	9025	Cambuí	\N
16273	SP	9025	Carlos Gomes	C Gomes
16274	SP	9025	Centro	\N
16278	SP	9025	Chácaras Anhanguera	C Anhanguera
16280	SP	9025	Chácara Belvedere	Ch Belvedere
16281	SP	9025	Chácara Buriti	Ch Buriti
16283	SP	9025	Chácaras Campos Elíseos	C C Elíseos
16284	SP	9025	Chácara Cneo	Ch Cneo
16285	SP	9025	Chácaras Cruzeiro do Sul	C C Sul
16286	SP	9025	Chácara da Barra	Ch Barra
16287	SP	9025	Chácara de Recreio Santa Fé	Ch Rcr Sta Fé
16288	SP	9025	Chácara Formosa	Ch Formosa
16289	SP	9025	Vila Hollândia	Vl Hollândia
16292	SP	9025	Chácara Nova Boa Vista	Ch N B Vista
16293	SP	9025	Chácara Primavera	Ch Primavera
16296	SP	9025	Chácara Santa Letícia	Ch Sta Letícia
16297	SP	9025	Chácara Santa Margarida	Ch Sta Margarida
16298	SP	9025	Chácara Santos Dumont	Ch Stos Dumont
16299	SP	9025	Chácara São Domingos	Ch S Domingos
16301	SP	9025	Chácara São José	Ch S José
16303	SP	9025	Chácaras São Quirino	C S Quirino
16304	SP	9025	Chácara São Rafael	Ch S Rafael
16306	SP	9025	Cidade Jardim	C Jardim
16307	SP	9025	Cidade Satélite Íris	C S Íris
16308	SP	9025	Cidade Singer	C Singer
16309	SP	9025	Cidade Universitária	C Universitária
16310	SP	9025	Colinas do Ermitage (Sousas)	C Ermitage (Sousas)
16312	SP	9025	Condomínio Chácaras do Alto da Nova Campinas	Cond C At N Campinas
16315	SP	9025	Conjunto Habitacional Padre Anchieta	Cj Hab Pe Anchieta
16316	SP	9025	Conjunto Habitacional Parque Itajaí	Cj Hab Prq Itajaí
16319	SP	9025	Conjunto Habitacional Vida Nova	Cj Hab V Nova
16320	SP	9025	Conjunto Habitacional Vila Réggio	Cj Hab Vl Réggio
16321	SP	9025	Conjunto Mauro Marcondes	Cj M Marcondes
16326	SP	9025	Conjunto Residencial Parque São Bento	Cj Res Prq S Bento
16328	SP	9025	Conjunto Residencial Souza Queiroz	Cj Res S Queiroz
16329	SP	9025	Country Ville	C Ville
16330	SP	9025	DAE	\N
16382	SP	9025	Jardim Bom Retiro	Jd B Retiro
16383	SP	9025	Jardim Bom Sucesso	Jd B Sucesso
16384	SP	9025	Jardim Bonfim	Jd Bonfim
16385	SP	9025	Jardim Bordon	Jd Bordon
16387	SP	9025	Jardim Botânico (Sousas)	Jd Botânico (Sousas)
16389	SP	9025	Jardim Brasil	Jd Brasil
16392	SP	9025	Jardim Campinas	Jd Campinas
16393	SP	9025	Jardim Campineiro	Jd Campineiro
16394	SP	9025	Jardim Campo Belo	Jd Cpo Belo
16395	SP	9025	Jardim Campos Elíseos	Jd C Elíseos
16396	SP	9025	Jardim Capivari	Jd Capivari
16397	SP	9025	Jardim Carlos Gomes	Jd C Gomes
16398	SP	9025	Jardim Carlos Lourenço	Jd C Lourenço
16400	SP	9025	Jardim Centenário	Jd Centenário
16401	SP	9025	Jardim Chapadão	Jd Chapadão
16403	SP	9025	Jardim Colonial	Jd Colonial
16405	SP	9025	Jardim Conceição I	Jd Conceição I
16406	SP	9025	Jardim Cristina	Jd Cristina
16407	SP	9025	Jardim Cura D'Ars	Jd C D'Ars
16411	SP	9025	Jardim dos Oliveiras	Jd Oliveiras
16412	SP	9025	Jardim das Paineiras	Jd Paineiras
16413	SP	9025	Bairro das Palmeiras	B Palmeiras
16414	SP	9025	Jardim do Lago	Jd Lago
16415	SP	9025	Jardim do Lago Continuação	Jd Lg Continuação
16416	SP	9025	Jardim do Sol	Jd Sol
16417	SP	9025	Jardim do Trevo	Jd Trevo
16418	SP	9025	Jardim do Vale	Jd Vale
16419	SP	9025	Jardim do Vovô	Jd Vovô
16420	SP	9025	Jardim Dom Bosco	Jd D Bosco
16421	SP	9025	Jardim Dom Nery	Jd D Nery
16422	SP	9025	Jardim Dom Vieira	Jd D Vieira
16425	SP	9025	Jardim Esmeraldina	Jd Esmeraldina
16426	SP	9025	Jardim Esplanada	Jd Esplanada
16427	SP	9025	Jardim Estoril	Jd Estoril
16428	SP	9025	Jardim Eulina	Jd Eulina
16429	SP	9025	Jardim Fernanda	Jd Fernanda
16430	SP	9025	Jardim Flamboyant	Jd Flamboyant
16431	SP	9025	Jardim Florence	Jd Florence
16432	SP	9025	Jardim Francisca	Jd Francisca
16435	SP	9025	Jardim García	Jd García
16436	SP	9025	Jardim Guanabara	Jd Guanabara
16437	SP	9025	Jardim Guarani	Jd Guarani
16439	SP	9025	Jardim Icaraí	Jd Icaraí
16440	SP	9025	Jardim Independência	Jd Independência
16441	SP	9025	Jardim Indianópolis	Jd Indianópolis
16442	SP	9025	Jardim Interlagos	Jd Interlagos
16445	SP	9025	Jardim Ipaussurama	Jd Ipaussurama
16446	SP	9025	Jardim Ipiranga	Jd Ipiranga
16447	SP	9025	Jardim Iraci	Jd Iraci
16503	SP	9025	Jardim Novo Real Parque	Jd N R Parque
16504	SP	9025	Jardim Novo Sol	Jd N Sol
16505	SP	9025	Jardim Okita	Jd Okita
16506	SP	9025	Jardim Ouro Branco	Jd O Branco
16507	SP	9025	Jardim Ouro Verde	Jd O Verde
16508	SP	9025	Jardim Pacaembu	Jd Pacaembu
16510	SP	9025	Jardim Paraíso	Jd Paraíso
16511	SP	9025	Jardim Paraíso de Viracopos	Jd Paraíso Viracopos
16512	SP	9025	Jardim Paranapanema	Jd Paranapanema
16513	SP	9025	Jardim Paulicéia	Jd Paulicéia
16514	SP	9025	Jardim Paulistano	Jd Paulistano
16515	SP	9025	Jardim Petrópolis	Jd Petrópolis
16516	SP	9025	Jardim Pita	Jd Pita
16517	SP	9025	Jardim Planalto	Jd Planalto
16518	SP	9025	Jardim Planalto de Viracopos	Jd P Viracopos
16519	SP	9025	Jardim Presidente Wenceslau	Jd Pres Wenceslau
16520	SP	9025	Jardim Primavera	Jd Primavera
16521	SP	9025	Jardim Princesa	Jd Princesa
16523	SP	9025	Jardim Proença	Jd Proença
16524	SP	9025	Jardim Professora Tarcília	Jd Prfa Tarcília
16525	SP	9025	Jardim Profilurb	Jd Profilurb
16526	SP	9025	Jardim Quarto Centenário	Jd Q Centenário
16527	SP	9025	Vila Regina	Vl Regina
16528	SP	9025	Jardim Rosana (Sousas)	Jd Rosana (Sousas)
16529	SP	9025	Jardim Roseira	Jd Roseira
16530	SP	9025	Jardim Rossin	Jd Rossin
16531	SP	9025	Jardim Samambaia	Jd Samambaia
16532	SP	9025	Jardim San Diego	Jd S Diego
16534	SP	9025	Jardim Santa Amália	Jd Sta Amália
16535	SP	9025	Jardim Santa Clara	Jd Sta Clara
16536	SP	9025	Jardim Santa Cruz	Jd Sta Cruz
16537	SP	9025	Jardim Santa Eudóxia	Jd Sta Eudóxia
16539	SP	9025	Jardim Santa Genebra	Jd Sta Genebra
16540	SP	9025	Jardim Santa Inês	Jd Sta Inês
16541	SP	9025	Jardim Santa Lúcia	Jd Sta Lúcia
16543	SP	9025	Jardim Santa Marcelina	Jd Sta Marcelina
16546	SP	9025	Jardim Santa Mônica	Jd Sta Mônica
16548	SP	9025	Jardim Santa Rita de Cássia	Jd Sta R Cássia
16549	SP	9025	Jardim Santa Rosa	Jd Sta Rosa
16550	SP	9025	Jardim Santa Terezinha	Jd Sta Terezinha
16551	SP	9025	Jardim Santa Vitória	Jd Sta Vitória
16552	SP	9025	Jardim Santana	Jd Santana
16554	SP	9025	Jardim Santo Expedito	Jd Sto Expedito
16556	SP	9025	Jardim São Carlos	Jd S Carlos
16557	SP	9025	Jardim São Cristóvão	Jd S Cristóvão
16558	SP	9025	Jardim São Domingos	Jd S Domingos
16616	SP	9025	Nova Aparecida	N Aparecida
16617	SP	9025	Nova Campinas	N Campinas
16618	SP	9025	Nova Sousas (Sousas)	N Sousas (Sousas)
16619	SP	9025	Jardim Novo São José	Jd N S José
16620	SP	9025	Novo Taquaral	N Taquaral
16621	SP	9025	Núcleo Habitacional Boa Vista (Nova Aparecida)	Nuc H B Vista (N Aparecida)
16622	SP	9025	Núcleo Residencial Cristo Redentor	Nuc Res C Redentor
16623	SP	9025	Núcleo Residencial Cristo Rei (Sousas)	Nuc Res C Rei (Sousas)
16624	SP	9025	Núcleo Residencial Francisco Amaral	Nuc Res F Amaral
16625	SP	9025	Núcleo Residencial Independência	Nuc Res Independência
16626	SP	9025	Palmeiras	\N
16629	SP	9025	Parque Alto Taquaral	Prq At Taquaral
16630	SP	9025	Parque Beatriz	Prq Beatriz
16632	SP	9025	Parque Brasília	Prq Brasília
16633	SP	9025	Parque Camboriú	Prq Camboriú
16635	SP	9025	Parque Canadá	Prq Canadá
16636	SP	9025	Parque CEASA	Prq CEASA
16637	SP	9025	Parque Cidade Campinas	Prq C Campinas
16638	SP	9025	Parque Fazendinha	Prq Fazendinha
16640	SP	9025	Conjunto Habitacional Parque da Floresta	Cj Hab Prq Floresta
16641	SP	9025	Parque da Hípica	Prq Hípica
16642	SP	9025	Parque Anhumas	Prq Anhumas
16643	SP	9025	Parque Camélias	Prq Camélias
16644	SP	9025	Parque das Flores	Prq Flores
16645	SP	9025	Parque das Indústrias	Prq Indústrias
16646	SP	9025	Parque das Universidades	Prq Universidades
16647	SP	9025	Parque Dom Pedro II	Prq D Pedro II
16648	SP	9025	Parque dos Cisnes	Prq Cisnes
16649	SP	9025	Parque dos Jacarandás	Prq Jacarandás
16650	SP	9025	Parque dos Pomares	Prq Pomares
16652	SP	9025	Parque Imperador	Prq Imperador
16653	SP	9025	Parque Industrial	Prq Industrial
16654	SP	9025	Parque Ipiranga	Prq Ipiranga
16655	SP	9025	Parque Itália	Prq Itália
16657	SP	9025	Parque Jambeiro	Prq Jambeiro
16658	SP	9025	Parque Jatibaia (Sousas)	Prq Jatibaia (Sousas)
16659	SP	9025	Parque Luciamar	Prq Luciamar
16660	SP	9025	Parque Maria Helena	Prq M Helena
16661	SP	9025	Parque Montreal	Prq Montreal
16773	SP	9025	Vila Lídia	Vl Lídia
16774	SP	9025	Vila Lourdes	Vl Lourdes
16775	SP	9025	Vila Lovato	Vl Lovato
16776	SP	9025	Arruamento Luiz Vicentin	A L Vicentin
16777	SP	9025	Vila Lunardi	Vl Lunardi
16778	SP	9025	Jardim Madalena	Jd Madalena
16779	SP	9025	Vila Manoel Ferreira	Vl M Ferreira
16780	SP	9025	Vila Maria	Vl Maria
16781	SP	9025	Vila Maria Eugênia	Vl M Eugênia
16782	SP	9025	Vila Marieta	Vl Marieta
16784	SP	9025	Vila Miguel Vicente Cury	Vl M V Cury
16785	SP	9025	Vila Mimosa	Vl Mimosa
16786	SP	9025	Vila Mingone	Vl Mingone
16787	SP	9025	Vila Modesto Fernandes	Vl M Fernandes
16790	SP	9025	Vila Nogueira	Vl Nogueira
16792	SP	9025	Vila Nova	Vl Nova
16794	SP	9025	Vila Nova Teixeira	Vl N Teixeira
16796	SP	9025	Vila Orozimbo Maia	Vl O Maia
16798	SP	9025	Vila Padre Manoel de Nóbrega	Vl Pe M Nóbrega
16858	SP	9026	Jardim América	Jd América
16859	SP	9026	Jardim Brasil	Jd Brasil
16860	SP	9026	Jardim Brasília (Botujuru)	Jd Brasília (Botujuru)
16861	SP	9026	Jardim Campo Limpo	Jd Cpo Limpo
16862	SP	9026	Jardim Corcovado	Jd Corcovado
16863	SP	9026	Jardim das Palmeiras (Botujuru)	Jd Palmeiras (Botujuru)
16864	SP	9026	Jardim Europa	Jd Europa
16865	SP	9026	Jardim Fritz (Botujuru)	Jd Fritz (Botujuru)
16866	SP	9026	Jardim Guanciale	Jd Guanciale
16867	SP	9026	Jardim Laura	Jd Laura
16868	SP	9026	Jardim Marcheti	Jd Marcheti
16869	SP	9026	Jardim Maria	Jd Maria
16870	SP	9026	Jardim Marsola	Jd Marsola
16871	SP	9026	Jardim Paiol	Jd Paiol
16872	SP	9026	Jardim Paulista	Jd Paulista
16873	SP	9026	Jardim Santa Catarina	Jd Sta Catarina
16874	SP	9026	Jardim Santa Isabel (Botujuru)	Jd Sta Isabel (Botujuru)
16875	SP	9026	Jardim Santa Lúcia	Jd Sta Lúcia
16876	SP	9026	Jardim Santa Maria	Jd Sta Maria
16877	SP	9026	Jardim Santhiago	Jd Santhiago
16878	SP	9026	Jardim Santo Antônio I	Jd Sto Antônio I
16879	SP	9026	Jardim Santo Antônio II	Jd Sto Antônio II
16880	SP	9026	Jardim São Conrado	Jd S Conrado
16881	SP	9026	Jardim São Domingos	Jd S Domingos
16882	SP	9026	Jardim Solange	Jd Solange
16883	SP	9026	Jardim Timbara	Jd Timbara
16884	SP	9026	Jardim Vera Regina	Jd V Regina
16885	SP	9026	Jardim Vista Alegre	Jd V Alegre
16886	SP	9026	Jardim Vitória	Jd Vitória
16888	SP	9026	Núcleo Industrial - 2	Nuc Industrial - 2
16889	SP	9026	Núcleo Industrial - 3	Nuc Industrial - 3
16890	SP	9026	Outeiro das Paineiras (Botujuru)	O Paineiras (Botujuru)
16891	SP	9026	Parque Internacional	Prq Internacional
16892	SP	9026	Parque Iramaia	Prq Iramaia
16893	SP	9026	Parque Loja da China (Botujuru)	Prq L China (Botujuru)
16894	SP	9026	Parque Niágara	Prq Niágara
16895	SP	9026	Parque Residencial Califórnia	Prq Res Califórnia
16896	SP	9026	Parque Santana (Botujuru)	Prq Santana (Botujuru)
16897	SP	9026	Pau Arcado	P Arcado
16898	SP	9026	Recanto Campo Verde	Rec Cpo Verde
16899	SP	9026	Recanto das Videiras	Rec Videiras
16900	SP	9026	Recanto do Lago	Rec Lago
16901	SP	9026	Recanto do Sapê	Rec Sapê
16902	SP	9026	Residencial Monte Alegre	Res Mte Alegre
16974	SP	9043	Perequê Mirim	P Mirim
16975	SP	9043	Poiares	\N
16976	SP	9043	Pontal de Santa Marina	P Sta Marina
16977	SP	9043	Ponte Seca	Pte Seca
16979	SP	9043	Jardim Porto Novo	Jd Pto Novo
16980	SP	9043	Praia das Palmeiras	Pr Palmeiras
16981	SP	9043	Prainha	\N
16982	SP	9043	Rio do Ouro	R Ouro
16983	SP	9043	Sumaré	\N
16984	SP	9043	Tabatinga	\N
16985	SP	9043	Tinga	\N
16986	SP	9043	Travessão	\N
16988	SP	9044	Conjunto Habitacional 120 Casas	Cj Hab 120 Casas
16989	SP	9044	Altos da Santa Lúcia	A Sta Lúcia
16990	SP	9044	Bela Vista	B Vista
16991	SP	9044	Centro	\N
16992	SP	9044	Chácara Adriana Aparecida	Ch A Aparecida
16993	SP	9044	Chácara das Candeias	Ch Candeias
16994	SP	9044	Chácara das Flores	Ch Flores
16995	SP	9044	Chácara das Paineiras	Ch Paineiras
16996	SP	9044	Chácara de La Rocca	Ch L Rocca
16997	SP	9044	Chácara do Refúgio	Ch Refúgio
16998	SP	9044	Chácara dos Junqueiras	Ch Junqueiras
16999	SP	9044	Chácara dos Lagos	Ch Lagos
17000	SP	9044	Chácara Granja Velha	Ch Gja Velha
17001	SP	9044	Chácara Moinho Velho	Ch M Velho
17002	SP	9044	Chácara Noel Antônio	Ch N Antônio
17003	SP	9044	Chácara Quiriri	Ch Quiriri
17004	SP	9044	Chácara Santa Lúcia	Ch Sta Lúcia
17005	SP	9044	Chácara Santa Lúcia dos Ypes	Ch Sta L Ypes
17006	SP	9044	Chácara São João	Ch S João
17007	SP	9044	Chácara Vale do Rio Cotia	Ch Vle R Cotia
17008	SP	9044	Cidade Ariston Estela Azevedo	C A E Azevedo
17009	SP	9044	Conjunto Habitacional Presidente Castelo Branco	Cj Hab Pres C Branco
17010	SP	9044	Granja Santa Maria	Gja Sta Maria
17804	SP	9138	Jardim Juliana	Jd Juliana
17011	SP	9044	Jardim Alfredo Soncini	Jd A Soncini
17012	SP	9044	Jardim Alice	Jd Alice
17013	SP	9044	Jardim Ampermag	Jd Ampermag
17014	SP	9044	Jardim Ana Estela	Jd A Estela
17015	SP	9044	Jardim Ana Maria	Jd Ana Maria
17016	SP	9044	Jardim Ângela Maria	Jd A Maria
17017	SP	9044	Jardim Boa Vista	Jd B Vista
17018	SP	9044	Jardim Bom Pastor	Jd B Pastor
17019	SP	9044	Jardim Bom Sucesso	Jd B Sucesso
17020	SP	9044	Jardim Carapicuíba	Jd Carapicuíba
17021	SP	9044	Jardim Cecília Cristina	Jd C Cristina
17022	SP	9044	Jardim Cibele	Jd Cibele
17023	SP	9044	Jardim Colonial	Jd Colonial
17024	SP	9044	Jardim Copiúva	Jd Copiúva
17025	SP	9044	Jardim D'Ângelo	Jd D'Ângelo
16448	SP	9025	Jardim Irmãos Sigrist	Jd Imos Sigrist
16449	SP	9025	Jardim Itamarati	Jd Itamarati
16450	SP	9025	Jardim Itatiaia	Jd Itatiaia
16451	SP	9025	Jardim Itatinga	Jd Itatinga
16452	SP	9025	Jardim Itayu	Jd Itayu
16453	SP	9025	Jardim José Martins	Jd J Martins
16455	SP	9025	Jardim Leonor	Jd Leonor
16456	SP	9025	Jardim Liliza	Jd Liliza
16457	SP	9025	Jardim Lisa	Jd Lisa
16458	SP	9025	Jardim Londres	Jd Londres
16459	SP	9025	Jardim Lumen Christi	Jd L Christi
16461	SP	9025	Jardim Magnólia	Jd Magnólia
16462	SP	9025	Jardim Maísa	Jd Maísa
16463	SP	9025	Jardim Maracanã	Jd Maracanã
16464	SP	9025	Jardim Marajó	Jd Marajó
16465	SP	9025	Jardim Márcia	Jd Márcia
16466	SP	9025	Jardim Margarida	Jd Margarida
16467	SP	9025	Jardim Maria Eugênia	Jd M Eugênia
16468	SP	9025	Jardim Maria Helena	Jd M Helena
16469	SP	9025	Jardim Maria Rosa	Jd M Rosa
16472	SP	9025	Jardim Marisa	Jd Marisa
16473	SP	9025	Jardim Martinelli (Sousas)	Jd Martinelli (Sousas)
16474	SP	9025	Jardim Melina I	Jd Melina I
16475	SP	9025	Jardim Mercedes	Jd Mercedes
16476	SP	9025	Jardim Miranda	Jd Miranda
16477	SP	9025	Jardim Monte Alto	Jd Mte Alto
16478	SP	9025	Jardim Monte Belo	Jd Mte Belo
16479	SP	9025	Jardim Monte Líbano	Jd Mte Líbano
16480	SP	9025	Jardim Moreira	Jd Moreira
16481	SP	9025	Jardim Morumbi	Jd Morumbi
16482	SP	9025	Jardim Myrian Moreira da Costa	Jd M M Costa
16483	SP	9025	Jardim New York	Jd N York
16484	SP	9025	Jardim Nilópolis	Jd Nilópolis
16486	SP	9025	Jardim Noêmia	Jd Noêmia
16487	SP	9025	Jardim Nossa Senhora Auxiliadora	Jd N Sra Auxiliadora
16488	SP	9025	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
16489	SP	9025	Jardim Nossa Senhora de Lourdes	Jd N Sra Lourdes
16490	SP	9025	Jardim Nova América	Jd N América
16491	SP	9025	Jardim Nova Esperança	Jd N Esperança
16492	SP	9025	Jardim Nova Europa	Jd N Europa
16493	SP	9025	Jardim Nova Mercedes	Jd N Mercedes
16494	SP	9025	Jardim Nova Morada	Jd N Morada
16496	SP	9025	Jardim Novo Barão Geraldo	Jd N Br Geraldo
16497	SP	9025	Jardim Novo Botafogo	Jd N Botafogo
16498	SP	9025	Jardim Novo Cambuí	Jd N Cambuí
16500	SP	9025	Jardim Novo Flamboyant	Jd N Flamboyant
16502	SP	9025	Jardim Novo Maracanã	Jd N Maracanã
16559	SP	9025	Jardim São Domingos Sávio	Jd S D Sávio
16560	SP	9025	Jardim São Fernando	Jd S Fernando
16561	SP	9025	Jardim São Francisco	Jd S Francisco
16563	SP	9025	Jardim São Gabriel	Jd S Gabriel
16564	SP	9025	Jardim São Gonçalo	Jd S Gonçalo
16565	SP	9025	Jardim São João	Jd S João
16569	SP	9025	Jardim São Judas Tadeu	Jd S J Tadeu
16571	SP	9025	Jardim São Luiz	Jd S Luiz
16572	SP	9025	Jardim São Marcos	Jd S Marcos
16574	SP	9025	Jardim São Pedro	Jd S Pedro
16575	SP	9025	Jardim São Pedro de Viracopos	Jd S P Viracopos
16576	SP	9025	Jardim São Rafael	Jd S Rafael
16577	SP	9025	Jardim São Vicente	Jd S Vicente
16578	SP	9025	Jardim Shangai	Jd Shangai
16580	SP	9025	Jardim Sorirama (Sousas)	Jd Sorirama (Sousas)
16581	SP	9025	Jardim Stella	Jd Stella
16583	SP	9025	Jardim Tamoio	Jd Tamoio
16585	SP	9025	Jardim Tupi	Jd Tupi
16588	SP	9025	Jardim Vista Alegre	Jd V Alegre
16589	SP	9025	Jardim Yeda	Jd Yeda
16591	SP	9025	Joaquim Egídio	J Egídio
16592	SP	9025	Loteamento Alphaville Campinas	Lot A Campinas
16593	SP	9025	Loteamento Caminhos de São Conrado (Sousas)	Lot C S Conrado (Sousas)
16594	SP	9025	Loteamento Campos dos Amarais	Lot C Amarais
16595	SP	9025	Loteamento Chácaras Gargantilhas	Lot C Gargantilhas
16597	SP	9025	Loteamento Claude de Barros Penteado (Sousas)	Lot C B Penteado (Sousas)
16598	SP	9025	Loteamento Country Ville	Lot C Ville
16599	SP	9025	Loteamento e Arruamento TELESP	Lot E A TELESP
16601	SP	9025	Loteamento Parque Centenário	Lot Prq Centenário
16602	SP	9025	Loteamento Parque das Hortências (Sousas)	Lot Prq Hortências (Sousas)
16603	SP	9025	Loteamento Parque São Martinho	Lot Prq S Martinho
16604	SP	9025	Loteamento Residencial Barão do Café	Lot Res Br Café
16605	SP	9025	Residencial Cosmos	Res Cosmos
16606	SP	9025	Loteamento Residencial Novo Mundo	Lot Res N Mundo
16609	SP	9025	Loteamento Vila Esperança	Lot Vl Esperança
16610	SP	9025	Loteamento Vila Lafayette Álvaro	Lot Vl L Álvaro
16611	SP	9025	Loteamento Village Campinas	Lot V Campinas
16612	SP	9025	Mansões Santo Antônio	M Sto Antônio
16614	SP	9025	Morada das Nascentes (Joaquim Egídio)	M Nascentes (J Egídio)
16615	SP	9025	Notre Dame	N Dame
16667	SP	9025	Parque Residencial Carvalho de Moura	Prq Res C Moura
16668	SP	9025	Parque Residencial Shalon	Prq Res Shalon
16669	SP	9025	Parque Residencial Vila União	Prq Res Vl União
16670	SP	9025	Parque Santa Bárbara	Prq Sta Bárbara
16672	SP	9025	Parque São Jorge	Prq S Jorge
16673	SP	9025	Parque São Paulo	Prq S Paulo
16674	SP	9025	Parque São Quirino	Prq S Quirino
16675	SP	9025	Parque Taquaral	Prq Taquaral
16676	SP	9025	Parque Tropical	Prq Tropical
16677	SP	9025	Parque Universitário de Viracopos	Prq Univ Viracopos
16678	SP	9025	Parque Valença I	Prq Valença I
16679	SP	9025	Parque Valença II	Prq Valença II
16680	SP	9025	Parque Valença III	Prq Valença III
16681	SP	9025	Parque Venceslau	Prq Venceslau
16682	SP	9025	Parque Via Norte	Prq V Norte
16683	SP	9025	Parque Vista Alegre	Prq V Alegre
16684	SP	9025	Parque Xangrilá	Prq Xangrilá
16685	SP	9025	Ponte Preta	Pte Preta
16686	SP	9025	Real Parque	R Parque
16687	SP	9025	Recanto do Sol I	Rec Sol I
16688	SP	9025	Recanto do Sol II	Rec Sol II
16689	SP	9025	Recanto dos Dourados	Rec Dourados
16690	SP	9025	Recanto Fortuna	Rec Fortuna
16693	SP	9025	Recreio Tsuriba	Rcr Tsuriba
16694	SP	9025	Loteamento Arboreto dos Jequitibás (Sousas)	Lot A Jequitibás (Sousas)
16695	SP	9025	Residencial Burato	Res Burato
16696	SP	9025	Residencial Cândido Ferreira (Sousas)	Res C Ferreira (Sousas)
16698	SP	9025	Residencial Parque Rio das Pedras	Res Prq R Pedras
16702	SP	9025	Rosália	\N
16705	SP	9025	São Bernardo	S Bernardo
16708	SP	9025	Sítios de Recreio Gramado	S Rcr Gramado
16709	SP	9025	Sousas	\N
16710	SP	9025	Taquaral	\N
16711	SP	9025	Terminal Intermodal de Cargas (TIC)	Ter I Cargas (TIC)
16712	SP	9025	Chácara Três Marias	Ch T Marias
16713	SP	9025	Vila Aeroporto	Vl Aeroporto
16715	SP	9025	Vila Antônio Martins	Vl A Martins
16716	SP	9025	Vila Alberto Simões	Vl A Simões
16717	SP	9025	Vila Ana Luiza (Sousas)	Vl A Luiza (Sousas)
16718	SP	9025	Vila Andrade Neves	Vl A Neves
16719	SP	9025	Vila Ângela Marta	Vl A Marta
16720	SP	9025	Vila Rossi	Vl Rossi
16721	SP	9025	Vila Anhangüera	Vl Anhangüera
16722	SP	9025	Vila Antônio Francisco	Vl A Francisco
16723	SP	9025	Vila Antônio Lourenço	Vl A Lourenço
16799	SP	9025	Vila Palácios	Vl Palácios
16800	SP	9025	Vila Palmeiras I	Vl Palmeiras I
16801	SP	9025	Vila Palmeiras II	Vl Palmeiras II
16802	SP	9025	Vila Paraíso	Vl Paraíso
16803	SP	9025	Vila Perseu Leite de Barros	Vl P L Barros
16804	SP	9025	Vila Pompéia	Vl Pompéia
16806	SP	9025	Vila Progresso	Vl Progresso
16807	SP	9025	Vila Proost de Souza	Vl P Souza
16810	SP	9025	Vila Rica	Vl Rica
16813	SP	9025	Vila Rossi Borghi e Siqueira	Vl R B E Siqueira
16816	SP	9025	Vila San Martin	Vl S Martin
16817	SP	9025	Vila Santa Isabel	Vl Sta Isabel
16818	SP	9025	Vila Santa Luisa	Vl Sta Luisa
16820	SP	9025	Vila Santa Odila	Vl Sta Odila
16821	SP	9025	Vila Santa Rita (Sousas)	Vl Sta Rita (Sousas)
16822	SP	9025	Vila Santana	Vl Santana
16824	SP	9025	Vila São Bento	Vl S Bento
16825	SP	9025	Vila São Bernardo	Vl S Bernardo
16826	SP	9025	Vila São João	Vl S João
16827	SP	9025	Vila São Joaquim	Vl S Joaquim
16828	SP	9025	Vila João Jorge	Vl J Jorge
16829	SP	9025	Vila Satúrnia	Vl Satúrnia
16830	SP	9025	Vila Sete de Setembro	Vl S Setembro
16833	SP	9025	Vila Soares	Vl Soares
16834	SP	9025	Vila Sônia (Sousas)	Vl Sônia (Sousas)
16835	SP	9025	Vila Tancredo Neves	Vl T Neves
16836	SP	9025	Vila Teixeira	Vl Teixeira
16837	SP	9025	Vila Tofanello	Vl Tofanello
16838	SP	9025	Vila Trinta e Um de Março	Vl T E U Março
16839	SP	9025	Vila Virgínia	Vl Virgínia
16840	SP	9025	Village Campinas	V Campinas
16841	SP	9025	31 de Março	31 Março
16842	SP	9026	Botujuru (Botujuru)	\N
16843	SP	9026	Centro	\N
16844	SP	9026	Chácara São João	Ch S João
16845	SP	9026	Chácara Serra Morena	Ch S Morena
16846	SP	9026	Chácaras Campo Limpo	C Cpo Limpo
16847	SP	9026	Chácara Ivoturucaia	Ch Ivoturucaia
16848	SP	9026	Chácara Lagoa Branca	Ch Lga Branca
16849	SP	9026	Chácara Nova Essen	Ch N Essen
16850	SP	9026	Chácaras Nova Germânia	C N Germânia
16851	SP	9026	Chácaras Novo Hamburgo	C N Hamburgo
16852	SP	9026	Colinas do Pontal (Botujuru)	C Pontal (Botujuru)
16853	SP	9026	Condomínio Cerro Azul	Cond C Azul
16854	SP	9026	Conjunto Habitacional São José	Cj Hab S José
16855	SP	9026	Estância Figueira Branca	Etn F Branca
16856	SP	9026	Estância São Paulo	Etn S Paulo
16857	SP	9026	Fazenda Marajoara	Faz Marajoara
16903	SP	9026	Vila Cardoso	Vl Cardoso
16904	SP	9026	Vila Chacrinha (Botujuru)	Vl Chacrinha (Botujuru)
16905	SP	9026	Vila Constança (Botujuru)	Vl Constança (Botujuru)
16906	SP	9026	Vila Firenze (Botujuru)	Vl Firenze (Botujuru)
16907	SP	9026	Vila Imape	Vl Imape
16908	SP	9026	Vila Marieta (Botujuru)	Vl Marieta (Botujuru)
16909	SP	9026	Vila Olímpia	Vl Olímpia
16910	SP	9026	Vila São Paulo	Vl S Paulo
16911	SP	9026	Vila Tavares	Vl Tavares
16912	SP	9026	Vila Thomazina	Vl Thomazina
16913	SP	9026	Ville Saint James I	V S James I
16914	SP	9026	Ville Saint James II	V S James II
16915	SP	9037	Centro	\N
16916	SP	9037	Distrito Industrial	Dt Industrial
16917	SP	9037	Jardim Alvorada	Jd Alvorada
16918	SP	9037	Jardim Colonial	Jd Colonial
16919	SP	9037	Jardim Cruzeiro	Jd Cruzeiro
16920	SP	9037	Jardim da Amizade	Jd Amizade
16921	SP	9037	Jardim Europa	Jd Europa
16924	SP	9037	Jardim Vale Verde	Jd Vle Verde
16926	SP	9037	Parque das Nações	Prq Nações
16927	SP	9037	Recanto do Pescador	Rec Pescador
16928	SP	9037	Terras do Embiruçu	T Embiruçu
16929	SP	9037	Vila Aparecida	Vl Aparecida
16931	SP	9037	Vila Bela Vista	Vl B Vista
16932	SP	9037	Vila Boa Esperança	Vl B Esperança
16934	SP	9037	Vila Guanabara	Vl Guanabara
16936	SP	9037	Vila Nova Capão Bonito	Vl N C Bonito
16938	SP	9037	Vila Santa Isabel	Vl Sta Isabel
16939	SP	9037	Vila Santa Rosa	Vl Sta Rosa
16941	SP	9037	Vila São Francisco de Assis	Vl S F Assis
16943	SP	9037	Vila São Judas Thadeu	Vl S J Thadeu
16944	SP	9037	Vila São Paulo	Vl S Paulo
16947	SP	9043	Barranco Alto	B Alto
16949	SP	9043	Jardim Britânia	Jd Britânia
16951	SP	9043	Caputera	\N
16952	SP	9043	Centro	\N
16953	SP	9043	Cidade Jardim	C Jardim
16954	SP	9043	Estrela D'Alva	E D'Alva
16955	SP	9043	Getuba	\N
16956	SP	9043	Indaiá	\N
16958	SP	9043	Jaraguá	\N
16959	SP	9043	Jaraguazinho	\N
16962	SP	9043	Jardim Capricórnio	Jd Capricórnio
16963	SP	9043	Jardim Casa Branca	Jd C Branca
16964	SP	9043	Jardim das Gaivotas	Jd Gaivotas
16966	SP	9043	Jardim Jaqueira	Jd Jaqueira
16967	SP	9043	Jardim Olaria	Jd Olaria
16968	SP	9043	Jardim Primavera	Jd Primavera
16970	SP	9043	Martim de Sá	M Sá
16971	SP	9043	Massaguaçu	\N
16972	SP	9043	Morro do Algodão	Mro Algodão
16973	SP	9043	Pegorelli	\N
17026	SP	9044	Jardim das Belezas	Jd Belezas
17027	SP	9044	Jardim das Palmeiras	Jd Palmeiras
17028	SP	9044	Jardim das Pedras	Jd Pedras
17029	SP	9044	Jardim dos Manacás	Jd Manacás
17030	SP	9044	Jardim Edi	Jd Edi
17031	SP	9044	Jardim Elzinha	Jd Elzinha
17032	SP	9044	Jardim Ercy	Jd Ercy
17033	SP	9044	Jardim Felipe	Jd Felipe
17034	SP	9044	Jardim Guiomar	Jd Guiomar
17035	SP	9044	Jardim Helena	Jd Helena
17036	SP	9044	Jardim Hermínia	Jd Hermínia
17037	SP	9044	Jardim Leonor	Jd Leonor
17038	SP	9044	Jardim Leopoldina	Jd Leopoldina
17039	SP	9044	Jardim Lice	Jd Lice
17040	SP	9044	Jardim Maria Beatriz	Jd M Beatriz
17041	SP	9044	Jardim Maria Helena	Jd M Helena
17042	SP	9044	Jardim Maria Rita	Jd M Rita
17043	SP	9044	Jardim Marilu	Jd Marilu
17044	SP	9044	Jardim Mesquita	Jd Mesquita
17045	SP	9044	Jardim Monteiro Lobato	Jd M Lobato
17046	SP	9044	Jardim Novo Horizonte	Jd N Horizonte
17047	SP	9044	Jardim Paulista	Jd Paulista
17048	SP	9044	Jardim Pignatary	Jd Pignatary
17049	SP	9044	Jardim Planalto	Jd Planalto
17050	SP	9044	Jardim Popular	Jd Popular
17051	SP	9044	Jardim Primavera	Jd Primavera
17052	SP	9044	Jardim Primeiro de Maio	Jd P Maio
17053	SP	9044	Jardim Rosa Maria	Jd R Maria
17054	SP	9044	Jardim Roseli	Jd Roseli
17055	SP	9044	Jardim Sandra Regina	Jd S Regina
17056	SP	9044	Jardim Santa Brígida	Jd Sta Brígida
17057	SP	9044	Jardim Santa Rita	Jd Sta Rita
17058	SP	9044	Jardim Santa Tereza	Jd Sta Tereza
17059	SP	9044	Jardim Santo Estêvão	Jd Sto Estêvão
17060	SP	9044	Jardim São Pedro	Jd S Pedro
17061	SP	9044	Jardim Ster-Za	Jd Ster-Za
17062	SP	9044	Jardim Tonato	Jd Tonato
17063	SP	9044	Jardim Tucunduva	Jd Tucunduva
17064	SP	9044	Jardim Yaya	Jd Yaya
17065	SP	9044	Nova Fazendinha	N Fazendinha
17066	SP	9044	Palos Verdes	P Verdes
17067	SP	9044	Parque Flórida	Prq Flórida
17068	SP	9044	Parque Ideal	Prq Ideal
17069	SP	9044	Parque Jandaia	Prq Jandaia
17070	SP	9044	Parque José Alex André	Prq J A André
17071	SP	9044	Parque Primavera	Prq Primavera
17072	SP	9044	Parque Roseira	Prq Roseira
17073	SP	9044	Parque Sampaio Viana	Prq S Viana
17074	SP	9044	Parque Santa Teresa	Prq Sta Teresa
17075	SP	9044	Pontal da Fazendinha	P Fazendinha
17131	SP	9044	Vila Silva Ribeiro	Vl S Ribeiro
17134	SP	9044	Vila Silviânia	Vl Silviânia
17135	SP	9044	Vila Sul Americana	Vl S Americana
17136	SP	9044	Vila Tambory	Vl Tambory
17137	SP	9044	Vila Teresa	Vl Teresa
17138	SP	9044	Vila Terezinha	Vl Terezinha
17139	SP	9044	Vila Três Irmãos	Vl T Irmãos
17140	SP	9044	Vila Veloso	Vl Veloso
17141	SP	9044	Vilarejo	\N
17142	SP	9052	Centro	\N
17143	SP	9052	Conjunto Habitacional Carlos Alberto Magalhães	Cj Hab C A Magalhães
17144	SP	9052	Conjunto Habitacional Comendador José A Borelli	Cj Hab Cdor J A Borelli
17145	SP	9052	Conjunto Habitacional Deputado Antônio Mastrocola	Cj Hab Dep A Mastrocola
17146	SP	9052	Conjunto Habitacional Dona Júlia B Caparroz	Cj Hab Da J B Caparroz
17147	SP	9052	Conjunto Habitacional Euclides Figueiredo	Cj Hab E Figueiredo
17148	SP	9052	Conjunto Habitacional Gabriel Hernandez	Cj Hab G Hernandez
17149	SP	9052	Conjunto Habitacional Orlando Facci	Cj Hab O Facci
17150	SP	9052	Conjunto Habitacional Prefeito João Righini	Cj Hab Pref J Righini
17151	SP	9052	Conjunto Habitacional Prefeito Pedro Nechar	Cj Hab Pref P Nechar
17152	SP	9052	Conjunto Polo Comercial e Industrial Giordano Mestrinelli	Cj P C E Ind G Mestrinelli
17153	SP	9052	Distrito Industrial Antônio Zácaro	Dt Ind A Zácaro
17154	SP	9052	Distrito Industrial José Antônio Boso	Dt Ind J A Boso
17155	SP	9052	Higienópolis	\N
17156	SP	9052	Jardim Aeroporto	Jd Aeroporto
17157	SP	9052	Jardim Alpino	Jd Alpino
17158	SP	9052	Jardim Alvorada	Jd Alvorada
17159	SP	9052	Jardim Amêndola	Jd Amêndola
17160	SP	9052	Jardim América	Jd América
17161	SP	9052	Jardim Augusta	Jd Augusta
17162	SP	9052	Jardim Bela Vista	Jd B Vista
17163	SP	9052	Jardim Brasil	Jd Brasil
17164	SP	9052	Jardim Caparroz	Jd Caparroz
17165	SP	9052	Jardim Clélia	Jd Clélia
17166	SP	9052	Jardim da Torre	Jd Torre
17167	SP	9052	Jardim Del Rey	Jd D Rey
17168	SP	9052	Jardim do Bosque	Jd Bosque
17169	SP	9052	Jardim do Lago	Jd Lago
17170	SP	9052	Jardim dos Coqueiros	Jd Coqueiros
17171	SP	9052	Jardim dos Coqueiros II	Jd Coqueiros II
17172	SP	9052	Jardim Esperança	Jd Esperança
17173	SP	9052	Jardim Glória	Jd Glória
17174	SP	9052	Jardim Glória II	Jd Glória II
17217	SP	9052	Parque Residencial Paraíso	Prq Res Paraíso
17218	SP	9052	Parque Residencial Santa Paula	Prq Res Sta Paula
17219	SP	9052	Residencial Comendador Pedro Monteleone	Res Cdor P Monteleone
17220	SP	9052	Residencial Granville	Res Granville
17221	SP	9052	Residencial Granville II	Res Granville II
17222	SP	9052	Residencial Júlia Caparroz	Res J Caparroz
17223	SP	9052	Residencial Lunardelli	Res Lunardelli
17224	SP	9052	Residencial Novo Tarraf	Res N Tarraf
17225	SP	9052	Residencial Primavera	Res Primavera
17226	SP	9052	Residencial San Remo	Res S Remo
17227	SP	9052	São Francisco	S Francisco
17228	SP	9052	Vila Alexandria	Vl Alexandria
17229	SP	9052	Vila Bela	Vl Bela
17230	SP	9052	Vila Celso Mauad	Vl C Mauad
17231	SP	9052	Vila de Roses	Vl Roses
17232	SP	9052	Vila Dona Engracia Agudo Romão	Vl Da E A Romão
17233	SP	9052	Vila Guzzo	Vl Guzzo
17234	SP	9052	Vila Industrial	Vl Industrial
17235	SP	9052	Vila Juca Pedro	Vl J Pedro
17236	SP	9052	Vila Maria Jorge	Vl M Jorge
17237	SP	9052	Vila Motta	Vl Motta
17238	SP	9052	Vila Paulista	Vl Paulista
17239	SP	9052	Vila Rodrigues	Vl Rodrigues
17240	SP	9052	Vila Santo Antônio	Vl Sto Antônio
17242	SP	9052	Vila São Luiz	Vl S Luiz
17243	SP	9082	Água Espraiada (Caucaia do Alto)	A Espraiada (C Alto)
17244	SP	9082	Altos de Caucaia (Caucaia do Alto)	A Caucaia (C Alto)
17245	SP	9082	Bosque do Vianna	Bsq Vianna
17246	SP	9082	Cachoeira	\N
17248	SP	9082	Caminho do Sol	Cam Sol
17249	SP	9082	Caputera	\N
17250	SP	9082	Centreville	\N
17251	SP	9082	Centro	\N
17252	SP	9082	Centro (Caucaia do Alto)	Centro (C Alto)
17253	SP	9082	Chácara Canta Galo	Ch C Galo
17254	SP	9082	Chácara Pavoeiro	Ch Pavoeiro
17255	SP	9082	Chácara Real (Caucaia do Alto)	Ch Real (C Alto)
17256	SP	9082	Chácara Remanso (Caucaia do Alto)	Ch Remanso (C Alto)
17257	SP	9082	Chácara Rincão	Ch Rincão
17258	SP	9082	Chácara Roselândia	Ch Roselândia
17259	SP	9082	Chácara Santa Maria	Ch Sta Maria
17260	SP	9082	Chácara Santa Rosa	Ch Sta Rosa
17261	SP	9082	Chácara Tropical (Caucaia do Alto)	Ch Tropical (C Alto)
17262	SP	9082	Chácara Vista Alegre	Ch V Alegre
17263	SP	9082	Colinas de Cotia	C Cotia
17076	SP	9044	Pousada dos Bandeirantes	P Bandeirantes
17077	SP	9044	Recantinho	\N
17078	SP	9044	Recanto Campy	Rec Campy
17079	SP	9044	Recanto Impla	Rec Impla
17080	SP	9044	Recanto Verde	Rec Verde
17081	SP	9044	Residencial Euroville	Res Euroville
17082	SP	9044	Terras do Madeira	T Madeira
17083	SP	9044	Vila América	Vl América
17084	SP	9044	Vila Anunciata	Vl Anunciata
17085	SP	9044	Vila Appia Antica	Vl A Antica
17086	SP	9044	Vila Artem	Vl Artem
17087	SP	9044	Vila Balog	Vl Balog
17088	SP	9044	Vila Bela	Vl Bela
17089	SP	9044	Vila Bolivar	Vl Bolivar
17090	SP	9044	Vila Caldas	Vl Caldas
17091	SP	9044	Vila Capriotti	Vl Capriotti
17092	SP	9044	Vila Clara	Vl Clara
17093	SP	9044	Vila Conquista	Vl Conquista
17094	SP	9044	Vila Creti	Vl Creti
17095	SP	9044	Vila da Oportunidade	Vl Oportunidade
17096	SP	9044	Vila Dirce	Vl Dirce
17097	SP	9044	Vila Diva	Vl Diva
17098	SP	9044	Vila dos Andrades	Vl Andrades
17099	SP	9044	Vila Ema	Vl Ema
17100	SP	9044	Vila Ester	Vl Ester
17101	SP	9044	Vila Freitas	Vl Freitas
17102	SP	9044	Vila Gobbi	Vl Gobbi
17103	SP	9044	Vila Guarani	Vl Guarani
17104	SP	9044	Vila Gustavo Correia	Vl G Correia
17105	SP	9044	Vila Helemar	Vl Helemar
17106	SP	9044	Vila Iza	Vl Iza
17107	SP	9044	Vila Janete	Vl Janete
17108	SP	9044	Vila Jussara	Vl Jussara
17109	SP	9044	Vila Leopoldo	Vl Leopoldo
17110	SP	9044	Vila Lisboa	Vl Lisboa
17111	SP	9044	Vila Lourdes	Vl Lourdes
17112	SP	9044	Vila Marcondes	Vl Marcondes
17113	SP	9044	Vila Margarida	Vl Margarida
17114	SP	9044	Vila Maria Helena	Vl M Helena
17115	SP	9044	Vila Martins	Vl Martins
17116	SP	9044	Vila Menk	Vl Menk
17117	SP	9044	Vila Mercês	Vl Mercês
17118	SP	9044	Vila Mor	Vl Mor
17119	SP	9044	Vila Municipal	Vl Municipal
17120	SP	9044	Vila Nossa Senhora Aparecida	Vl N Sra Aparecida
17121	SP	9044	Jardim Nova Carapicuíba	Jd N Carapicuíba
17122	SP	9044	Vila Odete	Vl Odete
17123	SP	9044	Vila Olivina	Vl Olivina
17124	SP	9044	Vila Quintino	Vl Quintino
17125	SP	9044	Vila Rosa	Vl Rosa
17126	SP	9044	Vila Santa Lúcia	Vl Sta Lúcia
17127	SP	9044	Vila Santa Terezinha	Vl Sta Terezinha
17128	SP	9044	Vila Santo Antônio	Vl Sto Antônio
17129	SP	9044	Vila São Jorge	Vl S Jorge
17130	SP	9044	Vila São José	Vl S José
17175	SP	9052	Jardim Imperial	Jd Imperial
17176	SP	9052	Jardim Ipanema	Jd Ipanema
17177	SP	9052	Jardim Irradiação	Jd Irradiação
17178	SP	9052	Jardim Monte Líbano	Jd Mte Líbano
17179	SP	9052	Jardim Nova Catanduva	Jd N Catanduva
17180	SP	9052	Jardim Oriental	Jd Oriental
17181	SP	9052	Jardim Pedro Borgoni	Jd P Borgoni
17182	SP	9052	Jardim Primavera	Jd Primavera
17183	SP	9052	Jardim Residencial Chiodini	Jd Res Chiodini
17184	SP	9052	Jardim Residencial Diolfen Martani	Jd Res D Martani
17185	SP	9052	Jardim Salles	Jd Salles
17186	SP	9052	Jardim Santa Helena	Jd Sta Helena
17187	SP	9052	Jardim Santa Rosa	Jd Sta Rosa
17188	SP	9052	Jardim Santo Antônio	Jd Sto Antônio
17189	SP	9052	Jardim São Domingos	Jd S Domingos
17190	SP	9052	Jardim Shangri-lá	Jd Shangri-lá
17191	SP	9052	Jardim Soto	Jd Soto
17192	SP	9052	Jardim Vertoni	Jd Vertoni
17193	SP	9052	Loteamento Altos do Higienópolis	Lot A Higienópolis
17194	SP	9052	Loteamento Antônio M Carvalho	Lot A M Carvalho
17195	SP	9052	Loteamento Bom Pastor	Lot B Pastor
17196	SP	9052	Loteamento Cerradinho	Lot Cerradinho
17197	SP	9052	Loteamento Colina do Sol	Lot C Sol
17198	SP	9052	Loteamento Jorge Mauad	Lot J Mauad
17199	SP	9052	Loteamento Miguel Elias	Lot M Elias
17200	SP	9052	Loteamento Morada dos Executivos	Lot M Executivos
17201	SP	9052	Loteamento Morada dos Pássaros	Lot M Pássaros
17202	SP	9052	Loteamento Nações Unidas	Lot N Unidas
17203	SP	9052	Loteamento São Pedro	Lot S Pedro
17204	SP	9052	Loteamento Solo Sagrado	Lot S Sagrado
17205	SP	9052	Parque Glória I	Prq Glória I
17206	SP	9052	Parque Glória II	Prq Glória II
17207	SP	9052	Parque Glória III	Prq Glória III
17208	SP	9052	Parque Glória IV	Prq Glória IV
17209	SP	9052	Parque Glória V	Prq Glória V
17210	SP	9052	Parque Ipiranga	Prq Ipiranga
17211	SP	9052	Parque Iracema	Prq Iracema
17212	SP	9052	Parque Joaquim Lopes	Prq J Lopes
17213	SP	9052	Parque Residencial Agudo Romão	Prq Res A Romão
17214	SP	9052	Parque Residencial Comendador João Amêndola	Prq Res Cdor J Amêndola
17215	SP	9052	Parque Residencial Flamingo	Prq Res Flamingo
17216	SP	9052	Parque Residencial Maria L P Faria	Prq Res M L P Faria
17264	SP	9082	Esmeralda Park (Caucaia do Alto)	E Park (C Alto)
17265	SP	9082	Furquim	\N
17266	SP	9082	Gramado	\N
17267	SP	9082	Granja Carolina	Gja Carolina
17268	SP	9082	Granja Clotilde	Gja Clotilde
17269	SP	9082	Granja Viana	Gja Viana
17270	SP	9082	Granja Viana II	Gja Viana II
17271	SP	9082	Haras Santa Bárbara	H Sta Bárbara
17272	SP	9082	Horizontal Park	H Park
17273	SP	9082	Jardim Adelina	Jd Adelina
17274	SP	9082	Jardim Ana Cristina (Caucaia do Alto)	Jd A Cristina (C Alto)
17275	SP	9082	Jardim Araruama	Jd Araruama
17276	SP	9082	Jardim Arco-Íris	Jd Arco-Íris
17277	SP	9082	Jardim Atalaia	Jd Atalaia
17278	SP	9082	Jardim Barbacena	Jd Barbacena
17279	SP	9082	Jardim Barro Branco	Jd B Branco
17280	SP	9082	Jardim Belizário	Jd Belizário
17281	SP	9082	Jardim Caiapiá	Jd Caiapiá
17282	SP	9082	Jardim Carmel	Jd Carmel
17283	SP	9082	Jardim Central	Jd Central
17284	SP	9082	Jardim Cláudio	Jd Cláudio
17285	SP	9082	Jardim Colibri	Jd Colibri
17286	SP	9082	Jardim Cotia	Jd Cotia
17287	SP	9082	Jardim da Glória	\N
17288	SP	9082	Jardim Nossa Senhora das Graças	Jd N Sra Graças
17289	SP	9082	Jardim das Oliveiras (Caucaia do Alto)	Jd Oliveiras (C Alto)
17290	SP	9082	Jardim Dinorah	Jd Dinorah
17291	SP	9082	Jardim do Engenho	Jd Engenho
17292	SP	9082	Jardim dos Ipês	\N
17293	SP	9082	Jardim dos Pereiras (Caucaia do Alto)	Jd Pereiras (C Alto)
17294	SP	9082	Jardim Eliane	Jd Eliane
17295	SP	9082	Jardim Elias	Jd Elias
17296	SP	9082	Jardim Empirio	Jd Empirio
17297	SP	9082	Jardim Estela Mari	Jd E Mari
17298	SP	9082	Jardim Fontana	Jd Fontana
17299	SP	9082	Jardim Guerreiro	Jd Guerreiro
17300	SP	9082	Jardim Ísis	Jd Ísis
17301	SP	9082	Jardim Japão (Caucaia do Alto)	Jd Japão (C Alto)
17302	SP	9082	Jardim Lambreta	Jd Lambreta
17303	SP	9082	Jardim Lavapes das Graças	Jd L Graças
17304	SP	9082	Jardim Leonor	Jd Leonor
17305	SP	9082	Jardim Lina	Jd Lina
17306	SP	9082	Jardim Maria Tereza	Jd M Tereza
17307	SP	9082	Jardim Miranda	Jd Miranda
17308	SP	9082	Jardim Monte Santo	Jd Mte Santo
17309	SP	9082	Jardim Nara Lúcia	Jd N Lúcia
17310	SP	9082	Jardim Nomura	Jd Nomura
17311	SP	9082	Jardim Nova Coimbra	Jd N Coimbra
17312	SP	9082	Jardim Nova Cotia	Jd N Cotia
17363	SP	9082	Pitas	\N
17364	SP	9082	Planalto (Caucaia do Alto)	Planalto (C Alto)
17365	SP	9082	Portal da Primavera	P Primavera
17366	SP	9082	Portal do Santa Paula	P Sta Paula
17367	SP	9082	Quinta dos Angicos	Qta Angicos
17368	SP	9082	Recanto Arco Verde	Rec A Verde
17369	SP	9082	Recanto dos Victor's	Rec Victor's
17370	SP	9082	Recanto Suave	Rec Suave
17371	SP	9082	Recanto Vista Alegre	Rec V Alegre
17372	SP	9082	Residencial Palma de Maiorca	Res P Maiorca
17373	SP	9082	Ressaca	\N
17374	SP	9082	Sítio Boa Vista	Sit B Vista
17375	SP	9082	Taboleiro Verde	T Verde
17376	SP	9082	Terras de São Felipe (Caucaia do Alto)	T S Felipe (C Alto)
17377	SP	9082	Vila Clara	Vl Clara
17378	SP	9082	Vila Hortência	Vl Hortência
17379	SP	9082	Vila Jovina	Vl Jovina
17380	SP	9082	Vila Monte Serrat	Vl Mte Serrat
17381	SP	9082	Vila Santa Terezinha	Vl Sta Terezinha
17382	SP	9082	Vila Santo Antônio	Vl Sto Antônio
17383	SP	9082	Vila São Francisco	Vl S Francisco
17384	SP	9082	Vila São Joaquim	Vl S Joaquim
17385	SP	9082	Vila São Roque (Caucaia do Alto)	Vl S Roque (C Alto)
17388	SP	9087	Centro	\N
17391	SP	9087	Itagaçaba	\N
17392	SP	9087	Jardim América	Jd América
17394	SP	9087	Jardim Imperial	Jd Imperial
17395	SP	9087	Jardim Paraíso	Jd Paraíso
17397	SP	9087	Jardim São José	Jd S José
17398	SP	9087	Lagoa Dourada	Lga Dourada
17402	SP	9087	Parque Primavera	Prq Primavera
17403	SP	9087	Retiro da Mantiqueira	Rer Mantiqueira
17406	SP	9087	Vila Ana Rosa Novaes	Vl A R Novaes
17409	SP	9087	Vila Bionde	Vl Bionde
17410	SP	9087	Vila Brasil	Vl Brasil
17411	SP	9087	Vila Canevari	Vl Canevari
17412	SP	9087	Vila Celestina	Vl Celestina
17415	SP	9087	Vila Doutor João Batista (Parte Alta)	Vl Dr J Batista (P Alta)
17416	SP	9087	Vila Doutor João Batista (Parte Baixa)	Vl Dr J Batista (P Baixa)
17419	SP	9087	Vila Expedicionários Cruzeirenses	Vl Exps Cruzeirenses
17430	SP	9087	Vila Paulo Romeu	Vl P Romeu
17431	SP	9087	Vila Pontilhão	Vl Pontilhão
17432	SP	9087	Vila Regina Célia	Vl R Célia
17434	SP	9087	Vila Romana	Vl Romana
17438	SP	9087	Vila Suely	Vl Suely
17440	SP	9087	Vila Washington Beleza	Vl W Beleza
17443	SP	9088	Centro	\N
17444	SP	9088	Conjunto Afonso Schmidt	Cj A Schmidt
17515	SP	9094	Jardim Fraternal	Jd Fraternal
17516	SP	9094	Jardim Gabriel Correia	Jd G Correia
17517	SP	9094	Inamar	\N
17518	SP	9094	Jardim Ingaí	Jd Ingaí
17519	SP	9094	Jardim Lilianeli	Jd Lilianeli
17520	SP	9094	Jardim Mafalda	Jd Mafalda
17521	SP	9094	Jardim Marajá	Jd Marajá
17522	SP	9094	Jardim Marão	Jd Marão
17523	SP	9094	Jardim Maravilha	Jd Maravilha
17524	SP	9094	Jardim Maria Cláudia	Jd M Cláudia
17525	SP	9094	Jardim Maria Helena(Serraria)	Jd M Helena (Serraria)
17526	SP	9094	Jardim Maria Tereza	Jd M Tereza
17527	SP	9094	Jardim Marilene	Jd Marilene
17528	SP	9094	Jardim Maringá	Jd Maringá
17529	SP	9094	Jardim Mombae	Jd Mombae
17530	SP	9094	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
17531	SP	9094	Jardim Novo Lar	Jd N Lar
17532	SP	9094	Jardim Olga	Jd Olga
17533	SP	9094	Jardim Pean	Jd Pean
17534	SP	9094	Jardim Piraporinha	Jd Piraporinha
17535	SP	9094	Jardim Pitangueiras	Jd Pitangueiras
17536	SP	9094	Jardim Portinari	Jd Portinari
17537	SP	9094	Jardim Promissão	Jd Promissão
17538	SP	9094	Jardim Recanto	Jd Recanto
17539	SP	9094	Jardim Remanso	Jd Remanso
17540	SP	9094	Jardim Rey	Jd Rey
17541	SP	9094	Jardim Rosinha	Jd Rosinha
17542	SP	9094	Jardim Ruyce	Jd Ruyce
17543	SP	9094	Jardim Sandra	Jd Sandra
17544	SP	9094	Jardim Santa Cândida	Jd Sta Cândida
17545	SP	9094	Jardim Santa Dirce	Jd Sta Dirce
17546	SP	9094	Jardim Santa Elizabeth	Jd Sta Elizabeth
17547	SP	9094	Jardim Santa Filomena	Jd Sta Filomena
17548	SP	9094	Jardim Santa Rita	Jd Sta Rita
17549	SP	9094	Jardim São Judas Tadeu	Jd S J Tadeu
17550	SP	9094	Jardim Sara Regina	Jd S Regina
17551	SP	9094	Jardim Sônia	Jd Sônia
17552	SP	9094	Jardim Takebe	Jd Takebe
17553	SP	9094	Jardim Tamoio	Jd Tamoio
17554	SP	9094	Jardim Tijuco	Jd Tijuco
17555	SP	9094	Jardim Tiradentes	Jd Tiradentes
17556	SP	9094	Jardim Transilvânia	Jd Transilvânia
17557	SP	9094	Jardim União	Jd União
17558	SP	9094	Jardim Vera Lúcia	Jd V Lúcia
17559	SP	9094	Jardim Yamberê	Jd Yamberê
17560	SP	9094	Jardim Yvone	Jd Yvone
17561	SP	9094	Loteamento Elbio Camilo	Lot E Camilo
17562	SP	9094	Loteamento Joaquim de Oliveira	Lot J Oliveira
17563	SP	9094	Loteamento Júlio Adaí	Lot J Adaí
17639	SP	9113	Chácaras Embu	C Embu
17640	SP	9113	Embu Colonial	E Colonial
17641	SP	9113	Chácaras Esplanada do Embu	C Esp Embu
17642	SP	9113	Chácaras Estância Panorama	C Etn Panorama
17643	SP	9113	Chácaras Lidia	C Lidia
17644	SP	9113	Chácaras Marajuara	C Marajuara
17645	SP	9113	Chácaras Maria Alice	C M Alice
17646	SP	9113	Chácaras São Cristóvão	C S Cristóvão
17647	SP	9113	Chácaras São Marcos	C S Marcos
17648	SP	9113	Chácaras Uirapuru	C Uirapuru
17649	SP	9113	Estância  de Embuarama	Etn Embuarama
17650	SP	9113	Condomínio Green Valley	Cond G Valley
17651	SP	9113	Condomínio Meu Recanto	Cond M Recanto
17652	SP	9113	Conjunto Residencial Vila Carvalho	Cj Res Vl Carvalho
17653	SP	9113	Jardim Ângela	Jd Ângela
17654	SP	9113	Jardim Arabutan	Jd Arabutan
17655	SP	9113	Jardim Batista	Jd Batista
17656	SP	9113	Jardim Casa Branca	Jd C Branca
17657	SP	9113	Jardim Castilho	Jd Castilho
17658	SP	9113	Jardim do Colégio	Jd Colégio
17659	SP	9113	Jardim Colibri	Jd Colibri
17660	SP	9113	Jardim Cultura Física	Jd C Física
17661	SP	9113	Jardim da Luz	Jd Luz
17662	SP	9113	Jardim das Colinas	Jd Colinas
17663	SP	9113	Jardim de Lourdes	Jd Lourdes
17664	SP	9113	Jardim do Sol	Jd Sol
17665	SP	9113	Jardim Dom José	Jd D José
17666	SP	9113	Parque dos Caetes	Prq Caetes
17667	SP	9113	Jardim dos Oliveiras	Jd Oliveiras
17668	SP	9113	Jardim Elisa	Jd Elisa
17669	SP	9113	Embuema	\N
17670	SP	9113	Jardim Emílio Carlos	Jd E Carlos
17671	SP	9113	Jardim Estela	Jd Estela
17672	SP	9113	Jardim Fabiana	Jd Fabiana
17673	SP	9113	Jardim Ferraz	Jd Ferraz
17674	SP	9113	Jardim Ferreira	Jd Ferreira
17675	SP	9113	Jardim Flórida	Jd Flórida
17676	SP	9113	Jardim Independência	Jd Independência
17677	SP	9113	Jardim Independência II	Jd Independência II
17678	SP	9113	Jardim Irapiranga	Jd Irapiranga
17679	SP	9113	Jardim Irene	Jd Irene
17680	SP	9113	Jardim Itatiaia	Jd Itatiaia
17681	SP	9113	Jardim Júlia	Jd Júlia
17682	SP	9113	Jardim Jurema	Jd Jurema
17683	SP	9113	Jardim Laila	Jd Laila
17684	SP	9113	Jardim Liberdade	Jd Liberdade
17685	SP	9113	Jardim Mabilia	Jd Mabilia
17686	SP	9113	Jardim Maciel	Jd Maciel
17687	SP	9113	Jardim Magaly	Jd Magaly
17688	SP	9113	Maranhão	\N
17689	SP	9113	Jardim Marina	Jd Marina
17740	SP	9113	Vila Carvalho	Vl Carvalho
17741	SP	9113	Vila Célia Regina	Vl C Regina
17742	SP	9113	Cercado Grande	C Grande
17743	SP	9113	Engenho Velho	E Velho
17744	SP	9113	Vila Ísis Cristina	Vl I Cristina
17745	SP	9113	Vila Maísa	Vl Maísa
17746	SP	9113	Vila Marajoara	Vl Marajoara
17747	SP	9113	Maria Auxiliadora	M Auxiliadora
17748	SP	9113	Vila Mei	Vl Mei
17749	SP	9113	Vila Olinda	Vl Olinda
17750	SP	9113	Vila Perequê	Vl Perequê
17751	SP	9113	Moinho Velho	M Velho
17752	SP	9113	Vila Regina	Vl Regina
17753	SP	9113	Vila Rodrigues	Vl Rodrigues
17754	SP	9113	Vila Salim	Vl Salim
17755	SP	9113	Vila Santa Maria	Vl Sta Maria
17756	SP	9113	Vila São José	Vl S José
17757	SP	9113	Vila Simone	Vl Simone
17758	SP	9113	Vila Triângulo	Vl Triângulo
17759	SP	9113	Votorantim	\N
17761	SP	9138	Centro	\N
17762	SP	9138	Chácara das Uvas	Ch Uvas
17763	SP	9138	Chácara Descansolândia	Ch Descansolândia
17764	SP	9138	Chácara Flora	Ch Flora
17765	SP	9138	Chácara Guaio	Ch Guaio
17766	SP	9138	Chácara Laguna	Ch Laguna
17767	SP	9138	Chácara Quinze de Novembro	Ch Q Novembro
17768	SP	9138	Chácara Servidone	Ch Servidone
17769	SP	9138	Cidade Kemel	C Kemel
17770	SP	9138	Conjunto Residencial Bandeirantes	Cj Res Bandeirantes
17771	SP	9138	Conjunto Residencial José Chacon Moriel	Cj Res J C Moriel
17772	SP	9138	Conjunto Residencial Presidente Castello Branco	Cj Res Pres C Branco
17773	SP	9138	Conjunto Residencial Santa Teresa	Cj Res Sta Teresa
17775	SP	9138	Jardim Alexandre	Jd Alexandre
17776	SP	9138	Jardim Alice	Jd Alice
17777	SP	9138	Jardim Amalfi	Jd Amalfi
17778	SP	9138	Jardim Anchieta	Jd Anchieta
17779	SP	9138	Jardim Angelina	Jd Angelina
17780	SP	9138	Jardim Ayda	Jd Ayda
17781	SP	9138	Jardim Bela Vista	Jd B Vista
17782	SP	9138	Jardim Brígida	Jd Brígida
17783	SP	9138	Jardim Burza	Jd Burza
17784	SP	9138	Jardim Cambiri	Jd Cambiri
17785	SP	9138	Jardim Dayse	Jd Dayse
17786	SP	9138	Jardim Débora	Jd Débora
17787	SP	9138	Jardim do Castelo	Jd Castelo
17788	SP	9138	Jardim do Papai	Jd Papai
17790	SP	9138	Jardim do Sol	Jd Sol
17793	SP	9138	Jardim Espinha	Jd Espinha
17797	SP	9138	Jardim Ferrazense	Jd Ferrazense
17798	SP	9138	Jardim Figueiredo	Jd Figueiredo
17861	SP	9138	Parque São Judas Tadeu	Prq S J Tadeu
17863	SP	9138	Rosado	\N
17864	SP	9138	Roseiras	\N
17865	SP	9138	Sitio Alferes	S Alferes
17866	SP	9138	Sitio Florencios	S Florencios
17868	SP	9138	Sitio Paredão	S Paredão
17869	SP	9138	Sitio Sebastião Soares	S S Soares
17870	SP	9138	Tanquinho	\N
17871	SP	9138	Vila Alayde	Vl Alayde
17872	SP	9138	Vila do Americano	Vl Americano
17873	SP	9138	Vila Ana Maria	Vl A Maria
17874	SP	9138	Vila Andeyara	Vl Andeyara
17875	SP	9138	Vila Andrea	Vl Andrea
17876	SP	9138	Vila Arbame	Vl Arbame
17877	SP	9138	Vila Ayda	Vl Ayda
17878	SP	9138	Vila Bianchi	Vl Bianchi
17879	SP	9138	Vila Central	Vl Central
17880	SP	9138	Vila Correa	Vl Correa
17882	SP	9138	Vila Cristina	Vl Cristina
17883	SP	9138	Vila das Nações	Vl Nações
17884	SP	9138	Vila das Pedreiras	Vl Pedreiras
17885	SP	9138	Vila das Roseiras	Vl Roseiras
17887	SP	9138	Vila Jamil	Vl Jamil
17888	SP	9138	Vila Joana D'Arc	Vl J D'Arc
17889	SP	9138	Vila Jurema	Vl Jurema
17890	SP	9138	Vila Leite	Vl Leite
17891	SP	9138	Vila Loanda	Vl Loanda
17892	SP	9138	Vila Maria Rosa	Vl M Rosa
17893	SP	9138	Vila Mariana	Vl Mariana
17894	SP	9138	Vila Mariano	Vl Mariano
17895	SP	9138	Vila Nova	Vl Nova
17896	SP	9138	Vila Oliveira	Vl Oliveira
17897	SP	9138	Vila Panucce	Vl Panucce
17898	SP	9138	Vila Pereira	Vl Pereira
17900	SP	9138	Vila Primavera	Vl Primavera
17901	SP	9138	Vila Romanópolis	Vl Romanópolis
17902	SP	9138	Vila Santa Margarida	Vl Sta Margarida
17903	SP	9138	Vila Santo Antônio	Vl Sto Antônio
17905	SP	9138	Vila São Paulo	Vl S Paulo
17906	SP	9138	Vila São Sebastião	Vl S Sebastião
17907	SP	9138	Vila Sofia	Vl Sofia
17908	SP	9138	Vila Solar	Vl Solar
17909	SP	9138	Vila Tanquinho	Vl Tanquinho
17911	SP	9138	Vila Zita	Vl Zita
17912	SP	9144	Belvedere Bandeirante	Belv Bandeirante
17913	SP	9144	Boa Vista	B Vista
17914	SP	9144	Centro	\N
17916	SP	9144	Chácara Espraiado	Ch Espraiado
17918	SP	9144	Chácara Santo Antônio	Ch Sto Antônio
17919	SP	9144	Chácaras São Paulo	C S Paulo
17920	SP	9144	Cidade Nova	C Nova
17921	SP	9144	City Petrópolis	C Petrópolis
17922	SP	9144	Distrito Industrial Antônio Della - Torre	Dt Ind A Della - Torre
17923	SP	9144	Estação	\N
17924	SP	9144	Higienópolis	\N
17313	SP	9082	Jardim Nova Vida	Jd N Vida
17314	SP	9082	Jardim Panorama	Jd Panorama
17315	SP	9082	Jardim Passárgada I	Jd Passárgada I
17317	SP	9082	Jardim Petrópolis	Jd Petrópolis
17318	SP	9082	Jardim Pioneira	Jd Pioneira
17319	SP	9082	Jardim Rebelato	Jd Rebelato
17320	SP	9082	Jardim Recanto Suave	Jd Rec Suave
17321	SP	9082	Jardim do Rio Cotia	Jd R Cotia
17322	SP	9082	Jardim Rio das Pedras	Jd R Pedras
17323	SP	9082	Jardim Rosa Azul (Caucaia do Alto)	Jd R Azul (C Alto)
17324	SP	9082	Jardim Rosalina	Jd Rosalina
17325	SP	9082	Jardim Rosemary	Jd Rosemary
17326	SP	9082	Jardim Sabiá	Jd Sabiá
17327	SP	9082	Jardim San Ressore (Caucaia do Alto)	Jd S Ressore (C Alto)
17328	SP	9082	Jardim Sandra	Jd Sandra
17329	SP	9082	Jardim Santa Izabel	Jd Sta Izabel
17330	SP	9082	Jardim Santa Maria	Jd Sta Maria
17331	SP	9082	Jardim Santa Paula	Jd Sta Paula
17332	SP	9082	Jardim Santana	Jd Santana
17333	SP	9082	Jardim São Luiz (Caucaia do Alto)	Jd S Luiz (C Alto)
17334	SP	9082	Jardim São Miguel	Jd S Miguel
17335	SP	9082	Jardim São Paulo II	Jd S Paulo II
17336	SP	9082	Jardim São Pedro	Jd S Pedro
17337	SP	9082	Jardim São Vicente	Jd S Vicente
17338	SP	9082	Jardim Semiramis	Jd Semiramis
17339	SP	9082	Jardim Wanda	Jd Wanda
17340	SP	9082	Lageadinho	\N
17341	SP	9082	Moinho Velho	M Velho
17343	SP	9082	Morro Grande	Mro Grande
17344	SP	9082	Nakamura Park	N Park
17345	SP	9082	Paisagem Renoir	P Renoir
17346	SP	9082	Parque Alexandre	Prq Alexandre
17347	SP	9082	Parque Bahia	Prq Bahia
17348	SP	9082	Parque das Rosas	Prq Rosas
17349	SP	9082	Parque Dom Henrique	Prq D Henrique
17350	SP	9082	Parque Isaac Pires	Prq I Pires
17351	SP	9082	Parque Miguel Mirizola	Prq M Mirizola
17352	SP	9082	Parque Mirante da Mata	Prq M Mata
17353	SP	9082	Parque Monjolo	Prq Monjolo
17354	SP	9082	Parque Paulistano	Prq Paulistano
17355	SP	9082	Parque Rincão	Prq Rincão
17356	SP	9082	Parque Rizzo II	Prq Rizzo II
17357	SP	9082	Parque Santa Rita de Cássia	Prq Sta R Cássia
17358	SP	9082	Parque São George	Prq S George
17359	SP	9082	Parque Turiguara	Prq Turiguara
17360	SP	9082	das Pedras	Pedras
17361	SP	9082	dos Pereiras (Caucaia do Alto)	Pereiras (C Alto)
17362	SP	9082	Pinus Park	P Park
17445	SP	9088	Conjunto Marechal Rondon	Cj Mal Rondon
17446	SP	9088	Fabril	\N
17447	SP	9088	Jardim Casqueiro	Jd Casqueiro
17448	SP	9088	Jardim Costa e Silva	Jd C E Silva
17449	SP	9088	Jardim das Indústrias	Jd Indústrias
17450	SP	9088	Jardim Nova República	Jd N República
17451	SP	9088	Jardim São Francisco	Jd S Francisco
17452	SP	9088	Jardim São Marcos	Jd S Marcos
17453	SP	9088	Jardim Trinta e Um de Março	Jd T E U Março
17454	SP	9088	Padre Manoel da Nóbrega	Pe M Nóbrega
17455	SP	9088	Parque Fernando Jorge	Prq F Jorge
17456	SP	9088	Parque São Luis	Prq S Luis
17457	SP	9088	Piacaguera	\N
17458	SP	9088	Pica-Pau	\N
17459	SP	9088	Santa Tereza	Sta Tereza
17460	SP	9088	Vila Caraguata	Vl Caraguata
17461	SP	9088	Vila Costa Muniz	Vl C Muniz
17462	SP	9088	Vila Couto	Vl Couto
17463	SP	9088	Vila dos Pescadores	Vl Pescadores
17464	SP	9088	Vila Elizabeth	Vl Elizabeth
17465	SP	9088	Vila Esperança	Vl Esperança
17466	SP	9088	Vila Natal	Vl Natal
17467	SP	9088	Vila Nova	Vl Nova
17468	SP	9088	Vila Parisi	Vl Parisi
17469	SP	9088	Vila Paulista	Vl Paulista
17470	SP	9088	Vila Pelicas	Vl Pelicas
17471	SP	9088	Vila Ponte Nova	Vl Pte Nova
17472	SP	9088	Vila Santa Rosa	Vl Sta Rosa
17473	SP	9088	Vila São Benedito	Vl S Benedito
17474	SP	9088	Vila São José	Vl S José
17475	SP	9094	Campanário	\N
17476	SP	9094	Canhema	\N
17477	SP	9094	Casa Grande	C Grande
17478	SP	9094	Centro	\N
17479	SP	9094	Chácara Húngara	Ch Húngara
17482	SP	9094	Eldorado	\N
17484	SP	9094	Eucaliptos	\N
17497	SP	9094	Jardim Campanário	Jd Campanário
17498	SP	9094	Jardim Canhema	Jd Canhema
17500	SP	9094	Jardim Conceição	Jd Conceição
17501	SP	9094	Jardim Concórdia	Jd Concórdia
17502	SP	9094	Jardim Damasco	Jd Damasco
17503	SP	9094	Jardim das Nações	Jd Nações
17504	SP	9094	Jardim das Paineiras	Jd Paineiras
17505	SP	9094	Jardim Diadema	Jd Diadema
17506	SP	9094	Jardim do Comércio	Jd Comércio
17507	SP	9094	Jardim do Parque	Jd Parque
17508	SP	9094	Jardim Donini	Jd Donini
17509	SP	9094	Jardim dos Navegantes	Jd Navegantes
17510	SP	9094	Jardim Dupont	Jd Dupont
17511	SP	9094	Jardim Eldorado	Jd Eldorado
17512	SP	9094	Jardim Elisa	Jd Elisa
17513	SP	9094	Jardim Elite	Jd Elite
17514	SP	9094	Jardim Ellen	Jd Ellen
17564	SP	9094	Parque das Jaboticabeiras	Prq Jaboticabeiras
17565	SP	9094	Parque Galícia	Prq Galícia
17566	SP	9094	Parque Mamede	Prq Mamede
17567	SP	9094	Parque Real	Prq Real
17568	SP	9094	Parque Reid	Prq Reid
17569	SP	9094	Parque Sete de Setembro	Prq S Setembro
17570	SP	9094	Piraporinha	\N
17571	SP	9094	Praia Vermelha	Pr Vermelha
17572	SP	9094	Serraria	\N
17573	SP	9094	Sítio Mato Dentro	Sit M Dentro
17574	SP	9094	Taboão	\N
17582	SP	9094	Conceição	\N
17583	SP	9094	Vila Diadema	Vl Diadema
17588	SP	9094	Vila Ester	Vl Ester
17589	SP	9094	Vila Flávia	Vl Flávia
17590	SP	9094	Vila Goyotin	Vl Goyotin
17591	SP	9094	Vila Hellas	Vl Hellas
17593	SP	9094	Vila Ida	Vl Ida
17594	SP	9094	Vila Idealópolis	Vl Idealópolis
17595	SP	9094	Vila Iran	Vl Iran
17596	SP	9094	Vila Jacira	Vl Jacira
17597	SP	9094	Vila Lia	Vl Lia
17598	SP	9094	Vila Lídia	Vl Lídia
17599	SP	9094	Vila Maria Leonor	Vl M Leonor
17600	SP	9094	Vila Marina	Vl Marina
17601	SP	9094	Vila Marques	Vl Marques
17602	SP	9094	Vila Marta	Vl Marta
17603	SP	9094	Vila Mulford	Vl Mulford
17604	SP	9094	Vila Nogueira	Vl Nogueira
17605	SP	9094	Vila Nova Esperança	Vl N Esperança
17606	SP	9094	Vila Nova Santa Luzia	Vl N Sta Luzia
17607	SP	9094	Vila Odete	Vl Odete
17608	SP	9094	Vila Oriental	Vl Oriental
17610	SP	9094	Vila Paulina	Vl Paulina
17611	SP	9094	Vila Poente	Vl Poente
17612	SP	9094	Vila Regina	Vl Regina
17613	SP	9094	Vila Santa Antônia	Vl Sta Antônia
17614	SP	9094	Vila Santa Cecília	Vl Sta Cecília
17615	SP	9094	Vila Santa Fé	Vl Sta Fé
17616	SP	9094	Vila Santa Luzia	Vl Sta Luzia
17617	SP	9094	Vila Santa Maria	Vl Sta Maria
17618	SP	9094	Vila Santa Rita	Vl Sta Rita
17619	SP	9094	Vila Santa Terezinha	Vl Sta Terezinha
17620	SP	9094	Vila São José	Vl S José
17621	SP	9094	Vila São Vicente	Vl S Vicente
17622	SP	9094	Vila Sofia	Vl Sofia
17623	SP	9094	Vila Tachibana	Vl Tachibana
17628	SP	9113	Capuava	\N
17630	SP	9113	Centro	\N
17631	SP	9113	Chácara Vale da Boa Vida	Ch Vle B Vida
17633	SP	9113	Chácaras Ana Lúcia	C A Lúcia
17634	SP	9113	Chácaras Aurora	C Aurora
17635	SP	9113	Chácaras Bartira	C Bartira
17636	SP	9113	Bosque do Embu	Bsq Embu
17637	SP	9113	Chácaras Caxingui	C Caxingui
17638	SP	9113	Chácaras do Pinheirinho	C Pinheirinho
17690	SP	9113	Jardim Mascarenhas	Jd Mascarenhas
17691	SP	9113	Jardim Mimas	Jd Mimas
17692	SP	9113	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
17693	SP	9113	Jardim Nova República	Jd N República
17694	SP	9113	Jardim Novo Campo Limpo	Jd N Cpo Limpo
17695	SP	9113	Jardim Novo Embu	Jd N Embu
17696	SP	9113	Parque São Leonardo	Prq S Leonardo
17697	SP	9113	Pindorama	\N
17698	SP	9113	Jardim Pinheirinho	Jd Pinheirinho
17699	SP	9113	Jardim Pinheiros	Jd Pinheiros
17700	SP	9113	Jardim Presidente Kennedy	Jd Pres Kennedy
17701	SP	9113	Jardim Recanto da Fonte	Jd Rec Fonte
17702	SP	9113	Jardim Sadie	Jd Sadie
17703	SP	9113	Jardim Santa Bárbara	Jd Sta Bárbara
17704	SP	9113	Jardim Santa Clara	Jd Sta Clara
17705	SP	9113	Jardim Santa Emília	Jd Sta Emília
17706	SP	9113	Jardim Santa Luzia	Jd Sta Luzia
17707	SP	9113	Chácaras Santa Maria	C Sta Maria
17708	SP	9113	Jardim Santa Rita (Km 25)	Jd Sta Rita (Km 25)
17709	SP	9113	Santa Rosa	Sta Rosa
17710	SP	9113	Jardim Santa Tereza Novo	Jd Sta T Novo
17711	SP	9113	Jardim Santarém	Jd Santarém
17712	SP	9113	Jardim Santo Antônio	Jd Sto Antônio
17713	SP	9113	Jardim Santo Eduardo	Jd Sto Eduardo
17714	SP	9113	Jardim São Francisco	Jd S Francisco
17715	SP	9113	Jardim São Luiz	Jd S Luiz
17716	SP	9113	Jardim São Marcos	Jd S Marcos
17717	SP	9113	Jardim São Vicente	Jd S Vicente
17718	SP	9113	Jardim Sérgio	Jd Sérgio
17719	SP	9113	Jardim Silvana	Jd Silvana
17720	SP	9113	Jardim Sílvia	Jd Sílvia
17721	SP	9113	Jardim Taima	Jd Taima
17722	SP	9113	Jardim Tomé	Jd Tomé
17723	SP	9113	Jardim Valo Verde	Jd V Verde
17724	SP	9113	Jardim Vazame	Jd Vazame
17725	SP	9113	Jardim Vista Alegre	Jd V Alegre
17726	SP	9113	Lotes Vale da Boa Vida	L Vle B Vida
17727	SP	9113	Parque das Chácaras	Prq Chácaras
17728	SP	9113	Esplanada	\N
17729	SP	9113	Parque Industrial Ramos de Freitas	Prq Ind R Freitas
17730	SP	9113	Parque Jane	Prq Jane
17731	SP	9113	Parque Luíza	Prq Luíza
17732	SP	9113	Parque Pirajussara	Prq Pirajussara
17733	SP	9113	Jardim dos Moraes	Jd Moraes
17734	SP	9113	Vale do Sol	Vle Sol
17735	SP	9113	Sítio Seis Amigos	Sit S Amigos
17737	SP	9113	Vila Alice	Vl Alice
17738	SP	9113	Vila Anchieta	Vl Anchieta
17739	SP	9113	Vila Carmem	Vl Carmem
17799	SP	9138	Jardim Freire	Jd Freire
17801	SP	9138	Jardim Helena	Jd Helena
17803	SP	9138	Jardim Ipanema	Jd Ipanema
17805	SP	9138	Jardim Júlio de Carvalho	Jd J Carvalho
17806	SP	9138	Jardim Leila	Jd Leila
17807	SP	9138	Jardim Lourdes	Jd Lourdes
17808	SP	9138	Jardim Lozano	Jd Lozano
17809	SP	9138	Jardim Luiz Mauro	Jd L Mauro
17810	SP	9138	Jardim Malda	Jd Malda
17811	SP	9138	Jardim Maria Cecília	Jd M Cecília
17812	SP	9138	Jardim Melilo	Jd Melilo
17813	SP	9138	Jardim Mercedes	Jd Mercedes
17815	SP	9138	Jardim Nossa Senhora do Caminho	Jd N Sra Caminho
17816	SP	9138	Jardim Nosso Recanto	Jd N Recanto
17817	SP	9138	Jardim Nove de Julho	Jd N Julho
17820	SP	9138	Jardim Pérola	Jd Pérola
17821	SP	9138	Jardim Planalto Bancário	Jd P Bancário
17822	SP	9138	Jardim Primavera	Jd Primavera
17823	SP	9138	Jardim Renata	Jd Renata
17824	SP	9138	Jardim Rodrigues Alves	Jd R Alves
17825	SP	9138	Jardim Rosana	Jd Rosana
17826	SP	9138	Jardim San Giovani	Jd S Giovani
17827	SP	9138	Jardim Santa Rosa	Jd Sta Rosa
17828	SP	9138	Jardim Santiago	Jd Santiago
17829	SP	9138	Jardim São Benedito	Jd S Benedito
17830	SP	9138	Jardim São Carlos	Jd S Carlos
17831	SP	9138	Jardim São Fernando	Jd S Fernando
17832	SP	9138	Jardim São João	Jd S João
17833	SP	9138	Jardim São José	Jd S José
17835	SP	9138	Jardim São Judas Tadeu	Jd S J Tadeu
17836	SP	9138	Jardim São Lázaro	Jd S Lázaro
17837	SP	9138	Jardim São Luiz	Jd S Luiz
17838	SP	9138	Jardim Sara	Jd Sara
17840	SP	9138	Jardim Selma Helena	Jd S Helena
17841	SP	9138	Jardim Seminário	Jd Seminário
17843	SP	9138	Jardim Temporim	Jd Temporim
17844	SP	9138	Jardim Tinoco	Jd Tinoco
17845	SP	9138	Jardim Triângulo	Jd Triângulo
17846	SP	9138	Jardim TV	Jd TV
17849	SP	9138	Jardim Vico	Jd Vico
17850	SP	9138	Jardim Vista Alegre	Jd V Alegre
17851	SP	9138	Jardim Viviane	Jd Viviane
17852	SP	9138	Jardim Yone	Jd Yone
17853	SP	9138	Lageado	\N
17854	SP	9138	Jardim São Miguel	Jd S Miguel
17855	SP	9138	Meinho	\N
17856	SP	9138	Núcleo Itaim	Nuc Itaim
17857	SP	9138	Paiol Velho	P Velho
17858	SP	9138	Parque Dourado	Prq Dourado
17859	SP	9138	Parque Imperial	Prq Imperial
17860	SP	9138	Parque São Francisco	Prq S Francisco
17925	SP	9144	Jardim Aeroporto I	Jd Aeroporto I
17926	SP	9144	Jardim Aeroporto II	Jd Aeroporto II
17927	SP	9144	Jardim Aeroporto III	Jd Aeroporto III
17928	SP	9144	Jardim Aeroporto IV	Jd Aeroporto IV
17929	SP	9144	Jardim Alvorada	Jd Alvorada
17931	SP	9144	Jardim Ângela Rosa	Jd A Rosa
17932	SP	9144	Jardim Anita	Jd Anita
17933	SP	9144	Jardim Aviação	Jd Aviação
17934	SP	9144	Jardim Barão	Jd Barão
17935	SP	9144	Jardim Bethânia	Jd Bethânia
17936	SP	9144	Jardim Boa Esperança	Jd B Esperança
17937	SP	9144	Jardim Bonsucesso	Jd Bonsucesso
17938	SP	9144	Jardim Brasil	Jd Brasil
17939	SP	9144	Jardim Brasilândia	Jd Brasilândia
17941	SP	9144	Jardim Califórnia	Jd Califórnia
17942	SP	9144	Jardim Castelo Soberano	Jd C Soberano
17944	SP	9144	Jardim Centenário	Jd Centenário
17945	SP	9144	Jardim Conceição Leite	Jd C Leite
17946	SP	9144	Jardim Consolação	Jd Consolação
17947	SP	9144	Jardim das Palmeiras	Jd Palmeiras
17948	SP	9144	Jardim Dermínio	Jd Dermínio
17949	SP	9144	Jardim Doutor Antônio Petráglia	Jd Dr A Petráglia
17950	SP	9144	Jardim Éden	Jd Éden
17952	SP	9144	Jardim Espraiado	Jd Espraiado
17953	SP	9144	Jardim Flórida	Jd Flórida
17954	SP	9144	Jardim Francano	Jd Francano
17956	SP	9144	Jardim Integração	Jd Integração
17957	SP	9144	Jardim Ipanema	Jd Ipanema
17959	SP	9144	Jardim Líbano	Jd Líbano
17960	SP	9144	Jardim Lima	Jd Lima
17961	SP	9144	Jardim Luiza	Jd Luiza
17962	SP	9144	Jardim Marambaia	Jd Marambaia
17963	SP	9144	Jardim Maria Gabriela	Jd M Gabriela
17964	SP	9144	Jardim Maria Rosa	Jd M Rosa
17966	SP	9144	Jardim Martins	Jd Martins
17969	SP	9144	Jardim Monte Carlo	Jd Mte Carlo
17970	SP	9144	Jardim Noêmia	Jd Noêmia
17971	SP	9144	Jardim Paineiras	Jd Paineiras
17972	SP	9144	Jardim Palestina	Jd Palestina
17973	SP	9144	Jardim Palma	Jd Palma
17974	SP	9144	Jardim Panorama	Jd Panorama
17975	SP	9144	Jardim Paraty	Jd Paraty
17976	SP	9144	Jardim Paulista	Jd Paulista
17977	SP	9144	Jardim Paulistano	Jd Paulistano
17979	SP	9144	Jardim Pinheiros I	Jd Pinheiros I
17980	SP	9144	Jardim Pinheiros II	Jd Pinheiros II
17981	SP	9144	Jardim Planalto	Jd Planalto
17982	SP	9144	Jardim Portinari	Jd Portinari
17983	SP	9144	Jardim Primavera	Jd Primavera
18055	SP	9144	Prolongamento Jardim Aeroporto II	Prl Jd Aeroporto II
18056	SP	9144	Prolongamento Jardim Ângela Rosa	Prl Jd A Rosa
18061	SP	9144	Prolongamento Jardim Doutor Antônio Petráglia	Prl Jd Dr A Petráglia
18062	SP	9144	Prolongamento Jardim Flórida	Prl Jd Flórida
18064	SP	9144	Prolongamento Jardim Lima	Prl Jd Lima
18065	SP	9144	Jardim Piratininga II	Jd Piratininga II
18071	SP	9144	Prolongamento Vila Aparecida II	Prl Vl Aparecida II
18074	SP	9144	Prolongamento Vila Duque de Caxias	Prl Vl Dq Caxias
18077	SP	9144	Prolongamento Vila Industrial	Prl Vl Industrial
18081	SP	9144	Prolongamento Vila Santa Cruz	Prl Vl Sta Cruz
18088	SP	9144	Recanto Capitão Heliodoro	Rec Cap Heliodoro
18089	SP	9144	Recanto do Itambé	Rec Itambé
18090	SP	9144	Recanto Elimar	Rec Elimar
18091	SP	9144	Recanto Fortuna	Rec Fortuna
18092	SP	9144	Recreio Campo Belo	Rcr Cpo Belo
18093	SP	9144	Residencial Baldassari	Res Baldassari
18094	SP	9144	Residencial Jardim Vera Cruz	Res Jd V Cruz
18096	SP	9144	Residencial Moreira Júnior	Res M Júnior
18097	SP	9144	Residencial Nosso Lar	Res N Lar
18098	SP	9144	Residencial Olavo Pinheiro	Res O Pinheiro
18099	SP	9144	Residencial Oswaldo Maciel	Res O Maciel
18100	SP	9144	Residencial Paraíso	Res Paraíso
18101	SP	9144	Residencial São Tomaz	Res S Tomaz
18102	SP	9144	Santo Agostinho	Sto Agostinho
18104	SP	9144	São Joaquim	S Joaquim
18105	SP	9144	São José	S José
18106	SP	9144	São Miguel	S Miguel
18107	SP	9144	Vale da Lua Azul	Vle L Azul
18110	SP	9144	Vila Aparecida	Vl Aparecida
18112	SP	9144	Vila Champagnat	Vl Champagnat
18113	SP	9144	Vila Chico Júlio	Vl C Júlio
18115	SP	9144	Vila Coronel Antônio J Sobrinho	Vl Cel A J Sobrinho
18117	SP	9144	Vila Europa	Vl Europa
18118	SP	9144	Vila Exposição	Vl Exposição
18119	SP	9144	Vila Flores	Vl Flores
18120	SP	9144	Vila Formosa	Vl Formosa
18125	SP	9144	Vila Hípica	Vl Hípica
18127	SP	9144	Vila Industrial	Vl Industrial
18129	SP	9144	Vila Marta	Vl Marta
18132	SP	9144	Vila Nicácio	Vl Nicácio
18133	SP	9144	Vila Nossa Senhora das Graças	Vl N Sra Graças
18134	SP	9144	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
18135	SP	9144	Vila Pandolfo	Vl Pandolfo
18140	SP	9144	Vila Raycos	Vl Raycos
18194	SP	9145	Jardim Flórida	Jd Flórida
18195	SP	9145	Jardim Gennari	Jd Gennari
18196	SP	9145	Jardim Liliane	Jd Liliane
18197	SP	9145	Jardim Luíza	Jd Luíza
18198	SP	9145	Jardim Magalhães	Jd Magalhães
18199	SP	9145	Jardim Meu Recanto	Jd M Recanto
18200	SP	9145	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
18202	SP	9145	Jardim Nova Belém	Jd N Belém
18203	SP	9145	Jardim Nova Esperança	Jd N Esperança
18204	SP	9145	Jardim Nova Morada	Jd N Morada
18205	SP	9145	Jardim Olga	Jd Olga
18206	SP	9145	Jardim Ouro Preto	Jd O Preto
18207	SP	9145	Jardim Planalto do Belém	Jd P Belém
18208	SP	9145	Jardim Primavera	Jd Primavera
18209	SP	9145	Jardim Professor Francisco Morato	Jd Prf F Morato
18210	SP	9145	Jardim Rogerio Levorin	Jd R Levorin
18211	SP	9145	Jardim Rosa	Jd Rosa
18212	SP	9145	Jardim Santa Catarina	Jd Sta Catarina
18213	SP	9145	Jardim Santa Catarina II	Jd Sta Catarina II
18214	SP	9145	Jardim Santa Helena	Jd Sta Helena
18215	SP	9145	Jardim Santa Rosa	Jd Sta Rosa
18216	SP	9145	Jardim Santo Antônio	Jd Sto Antônio
18217	SP	9145	Jardim São Joaquim	Jd S Joaquim
18218	SP	9145	Jardim São Jorge	Jd S Jorge
18219	SP	9145	Jardim São José	Jd S José
18220	SP	9145	Jardim São Severino	Jd S Severino
18221	SP	9145	Jardim Silvia	Jd Silvia
18222	SP	9145	Jardim Sinobe	Jd Sinobe
18223	SP	9145	Jardim Vagliengo	Jd Vagliengo
18224	SP	9145	Jardim Vassouras	Jd Vassouras
18225	SP	9145	Jardim Vassouras II	Jd Vassouras II
18226	SP	9145	Jardim Vila Belém	Jd Vl Belém
18227	SP	9145	Jardim Virginia	Jd Virginia
18228	SP	9145	Núcleo João Jungle	Nuc J Jungle
18229	SP	9145	Parque Água Vermelha	Prq A Vermelha
18230	SP	9145	Parque Belém	Prq Belém
18231	SP	9145	Parque Cento e Vinte	Prq C E Vinte
18232	SP	9145	Parque Climateric Rolland	Prq C Rolland
18233	SP	9145	Parque dos Eucaliptos	Prq Eucaliptos
18234	SP	9145	Parque Morumbi	Prq Morumbi
18235	SP	9145	Parque Paulista	Prq Paulista
18236	SP	9145	Parque Santana	Prq Santana
18237	SP	9145	Portal do Lago	P Lago
18238	SP	9145	Recanto Feliz	Rec Feliz
18239	SP	9145	Recanto Regina	Rec Regina
18240	SP	9145	Recanto Soraya	Rec Soraya
18241	SP	9145	Residencial Casa Grande I	Res C Grande I
17985	SP	9144	Jardim Redentor	Jd Redentor
17987	SP	9144	Jardim Riviera	Jd Riviera
17988	SP	9144	Jardim Roselândia	Jd Roselândia
17989	SP	9144	Jardim Samel Park	Jd S Park
17992	SP	9144	Jardim Samello IV	Jd Samello IV
17993	SP	9144	Jardim Samello V	Jd Samello V
17995	SP	9144	Jardim Samello Woods	Jd S Woods
17996	SP	9144	Jardim Santa Bárbara	Jd Sta Bárbara
17997	SP	9144	Jardim Santa Efigênia	Jd Sta Efigênia
17999	SP	9144	Jardim Santana	Jd Santana
18000	SP	9144	Jardim São Francisco	Jd S Francisco
18001	SP	9144	Jardim São Gabriel	Jd S Gabriel
18002	SP	9144	Jardim São Luiz	Jd S Luiz
18003	SP	9144	Jardim São Luiz II	Jd S Luiz II
18005	SP	9144	Jardim São Vicente de Paula	Jd S V Paula
18006	SP	9144	Jardim Seminário	Jd Seminário
18007	SP	9144	Jardim Três Colinas	Jd T Colinas
18008	SP	9144	Jardim Tropical	Jd Tropical
18009	SP	9144	Jardim Tropical II	Jd Tropical II
18010	SP	9144	Jardim Veneza	Jd Veneza
18011	SP	9144	Jardim Zelinda	Jd Zelinda
18013	SP	9144	Miramontes	\N
18014	SP	9144	Morada do Sol	M Sol
18015	SP	9144	Morada do Verde	M Verde
18017	SP	9144	Núcleo Agrícola Alpha	Nuc A Alpha
18019	SP	9144	Parque Continental	Prq Continental
18022	SP	9144	Parque das Árvores	Prq Árvores
18023	SP	9144	Parque das Esmeraldas	Prq Esmeraldas
18024	SP	9144	Parque do Castelo	Prq Castelo
18025	SP	9144	Parque do Horto	Prq Horto
18026	SP	9144	Parque Dom Pedro I	Prq D Pedro I
18028	SP	9144	Parque dos Lima	Prq Lima
18029	SP	9144	Parque dos Pinhais	Prq Pinhais
18030	SP	9144	Parque Doutor Carrão	Prq Dr Carrão
18032	SP	9144	Parque Florestal	Prq Florestal
18033	SP	9144	Parque Francal	Prq Francal
18034	SP	9144	Parque Moema	Prq Moema
18035	SP	9144	Parque Mundo Novo	Prq M Novo
18037	SP	9144	Parque Progresso	Prq Progresso
18039	SP	9144	Parque Residencial Nova Franca	Prq Res N Franca
18040	SP	9144	Parque Residencial Santa Maria	Prq Res Sta Maria
18041	SP	9144	Parque Santa Adélia	Prq Sta Adélia
18042	SP	9144	Parque Santa Hilda	Prq Sta Hilda
18043	SP	9144	Parque São Jorge	Prq S Jorge
18046	SP	9144	Parque Universitário	Prq Universitário
18047	SP	9144	Parque Vicente Leporace I	Prq V Leporace I
18054	SP	9144	Prolongamento Jardim Aeroporto I	Prl Jd Aeroporto I
18141	SP	9144	Vila Regina	Vl Regina
18142	SP	9144	Vila Rezende	Vl Rezende
18144	SP	9144	Vila Santa Cruz	Vl Sta Cruz
18145	SP	9144	Vila Santa Helena	Vl Sta Helena
18146	SP	9144	Vila Santa Luzia	Vl Sta Luzia
18147	SP	9144	Vila Santa Maria do Carmo	Vl Sta M Carmo
18148	SP	9144	Vila Santa Rita	Vl Sta Rita
18150	SP	9144	Vila Santa Terezinha	Vl Sta Terezinha
18151	SP	9144	Vila Santo Antônio	Vl Sto Antônio
18152	SP	9144	Vila Santos Dumont	Vl Stos Dumont
18153	SP	9144	Vila São Sebastião	Vl S Sebastião
18154	SP	9144	Vila Scarabucci	Vl Scarabucci
18156	SP	9144	Vila Totoli	Vl Totoli
18157	SP	9144	Village de São Vicente	V S Vicente
18159	SP	9145	Belém Capela	B Capela
18160	SP	9145	Belém Estação	B Estação
18161	SP	9145	Chácaras e Ranchos Córrego das Favas	C E R Crg Favas
18162	SP	9145	Chácaras R S Aleixo	C R S Aleixo
18163	SP	9145	Centro	\N
18164	SP	9145	Chácara Alto de Belém	Ch At Belém
18165	SP	9145	Chácara Camponesa	Ch Camponesa
18166	SP	9145	Chácara da Campininha	Ch Campininha
18167	SP	9145	Chácara das Cascatas	Ch Cascatas
18168	SP	9145	Chácara das Rosas	Ch Rosas
18169	SP	9145	Chácara de Recreio Santa Catarina	Ch Rcr Sta Catarina
18170	SP	9145	Chácara Jacob Kutner	Ch J Kutner
18171	SP	9145	Chácara Martha	Ch Martha
18172	SP	9145	Chácara Moreira	Ch Moreira
18173	SP	9145	Chácara Santo Antônio	Ch Sto Antônio
18174	SP	9145	Chácara Santo Onofre	Ch Sto Onofre
18175	SP	9145	Chácara Vista Alegre	Ch V Alegre
18176	SP	9145	Estância Belém	Etn Belém
18177	SP	9145	Jardim	\N
18178	SP	9145	Jardim Alegria	Jd Alegria
18179	SP	9145	Jardim Alexandra	Jd Alexandra
18180	SP	9145	Jardim Alpino	Jd Alpino
18181	SP	9145	Jardim Anita	Jd Anita
18182	SP	9145	Jardim Antomar	Jd Antomar
18183	SP	9145	Jardim Arpoador	Jd Arpoador
18184	SP	9145	Jardim Asturias	Jd Asturias
18185	SP	9145	Jardim Bandeirantes	Jd Bandeirantes
18186	SP	9145	Jardim Bom Sucesso	Jd B Sucesso
18187	SP	9145	Jardim Buenos Aires	Jd B Aires
18188	SP	9145	Jardim Cachoeira	Jd Cachoeira
18189	SP	9145	Jardim Constância	Jd Constância
18190	SP	9145	Jardim Eglen	Jd Eglen
18191	SP	9145	Jardim Eliza	Jd Eliza
18192	SP	9145	Jardim Esperança	Jd Esperança
18193	SP	9145	Jardim Ferrão	Jd Ferrão
18242	SP	9145	Residencial Casa Grande II	Res C Grande II
18243	SP	9145	Residencial Ferrão	Res Ferrão
18244	SP	9145	Residencial Parque	Res Parque
18245	SP	9145	Residencial São Luis	Res S Luis
18247	SP	9145	Vila Borges	Vl Borges
18248	SP	9145	Vila Capua	Vl Capua
18249	SP	9145	Vila Guilherme	Vl Guilherme
18250	SP	9145	Vila Heloísa	Vl Heloísa
18251	SP	9145	Vila João Marques	Vl J Marques
18252	SP	9145	Vila Luiza	Vl Luiza
18253	SP	9145	Vila Maria Luiza	Vl M Luiza
18254	SP	9145	Vila Natal	Vl Natal
18255	SP	9145	Vila Nunes	Vl Nunes
18256	SP	9145	Vila Primavera	Vl Primavera
18257	SP	9145	Vila Rossi	Vl Rossi
18258	SP	9145	Vila Santo Antônio	Vl Sto Antônio
18259	SP	9145	Vila Sileia	Vl Sileia
18260	SP	9145	Vila Sonia	Vl Sonia
18261	SP	9145	Vila Suiça	Vl Suiça
18262	SP	9146	Centro	\N
18263	SP	9146	Chácara das Colinas	Ch Colinas
18265	SP	9146	Chácaras São José	C S José
18266	SP	9146	Chácara São Luiz	Ch S Luiz
18267	SP	9146	Chácaras Bom Tempo	C B Tempo
18268	SP	9146	Recanto da Lapa	Rec Lapa
18269	SP	9146	Chácaras Maristela	C Maristela
18270	SP	9146	Chácaras Rutina Strauss	C R Strauss
18271	SP	9146	Companhia Fazenda Belém	C Faz Belém
18272	SP	9146	Cristal Parque	C Parque
18274	SP	9146	Estância Lago Azul	Etn Lg Azul
18275	SP	9146	Glebas	\N
18276	SP	9146	Jardim Alice	Jd Alice
18277	SP	9146	Jardim Alpino	Jd Alpino
18278	SP	9146	Jardim Benintendi	Jd Benintendi
18279	SP	9146	Jardim Cedro do Líbano	Jd C Líbano
18280	SP	9146	Jardim Cruzeiro	Jd Cruzeiro
18281	SP	9146	Jardim das Colinas	Jd Colinas
18282	SP	9146	Jardim das Jabuticabeiras	Jd Jabuticabeiras
18283	SP	9146	Jardim dos Bandeirantes	Jd Bandeirantes
18284	SP	9146	Jardim dos Eucaliptos	Jd Eucaliptos
18285	SP	9146	Jardim dos Lagos	Jd Lagos
18286	SP	9146	Jardim dos Reis	Jd Reis
18287	SP	9146	Jardim Luciana	Jd Luciana
18288	SP	9146	Jardim Luiza	Jd Luiza
18289	SP	9146	Jardim Primavera	Jd Primavera
18290	SP	9146	Jardim Progresso	Jd Progresso
18293	SP	9146	Jardim Santa Filomena	Jd Sta Filomena
18294	SP	9146	Jardim Sinki	Jd Sinki
18295	SP	9146	Jardim União	Jd União
18296	SP	9146	Jorge Verpa	J Verpa
18298	SP	9146	Parque Industrial	Prq Industrial
18299	SP	9146	Parque Lanel	Prq Lanel
18379	SP	9177	Jardim Coelho Neto	Jd C Neto
18380	SP	9177	Jardim do Vale	Jd Vale
18384	SP	9177	Jardim Esplanada	Jd Esplanada
18395	SP	9177	Jardim Rony	Jd Rony
18401	SP	9177	Nova Guará	N Guará
18405	SP	9177	Parque do Sol	Prq Sol
18410	SP	9177	Parque São Francisco	Prq S Francisco
18413	SP	9177	Pedregulho	\N
18415	SP	9177	Pingo de Ouro	P Ouro
18416	SP	9177	Portal das Colinas	P Colinas
18425	SP	9177	Rocinha	\N
18426	SP	9177	Santa Luzia	Sta Luzia
18428	SP	9177	São Benedito	S Benedito
18430	SP	9177	São Dimas	S Dimas
18431	SP	9177	Vila São José	Vl S José
18433	SP	9177	Jardim Tamandaré	Jd Tamandaré
18440	SP	9177	Vila Comendador Rodrigues Alves	Vl Cdor R Alves
18452	SP	9177	Vila Rosa	Vl Rosa
18454	SP	9177	Vila Santa Rita	Vl Sta Rita
18457	SP	9182	Acapulco	\N
18458	SP	9182	Balneário Cidade Atlântica	Bal C Atlântica
18459	SP	9182	Balneário Guarujá	Bal Guarujá
18460	SP	9182	Balneário Mar Casado	Bal M Casado
18461	SP	9182	Balneario Praia do Perequê	B Pr Perequê
18462	SP	9182	Balneário Praia do Pernambuco	Bal Pr Pernambuco
18463	SP	9182	Barra Funda	B Funda
18464	SP	9182	Cachoeira	\N
18465	SP	9182	Centro	\N
18469	SP	9182	Jardim Alvorada (Vicente de Carvalho)	Jd Alvorada (V Carvalho)
18470	SP	9182	Jardim Ana Maria	Jd A Maria
18471	SP	9182	Jardim Astúrias	Jd Astúrias
18472	SP	9182	Jardim Belmar	Jd Belmar
18473	SP	9182	Jardim Boa Esperança (Vicente de Carvalho)	Jd B Esperança (V Carvalho)
18474	SP	9182	Jardim Centenário	Jd Centenário
18475	SP	9182	Jardim Conceiçãozinha (Vicente de Carvalho)	Jd Conceiçãozinha (V Carvalho)
18476	SP	9182	Jardim Cunhambebe (Vicente de Carvalho)	Jd Cunhambebe (V Carvalho)
18477	SP	9182	Jardim das Conchas	Jd Conchas
18478	SP	9182	Jardim dos Pássaros	Jd Pássaros
18479	SP	9182	Jardim Enguaguassu (Vicente de Carvalho)	Jd Enguaguassu (V Carvalho)
18480	SP	9182	Jardim Enseada	Jd Enseada
18481	SP	9182	Jardim Esplanada do Castelo (Vicente de Carvalho)	Jd Esp Castelo (V Carvalho)
18482	SP	9182	Jardim Guaiuba	Jd Guaiuba
18483	SP	9182	Jardim Helena Maria	Jd H Maria
18484	SP	9182	Jardim Ideal	Jd Ideal
18485	SP	9182	Jardim Las Palmas	Jd L Palmas
18486	SP	9182	Jardim Mar e Céu	Jd M E Céu
18530	SP	9182	Vila Zilda	Vl Zilda
18531	SP	9183	Bonsucesso	\N
18532	SP	9183	Camargos	\N
18533	SP	9183	Campos de Gopouva	C Gopouva
18534	SP	9183	Centro	\N
18535	SP	9183	Cerâmica São Caetano	C S Caetano
18536	SP	9183	Chácara Cabuçu	Ch Cabuçu
18537	SP	9183	Chácara do Vovô	Ch Vovô
18538	SP	9183	Chácara Dora	Ch Dora
18539	SP	9183	Chácara São Judas Tadeu	Ch S J Tadeu
18540	SP	9183	Chácara São Luis	Ch S Luis
18541	SP	9183	Cidade Aracilia	C Aracilia
18542	SP	9183	Cidade Brasil	C Brasil
18543	SP	9183	Cidade Industrial Satélite de São Paulo	C Ind S S Paulo
18544	SP	9183	Cidade Jardim Cumbica	C Jd Cumbica
18545	SP	9183	Cidade Maia	C Maia
18546	SP	9183	Cidade Martins	C Martins
18547	SP	9183	Cidade Nova Bonsucesso	C N Bonsucesso
18548	SP	9183	Cidade Parque Alvorada	C Prq Alvorada
18549	SP	9183	Cidade Parque Brasília	C Prq Brasília
18550	SP	9183	Cidade Parque São Luiz	C Prq S Luiz
18551	SP	9183	Cidade Seródio	C Seródio
18552	SP	9183	Cidade Soberana	C Soberana
18553	SP	9183	Cidade SOIMCO	C SOIMCO
18554	SP	9183	Cidade Tupinambá	C Tupinambá
18555	SP	9183	Cocaia	\N
18556	SP	9183	Conjunto Inocoop-Bonsucesso	Cj Inocoop-Bonsucesso
18557	SP	9183	Conjunto Residencial Haroldo Veloso	Cj Res H Veloso
18558	SP	9183	Conjunto Residencial Paes de Barros	Cj Res P Barros
18559	SP	9183	Conjunto Residencial Refal	Cj Res Refal
18560	SP	9183	Cumbica	\N
18561	SP	9183	Fazenda Cocaia	Faz Cocaia
18562	SP	9183	Gopoúva	\N
18564	SP	9183	Granja Kida	Gja Kida
18565	SP	9183	Granja Nakashina	Gja Nakashina
18566	SP	9183	Granja Yoshida	Gja Yoshida
18567	SP	9183	Itapegica	\N
18568	SP	9183	Jardim Adriana	Jd Adriana
18569	SP	9183	Jardim Aida	Jd Aida
18570	SP	9183	Jardim Álamo	Jd Álamo
18571	SP	9183	Jardim Albertina	Jd Albertina
18572	SP	9183	Jardim Aliança	Jd Aliança
18573	SP	9183	Jardim Alice	Jd Alice
18574	SP	9183	Jardim Almeida Prado	Jd A Prado
18575	SP	9183	Jardim Alvorada	Jd Alvorada
18576	SP	9183	Jardim América	Jd América
18577	SP	9183	Jardim Ana Maria	Jd A Maria
18578	SP	9183	Jardim Angélica	Jd Angélica
18579	SP	9183	Jardim Anny	Jd Anny
18580	SP	9183	Jardim Ansalca	Jd Ansalca
18581	SP	9183	Jardim Arapongas	Jd Arapongas
18582	SP	9183	Jardim Artidoro	Jd Artidoro
18635	SP	9183	Jardim Gopoúva	Jd Gopoúva
18636	SP	9183	Jardim Gracinda	Jd Gracinda
18637	SP	9183	Jardim Guarulhos	Jd Guarulhos
18638	SP	9183	Jardim Guilhermino	Jd Guilhermino
18639	SP	9183	Jardim Guimarães	Jd Guimarães
18640	SP	9183	Jardim Gumercindo	Jd Gumercindo
18641	SP	9183	Jardim Gurupa	Jd Gurupa
18642	SP	9183	Jardim Imperador	Jd Imperador
18643	SP	9183	Jardim Ipanema	Jd Ipanema
18644	SP	9183	Jardim Iporanga	Jd Iporanga
18645	SP	9183	Jardim Iracema	Jd Iracema
18646	SP	9183	Jardim Irene	Jd Irene
18647	SP	9183	Jardim Izildinha	Jd Izildinha
18648	SP	9183	Jardim Jacy	Jd Jacy
18649	SP	9183	Jardim Jade	Jd Jade
18650	SP	9183	Jardim Joemi	Jd Joemi
18651	SP	9183	Jardim Jovaia	Jd Jovaia
18652	SP	9183	Jardim Kawamoto	Jd Kawamoto
18653	SP	9183	Jardim Kida	Jd Kida
18654	SP	9183	Jardim Las Vegas	Jd L Vegas
18655	SP	9183	Jardim Leblon	Jd Leblon
18656	SP	9183	Jardim Leda	Jd Leda
18657	SP	9183	Jardim Leila	Jd Leila
18658	SP	9183	Jardim Lenize	Jd Lenize
18659	SP	9183	Jardim Luciara	Jd Luciara
18660	SP	9183	Jardim Madeirense	Jd Madeirense
18661	SP	9183	Jardim Maia	Jd Maia
18662	SP	9183	Jardim Maria Aparecida	Jd M Aparecida
18663	SP	9183	Jardim Maria de Lourdes	Jd M Lourdes
18664	SP	9183	Jardim Maria Dirce	Jd M Dirce
18665	SP	9183	Jardim Maria Helena	Jd M Helena
18666	SP	9183	Jardim Maria Joana	Jd M Joana
18667	SP	9183	Jardim Marilena	Jd Marilena
18668	SP	9183	Jardim Miriam	Jd Miriam
18669	SP	9183	Jardim Mônaco	Jd Mônaco
18670	SP	9183	Jardim Monte Alegre	Jd Mte Alegre
18671	SP	9183	Jardim Monte Carmelo	Jd Mte Carmelo
18672	SP	9183	Jardim Monte Santo	Jd Mte Santo
18673	SP	9183	Jardim Moreira	Jd Moreira
18674	SP	9183	Jardim Munhoz	Jd Munhoz
18675	SP	9183	Jardim Nazaret	Jd Nazaret
18676	SP	9183	Jardim Normandia	Jd Normandia
18677	SP	9183	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
18679	SP	9183	Jardim Nova Guarulhos	Jd N Guarulhos
18680	SP	9183	Jardim Nova Ipanema	Jd N Ipanema
18681	SP	9183	Jardim Nova Taboão	Jd N Taboão
18682	SP	9183	Jardim Novo Iporanga	Jd N Iporanga
18683	SP	9183	Jardim Novo Portugal	Jd N Portugal
18684	SP	9183	Jardim Oliveira	Jd Oliveira
18685	SP	9183	Jardim Ottawa	Jd Ottawa
18686	SP	9183	Jardim Palmira	Jd Palmira
18734	SP	9183	Jardim Silvestre	Jd Silvestre
18735	SP	9183	Jardim Sueli	Jd Sueli
18736	SP	9183	Jardim Silvia	Jd Silvia
18737	SP	9183	Jardim Tabatinga	Jd Tabatinga
18738	SP	9183	Jardim Taboão	Jd Taboão
18739	SP	9183	Jardim Tamassia	Jd Tamassia
18740	SP	9183	Jardim Terezópolis	Jd Terezópolis
18741	SP	9183	Jardim Testae	Jd Testae
18742	SP	9183	Jardim Tijuco	Jd Tijuco
18743	SP	9183	Jardim Toscana	Jd Toscana
18744	SP	9183	Jardim Tranqüilidade	Jd Tranqüilidade
18745	SP	9183	Jardim Uirapuru	Jd Uirapuru
18746	SP	9183	Jardim Valéria	Jd Valéria
18747	SP	9183	Jardim Vanira	Jd Vanira
18748	SP	9183	Jardim Vera	Jd Vera
18749	SP	9183	Jardim Vila Galvão	Jd Vl Galvão
18750	SP	9183	Jardim Vila Rica	Jd Vl Rica
18751	SP	9183	Jardim Zaira	Jd Zaira
18752	SP	9183	Jardim Zimbardi	Jd Zimbardi
18753	SP	9183	Jardim Bondança	Jd Bondança
18754	SP	9183	Macedo	\N
18755	SP	9183	Porto da Igreja	Pto Igreja
18756	SP	9183	Parque Continental	Prq Continental
18757	SP	9183	Parque das Nações	Prq Nações
18758	SP	9183	Parque Gonçalves Junior	Prq G Junior
18759	SP	9183	Parque Industrial Cumbica	Prq Ind Cumbica
18760	SP	9183	Parque Jandaia	Prq Jandaia
18761	SP	9183	Parque Jurema	Prq Jurema
18762	SP	9183	Parque Marabá	Prq Marabá
18763	SP	9183	Parque Maria Helena	Prq M Helena
18764	SP	9183	Parque Mikail	Prq Mikail
18765	SP	9183	Parque Renato Maia	Prq R Maia
18766	SP	9183	Parque Santo Antônio	Prq Sto Antônio
18767	SP	9183	Parque Santos Dumont	Prq Stos Dumont
18769	SP	9183	Parque São Miguel	Prq S Miguel
18770	SP	9183	Parque Uirapuru	Prq Uirapuru
18771	SP	9183	Picanço	\N
18772	SP	9183	Jardim Ponte Alta I	Jd Pte Alta I
18773	SP	9183	Ponte Grande	Pte Grande
18774	SP	9183	Porto	\N
18775	SP	9183	Recanto Bom Jesus	Rec B Jesus
18776	SP	9183	Recanto do Sol	Rec Sol
18777	SP	9183	Recreio São Jorge	Rcr S Jorge
18778	SP	9183	Residencial Parque Cumbica	Res Prq Cumbica
18779	SP	9183	Sanatório do Padre Bento	S Pe Bento
18780	SP	9183	São Roque	S Roque
18781	SP	9183	Sede	\N
18782	SP	9183	Taboão	\N
18783	SP	9183	Vila dos Telles	Vl Telles
18784	SP	9183	Várzea do Palácio	V Palácio
18785	SP	9183	Vila Adelaide Perella	Vl A Perella
18786	SP	9183	Vila Adelita	Vl Adelita
18787	SP	9183	Vila Aeroporto	Vl Aeroporto
18845	SP	9183	Vila Leonor	Vl Leonor
18846	SP	9183	Vila Lidio Santana	Vl L Santana
18847	SP	9183	Vila Marajó	Vl Marajó
18848	SP	9183	Vila Maranduba	Vl Maranduba
18849	SP	9183	Vila Maria Luiza	Vl M Luiza
18850	SP	9183	Vila Maria Tereza	Vl M Tereza
18851	SP	9183	Vila Maricy	Vl Maricy
18852	SP	9183	Vila Marilda	Vl Marilda
18853	SP	9183	Vila Melliani	Vl Melliani
18854	SP	9183	Vila Mesquita	Vl Mesquita
18855	SP	9183	Vila Militar de Cumbica	Vl M Cumbica
18856	SP	9183	Vila Milton	Vl Milton
18857	SP	9183	Vila Miriam	Vl Miriam
18858	SP	9183	Vila Miss Velta	Vl M Velta
18859	SP	9183	Vila Monteiro Lobato	Vl M Lobato
18860	SP	9183	Vila Moreira	Vl Moreira
18861	SP	9183	Vila Nisia	Vl Nisia
18862	SP	9183	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
18863	SP	9183	Vila Nova Bonsucesso	Vl N Bonsucesso
18864	SP	9183	Vila Nova Cumbica	Vl N Cumbica
18865	SP	9183	Vila Otilia	Vl Otilia
18866	SP	9183	Vila Paraíso	Vl Paraíso
18867	SP	9183	Vila Pascoal	Vl Pascoal
18868	SP	9183	Vila Paulista	Vl Paulista
18869	SP	9183	Vila Pedro Moreira	Vl P Moreira
18870	SP	9183	Vila Pires	Vl Pires
18871	SP	9183	Vila Planalto	Vl Planalto
18872	SP	9183	Vila Progresso	Vl Progresso
18873	SP	9183	Vila Queiroz	Vl Queiroz
18874	SP	9183	Vila Rachid	Vl Rachid
18875	SP	9183	Vila Renata	Vl Renata
18876	SP	9183	Vila Rio de Janeiro	Vl R Janeiro
18877	SP	9183	Vila Ristori	Vl Ristori
18878	SP	9183	Vila Rosa Minelia	Vl R Minelia
18879	SP	9183	Vila Rosália	Vl Rosália
18880	SP	9183	Vila Rute	Vl Rute
18881	SP	9183	Vila Sabatino	Vl Sabatino
18882	SP	9183	Vila Sadokim	Vl Sadokim
18883	SP	9183	Esplanada das Bandeiras	Esp Bandeiras
18884	SP	9183	Vila Sant Anna	Vl S Anna
18885	SP	9183	Vila Santa Maria	Vl Sta Maria
18886	SP	9183	Vila Santo Antônio	Vl Sto Antônio
18887	SP	9183	Vila São Caetano	Vl S Caetano
18888	SP	9183	Vila São Carlos	Vl S Carlos
18889	SP	9183	Vila São Gabriel	Vl S Gabriel
18890	SP	9183	Vila São João	Vl S João
18891	SP	9183	Vila São João Batista	Vl S J Batista
18892	SP	9183	Vila São Jorge	Vl S Jorge
18893	SP	9183	Vila São José	Vl S José
18894	SP	9183	Vila São Judas Tadeu	Vl S J Tadeu
18895	SP	9183	Vila São Luis	Vl S Luis
18896	SP	9183	Vila São Paulo	Vl S Paulo
18300	SP	9146	Parque Monte Verde	Prq Mte Verde
18301	SP	9146	Parque Montreal	Prq Montreal
18302	SP	9146	Parque Munhos	Prq Munhos
18303	SP	9146	Parque Paulista	Prq Paulista
18304	SP	9146	Parque Santa Delfa	Prq Sta Delfa
18305	SP	9146	Parque Vitória	Prq Vitória
18306	SP	9146	Pouso Alegre	P Alegre
18307	SP	9146	Sitio Borda da Mata	S B Mata
18308	SP	9146	Sitio Marilene	S Marilene
18309	SP	9146	Vila Alves	Vl Alves
18310	SP	9146	Vila Amália	Vl Amália
18311	SP	9146	Vila Artur Sestini	Vl A Sestini
18312	SP	9146	Vila Barbosa	Vl Barbosa
18313	SP	9146	Vila Bazu	Vl Bazu
18314	SP	9146	Vila Bela	Vl Bela
18315	SP	9146	Vila Cariri	Vl Cariri
18316	SP	9146	Vila Carmela de Túlio	Vl C Túlio
18317	SP	9146	Vila Eliza	Vl Eliza
18318	SP	9146	Vila Francisco de Tulio	Vl F Tulio
18319	SP	9146	Vila Guarani	Vl Guarani
18320	SP	9146	Vila Humbelina	Vl Humbelina
18321	SP	9146	Vila Ida	Vl Ida
18322	SP	9146	Vila Irma	Vl Irma
18323	SP	9146	Vila José Palma	Vl J Palma
18324	SP	9146	Vila Josefina	Vl Josefina
18325	SP	9146	Vila Lanfranchi	Vl Lanfranchi
18326	SP	9146	Vila Lemar	Vl Lemar
18328	SP	9146	Vila Linharte	Vl Linharte
18329	SP	9146	Vila Luciana	Vl Luciana
18330	SP	9146	Vila Machado	Vl Machado
18331	SP	9146	Vila Maggi	Vl Maggi
18332	SP	9146	Vila Margarida	Vl Margarida
18333	SP	9146	Vila Martinho	Vl Martinho
18334	SP	9146	Vila Nita	Vl Nita
18336	SP	9146	Vila Olinda	Vl Olinda
18337	SP	9146	Vila Ramos	Vl Ramos
18338	SP	9146	Vila Rodrigues	Vl Rodrigues
18339	SP	9146	Vila Rosa	Vl Rosa
18340	SP	9146	Vila Rosalina	Vl Rosalina
18341	SP	9146	Vila Rosemeire	Vl Rosemeire
18342	SP	9146	Vila Santa Rosa	Vl Sta Rosa
18343	SP	9146	Vila Santista	Vl Santista
18344	SP	9146	Vila São Benedito	Vl S Benedito
18345	SP	9146	Vila Sonia	Vl Sonia
18346	SP	9146	Vila Vera Cruz	Vl V Cruz
18347	SP	9146	Vila Zanela	Vl Zanela
18353	SP	9177	Belvedere Club dos 500	Belv C dos 500
18355	SP	9177	Bom Jardim I	B Jardim I
18358	SP	9177	Bosque dos Ipês	Bsq Ipês
18360	SP	9177	Campo do Galvão	Cpo Galvão
18362	SP	9177	Centro	\N
18371	SP	9177	Engenheiro Neiva	Eng Neiva
18372	SP	9177	Escola Especialista da Aeronáutica	E E Aeronáutica
18373	SP	9177	Figueira	\N
18376	SP	9177	Jardim Aeroporto	Jd Aeroporto
18487	SP	9182	Jardim Maravilha (Vicente de Carvalho)	Jd Maravilha (V Carvalho)
18488	SP	9182	Jardim Monteiro da Cruz (Vicente de Carvalho)	Jd M Cruz (V Carvalho)
18489	SP	9182	Jardim Nancy	Jd Nancy
18490	SP	9182	Jardim Praiano	Jd Praiano
18491	SP	9182	Jardim Primavera	Jd Primavera
18492	SP	9182	Jardim Progresso (Vicente de Carvalho)	Jd Progresso (V Carvalho)
18493	SP	9182	Jardim Santa Genoveva	Jd Sta Genoveva
18494	SP	9182	Jardim Santa Isabel	Jd Sta Isabel
18495	SP	9182	Jardim Santa Maria	Jd Sta Maria
18496	SP	9182	Jardim Santana (Vicente de Carvalho)	Jd Santana (V Carvalho)
18497	SP	9182	Jardim Santense (Vicente de Carvalho)	Jd Santense (V Carvalho)
18498	SP	9182	Jardim Santo Amaro	Jd Sto Amaro
18499	SP	9182	Jardim São José	Jd S José
18500	SP	9182	Jardim São Manoel	Jd S Manoel
18501	SP	9182	Jardim São Miguel	Jd S Miguel
18502	SP	9182	Jardim Tejereba	Jd Tejereba
18503	SP	9182	Jardim Três Marias	Jd T Marias
18504	SP	9182	Jardim Virgínia	Jd Virgínia
18505	SP	9182	Jardim Vitória	Jd Vitória
18506	SP	9182	Loteamento João Batista Julião	Lot J B Julião
18507	SP	9182	Loteamento Silex	Lot Silex
18508	SP	9182	Morrinhos	\N
18509	SP	9182	Morro do Maluf	Mro Maluf
18510	SP	9182	Parque Enseada	Prq Enseada
18511	SP	9182	Parque Estuário (Vicente de Carvalho)	Prq Estuário (V Carvalho)
18512	SP	9182	Santa Cruz dos Navegantes	Sta C Navegantes
18513	SP	9182	Sitio Conceiçãozinha (Vicente de Carvalho)	S Conceiçãozinha (V Carvalho)
18514	SP	9182	Sítio Paecara (Vicente de Carvalho)	Sit Paecara (V Carvalho)
18515	SP	9182	Tombo	\N
18516	SP	9182	Vila Alice (Vicente de Carvalho)	Vl Alice (V Carvalho)
18517	SP	9182	Vila Alzira	Vl Alzira
18518	SP	9182	Vila Áurea (Vicente de Carvalho)	Vl Áurea (V Carvalho)
18519	SP	9182	Vila Carla	Vl Carla
18520	SP	9182	Vila Carvalho	Vl Carvalho
18521	SP	9182	Vila Júlia	Vl Júlia
18522	SP	9182	Vila Ligya	Vl Ligya
18523	SP	9182	Vila Luis Antônio	Vl L Antônio
18524	SP	9182	Vila Maia	Vl Maia
18525	SP	9182	Vila Outeiro	Vl Outeiro
18526	SP	9182	Vila Rosalina	Vl Rosalina
18527	SP	9182	Vila Santa Clara	Vl Sta Clara
18528	SP	9182	Vila Santa Rosa	Vl Sta Rosa
18529	SP	9182	Vila Santo Antônio	Vl Sto Antônio
18583	SP	9183	Jardim Arujá	Jd Arujá
18584	SP	9183	Jardim Bananal	Jd Bananal
18585	SP	9183	Jardim Bandeirantes	Jd Bandeirantes
18586	SP	9183	Jardim Barbosa	Jd Barbosa
18587	SP	9183	Jardim Baruch	Jd Baruch
18588	SP	9183	Jardim Bebedouro	Jd Bebedouro
18589	SP	9183	Jardim Bela Vista	Jd B Vista
18590	SP	9183	Jardim Belvedere	Jd Belvedere
18591	SP	9183	Jardim Betel	Jd Betel
18592	SP	9183	Jardim Bom Clima	Jd B Clima
18593	SP	9183	Jardim Bonsucesso	Jd Bonsucesso
18594	SP	9183	Jardim Brasil	Jd Brasil
18595	SP	9183	Jardim Campestre	Jd Campestre
18596	SP	9183	Jardim Capri	Jd Capri
18597	SP	9183	Jardim Carioca	Jd Carioca
18598	SP	9183	Jardim Carvalho	Jd Carvalho
18599	SP	9183	Jardim Célia	Jd Célia
18600	SP	9183	Jardim Centenário	Jd Centenário
18601	SP	9183	Jardim Cidade São Luis	Jd C S Luis
18602	SP	9183	Jardim Cocaia	Jd Cocaia
18604	SP	9183	Jardim Cristina	Jd Cristina
18605	SP	9183	Jardim Cumbica	Jd Cumbica
18606	SP	9183	Jardim da Mamãe	Jd Mamãe
18607	SP	9183	Jardim das Acácias	Jd Acácias
18608	SP	9183	Jardim das Andorinhas	Jd Andorinhas
18609	SP	9183	Jardim das Hortências	Jd Hortências
18610	SP	9183	Jardim das Nações	Jd Nações
18611	SP	9183	Jardim dos Pimentas	Jd Pimentas
18612	SP	9183	Jardim Diogo	Jd Diogo
18613	SP	9183	Jardim Divinolândia	Jd Divinolândia
18614	SP	9183	Jardim do Papai	Jd Papai
18615	SP	9183	Jardim do Triunfo	Jd Triunfo
18616	SP	9183	Jardim Dona Luiza	Jd Da Luiza
18617	SP	9183	Jardim Dona Meri	Jd Da Meri
18618	SP	9183	Jardim Doraly	Jd Doraly
18619	SP	9183	Jardim dos Afonsos	Jd Afonsos
18620	SP	9183	Jardim Dourado	Jd Dourado
18621	SP	9183	Jardim Eliana	Jd Eliana
18622	SP	9183	Jardim Elizabeth	Jd Elizabeth
18623	SP	9183	Jardim Ema	Jd Ema
18624	SP	9183	Jardim Eugênia	Jd Eugênia
18625	SP	9183	Jardim Eusonia	Jd Eusonia
18626	SP	9183	Jardim Fátima	Jd Fátima
18627	SP	9183	Jardim Ferrão	Jd Ferrão
18628	SP	9183	Jardim Figueira	Jd Figueira
18629	SP	9183	Jardim Flor da Montanha	Jd F Montanha
18630	SP	9183	Jardim Flor do Campo	Jd F Campo
18631	SP	9183	Jardim Fortaleza	Jd Fortaleza
18632	SP	9183	Jardim Frizzo	Jd Frizzo
18633	SP	9183	Jardim Gabriela	Jd Gabriela
18634	SP	9183	Jardim Gonçalves	Jd Gonçalves
18687	SP	9183	Jardim Paraíso	Jd Paraíso
18688	SP	9183	Jardim Paraventi	Jd Paraventi
18689	SP	9183	Jardim Paulista	Jd Paulista
18690	SP	9183	Jardim Pereira	Jd Pereira
18691	SP	9183	Jardim Pinhal	Jd Pinhal
18692	SP	9183	Jardim Pinheiros	Jd Pinheiros
18693	SP	9183	Jardim Presidente Dutra	Jd Pres Dutra
18694	SP	9183	Jardim IV Centenário	Jd IV Centenário
18695	SP	9183	Jardim Regina	Jd Regina
18696	SP	9183	Jardim Renee	Jd Renee
18697	SP	9183	Jardim Rizzo	Jd Rizzo
18698	SP	9183	Jardim Rodrigues	Jd Rodrigues
18699	SP	9183	Jardim Rosa de Franca	Jd R Franca
18700	SP	9183	Jardim Rosana	Jd Rosana
18701	SP	9183	Jardim Rossi	Jd Rossi
18702	SP	9183	Jardim Santa Bárbara	Jd Sta Bárbara
18703	SP	9183	Jardim Santa Beatriz	Jd Sta Beatriz
18704	SP	9183	Jardim Santa Cecília	Jd Sta Cecília
18705	SP	9183	Jardim Santa Clara	Jd Sta Clara
18706	SP	9183	Jardim Santa Emilia	Jd Sta Emilia
18707	SP	9183	Jardim Santa Francisca	Jd Sta Francisca
18708	SP	9183	Jardim Santa Gema	Jd Sta Gema
18709	SP	9183	Jardim Santa Helena	Jd Sta Helena
18710	SP	9183	Jardim Santa Inês	Jd Sta Inês
18711	SP	9183	Jardim Santa Maria	Jd Sta Maria
18712	SP	9183	Jardim Santa Mena	Jd Sta Mena
18713	SP	9183	Jardim Santa Rita	Jd Sta Rita
18714	SP	9183	Jardim Santa Terezinha	Jd Sta Terezinha
18715	SP	9183	Jardim Santa Vicência	Jd Sta Vicência
18716	SP	9183	Jardim Santo Afonso	Jd Sto Afonso
18717	SP	9183	Jardim Santo Eduardo	Jd Sto Eduardo
18718	SP	9183	Jardim Santo Expedito	Jd Sto Expedito
18719	SP	9183	Jardim São Domingos	Jd S Domingos
18720	SP	9183	Jardim São Francisco	Jd S Francisco
18721	SP	9183	Jardim São Gabriel	Jd S Gabriel
18722	SP	9183	Jardim São Geraldo	Jd S Geraldo
18723	SP	9183	Jardim São João	Jd S João
18724	SP	9183	Jardim São Jorge	Jd S Jorge
18725	SP	9183	Jardim São José	Jd S José
18726	SP	9183	Jardim São Judas Tadeu	Jd S J Tadeu
18727	SP	9183	Jardim São Luis	Jd S Luis
18728	SP	9183	Jardim São Manoel	Jd S Manoel
18729	SP	9183	Jardim São Paulo	Jd S Paulo
18730	SP	9183	Jardim São Ricardo	Jd S Ricardo
18731	SP	9183	Jardim São Roberto	Jd S Roberto
18732	SP	9183	Jardim São Vicente	Jd S Vicente
18733	SP	9183	Jardim Scyntila	Jd Scyntila
18788	SP	9183	Vila Aliança	Vl Aliança
18789	SP	9183	Vila Almeida	Vl Almeida
18790	SP	9183	Vila Alzira	Vl Alzira
18791	SP	9183	Vila Anny	Vl Anny
18792	SP	9183	Vila Antonieta	Vl Antonieta
18793	SP	9183	Vila Aprazível	Vl Aprazível
18794	SP	9183	Vila Augusta	Vl Augusta
18795	SP	9183	Vila Bananal	Vl Bananal
18796	SP	9183	Vila Bancária	Vl Bancária
18797	SP	9183	Vila Barbosa	Vl Barbosa
18798	SP	9183	Vila Barros	Vl Barros
18799	SP	9183	Vila Bernardino	Vl Bernardino
18800	SP	9183	Vila Bom Lar	Vl B Lar
18801	SP	9183	Vila Bremen	Vl Bremen
18802	SP	9183	Vila Calegari	Vl Calegari
18803	SP	9183	Vila Camargos	Vl Camargos
18804	SP	9183	Vila Capitão Rabelo	Vl Cap Rabelo
18805	SP	9183	Vila Carioca	Vl Carioca
18806	SP	9183	Vila Carmela I	Vl Carmela I
18807	SP	9183	Vila Carmela II	Vl Carmela II
18808	SP	9183	Vila Cavadas	Vl Cavadas
18809	SP	9183	Vila Clotilde	Vl Clotilde
18810	SP	9183	Vila Conceição	Vl Conceição
18811	SP	9183	Vila da Fábrica	Vl Fábrica
18812	SP	9183	Vila das Bandeiras	Vl Bandeiras
18813	SP	9183	Vila das Castanhas	Vl Castanhas
18814	SP	9183	Vila das Palmeiras	Vl Palmeiras
18816	SP	9183	Vila Dona Antonia	Vl Da Antonia
18817	SP	9183	Vila Edgar	Vl Edgar
18818	SP	9183	Vila Endres	Vl Endres
18819	SP	9183	Vila Esplanada	Vl Esplanada
18820	SP	9183	Vila Ester	Vl Ester
18821	SP	9183	Vila Fanganielo	Vl Fanganielo
18822	SP	9183	Vila Fátima	Vl Fátima
18823	SP	9183	Vila Fiuza	Vl Fiuza
18824	SP	9183	Vila Flora	Vl Flora
18825	SP	9183	Vila Flórida	Vl Flórida
18826	SP	9183	Vila Francisco Mineiro	Vl F Mineiro
18827	SP	9183	Vila Galvão	Vl Galvão
18828	SP	9183	Vila Garcia	Vl Garcia
18829	SP	9183	Vila Girassol	Vl Girassol
18830	SP	9183	Vila Gopoúva	Vl Gopoúva
18831	SP	9183	Vila Harmonia	Vl Harmonia
18832	SP	9183	Vila Hermínia	Vl Hermínia
18833	SP	9183	Vila Hulda	Vl Hulda
18834	SP	9183	Vila Imaculada	Vl Imaculada
18835	SP	9183	Vila Iris	Vl Iris
18836	SP	9183	Vila Itai	Vl Itai
18837	SP	9183	Vila Itapegica	Vl Itapegica
18838	SP	9183	Vila Itapoan	Vl Itapoan
18839	SP	9183	Vila Izabel	Vl Izabel
18840	SP	9183	Vila Izinha	Vl Izinha
18841	SP	9183	Vila Kida	Vl Kida
18842	SP	9183	Vila Lanzara	Vl Lanzara
18843	SP	9183	Vila Laurita	Vl Laurita
18844	SP	9183	Vila Leda	Vl Leda
18897	SP	9183	Vila São Pedro	Vl S Pedro
18898	SP	9183	Vila São Rafael	Vl S Rafael
18899	SP	9183	Vila São Ricardo	Vl S Ricardo
18900	SP	9183	Vila Silveira	Vl Silveira
18901	SP	9183	Vila Sirena	Vl Sirena
18902	SP	9183	Vila Sítio dos Morros	Vl Sit Morros
18903	SP	9183	Vila SOIMCO	Vl SOIMCO
18904	SP	9183	Vila Sorocabana	Vl Sorocabana
18905	SP	9183	Vila Souza	Vl Souza
18906	SP	9183	Vila Tibagi	Vl Tibagi
18907	SP	9183	Vila Tijuco	Vl Tijuco
18908	SP	9183	Vila Trabalhista	Vl Trabalhista
18909	SP	9183	Vila Venditti	Vl Venditti
18910	SP	9183	Vila Vicentina	Vl Vicentina
18911	SP	9183	Vila Yaya	Vl Yaya
18912	SP	9183	Vila Zaira	Vl Zaira
18913	SP	9183	Vila Zamataro	Vl Zamataro
18914	SP	9183	Vila Zanardi	Vl Zanardi
18916	SP	9189	Chácaras Acaraí	C Acaraí
18917	SP	9189	Chácaras Assay	C Assay
18918	SP	9189	Chácara Planalto	Ch Planalto
18919	SP	9189	Chácara Recreio Alvorada	Ch Rcr Alvorada
18920	SP	9189	Chácara Reymar	Ch Reymar
18921	SP	9189	Chácaras Fazenda Coelho	C Faz Coelho
18922	SP	9189	Chácaras Havaí	C Havaí
18923	SP	9189	Chácaras Luzitana	C Luzitana
18924	SP	9189	Chácaras de Recreio - 2000	C Recreio - 2000
18925	SP	9189	Condomínio Chácara Grota Azul	Cond Ch G Azul
18926	SP	9189	Jardim Adelaide	Jd Adelaide
18927	SP	9189	Jardim Amanda I	Jd Amanda I
18928	SP	9189	Jardim Amanda II	Jd Amanda II
18929	SP	9189	Jardim Boa Vista	Jd B Vista
18930	SP	9189	Jardim Campos Verdes	Jd C Verdes
18931	SP	9189	Jardim Carmen Cristina	Jd C Cristina
18932	SP	9189	Jardim das Colinas	Jd Colinas
18933	SP	9189	Jardim das Laranjeiras	Jd Laranjeiras
18934	SP	9189	Jardim das Paineiras	Jd Paineiras
18935	SP	9189	Jardim do Bosque	Jd Bosque
18936	SP	9189	Jardim do Brás	Jd Brás
18937	SP	9189	Jardim do Lago	Jd Lago
18938	SP	9189	Jardim Stella	Jd Stella
18939	SP	9189	Jardim Everest	Jd Everest
18940	SP	9189	Jardim Girassol	Jd Girassol
18941	SP	9189	Parque Residencial João Luiz	Prq Res J Luiz
18942	SP	9189	Jardim Lírio	Jd Lírio
18943	SP	9189	Jardim Malta	Jd Malta
18944	SP	9189	Parque Residencial Maria de Lourdes	Prq Res M Lourdes
18945	SP	9189	Jardim Minda	Jd Minda
18946	SP	9189	Jardim Mirante de Sumaré	Jd M Sumaré
19023	SP	9216	Jardim Adriana	Jd Adriana
18947	SP	9189	Jardim Nossa Senhora Auxiliadora	Jd N Sra Auxiliadora
18948	SP	9189	Jardim Nossa Senhora da Penha	Jd N Sra Penha
18949	SP	9189	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
18950	SP	9189	Jardim Nova Boa Vista	Jd N B Vista
18951	SP	9189	Jardim Nova Hortolândia I	Jd N Hortolândia I
18952	SP	9189	Jardim Novo Ângulo	Jd N Ângulo
18953	SP	9189	Jardim Novo Horizonte	Jd N Horizonte
18954	SP	9189	Parque Orestes Ôngaro	Prq O Ôngaro
18955	SP	9189	Jardim Ricardo	Jd Ricardo
18956	SP	9189	Jardim Rosolém	Jd Rosolém
18957	SP	9189	Jardim Santa Amélia	Jd Sta Amélia
18958	SP	9189	Jardim Santa Cândida	Jd Sta Cândida
18959	SP	9189	Jardim Santa Clara do Lago I	Jd Sta C Lago I
18960	SP	9189	Jardim Santa Clara do Lago II	Jd Sta C Lago II
18961	SP	9189	Jardim Santa Emília	Jd Sta Emília
18962	SP	9189	Jardim Santa Esmeralda	Jd Sta Esmeralda
18963	SP	9189	Jardim Santa Fé	Jd Sta Fé
18964	SP	9189	Jardim Santa Izabel	Jd Sta Izabel
18965	SP	9189	Jardim Santa Luzia	Jd Sta Luzia
18966	SP	9189	Jardim Santa Rita de Cássia	Jd Sta R Cássia
18967	SP	9189	Jardim Santana	Jd Santana
18968	SP	9189	Jardim Santo André	Jd Sto André
18969	SP	9189	Jardim Santo Antônio	Jd Sto Antônio
18970	SP	9189	Jardim São Bento	Jd S Bento
18971	SP	9189	Jardim São Camilo	Jd S Camilo
18972	SP	9189	Jardim São Jorge	Jd S Jorge
18973	SP	9189	Parque São Miguel	Prq S Miguel
18974	SP	9189	Jardim São Pedro	Jd S Pedro
18975	SP	9189	Jardim São Sebastião	Jd S Sebastião
18976	SP	9189	Jardim Sumarezinho	Jd Sumarezinho
18977	SP	9189	Jardim Viagem	Jd Viagem
18978	SP	9189	Loteamento Adventista Campineiro	Lot A Campineiro
18979	SP	9189	Parque do Horto	Prq Horto
18980	SP	9189	Parque dos Pinheiros	Prq Pinheiros
18981	SP	9189	Parque Ortolândia	Prq Ortolândia
18982	SP	9189	Parque Odimar	Prq Odimar
18983	SP	9189	Loteamento Remanso Campineiro	Lot R Campineiro
18984	SP	9189	Vila Inema	Vl Inema
18985	SP	9189	Vila Real	Vl Real
18986	SP	9189	Vila Real Santista	Vl R Santista
18987	SP	9189	Vila São Francisco	Vl S Francisco
18988	SP	9189	Vila São Pedro	Vl S Pedro
18989	SP	9216	Aldrovândia	\N
18990	SP	9216	Loteamento Aldrovândia Gleba 2	Lot A Gleba 2
18991	SP	9216	Alto da Colina	At Colina
19065	SP	9216	Jardim Primavera	Jd Primavera
19066	SP	9216	Jardim Rêmulo Zoppi	Jd R Zoppi
19067	SP	9216	Jardim Renata	Jd Renata
19070	SP	9216	Jardim Rossignatti	Jd Rossignatti
19073	SP	9216	Jardim Santiago	Jd Santiago
19075	SP	9216	Jardim São Carlos	Jd S Carlos
19076	SP	9216	Jardim São Conrado	Jd S Conrado
19078	SP	9216	Jardim São Francisco	Jd S Francisco
19082	SP	9216	Jardim São Paulo	Jd S Paulo
19084	SP	9216	Jardim Tancredo Neves	Jd T Neves
19086	SP	9216	Jardim Tropical	Jd Tropical
19087	SP	9216	Lagos de Shanadu	L Shanadu
19096	SP	9216	Morro Torto	Mro Torto
19097	SP	9216	Núcleo Habitacional Brigadeiro Faria Lima	Nuc Hab Brg F Lima
19099	SP	9216	Núcleo Residencial Professor Carlos Aldrovandi	Nuc Res Prf C Aldrovandi
19100	SP	9216	Parque Aristocrático Viracopos	Prq A Viracopos
19101	SP	9216	Parque Boa Esperança	Prq B Esperança
19102	SP	9216	Parque da Grama	Prq Grama
19103	SP	9216	Parque das Bandeiras	Prq Bandeiras
19105	SP	9216	Parque das Nações	Prq Nações
19106	SP	9216	Parque Nacional de Viracopos	Prq N Viracopos
19107	SP	9216	Parque Presidente	Prq Presidente
19108	SP	9216	Parque Residencial Indaiá	Prq Res Indaiá
19109	SP	9216	Parque São Lourenço	Prq S Lourenço
19110	SP	9216	Parque São Tomaz de Aquino	Prq S T Aquino
19113	SP	9216	Recreio Campestre Jóia	Rcr C Jóia
19118	SP	9216	Recanto Campestre Internacional de Viracopos Gleba 1	Rec C I V Gleba 1
19119	SP	9216	Recanto Campestre Viracopos Gleba 2	Rec C V Gleba 2
19120	SP	9216	Recanto Campestre Internacional de Viracopos Gleba 3	Rec C I V Gleba 3
19121	SP	9216	Recanto Campestre Internacional de Viracopos Gleba 4	Rec C I V Gleba 4
19122	SP	9216	Recanto Campestre Internacional de Viracopos Gleba 9	Rec C I V Gleba 9
19123	SP	9216	Recanto Campestre Internacional de Viracopos Gleba 5	Rec C I V Gleba 5
19124	SP	9216	Recanto Campestre Internacional de Viracopos Gleba 6	Rec C I V Gleba 6
19126	SP	9216	Recanto Campestre Internacional de Viracopos Gleba 8	Rec C I V Gleba 8
19127	SP	9216	Recanto Campestre Internacional de Viracopos Gleba 10	Rec C I V Gleba 10
19128	SP	9216	Jardim Santa Cruz	Jd Sta Cruz
19131	SP	9216	Sítios de Recreio Colina	S Rcr Colina
18992	SP	9216	Altos da Bela Vista	A B Vista
18997	SP	9216	Caldeira	\N
18998	SP	9216	Centro	\N
18999	SP	9216	Chácara Alvorada	Ch Alvorada
19000	SP	9216	Chácara Areal	Ch Areal
19001	SP	9216	Chácara Belvedere	Ch Belvedere
19002	SP	9216	Chácara do Trevo	Ch Trevo
19003	SP	9216	Chácara Polaris	Ch Polaris
19004	SP	9216	Chácaras de Recreio Ingá	C Rcr Ingá
19006	SP	9216	Chácara Viracopos	Ch Viracopos
19007	SP	9216	Cidade Nova I	C Nova I
19008	SP	9216	Cidade Nova II	C Nova II
19009	SP	9216	Colinas de Indaiatuba	C Indaiatuba
19011	SP	9216	Colinas do Mosteiro de Itaici	C M Itaici
19013	SP	9216	Distrito Industrial Domingos Giomi	Dt Ind D Giomi
19015	SP	9216	Distrito Industrial Nova Era	Dt Ind N Era
19019	SP	9216	Helvétia Country	H Country
19020	SP	9216	Helvétia Polo Country	H P Country
19021	SP	9216	Itaici	\N
19024	SP	9216	Jardim Alice	Jd Alice
19025	SP	9216	Jardim América	Jd América
19029	SP	9216	Jardim Brasil	Jd Brasil
19031	SP	9216	Jardim Califórnia	Jd Califórnia
19032	SP	9216	Jardim Cristina	Jd Cristina
19033	SP	9216	Jardim das Esmeraldas	Jd Esmeraldas
19034	SP	9216	Jardim do Sol	Jd Sol
19035	SP	9216	Jardim Dom Bosco	Jd D Bosco
19038	SP	9216	Jardim Doutor Carlos Augusto de Camargo Andrade	Jd Dr C A C Andrade
19040	SP	9216	Jardim Eldorado	Jd Eldorado
19041	SP	9216	Jardim Feres	Jd Feres
19042	SP	9216	Jardim Flórida	Jd Flórida
19043	SP	9216	Jardim Guanabara	Jd Guanabara
19044	SP	9216	Jardim Imperial	Jd Imperial
19045	SP	9216	Jardim Itamaracá	Jd Itamaracá
19047	SP	9216	Jardim Juliana	Jd Juliana
19050	SP	9216	Jardim Maria Luiza	Jd M Luiza
19051	SP	9216	Jardim Marina	Jd Marina
19052	SP	9216	Jardim Moacyr Arruda	Jd M Arruda
19053	SP	9216	Jardim Morada do Sol	Jd M Sol
19054	SP	9216	Jardim Morumbi	Jd Morumbi
19055	SP	9216	Jardim Nely	Jd Nely
19056	SP	9216	Jardim Nova Indaiá	Jd N Indaiá
19057	SP	9216	Jardim Olinda	Jd Olinda
19058	SP	9216	Jardim Oliveira Camargo	Jd O Camargo
19059	SP	9216	Jardim Panorama	Jd Panorama
19060	SP	9216	Jardim Paraíso	Jd Paraíso
19062	SP	9216	Jardim Pau Preto	Jd P Preto
19063	SP	9216	Jardim Pedroso	Jd Pedroso
19064	SP	9216	Jardim Pompéia	Jd Pompéia
19132	SP	9216	Solar de Itamaracá	S Itamaracá
19133	SP	9216	Terras de Itaici	T Itaici
19135	SP	9216	Vale das Laranjeiras	Vle Laranjeiras
19136	SP	9216	Vale do Sol	Vle Sol
19137	SP	9216	Vila Almeida	Vl Almeida
19139	SP	9216	Vila Areal	Vl Areal
19140	SP	9216	Vila Aurora	Vl Aurora
19141	SP	9216	Vila Avaí	Vl Avaí
19144	SP	9216	Vila Brizzola	Vl Brizzola
19145	SP	9216	Vila Castelo Branco	Vl C Branco
19146	SP	9216	Vila Costa e Silva	Vl C E Silva
19148	SP	9216	Vila Furlan	Vl Furlan
19149	SP	9216	Vila Georgina	Vl Georgina
19151	SP	9216	Vila Granada	Vl Granada
19152	SP	9216	Vila Homero	Vl Homero
19153	SP	9216	Vila Lopes	Vl Lopes
19154	SP	9216	Vila Maria	Vl Maria
19155	SP	9216	Vila Maria Helena	Vl M Helena
19156	SP	9216	Vila Nossa Senhora Aparecida	Vl N Sra Aparecida
19157	SP	9216	Vila Nossa Senhora da Candelária	Vl N Sra Candelária
19159	SP	9216	Vila Pires da Cunha	Vl P Cunha
19160	SP	9216	Vila Rubens	Vl Rubens
19161	SP	9216	Vila Ruz Peres	Vl R Peres
19162	SP	9216	Vila São José	Vl S José
19163	SP	9216	Vila Sfeir	Vl Sfeir
19164	SP	9216	Vila Soriano	Vl Soriano
19165	SP	9216	Vila Suíça	Vl Suíça
19167	SP	9216	Vila Teller	Vl Teller
19168	SP	9216	Vila Todos os Santos	Vl T O Santos
19169	SP	9216	Vila Vitória I	Vl Vitória I
19170	SP	9216	Vila Vitória II	Vl Vitória II
19172	SP	9239	Centro	\N
19173	SP	9239	Chácara Alpes	Ch Alpes
19174	SP	9239	Chácara Cinco Enes	Ch C Enes
19175	SP	9239	Chácara da Lagoa	Ch Lagoa
19176	SP	9239	Chácara das Palmeiras	Ch Palmeiras
19177	SP	9239	Chácara Fischer	Ch Fischer
19178	SP	9239	Chácara Guarapiranga	Ch Guarapiranga
19179	SP	9239	Chácara Hitoshi	Ch Hitoshi
19180	SP	9239	Chácara Italago	Ch Italago
19181	SP	9239	Chácara Santa Maria	Ch Sta Maria
19182	SP	9239	Chácara São Jorge	Ch S Jorge
19183	SP	9239	Chácara Val de Palmas	Ch V Palmas
19184	SP	9239	Chácara Vista Alegre	Ch V Alegre
19185	SP	9239	Cidade Santa Júlia	C Sta Júlia
19186	SP	9239	Cidade São Pedro	C S Pedro
19187	SP	9239	Crispim	\N
19188	SP	9239	Embu Mirim	E Mirim
19189	SP	9239	Engenho	\N
19190	SP	9239	Itaquaciara	\N
19191	SP	9239	Jardim Analândia	Jd Analândia
19192	SP	9239	Jardim Angélica	Jd Angélica
19193	SP	9239	Jardim Balbina	Jd Balbina
19249	SP	9239	Recreio Primavera	Rcr Primavera
19250	SP	9239	Ressaca	\N
19251	SP	9239	Royal Park	R Park
19252	SP	9239	Valo Velho	V Velho
19253	SP	9239	Vila Geni	Vl Geni
19254	SP	9239	Vila João Montesano	Vl J Montesano
19255	SP	9239	Vila Santa Maria	Vl Sta Maria
19256	SP	9240	Central Parque 4-L	C Prq 4-L
19257	SP	9240	Centro	\N
19258	SP	9240	Chácaras Alvorada	C Alvorada
19260	SP	9240	Chapadinha	\N
19261	SP	9240	Conceição	\N
19262	SP	9240	Conjunto Habitacional Nisshinbo do Brasil	Cj H N Brasil
19263	SP	9240	Estância Conceição	Etn Conceição
19264	SP	9240	Jardim Alvorada	Jd Alvorada
19265	SP	9240	Jardim Bela Vista	Jd B Vista
19267	SP	9240	Jardim Brasil	Jd Brasil
19268	SP	9240	Jardim Casa Grande	Jd C Grande
19269	SP	9240	Jardim Colombo	Jd Colombo
19270	SP	9240	Jardim Cruzeiro do Sul	Jd C Sul
19271	SP	9240	Jardim das Flores	Jd Flores
19272	SP	9240	Jardim das Laranjeiras	Jd Laranjeiras
19274	SP	9240	Jardim das Rosas	Jd Rosas
19275	SP	9240	Jardim Florestal	Jd Florestal
19276	SP	9240	Jardim Fogaça	Jd Fogaça
19277	SP	9240	Jardim Itália	Jd Itália
19278	SP	9240	Jardim Leonel	Jd Leonel
19279	SP	9240	Jardim Marabá	Jd Marabá
19280	SP	9240	Jardim Maria Luiza	Jd M Luiza
19281	SP	9240	Jardim Maricota	Jd Maricota
19282	SP	9240	Jardim Mesquita	Jd Mesquita
19283	SP	9240	Jardim Monte Santo	Jd Mte Santo
19732	SP	9250	Pinheirinho	\N
19284	SP	9240	Jardim Moraes Rosa	Jd M Rosa
19285	SP	9240	Jardim Nova Era	Jd N Era
19286	SP	9240	Jardim Novo Aeroporto	Jd N Aeroporto
19287	SP	9240	Jardim Paulista	Jd Paulista
19288	SP	9240	Jardim Santa Inêz	Jd Sta Inêz
19289	SP	9240	Jardim Shangri-lá	Jd Shangri-lá
19290	SP	9240	Jardim Vieira de Moraes	Jd V Moraes
19291	SP	9240	Parque Atenas do Sul	Prq A Sul
19292	SP	9240	Parque da Lagoa	Prq Lagoa
19294	SP	9240	Portal da Figueira	P Figueira
19295	SP	9240	Retiro Santana	Rer Santana
19297	SP	9240	Tupy	\N
19298	SP	9240	Vale San Fernando	Vle S Fernando
19299	SP	9240	Vila Aliança	Vl Aliança
19300	SP	9240	Vila Alves	Vl Alves
19301	SP	9240	Vila Aparecida	Vl Aparecida
19303	SP	9240	Vila Arruda	Vl Arruda
19304	SP	9240	Vila Asem	Vl Asem
19305	SP	9240	Vila Aurora	Vl Aurora
19306	SP	9240	Vila Ayres	Vl Ayres
19307	SP	9240	Vila Barth	Vl Barth
19308	SP	9240	Monte Santo	Mte Santo
19371	SP	9240	Vila Visaltino Gomes	Vl V Gomes
19372	SP	9242	Central Park	C Park
19373	SP	9242	Centro	\N
19375	SP	9242	Conjunto Habitacional Paulo VI	Cj Hab Paulo VI
19376	SP	9242	Conjunto Habitacional São Camilo	Cj Hab S Camilo
19377	SP	9242	Conjunto Habitacional Tancredo Neves	Cj Hab T Neves
19378	SP	9242	Distrito Industrial	Dt Industrial
19379	SP	9242	Horto do Ipê	H Ipê
19380	SP	9242	Jardim Alvorada	Jd Alvorada
19381	SP	9242	Jardim América I	Jd América I
19382	SP	9242	Jardim América II	Jd América II
19383	SP	9242	Jardim Beija-Flor	Jd Beija-Flor
19384	SP	9242	Jardim Bela Vista	Jd B Vista
19385	SP	9242	Jardim Belvedere	Jd Belvedere
19386	SP	9242	Jardim Brasil	Jd Brasil
19387	SP	9242	Jardim Califórnia	Jd Califórnia
19388	SP	9242	Jardim Dona Miriam	Jd Da Miriam
19389	SP	9242	Jardim Doutor Pinheiro	Jd Dr Pinheiro
19390	SP	9242	Jardim Europa	Jd Europa
19391	SP	9242	Jardim Ferrari	Jd Ferrari
19392	SP	9242	Jardim Grajaú	Jd Grajaú
19393	SP	9242	Jardim Guanabara	Jd Guanabara
19395	SP	9242	Jardim Maringá	Jd Maringá
19396	SP	9242	Jardim Maringá III	Jd Maringá III
19397	SP	9242	Jardim Maringá IV	Jd Maringá IV
19398	SP	9242	Jardim Morada do Sol	Jd M Sol
19399	SP	9242	Jardim Nova Itapeva	Jd N Itapeva
19400	SP	9242	Jardim Paulista	Jd Paulista
19401	SP	9242	Jardim Pilar	Jd Pilar
19402	SP	9242	Jardim Pôr do Sol	Jd P Sol
19403	SP	9242	Jardim Santa Rosa	Jd Sta Rosa
19404	SP	9242	Jardim São Francisco	Jd S Francisco
19405	SP	9242	Jardim Virgínia	Jd Virgínia
19406	SP	9242	Loteamento Longa Vida	Lot L Vida
19407	SP	9242	Parque Cimentolândia	Prq Cimentolândia
19408	SP	9242	Parque Nova Esperança	Prq N Esperança
19409	SP	9242	Parque Paineiras	Prq Paineiras
19410	SP	9242	Parque Planalto	Prq Planalto
19411	SP	9242	Parque Residencial Itapeva	Prq Res Itapeva
19412	SP	9242	Parque São Jorge	Prq S Jorge
19413	SP	9242	Parque Vista Alegre	Prq V Alegre
19414	SP	9242	Recanto Pilão D'Agua	Rec P D'Agua
19416	SP	9242	Vila Aparecida	Vl Aparecida
19417	SP	9242	Vila Boava	Vl Boava
19418	SP	9242	Vila Bom Jesus	Vl B Jesus
19419	SP	9242	Vila Camargo	Vl Camargo
19420	SP	9242	Vila Dom Bosco	Vl D Bosco
19421	SP	9242	Vila Guarani	Vl Guarani
19422	SP	9242	Vila Isabel	Vl Isabel
19477	SP	9243	Jardim Gioia	Jd Gioia
19478	SP	9243	Jardim Hokkaido	Jd Hokkaido
19479	SP	9243	Jardim Itacolomi	Jd Itacolomi
19480	SP	9243	Jardim Itaguassu	Jd Itaguassu
19481	SP	9243	Jardim Itapevi	Jd Itapevi
19482	SP	9243	Jardim Itapoã	Jd Itapoã
19483	SP	9243	Jardim Julieta	Jd Julieta
19484	SP	9243	Jardim Jurema	Jd Jurema
19485	SP	9243	Jardim Maria Cecília	Jd M Cecília
19486	SP	9243	Jardim Maria Judite	Jd M Judite
19487	SP	9243	Jardim Marina	Jd Marina
19488	SP	9243	Jardim Maristela	Jd Maristela
19489	SP	9243	Jardim Mirador	Jd Mirador
19490	SP	9243	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
19491	SP	9243	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
19492	SP	9243	Jardim Nova Cotia	Jd N Cotia
19493	SP	9243	Nova Itapevi	N Itapevi
19494	SP	9243	Jardim Paulista	Jd Paulista
19495	SP	9243	Jardim Portão Vermelho	Jd P Vermelho
19496	SP	9243	Jardim Portela	Jd Portela
19497	SP	9243	Jardim Rosemary	Jd Rosemary
19498	SP	9243	Jardim Ruth	Jd Ruth
19499	SP	9243	Jardim Santa Rita	Jd Sta Rita
19500	SP	9243	Jardim Santa Rita - 2a Parte	Jd Sta Rita - 2 Parte
19501	SP	9243	Jardim Santo Américo	Jd Sto Américo
19502	SP	9243	Jardim Santo Antônio	Jd Sto Antônio
19503	SP	9243	Jardim São Benedito	Jd S Benedito
19504	SP	9243	Jardim São Carlos	Jd S Carlos
19505	SP	9243	Jardim São Lucas	Jd S Lucas
19506	SP	9243	Jardim São Luiz	Jd S Luiz
19507	SP	9243	Jardim São Marcos	Jd S Marcos
19508	SP	9243	Jardim São Paulo	Jd S Paulo
19509	SP	9243	Jardim Sorocabana	Jd Sorocabana
19510	SP	9243	Jardim V Grande	Jd V Grande
19511	SP	9243	Jardim Vitápolis	Jd Vitápolis
19512	SP	9243	Morada das Nuvens	M Nuvens
19513	SP	9243	Parque Boa Esperança	Prq B Esperança
19514	SP	9243	Parque Ciras	Prq Ciras
19515	SP	9243	Parque Itamarati	Prq Itamarati
19516	SP	9243	Parque Mira Flores	Prq M Flores
19517	SP	9243	Parque Santo Antônio	Prq Sto Antônio
19518	SP	9243	Parque Suburbano	Prq Suburbano
19519	SP	9243	Recanto Camargo Ribeiro	Rec C Ribeiro
19520	SP	9243	Recanto do Sossego	Rec Sossego
19521	SP	9243	Recanto Verde	Rec Verde
19522	SP	9243	Recanto Verde dos Lagos	Rec V Lagos
19523	SP	9243	Residencial Parque Itamarati	Res Prq Itamarati
19524	SP	9243	São João	S João
19576	SP	9244	Jardim Magali	Jd Magali
19577	SP	9244	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
19578	SP	9244	Jardim Paraíso	Jd Paraíso
19580	SP	9244	Jardim Soares	Jd Soares
19581	SP	9244	Jardim Tropical	Jd Tropical
19582	SP	9244	Jardim Yara	Jd Yara
19583	SP	9244	Loteamento Conjunto Habitacional Antônio Assad Alcici	Lot Cj Hab A A Alcici
19584	SP	9244	Loteamento Della Rocha	Lot D Rocha
19585	SP	9244	Loteamento Elizeu do Espírito Santo	Lot E E Santo
19586	SP	9244	Loteamento Habitacional Haldi	Lot Hab Haldi
19587	SP	9244	Loteamento João de Barros	Lot J Barros
19588	SP	9244	Loteamento Nações Unidas	Lot N Unidas
19589	SP	9244	Macumbé	\N
19590	SP	9244	Nova Itapira	N Itapira
19591	SP	9244	Parque Felicidade	Prq Felicidade
19592	SP	9244	Parque Fortaleza	Prq Fortaleza
19593	SP	9244	Parque São Francisco	Prq S Francisco
19594	SP	9244	Parque São Jorge	Prq S Jorge
19595	SP	9244	Parque São Lucas	Prq S Lucas
19596	SP	9244	Pires	\N
19597	SP	9244	Prados	\N
19598	SP	9244	Estâncias de Recreio Santa Fé	E Rcr Sta Fé
19599	SP	9244	Salgados	\N
19600	SP	9244	Santa Cruz	Sta Cruz
19601	SP	9244	Santa Fé	Sta Fé
19602	SP	9244	Santo Antônio	Sto Antônio
19603	SP	9244	São Benedito	S Benedito
19604	SP	9244	São Vicente	S Vicente
19605	SP	9244	Vila Bazani	Vl Bazani
19606	SP	9244	Vila Esperança	Vl Esperança
19607	SP	9244	Vila Ilze	Vl Ilze
19608	SP	9244	Vila Maria	Vl Maria
19609	SP	9244	Vila Penha do Rio do Peixe	Vl P R Peixe
19610	SP	9244	Vila Pereira	Vl Pereira
19611	SP	9244	Vila Santa Marta	Vl Sta Marta
19612	SP	9244	Vila Vieira	Vl Vieira
19613	SP	9244	Jardim Itamaracá	Jd Itamaracá
19615	SP	9250	Arujá Country Club	A C Club
19616	SP	9250	Campo da Venda	Cpo Venda
19617	SP	9250	Centro	\N
19618	SP	9250	Chácara Águas da Pedra	Ch A Pedra
19619	SP	9250	Chácara Coqueiro	Ch Coqueiro
19620	SP	9250	Chácara Cuiabá	Ch Cuiabá
19621	SP	9250	Chácara Dona Escolástica	Ch Da Escolástica
19622	SP	9250	Chácara Holiday	Ch Holiday
19623	SP	9250	Chácara Maracanã	Ch Maracanã
19624	SP	9250	Chácara Progresso	Ch Progresso
19625	SP	9250	Chácara São Joaquim	Ch S Joaquim
19626	SP	9250	Chácara São Miguel	Ch S Miguel
19627	SP	9250	Cidade Kemel	C Kemel
19628	SP	9250	Cidade Nova Louzada	C N Louzada
19629	SP	9250	Condomínio  Arujazinho III Parte	Cond A III Parte
19630	SP	9250	Condomínio Arujazinho IV Parte	Cond A IV Parte
19631	SP	9250	Condomínio Vilage	Cond Vilage
19632	SP	9250	Corredor	\N
19633	SP	9250	Cuiabá	\N
19634	SP	9250	Estação	\N
19635	SP	9250	Estância Fraternidade	Etn Fraternidade
19636	SP	9250	Estância Guatambu	Etn Guatambu
19637	SP	9250	Estância Paraíso	Etn Paraíso
19638	SP	9250	Industrial	\N
19639	SP	9250	Jaguari	\N
19640	SP	9250	Jardim Adriana	Jd Adriana
19641	SP	9250	Jardim Adriane	Jd Adriane
19642	SP	9250	Jardim do Algarve	Jd Algarve
19643	SP	9250	Jardim Alpes de Itaquá	Jd Alpes Itaquá
19644	SP	9250	Jardim Altos de Itaquá	Jd A Itaquá
19645	SP	9250	Jardim Amanda Caiubi	Jd A Caiubi
19646	SP	9250	Jardim Amaral	Jd Amaral
19647	SP	9250	Jardim América	Jd América
19648	SP	9250	Jardim Americano	Jd Americano
19649	SP	9250	Jardim Anita	Jd Anita
19650	SP	9250	Jardim Aracaré	Jd Aracaré
19651	SP	9250	Jardim Belém	Jd Belém
19652	SP	9250	Jardim Caiubi	Jd Caiubi
19653	SP	9250	Jardim Campo Limpo	Jd Cpo Limpo
19654	SP	9250	Jardim Carolina	Jd Carolina
19655	SP	9250	Jardim Coqueiro	Jd Coqueiro
19656	SP	9250	Jardim Cristiano	Jd Cristiano
19657	SP	9250	Jardim da Estação	Jd Estação
19658	SP	9250	Jardim da Fonte	Jd Fonte
19659	SP	9250	Jardim Deliy	Jd Deliy
19660	SP	9250	Jardim do Carmo	Jd Carmo
19661	SP	9250	Jardim do Vale	Jd Vale
19662	SP	9250	Jardim dos Ipês	Jd Ipês
19663	SP	9250	Jardim Europa	Jd Europa
19664	SP	9250	Jardim Félix e Milton	Jd F E Milton
19665	SP	9250	Jardim Fiorelo	Jd Fiorelo
19666	SP	9250	Jardim Gonçalves	Jd Gonçalves
19667	SP	9250	Jardim Guarani	Jd Guarani
19668	SP	9250	Jardim Ikes	Jd Ikes
19669	SP	9250	Jardim Ipê	Jd Ipê
19670	SP	9250	Jardim Itapuã	Jd Itapuã
19671	SP	9250	Jardim Itaquá	Jd Itaquá
19672	SP	9250	Jardim Japão	Jd Japão
19673	SP	9250	Jardim Joandra	Jd Joandra
19674	SP	9250	Jardim Josely	Jd Josely
19675	SP	9250	Jardim Karine	Jd Karine
19676	SP	9250	Jardim Luana	Jd Luana
19677	SP	9250	Jardim Luciana	Jd Luciana
19678	SP	9250	Jardim Lucinda	Jd Lucinda
19679	SP	9250	Jardim Maragojipe	Jd Maragojipe
19680	SP	9250	Jardim Marcelo	Jd Marcelo
19681	SP	9250	Jardim Margarida	Jd Margarida
19682	SP	9250	Jardim Maria Eliza	Jd M Eliza
19731	SP	9250	Perobal	\N
19733	SP	9250	Pium	\N
19734	SP	9250	Quinta da Boa Vista (Industrial)	Qta B Vista (Industrial)
19735	SP	9250	Quinta da Boa Vista (Residencial)	Qta B Vista (Residencial)
19737	SP	9250	Residencial Furtuna	Res Furtuna
19738	SP	9250	Residencial Novo Horizonte	Res N Horizonte
19739	SP	9250	Residencial Palmas de Itaquá	Res P Itaquá
19740	SP	9250	Residencial Pamela	Res Pamela
19741	SP	9250	Residencial Rancho Grande	Res R Grande
19742	SP	9250	Ribeiro	\N
19743	SP	9250	Rio Abaixo	R Abaixo
19744	SP	9250	Tipoia	\N
19745	SP	9250	Una	\N
19746	SP	9250	Veraneio Maracanã	V Maracanã
19747	SP	9250	Vila Arizona	Vl Arizona
19748	SP	9250	Vila Augusta	Vl Augusta
19749	SP	9250	Vila Bartira	Vl Bartira
19750	SP	9250	Vila Bruno	Vl Bruno
19751	SP	9250	Vila Celeste	Vl Celeste
19752	SP	9250	Vila Dolores	Vl Dolores
19753	SP	9250	Vila Ercília	Vl Ercília
19754	SP	9250	Vila Esperança	Vl Esperança
19755	SP	9250	Vila Ferlópolis	Vl Ferlópolis
19756	SP	9250	Vila Ferreira	Vl Ferreira
19757	SP	9250	Vila Florindo	Vl Florindo
19758	SP	9250	Vila Geni	Vl Geni
19759	SP	9250	Vila Gepina	Vl Gepina
19760	SP	9250	Vila Itaquá Mirim	Vl I Mirim
19761	SP	9250	Vila Itaquassu	Vl Itaquassu
19762	SP	9250	Vila Japão	Vl Japão
19763	SP	9250	Vila Londrina	Vl Londrina
19764	SP	9250	Vila Maria Augusta	Vl M Augusta
19765	SP	9250	Vila Menezes	Vl Menezes
19766	SP	9250	Vila Miranda	Vl Miranda
19767	SP	9250	Vila Monte Belo	Vl Mte Belo
19768	SP	9250	Vila Nely	Vl Nely
19769	SP	9250	Vila Passalacqua	Vl Passalacqua
19770	SP	9250	Vila Popular	Vl Popular
19771	SP	9250	Vila Rolândia	Vl Rolândia
19772	SP	9250	Vila Santa Bárbara	Vl Sta Bárbara
19773	SP	9250	Vila São Carlos	Vl S Carlos
19774	SP	9250	Vila São José	Vl S José
19775	SP	9250	Vila São Judas Tadeu	Vl S J Tadeu
19776	SP	9250	Vila São Roberto	Vl S Roberto
19777	SP	9250	Vila Sônia	Vl Sônia
19778	SP	9250	Vila Ursulina	Vl Ursulina
19779	SP	9250	Vila Vermont	Vl Vermont
19780	SP	9250	Vila Virgínia	Vl Virgínia
19781	SP	9250	Vila Zeferina	Vl Zeferina
19782	SP	9250	Vila Zesuína	Vl Zesuína
19783	SP	9254	Cachoeiras do Imaratá	C Imaratá
19784	SP	9254	Capela do Barreiro	C Barreiro
19785	SP	9254	Centro	\N
19194	SP	9239	Jardim Branca Flor	Jd B Flor
19195	SP	9239	Jardim Cinira	Jd Cinira
19196	SP	9239	Jardim Dara	Jd Dara
19197	SP	9239	Jardim das Esmeraldas	Jd Esmeraldas
19198	SP	9239	Jardim das Oliveiras	Jd Oliveiras
19199	SP	9239	Jardim das Palmeiras	\N
19200	SP	9239	Jardim Diniz	Jd Diniz
19201	SP	9239	Jardim do Carmo	Jd Carmo
19202	SP	9239	Jardim do Édem	Jd Édem
19203	SP	9239	Jardim Elisa	Jd Elisa
19204	SP	9239	Jardim Esther	Jd Esther
19206	SP	9239	Jardim Europa	Jd Europa
19207	SP	9239	Jardim Idemori	Jd Idemori
19208	SP	9239	Jardim Imperatriz	Jd Imperatriz
19209	SP	9239	Jardim Itapecerica	Jd Itapecerica
19210	SP	9239	Jardim Jacira	Jd Jacira
19211	SP	9239	Jardim Maria Cristina	Jd M Cristina
19212	SP	9239	Jardim Marilu	Jd Marilu
19213	SP	9239	Jardim Marmarita	Jd Marmarita
19214	SP	9239	Jardim Mirante	Jd Mirante
19215	SP	9239	Jardim Montesano	Jd Montesano
19216	SP	9239	Jardim Nisalves	Jd Nisalves
19217	SP	9239	Jardim Paraíso	Jd Paraíso
19218	SP	9239	Jardim Pelucio	Jd Pelucio
19219	SP	9239	Jardim Petrópolis	Jd Petrópolis
19220	SP	9239	Jardim Renata	Jd Renata
19221	SP	9239	Jardim Sampaio	Jd Sampaio
19222	SP	9239	Jardim Santa Isabel	Jd Sta Isabel
19223	SP	9239	Jardim Santa Júlia	Jd Sta Júlia
19224	SP	9239	Jardim São Jorge	Jd S Jorge
19225	SP	9239	Jardim São Marcos	Jd S Marcos
19226	SP	9239	Jardim São Pedro	Jd S Pedro
19227	SP	9239	Jardim Sônia Maria	Jd S Maria
19228	SP	9239	Jardim Valo Velho	Jd V Velho
19229	SP	9239	Jardim Virgínia	Jd Virgínia
19230	SP	9239	Jardim Tereza Maria	Jd T Maria
19231	SP	9239	da Lagoa	Lagoa
19232	SP	9239	Lagoa da Prata	Lga Prata
19233	SP	9239	Mombaça	\N
19234	SP	9239	Olaria	\N
19235	SP	9239	Palmeiras	\N
19236	SP	9239	Parque Delfim Verde	Prq D Verde
19237	SP	9239	Parque Jandaia	Prq Jandaia
19238	SP	9239	Parque Paraíso	Prq Paraíso
19239	SP	9239	Parque Santa Amélia	Prq Sta Amélia
19241	SP	9239	Parque São Francisco	Prq S Francisco
19242	SP	9239	Parque São Lourenço	Prq S Lourenço
19243	SP	9239	Parque Yara Cecy	Prq Y Cecy
19244	SP	9239	Potuverá	\N
19245	SP	9239	Recanto da Floresta	Rec Floresta
19246	SP	9239	Recanto da Serra	Rec Serra
19247	SP	9239	Recanto dos Colibris	Rec Colibris
19248	SP	9239	Recreio Campestre	Rcr Campestre
19309	SP	9240	Vila Camarão	Vl Camarão
19310	SP	9240	Vila Carolina	Vl Carolina
19311	SP	9240	Vila Carvalho	Vl Carvalho
19312	SP	9240	Vila Célia	Vl Célia
19313	SP	9240	Vila Cubatão	Vl Cubatão
19314	SP	9240	Vila Deyse	Vl Deyse
19315	SP	9240	Vila dos Bandeirantes	Vl Bandeirantes
19316	SP	9240	Vila Eldorado	Vl Eldorado
19317	SP	9240	Vila Esplanada	Vl Esplanada
19318	SP	9240	Vila Francisca	Vl Francisca
19319	SP	9240	Vila Garrido	Vl Garrido
19320	SP	9240	Vila Ginez	Vl Ginez
19321	SP	9240	Vila Godói	Vl Godói
19322	SP	9240	Vila Grace	Vl Grace
19324	SP	9240	Vila Hungria	Vl Hungria
19325	SP	9240	Vila Itapetininga	Vl Itapetininga
19326	SP	9240	Vila Judite	Vl Judite
19327	SP	9240	Vila Kalil Halak	Vl K Halak
19330	SP	9240	Vila Leonor	Vl Leonor
19331	SP	9240	Vila Luiz Antônio	Vl L Antônio
19332	SP	9240	Vila Macia	Vl Macia
19333	SP	9240	Vila Maciel	Vl Maciel
19334	SP	9240	Vila Maria	Vl Maria
19336	SP	9240	Vila Mazarino	Vl Mazarino
19337	SP	9240	Vila Mazzei	Vl Mazzei
19338	SP	9240	Vila Monteiro	Vl Monteiro
19339	SP	9240	Vila Nastri	Vl Nastri
19340	SP	9240	Vila Nova	Vl Nova
19341	SP	9240	Vila Nova Itapetininga	Vl N Itapetininga
19342	SP	9240	Vila Novo Horizonte	Vl N Horizonte
19343	SP	9240	Vila Olho D'Agua	Vl O D'Agua
19344	SP	9240	Vila Oliveira	Vl Oliveira
19345	SP	9240	Vila Orestes	Vl Orestes
19347	SP	9240	Vila Piedade	Vl Piedade
19348	SP	9240	Vila Popular	Vl Popular
19349	SP	9240	Vila Prado	Vl Prado
19350	SP	9240	Vila Prestes	Vl Prestes
19351	SP	9240	Vila Progresso	Vl Progresso
19352	SP	9240	Vila Recreio	Vl Recreio
19353	SP	9240	Vila Regina	Vl Regina
19354	SP	9240	Vila Reis	Vl Reis
19355	SP	9240	Vila Rica	Vl Rica
19356	SP	9240	Vila Rio Branco	Vl R Branco
19357	SP	9240	Vila Rocha	Vl Rocha
19358	SP	9240	Vila Rosa	Vl Rosa
19359	SP	9240	Vila Rubens	Vl Rubens
19360	SP	9240	Vila Salém	Vl Salém
19361	SP	9240	Vila Santa Isabel	Vl Sta Isabel
19362	SP	9240	Vila Santana	Vl Santana
19363	SP	9240	Vila São Gonçalo	Vl S Gonçalo
19365	SP	9240	Vila São José	Vl S José
19366	SP	9240	Vila São Pedro	Vl S Pedro
19367	SP	9240	Vila Serafim	Vl Serafim
19368	SP	9240	Vila Sonia	Vl Sonia
19369	SP	9240	Vila Sottemo	Vl Sottemo
19370	SP	9240	Vila Vendramini	Vl Vendramini
19423	SP	9242	Vila Maringá	Vl Maringá
19424	SP	9242	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
19425	SP	9242	Vila Nova	Vl Nova
19426	SP	9242	Vila Ophélia	Vl Ophélia
19427	SP	9242	Vila Ribas	Vl Ribas
19428	SP	9242	Vila Santa Maria	Vl Sta Maria
19429	SP	9242	Vila Santana	Vl Santana
19430	SP	9242	Vila São Benedito	Vl S Benedito
19431	SP	9242	Vila São Francisco de Assis	Vl S F Assis
19432	SP	9242	Vila São José	Vl S José
19433	SP	9242	Vila São Miguel	Vl S Miguel
19434	SP	9242	Vila Sonia	Vl Sonia
19435	SP	9242	Vila Taquari	Vl Taquari
19437	SP	9242	Vista Alegre II	V Alegre II
19438	SP	9243	Amador Bueno	A Bueno
19439	SP	9243	J	 J
19440	SP	9243	Caminho do Sol	Cam Sol
19441	SP	9243	Centro	\N
19442	SP	9243	Chácara Santa Cecília	Ch Sta Cecília
19443	SP	9243	Chácara Silene	Ch Silene
19444	SP	9243	Chácara Vitápolis	Ch Vitápolis
19445	SP	9243	Chácaras Goiapa	C Goiapa
19446	SP	9243	Chácaras Lagoinha	C Lagoinha
19447	SP	9243	Chácaras Monte Serrat	C Mte Serrat
19448	SP	9243	Chácaras Nossa Senhora Aparecida	C N Sra Aparecida
19449	SP	9243	Chácaras Primavera	C Primavera
19450	SP	9243	Chácaras Santa Marina	C Sta Marina
19451	SP	9243	Chácaras Selva	C Selva
19452	SP	9243	Cidade da Saúde	C Saúde
19453	SP	9243	Cidade do Sol	C Sol
19454	SP	9243	Conjunto Habitacional - Setor A	Cj Habitacional - Setor A
19455	SP	9243	Conjunto Habitacional - Setor B	Cj Habitacional - Setor B
19456	SP	9243	Conjunto Habitacional - Setor D	Cj Habitacional - Setor D
19457	SP	9243	Condomínio Nova São Paulo	Cond N S Paulo
19458	SP	9243	Condomínio Refúgio dos Pinheiros	Cond R Pinheiros
19459	SP	9243	dos Abreus	Abreus
19460	SP	9243	Estância São Francisco	Etn S Francisco
19461	SP	9243	Estrela Dalva	E Dalva
19462	SP	9243	Granja Leda	Gja Leda
19463	SP	9243	Ingahi	\N
19464	SP	9243	Itaparica	\N
19465	SP	9243	Itapevi	\N
19466	SP	9243	Itaqui	\N
19467	SP	9243	Jacucai	\N
19468	SP	9243	Jardim Alabama	Jd Alabama
19469	SP	9243	Jardim Beatriz	Jd Beatriz
19470	SP	9243	Jardim Bela Vista	Jd B Vista
19471	SP	9243	Jardim Briquet	Jd Briquet
19473	SP	9243	Jardim Cruzeiro	Jd Cruzeiro
19474	SP	9243	Jardim da Rainha	Jd Rainha
19475	SP	9243	Jardim Dona Elvira	Jd Da Elvira
19476	SP	9243	Jardim Dorotéia	Jd Dorotéia
19525	SP	9243	Transurb	\N
19526	SP	9243	Vale do Sol	Vle Sol
19527	SP	9243	Vila Aparecida	Vl Aparecida
19528	SP	9243	Vila Áurea	Vl Áurea
19529	SP	9243	Vila Aurora	Vl Aurora
19530	SP	9243	Vila Belmira	Vl Belmira
19531	SP	9243	Vila das Chácaras	Vl Chácaras
19532	SP	9243	Vila das Flores	Vl Flores
19533	SP	9243	Vila Dolores	Vl Dolores
19534	SP	9243	Vila Dona Paulina	Vl Da Paulina
19535	SP	9243	Vila Doutor Cardoso	Vl Dr Cardoso
19536	SP	9243	Vila Garcia	Vl Garcia
19537	SP	9243	Vila Iracema	Vl Iracema
19538	SP	9243	Vila Licia	Vl Licia
19539	SP	9243	Vila Lucila	Vl Lucila
19540	SP	9243	Vila Maria Christina	Vl M Christina
19541	SP	9243	Vila Maria de Jesus	Vl M Jesus
19542	SP	9243	Vila Neofarm	Vl Neofarm
19543	SP	9243	Vila Nova Esperança	Vl N Esperança
19544	SP	9243	Vila Olímpia	Vl Olímpia
19545	SP	9243	Vila Olinda	Vl Olinda
19546	SP	9243	Vila Recanto Paulistano	Vl Rec Paulistano
19547	SP	9243	Vila Santa Clara	Vl Sta Clara
19548	SP	9243	Vila Santa Flora	Vl Sta Flora
19549	SP	9243	Vila Santa Rita	Vl Sta Rita
19550	SP	9243	Vila Santo Antônio da Boa Vista	Vl Sto A B Vista
19551	SP	9243	Vila São Francisco	Vl S Francisco
19552	SP	9243	Vila São Francisco (Glebas 1 A 3)	Vl S Francisco (G 1 A 3)
19553	SP	9243	Vila São João	Vl S João
19555	SP	9244	Boa Vista	B Vista
19556	SP	9244	Centro	\N
19557	SP	9244	Chácara Freitas	Ch Freitas
19558	SP	9244	Chácara Santa Fé	Ch Sta Fé
19560	SP	9244	Conjunto Habitacional Doutor Achiles Galdi	Cj Hab Dr A Galdi
19561	SP	9244	Conjunto Habitacional Doutor José Secchi	Cj Hab Dr J Secchi
19562	SP	9244	Conjunto Habitacional General Euclides Figueiredo	Cj Hab Gen E Figueiredo
19563	SP	9244	Conjunto Habitacional Juscelino Kubitschek de Oliveira	Cj Hab J K Oliveira
19564	SP	9244	Cubatão	\N
19565	SP	9244	Jardim Bela Vista	Jd B Vista
19566	SP	9244	Jardim Bonfim	Jd Bonfim
19567	SP	9244	Jardim Camboriú	Jd Camboriú
19568	SP	9244	Jardim Esplanada	Jd Esplanada
19569	SP	9244	Jardim Guarujá	Jd Guarujá
19570	SP	9244	Jardim Isaura	Jd Isaura
19571	SP	9244	Jardim Itapema	Jd Itapema
19572	SP	9244	Jardim Itapuã	Jd Itapuã
19573	SP	9244	Jardim Ivete	Jd Ivete
19574	SP	9244	Jardim Lindóia	Jd Lindóia
19575	SP	9244	Jardim Macucos	Jd Macucos
19683	SP	9250	Jardim Miray	Jd Miray
19684	SP	9250	Jardim Mônica	Jd Mônica
19685	SP	9250	Jardim Mossapyra	Jd Mossapyra
19686	SP	9250	Jardim Nápoli	Jd Nápoli
19687	SP	9250	Jardim Nápoli I	Jd Nápoli I
19688	SP	9250	Jardim Nascente	Jd Nascente
19689	SP	9250	Jardim Nicea	Jd Nicea
19690	SP	9250	Jardim Nossa Senhora D'Ajuda	Jd N Sra D'Ajuda
19691	SP	9250	Jardim Nova Itaquá	Jd N Itaquá
19692	SP	9250	Jardim Novo Horizonte	Jd N Horizonte
19693	SP	9250	Jardim Odete	Jd Odete
19694	SP	9250	Jardim Paineira	Jd Paineira
19695	SP	9250	Jardim Patrícia	Jd Patrícia
19696	SP	9250	Jardim Piata A	Jd Piata A
19697	SP	9250	Jardim Piata B	Jd Piata B
19698	SP	9250	Jardim Pinheirinho	Jd Pinheirinho
19699	SP	9250	Jardim Primavera	Jd Primavera
19700	SP	9250	Jardim Santa Helena	Jd Sta Helena
19701	SP	9250	Jardim Santa Luzia de Poa	Jd Sta L Poa
19702	SP	9250	Jardim Santo Antonio	Jd Sto Antonio
19703	SP	9250	Jardim São Armando	Jd S Armando
19704	SP	9250	Jardim São Jerônimo	Jd S Jerônimo
19705	SP	9250	Jardim São Manoel	Jd S Manoel
19706	SP	9250	Jardim São Paulo	Jd S Paulo
19707	SP	9250	Jardim Silvestre	Jd Silvestre
19708	SP	9250	Jardim Tropical	Jd Tropical
19709	SP	9250	Jardim Valparaíso	Jd Valparaíso
19710	SP	9250	Jardim Viana	Jd Viana
19711	SP	9250	Jardim Zélia	Jd Zélia
19712	SP	9250	Mandi	\N
19713	SP	9250	Merenda	\N
19714	SP	9250	Morro Branco	Mro Branco
19715	SP	9250	O Pequeno Coração	O P Coração
19716	SP	9250	Parque Dirce	Prq Dirce
19717	SP	9250	Parque Macedo	Prq Macedo
19718	SP	9250	Parque Nossa Senhora das Graças	Prq N Sra Graças
19719	SP	9250	Parque Novo Horizonte	Prq N Horizonte
19720	SP	9250	Parque Piratininga	Prq Piratininga
19721	SP	9250	Parque Piratininga II	Prq Piratininga II
19722	SP	9250	Parque Recanto Mônica	Prq Rec Mônica
19723	SP	9250	Parque Residencial Califórnia	Prq Res Califórnia
19724	SP	9250	Parque Residencial Marengo	Prq Res Marengo
19725	SP	9250	Parque Residencial Scaffid	Prq Res Scaffid
19726	SP	9250	Parque Residencial Scaffid II	Prq Res Scaffid II
19727	SP	9250	Parque Residencial Souza Campos	Prq Res S Campos
19728	SP	9250	Parque São Pedro	Prq S Pedro
19729	SP	9250	Parque Viviane	Prq Viviane
19730	SP	9250	Pedreira	\N
19786	SP	9254	Chácara San Martin I	Ch S Martin I
19787	SP	9254	Chácara San Martin II	Ch S Martin II
19788	SP	9254	Chácara Santa Cruz dos Pires	Ch Sta C Pires
19789	SP	9254	Cidade Jardim	C Jardim
19790	SP	9254	Cocais	\N
19791	SP	9254	Condomínio Residencial Beija-Flor	Cond Res Beija-Flor
19792	SP	9254	Encosta do Sol	E Sol
19793	SP	9254	Bairro do Engenho	B Engenho
19794	SP	9254	Condomínio Itaembu	Cond Itaembu
19795	SP	9254	Bairro Itapema	B Itapema
19796	SP	9254	Jardim Alto de Santa Cruz	Jd At Sta Cruz
19798	SP	9254	Jardim América	Jd América
19799	SP	9254	Jardim Ana Maria	Jd A Maria
19800	SP	9254	Jardim Arizona	Jd Arizona
19801	SP	9254	Jardim Belém	Jd Belém
19802	SP	9254	Jardim Carlos Borella	Jd C Borella
19803	SP	9254	Jardim Coronel Peroba	Jd Cel Peroba
19804	SP	9254	Jardim das Laranjeiras	Jd Laranjeiras
19805	SP	9254	Jardim das Nações	Jd Nações
19806	SP	9254	Jardim de Lucca	Jd Lucca
19807	SP	9254	Jardim Delforno	Jd Delforno
19809	SP	9254	Jardim do Leste	Jd Leste
19810	SP	9254	Jardim dos Lagos	Jd Lagos
19811	SP	9254	Jardim Esplanada	Jd Esplanada
19812	SP	9254	Jardim Ester	Jd Ester
19813	SP	9254	Jardim Galetto	Jd Galetto
19814	SP	9254	Jardim Harmonia	Jd Harmonia
19815	SP	9254	Jardim Ipê	Jd Ipê
19816	SP	9254	Jardim Leonor	Jd Leonor
19817	SP	9254	Jardim Lúcia	Jd Lúcia
19818	SP	9254	Jardim Maria	Jd Maria
19819	SP	9254	Jardim Mateus	Jd Mateus
19820	SP	9254	Jardim México	Jd México
19821	SP	9254	Jardim Monte Verde	Jd Mte Verde
19822	SP	9254	Jardim Morumbi	Jd Morumbi
19823	SP	9254	Jardim Nardin	Jd Nardin
19824	SP	9254	Jardim Nice	Jd Nice
19825	SP	9254	Jardim Nossa Senhora das Graças	Jd N Sra Graças
19826	SP	9254	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
19827	SP	9254	Jardim Nova América	Jd N América
19828	SP	9254	Jardim Novo Horizonte	Jd N Horizonte
19829	SP	9254	Jardim Palladino	Jd Palladino
19830	SP	9254	Jardim Salessi	Jd Salessi
19831	SP	9254	Jardim Santa Filomena	Jd Sta Filomena
19833	SP	9254	Vila Santa Luzia	Vl Sta Luzia
19834	SP	9254	Jardim Santa Rosa	Jd Sta Rosa
19835	SP	9254	Jardim Santo Antônio	Jd Sto Antônio
19836	SP	9254	Jardim São João	Jd S João
19837	SP	9254	Jardim São José	Jd S José
19884	SP	9254	Terras de São Sebastião	T S Sebastião
19885	SP	9254	Terras de Savion	T Savion
19886	SP	9254	Vila Bela Vista	Vl B Vista
19887	SP	9254	Vila Brasileira	Vl Brasileira
19888	SP	9254	Vila Capelletto	Vl Capelletto
19889	SP	9254	Vila Cassaro	Vl Cassaro
19890	SP	9254	Vila Centenário	Vl Centenário
19891	SP	9254	Vila Cremonesi	Vl Cremonesi
19892	SP	9254	Vila Cristo Redentor	Vl C Redentor
19893	SP	9254	Vila Cruzeiro	Vl Cruzeiro
19894	SP	9254	Vila Fassina	Vl Fassina
19895	SP	9254	Vila Mutton	Vl Mutton
19896	SP	9254	Vila Penteado	Vl Penteado
19897	SP	9254	Vila Prudente de Moraes	Vl P Moraes
19898	SP	9254	Vila Santa Clara	Vl Sta Clara
19899	SP	9254	Vila Santa Cruz	Vl Sta Cruz
19900	SP	9254	Vila Santa Terezinha	Vl Sta Terezinha
19901	SP	9254	Vila São Caetano	Vl S Caetano
19902	SP	9254	Ville Chamonix	V Chamonix
19903	SP	9254	Vivendas do Engenho D'Água	V E D'Água
19904	SP	9260	Alto	\N
19905	SP	9260	Alto da Vila Nova	At Vl Nova
19906	SP	9260	Alto das Palmeiras	At Palmeiras
19907	SP	9260	Brasil	\N
19908	SP	9260	Bairro Campos de Santo Antônio	B C Sto Antônio
19909	SP	9260	Centro	\N
19910	SP	9260	Chácara Bela Vista	Ch B Vista
19912	SP	9260	Chácara dos Eucaliptos	Ch Eucaliptos
19913	SP	9260	Chácara Flora	Ch Flora
19914	SP	9260	Chácara Flórida	Ch Flórida
19915	SP	9260	Chácara Paraíso	Ch Paraíso
19916	SP	9260	Chácaras Primavera	C Primavera
19917	SP	9260	Chácara São João	Ch S João
19920	SP	9260	Chafaris	\N
19921	SP	9260	Cidade Nova I	C Nova I
19922	SP	9260	Cidade Nova II	C Nova II
19923	SP	9260	City Castello	C Castello
19924	SP	9260	Condomínio Portal de Itu	Cond P Itu
19925	SP	9260	Cruz das Almas	C Almas
19926	SP	9260	Fazenda Vila Real de Itu	Faz Vl R Itu
19927	SP	9260	Itaim	\N
19928	SP	9260	Jardim Aeroporto I	Jd Aeroporto I
19929	SP	9260	Jardim Aeroporto II	Jd Aeroporto II
19930	SP	9260	Jardim Agarussi	Jd Agarussi
19931	SP	9260	Jardim Alberto Gomes	Jd A Gomes
19932	SP	9260	Jardim Convenção	Jd Convenção
19933	SP	9260	Jardim Corazza	Jd Corazza
19934	SP	9260	Jardim da Vitória	Jd Vitória
19935	SP	9260	Jardim das Indústrias	Jd Indústrias
19936	SP	9260	Jardim das Rosas	Jd Rosas
19937	SP	9260	Jardim do Estádio	Jd Estádio
19938	SP	9260	Jardim Eridano	Jd Eridano
19996	SP	9265	Capalbo Neto	C Neto
19997	SP	9265	Centro	\N
19998	SP	9265	Cidade Alta	C Alta
19999	SP	9265	Cidade Jardim (Zagalo)	C Jardim (Zagalo)
20000	SP	9265	Conjunto Habitacional Hugo Lacorte Vitalle I	Cj Hab H L Vitalle I
20001	SP	9265	Conjunto Habitacional Hugo Lacorte Vitalle II	Cj Hab H L Vitalle II
20002	SP	9265	Conjunto Habitacional Margarida Raymundo Berchieri	Cj Hab M R Berchieri
20003	SP	9265	Conjunto Habitacional Ulisses Guimarães	Cj Hab U Guimarães
20005	SP	9265	Ferreira	\N
20006	SP	9265	Jardim Alvorada	Jd Alvorada
20007	SP	9265	Jardim Angélica	Jd Angélica
20008	SP	9265	Jardim Bela Vista	Jd Bela Vista
20009	SP	9265	Jardim Boa Vista	Jd B Vista
20010	SP	9265	Jardim Bom Jesus	Jd B Jesus
20011	SP	9265	Jardim Brandi	Jd Brandi
20012	SP	9265	Jardim das Cigarras	Jd Cigarras
20014	SP	9265	Jardim das Rosas	Jd Rosas
20015	SP	9265	Jardim Ebenezer	Jd Ebenezer
20016	SP	9265	Jardim Eldorado	Jd Eldorado
20017	SP	9265	Jardim Grajaú	Jd Grajaú
20018	SP	9265	Jardim Independência	Jd Independência
20019	SP	9265	Jardim Kennedy	Jd Kennedy
20020	SP	9265	Jardim Morumbi	Jd Morumbi
20021	SP	9265	Jardim Nova Aparecida	Jd N Aparecida
20022	SP	9265	Jardim Patriarca	Jd Patriarca
20023	SP	9265	Jardim Paulista	Jd Paulista
20024	SP	9265	Jardim Pedroso	Jd Pedroso
20025	SP	9265	Jardim Perina	Jd Perina
20026	SP	9265	Jardim Primavera	Jd Primavera
20027	SP	9265	Jardim Santa Rita	Jd Sta Rita
20028	SP	9265	Jardim Santa Rosa	Jd Sta Rosa
20029	SP	9265	Jardim São Marcos I	Jd S Marcos I
20030	SP	9265	Jardim São Marcos II	Jd S Marcos II
20031	SP	9265	Jardim Tangará	Jd Tangará
20032	SP	9265	Jardim Universitário	Jd Universitário
20033	SP	9265	João Costa	J Costa
20034	SP	9265	Maria de Lourdes	M Lourdes
20035	SP	9265	Maria Marconato	M Marconato
20036	SP	9265	Niero	\N
20037	SP	9265	Nova Jaboticabal	N Jaboticabal
20038	SP	9265	Parque do Trevo	Prq Trevo
20039	SP	9265	Parque dos Laranjais	Prq Laranjais
20041	SP	9265	Parque Jaqueline	Prq Jaqueline
20042	SP	9265	Parque Primeiro de Maio	Prq P Maio
20043	SP	9265	Pedro Morello	P Morello
20044	SP	9265	Perina	\N
20045	SP	9265	Planalto do Bosque	P Bosque
20046	SP	9265	Planalto Itália	P Itália
20047	SP	9265	Ponte Seca	Pte Seca
19838	SP	9254	Jardim São Luiz II	Jd S Luiz II
19839	SP	9254	Jardim São Marcos	Jd S Marcos
19841	SP	9254	Jardim Tereza	Jd Tereza
19842	SP	9254	Jardim Virgínia	Jd Virgínia
19844	SP	9254	Loteamento Caminhos do Sol	Lot C Sol
19845	SP	9254	Loteamento Fernando Momentel	Lot F Momentel
19846	SP	9254	Loteamento Rei de Ouro	Lot R Ouro
19847	SP	9254	Loteamento Santo Antônio	Lot Sto Antônio
19848	SP	9254	Mombuca	\N
19849	SP	9254	Morada das Fontes	M Fontes
19850	SP	9254	Morada dos Pássaros	M Pássaros
19851	SP	9254	Nova Itatiba	N Itatiba
19852	SP	9254	Novo Cruzeiro	N Cruzeiro
19853	SP	9254	Núcleo Residencial Abramo Delforno	Nuc Res A Delforno
19854	SP	9254	Núcleo Residencial Afonso Zupardo	Nuc Res A Zupardo
19855	SP	9254	Núcleo Residencial Doutor Luiz de Mattos Pimenta	Nuc Res Dr L M Pimenta
19856	SP	9254	Núcleo Residencial João Corradini	Nuc Res J Corradini
19857	SP	9254	Núcleo Residencial Pedro Fumachi	Nuc Res P Fumachi
19858	SP	9254	Núcleo Residencial Porto Seguro	Nuc Res Pto Seguro
19859	SP	9254	Núcleo Residencial Vale Verde	Nuc Res Vle Verde
19860	SP	9254	Parque da Fazenda	Prq Fazenda
19861	SP	9254	Parque das Laranjeiras	Prq Laranjeiras
19862	SP	9254	Parque Nova Xampirra	Prq N Xampirra
19863	SP	9254	Parque São Francisco	Prq S Francisco
19864	SP	9254	Parque São Gabriel	Prq S Gabriel
19865	SP	9254	Parque São Vicente	Prq S Vicente
19866	SP	9254	Parque Tescarollo	Prq Tescarollo
19867	SP	9254	Bairro do Pinhal	B Pinhal
19868	SP	9254	Pomar São Jorge	P S Jorge
19869	SP	9254	Bairro da Ponte	B Ponte
19870	SP	9254	Ponte Nova	Pte Nova
19871	SP	9254	Portal da Colina	P Colina
19872	SP	9254	Real Parque Dom Pedro I	R Prq D Pedro I
19873	SP	9254	Recanto Beira Rio	Rec B Rio
19874	SP	9254	Recanto da Paz	Rec Paz
19875	SP	9254	Recanto das Estrelas	Rec Estrelas
19876	SP	9254	Recanto dos Pássaros	Rec Pássaros
19877	SP	9254	Recanto Princesa da Colina	Rec Prca Colina
19878	SP	9254	Recreio Costa Verde	Rcr C Verde
19879	SP	9254	Residencial Grêmio	Res Grêmio
19880	SP	9254	Residencial Moenda	Res Moenda
19881	SP	9254	Sítio da Moenda	Sit Moenda
19882	SP	9254	Summertime Barreiro	S Barreiro
19883	SP	9254	Terras de San Marco	T S Marco
19939	SP	9260	Jardim Faculdade	Jd Faculdade
19940	SP	9260	Jardim Novo Itu	Jd N Itu
19941	SP	9260	Jardim Oliveira	Jd Oliveira
19942	SP	9260	Jardim Padre Bento	Jd Pe Bento
19943	SP	9260	Jardim Paineiras	Jd Paineiras
19944	SP	9260	Jardim Paraíso	Jd Paraíso
19945	SP	9260	Rancho Grande	R Grande
19946	SP	9260	Jardim Rosinha	Jd Rosinha
19947	SP	9260	Jardim Santa Tereza	Jd Sta Tereza
19948	SP	9260	Jardim Santana	Jd Santana
19949	SP	9260	Jardim São José	Jd S José
19951	SP	9260	Liberdade	\N
19952	SP	9260	Mangueiras de Itu	M Itu
19953	SP	9260	Nossa Senhora Aparecida	N Sra Aparecida
19954	SP	9260	Núcleo Habitacional São Judas Tadeu	Nuc Hab S J Tadeu
19955	SP	9260	Parque das Indústrias	Prq Indústrias
19956	SP	9260	Parque das Rosas	Prq Rosas
19957	SP	9260	Parque Industrial	Prq Industrial
19958	SP	9260	Parque Nossa Senhora da Candelária	Prq N Sra Candelária
19959	SP	9260	Parque Residencial Guitti	Prq Res Guitti
19960	SP	9260	Parque Residencial Mayard	Prq Res Mayard
19961	SP	9260	Parque Residencial Presidente Médici	Prq Res Pres Médici
19962	SP	9260	Pinheirinho	\N
19963	SP	9260	Pirapitingui	\N
19964	SP	9260	Portal da Vila Rica	P Vl Rica
19965	SP	9260	Portal do Éden	P Éden
19968	SP	9260	Santa Cruz	Sta Cruz
19969	SP	9260	Santa Inês	Sta Inês
19970	SP	9260	São Luiz	S Luiz
19972	SP	9260	Condomínio Terras de São José	Cond T S José
19973	SP	9260	Terras de São José Urbano Portella	T S J U Portella
19975	SP	9260	Vila Cleto	Vl Cleto
19976	SP	9260	Vila Esperança	Vl Esperança
19977	SP	9260	Vila Gardiman	Vl Gardiman
19978	SP	9260	Vila Gatti	Vl Gatti
19979	SP	9260	Vila Guido	Vl Guido
19980	SP	9260	Vila Ianni	Vl Ianni
19981	SP	9260	Vila Leis	Vl Leis
19982	SP	9260	Vila Lucinda/Romana	Vl Lucinda/Romana
19983	SP	9260	Vila Martins	Vl Martins
19984	SP	9260	Vila Nova	Vl Nova
19985	SP	9260	Vila Padre Bento	Vl Pe Bento
19986	SP	9260	Vila Prudente de Moraes	Vl P Moraes
19987	SP	9260	Vila Roma	Vl Roma
19988	SP	9260	Vila Santa Rosa	Vl Sta Rosa
19989	SP	9260	Vila Santa Terezinha	Vl Sta Terezinha
19990	SP	9260	Vila São Francisco	Vl S Francisco
19991	SP	9260	Vila São José	Vl S José
19992	SP	9265	Aparecida	\N
19993	SP	9265	Barra Funda	B Funda
19994	SP	9265	Barreiro	\N
20048	SP	9265	Recanto do Barreiro	Rec Barreiro
20049	SP	9265	Recreio dos Bandeirantes	Rcr Bandeirantes
20050	SP	9265	Santa Izabel	Sta Izabel
20051	SP	9265	Santa Luzia	Sta Luzia
20052	SP	9265	Santa Mônica	Sta Mônica
20053	SP	9265	Santo Antônio	Sto Antônio
20054	SP	9265	São Roque	S Roque
20055	SP	9265	Solar Corinthiano	S Corinthiano
20056	SP	9265	Sorocabano	\N
20057	SP	9265	Vale do Sol	Vle Sol
20058	SP	9265	Vila Buenos Aires	Vl B Aires
20059	SP	9265	Vila Industrial	Vl Industrial
20060	SP	9265	Vila Patrício dos Santos	Vl P Santos
20061	SP	9265	Vila Santa Rosa	Vl Sta Rosa
20062	SP	9265	Vila Santa Tereza	Vl Sta Tereza
20063	SP	9265	Vila Santo Antônio	Vl Sto Antônio
20064	SP	9265	Vila São José	Vl S José
20065	SP	9265	Vila Saul Borsari	Vl S Borsari
20066	SP	9265	Vila Serra	Vl Serra
20067	SP	9265	Vila Simoni	Vl Simoni
20068	SP	9265	Vila Toto	Vl Toto
20069	SP	9265	X	 X
20071	SP	9267	Angola de Baixo	A Baixo
20076	SP	9267	Bandeira Branca	B Branca
20079	SP	9267	Bom Jesus	B Jesus
20087	SP	9267	Centro	\N
20090	SP	9267	Chácara Itapoã	Ch Itapoã
20091	SP	9267	Chácaras Condomínio Recanto Pássaros II	C Cond Rec Pássaros II
20093	SP	9267	Chácaras Reunidas Bela Vista	C R B Vista
20094	SP	9267	Chácaras Reunidas Igarapés	C R Igarapés
20095	SP	9267	Chácaras Rurais de Guararema	C R Guararema
20097	SP	9267	Chácaras Rurais Santa Maria	C R Sta Maria
20098	SP	9267	Chácaras Santa Maria	C Sta Maria
20100	SP	9267	Cidade Jardim	C Jardim
20101	SP	9267	Cidade Nova Jacareí	C N Jacareí
20102	SP	9267	Cidade Salvador	C Salvador
20104	SP	9267	Condomínio Lagoinha	Cond Lagoinha
20108	SP	9267	Primeiro de Maio	P Maio
20109	SP	9267	Conjunto Residencial Vinte e Dois de Abril	Cj Res V E D Abril
20110	SP	9267	Conjunto São Benedito	Cj S Benedito
20120	SP	9267	Jardim Alvorada	Jd Alvorada
20123	SP	9267	Jardim Bela Vista	Jd Bela Vista
20125	SP	9267	Jardim Boa Vista	Jd B Vista
20127	SP	9267	Jardim Califórnia	Jd Califórnia
20129	SP	9267	Jardim Colinas	Jd Colinas
20130	SP	9267	Jardim Colônia	Jd Colônia
20132	SP	9267	Jardim das Indústrias	Jd Indústrias
20137	SP	9267	Jardim do Vale	Jd Vale
20140	SP	9267	Jardim Emília	Jd Emília
20141	SP	9267	Jardim Esper	Jd Esper
20269	SP	9277	Jardim Cristino	Jd Cristino
20270	SP	9277	Jardim das Margaridas	Jd Margaridas
20271	SP	9277	Jardim do Golf I	Jd Golf I
20272	SP	9277	Jardim do Líbano	Jd Líbano
20273	SP	9277	Jardim Europa	Jd Europa
20274	SP	9277	Jardim Gabriela I	Jd Gabriela I
20275	SP	9277	Jardim Gabriela II	Jd Gabriela II
20276	SP	9277	Jardim Gabriela III	Jd Gabriela III
20277	SP	9277	Jardim Heneide	Jd Heneide
20278	SP	9277	Jardim Jandira	Jd Jandira
20279	SP	9277	Jardim Javaes	Jd Javaes
20280	SP	9277	Jardim Lindomar	Jd Lindomar
20281	SP	9277	Jardim Marília	Jd Marília
20282	SP	9277	Jardim Mase	Jd Mase
20283	SP	9277	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
20284	SP	9277	Jardim Novo Horizonte	Jd N Horizonte
20285	SP	9277	Jardim Palmeiras	Jd Palmeiras
20286	SP	9277	Jardim Patriarca	Jd Patriarca
20287	SP	9277	Jardim Rosa Emília	Jd R Emília
20288	SP	9277	Jardim Sagrado Coração	Jd S Coração
20289	SP	9277	Jardim Sagrado Coração de Jesus	Jd S C Jesus
20290	SP	9277	Jardim São João	Jd S João
20291	SP	9277	Jardim São Luiz	Jd S Luiz
20292	SP	9277	Jardim São Paulo	Jd S Paulo
20293	SP	9277	Jardim Sol Nascente	Jd S Nascente
20294	SP	9277	Jardim Sorocabano	Jd Sorocabano
20295	SP	9277	Jardim Stella Maris	Jd S Maris
20296	SP	9277	Jardim Velho Sanazar	Jd Vo Sanazar
20297	SP	9277	Lago dos Cisnes	Lg Cisnes
20298	SP	9277	Nova Higienópolis	N Higienópolis
20299	SP	9277	Núcleo Micro Industrial Presidente Wilson	Nuc M Ind Pres Wilson
20300	SP	9277	Parque das Iglesias	Prq Iglesias
20301	SP	9277	Parque dos Lagos	Prq Lagos
20302	SP	9277	Parque Industrial	Prq Industrial
20303	SP	9277	Parque Nova Jandira	Prq N Jandira
20304	SP	9277	Parque Santa Tereza	Prq Sta Tereza
20305	SP	9277	Recreio Santa Rosa	Rcr Sta Rosa
20306	SP	9277	Suite Quebra Nozes	S Q Nozes
20307	SP	9277	Vale do Sol	Vle Sol
20308	SP	9277	Vila Anita Costa	Vl A Costa
20309	SP	9277	Vila Bianca	Vl Bianca
20310	SP	9277	Vila Cecília	Vl Cecília
20311	SP	9277	Vila Diogo Balhesteiro	Vl D Balhesteiro
20312	SP	9277	Vila Dolores Paschoalin	Vl D Paschoalin
20313	SP	9277	Vila Ercília	Vl Ercília
20314	SP	9277	Vila Esmeralda	Vl Esmeralda
20315	SP	9277	Vila Eugênia	Vl Eugênia
20316	SP	9277	Vila Eunice	Vl Eunice
20373	SP	9285	Jardim Nova América	Jd N América
20374	SP	9285	Jardim Nova Jaú	Jd N Jaú
20375	SP	9285	Jardim Novo Horizonte	Jd N Horizonte
20376	SP	9285	Jardim Odete	Jd Odete
20377	SP	9285	Jardim Olímpia	Jd Olímpia
20378	SP	9285	Jardim Orlando Chesini Ometto	Jd O C Ometto
20380	SP	9285	Jardim Padre Augusto Sani	Jd Pe A Sani
20381	SP	9285	Jardim Parati	Jd Parati
20382	SP	9285	Jardim Pedro Ometto	Jd P Ometto
20383	SP	9285	Jardim Pires de Campos	Jd P Campos
20384	SP	9285	Jardim Regina	Jd Regina
20385	SP	9285	Jardim Rosa Branca	Jd R Branca
20386	SP	9285	Jardim Santa Helena	Jd Sta Helena
20387	SP	9285	Jardim Santa Rosa	Jd Sta Rosa
20388	SP	9285	Jardim Santo Onofre	Jd Sto Onofre
20389	SP	9285	Jardim Sanzovo	Jd Sanzovo
20390	SP	9285	Jardim São Caetano	Jd S Caetano
20391	SP	9285	Jardim São Crispim	Jd S Crispim
20392	SP	9285	Jardim São Francisco	Jd S Francisco
20393	SP	9285	Jardim São José	Jd S José
20394	SP	9285	Jardim Sempre Verde	Jd S Verde
20395	SP	9285	Jardim Vila Maria	Jd Vl Maria
20398	SP	9285	Pouso Alegre de Baixo	P A Baixo
20399	SP	9285	Residencial dos Pássaros	Res Pássaros
20400	SP	9285	Santo Antônio	Sto Antônio
20401	SP	9285	Vila Alves de Almeida	Vl A Almeida
20402	SP	9285	Vila Assis	Vl Assis
20403	SP	9285	Vila Brasil	Vl Brasil
20404	SP	9285	Vila Buscariolo	Vl Buscariolo
20405	SP	9285	Vila Carvalho	Vl Carvalho
20408	SP	9285	Vila Hilst	Vl Hilst
20409	SP	9285	Vila Industrial	Vl Industrial
20410	SP	9285	Vila Ivan	Vl Ivan
20411	SP	9285	Jardim Brasília	Jd Brasília
20412	SP	9285	Vila Maria Cristina	Vl M Cristina
20413	SP	9285	Vila Nassif Name	Vl N Name
20414	SP	9285	Vila Netinho Prado	Vl N Prado
20415	SP	9285	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
20416	SP	9285	Vila Nova	Vl Nova
20417	SP	9285	Vila Nova Brasil	Vl N Brasil
20418	SP	9285	Vila Nova Jaú	Vl N Jaú
20420	SP	9285	Vila Padre Nosso	Vl Pe Nosso
20421	SP	9285	Vila Paulista	Vl Paulista
20422	SP	9285	Vila Piragine	Vl Piragine
20423	SP	9285	Vila Pires de Campo	Vl P Campo
20424	SP	9285	Vila Quinze de Novembro	Vl Q Novembro
20425	SP	9285	Vila Ribeiro	Vl Ribeiro
20426	SP	9285	Vila Sampaio Bueno	Vl S Bueno
20427	SP	9285	Vila Santa Maria	Vl Sta Maria
20428	SP	9285	Vila Santa Terezinha	Vl Sta Terezinha
20429	SP	9285	Vila Santo Ivo	Vl Sto Ivo
20430	SP	9285	Vila São Judas Tadeu	Vl S J Tadeu
20431	SP	9285	Vila Vicente	Vl Vicente
20432	SP	9285	1ª Zona Industrial	1ª Z Industrial
20433	SP	9285	2ª Zona Industrial	2ª Z Industrial
20435	SP	9295	Água das Flores	A Flores
20437	SP	9295	Anhangabaú	\N
20439	SP	9295	Bela Vista	\N
20440	SP	9295	Boa Vista	B Vista
20441	SP	9295	Casa Branca	C Branca
20443	SP	9295	Caxambu	\N
20444	SP	9295	Centro	\N
20445	SP	9295	Chácara Aeroporto	Ch Aeroporto
20452	SP	9295	Chácara Morada Mediterrânea	Ch M Mediterrânea
20454	SP	9295	Chácara Malota	Ch Malota
20455	SP	9295	Rio Acima	R Acima
20457	SP	9295	Chácara Planalto	Ch Planalto
20460	SP	9295	Chácaras de Recreio Santa Terezinha	C Rcr Sta Terezinha
20462	SP	9295	Chácara São Felipe	Ch S Felipe
20463	SP	9295	Chácara São Francisco	Ch S Francisco
20464	SP	9295	Chácaras Saudáveis e Encantadoras	C S Encantadoras
20467	SP	9295	Chácara Urbana	Ch Urbana
20468	SP	9295	Cidade Jardim	C Jardim
20469	SP	9295	Cidade Luiza	C Luiza
20470	SP	9295	Cidade Nova	C Nova
20471	SP	9295	Cidade Santos Dumont	C Stos Dumont
20472	SP	9295	Colônia	\N
20474	SP	9295	Distrito Industrial	Dt Industrial
20475	SP	9295	Engordadouro	\N
20479	SP	9295	Ivoturucaia	\N
20481	SP	9295	Jardim Adélia	Jd Adélia
20482	SP	9295	Jardim América	Jd América
20483	SP	9295	Jardim Ana Maria	Jd A Maria
20484	SP	9295	Jardim Ângela	Jd Ângela
20485	SP	9295	Jardim Anhangüera	Jd Anhangüera
20486	SP	9295	Jardim Aurélia	Jd Aurélia
20487	SP	9295	Jardim Bandeiras	Jd Bandeiras
20488	SP	9295	Jardim Bizarro	Jd Bizarro
20489	SP	9295	Jardim Boa Vista	Jd B Vista
20490	SP	9295	Jardim Bonfiglioli	Jd Bonfiglioli
20491	SP	9295	Jardim Brasil	Jd Brasil
20492	SP	9295	Jardim Búfalo	Jd Búfalo
20493	SP	9295	Jardim Caçula	Jd Caçula
20494	SP	9295	Jardim Califórnia	Jd Califórnia
20495	SP	9295	Jardim Campos Elísios	Jd C Elísios
20496	SP	9295	Jardim Carlos Gomes	Jd C Gomes
20497	SP	9295	Jardim Carolina	Jd Carolina
20498	SP	9295	Jardim Caxambu	Jd Caxambu
20499	SP	9295	Jardim Celeste	Jd Celeste
20500	SP	9295	Jardim Cica	Jd Cica
20501	SP	9295	Jardim Cidapel	Jd Cidapel
20502	SP	9295	Jardim Colônia	Jd Colônia
20562	SP	9295	Jardim Santa Lourdes	Jd Sta Lourdes
20563	SP	9295	Jardim Santa Rita de Cássia	Jd Sta R Cássia
20564	SP	9295	Jardim Santa Teresa	Jd Sta Teresa
20565	SP	9295	Jardim São Bento	Jd S Bento
20566	SP	9295	Jardim São Camilo	Jd S Camilo
20567	SP	9295	Jardim São Camilo Novo	Jd S C Novo
20568	SP	9295	Jardim São Judas Tadeu	Jd S J Tadeu
20569	SP	9295	Jardim São Marcus	Jd S Marcus
20570	SP	9295	Jardim São Miguel	Jd S Miguel
20571	SP	9295	Jardim São Paulo	Jd S Paulo
20572	SP	9295	Jardim São Vicente	Jd S Vicente
20573	SP	9295	Jardim Scala	Jd Scala
20574	SP	9295	Jardim Servilha	Jd Servilha
20575	SP	9295	Jardim Shangai	Jd Shangai
20576	SP	9295	Jardim Tamoio	Jd Tamoio
20577	SP	9295	Jardim Tannus	Jd Tannus
20578	SP	9295	Jardim Tarumã	Jd Tarumã
20579	SP	9295	Jardim Tereza Cristina	Jd T Cristina
20580	SP	9295	Jardim Tiradentes	Jd Tiradentes
20581	SP	9295	Jardim Torres São José	Jd T S José
20582	SP	9295	Jardim Trevo	Jd Trevo
20583	SP	9295	Jardim Vera Cruz	Jd V Cruz
20584	SP	9295	Jundiaí Mirim	J Mirim
20587	SP	9295	Medeiros	\N
20589	SP	9295	Morada das Vinhas	M Vinhas
20591	SP	9295	Núcleo Colonial Barão de Jundiaí	Nuc C Br Jundiaí
20593	SP	9295	Parque Brasília	Prq Brasília
20594	SP	9295	Parque Cecap	Prq Cecap
20595	SP	9295	Parque Centenário	Prq Centenário
20596	SP	9295	Parque Cidade Jardim	Prq C Jardim
20597	SP	9295	Parque Continental	Prq Continental
20598	SP	9295	Parque da Represa	Prq Represa
20599	SP	9295	Parque do Colégio	Prq Colégio
20603	SP	9295	Portal do Paraíso I	P Paraíso I
20604	SP	9295	Parque Recanto do Parrilho	Prq Rec Parrilho
20605	SP	9295	Parque Residencial Eloy Chaves	Prq Res E Chaves
20608	SP	9295	Parque São Luiz	Prq S Luiz
20609	SP	9295	Parque União	Prq União
20612	SP	9295	Ponte de Campinas	Pte Campinas
20613	SP	9295	Ponte de São João	Pte S João
20614	SP	9295	Poste	\N
20615	SP	9295	Parque Quinta da Boa Vista	Prq Qta B Vista
20616	SP	9295	Recanto Quarto Centenário	Rec Q Centenário
20617	SP	9295	Residencial Terra da Uva	Res T Uva
20618	SP	9295	Retiro	\N
20620	SP	9295	Santo Antônio	Sto Antônio
20622	SP	9295	Traviú	\N
20626	SP	9295	Vila Agostinho Zambom	Vl A Zambom
20627	SP	9295	Vila Agrícola	Vl Agrícola
20686	SP	9295	Vila Moraes	Vl Moraes
20687	SP	9295	Vila Moutran	Vl Moutran
20689	SP	9295	Vila Municipal	Vl Municipal
20691	SP	9295	Vila Nambi	Vl Nambi
20692	SP	9295	Vila Nova Esperia	Vl N Esperia
20693	SP	9295	Vila Nova Jundiaí	Vl N Jundiaí
20694	SP	9295	Vila Nova Jundiainópolis	Vl N Jundiainópolis
20695	SP	9295	Vila Nova Medeiros	Vl N Medeiros
20696	SP	9295	Vila Padre Nóbrega	Vl Pe Nóbrega
20697	SP	9295	Vila Paulista	Vl Paulista
20698	SP	9295	Vila Pirapora	Vl Pirapora
20699	SP	9295	Vila Pires	Vl Pires
20700	SP	9295	Vila Ponte de Campinas	Vl Pte Campinas
20701	SP	9295	Vila Princesa Isabel	Vl Prca Isabel
20702	SP	9295	Vila Progresso	Vl Progresso
20703	SP	9295	Vila Rafael de Oliveira	Vl R Oliveira
20704	SP	9295	Vila Rami	Vl Rami
20705	SP	9295	Vila Rica	Vl Rica
20706	SP	9295	Vila Rio Branco	Vl R Branco
20707	SP	9295	Vila Rossi	Vl Rossi
20708	SP	9295	Vila Ruy Barbosa	Vl R Barbosa
20709	SP	9295	Vila Salermo	Vl Salermo
20710	SP	9295	Vila Santa Maria	Vl Sta Maria
20711	SP	9295	Vila Santa Marina	Vl Sta Marina
20712	SP	9295	Vila Santa Rosa	Vl Sta Rosa
20713	SP	9295	Vila Santana I	Vl Santana I
20715	SP	9295	Vila São Bento	Vl S Bento
20716	SP	9295	Vila São João Batista	Vl S J Batista
20718	SP	9295	Vila São Paulo	Vl S Paulo
20720	SP	9295	Vila São Sebastião	Vl S Sebastião
20721	SP	9295	Vila Savieto	Vl Savieto
20726	SP	9295	Vila Torres Neves	Vl T Neves
20727	SP	9295	Vila de Vecchi	Vl Vecchi
20728	SP	9295	Vila Vianelo	Vl Vianelo
20730	SP	9295	Vila Vioto	Vl Vioto
20731	SP	9295	Vila Virgínia	Vl Virgínia
20732	SP	9295	Vila Della Piazza	Vl D Piazza
20734	SP	9315	Barra Funda	B Funda
20736	SP	9315	Centro	\N
20737	SP	9315	Chácara Saúde	Ch Saúde
20738	SP	9315	Cidade Jardim	C Jardim
20739	SP	9315	Conjunto Habitacional Ferdinando Marchi	Cj Hab F Marchi
20741	SP	9315	Desmembramento Davi Comi	D D Comi
20742	SP	9315	Desmembramento Vila Nova	D Vl Nova
20744	SP	9315	Estrada Municipal Caju	Est M Caju
20746	SP	9315	Estrada Particular Ibicatu	Est P Ibicatu
20747	SP	9315	Fazenda Capitólio	Faz Capitólio
20748	SP	9315	Fazenda Palmeiras	Faz Palmeiras
20749	SP	9315	Fazenda Santo Antônio	Faz Sto Antônio
20751	SP	9315	Jardim Residencial Santa Maria	Jd Res Sta Maria
20142	SP	9267	Jardim Esperança	Jd Esperança
20143	SP	9267	Jardim Flórida	Jd Flórida
20146	SP	9267	Jardim Jacinto	Jd Jacinto
20151	SP	9267	Jardim Maria Amélia	Jd M Amélia
20157	SP	9267	Jardim Nova Esperança	Jd N Esperança
20159	SP	9267	Jardim Panorama	Jd Panorama
20160	SP	9267	Jardim Paraíba	Jd Paraíba
20161	SP	9267	Jardim Paraíso	Jd Paraíso
20164	SP	9267	Jardim Pedra Mar	Jd P Mar
20165	SP	9267	Jardim Pereira do Amparo	Jd P Amparo
20167	SP	9267	Jardim Primavera	Jd Primavera
20169	SP	9267	Jardim Santa Maria	Jd Sta Maria
20172	SP	9267	Jardim Santana	Jd Santana
20173	SP	9267	Jardim Santo Antônio da Boa Vista	Jd Sto A B Vista
20174	SP	9267	Jardim São Gabriel	Jd S Gabriel
20180	SP	9267	Jardim Siesta	Jd Siesta
20182	SP	9267	Jardim Terras de São João	Jd T S João
20193	SP	9267	Pagador de Andrade	P Andrade
20196	SP	9267	Parque Califórnia	Prq Califórnia
20198	SP	9267	Parque Imperial	Prq Imperial
20199	SP	9267	Parque Itamarati	Prq Itamarati
20200	SP	9267	Parque Meia Lua	Prq M Lua
20205	SP	9267	Parque Santo Antônio	Prq Sto Antônio
20209	SP	9267	Pinho	\N
20214	SP	9267	Rio Abaixo	R Abaixo
20215	SP	9267	Rio Comprido	R Comprido
20216	SP	9267	São João	S João
20218	SP	9267	São Silvestre (São Silvestre)	S Silvestre (S Silvestre)
20225	SP	9267	Veraneio Ijal	V Ijal
20226	SP	9267	Veraneio Irajá	V Irajá
20231	SP	9267	Vila Formosa	Vl Formosa
20232	SP	9267	Vila Garcia (São Silvestre)	Vl Garcia (S Silvestre)
20245	SP	9267	Vila São João (São Silvestre)	Vl S João (S Silvestre)
20251	SP	9267	Vila Zezé	Vl Zezé
20254	SP	9277	Altos de São Fernando	A S Fernando
20255	SP	9277	Centro	\N
20256	SP	9277	Chácaras do Peroba	C Peroba
20257	SP	9277	Condomínio Forest Hills	Cond F Hills
20258	SP	9277	Granja Alvorada	Gja Alvorada
20259	SP	9277	Infant's Garden	I Garden
20260	SP	9277	Jardim Alvorada	Jd Alvorada
20261	SP	9277	Jardim Analândia	Jd Analândia
20262	SP	9277	Jardim Antônio Porto	Jd A Porto
20263	SP	9277	Jardim Aurora	Jd Aurora
20264	SP	9277	Jardim Belmont	Jd Belmont
20265	SP	9277	Jardim Bolívia	Jd Bolívia
20266	SP	9277	Jardim Briquet	Jd Briquet
20267	SP	9277	Jardim Brotinho	Jd Brotinho
20268	SP	9277	Jardim Centenário	Jd Centenário
20317	SP	9277	Vila Godinho	Vl Godinho
20318	SP	9277	Vila Ipê	Vl Ipê
20319	SP	9277	Vila Lucinda	Vl Lucinda
20320	SP	9277	Vila Makenzi	Vl Makenzi
20321	SP	9277	Vila Márcia	Vl Márcia
20322	SP	9277	Vila Mercedes	Vl Mercedes
20323	SP	9277	Vila Ouro Verde	Vl O Verde
20324	SP	9277	Vila Popi	Vl Popi
20325	SP	9277	Vila Rolim	Vl Rolim
20326	SP	9277	Vila Santa Rosa	Vl Sta Rosa
20327	SP	9277	Vila Santo Antônio	Vl Sto Antônio
20328	SP	9277	Vila São Nicolau	Vl S Nicolau
20329	SP	9285	Centro	\N
20330	SP	9285	Chácara Bela Vista	Ch B Vista
20331	SP	9285	Chácara Braz Miraglia	Ch B Miraglia
20332	SP	9285	Chácara Canhos	Ch Canhos
20333	SP	9285	Chácara Doutor Lopes	Ch Dr Lopes
20334	SP	9285	Chácara Ferreira Dias	Ch F Dias
20335	SP	9285	Chácara Flora	Ch Flora
20336	SP	9285	Chácara Itaúna	Ch Itaúna
20337	SP	9285	Chácara Nunes	Ch Nunes
20338	SP	9285	Chácara Peccioli	Ch Peccioli
20339	SP	9285	Chácara São Joaquim	Ch S Joaquim
20340	SP	9285	Chácara São José	Ch S José
20341	SP	9285	Condomínio Jardim Alvorada	Cond Jd Alvorada
20345	SP	9285	Distrito Industrial	Dt Industrial
20346	SP	9285	Jardim Alvorada	Jd Alvorada
20347	SP	9285	Jardim América	Jd América
20348	SP	9285	Jardim Ana Carolina	Jd A Carolina
20349	SP	9285	Jardim Antonina	Jd Antonina
20350	SP	9285	Jardim Bela Vista	Jd B Vista
20351	SP	9285	Jardim Bernardi	Jd Bernardi
20353	SP	9285	Jardim Campos Prado	Jd C Prado
20354	SP	9285	Jardim Carolina	Jd Carolina
20355	SP	9285	Jardim Chácara Auler	Jd Ch Auler
20356	SP	9285	Jardim Cila de Lúcio Bauab	Jd C L Bauab
20357	SP	9285	Jardim Concha de Ouro	Jd C Ouro
20358	SP	9285	Jardim Conde Pinhal I	Jd Cd Pinhal I
20359	SP	9285	Jardim Continental	Jd Continental
20361	SP	9285	Jardim das Paineiras	Jd Paineiras
20362	SP	9285	Jardim Diamante	Jd Diamante
20364	SP	9285	Jardim Doutor Luciano	Jd Dr Luciano
20365	SP	9285	Jardim Estádio	Jd Estádio
20366	SP	9285	Jardim Ferreira Dias	Jd F Dias
20367	SP	9285	Jardim Ibirapuera	Jd Ibirapuera
20368	SP	9285	Jardim Itamarati	Jd Itamarati
20369	SP	9285	Jardim Jorge Atalla	Jd J Atalla
20370	SP	9285	Jardim Maria Cibele	Jd M Cibele
20371	SP	9285	Jardim Maria Luiza I	Jd M Luiza I
20372	SP	9285	Jardim Netinho Prado	Jd N Prado
20503	SP	9295	Jardim Copacabana	Jd Copacabana
20504	SP	9295	Corrupira	\N
20505	SP	9295	Jardim Cristina	Jd Cristina
20506	SP	9295	Jardim da Fonte	Jd Fonte
20507	SP	9295	Jardim da Serra	Jd Serra
20508	SP	9295	Jardim Danúbio	Jd Danúbio
20509	SP	9295	Jardim das Carpas	Jd Carpas
20510	SP	9295	Jardim das Orquídeas	Jd Orquídeas
20511	SP	9295	Jardim das Samambaias	Jd Samambaias
20512	SP	9295	Jardim das Tulipas	Jd Tulipas
20513	SP	9295	Jardim do Lago	Jd Lago
20514	SP	9295	Jardim do Lírio	Jd Lírio
20515	SP	9295	Jardim Dom Bosco	Jd D Bosco
20516	SP	9295	Jardim Dona Donata	Jd Da Donata
20517	SP	9295	Jardim Dupre	Jd Dupre
20518	SP	9295	Jardim Ermida I	Jd Ermida I
20519	SP	9295	Jardim Ermida II	Jd Ermida II
20520	SP	9295	Jardim Esplanada	Jd Esplanada
20521	SP	9295	Jardim Estádio	Jd Estádio
20522	SP	9295	Jardim Europa	Jd Europa
20523	SP	9295	Jardim Florestal	Jd Florestal
20524	SP	9295	Jardim Flórida	Jd Flórida
20525	SP	9295	Jardim Guanabara	Jd Guanabara
20526	SP	9295	Jardim Guarani	Jd Guarani
20528	SP	9295	Jardim Itália	Jd Itália
20529	SP	9295	Jardim Itamarati	Jd Itamarati
20532	SP	9295	Jardim Liberdade	Jd Liberdade
20533	SP	9295	Jardim Luciana	Jd Luciana
20534	SP	9295	Jardim Marco Leite	Jd M Leite
20535	SP	9295	Jardim Martins	Jd Martins
20536	SP	9295	Jardim Merci I	Jd Merci I
20537	SP	9295	Jardim Messina	Jd Messina
20540	SP	9295	Jardim Molinari	Jd Molinari
20541	SP	9295	Jardim Morumbi	Jd Morumbi
20543	SP	9295	Jardim Novo Mundo	Jd N Mundo
20544	SP	9295	Jardim Pacaembu	Jd Pacaembu
20546	SP	9295	Jardim Paris	Jd Paris
20547	SP	9295	Jardim Paulista II	Jd Paulista II
20548	SP	9295	Jardim Petrópolis	Jd Petrópolis
20549	SP	9295	Jardim Pitangueiras I	Jd Pitangueiras I
20550	SP	9295	Jardim Planalto	Jd Planalto
20551	SP	9295	Jardim Primavera	Jd Primavera
20552	SP	9295	Jardim Quintas das Videiras	Jd Qtas Videiras
20554	SP	9295	Jardim Roma	Jd Roma
20555	SP	9295	Jardim Rosaura	Jd Rosaura
20556	SP	9295	Jardim Sagrado Coração de Jesus	Jd S C Jesus
20557	SP	9295	Jardim Sales	Jd Sales
20559	SP	9295	Jardim Santa Adelaide	Jd Sta Adelaide
20560	SP	9295	Jardim Santa Gertrudes	Jd Sta Gertrudes
20561	SP	9295	Jardim Santa Júlia	Jd Sta Júlia
20628	SP	9295	Vila Aielo	Vl Aielo
20630	SP	9295	Vila Alvorada	Vl Alvorada
20631	SP	9295	Vila Ana	Vl Ana
20632	SP	9295	Vila Angélica	Vl Angélica
20633	SP	9295	Vila Aparecida	Vl Aparecida
20634	SP	9295	Vila Arens I	Vl Arens I
20635	SP	9295	Vila Argos Nova	Vl A Nova
20636	SP	9295	Vila Argos Velha	Vl A Velha
20637	SP	9295	Vila Bandeirantes	Vl Bandeirantes
20638	SP	9295	Vila Bela I	Vl Bela I
20639	SP	9295	Vila Bela II	Vl Bela II
20640	SP	9295	Vila Bernardes	Vl Bernardes
20641	SP	9295	Vila Boaventura	Vl Boaventura
20642	SP	9295	Vila Cacilda	Vl Cacilda
20643	SP	9295	Vila Campos Sales	Vl C Sales
20644	SP	9295	Vila Caodáglio	Vl Caodáglio
20645	SP	9295	Vila Comercial	Vl Comercial
20646	SP	9295	Vila Cristo Redentor	Vl C Redentor
20647	SP	9295	Vila Cunha	Vl Cunha
20648	SP	9295	Núcleo Residencial Dom Gabriel Paulino Bueno Couto	Nuc Res D G P B Couto
20649	SP	9295	Vila das Hortências	Vl Hortências
20650	SP	9295	Vila de Vito	Vl Vito
20651	SP	9295	Vila Didi	Vl Didi
20653	SP	9295	Vila Esperança	Vl Esperança
20654	SP	9295	Vila Formosa	Vl Formosa
20655	SP	9295	Vila Francisco Eber	Vl F Eber
20657	SP	9295	Vila Galvão	Vl Galvão
20658	SP	9295	Vila Garcia	Vl Garcia
20659	SP	9295	Vila Gotardo	Vl Gotardo
20660	SP	9295	Vila Graff	Vl Graff
20661	SP	9295	Vila Guarani	Vl Guarani
20662	SP	9295	Vila Guilherme	Vl Guilherme
20663	SP	9295	Vila Helena	Vl Helena
20664	SP	9295	Vila Hortolândia	Vl Hortolândia
20665	SP	9295	Vila Inhamupe	Vl Inhamupe
20667	SP	9295	Vila Isabel Eber	Vl I Eber
20669	SP	9295	Vila Japi I	Vl Japi I
20670	SP	9295	Vila Joana	Vl Joana
20671	SP	9295	Vila Joaquina	Vl Joaquina
20672	SP	9295	Vila Josefina	Vl Josefina
20673	SP	9295	Vila Jundiainópolis	Vl Jundiainópolis
20674	SP	9295	Vila Lacerda	Vl Lacerda
20675	SP	9295	Vila Liberdade	Vl Liberdade
20676	SP	9295	Vila Loureiro	Vl Loureiro
20677	SP	9295	Vila Loyola	Vl Loyola
20678	SP	9295	Vila M Genoveva	Vl M Genoveva
20679	SP	9295	Vila Mafalda	Vl Mafalda
20680	SP	9295	Vila Manfredi	Vl Manfredi
20681	SP	9295	Vila Margarida	Vl Margarida
20682	SP	9295	Vila Maria Luiza	Vl M Luiza
20683	SP	9295	Vila Maringá	Vl Maringá
20684	SP	9295	Vila Marlene	Vl Marlene
20685	SP	9295	Vila Militar	Vl Militar
20752	SP	9315	Jardim Adelina	Jd Adelina
20753	SP	9315	Jardim Alvorada	Jd Alvorada
20754	SP	9315	Jardim Amália	Jd Amália
20755	SP	9315	Jardim Ariana	Jd Ariana
20757	SP	9315	Jardim Bonsucesso	Jd Bonsucesso
20758	SP	9315	Jardim Capitólio	Jd Capitólio
20759	SP	9315	Jardim Coloninha Cláudia	Jd C Cláudia
20760	SP	9315	Jardim do Bosque	Jd Bosque
20761	SP	9315	Jardim Eloísa	Jd Eloísa
20762	SP	9315	Jardim Eroísi	Jd Eroísi
20763	SP	9315	Jardim Governador	Jd Governador
20764	SP	9315	Jardim Isabel Cristina	Jd I Cristina
20765	SP	9315	Jardim Juana	Jd Juana
20766	SP	9315	Jardim Lívia	Jd Lívia
20767	SP	9315	Jardim Nova Era	Jd N Era
20768	SP	9315	Jardim Nova Granada	Jd N Granada
20769	SP	9315	Jardim Nova Leme	Jd N Leme
20770	SP	9315	Jardim Nova Santa Rita	Jd N Sta Rita
20771	SP	9315	Jardim Novo Horizonte	Jd N Horizonte
20772	SP	9315	Jardim Palmeiras	Jd Palmeiras
20773	SP	9315	Jardim Presidente	Jd Presidente
20774	SP	9315	Jardim Primavera	Jd Primavera
20775	SP	9315	Jardim Primavera - Gover	Jd Primavera - Gover
20776	SP	9315	Jardim Residencial Saulo	Jd Res Saulo
20777	SP	9315	Jardim Santa Inês	Jd Sta Inês
20779	SP	9315	Jardim Santa Paula	Jd Sta Paula
20780	SP	9315	Jardim Santa Rita	Jd Sta Rita
20781	SP	9315	Jardim Santana	Jd Santana
20782	SP	9315	Jardim São Francisco	Jd S Francisco
20783	SP	9315	Taquari Ponte	T Ponte
20784	SP	9315	Jardim São José	Jd S José
20786	SP	9315	Jardim Vanessa	Jd Vanessa
20787	SP	9315	Jardim Vila Verde	Jd Vl Verde
20788	SP	9315	Jardim Vista Alegre	Jd V Alegre
20789	SP	9315	Loteamento Grossklauss	Lot Grossklauss
20790	SP	9315	Loteamento Tufanin	Lot Tufanin
20791	SP	9315	Morada Sol	M Sol
20792	SP	9315	Parque Residencial Itamaraty	Prq Res Itamaraty
20793	SP	9315	Parque São Manoel	Prq S Manoel
20794	SP	9315	Quinta do Vale Verde	Qta Vle Verde
20795	SP	9315	Recanto da Colina	Rec Colina
20796	SP	9315	Recanto do Sol	Rec Sol
20797	SP	9315	Retiro Velho	Rer Velho
20799	SP	9315	Vila Bancária	Vl Bancária
20800	SP	9315	Vila Bela Vista	Vl B Vista
20802	SP	9315	Vila Bom Jesus	Vl B Jesus
20803	SP	9315	Vila Hilsdorf	Vl Hilsdorf
20804	SP	9315	Vila Joest	Vl Joest
20805	SP	9315	Vila Nova	Vl Nova
20806	SP	9315	Vila Rauter	Vl Rauter
20871	SP	9316	Vila Antonieta I	Vl Antonieta I
20872	SP	9316	Vila Antonieta II	Vl Antonieta II
20873	SP	9316	Vila Baccili	Vl Baccili
20874	SP	9316	Vila Cachoeirinha	Vl Cachoeirinha
20875	SP	9316	Vila Contente	Vl Contente
20876	SP	9316	Vila Éden	Vl Éden
20877	SP	9316	Vila Irerê	Vl Irerê
20878	SP	9316	Vila Maestra Amélia	Vl M Amélia
20879	SP	9316	Vila Mamedina	Vl Mamedina
20881	SP	9316	Vila Marimbondo	Vl Marimbondo
20882	SP	9316	Vila Nossa Senhora Aparecida	Vl N Sra Aparecida
20883	SP	9316	Vila Nova Irerê	Vl N Irerê
20884	SP	9316	Vila Paccola	Vl Paccola
20885	SP	9316	Vila Repke	Vl Repke
20886	SP	9316	Vila Santa Cecília	Vl Sta Cecília
20888	SP	9316	Vila São Judas Tadeu	Vl S J Tadeu
20889	SP	9316	Vila Virgílio Capoani	Vl V Capoani
20890	SP	9317	Boa Vista	B Vista
20891	SP	9317	Centro	\N
20892	SP	9317	Chácara Antonieta	Ch Antonieta
20894	SP	9317	Chácara Boa Vista da Graminha	Ch B V Graminha
20898	SP	9317	Chácara São José	Ch S José
20901	SP	9317	Conjunto Residencial Victor D'Andrea	Cj Res V D'Andrea
20906	SP	9317	Gleba Beatriz	G Beatriz
20908	SP	9317	Jardim Adélia Cavicchia Grotta	Jd A C Grotta
20910	SP	9317	Jardim Alvorada	Jd Alvorada
20912	SP	9317	Jardim Anhangüera	Jd Anhangüera
20913	SP	9317	Jardim Aquárius	Jd Aquárius
20914	SP	9317	Jardim Arruda	Jd Arruda
20916	SP	9317	Jardim Bandeirantes	Jd Bandeirantes
20917	SP	9317	Jardim Barão de Limeira	Jd Br Limeira
20918	SP	9317	Jardim Barão de Souza Queiroz	Jd Br S Queiroz
20919	SP	9317	Jardim Bartolomeu Grotta	Jd B Grotta
20920	SP	9317	Jardim Bela Vista	Jd Bela Vista
20921	SP	9317	Jardim Boa Esperança	Jd B Esperança
20922	SP	9317	Jardim Boa Vista	Jd B Vista
20923	SP	9317	Jardim Brasil	Jd Brasil
20924	SP	9317	Jardim Caieira	Jd Caieira
20925	SP	9317	Jardim Cavinato	Jd Cavinato
20926	SP	9317	Jardim Celina	Jd Celina
20928	SP	9317	Jardim Colina Verde	Jd C Verde
20929	SP	9317	Jardim Colinas de São João	Jd C S João
20931	SP	9317	Jardim Colonial	Jd Colonial
20932	SP	9317	Jardim Consoli	Jd Consoli
20933	SP	9317	Jardim da Graminha	Jd Graminha
20934	SP	9317	Jardim Desmembramento Fiorino Torrezan	Jd D F Torrezan
20935	SP	9317	Jardim do Lago	Jd Lago
20992	SP	9317	Jardim Residencial Granja Machado	Jd Res Gja Machado
20993	SP	9317	Jardim Residencial Recanto Alvorada	Jd Res Rec Alvorada
20994	SP	9317	Jardim Residencial Roseira	Jd Res Roseira
20995	SP	9317	Jardim Residencial Santina Paroli Peccinino	Jd Res S P Peccinino
20996	SP	9317	Jardim Residencial Village	Jd Res Village
20997	SP	9317	Jardim Rossi	Jd Rossi
20998	SP	9317	Jardim Santa Bárbara	Jd Sta Bárbara
20999	SP	9317	Jardim Santa Catarina	Jd Sta Catarina
21000	SP	9317	Jardim Santa Cecília	Jd Sta Cecília
21001	SP	9317	Jardim Santa Eulália	Jd Sta Eulália
21002	SP	9317	Jardim Santa Fé	Jd Sta Fé
21003	SP	9317	Jardim Santa Lina	Jd Sta Lina
21005	SP	9317	Jardim Santa Luiza	Jd Sta Luiza
21006	SP	9317	Jardim Santana	Jd Santana
21007	SP	9317	Jardim Santo André	Jd Sto André
21008	SP	9317	Jardim São Francisco	Jd S Francisco
21009	SP	9317	Jardim São João	Jd S João
21010	SP	9317	Jardim São Luiz	Jd S Luiz
21011	SP	9317	Jardim São Manoel	Jd S Manoel
21012	SP	9317	Jardim São Paulo	Jd S Paulo
21013	SP	9317	Jardim São Pedro	Jd S Pedro
21014	SP	9317	Jardim São Rafael	Jd S Rafael
21015	SP	9317	Jardim São Roque	Jd S Roque
21016	SP	9317	Jardim São Simão	Jd S Simão
21017	SP	9317	Jardim Senador Vergueiro	Jd Sen Vergueiro
21018	SP	9317	Jardim Sol a Sol	Jd S A Sol
21022	SP	9317	Jardim Terras de Santa Elisa	Jd T Sta Elisa
21023	SP	9317	Jardim Trevo	Jd Trevo
21024	SP	9317	Jardim Vanessa	Jd Vanessa
21025	SP	9317	Jardim Vista Alegre	Jd V Alegre
21026	SP	9317	ANAVEC	\N
21027	SP	9317	Parque Campos Elíseos	Prq C Elíseos
21028	SP	9317	Parque Centreville	Prq Centreville
21029	SP	9317	Parque das Nações	Prq Nações
21030	SP	9317	Parque Egisto Ragazzo	Prq E Ragazzo
21031	SP	9317	Parque Expedicionário Hipólito	Prq Exp Hipólito
21032	SP	9317	Parque Hipólyto	Prq Hipólyto
21033	SP	9317	Parque Nossa Senhora das Dores	Prq N Sra Dores
21034	SP	9317	Parque Novo Mundo	Prq N Mundo
21035	SP	9317	Parque Real	Prq Real
21036	SP	9317	Parque Residencial Abílio Pedro	Prq Res A Pedro
21037	SP	9317	Parque Residencial Aeroporto	Prq Res Aeroporto
21038	SP	9317	Parque Residencial Independência	Prq Res Independência
21105	SP	9319	Conjunto Habitacional Paulo Freire	Cj Hab P Freire
21106	SP	9319	Conjunto Habitacional Teisuke Kumassaka	Cj Hab T Kumassaka
21107	SP	9319	Garcia	\N
21108	SP	9319	Jardim Aeroporto	Jd Aeroporto
21109	SP	9319	Jardim Alvorada	Jd Alvorada
21111	SP	9319	Jardim Americano	Jd Americano
21112	SP	9319	Jardim Arapuã	Jd Arapuã
21113	SP	9319	Jardim Ariano	Jd Ariano
21114	SP	9319	Jardim Bandeirantes	Jd Bandeirantes
21115	SP	9319	Jardim Bela Vista	Jd B Vista
21116	SP	9319	Jardim Bom Viver I	Jd B Viver I
21117	SP	9319	Jardim Bom Viver II	Jd B Viver II
21118	SP	9319	Jardim Bom Viver III	Jd B Viver III
21119	SP	9319	Jardim Bom Viver IV	Jd B Viver IV
21120	SP	9319	Jardim Campestre	Jd Campestre
21121	SP	9319	Jardim Eldorado	Jd Eldorado
21123	SP	9319	Jardim Guanabara	Jd Guanabara
21124	SP	9319	Jardim Leoni	Jd Leoni
21125	SP	9319	Jardim Linense	Jd Linense
21126	SP	9319	Jardim Marabá	Jd Marabá
21127	SP	9319	Jardim Paraíso	Jd Paraíso
21128	SP	9319	Jardim Pinheiro	Jd Pinheiro
21129	SP	9319	Jardim Primavera	Jd Primavera
21130	SP	9319	Jardim Santa Clara	Jd Sta Clara
21131	SP	9319	Jardim Santa Maria	Jd Sta Maria
21132	SP	9319	Jardim Santuário de Fátima	Jd S Fátima
21133	SP	9319	Jardim São Francisco da Boa Vista	Jd S F B Vista
21135	SP	9319	Jardim São Luiz	Jd S Luiz
21136	SP	9319	Jardim São Roque	Jd S Roque
21137	SP	9319	Jardim São Vicente	Jd S Vicente
21138	SP	9319	Jardim Tangará	Jd Tangará
21139	SP	9319	Jardim Tropical	Jd Tropical
21140	SP	9319	Jardim União	Jd União
21142	SP	9319	Junqueira	\N
21143	SP	9319	Labaté	\N
21144	SP	9319	Núcleo Habitacional Monsenhor Pasetto	Nuc Hab Mns Pasetto
21145	SP	9319	Núcleo Habitacional Ulisses Guimarães	Nuc Hab U Guimarães
21147	SP	9319	Parque Aeroporto	Prq Aeroporto
21148	SP	9319	Parque Alto da Boa Vista	Prq At B Vista
21149	SP	9319	Parque Alto de Fátima	Prq At Fátima
21150	SP	9319	Parque das Oficinas	Prq Oficinas
21151	SP	9319	Parque Empresarial Rolande Alves Pereira	Prq E R A Pereira
21152	SP	9319	Parque Ferroviário	Prq Ferroviário
21153	SP	9319	Parque Industrial	Prq Industrial
21154	SP	9319	Parque Industrial Mário Sebelin	Prq Ind M Sebelin
21155	SP	9319	Parque São Jorge	Prq S Jorge
20807	SP	9315	Vila Santa Maria	Vl Sta Maria
20809	SP	9315	Vila Santucci	Vl Santucci
20810	SP	9315	Vila São João	Vl S João
20811	SP	9315	Vila São Jorge	Vl S Jorge
20812	SP	9315	Vila Sumaré	Vl Sumaré
20813	SP	9315	Vila Terezinha	Vl Terezinha
20815	SP	9315	Vila Zarif	Vl Zarif
20816	SP	9316	Centro	\N
20819	SP	9316	Chácaras Santo Antônio	C Sto Antônio
20820	SP	9316	Conjunto Habitacional Corvo Branco	Cj Hab C Branco
20821	SP	9316	Conjunto Habitacional Lençóis Paulista	Cj Hab L Paulista
20822	SP	9316	Conjunto Habitacional Maestro Júlio Ferrari	Cj Hab Mto J Ferrari
20823	SP	9316	Conjunto Habitacional Paraíso	Cj Hab Paraíso
20824	SP	9316	Conjunto Sílvio Campanholi	Cj S Campanholi
20825	SP	9316	Distrito Industrial II Luiz Trecenti	Dt Ind II L Trecenti
20829	SP	9316	Jardim Alvorada	Jd Alvorada
20830	SP	9316	Jardim América	Jd América
20834	SP	9316	Jardim Cruzeiro	Jd Cruzeiro
20835	SP	9316	Jardim da Prata	Jd Prata
20836	SP	9316	Jardim das Nações	Jd Nações
20837	SP	9316	Jardim do Caju I	Jd Caju I
20838	SP	9316	Jardim Granville	Jd Granville
20839	SP	9316	Jardim Humaitá	Jd Humaitá
20840	SP	9316	Jardim Ipê	Jd Ipê
20841	SP	9316	Jardim Itamaraty	Jd Itamaraty
20842	SP	9316	Jardim Itapuã	Jd Itapuã
20843	SP	9316	Jardim Lago da Prata	Jd Lg Prata
20844	SP	9316	Jardim Monte Azul	Jd Mte Azul
20845	SP	9316	Jardim Morumbi	Jd Morumbi
20846	SP	9316	Jardim Nova Lençóis	Jd N Lençóis
20847	SP	9316	Jardim Primavera	Jd Primavera
20848	SP	9316	Jardim Príncipe	Jd Príncipe
20849	SP	9316	Jardim São João	Jd S João
20850	SP	9316	Jardim Ubirama	Jd Ubirama
20852	SP	9316	Jardim Village	Jd Village
20858	SP	9316	Núcleo Habitacional Bela Vista I	Nuc Hab B Vista I
20859	SP	9316	Núcleo Habitacional Bela Vista II	Nuc Hab B Vista II
20860	SP	9316	Núcleo Habitacional João Zillo	Nuc Hab J Zillo
20861	SP	9316	Núcleo Habitacional Luis Zillo	Nuc Hab L Zillo
20862	SP	9316	Parque Antártica	Prq Antártica
20863	SP	9316	Parque Residencial Elizabeth	Prq Res Elizabeth
20866	SP	9316	Parque Residencial Rondon	Prq Res Rondon
20867	SP	9316	Parque Residencial São José	Prq Res S José
20870	SP	9316	Sítio Recreio São Judas Thadeu	Sit Rcr S J Thadeu
20936	SP	9317	Jardim Doutor João Batista Levy	Jd Dr J B Levy
20938	SP	9317	Jardim Elite	Jd Elite
20939	SP	9317	Jardim Esmeralda	Jd Esmeralda
20940	SP	9317	Jardim Esteves	Jd Esteves
20941	SP	9317	Jardim Florença	Jd Florença
20942	SP	9317	Jardim Glória	Jd Glória
20943	SP	9317	Jardim Gustavo Picinini	Jd G Picinini
20944	SP	9317	Jardim Hortência	Jd Hortência
20945	SP	9317	Jardim Ibirapuera	Jd Ibirapuera
20946	SP	9317	Jardim Ipiranga	Jd Ipiranga
20948	SP	9317	Jardim Itapoã	Jd Itapoã
20951	SP	9317	Jardim Lago Azul	Jd Lg Azul
20952	SP	9317	Jardim Laranjeiras	Jd Laranjeiras
20953	SP	9317	Jardim Manoel Francisco	Jd M Francisco
20954	SP	9317	Jardim Maria Buchi Modeneis	Jd M B Modeneis
20955	SP	9317	Jardim Maria Flora	Jd M Flora
20956	SP	9317	Jardim Maria Helena	Jd M Helena
20957	SP	9317	Jardim Mediterrâneo	Jd Mediterrâneo
20958	SP	9317	Jardim Mercedes	Jd Mercedes
20959	SP	9317	Jardim Monte Carlo	Jd Mte Carlo
20960	SP	9317	Jardim Montezuma	Jd Montezuma
20961	SP	9317	Jardim Morro Azul	Jd Mro Azul
20962	SP	9317	Jardim Morro Branco	Jd Mro Branco
20963	SP	9317	Jardim Nereide	Jd Nereide
20964	SP	9317	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
20965	SP	9317	Jardim Nossa Senhora do Amparo	Jd N Sra Amparo
20966	SP	9317	Jardim Nova Europa	Jd N Europa
20967	SP	9317	Jardim Nova Itália	Jd N Itália
20968	SP	9317	Jardim Nova Limeira	Jd N Limeira
20969	SP	9317	Jardim Nova Suíça	Jd N Suíça
20970	SP	9317	Jardim Novo Horizonte	Jd N Horizonte
20971	SP	9317	Jardim Odécio Degan	Jd O Degan
20972	SP	9317	Jardim Olga Veroni	Jd Olga Veroni
20974	SP	9317	Jardim Orestes Veroni	Jd O Veroni
20975	SP	9317	Jardim Ouro Branco	Jd O Branco
20976	SP	9317	Jardim Ouro Verde	Jd O Verde
20978	SP	9317	Jardim Parque Avenida	Jd Prq Avenida
20980	SP	9317	Jardim Paulista	Jd Paulista
20981	SP	9317	Jardim Pérola	Jd Pérola
20982	SP	9317	Jardim Piratininga	Jd Piratininga
20984	SP	9317	Jardim Planalto	Jd Planalto
20985	SP	9317	Jardim Portal das Rosas	Jd P Rosas
20986	SP	9317	Jardim Presidente Dutra	Jd Pres Dutra
20988	SP	9317	Jardim Residencial Alto da Capela	Jd Res At Capela
20991	SP	9317	Jardim Residencial Flora	Jd Res Flora
21039	SP	9317	Parque Residencial João Ometto	Prq Res J Ometto
21040	SP	9317	Parque Residencial Manoel Simão Levy	Prq Res M S Levy
21041	SP	9317	Parque Residencial Sthalberg	Prq Res Sthalberg
21042	SP	9317	Parque Residencial Tancredo Neves	Prq Res T Neves
21043	SP	9317	Parque Rosa Marrafon Lucas	Prq R M Lucas
21044	SP	9317	Parque São Bento	Prq S Bento
21046	SP	9317	Residencial Antônio Brigato	Res A Brigato
21047	SP	9317	Tatu	\N
21048	SP	9317	Vila Anita	Vl Anita
21049	SP	9317	Vila Bragotto	Vl Bragotto
21051	SP	9317	Vila Camargo	Vl Camargo
21052	SP	9317	Vila Castelar	Vl Castelar
21053	SP	9317	Vila Cidade Jardim	Vl C Jardim
21054	SP	9317	Vila Claudia	Vl Claudia
21056	SP	9317	Vila Conceição	Vl Conceição
21057	SP	9317	Vila Cristóvam	Vl Cristóvam
21058	SP	9317	Vila da Glória	Vl Glória
21059	SP	9317	Vila Eliza Fumagalli	Vl E Fumagalli
21060	SP	9317	Vila Esteves	Vl Esteves
21061	SP	9317	Vila Fascina	Vl Fascina
21065	SP	9317	Vila Gioto	Vl Gioto
21068	SP	9317	Vila Independência	Vl Independência
21069	SP	9317	Vila Labaki	Vl Labaki
21070	SP	9317	Vila Limeirânea	Vl Limeirânea
21072	SP	9317	Vila Mathias	Vl Mathias
21073	SP	9317	Vila Nova	Vl Nova
21074	SP	9317	Vila Paraíso	Vl Paraíso
21075	SP	9317	Vila Paulista	Vl Paulista
21077	SP	9317	Vila Piza	Vl Piza
21078	SP	9317	Vila Primavera	Vl Primavera
21079	SP	9317	Vila Queiroz	Vl Queiroz
21080	SP	9317	Vila Rocha	Vl Rocha
21081	SP	9317	Vila Rosana	Vl Rosana
21082	SP	9317	Vila San Marino	Vl S Marino
21085	SP	9317	Vila Santa Josefa	Vl Sta Josefa
21086	SP	9317	Vila Santa Lina	Vl Sta Lina
21087	SP	9317	Vila Santa Rosália	Vl Sta Rosália
21090	SP	9317	Vila São Geraldo	Vl S Geraldo
21091	SP	9317	Vila São João	Vl S João
21092	SP	9317	Vila São Luiz	Vl S Luiz
21094	SP	9317	Vila São Roque	Vl S Roque
21095	SP	9317	Vila Solar	Vl Solar
21098	SP	9317	Vila Teixeira Marques	Vl T Marques
21099	SP	9319	Centro	\N
21100	SP	9319	Chácara Flora	Ch Flora
21101	SP	9319	Chácara Iracema	Ch Iracema
21102	SP	9319	Conjunto Habitacional Ana Carolina	Cj Hab A Carolina
21103	SP	9319	Conjunto Habitacional Francisco José de Oliveira Ratto	Cj Hab F J O Ratto
21104	SP	9319	Conjunto Habitacional José Dias dos Santos	Cj Hab J D Santos
21156	SP	9319	Parque Xingu	Prq Xingu
21157	SP	9319	Rebouças	\N
21158	SP	9319	Residencial dos Comerciários	Res Comerciários
21159	SP	9319	Residencial Florestan Fernandes	Res F Fernandes
21160	SP	9319	Residencial Fortaleza	Res Fortaleza
21161	SP	9319	Residencial Henrique Bertin	Res H Bertin
21163	SP	9319	Residencial Jardim do Sol	Res Jd Sol
21164	SP	9319	Residencial Jardim Paineiras	Res Jd Paineiras
21165	SP	9319	Residencial Manabu Mabe	Res M Mabe
21166	SP	9319	Residencial Morumbi	Res Morumbi
21167	SP	9319	Residencial Santa Lúcia	Res Sta Lúcia
21168	SP	9319	Ribeiro	\N
21169	SP	9319	Vila Alta	Vl Alta
21171	SP	9319	Vila América	Vl América
21173	SP	9319	Vila Anchieta	Vl Anchieta
21174	SP	9319	Vila Azevedo	Vl Azevedo
21175	SP	9319	Vila Bela Vista	Vl B Vista
21177	SP	9319	Vila Cinquentenário da Imigração Japonesa	Vl C I Japonesa
21178	SP	9319	Vila Clélia	Vl Clélia
21180	SP	9319	Vila Ester	Vl Ester
21181	SP	9319	Vila Guararapes	Vl Guararapes
21182	SP	9319	Vila Irmãos Andrade	Vl Imos Andrade
21183	SP	9319	Vila José Mendes	Vl J Mendes
21184	SP	9319	Vila Mafalda	Vl Mafalda
21185	SP	9319	Vila Marussig	Vl Marussig
21186	SP	9319	Vila Militar	Vl Militar
21188	SP	9319	Vila Pacini	Vl Pacini
21189	SP	9319	Vila Parque das Américas	Vl Prq Américas
21190	SP	9319	Vila Paulista	Vl Paulista
21191	SP	9319	Vila Perin	Vl Perin
21192	SP	9319	Vila Ramalho	Vl Ramalho
21194	SP	9319	Vila Santa Terezinha	Vl Sta Terezinha
21195	SP	9319	Vila São Benedito	Vl S Benedito
21196	SP	9319	Vila São Francisco	Vl S Francisco
21197	SP	9319	Vila São João	Vl S João
21198	SP	9319	Vila São José	Vl S José
21200	SP	9321	Cabelinha	\N
21203	SP	9321	Centro	\N
21204	SP	9321	Cidade Industrial	C Industrial
21205	SP	9321	Cruz	\N
21211	SP	9321	Jardim Margarida	Jd Margarida
21213	SP	9321	Jardim Novo Horizonte	Jd N Horizonte
21216	SP	9321	Nova Lorena	N Lorena
21217	SP	9321	Olaria	\N
21218	SP	9321	Parque das Rodovias	Prq Rodovias
21219	SP	9321	Parque Mondesir	Prq Mondesir
21223	SP	9321	Santo Antônio	Sto Antônio
21225	SP	9321	Vila Brito	Vl Brito
21229	SP	9321	Vila Cristina	Vl Cristina
21232	SP	9321	Vila Esperança	Vl Esperança
21233	SP	9321	Vila Fabiano	Vl Fabiano
21235	SP	9321	Vila Geny	Vl Geny
21303	SP	9348	Jardim Continental	Jd Continental
21304	SP	9348	Jardim Cristo Rei	Jd C Rei
21305	SP	9348	Jardim Damasco I	Jd Damasco I
21306	SP	9348	Jardim Damasco II	Jd Damasco II
21307	SP	9348	Jardim Pérola	Jd Pérola
21308	SP	9348	Jardim Dirceu	Jd Dirceu
21309	SP	9348	Jardim Domingos de Léo	Jd D Léo
21310	SP	9348	Jardim dos Lírios	Jd Lírios
21311	SP	9348	Jardim Eldorado	Jd Eldorado
21312	SP	9348	Jardim Esplanada	Jd Esplanada
21313	SP	9348	Jardim Estoril	Jd Estoril
21314	SP	9348	Jardim Europa	Jd Europa
21315	SP	9348	Jardim Flamingo	Jd Flamingo
21316	SP	9348	Jardim Flora Rica	Jd F Rica
21318	SP	9348	Jardim Fontanelli	Jd Fontanelli
21319	SP	9348	Jardim Guarujá	Jd Guarujá
21320	SP	9348	Jardim Ipanema	Jd Ipanema
21321	SP	9348	Jardim Itaipu	Jd Itaipu
21322	SP	9348	Jardim Itamarati	Jd Itamarati
21323	SP	9348	Jardim Jequitibá	Jd Jequitibá
21324	SP	9348	Jardim Lavínia	Jd Lavínia
21325	SP	9348	Jardim Luciana	Jd Luciana
21326	SP	9348	Jardim Marajá	Jd Marajá
21327	SP	9348	Jardim Marajó	Jd Marajó
21329	SP	9348	Jardim Marambaia	Jd Marambaia
21330	SP	9348	Jardim Maria Izabel	Jd M Izabel
21331	SP	9348	Jardim Maria Martha	Jd M Martha
21332	SP	9348	Jardim Marília	Jd Marília
21333	SP	9348	Jardim Monte Castelo	Jd Mte Castelo
21334	SP	9348	Jardim Morumbi	Jd Morumbi
21335	SP	9348	Jardim Nacional	Jd Nacional
21336	SP	9348	Jardim Nazareth	Jd Nazareth
21337	SP	9348	Jardim Ohara	Jd Ohara
21339	SP	9348	Jardim Paraíso	Jd Paraíso
21340	SP	9348	Jardim Parati	Jd Parati
21342	SP	9348	Jardim Planalto	Jd Planalto
21343	SP	9348	Jardim Polyana	Jd Polyana
21344	SP	9348	Jardim Portal do Sol	Jd P Sol
21345	SP	9348	Jardim Presidente	Jd Presidente
21346	SP	9348	Jardim Progresso	Jd Progresso
21347	SP	9348	Jardim Riviera	Jd Riviera
21348	SP	9348	Jardim Santa Antonieta	Jd Sta Antonieta
21349	SP	9348	Jardim Santa Clara	Jd Sta Clara
21350	SP	9348	Jardim Santa Gertrudes	Jd Sta Gertrudes
21351	SP	9348	Jardim Santa Paula	Jd Sta Paula
21352	SP	9348	Jardim São Domingos	Jd S Domingos
21353	SP	9348	Jardim São Francisco	Jd S Francisco
21354	SP	9348	Jardim São Gabriel	Jd S Gabriel
21355	SP	9348	Jardim São Geraldo	Jd S Geraldo
21356	SP	9348	Jardim São Vicente de Paulo	Jd S V Paulo
21401	SP	9348	Parque dos Ipês	Prq Ipês
21402	SP	9348	Parque Nova Almeida	Prq N Almeida
21403	SP	9348	Parque Residencial Julieta	Prq Res Julieta
21404	SP	9348	Parque Residencial Novo Horizonte	Prq Res N Horizonte
21405	SP	9348	Parque Residencial Santa Gertrudes	Prq Res Sta Gertrudes
21406	SP	9348	Parque São Jorge	Prq S Jorge
21407	SP	9348	Parque Serra Dourada	Prq S Dourada
21408	SP	9348	Paulista	\N
21409	SP	9348	Pólon	\N
21410	SP	9348	Professor Antônio da Silva Penteado	Prf A S Penteado
21411	SP	9348	Professor José Augusto da Silva Ribeiro	Prf J A S Ribeiro
21412	SP	9348	Professora Liliana de Sousa Gonzaga	Prfa L S Gonzaga
21413	SP	9348	Quarto Centenário	Q Centenário
21414	SP	9348	Realengo	\N
21415	SP	9348	Residencial de Recreio Maria Izabel	Res Rcr M Izabel
21416	SP	9348	Residencial Vale Verde	Res Vle Verde
21418	SP	9348	Rodolfo da Silva Costa	R S Costa
21420	SP	9348	Saliola	\N
21421	SP	9348	Santa Lourdes	Sta Lourdes
21422	SP	9348	Santa Olívia	Sta Olívia
21423	SP	9348	Santa Tereza	Sta Tereza
21424	SP	9348	São João	S João
21425	SP	9348	São José	S José
21427	SP	9348	São Miguel	S Miguel
21428	SP	9348	São Paulo	S Paulo
21429	SP	9348	Senador Salgado Filho	Sen S Filho
21430	SP	9348	Sítios de Recreio Céu Azul	S Rcr C Azul
21431	SP	9348	Sítios de Recreio Cinquentenário	S Rcr Cinquentenário
21432	SP	9348	Sítios de Recreio Morada do Sol	S Rcr M Sol
21433	SP	9348	Sítios de Recreio Nascimento	S Rcr Nascimento
21434	SP	9348	Sítios de Recreio Panambi	S Rcr Panambi
21435	SP	9348	Sítios de Recreio Portal do Vale	S Rcr P Vale
21436	SP	9348	Sítios de Recreio Recanto dos Nobres	S Rcr Rec Nobres
21437	SP	9348	Sítios de Recreio Santa Carolina	S Rcr Sta Carolina
21438	SP	9348	Sítios de Recreio Santa Gertrudes	S Rcr Sta Gertrudes
21439	SP	9348	Somenzari	\N
21440	SP	9348	Souza	\N
21441	SP	9348	Thereza Bassan de Argollo Ferrão	T B A Ferrão
21443	SP	9348	Vila Coimbra	Vl Coimbra
21444	SP	9348	Vila Maria	Vl Maria
21445	SP	9348	Vila Operária Alimentação I	Vl O Alimentação I
21446	SP	9348	Vila Operária Alimentação II	Vl O Alimentação II
21447	SP	9348	Vila Real	Vl Real
21448	SP	9348	Vila Romana	Vl Romana
21449	SP	9354	Alto	\N
21450	SP	9354	Bela Vista	\N
21516	SP	9355	Jardim Cruzeiro	Jd Cruzeiro
21517	SP	9355	Jardim Esperança	Jd Esperança
21518	SP	9355	Jardim Estrela	Jd Estrela
21519	SP	9355	Jardim Guapituba	Jd Guapituba
21520	SP	9355	Jardim Haydee	Jd Haydee
21521	SP	9355	Jardim Ipê	Jd Ipê
21522	SP	9355	Jardim Itapark	Jd Itapark
21523	SP	9355	Jardim Itapark Novo	Jd I Novo
21524	SP	9355	Jardim Itapeva	Jd Itapeva
21526	SP	9355	Jardim Luzitano	Jd Luzitano
21527	SP	9355	São João	S João
21528	SP	9355	Jardim Maringá	Jd Maringá
21529	SP	9355	Jardim Mauá	Jd Mauá
21530	SP	9355	Jardim Miranda D'Aviz	Jd M D'Aviz
21531	SP	9355	Jardim Olinda	Jd Olinda
21533	SP	9355	Jardim Paranavaí	Jd Paranavaí
21534	SP	9355	Jardim Paulista	Jd Paulista
21535	SP	9355	Jardim Pedroso	Jd Pedroso
21536	SP	9355	Jardim Pilar	Jd Pilar
21537	SP	9355	Jardim Planalto	Jd Planalto
21538	SP	9355	Jardim Primavera	Jd Primavera
21539	SP	9355	Jardim Quarto Centenário	Jd Q Centenário
21540	SP	9355	Jardim Rosina	Jd Rosina
21541	SP	9355	Jardim Sampaio Vidal	Jd S Vidal
21542	SP	9355	Jardim Santa Lídia	Jd Sta Lídia
21543	SP	9355	Jardim Santista	Jd Santista
21544	SP	9355	Jardim São Francisco	Jd S Francisco
21545	SP	9355	Jardim São Gabriel	Jd S Gabriel
21546	SP	9355	Jardim São Jorge do Guapituba	Jd S J Guapituba
21547	SP	9355	Jardim São José	Jd S José
21548	SP	9355	Jardim São Judas	Jd S Judas
21549	SP	9355	Jardim São Lucas	Jd S Lucas
21550	SP	9355	Jardim São Sebastião	Jd S Sebastião
21551	SP	9355	Jardim Sílvia Maria	Jd S Maria
21552	SP	9355	Jardim Sônia Maria	Jd Sônia Maria
21553	SP	9355	Jardim Taquarussu	Jd Taquarussu
21554	SP	9355	Jardim Zaira	Jd Zaira
21555	SP	9355	Matriz	\N
21556	SP	9355	Parque Alvorada	Prq Alvorada
21557	SP	9355	Parque Bandeirantes	Prq Bandeirantes
21558	SP	9355	Parque Boa Esperança	Prq B Esperança
21559	SP	9355	Parque das Américas	Prq Américas
21560	SP	9355	Parque São Vicente	Prq S Vicente
21562	SP	9355	Vila América	Vl América
21563	SP	9355	Vila Ana Maria	Vl A Maria
21564	SP	9355	Vila Assis Brasil	Vl A Brasil
21565	SP	9355	Vila Augusto	Vl Augusto
21566	SP	9355	Vila Bocaina	Vl Bocaina
21567	SP	9355	Vila Carlina	Vl Carlina
21568	SP	9355	Vila Correia	Vl Correia
21569	SP	9355	Vila Dirce	Vl Dirce
21623	SP	9368	Mocoquinha	\N
21624	SP	9368	Núcleo Habitacional Nenê Pereira Lima	Nuc Hab N P Lima
21626	SP	9368	Vila Carvalho	Vl Carvalho
21627	SP	9368	Vila Lambari	Vl Lambari
21628	SP	9368	Vila Maria	Vl Maria
21629	SP	9368	Vila Mariana	Vl Mariana
21630	SP	9368	Vila Naufel	Vl Naufel
21631	SP	9368	Vila Quintino	Vl Quintino
21632	SP	9368	Vila Santa Cruz	Vl Sta Cruz
21633	SP	9368	Vila Santa Rosa	Vl Sta Rosa
21634	SP	9369	Alto da Boa Vista	At B Vista
21635	SP	9369	Alto Ipiranga	At Ipiranga
21636	SP	9369	Botujuru	\N
21637	SP	9369	Braz Cubas	B Cubas
21638	SP	9369	Carmo	\N
21639	SP	9369	Centro	\N
21640	SP	9369	Centro Cívico	C Cívico
21641	SP	9369	Cézar de Souza	C Souza
21642	SP	9369	Chácara Cruzeiro do Sul	Ch C Sul
21643	SP	9369	Chácara das Flores	Ch Flores
21644	SP	9369	Chácara Olaria	Ch Olaria
21645	SP	9369	Conjunto Habitacional Ana Paula	Cj Hab A Paula
21646	SP	9369	Conjunto Habitacional Antônio Bovolenta	Cj Hab A Bovolenta
21647	SP	9369	Conjunto Habitacional Brás Cubas	Cj Hab B Cubas
21648	SP	9369	Conjunto Habitacional São Sebastião	Cj Hab S Sebastião
21649	SP	9369	Conjunto Habitacional Taysa	Cj Hab Taysa
21650	SP	9369	Conjunto Residencial Álvaro Bovolenta	Cj Res A Bovolenta
21651	SP	9369	Conjunto Residencial Cocuera	Cj Res Cocuera
21652	SP	9369	Conjunto Residencial do Bosque	Cj Res Bosque
21653	SP	9369	Conjunto Residencial Nova Bertioga	Cj Res N Bertioga
21654	SP	9369	Conjunto Residencial Santo Ângelo	Cj Res Sto Ângelo
21655	SP	9369	Jardim Aeroporto I	Jd Aeroporto I
21656	SP	9369	Jardim Aeroporto II	Jd Aeroporto II
21657	SP	9369	Jardim Aeroporto III	Jd Aeroporto III
21658	SP	9369	Jardim Apolo	Jd Apolo
21659	SP	9369	Jardim Aracy	Jd Aracy
21660	SP	9369	Jardim Armênia	Jd Armênia
21661	SP	9369	Jardim Assunta	Jd Assunta
21662	SP	9369	Jardim Avenida	Jd Avenida
21663	SP	9369	Jardim Bela Vista	Jd B Vista
21664	SP	9369	Jardim Betânia	Jd Betânia
21665	SP	9369	Jardim Camila	Jd Camila
21666	SP	9369	Jardim Cecília	Jd Cecília
21667	SP	9369	Jardim Cintia	Jd Cintia
21668	SP	9369	Jardim Coqueiro	Jd Coqueiro
21669	SP	9369	Jardim das Acácias	Jd Acácias
21670	SP	9369	Jardim das Bandeiras	Jd Bandeiras
21671	SP	9369	Jardim das Cerejeiras	Jd Cerejeiras
21236	SP	9321	Vila Hepacare	Vl Hepacare
21239	SP	9321	Vila Neide	Vl Neide
21241	SP	9321	Vila Nunes	Vl Nunes
21242	SP	9321	Vila Passos	Vl Passos
21244	SP	9321	Vila Santa Edwiges	Vl Sta Edwiges
21247	SP	9321	Vila São Roque	Vl S Roque
21248	SP	9321	Vila Simão	Vl Simão
21250	SP	9321	Ypê	\N
21251	SP	9348	Altaneira	\N
21252	SP	9348	Alto Cafezal	At Cafezal
21254	SP	9348	Ana Carla	A Carla
21255	SP	9348	Banzato	\N
21256	SP	9348	Barbosa	\N
21257	SP	9348	Barros	\N
21258	SP	9348	Bassan	\N
21259	SP	9348	Betel	\N
21260	SP	9348	Boa Vista	B Vista
21261	SP	9348	Bosque	\N
21262	SP	9348	Canaã	\N
21263	SP	9348	Cascata	\N
21264	SP	9348	Cavalieri	\N
21265	SP	9348	Centro	\N
21266	SP	9348	César de Almeida	C Almeida
21267	SP	9348	Chácara Eliana	Ch Eliana
21268	SP	9348	Chácara dos Laranjais	Ch Laranjais
21269	SP	9348	Chácara São Carlos	Ch S Carlos
21271	SP	9348	Conjunto Habitacional Monsenhor João Batista Toffoli	Cj Hab Mns J B Toffoli
21272	SP	9348	Conjunto Habitacional Paulo Lúcio Nogueira	Cj Hab P L Nogueira
21273	SP	9348	Conjunto Habitacional Vila dos Comerciários I	Cj Hab Vl Comerciários I
21275	SP	9348	Conjunto Residencial Alcir Raineri	Cj Res A Raineri
21276	SP	9348	Conjunto Residencial Luiz Egydio de Cerqueira César	Cj Res L E C César
21277	SP	9348	Distrito Industrial	Dt Industrial
21278	SP	9348	Distrito Industrial Santo Barion	Dt Ind Sto Barion
21279	SP	9348	Fragata	\N
21280	SP	9348	Francisco de Abreu Fernandes	F A Fernandes
21282	SP	9348	Higienópolis	\N
21283	SP	9348	Hípica Paulista	H Paulista
21284	SP	9348	Jardim Acapulco	Jd Acapulco
21285	SP	9348	Jardim Adolpho Bim	Jd A Bim
21286	SP	9348	Jardim Aeroporto	Jd Aeroporto
21287	SP	9348	Jardim Altos da Cidade	Jd A Cidade
21288	SP	9348	Jardim Alvorada	Jd Alvorada
21290	SP	9348	Jardim América	Jd América
21291	SP	9348	Jardim Aparecida Nasser	Jd A Nasser
21292	SP	9348	Jardim Aquárius	Jd Aquárius
21293	SP	9348	Jardim Araxá	Jd Araxá
21294	SP	9348	Jardim Bancários	Jd Bancários
21295	SP	9348	Jardim Bandeirantes	Jd Bandeirantes
21296	SP	9348	Jardim Betânia	Jd Betânia
21298	SP	9348	Jardim Califórnia	Jd Califórnia
21299	SP	9348	Jardim Casadei	Jd Casadei
21300	SP	9348	Jardim Cavallari	Jd Cavallari
21301	SP	9348	Jardim Colibri	Jd Colibri
21357	SP	9348	Jardim Sasazaki	Jd Sasazaki
21359	SP	9348	Jardim Teotônio Vilela	Jd T Vilela
21360	SP	9348	Jardim Tropical	Jd Tropical
21361	SP	9348	Jardim Universitário	Jd Universitário
21362	SP	9348	Jardim Virgínia	Jd Virgínia
21363	SP	9348	Jardim Vista Alegre	Jd V Alegre
21364	SP	9348	Jardim Vitória	Jd Vitória
21365	SP	9348	Jóquei Clube	J Clube
21366	SP	9348	Lorenzetti	\N
21368	SP	9348	Luiz Homero Zaninotto	L H Zaninotto
21369	SP	9348	Maria Paula	M Paula
21370	SP	9348	Mariana	\N
21371	SP	9348	Marília	\N
21372	SP	9348	Mirante	\N
21373	SP	9348	Montolar	\N
21374	SP	9348	Núcleo Habitacional Alcides Matiuzzi	Nuc Hab A Matiuzzi
21375	SP	9348	Núcleo Habitacional Castelo Branco	Nuc Hab C Branco
21376	SP	9348	Núcleo Habitacional Cecap	Nuc Hab Cecap
21377	SP	9348	Núcleo Habitacional Chico Mendes	Nuc Hab C Mendes
21378	SP	9348	Núcleo Habitacional Costa e Silva	Nuc Hab C E Silva
21379	SP	9348	Núcleo Habitacional Doutor Aniz Badra	Nuc Hab Dr A Badra
21380	SP	9348	Núcleo Habitacional Doutor Fernando Mauro Pires Rocha	Nuc Hab Dr F M P Rocha
21381	SP	9348	Núcleo Habitacional Eliana Dias Mota	Nuc Hab E D Mota
21382	SP	9348	Núcleo Habitacional Helena Bernardes	Nuc Hab H Bernardes
21383	SP	9348	Núcleo Habitacional Jardim Bela Vista	Nuc Hab Jd B Vista
21384	SP	9348	Núcleo Habitacional José Teruel Martinez	Nuc Hab J T Martinez
21385	SP	9348	Núcleo Habitacional Juscelino Kubitschek	Nuc Hab J Kubitschek
21386	SP	9348	Núcleo Habitacional Maria Angélica Matos	Nuc Hab M A Matos
21387	SP	9348	Núcleo Habitacional Nova Marília	Nuc Hab N Marília
21388	SP	9348	Núcleo Habitacional Presidente Jânio da Silva Quadros	Nuc Hab Pres J S Quadros
21389	SP	9348	Palmeira	\N
21390	SP	9348	Palmital	\N
21391	SP	9348	Parque Cecap Aeroporto	Prq C Aeroporto
21392	SP	9348	Parque das Acácias	Prq Acácias
21393	SP	9348	Parque das Azaléias	Prq Azaléias
21395	SP	9348	Parque das Esmeraldas	Prq Esmeraldas
21396	SP	9348	Parque das Esmeraldas II	Prq Esmeraldas II
21397	SP	9348	Parque das Indústrias	Prq Indústrias
21398	SP	9348	Parque das Nações	Prq Nações
21399	SP	9348	Parque das Primaveras	Prq Primaveras
21400	SP	9348	Parque das Vivendas	Prq Vivendas
21451	SP	9354	Boa Vista	B Vista
21452	SP	9354	Bussola	\N
21453	SP	9354	Centro	\N
21454	SP	9354	Conjunto Residencial João Vital	Cj Res J Vital
21455	SP	9354	Distrito Industrial Adolfo Baldan	Dt Ind A Baldan
21457	SP	9354	IV Centenário	\N
21458	SP	9354	Jardim Aeroporto	Jd Aeroporto
21459	SP	9354	Residencial Monte Carlo	Res Mte Carlo
21460	SP	9354	Jardim Alvorada	Jd Alvorada
21461	SP	9354	Jardim Ballista	Jd Ballista
21462	SP	9354	Jardim Brasil	Jd Brasil
21463	SP	9354	Jardim Buscardi	Jd Buscardi
21464	SP	9354	Residencial das Acácias	Res Acácias
21467	SP	9354	Jardim do Bosque	Jd Bosque
21468	SP	9354	Jardim Itália	Jd Itália
21469	SP	9354	Jardim Morumbi	Jd Morumbi
21473	SP	9354	Jardim Paraíso	Jd Paraíso
21474	SP	9354	Jardim Paraíso II	Jd Paraíso II
21475	SP	9354	Jardim Paraíso III	Jd Paraíso III
21476	SP	9354	Jardim Pereira	Jd Pereira
21477	SP	9354	Jardim Popular	Jd Popular
21478	SP	9354	Jardim Primavera	Jd Primavera
21479	SP	9354	Jardim Santa Rosa	Jd Sta Rosa
21480	SP	9354	Jardim São José	Jd S José
21481	SP	9354	Jardim Cambuí	Jd Cambuí
21483	SP	9354	Nova Cidade	N Cidade
21484	SP	9354	Nova Matão	N Matão
21485	SP	9354	Park Aliança	P Aliança
21486	SP	9354	Park do Imperador	P Imperador
21487	SP	9354	Recanto dos Pinheiros	Rec Pinheiros
21490	SP	9354	Residencial Olivio Benassi	Res O Benassi
21493	SP	9354	Silvania	\N
21494	SP	9354	Parque Industrial Toriba	Prq Ind Toriba
21495	SP	9354	Vila Cardim	Vl Cardim
21496	SP	9354	Vila Guarani	Vl Guarani
21497	SP	9354	Vila Jandira	Vl Jandira
21498	SP	9354	Vila Maria	Vl Maria
21499	SP	9354	Vila Mariani	Vl Mariani
21501	SP	9354	Vila Santa Cruz	Vl Sta Cruz
21502	SP	9354	Vivelândia	\N
21503	SP	9355	Alto da Boa Vista	At B Vista
21504	SP	9355	Capuava	\N
21505	SP	9355	Jardim Adelina	Jd Adelina
21506	SP	9355	Jardim Anchieta	Jd Anchieta
21507	SP	9355	Jardim Araguaia	Jd Araguaia
21508	SP	9355	Jardim Bela Vista	Jd B Vista
21509	SP	9355	Jardim Bógus	Jd Bógus
21510	SP	9355	Jardim Bom Recanto	Jd B Recanto
21511	SP	9355	Jardim Camila	Jd Camila
21512	SP	9355	Jardim Campo Verde	Jd Cpo Verde
21513	SP	9355	Jardim Canadá	Jd Canadá
21514	SP	9355	Jardim Coimbra	Jd Coimbra
21515	SP	9355	Jardim Columbia	Jd Columbia
21570	SP	9355	Vila Emílio	Vl Emílio
21571	SP	9355	Vila Falchi	Vl Falchi
21572	SP	9355	Vila Feital	Vl Feital
21573	SP	9355	Vila Flórida	Vl Flórida
21574	SP	9355	Vila Guarani	Vl Guarani
21575	SP	9355	Vila Independência	Vl Independência
21576	SP	9355	Vila Isabel	Vl Isabel
21577	SP	9355	Vila João Ramalho	Vl J Ramalho
21578	SP	9355	Vila Lisboa	Vl Lisboa
21579	SP	9355	Vila Magini	Vl Magini
21580	SP	9355	Vila Mercedes	Vl Mercedes
21581	SP	9355	Vila Morelli	Vl Morelli
21582	SP	9355	Vila Noêmia	Vl Noêmia
21583	SP	9355	Vila Nossa Senhora das Vitórias	Vl N Sra Vitórias
21584	SP	9355	Vila Nova Mauá	Vl N Mauá
21585	SP	9355	Vila Pereira	Vl Pereira
21586	SP	9355	Vila Santa Cecília	Vl Sta Cecília
21587	SP	9355	Vila Santa Rosa	Vl Sta Rosa
21588	SP	9355	Vila São Francisco	Vl S Francisco
21589	SP	9355	Vila Sonia	Vl Sonia
21590	SP	9355	Vila Tavares	Vl Tavares
21591	SP	9368	Aparecida	\N
21592	SP	9368	Brás	\N
21593	SP	9368	Cecap I	\N
21594	SP	9368	Cecap II	\N
21595	SP	9368	Centro	\N
21596	SP	9368	Chácara Bela Vista	Ch B Vista
21597	SP	9368	Chácara do Vale	Ch Vale
21598	SP	9368	Conjunto Habitacional Gabriel do Ó	Cj Hab G do Ó
21599	SP	9368	Conjunto Habitacional Gilberto Rossetti	Cj Hab G Rossetti
21600	SP	9368	Conjunto Habitacional Luiz Fernandes Dias	Cj Hab L F Dias
21601	SP	9368	Descanso	\N
21602	SP	9368	Distrito Industrial I	Dt Industrial I
21603	SP	9368	Distrito Industrial II	Dt Industrial II
21604	SP	9368	Jardim Alvorada	Jd Alvorada
21605	SP	9368	Jardim Bianchesi	Jd Bianchesi
21606	SP	9368	Jardim Chico Piscina	Jd C Piscina
21607	SP	9368	Jardim Gatolândia	Jd Gatolândia
21608	SP	9368	Jardim Lavínia	Jd Lavínia
21610	SP	9368	Jardim Morro Azul	Jd Mro Azul
21611	SP	9368	Jardim Nova Mococa	Jd N Mococa
21612	SP	9368	Jardim Primavera	Jd Primavera
21614	SP	9368	Jardim Residencial do Bosque	Jd Res Bosque
21615	SP	9368	Jardim Riachuelo	Jd Riachuelo
21616	SP	9368	Jardim Rigobelo	Jd Rigobelo
21617	SP	9368	Jardim Santa Cecília	Jd Sta Cecília
21618	SP	9368	Jardim Santa Clara	Jd Sta Clara
21619	SP	9368	Jardim Santa Maria	Jd Sta Maria
21620	SP	9368	Jardim São Domingos	Jd S Domingos
21621	SP	9368	Jardim São Francisco	Jd S Francisco
21622	SP	9368	Jardim São Luiz	Jd S Luiz
21672	SP	9369	Jardim Doutora Liliana	Jd Dra Liliana
21673	SP	9369	Jardim Esperança	Jd Esperança
21674	SP	9369	Jardim Esplanada	Jd Esplanada
21675	SP	9369	Jardim Ivete	Jd Ivete
21676	SP	9369	Jardim Juliana	Jd Juliana
21677	SP	9369	Jardim Jussara	Jd Jussara
21678	SP	9369	Jardim Layr	Jd Layr
21679	SP	9369	Jardim Marica	Jd Marica
21680	SP	9369	Jardim Modelo	Jd Modelo
21681	SP	9369	Jardim Mogi	Jd Mogi
21682	SP	9369	Jardim Náutico	Jd Náutico
21683	SP	9369	Jardim Paulista	Jd Paulista
21684	SP	9369	Jardim Pavão	Jd Pavão
21685	SP	9369	Jardim Planalto	Jd Planalto
21686	SP	9369	Jardim Ponte Grande	Jd Pte Grande
21687	SP	9369	Jardim Real	Jd Real
21688	SP	9369	Jardim Rodeio	Jd Rodeio
21689	SP	9369	Jardim Rubi	Jd Rubi
21690	SP	9369	Jardim Santa Carolina	Jd Sta Carolina
21691	SP	9369	Jardim Santa Teresa	Jd Sta Teresa
21692	SP	9369	Jardim Santista	Jd Santista
21693	SP	9369	Jardim Santos Dumont	Jd Stos Dumont
21694	SP	9369	Jardim Santos Dumont I	Jd Stos Dumont I
21695	SP	9369	Jardim Santos Dumont II	Jd Stos Dumont II
21696	SP	9369	Jardim Santos Dumont III	Jd Stos Dumont III
21697	SP	9369	Jardim São Francisco	Jd S Francisco
21698	SP	9369	Jardim São Jorge	Jd S Jorge
21699	SP	9369	Jardim São Pedro	Jd S Pedro
21700	SP	9369	Jardim Universo	Jd Universo
21701	SP	9369	Jardim Veneza	Jd Veneza
21702	SP	9369	Jundiapeba	\N
21703	SP	9369	Lagoa Seca	Lga Seca
21704	SP	9369	Loteamento Acrísio de Oliveira Silva	Lot A O Silva
21705	SP	9369	Loteamento Jardim Primavera	Lot Jd Primavera
21706	SP	9369	Loteamento Mogilar	Lot Mogilar
21707	SP	9369	Loteamento Morumbi	Lot Morumbi
21708	SP	9369	Loteamento Municipal Brás Cubas	Lot M B Cubas
21709	SP	9369	Loteamento Yotsu Tobisawa	Lot Y Tobisawa
21710	SP	9369	Mogi das Cruzes	M Cruzes
21711	SP	9369	Parque Monte Líbano	Prq Mte Líbano
21712	SP	9369	Parque Morumbi	Prq Morumbi
21713	SP	9369	Parque Ponte Grande	Prq Pte Grande
21714	SP	9369	Parque Residencial Itapeti	Prq Res Itapeti
21715	SP	9369	Parque Santana	Prq Santana
21716	SP	9369	Rio Baixo	R Baixo
21717	SP	9369	Sabaúna	\N
21718	SP	9369	Taiaçupeba	\N
21719	SP	9369	Vila Andrade	Vl Andrade
21720	SP	9369	Vila Áurea Maria	Vl A Maria
21721	SP	9369	Vila Avignon	Vl Avignon
21776	SP	9369	Vila São Paulo	Vl S Paulo
21777	SP	9369	Vila São Sebastião	Vl S Sebastião
21778	SP	9369	Vila Sarah	Vl Sarah
21779	SP	9369	Vila Sarah Avignon	Vl S Avignon
21780	SP	9369	Vila Silva	Vl Silva
21782	SP	9369	Vila Socorro Velho	Vl S Velho
21784	SP	9369	Vila Stella	Vl Stella
21785	SP	9369	Vila Sud Menuci	Vl S Menuci
21786	SP	9369	Vila Suissa	Vl Suissa
21787	SP	9369	Vila Tietê	Vl Tietê
21788	SP	9369	Vila Vitória	Vl Vitória
21789	SP	9369	Volta Fria	V Fria
21790	SP	9370	Areião	\N
21791	SP	9370	Arruamento Primavera	A Primavera
21792	SP	9370	Capela	\N
21793	SP	9370	Centro	\N
21794	SP	9370	Chácara do Ouro	Ch Ouro
21795	SP	9370	Chácara Gonçalo	Ch Gonçalo
21796	SP	9370	Chácara Nova Odessa	Ch N Odessa
21797	SP	9370	Chácara São João	Ch S João
21799	SP	9370	Desmembramento Furno	D Furno
21800	SP	9370	Desmembramento Kamel II	D Kamel II
21801	SP	9370	Desmembramento Santana	D Santana
21802	SP	9370	Distrito Industrial I	Dt Industrial I
21803	SP	9370	Distrito Industrial II	Dt Industrial II
21804	SP	9370	Distrito Industrial III	Dt Industrial III
21805	SP	9370	Imóvel Olho D'Agua	I O D'Agua
21806	SP	9370	Imóvel Pedregulhal	I Pedregulhal
21807	SP	9370	Jardim Almira	Jd Almira
21808	SP	9370	Jardim Alvorada	Jd Alvorada
21809	SP	9370	Jardim América	Jd América
21810	SP	9370	Jardim Artigiane	Jd Artigiane
21811	SP	9370	Jardim Bandeirantes	Jd Bandeirantes
21812	SP	9370	Jardim Bela Vista	Jd Bela Vista
21813	SP	9370	Jardim Brasília	Jd Brasília
21814	SP	9370	Jardim Califórnia	Jd Califórnia
21815	SP	9370	Jardim Camargo	Jd Camargo
21817	SP	9370	Jardim Casa Grande	Jd C Grande
21818	SP	9370	Jardim Centenário	Jd Centenário
21819	SP	9370	Jardim Chiorato	Jd Chiorato
21820	SP	9370	Jardim Cristina	Jd Cristina
21821	SP	9370	Jardim Cruzeiro	Jd Cruzeiro
21822	SP	9370	Jardim da Lagoa	Jd Lagoa
21823	SP	9370	Jardim Duas Nascentes	Jd D Nascentes
21824	SP	9370	Jardim Esplanada	Jd Esplanada
21825	SP	9370	Jardim Fantinato	Jd Fantinato
21826	SP	9370	Jardim Guaçu-Mirim I	Jd Guaçu-Mirim I
21827	SP	9370	Jardim Guaçu-Mirim II	Jd Guaçu-Mirim II
21828	SP	9370	Jardim Guaçu-Mirim III	Jd Guaçu-Mirim III
21829	SP	9370	Jardim Guadalajara	Jd Guadalajara
21830	SP	9370	Jardim Hedy	Jd Hedy
21831	SP	9370	Jardim Horizonte	Jd Horizonte
21832	SP	9370	Jardim Igaçaba	Jd Igaçaba
21833	SP	9370	Jardim Iguatemi	Jd Iguatemi
21834	SP	9370	Jardim Ipê I	Jd Ipê I
21835	SP	9370	Jardim Ipê II	Jd Ipê II
21836	SP	9370	Jardim Ipê III	Jd Ipê III
21837	SP	9370	Jardim Ipê IV	Jd Ipê IV
21838	SP	9370	Jardim Ipê Pinheiro	Jd I Pinheiro
21839	SP	9370	Jardim Itacolomi	Jd Itacolomi
21840	SP	9370	Jardim Itamaraty	Jd Itamaraty
21841	SP	9370	Jardim Jacira	Jd Jacira
21842	SP	9370	Jardim Maria Mendes	Jd M Mendes
21843	SP	9370	Jardim Munhoz	Jd Munhoz
21844	SP	9370	Jardim Murilo	Jd Murilo
21845	SP	9370	Jardim Nossa Senhora das Graças	Jd N Sra Graças
21846	SP	9370	Jardim Nova Europa	Jd N Europa
21847	SP	9370	Jardim Novo I	Jd Novo I
21848	SP	9370	Jardim Novo II	Jd Novo II
21849	SP	9370	Jardim Novo Itacolomi	Jd N Itacolomi
21850	SP	9370	Jardim Paulista	Jd Paulista
21851	SP	9370	Jardim Planalto	Jd Planalto
21852	SP	9370	Jardim Planalto Verde	Jd P Verde
21853	SP	9370	Jardim Presidente	Jd Presidente
21854	SP	9370	Jardim Progresso	Jd Progresso
21855	SP	9370	Jardim Rosa Cruz	Jd R Cruz
21856	SP	9370	Jardim Samira	Jd Samira
21857	SP	9370	Jardim Santa Helena	Jd Sta Helena
21858	SP	9370	Jardim Santa Madalena	Jd Sta Madalena
21859	SP	9370	Jardim Santa Maria I	Jd Sta Maria I
21860	SP	9370	Jardim Santa Maria II	Jd Sta Maria II
21861	SP	9370	Jardim Santa Terezinha	Jd Sta Terezinha
21862	SP	9370	Jardim Santa Terezinha II	Jd Sta Terezinha II
21863	SP	9370	Jardim Santo André	Jd Sto André
21864	SP	9370	Jardim Santo Antônio	Jd Sto Antônio
21865	SP	9370	Jardim São Francisco	Jd S Francisco
21866	SP	9370	Jardim São Luiz	Jd S Luiz
21868	SP	9370	Jardim São Pedro	Jd S Pedro
21869	SP	9370	Jardim Selma	Jd Selma
21870	SP	9370	Jardim Serra Dourada	Jd S Dourada
21871	SP	9370	Jardim Slest	Jd Slest
21872	SP	9370	Jardim Soares	Jd Soares
21873	SP	9370	Jardim Sonia	Jd Sonia
21874	SP	9370	Jardim Tabajara	Jd Tabajara
21875	SP	9370	Jardim Zaniboni I	Jd Zaniboni I
21876	SP	9370	Parque Residencial Zaniboni II	Prq Res Zaniboni II
21877	SP	9370	Lote	\N
21878	SP	9370	Loteamento Cidade Nova Mogi-Guaçu	Lot C N Mogi-Guaçu
21879	SP	9370	Loteamento Coloninha	Lot Coloninha
21941	SP	9371	Jardim Getúlio Vargas	Jd G Vargas
21942	SP	9371	Jardim Guaçu-Mirim	Jd Guaçu-Mirim
21943	SP	9371	Jardim Guarnieri	Jd Guarnieri
21944	SP	9371	Jardim Helena	Jd Helena
21945	SP	9371	Jardim Itapema	Jd Itapema
21946	SP	9371	Jardim Lago	Jd Lago
21947	SP	9371	Jardim Longatto	Jd Longatto
21949	SP	9371	Jardim Maria Antonieta	Jd M Antonieta
21950	SP	9371	Jardim Maria Beatriz	Jd M Beatriz
21951	SP	9371	Jardim Maria Bonati Bordignon	Jd M B Bordignon
21955	SP	9371	Jardim Nazareth	Jd Nazareth
21956	SP	9371	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
21958	SP	9371	Jardim Panorama	Jd Panorama
21959	SP	9371	Jardim Paulista	Jd Paulista
21960	SP	9371	Jardim Pissinatti	Jd Pissinatti
21961	SP	9371	Jardim Planalto	Jd Planalto
21962	SP	9371	Jardim Planalto Mirim	Jd P Mirim
21963	SP	9371	Jardim Santa Clara	Jd Sta Clara
21964	SP	9371	Jardim Santa Cruz	Jd Sta Cruz
21965	SP	9371	Jardim Santa Helena	Jd Sta Helena
21966	SP	9371	Jardim São Víctor	Jd S Víctor
21967	SP	9371	Jardim Sbeghen	Jd Sbeghen
21968	SP	9371	Jardim Scomparim	Jd Scomparim
21969	SP	9371	Jardim Silvania	Jd Silvania
21970	SP	9371	Jardim Tropical	Jd Tropical
21971	SP	9371	Jardim 31 de Março	Jd 31 Março
21972	SP	9371	Loteamento Dionízio Linares	Lot D Linares
21973	SP	9371	Loteamento INOCOOP	Lot INOCOOP
21975	SP	9371	Loteamento Irmãos Zani	Lot Imos Zani
21976	SP	9371	Loteamento Nova Mogi	Lot N Mogi
21977	SP	9371	Jardim Santa Ana	Jd Sta Ana
21978	SP	9371	Loteamento São Jerônimo	Lot S Jerônimo
21981	SP	9371	Mirante	\N
21983	SP	9371	Nova Mogi	N Mogi
21984	SP	9371	Parque da Imprensa	Prq Imprensa
21985	SP	9371	Parque da Empresa	Prq Empresa
21986	SP	9371	Parque Esperança	Prq Esperança
21987	SP	9371	Parque do Estado II	Prq Estado II
21988	SP	9371	Parque das Laranjeiras	Prq Laranjeiras
21989	SP	9371	Portal Luiza	P Luiza
21990	SP	9371	Parque Novacoop	Prq Novacoop
21991	SP	9371	Planalto Bela Vista	P B Vista
21992	SP	9371	Santa Cruz	Sta Cruz
21993	SP	9371	Saúde	\N
21996	SP	9371	Tucura	\N
21997	SP	9371	Vila Bianchi	Vl Bianchi
21998	SP	9371	Vila Bordignon	Vl Bordignon
21999	SP	9371	Vila Dias	Vl Dias
22000	SP	9371	Vila Eunice	Vl Eunice
22001	SP	9371	Vila Melo	Vl Melo
21722	SP	9369	Vila Bela Flor	Vl B Flor
21723	SP	9369	Vila Bela Vista	Vl B Vista
21724	SP	9369	Vila Bernadotti	Vl Bernadotti
21725	SP	9369	Vila Brás Cubas	Vl B Cubas
21726	SP	9369	Vila Brasileira	Vl Brasileira
21727	SP	9369	Vila Caputera	Vl Caputera
21728	SP	9369	Vila Cardoso	Vl Cardoso
21729	SP	9369	Vila Cecília	Vl Cecília
21730	SP	9369	Vila Celeste	Vl Celeste
21731	SP	9369	Vila Chinesa	Vl Chinesa
21732	SP	9369	Vila Cidinha	Vl Cidinha
21733	SP	9369	Vila Cintra	Vl Cintra
21734	SP	9369	Vila Cléo	Vl Cléo
21735	SP	9369	Vila Doutora Liliana	Vl Dra Liliana
21736	SP	9369	Vila Eugênia	Vl Eugênia
21737	SP	9369	Vila Flávio	Vl Flávio
21738	SP	9369	Vila Hélio	Vl Hélio
21739	SP	9369	Vila Horizonte	Vl Horizonte
21740	SP	9369	Vila Industrial	Vl Industrial
21741	SP	9369	Vila Ipiranga	Vl Ipiranga
21743	SP	9369	Vila Jundiaí	Vl Jundiaí
21744	SP	9369	Vila Lavínia	Vl Lavínia
21745	SP	9369	Vila Martins	Vl Martins
21746	SP	9369	Vila Mathias	Vl Mathias
21747	SP	9369	Vila Melchizedec	Vl Melchizedec
21748	SP	9369	Mogi Moderno	M Moderno
21749	SP	9369	Vila Mogilar	Vl Mogilar
21750	SP	9369	Vila Nancy	Vl Nancy
21751	SP	9369	Vila Natal	Vl Natal
21752	SP	9369	Vila Nova Aparecida	Vl N Aparecida
21753	SP	9369	Vila Nova Cintra	Vl N Cintra
21754	SP	9369	Vila Nova Socorro	Vl N Socorro
21755	SP	9369	Vila Oliveira	Vl Oliveira
21756	SP	9369	Vila Partenio	Vl Partenio
21757	SP	9369	Vila Paulicea	Vl Paulicea
21758	SP	9369	Vila Paulista	Vl Paulista
21759	SP	9369	Vila Paulista da Estação	Vl P Estação
21760	SP	9369	Vila Pomar	Vl Pomar
21761	SP	9369	Vila Presidente Wilson	Vl Pres Wilson
21762	SP	9369	Vila Progresso	Vl Progresso
21763	SP	9369	Vila Raicher	Vl Raicher
21764	SP	9369	Vila Ressaca	Vl Ressaca
21765	SP	9369	Vila Rica	Vl Rica
21766	SP	9369	Vila Rachel	Vl Rachel
21767	SP	9369	Vila Rodrigues	Vl Rodrigues
21768	SP	9369	Vila Rubens	Vl Rubens
21769	SP	9369	Vila Sagrado Coração de Maria	Vl S C Maria
21770	SP	9369	Vila Santa Helena	Vl Sta Helena
21771	SP	9369	Vila Santa Teresinha	Vl Sta Teresinha
21772	SP	9369	Vila Santana	Vl Santana
21773	SP	9369	Vila Santo Ângelo	Vl Sto Ângelo
21774	SP	9369	Vila Santo Antônio	Vl Sto Antônio
21775	SP	9369	Vila São Francisco	Vl S Francisco
21880	SP	9370	Loteamento Europa	Lot Europa
21881	SP	9370	Loteamento Morro de Ouro	Lot Mro Ouro
21882	SP	9370	Loteamento Parque do Estado	Lot Prq Estado
21883	SP	9370	Loteamento Parque Itacolomi	Lot Prq Itacolomi
21884	SP	9370	Loteamento Parque Real Guaçu	Lot Prq R Guaçu
21885	SP	9370	Loteamento Portal Flamboyant	Lot P Flamboyant
21886	SP	9370	Parque Cidade Nova	Prq C Nova
21887	SP	9370	Parque Guainco	Prq Guainco
21888	SP	9370	Parque Residencial Cambuí	Prq Res Cambuí
21889	SP	9370	Parque São Camilo	Prq S Camilo
21890	SP	9370	Parque São Luiz	Prq S Luiz
21891	SP	9370	Recanto do Itamaracá	Rec Itamaracá
21892	SP	9370	Vila Beatriz I	Vl Beatriz I
21893	SP	9370	Vila Beatriz II	Vl Beatriz II
21894	SP	9370	Vila Bertioga	Vl Bertioga
21895	SP	9370	Vila Champion	Vl Champion
21896	SP	9370	Vila José de Paula	Vl J Paula
21897	SP	9370	Vila Júlia	Vl Júlia
21898	SP	9370	Vila Leila	Vl Leila
21899	SP	9370	Vila Maria	Vl Maria
21900	SP	9370	Vila Paraíso	Vl Paraíso
21902	SP	9370	Vila Pataro	Vl Pataro
21904	SP	9370	Vila Pinheiro	Vl Pinheiro
21905	SP	9370	Vila Ricci	Vl Ricci
21906	SP	9370	Vila Roberto	Vl Roberto
21907	SP	9370	Vila Santa Júlia	Vl Sta Júlia
21908	SP	9370	Vila Santa Rosa	Vl Sta Rosa
21909	SP	9370	Vila São Carlos	Vl S Carlos
21910	SP	9370	Vila São João	Vl S João
21911	SP	9370	Vila Vasconcelos	Vl Vasconcelos
21912	SP	9371	Aterrado	\N
21916	SP	9371	Centro	\N
21918	SP	9371	Chácara Ipê	Ch Ipê
21919	SP	9371	Chácara São Luiz	Ch S Luiz
21920	SP	9371	Chácara São Marcelo	Ch S Marcelo
21921	SP	9371	Conjunto Residencial Anselmo Lopes Bueno	Cj Res A L Bueno
21922	SP	9371	Garcez	\N
21924	SP	9371	Jardim Alvorada	Jd Alvorada
21925	SP	9371	Jardim América	Jd América
21926	SP	9371	Jardim Áurea	Jd Áurea
21927	SP	9371	Jardim Aurora	Jd Aurora
21928	SP	9371	Jardim Bela Vista	Jd B Vista
21929	SP	9371	Jardim Bi-Centenário	Jd Bi-Centenário
21930	SP	9371	Jardim Brasília	Jd Brasília
21931	SP	9371	Jardim Califórnia	Jd Califórnia
21932	SP	9371	Jardim Carlos Gomes	Jd C Gomes
21934	SP	9371	Jardim Cintra	Jd Cintra
21936	SP	9371	Jardim Copacabana	Jd Copacabana
21937	SP	9371	Jardim Elite	Jd Elite
21938	SP	9371	Jardim Flamboyant	Jd Flamboyant
21939	SP	9371	Jardim Flórida	Jd Flórida
22002	SP	9371	Vila Morani	Vl Morani
22003	SP	9371	Vila Oceania	Vl Oceania
22004	SP	9371	Vila Pichatelli	Vl Pichatelli
22005	SP	9371	Jardim Primavera	Jd Primavera
22006	SP	9371	Vila Rádio	Vl Rádio
22007	SP	9371	Vila Santa Eliza	Vl Sta Eliza
22008	SP	9371	Vila Santa Luzia	Vl Sta Luzia
22009	SP	9371	Vila São João	Vl S João
22010	SP	9371	Vila São José	Vl S José
22011	SP	9371	Vila Universitária	Vl Universitária
22013	SP	9432	Bussocaba	\N
22014	SP	9432	City Bussocaba	C Bussocaba
22015	SP	9432	Centro	\N
22019	SP	9432	Raposo Tavares	R Tavares
22023	SP	9432	Metalúrgicos	\N
22027	SP	9432	I.A.P.I.	\N
22029	SP	9432	Jaguaribe	\N
22030	SP	9432	Adalgisa	\N
22034	SP	9432	Aliança	\N
22039	SP	9432	Baronesa	\N
22040	SP	9432	Bela Vista	B Vista
22044	SP	9432	Bonança	\N
22056	SP	9432	Cipava	\N
22061	SP	9432	Conceição	\N
22062	SP	9432	Jardim D'Abril	Jd D'Abril
22064	SP	9432	Bandeiras	\N
22065	SP	9432	Jardim das Flores	Jd Flores
22071	SP	9432	Jardim Elvira	Jd Elvira
22083	SP	9432	Helena Maria	H Maria
22118	SP	9432	Novo Osasco	N Osasco
22123	SP	9432	Padroeira	\N
22129	SP	9432	Jardim Platina	Jd Platina
22133	SP	9432	Jardim Roberto	Jd Roberto
22137	SP	9432	Santa Maria	Sta Maria
22138	SP	9432	Industrial Anhangüera	Ind Anhangüera
22141	SP	9432	Santo Antônio	Sto Antônio
22161	SP	9432	Três Montanhas	T Montanhas
22163	SP	9432	Veloso	\N
22170	SP	9432	Munhoz Júnior	M Júnior
22171	SP	9432	Mutinga	\N
22173	SP	9432	Continental	\N
22179	SP	9432	Santa Fé	Sta Fé
22181	SP	9432	Piratininga	\N
22182	SP	9432	Portal D'Oeste	P D'Oeste
22183	SP	9432	Presidente Altino	Pres Altino
22184	SP	9432	km 18	\N
22185	SP	9432	Quitaúna	\N
22187	SP	9432	Rochdale	\N
22188	SP	9432	Umuarama	\N
22194	SP	9432	Ayrosa	\N
22198	SP	9432	Vila Campesina	Vl Campesina
22208	SP	9432	Remédios	\N
22225	SP	9432	Vila Menk	Vl Menk
22226	SP	9432	Vila Militar	Vl Militar
22231	SP	9432	Vila Osasco	Vl Osasco
22233	SP	9432	Pestana	\N
22259	SP	9432	Vila Yara	Vl Yara
22260	SP	9432	Vila Yolanda	Vl Yolanda
22261	SP	9435	Centro	\N
22264	SP	9435	Chácaras Bom Retiro	C B Retiro
22266	SP	9435	Chácaras São Silvestre	C S Silvestre
22269	SP	9435	COHAB	\N
22271	SP	9435	Conjunto Habitacional Orlando Quagliato	Cj Hab O Quagliato
22272	SP	9435	Conjunto Habitacional Ourinhos Caiuá	Cj Hab O Caiuá
22323	SP	9435	Jardim São Jorge	Jd S Jorge
22324	SP	9435	Jardim São Judas Tadeu	Jd S J Tadeu
22325	SP	9435	Jardim Tropical	Jd Tropical
22326	SP	9435	Jardim Vale Verde	Jd Vle Verde
22327	SP	9435	Jardim Vista Alegre	Jd V Alegre
22328	SP	9435	Loteamento Angelina Marcante	Lot A Marcante
22330	SP	9435	Loteamento Domingos Garcia	Lot D Garcia
22332	SP	9435	Loteamento Maria Christoni	Lot M Christoni
22333	SP	9435	Loteamento Mitsui	Lot Mitsui
22334	SP	9435	Loteamento Royal Park	Lot R Park
22335	SP	9435	Loteamento São Bento	Lot S Bento
22336	SP	9435	Loteamento Waldomiro Amaral Mello	Lot W A Mello
22337	SP	9435	Nova Ourinhos	N Ourinhos
22338	SP	9435	Núcleo Habitacional Asise Chequer Nicolau	Nuc Hab A C Nicolau
22339	SP	9435	Parque Minas Gerais	Prq M Gerais
22340	SP	9435	Parque Pacheco Chaves	Prq P Chaves
22341	SP	9435	Parque Valeriano Marcante	Prq V Marcante
22342	SP	9435	Residencial Parque Gabriela	Res Prq Gabriela
22343	SP	9435	Vila Adalgisa	Vl Adalgisa
22344	SP	9435	Vila Adélia	Vl Adélia
22345	SP	9435	Vila Boa Esperança	Vl B Esperança
22346	SP	9435	Vila Brasil	Vl Brasil
22347	SP	9435	Vila Califórnia	Vl Califórnia
22348	SP	9435	Vila Christoni	Vl Christoni
22349	SP	9435	Vila Emília	Vl Emília
22350	SP	9435	Vila Kennedy	Vl Kennedy
22351	SP	9435	Vila Mano	Vl Mano
22352	SP	9435	Vila Margarida	Vl Margarida
22353	SP	9435	Vila Moraes	Vl Moraes
22354	SP	9435	Vila Musa	Vl Musa
22355	SP	9435	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
22356	SP	9435	Vila Nova Christoni	Vl N Christoni
22357	SP	9435	Vila Nova Sá	Vl N Sá
22358	SP	9435	Vila Odilon	Vl Odilon
22359	SP	9435	Vila Operária	Vl Operária
22360	SP	9435	Vila Perino	Vl Perino
22361	SP	9435	Vila Recreio	Vl Recreio
22363	SP	9435	Vila Sá	Vl Sá
22364	SP	9435	Vila Sândano	Vl Sândano
22365	SP	9435	Vila Santa Maria	Vl Sta Maria
22366	SP	9435	Vila Santo Antônio	Vl Sto Antônio
22367	SP	9435	Vila Santos Dumont	Vl Stos Dumont
22368	SP	9435	Vila São Francisco	Vl S Francisco
22369	SP	9435	Vila São João	Vl S João
22370	SP	9435	Vila São José	Vl S José
22371	SP	9435	Vila São Luiz	Vl S Luiz
22372	SP	9435	Vila São Silvestre	Vl S Silvestre
22373	SP	9435	Vila Soares	Vl Soares
22374	SP	9435	Vila Vilar	Vl Vilar
22464	SP	9485	Residencial Ouro Verde	Res O Verde
22465	SP	9485	Residencial Pasin	Res Pasin
22466	SP	9485	Residencial Primavera	Res Primavera
22470	SP	9485	Residencial Vale das Acácias	Res Vle Acácias
22472	SP	9485	Ribeirão Grande	R Grande
22473	SP	9485	Santana	\N
22474	SP	9485	São Benedito	S Benedito
22481	SP	9485	Triângulo	\N
22488	SP	9485	Vila Rica	Vl Rica
22491	SP	9485	Vila São Benedito	Vl S Benedito
22492	SP	9485	Vila São João	Vl S João
22495	SP	9493	Água Branca	A Branca
22497	SP	9493	Água Seca	A Seca
22498	SP	9493	Alemães	\N
22499	SP	9493	Alto	\N
22500	SP	9493	Parque Residencial Piracicaba \\"Balbo\\"	Prq Res P \\"Balbo\\"
22501	SP	9493	Bongue	\N
22502	SP	9493	Campestre	\N
22504	SP	9493	Centro	\N
22505	SP	9493	Chácara Esperia	Ch Esperia
22506	SP	9493	Chácara Nazaré	Ch Nazaré
22508	SP	9493	Convívio Bonevie	C Bonevie
22512	SP	9493	Dois Córregos	D Córregos
22515	SP	9493	Garças	\N
22517	SP	9493	Gleba Califórnia	G Califórnia
22519	SP	9493	Glebas Natalinas	G Natalinas
22521	SP	9493	Grande Parque Residencial	G Prq Residencial
22522	SP	9493	Higienópolis	\N
22523	SP	9493	IAA	\N
22525	SP	9493	Jaraguá	\N
22526	SP	9493	Jardim Abaeté	Jd Abaeté
22527	SP	9493	Jardim Algodoal	Jd Algodoal
22528	SP	9493	Jardim Alvorada	Jd Alvorada
22529	SP	9493	Jardim Belvedere	Jd Belvedere
22530	SP	9493	Jardim Boa Esperança	Jd B Esperança
22532	SP	9493	Jardim Brasil	Jd Brasil
22533	SP	9493	Jardim Brasília	Jd Brasília
22534	SP	9493	Jardim Camargo	Jd Camargo
22535	SP	9493	Jardim Castor	Jd Castor
22536	SP	9493	Jardim Caxambu	Jd Caxambu
22538	SP	9493	Jardim Conceição	Jd Conceição
22539	SP	9493	Jardim Costa Rica	Jd C Rica
22541	SP	9493	Jardim Diamante	Jd Diamante
22542	SP	9493	Jardim Dona Luisa	Jd Da Luisa
22543	SP	9493	Jardim dos Antúrios	Jd Antúrios
22544	SP	9493	Jardim Elite	Jd Elite
22545	SP	9493	Jardim Esplanada	Jd Esplanada
22546	SP	9493	Jardim Estoril	Jd Estoril
22548	SP	9493	Jardim Europa	Jd Europa
22549	SP	9493	Jardim Flamboyant	Jd Flamboyant
22550	SP	9493	Jardim Glória	Jd Glória
22552	SP	9493	Jardim Ibirapuera	Jd Ibirapuera
22553	SP	9493	Jardim Ipanema	Jd Ipanema
22555	SP	9493	Jardim Irapuã	Jd Irapuã
22556	SP	9493	Jardim Itamaracá	Jd Itamaracá
22557	SP	9493	Jardim Itamaraty	Jd Itamaraty
22619	SP	9493	Parque São Jorge	Prq S Jorge
22620	SP	9493	Parque Taquaral	Prq Taquaral
22622	SP	9493	Pau Queimado	P Queimado
22623	SP	9493	Paulicéia	\N
22624	SP	9493	Paulista	\N
22626	SP	9493	Piracicamirim	\N
22627	SP	9493	Potiguar	\N
22628	SP	9493	Residencial Eldorado	Res Eldorado
22630	SP	9493	Residencial Paineiras	Res Paineiras
22633	SP	9493	Santa Rita	Sta Rita
22634	SP	9493	Santa Rosa	Sta Rosa
22635	SP	9493	Santa Rosa Ipês	Sta R Ipês
22636	SP	9493	Santa Terezinha	Sta Terezinha
22637	SP	9493	São Dimas	S Dimas
22638	SP	9493	São Judas	S Judas
22639	SP	9493	São Luiz	S Luiz
22641	SP	9493	Unileste	\N
22642	SP	9493	Vale do Sol	Vle Sol
22643	SP	9493	Verde	\N
22644	SP	9493	Vila Areião	Vl Areião
22646	SP	9493	Vila Bessy	Vl Bessy
22647	SP	9493	Vila Boyes	Vl Boyes
22648	SP	9493	Vila Cristina	Vl Cristina
22649	SP	9493	Vila Independência	Vl Independência
22650	SP	9493	Vila Industrial	Vl Industrial
22652	SP	9493	Vila Monteiro	Vl Monteiro
22653	SP	9493	Vila Nossa Senhora Aparecida	Vl N Sra Aparecida
22654	SP	9493	Vila Pacaembu	Vl Pacaembu
22655	SP	9493	Vila Prudente	Vl Prudente
22656	SP	9493	Vila Rezende	Vl Rezende
22657	SP	9493	Vila Verde	Vl Verde
22659	SP	9501	Centro	\N
22660	SP	9501	Cidade Jardim	C Jardim
22663	SP	9501	Distrito Industrial	Dt Industrial
22665	SP	9501	Jardim América	Jd América
22666	SP	9501	Jardim Bandeirantes	Jd Bandeirantes
22667	SP	9501	Jardim Brasília	Jd Brasília
22668	SP	9501	Jardim Carlos Gomes	Jd C Gomes
22669	SP	9501	Jardim das Laranjeiras	Jd Laranjeiras
22670	SP	9501	Jardim do Lago	Jd Lago
22671	SP	9501	Jardim Eldorado	Jd Eldorado
22672	SP	9501	Jardim Elite	Jd Elite
22673	SP	9501	Jardim Ferrarezzi	Jd Ferrarezzi
22674	SP	9501	Jardim Godoy	Jd Godoy
22675	SP	9501	Jardim Kamel	Jd Kamel
22676	SP	9501	Jardim Lauro Pozzi	Jd L Pozzi
22677	SP	9501	Jardim Leonor Cristina	Jd L Cristina
22678	SP	9501	Jardim Margarida	Jd Margarida
22679	SP	9501	Jardim Morumbi	Jd Morumbi
22680	SP	9501	Jardim Olímpio Felício	Jd O Felício
22681	SP	9501	Jardim Pavesi	Jd Pavesi
22682	SP	9501	Jardim Petrópolis	Jd Petrópolis
22683	SP	9501	Jardim Planalto	Jd Planalto
22684	SP	9501	Jardim Primavera	Jd Primavera
22685	SP	9501	Jardim Redentor	Jd Redentor
22746	SP	9508	Jardim Gonçalves	Jd Gonçalves
22747	SP	9508	Jardim Helena	Jd Helena
22748	SP	9508	Jardim Indaiá	Jd Indaiá
22749	SP	9508	Jardim Iracema Namam	Jd I Namam
22750	SP	9508	Jardim Itamarati	Jd Itamarati
22751	SP	9508	Jardim Ivone	Jd Ivone
22752	SP	9508	Jardim Ivonete	Jd Ivonete
22753	SP	9508	Jardim Julieta	Jd Julieta
22754	SP	9508	Jardim Madre Ângela	Jd Me Ângela
22755	SP	9508	Jardim Medina	Jd Medina
22756	SP	9508	Jardim Nova Poá	Jd N Poá
22757	SP	9508	Jardim Obelisco	Jd Obelisco
22758	SP	9508	Jardim Odete	Jd Odete
22759	SP	9508	Jardim Palma Tereza	Jd P Tereza
22760	SP	9508	Jardim Pereta	Jd Pereta
22761	SP	9508	Jardim Perracini	Jd Perracini
22763	SP	9508	Jardim Pinheiro	Jd Pinheiro
22764	SP	9508	Jardim Planalto	Jd Planalto
22765	SP	9508	Jardim Ruth	Jd Ruth
22766	SP	9508	Jardim Santa Cruz	Jd Sta Cruz
22767	SP	9508	Jardim Santa Helena	Jd Sta Helena
22768	SP	9508	Jardim Santa Luiza	Jd Sta Luiza
22769	SP	9508	Jardim Santa Maria	Jd Sta Maria
22770	SP	9508	Jardim Santo Antônio	Jd Sto Antônio
22771	SP	9508	Jardim São José	Jd S José
22772	SP	9508	Jardim São Marcos	Jd S Marcos
22773	SP	9508	Jardim Selma Helena	Jd S Helena
22774	SP	9508	Jardim Sonia	Jd Sonia
22775	SP	9508	Jardim Tereza Palma	Jd T Palma
22776	SP	9508	Jardim Varela	Jd Varela
22777	SP	9508	Jardim Violeta	Jd Violeta
22778	SP	9508	Jardim Virginia	Jd Virginia
22779	SP	9508	Vila Acoreana	Vl Acoreana
22780	SP	9508	Vila Amélia	Vl Amélia
22781	SP	9508	Vila Anchieta	Vl Anchieta
22782	SP	9508	Vila Anita	Vl Anita
22783	SP	9508	Vila Ararat	Vl Ararat
22784	SP	9508	Vila Arbame	Vl Arbame
22785	SP	9508	Vila Arquimedes	Vl Arquimedes
22787	SP	9508	Vila Áurea	Vl Áurea
22788	SP	9508	Vila Bandeirantes	Vl Bandeirantes
22789	SP	9508	Vila Calia	Vl Calia
22790	SP	9508	Vila Cândida	Vl Cândida
22791	SP	9508	Vila Cleto	Vl Cleto
22792	SP	9508	Vila Correa	Vl Correa
22793	SP	9508	Vila Cosmos	Vl Cosmos
22794	SP	9508	Vila Cristelo	Vl Cristelo
22795	SP	9508	Vila das Acácias	Vl Acácias
22796	SP	9508	Vila das Rosas	Vl Rosas
22797	SP	9508	Vila Eureka	Vl Eureka
22798	SP	9508	Vila Florenzano	Vl Florenzano
22799	SP	9508	Vila General	Vl General
22800	SP	9508	Vila Gonçalves	Vl Gonçalves
22801	SP	9508	Vila Ibar	Vl Ibar
22802	SP	9508	Vila Idalina	Vl Idalina
22803	SP	9508	Vila Ischia	Vl Ischia
22804	SP	9508	Vila Jamil	Vl Jamil
22805	SP	9508	Vila Jau	Vl Jau
22806	SP	9508	Vila Júlia	Vl Júlia
22807	SP	9508	Vila Lúcia	Vl Lúcia
22808	SP	9508	Vila Luiza	Vl Luiza
22809	SP	9508	Vila Monteiro	Vl Monteiro
22810	SP	9508	Vila Oceania	Vl Oceania
22811	SP	9508	Vila Odete	Vl Odete
22812	SP	9508	Vila Pereta	Vl Pereta
22813	SP	9508	Vila Perracini	Vl Perracini
22814	SP	9508	Vila Perreli	Vl Perreli
22815	SP	9508	Vila Rea	Vl Rea
22816	SP	9508	Vila Romana	Vl Romana
22817	SP	9508	Vila Ruth	Vl Ruth
22818	SP	9508	Vila Santa Helena	Vl Sta Helena
22819	SP	9508	Vila Santa Luiza	Vl Sta Luiza
22820	SP	9508	Vila Santa Maria	Vl Sta Maria
22821	SP	9508	Vila São João	Vl S João
22822	SP	9508	Vila São Jorge	Vl S Jorge
22823	SP	9508	Vila Sopreter	Vl Sopreter
22824	SP	9508	Vila Turmalina	Vl Turmalina
22825	SP	9508	Vila Vampre	Vl Vampre
22826	SP	9508	Vila Varela	Vl Varela
22828	SP	9527	Balneário Celimar	Bal Celimar
22829	SP	9527	Esmeralda	\N
22830	SP	9527	Flórida	\N
22831	SP	9527	Balneário Ipanema Mirim	Bal I Mirim
22832	SP	9527	Ribeirópolis	\N
22834	SP	9527	Maracanã	\N
22837	SP	9527	Balneário Maxland	Bal Maxland
22838	SP	9527	Balneário Mirante	Bal Mirante
22840	SP	9527	Balneário Paqueta	Bal Paqueta
22841	SP	9527	Balneário Pires	Bal Pires
22842	SP	9527	Boqueirão	\N
22843	SP	9527	Aviação	\N
22844	SP	9527	Canto do Forte	C Forte
22845	SP	9527	Cidade da Criança	C Criança
22846	SP	9527	Ocian	\N
22847	SP	9527	Ilha das Caieiras	Ia Caieiras
22848	SP	9527	Jardim Aclimação	Jd Aclimação
22849	SP	9527	Jardim Aloha	Jd Aloha
22850	SP	9527	Anhanguera	\N
22851	SP	9527	Glória	\N
22852	SP	9527	Jardim Guaramar	Jd Guaramar
22854	SP	9527	Jardim Imperador	Jd Imperador
22855	SP	9527	Imperador	\N
22856	SP	9527	Real	\N
22857	SP	9527	Jardim Imperador III	Jd Imperador III
22858	SP	9527	Jardim Imperador IV	Jd Imperador IV
22859	SP	9527	Jardim Matilde	Jd Matilde
22860	SP	9527	Melvi	\N
22861	SP	9527	Jardim Monte Serrat	Jd Mte Serrat
22863	SP	9527	Princesa	\N
22865	SP	9527	Quietude	\N
22868	SP	9527	Jardim Roberto Andraus	Jd R Andraus
22869	SP	9527	Samambaia	\N
22871	SP	9527	Jardim Santos	Jd Santos
22273	SP	9435	Conjunto Habitacional Ourinhos D-1 e D-2	Cj Hab O D E D-2
22274	SP	9435	Conjunto Residencial Cizira Sandano Migliari	Cj Res C S Migliari
22275	SP	9435	Conjunto Residencial Flamboyant	Cj Res Flamboyant
22276	SP	9435	Conjunto Residencial Itajubi	Cj Res Itajubi
22277	SP	9435	Conjunto Residencial Padre Eduardo Murante	Cj Res Pe E Murante
22278	SP	9435	Água da Veada	A Veada
22279	SP	9435	Distrito Industrial Doutor Hélio Silva	Dt Ind Dr H Silva
22280	SP	9435	Distrito Industrial Oriente Mori	Dt Ind O Mori
22281	SP	9435	Jardim Alvorada	Jd Alvorada
22282	SP	9435	Jardim América	Jd América
22283	SP	9435	Jardim Anchieta	Jd Anchieta
22284	SP	9435	Jardim Aurora	Jd Aurora
22286	SP	9435	Jardim Beatriz	Jd Beatriz
22287	SP	9435	Jardim Bela Vista	Jd B Vista
22289	SP	9435	Jardim Carolina	Jd Carolina
22290	SP	9435	Jardim Colorado	Jd Colorado
22291	SP	9435	Jardim Columbia	Jd Columbia
22292	SP	9435	Jardim Cristal	Jd Cristal
22293	SP	9435	Jardim das Paineiras	Jd Paineiras
22294	SP	9435	Jardim do Sol	Jd Sol
22295	SP	9435	Jardim do Sol II	Jd Sol II
22296	SP	9435	Jardim dos Bandeirantes	Jd Bandeirantes
22297	SP	9435	Jardim Eldorado	Jd Eldorado
22298	SP	9435	Jardim Estoril	Jd Estoril
22299	SP	9435	Jardim Europa	Jd Europa
22300	SP	9435	Jardim Flórida	Jd Flórida
22301	SP	9435	Jardim Furlan	Jd Furlan
22302	SP	9435	Jardim Guaporé	Jd Guaporé
22303	SP	9435	Jardim Imperial	Jd Imperial
22304	SP	9435	Jardim Industrial	Jd Industrial
22305	SP	9435	Jardim Itamaraty	Jd Itamaraty
22306	SP	9435	Jardim Josefina	Jd Josefina
22307	SP	9435	Jardim Matilde	Jd Matilde
22308	SP	9435	Jardim Nazareth	Jd Nazareth
22310	SP	9435	Jardim Ouro Verde	Jd O Verde
22311	SP	9435	Jardim Paris	Jd Paris
22312	SP	9435	Jardim Paulista	Jd Paulista
22314	SP	9435	Jardim Santa Catarina	Jd Sta Catarina
22315	SP	9435	Jardim Santa Cecília	Jd Sta Cecília
22316	SP	9435	Jardim Santa Fé	Jd Sta Fé
22317	SP	9435	Jardim Santa Felicidade	Jd Sta Felicidade
22319	SP	9435	Jardim Santos Dumont II	Jd Stos Dumont II
22320	SP	9435	Jardim São Carlos	Jd S Carlos
22321	SP	9435	Jardim São Domingos	Jd S Domingos
22322	SP	9435	Jardim São Francisco	Jd S Francisco
22375	SP	9435	Vila Village San Rafael	Vl V S Rafael
22378	SP	9485	Alto do Cardoso	At Cardoso
22379	SP	9485	Bela Vista	B Vista
22380	SP	9485	Bosque da Princesa	Bsq Princesa
22381	SP	9485	Campinas	\N
22383	SP	9485	Centro	\N
22384	SP	9485	Chácara da Galega	Ch Galega
22386	SP	9485	Cidade Nova	C Nova
22388	SP	9485	Conjunto Habitacional Terra dos Ipês I (Norte)	Cj Hab T Ipês I (Norte)
22389	SP	9485	Conjunto Habitacional Terra dos Ipês I (Sul)	Cj Hab T Ipês I (Sul)
22390	SP	9485	Conjunto Habitacional Terra dos Ipês II (Fase I)	Cj Hab T Ipês II (Fase I)
22391	SP	9485	Conjunto Habitacional Terra dos Ipês II (Fase II)	Cj Hab T Ipês II (Fase II)
22392	SP	9485	Conjunto Habitacional Terra dos Ipês W	Cj Hab T Ipês W
22393	SP	9485	Conjunto Residencial Araretama	Cj Res Araretama
22395	SP	9485	Crispim	\N
22397	SP	9485	Feital	\N
22405	SP	9485	Jardim Boa Vista	Jd B Vista
22409	SP	9485	Jardim Carlota	Jd Carlota
22410	SP	9485	Jardim Cristina	Jd Cristina
22413	SP	9485	Jardim Eloyna	Jd Eloyna
22420	SP	9485	Jardim Padre Rodolfo	Jd Pe Rodolfo
22423	SP	9485	Jardim Princesa	Jd Princesa
22424	SP	9485	Jardim Recanto Verde	Jd Rec Verde
22427	SP	9485	Jardim Residencial Doutor Lessa	Jd Res Dr Lessa
22428	SP	9485	Jardim Rosely	Jd Rosely
22429	SP	9485	Jardim Santa Cecília	Jd Sta Cecília
22430	SP	9485	Jardim Santa Luzia	Jd Sta Luzia
22438	SP	9485	Loteamento João Tamborindeguy Fernandes	Lot J T Fernandes
22441	SP	9485	Loteamento Residencial Andrade	Lot Res Andrade
22443	SP	9485	Maria Áurea	M Áurea
22445	SP	9485	Moreira César	M César
22447	SP	9485	Nossa Senhora do Perpétuo Socorro	N Sra P Socorro
22449	SP	9485	Parque das Nações	Prq Nações
22450	SP	9485	Parque Lago Azul	Prq Lg Azul
22452	SP	9485	Parque São Domingos	Prq S Domingos
22457	SP	9485	Residencial Campos Maia	Res C Maia
22458	SP	9485	Residencial Comercial Cidade Vista Alegre	Res C C V Alegre
22459	SP	9485	Residencial e Comercial Vila Verde	Res C Vl Verde
22460	SP	9485	Residencial e Comercial Cidade Jardim	Res E C C Jardim
22461	SP	9485	Residencial e Comercial Cidade Morumbi	Res E C C Morumbi
22462	SP	9485	Residencial Maricá	Res Maricá
22463	SP	9485	Residencial Mombaça	Res Mombaça
22558	SP	9493	Jardim Itapuã	Jd Itapuã
22559	SP	9493	Jardim Maria Claudia	Jd M Claudia
22560	SP	9493	Jardim Maria Helena	Jd M Helena
22563	SP	9493	Monte Líbano	Mte Líbano
22564	SP	9493	Jardim Monumento	Jd Monumento
22565	SP	9493	Jardim Morada do Sol	Jd M Sol
22566	SP	9493	Jardim Noiva da Colina	Jd N Colina
22567	SP	9493	Jardim Nova Iguaçu	Jd N Iguaçu
22568	SP	9493	Jardim Nova República	Jd N República
22569	SP	9493	Jardim Nova Suíça	Jd N Suíça
22570	SP	9493	Novo Horizonte	N Horizonte
22571	SP	9493	Jardim Pacaembu	Jd Pacaembu
22572	SP	9493	Jardim Parque Jupiá	Jd Prq Jupiá
22573	SP	9493	Jardim Petrópolis	Jd Petrópolis
22574	SP	9493	Jardim Planalto	Jd Planalto
22575	SP	9493	Jardim Primavera	Jd Primavera
22576	SP	9493	Jardim Residencial Itabera	Jd Res Itabera
22577	SP	9493	Jardim Residencial Javary I	Jd Res Javary I
22578	SP	9493	Jardim Santa Isabel	Jd Sta Isabel
22579	SP	9493	Jardim Santa Silvia	Jd Sta Silvia
22580	SP	9493	Jardim São Francisco	Jd S Francisco
22581	SP	9493	Jardim São Jorge	Jd S Jorge
22582	SP	9493	Jardim São Luiz	Jd S Luiz
22583	SP	9493	Jardim São Paulo	Jd S Paulo
22584	SP	9493	Jardim Sonia	Jd Sonia
22585	SP	9493	Jardim Taiguara	Jd Taiguara
22586	SP	9493	Jardim Taruman	Jd Taruman
22587	SP	9493	Jardim Tatuapé	Jd Tatuapé
22594	SP	9493	Loteamento Kobayat Líbano	Lot K Líbano
22595	SP	9493	Loteamento Ipanema	Lot Ipanema
22597	SP	9493	Loteamento Santa Rosa	Lot Sta Rosa
22598	SP	9493	Loteamento São Francisco	Lot S Francisco
22599	SP	9493	Maracanã	\N
22600	SP	9493	Matão	\N
22601	SP	9493	Monte Alegre	Mte Alegre
22602	SP	9493	Morumbi	\N
22603	SP	9493	Nhô Quim	N Quim
22604	SP	9493	Nossa Senhora de Fátima	N Sra Fátima
22605	SP	9493	Nova América	N América
22606	SP	9493	Nova Piracicaba	N Piracicaba
22607	SP	9493	Nova Pompéia	N Pompéia
22608	SP	9493	Parque Bela Vista	Prq B Vista
22609	SP	9493	Parque Cecap I	Prq Cecap I
22610	SP	9493	Parque Cecap II	Prq Cecap II
22611	SP	9493	Parque Chapadão	Prq Chapadão
22614	SP	9493	Parque Nossa Senhora das Graças	Prq N Sra Graças
22615	SP	9493	Parque Orlanda I	Prq Orlanda I
22617	SP	9493	Parque Primeiro de Maio	Prq P Maio
22618	SP	9493	Parque Santa Cecília	Prq Sta Cecília
22686	SP	9501	Jardim Roma	Jd Roma
22687	SP	9501	Jardim Rosim	Jd Rosim
22688	SP	9501	Jardim Santa Rita	Jd Sta Rita
22689	SP	9501	Jardim Santos Dumont	Jd Stos Dumont
22690	SP	9501	Jardim São Fernando	Jd S Fernando
22691	SP	9501	Jardim São Lucas	Jd S Lucas
22692	SP	9501	Jardim São Valentim	Jd S Valentim
22693	SP	9501	Loteamento Verona	Lot Verona
22694	SP	9501	Parque dos Eucaliptos	Prq Eucaliptos
22696	SP	9501	Rosário	\N
22698	SP	9501	Vila Becker	Vl Becker
22699	SP	9501	Vila Belmiro	Vl Belmiro
22700	SP	9501	Vila Brasil	Vl Brasil
22701	SP	9501	Vila Braz	Vl Braz
22702	SP	9501	Vila Constituição	Vl Constituição
22703	SP	9501	Vila Esperança	Vl Esperança
22704	SP	9501	Vila Guilhermina	Vl Guilhermina
22705	SP	9501	Vila Guimarães	Vl Guimarães
22706	SP	9501	Vila Industrial	Vl Industrial
22708	SP	9501	Vila Malaquias	Vl Malaquias
22709	SP	9501	Vila Militar	Vl Militar
22710	SP	9501	Vila Nova	Vl Nova
22711	SP	9501	Vila Paulista	Vl Paulista
22712	SP	9501	Vila Pinheiro	Vl Pinheiro
22714	SP	9501	Vila Redenção	Vl Redenção
22717	SP	9501	Vila Santa Terezinha	Vl Sta Terezinha
22718	SP	9501	Vila São Guido	Vl S Guido
22719	SP	9501	Vila São Judas Tadeu	Vl S J Tadeu
22720	SP	9501	Vila São Pedro	Vl S Pedro
22721	SP	9501	Vila Steola	Vl Steola
22722	SP	9501	Vila Urupês	Vl Urupês
22723	SP	9508	Água Vermelha	A Vermelha
22724	SP	9508	Biritiba	\N
22725	SP	9508	Calmon Viana	C Viana
22726	SP	9508	Centro	\N
22727	SP	9508	Chácara Bela Vista	Ch B Vista
22728	SP	9508	Cidade Kemel	C Kemel
22729	SP	9508	Conjunto Alvorada	Cj Alvorada
22730	SP	9508	Conjunto Madre Ângela	Cj Me Ângela
22731	SP	9508	Jardim Alvorada	Jd Alvorada
22732	SP	9508	Jardim Amélia	Jd Amélia
22733	SP	9508	Jardim América	Jd América
22734	SP	9508	Jardim Antônio Picosse	Jd A Picosse
22735	SP	9508	Jardim Áurea	Jd Áurea
22736	SP	9508	Jardim Beatriz	Jd Beatriz
22737	SP	9508	Jardim Bela Vista	Jd B Vista
22738	SP	9508	Jardim Cândida	Jd Cândida
22739	SP	9508	Jardim D Manoel	Jd D Manoel
22740	SP	9508	Jardim Débora	Jd Débora
22741	SP	9508	Jardim Dulce	Jd Dulce
22742	SP	9508	Jardim Emília	Jd Emília
22743	SP	9508	Jardim Estela	Jd Estela
22744	SP	9508	Jardim Fonte Áurea	Jd Fnt Áurea
22745	SP	9508	Jardim Glória	Jd Glória
22872	SP	9527	Jardim São Miguel	Jd S Miguel
22873	SP	9527	Jardim Trevo	Jd Trevo
22874	SP	9527	Parque das Américas	Prq Américas
22875	SP	9527	Sítio São Sebastião	Sit S Sebastião
22876	SP	9527	Solemar	\N
22877	SP	9527	Sítio do Campo	Sit Campo
22878	SP	9527	Antártica	\N
22879	SP	9527	Vila Assunção	Vl Assunção
22880	SP	9527	Vila Balneária	Vl Balneária
22881	SP	9527	Caiçara	\N
22883	SP	9527	Guilhermina	\N
22884	SP	9527	Vila Isabel	Vl Isabel
22885	SP	9527	Vila Itaipu	Vl Itaipu
22887	SP	9527	Mirim	\N
22888	SP	9527	Vila Noemia	Vl Noemia
22891	SP	9527	Vila São Jorge	Vl S Jorge
22892	SP	9527	Vila Sônia	Vl Sônia
22893	SP	9527	Tupi	\N
22894	SP	9527	Tupiry	\N
22895	SP	9527	Vilamar	\N
22896	SP	9532	Bosque	\N
22897	SP	9532	Bosque da Saúde	Bsq Saúde
22898	SP	9532	Bosque Itaju	Bsq Itaju
22899	SP	9532	Brasil Novo	B Novo
22900	SP	9532	Cecap	\N
22903	SP	9532	Centro	\N
22904	SP	9532	Chácara do Macuco	Ch Macuco
22906	SP	9532	Chácara Guerner	Ch Guerner
22909	SP	9532	Chácara São Luis	Ch S Luis
22910	SP	9532	Chácaras Azaléias	C Azaléias
22911	SP	9532	Cidade Jardim	C Jardim
22912	SP	9532	Cidade Universitária	C Universitária
22914	SP	9532	Conjunto Chácara Marisa	Cj Ch Marisa
22915	SP	9532	Conjunto Habitacional Alcides Perez Videira	Cj Hab A P Videira
22916	SP	9532	Conjunto Habitacional Ana Jacinta	Cj Hab A Jacinta
22917	SP	9532	Conjunto Habitacional Augusto de Paula	Cj Hab A Paula
23289	SP	9560	Condomínio Balneário Recreativa	Cond Bal Recreativa
22918	SP	9532	Conjunto Habitacional Efigênia Dionísio da Silva	Cj Hab E D Silva
22919	SP	9532	Conjunto Habitacional Jardim Humberto Salvador	Cj Hab Jd H Salvador
22920	SP	9532	Parque José Rotta	Prq J Rotta
22921	SP	9532	Conjunto Sítio São Pedro	Cj Sit S Pedro
22922	SP	9532	Distrito Industrial	Dt Industrial
22923	SP	9532	Grupo Educacional Esquema	G E Esquema
22924	SP	9532	Jardim Alto da Boa Vista	Jd At B Vista
22925	SP	9532	Jardim América	Jd América
22926	SP	9532	Jardim Antuérpia	Jd Antuérpia
22927	SP	9532	Jardim Aquinópolis	Jd Aquinópolis
22928	SP	9532	Jardim Aviação	Jd Aviação
22929	SP	9532	Jardim Balneário	Jd Balneário
22930	SP	9532	Jardim Barcelona	Jd Barcelona
22931	SP	9532	Jardim Bela Daria	Jd B Daria
22932	SP	9532	Jardim Bela Vista	Jd B Vista
22933	SP	9532	Jardim Belo Horizonte	Jd B Horizonte
22987	SP	9532	Jardim Santa Fé	Jd Sta Fé
22988	SP	9532	Jardim Santa Filomena	Jd Sta Filomena
22989	SP	9532	Jardim Santa Marta	Jd Sta Marta
22990	SP	9532	Jardim Santa Mônica	Jd Sta Mônica
22991	SP	9532	Jardim Santa Olga	Jd Sta Olga
22992	SP	9532	Jardim Santa Paula	Jd Sta Paula
22994	SP	9532	Jardim Santana	Jd Santana
22995	SP	9532	Jardim São Bento	Jd S Bento
22996	SP	9532	Jardim São Domingos	Jd S Domingos
22997	SP	9532	Jardim São Francisco	Jd S Francisco
22998	SP	9532	Jardim São Gabriel	Jd S Gabriel
22999	SP	9532	Jardim São Geraldo	Jd S Geraldo
23000	SP	9532	Jardim São Luís	Jd S Luís
23001	SP	9532	Jardim São Paulo	Jd S Paulo
23002	SP	9532	Jardim São Pedro	Jd S Pedro
23003	SP	9532	Jardim Satélite	Jd Satélite
23004	SP	9532	Jardim Sumaré	Jd Sumaré
23005	SP	9532	Jardim Tropical	Jd Tropical
23006	SP	9532	Jardim Vale do Sol	Jd Vle Sol
23007	SP	9532	Jardim Vale Verde	Jd Vle Verde
23008	SP	9532	Jardim Vale Verde II	Jd Vle Verde II
23009	SP	9532	Jardim Vila Real	Jd Vl Real
23010	SP	9532	Núcleo Bartholomeu Bueno de Miranda	Nuc B B Miranda
23011	SP	9532	Parque Alexandrina	Prq Alexandrina
23012	SP	9532	Parque Alto Bela Vista	Prq At B Vista
23013	SP	9532	Parque Alvorada	Prq Alvorada
23014	SP	9532	Parque Bandeirantes	Prq Bandeirantes
23015	SP	9532	Parque Castelo Branco	Prq C Branco
23016	SP	9532	Parque Cedral	Prq Cedral
23017	SP	9532	Parque das Cerejeiras	Prq Cerejeiras
23018	SP	9532	Parque Furquim	Prq Furquim
23019	SP	9532	Parque Higienópolis	Prq Higienópolis
23020	SP	9532	Parque Imperial	Prq Imperial
23021	SP	9532	Parque Jabaquara	Prq Jabaquara
23022	SP	9532	Parque Nova Alvorada	Prq N Alvorada
23023	SP	9532	Parque Primavera	Prq Primavera
23024	SP	9532	Parque Residencial Araki	Prq Res Araki
23025	SP	9532	Parque Residencial Carandá	Prq Res Carandá
23026	SP	9532	Parque Residencial Damha	Prq Res Damha
23027	SP	9532	Parque Residencial Jardins	Prq Res Jardins
23028	SP	9532	Parque Residencial Mediterrâneo	Prq Res Mediterrâneo
23029	SP	9532	Parque Residencial Nosaki	Prq Res Nosaki
23030	SP	9532	Parque Residencial São Lucas	Prq Res S Lucas
23031	SP	9532	Parque Residencial Servantes	Prq Res Servantes
23093	SP	9532	Vila Mariana	Vl Mariana
23094	SP	9532	Vila Marina	Vl Marina
23095	SP	9532	Vila Maristela	Vl Maristela
23097	SP	9532	Vila Mathilde Vieira	Vl M Vieira
23098	SP	9532	Vila Mendes	Vl Mendes
23100	SP	9532	Vila Mirian	Vl Mirian
23101	SP	9532	Vila Nova	Vl Nova
23103	SP	9532	Vila Nova Prudente	Vl N Prudente
23104	SP	9532	Vila Ocidental	Vl Ocidental
23105	SP	9532	Vila Operária	Vl Operária
23106	SP	9532	Vila Oriental	Vl Oriental
23107	SP	9532	Vila Paraíso	Vl Paraíso
23108	SP	9532	Vila Paulo Roberto	Vl P Roberto
23109	SP	9532	Vila Pinheiro	Vl Pinheiro
23110	SP	9532	Vila Prudente	Vl Prudente
23111	SP	9532	Vila Rainho	Vl Rainho
23112	SP	9532	Vila Ramos	Vl Ramos
23113	SP	9532	Vila Ramos de Freitas	Vl R Freitas
23114	SP	9532	Vila Roberto	Vl Roberto
23115	SP	9532	Vila Rosa	Vl Rosa
23116	SP	9532	Vila Santa Helena	Vl Sta Helena
23117	SP	9532	Vila Santa Izabel	Vl Sta Izabel
23118	SP	9532	Vila Santa Tereza	Vl Sta Tereza
23121	SP	9532	Vila São Jorge	Vl S Jorge
23122	SP	9532	Vila São Pedro	Vl S Pedro
23123	SP	9532	Vila Tabajara	Vl Tabajara
23124	SP	9532	Vila Tazitsu	Vl Tazitsu
23126	SP	9532	Vila Verinha	Vl Verinha
23127	SP	9532	Vila Yolanda	Vl Yolanda
23132	SP	9559	Centro	\N
23167	SP	9559	Jardim Itaquera (Santa Luzia)	Jd Itaquera (Sta Luzia)
23205	SP	9559	Quarta Divisão (Santa Luzia)	Q Divisão (Sta Luzia)
23212	SP	9559	São Caetaninho	S Caetaninho
23218	SP	9559	Sítio Paraíso (Santa Luzia)	Sit Paraíso (Sta Luzia)
23256	SP	9559	Vila Rica (Santa Luzia)	Vl Rica (Sta Luzia)
23273	SP	9560	Adão do Carmo Leonel	A C Leonel
23274	SP	9560	Adelino Simioni	A Simioni
23275	SP	9560	Alto da Boa Vista	At B Vista
23276	SP	9560	Alto do Ipiranga	At Ipiranga
23277	SP	9560	Antônio Marincek	A Marincek
23278	SP	9560	Avelino Alves Palma	A A Palma
23279	SP	9560	Campos Elíseos	C Elíseos
23280	SP	9560	Centro	\N
23283	SP	9560	Chácaras Pedro Corrêa de Carvalho	C P C Carvalho
23284	SP	9560	Chácaras Rio Pardo	C R Pardo
23285	SP	9560	Cidade Jardim	C Jardim
23286	SP	9560	City Ribeirão	C Ribeirão
23292	SP	9560	Condomínio Portal dos Ipês	Cond P Ipês
23293	SP	9560	Condomínio Quinta da Boa Vista	Cond Qta B Vista
23354	SP	9560	Jardim Patriarca	Jd Patriarca
23355	SP	9560	Jardim Paulista	Jd Paulista
23356	SP	9560	Jardim Paulistano	Jd Paulistano
23357	SP	9560	Jardim Piratininga	Jd Piratininga
23358	SP	9560	Jardim Recreio	Jd Recreio
23359	SP	9560	Jardim Roberto Benedetti	Jd R Benedetti
23360	SP	9560	Jardim Salgado Filho	Jd S Filho
23362	SP	9560	Jardim São José	Jd S José
23363	SP	9560	Jardim São Luiz	Jd S Luiz
23365	SP	9560	Jardim Sumaré	Jd Sumaré
23367	SP	9560	Jardim Zara	Jd Zara
23368	SP	9560	Nova Ribeirânia	N Ribeirânia
23369	SP	9560	Núcleo São Luís	Nuc S Luís
23370	SP	9560	Parque Anhangüera	Prq Anhangüera
23372	SP	9560	Parque das Andorinhas	Prq Andorinhas
23373	SP	9560	Parque das Figueiras	Prq Figueiras
23374	SP	9560	Parque dos Bandeirantes	Prq Bandeirantes
23375	SP	9560	Parque dos Flamboyans	Prq Flamboyans
23376	SP	9560	Parque dos Lagos	Prq Lagos
23377	SP	9560	Parque dos Pinus	Prq Pinus
23379	SP	9560	Parque Industrial Avelino Alves Palma	Prq Ind A A Palma
23380	SP	9560	Parque Industrial Coronel Quito Junqueira	Prq Ind Cel Q Junqueira
23381	SP	9560	Parque Residencial Lagoinha	Prq Res Lagoinha
23382	SP	9560	Parque Industrial Tanquinho	Prq Ind Tanquinho
23383	SP	9560	Parque Residencial Cândido Portinari	Prq Res C Portinari
23384	SP	9560	Parque Residencial Cidade Universitária	Prq Res C Universitária
23385	SP	9560	Parque Ribeirão Preto	Prq R Preto
23386	SP	9560	Parque São Sebastião	Prq S Sebastião
23387	SP	9560	Planalto Verde	P Verde
23388	SP	9560	Presidente Dutra	Pres Dutra
23389	SP	9560	Presidente Médici	Pres Médici
23390	SP	9560	Quintino Facci I	Q Facci I
23391	SP	9560	Quintino Facci II	Q Facci II
23394	SP	9560	Recreio Anhangüera	Rcr Anhangüera
23395	SP	9560	Recreio das Acácias	Rcr Acácias
23396	SP	9560	Recreio Internacional	Rcr Internacional
23397	SP	9560	República	\N
23398	SP	9560	Residencial das Américas	Res Américas
23399	SP	9560	Residencial e Comercial Palmares	Res E C Palmares
23400	SP	9560	Residencial Flórida	Res Flórida
23401	SP	9560	Residencial Parque dos Servidores	Res Prq Servidores
23402	SP	9560	Ribeirânia	\N
23403	SP	9560	Santa Cruz do José Jacques	Sta C J Jacques
23404	SP	9560	Solar Boa Vista	S B Vista
22934	SP	9532	Jardim Bongiovani	Jd Bongiovani
22935	SP	9532	Jardim Brasília	Jd Brasília
22936	SP	9532	Jardim Caiçara	Jd Caiçara
22937	SP	9532	Jardim Califórnia	Jd Califórnia
22938	SP	9532	Jardim Cambuci	Jd Cambuci
22939	SP	9532	Jardim Cambuy	Jd Cambuy
22940	SP	9532	Jardim Campo Belo	Jd Cpo Belo
22941	SP	9532	Jardim Cinqüentenário	Jd Cinqüentenário
22942	SP	9532	Jardim Cobral	Jd Cobral
22943	SP	9532	Jardim Colina	Jd Colina
22944	SP	9532	Jardim das Hortências	Jd Hortências
22945	SP	9532	Jardim das Rosas	Jd Rosas
22946	SP	9532	Jardim dos Pioneiros	Jd Pioneiros
22947	SP	9532	Jardim Duque de Caxias	Jd Dq Caxias
22948	SP	9532	Jardim Eldorado	Jd Eldorado
22949	SP	9532	Jardim Esplanada	Jd Esplanada
22950	SP	9532	Jardim Estoril	Jd Estoril
22951	SP	9532	Jardim Europa	Jd Europa
22952	SP	9532	Jardim Everest	Jd Everest
22953	SP	9532	Jardim Guanabara	Jd Guanabara
22954	SP	9532	Jardim Icaray	Jd Icaray
22955	SP	9532	Jardim Iguaçu	Jd Iguaçu
22956	SP	9532	Jardim Itaipu	Jd Itaipu
22957	SP	9532	Jardim Itapura	Jd Itapura
22958	SP	9532	Jardim Itatiaia	Jd Itatiaia
22959	SP	9532	Jardim Jequitibá	Jd Jequitibá
22961	SP	9532	Jardim João Paulo II	Jd J Paulo II
22962	SP	9532	Jardim Leonor	Jd Leonor
22963	SP	9532	Jardim Maracanã	Jd Maracanã
22964	SP	9532	Jardim Marupiara	Jd Marupiara
22965	SP	9532	Jardim Monte Alto	Jd Mte Alto
22966	SP	9532	Jardim Morada do Sol	Jd M Sol
22968	SP	9532	Jardim Morumbi	Jd Morumbi
22969	SP	9532	Jardim Nova Planaltina	Jd N Planaltina
22970	SP	9532	Jardim Novo Bongiovani	Jd N Bongiovani
22971	SP	9532	Jardim Novo Planalto	Jd N Planalto
22973	SP	9532	Jardim Ouro Verde	Jd O Verde
22974	SP	9532	Jardim Paraíso	Jd Paraíso
22975	SP	9532	Jardim Paris	Jd Paris
22976	SP	9532	Jardim Paulista	Jd Paulista
22977	SP	9532	Jardim Paulistano	Jd Paulistano
22978	SP	9532	Jardim Petrópolis	Jd Petrópolis
22979	SP	9532	Jardim Planaltina	Jd Planaltina
22980	SP	9532	Jardim Planalto	Jd Planalto
22981	SP	9532	Jardim Regina	Jd Regina
22982	SP	9532	Jardim Rio 400	Jd Rio 400
22983	SP	9532	Jardim Sabará	Jd Sabará
22984	SP	9532	Jardim Santa Cecília	Jd Sta Cecília
22985	SP	9532	Jardim Santa Clara	Jd Sta Clara
22986	SP	9532	Jardim Santa Eliza	Jd Sta Eliza
23032	SP	9532	Parque Residencial Servantes II	Prq Res Servantes II
23033	SP	9532	Parque Residencial Vitória Régia	Prq Res V Régia
23034	SP	9532	Parque São Judas Tadeu	Prq S J Tadeu
23035	SP	9532	Parque São Matheus	Prq S Matheus
23036	SP	9532	Parque Shiraiwa	Prq Shiraiwa
23037	SP	9532	Parque Watal Ishibashi	Prq W Ishibashi
23038	SP	9532	Residencial	\N
23039	SP	9532	Residencial Anita Tiezzi	Res A Tiezzi
23040	SP	9532	Residencial Monte Rey	Res Mte Rey
23042	SP	9532	Residencial São Marcos	Res S Marcos
23441	SP	9566	Cidade Nova	C Nova
23043	SP	9532	Residencial Universitário	Res Universitário
23044	SP	9532	Residencial Vivenda	Res Vivenda
23046	SP	9532	Vale das Parreiras	Vle Parreiras
23048	SP	9532	Vila Angélica	Vl Angélica
23049	SP	9532	Vila Aristarcho	Vl Aristarcho
23050	SP	9532	Vila Áurea	Vl Áurea
23051	SP	9532	Vila Aurélio	Vl Aurélio
23052	SP	9532	Vila Barbeiro	Vl Barbeiro
23054	SP	9532	Vila Boa Vista	Vl B Vista
23056	SP	9532	Vila Boscoli	Vl Boscoli
23057	SP	9532	Vila Brasil	Vl Brasil
23058	SP	9532	Vila Centenário	Vl Centenário
23059	SP	9532	Vila Charlote	Vl Charlote
23060	SP	9532	Vila Claudia Glória	Vl C Glória
23061	SP	9532	Vila Comercial	Vl Comercial
23062	SP	9532	Vila Coronel Goulart	Vl Cel Goulart
23063	SP	9532	Vila Cristina	Vl Cristina
23064	SP	9532	Vila Delger	Vl Delger
23065	SP	9532	Vila do Estádio	Vl Estádio
23066	SP	9532	Vila Dubus	Vl Dubus
23067	SP	9532	Vila Elizabeth	Vl Elizabeth
23068	SP	9532	Vila Euclides	Vl Euclides
23069	SP	9532	Vila Flores	Vl Flores
23071	SP	9532	Vila Formosa	Vl Formosa
23072	SP	9532	Vila Furquim	Vl Furquim
23073	SP	9532	Vila Geni	Vl Geni
23076	SP	9532	Vila Glória	Vl Glória
23077	SP	9532	Vila Guaíra	Vl Guaíra
23078	SP	9532	Vila Haruo Uoya	Vl H Uoya
23079	SP	9532	Vila Industrial	Vl Industrial
23080	SP	9532	Vila Iti	Vl Iti
23081	SP	9532	Vila Jesus	Vl Jesus
23083	SP	9532	Vila Laíde	Vl Laíde
23084	SP	9532	Vila Lessa	Vl Lessa
23085	SP	9532	Vila Liberdade	Vl Liberdade
23086	SP	9532	Vila Líder	Vl Líder
23087	SP	9532	Vila Lúcia Itada	Vl L Itada
23088	SP	9532	Vila Luso	Vl Luso
23089	SP	9532	Vila Machadinho	Vl Machadinho
23090	SP	9532	Vila Malaman	Vl Malaman
23091	SP	9532	Vila Marcondes	Vl Marcondes
23092	SP	9532	Vila Maria	Vl Maria
23297	SP	9560	Conjunto Habitacional Jardim das Palmeiras	Cj Hab Jd Palmeiras
23298	SP	9560	Dom Bernardo José Mielle	D B J Mielle
23299	SP	9560	Esplanada da Estação	Esp Estação
23301	SP	9560	Geraldo Correia de Carvalho	G C Carvalho
23302	SP	9560	Iguatemi	\N
23303	SP	9560	Independência	\N
23304	SP	9560	Ipiranga	\N
23305	SP	9560	Itanhangá Chácaras de Recreio	I C Recreio
23306	SP	9560	Jardim Aeroporto	Jd Aeroporto
23307	SP	9560	Jardim Alexandre Balbo	Jd A Balbo
23308	SP	9560	Jardim América	Jd América
23309	SP	9560	Jardim Anhangüera	Jd Anhangüera
23310	SP	9560	Jardim Antártica	Jd Antártica
23312	SP	9560	Jardim Cadacaam	Jd Cadacaam
23313	SP	9560	Jardim Califórnia	Jd Califórnia
23314	SP	9560	Jardim Canadá	Jd Canadá
23315	SP	9560	Jardim Castelo Branco	Jd C Branco
23316	SP	9560	Jardim das Mansões	Jd Mansões
23318	SP	9560	Jardim das Palmeiras	Jd Palmeiras
23319	SP	9560	Jardim Diva Tarlá de Carvalho	Jd D T Carvalho
23320	SP	9560	Jardim do Trevo	Jd Trevo
23321	SP	9560	Jardim Dona Branca Salles	Jd Da B Salles
23322	SP	9560	Jardim Florestan Fernandes	Jd F Fernandes
23324	SP	9560	Jardim Heitor Rigon	Jd H Rigon
23325	SP	9560	Jardim Helena	Jd Helena
23326	SP	9560	Jardim Iara	Jd Iara
23327	SP	9560	Jardim Interlagos	Jd Interlagos
23330	SP	9560	Jardim Irajá	Jd Irajá
23331	SP	9560	Jardim Itaporã	Jd Itaporã
23332	SP	9560	Jardim Itaú	Jd Itaú
23333	SP	9560	Jardim Itaú Mirim	Jd I Mirim
23334	SP	9560	Jardim Jandaia	Jd Jandaia
23335	SP	9560	Jardim João Rossi	Jd J Rossi
23336	SP	9560	Jardim Joaquim Procópio de Araújo Ferraz	Jd J P A Ferraz
23337	SP	9560	Jardim Jóquei Clube	Jd J Clube
23338	SP	9560	Jardim José Sampaio Júnior	Jd J S Júnior
23339	SP	9560	Jardim Jovino Campos	Jd J Campos
23340	SP	9560	Jardim Juliana	Jd Juliana
23342	SP	9560	Jardim Macedo	Jd Macedo
23343	SP	9560	Jardim Manoel Penna	Jd M Penna
23344	SP	9560	Jardim Marchesi	Jd Marchesi
23345	SP	9560	Jardim Maria Casagrande Lopes (Dona Amália)	Jd M C Lopes (Da Amália)
23347	SP	9560	Jardim Maria Goretti	Jd M Goretti
23348	SP	9560	Jardim Mosteiro	Jd Mosteiro
23351	SP	9560	Jardim Orestes Lopes de Camargo	Jd O L Camargo
23353	SP	9560	Jardim Paschoal Innecchi	Jd P Innecchi
23405	SP	9560	Sumarezinho	\N
23406	SP	9560	Valentina Figueiredo	V Figueiredo
23407	SP	9560	Vila Abranches	Vl Abranches
23408	SP	9560	Vila Albertina	Vl Albertina
23409	SP	9560	Vila Amélia	Vl Amélia
23410	SP	9560	Vila Ana Maria	Vl A Maria
23412	SP	9560	Vila Brasil	Vl Brasil
23413	SP	9560	Vila Carvalho	Vl Carvalho
23415	SP	9560	Vila Elisa	Vl Elisa
23417	SP	9560	Vila Guiomar	Vl Guiomar
23419	SP	9560	Vila Isabel	Vl Isabel
23420	SP	9560	Vila Maria Luiza	Vl M Luiza
23421	SP	9560	Vila Mariana	Vl Mariana
23422	SP	9560	Vila Monte Alegre	Vl Mte Alegre
23425	SP	9560	Vila Pompéia	Vl Pompéia
23427	SP	9560	Vila Seixas	Vl Seixas
23428	SP	9560	Vila Tamandaré	Vl Tamandaré
23429	SP	9560	Vila Tibério	Vl Tibério
23430	SP	9560	Vila Virgínia	Vl Virgínia
23431	SP	9566	Alto do Santana	At Santana
23432	SP	9566	Batovi	\N
23434	SP	9566	Centro	\N
23437	SP	9566	Chácara Bom Retiro	Ch B Retiro
23438	SP	9566	Chácara Lusa	Ch Lusa
23439	SP	9566	Cidade Claret	C Claret
23440	SP	9566	Cidade Jardim	C Jardim
23442	SP	9566	Recreio das Águas Claras	Rcr A Claras
23443	SP	9566	Conjunto Habitacional Arco-Íris (Cecap)	Cj Hab Arco-Íris (Cecap)
23445	SP	9566	Conjunto Residencial Vila Verde	Cj Res Vl Verde
23446	SP	9566	Consolação	\N
23447	SP	9566	Estádio	\N
23449	SP	9566	Granja Regina	Gja Regina
23450	SP	9566	Jardim A Karan	Jd A Karan
23452	SP	9566	Jardim América	Jd América
23453	SP	9566	Jardim Anhangüera	Jd Anhangüera
23454	SP	9566	Jardim Azul	Jd Azul
23455	SP	9566	Jardim Bandeirante (COHAB)	Jd Bandeirante (COHAB)
23456	SP	9566	Jardim Bela Vista	Jd Bela Vista
23457	SP	9566	Jardim Boa Vista	Jd B Vista
23458	SP	9566	Jardim Bom Sucesso	Jd B Sucesso
23459	SP	9566	Jardim Centenário	Jd Centenário
23460	SP	9566	Jardim Cherveson	Jd Cherveson
23461	SP	9566	Jardim Cidade Azul	Jd C Azul
23462	SP	9566	Jardim Claret	Jd Claret
23463	SP	9566	Jardim Conduta	Jd Conduta
23465	SP	9566	Jardim das Paineiras	Jd Paineiras
23469	SP	9566	Jardim Donângela	Jd Donângela
23470	SP	9566	Jardim Esmeralda	Jd Esmeralda
23471	SP	9566	Jardim Floridiana	Jd Floridiana
23472	SP	9566	Jardim Guanabara	Jd Guanabara
23474	SP	9566	Jardim Independência	Jd Independência
23533	SP	9566	Vila Anhanguera	Vl Anhanguera
23534	SP	9566	Vila Aparecida	Vl Aparecida
23535	SP	9566	Vila Bela Vista	Vl B Vista
23536	SP	9566	Vila Cristina	Vl Cristina
23537	SP	9566	Vila do Rádio	Vl Rádio
23538	SP	9566	Vila Elizabeth (BNH)	Vl Elizabeth (BNH)
23540	SP	9566	Vila Indaiá	Vl Indaiá
23541	SP	9566	Vila Industrial	Vl Industrial
23542	SP	9566	Vila Martins	Vl Martins
23543	SP	9566	Vila Nova	Vl Nova
23544	SP	9566	Vila Operária	Vl Operária
23545	SP	9566	Vila Paulista	Vl Paulista
23546	SP	9566	Vila Romana	Vl Romana
23547	SP	9566	Vila Saibreiro	Vl Saibreiro
23548	SP	9566	Vila Santa Terezinha	Vl Sta Terezinha
23549	SP	9566	Vila Santo Antônio	Vl Sto Antônio
23551	SP	9566	Vila São Miguel	Vl S Miguel
23552	SP	9587	Bela Vista	\N
23553	SP	9587	Boa Vista	B Vista
23554	SP	9587	Buru	\N
23555	SP	9587	Centro	\N
23556	SP	9587	Cesário Loate	C Loate
23557	SP	9587	Chácara Araújo	Ch Araújo
23558	SP	9587	Chácara Halter	Ch Halter
23559	SP	9587	Chácara Iracema	Ch Iracema
23560	SP	9587	Chácara Maracajás	Ch Maracajás
23561	SP	9587	Condomínio Fechado Hermenegildo Milioni	Cond F H Milioni
23562	SP	9587	Condomínio Fechado Piccolo Paese	Cond F P Paese
23563	SP	9587	Condomínio Fechado Village Haras São Luiz	Cond F V H S Luiz
23564	SP	9587	Condomínio Fechado Village Haras São Luiz II	Cond F V H S Luiz II
23565	SP	9587	Condomínio Zuleika Jabour	Cond Z Jabour
23566	SP	9587	Condomínio Monte Belo	Cond Mte Belo
23567	SP	9587	Distrito Industrial	Dt Industrial
23568	SP	9587	Distrito Industrial II	Dt Industrial II
23569	SP	9587	Estação	\N
23570	SP	9587	Estância da Colina	Etn Colina
23571	SP	9587	Guaraú	\N
23572	SP	9587	Haras Paineiras	H Paineiras
23573	SP	9587	Itapecerica	\N
23574	SP	9587	Jardim América	Jd América
23575	SP	9587	Jardim Arquidiocesano	Jd Arquidiocesano
23576	SP	9587	Jardim Bandeirantes	Jd Bandeirantes
23577	SP	9587	Jardim Barcella	Jd Barcella
23579	SP	9587	Jardim Bom Retiro	Jd B Retiro
23580	SP	9587	Jardim Brasil	Jd Brasil
23581	SP	9587	Jardim Buru	Jd Buru
23582	SP	9587	Jardim Celani	Jd Celani
23583	SP	9587	Jardim Celani II	Jd Celani II
23584	SP	9587	Jardim da Cidade	Jd Cidade
23585	SP	9587	Jardim da Cidade II	Jd Cidade II
23646	SP	9595	Cidade Nova II	C Nova II
23647	SP	9595	Conjunto Habitacional Angelo Giubina	Cj Hab A Giubina
23648	SP	9595	Conjunto Habitacional Francisco de Cillo (INOCOOP)	Cj Hab F Cillo (INOCOOP)
23649	SP	9595	Conjunto Habitacional Roberto Romano	Cj Hab R Romano
23650	SP	9595	Conjunto Habitacional Trabalhadores	Cj Hab Trabalhadores
23651	SP	9595	Conjunto Habitacional 31 de Março (COHAB)	Cj Hab 31 Março (COHAB)
23652	SP	9595	Distrito Industrial I	Dt Industrial I
23654	SP	9595	Glebas Califórnia	G Califórnia
23655	SP	9595	Jardim Adélia	Jd Adélia
23656	SP	9595	Jardim Alfa	Jd Alfa
23657	SP	9595	Jardim Alves	Jd Alves
23658	SP	9595	Jardim Amélia	Jd Amélia
23659	SP	9595	Jardim América	Jd América
23660	SP	9595	Jardim Augusto Cavalheiro	Jd A Cavalheiro
23661	SP	9595	Jardim Batagin	Jd Batagin
23662	SP	9595	Jardim Boa Vista	Jd B Vista
23663	SP	9595	Jardim Belo Horizonte	Jd B Horizonte
23664	SP	9595	Jardim Belo Horizonte II	Jd B Horizonte II
23665	SP	9595	Jardim Boa Esperança	Jd B Esperança
23667	SP	9595	Jardim Brasília	Jd Brasília
23668	SP	9595	Jardim Cândido Bertini	Jd C Bertini
23669	SP	9595	Jardim Conceição	Jd Conceição
23670	SP	9595	Jardim das Laranjeiras	Jd Laranjeiras
23671	SP	9595	Jardim das Orquídeas	Jd Orquídeas
23672	SP	9595	Jardim Barão	Jd Barão
23673	SP	9595	Jardim dos Cedros	Jd Cedros
23674	SP	9595	Jardim Dulce	Jd Dulce
23675	SP	9595	Jardim Esmeralda	Jd Esmeralda
23676	SP	9595	Jardim Europa I	Jd Europa I
23679	SP	9595	Jardim Europa IV	Jd Europa IV
23680	SP	9595	Jardim Geriva	Jd Geriva
23681	SP	9595	Jardim Icaraí	Jd Icaraí
23682	SP	9595	Jardim Industrial	Jd Industrial
23683	SP	9595	Jardim Itamaraty	Jd Itamaraty
23684	SP	9595	Jardim Laudissi	Jd Laudissi
23685	SP	9595	Jardim Miguel Claudio Grego	Jd M C Grego
23687	SP	9595	Jardim Monte Líbano	Jd Mte Líbano
23688	SP	9595	Jardim Palmeiras	Jd Palmeiras
23689	SP	9595	Jardim Panambi	Jd Panambi
23690	SP	9595	Jardim Pântano	Jd Pântano
23691	SP	9595	Jardim Paraíso	Jd Paraíso
23692	SP	9595	Jardim Paulista	Jd Paulista
23693	SP	9595	Jardim Pérola	Jd Pérola
23694	SP	9595	Jardim Primavera	Jd Primavera
23695	SP	9595	Jardim Residencial Mariana	Jd Res Mariana
23754	SP	9595	Vila Mollon IV	Vl Mollon IV
23757	SP	9595	Vila Oliveira	Vl Oliveira
23759	SP	9595	Vila Pires	Vl Pires
23760	SP	9595	Vila Prezotto	Vl Prezotto
23761	SP	9595	Vila Romi	Vl Romi
23762	SP	9595	Vila Santa Cruz	Vl Sta Cruz
23764	SP	9595	Vila Santa Terezinha	Vl Sta Terezinha
23765	SP	9595	Vila Santana	Vl Santana
23767	SP	9595	Vila Siqueira Campos	Vl S Campos
23768	SP	9595	Vila Tereza	Vl Tereza
23771	SP	9625	Acampamento Anchieta (Blocos C e D)	Acamp Anchieta (Bls C e D)
23773	SP	9625	Bela Vista	B Vista
23774	SP	9625	Campestre	\N
23775	SP	9625	Capuava	\N
23776	SP	9625	Casa Branca	C Branca
23777	SP	9625	Casas Populares	C Populares
23778	SP	9625	Centreville	\N
23779	SP	9625	Centro	\N
23780	SP	9625	Chácara Carreiras	Ch Carreiras
23781	SP	9625	Chácara Engenho da Serra	Ch E Serra
23782	SP	9625	Cidade Recreio da Borda do Campo	C Rcr B Campo
23783	SP	9625	Cidade São Jorge	C S Jorge
23784	SP	9625	Colônia dos Pescadores	Col Pescadores
23785	SP	9625	Condomínio Maracanã	Cond Maracanã
23786	SP	9625	Conjunto Dona Beatriz	Cj Da Beatriz
23787	SP	9625	Conjunto Residencial Jardim do Estádio	Cj Res Jd Estádio
23788	SP	9625	Conjunto Residencial Planeta	Cj Res Planeta
23789	SP	9625	Estação	\N
23790	SP	9625	Estância Rio Grande	Etn R Grande
23791	SP	9625	Jardim	\N
23792	SP	9625	Jardim Aclimação	Jd Aclimação
23793	SP	9625	Jardim Águia de Ouro	Jd A Ouro
23795	SP	9625	Jardim Alvorada	Jd Alvorada
23796	SP	9625	Jardim Alzira Franco	Jd A Franco
23797	SP	9625	Jardim Ana Maria	Jd A Maria
23798	SP	9625	Jardim Bela Vista	Jd B Vista
23799	SP	9625	Jardim Bom Pastor	Jd B Pastor
23800	SP	9625	Jardim Cambuí	Jd Cambuí
23801	SP	9625	Jardim Carla	Jd Carla
23802	SP	9625	Jardim Cristiana	Jd Cristiana
23803	SP	9625	Jardim Cristiane	Jd Cristiane
23804	SP	9625	Jardim das Maravilhas	\N
23805	SP	9625	Jardim do Carmo	Jd Carmo
23807	SP	9625	Jardim do Sol	Jd Sol
23808	SP	9625	Jardim do Estádio	Jd Estádio
23809	SP	9625	Jardim Europa	Jd Europa
23810	SP	9625	Jardim Guarará	Jd Guarará
23811	SP	9625	Jardim Guaripocaba	Jd Guaripocaba
23813	SP	9625	Jardim Ipanema	Jd Ipanema
23814	SP	9625	Jardim Irene	Jd Irene
23815	SP	9625	Jardim Itapoan	Jd Itapoan
23816	SP	9625	Jardim Jaçatuba	Jd Jaçatuba
23869	SP	9625	Parque Andreense	Prq Andreense
23873	SP	9625	Jardim Clube de Campo	Jd C Campo
23874	SP	9625	Parque Rio Grande	Prq R Grande
23875	SP	9625	Região de Campo Grande	R Cpo Grande
23876	SP	9625	Sacadura Cabral	S Cabral
23877	SP	9625	Santa Maria	Sta Maria
23878	SP	9625	Santa Teresa	Sta Teresa
23879	SP	9625	Santa Teresinha	Sta Teresinha
23880	SP	9625	Santo Antônio	Sto Antônio
23881	SP	9625	São Bernardo Novo	S B Novo
23883	SP	9625	Silveira	\N
23884	SP	9625	Sítio Cassaquera	Sit Cassaquera
23885	SP	9625	Sítio dos Vianas	Sit Vianas
23886	SP	9625	Sítio Taquaral	Sit Taquaral
23887	SP	9625	Utinga	\N
23889	SP	9625	Vila Adele	Vl Adele
23890	SP	9625	Vila Alberto	Vl Alberto
23891	SP	9625	Vila Aliança	Vl Aliança
23892	SP	9625	Vila Alice	Vl Alice
23893	SP	9625	Vila Alpina	Vl Alpina
23894	SP	9625	Vila Alto de Santo André	Vl At Sto André
23895	SP	9625	Vila Alzira	Vl Alzira
23896	SP	9625	Vila Amábile Pezzolo	Vl A Pezzolo
23897	SP	9625	Vila América	Vl América
23898	SP	9625	Vila Apiaí	Vl Apiaí
23899	SP	9625	Vila Aquilino	Vl Aquilino
23900	SP	9625	Vila Arlete	Vl Arlete
23901	SP	9625	Vila Assunção	Vl Assunção
23902	SP	9625	Vila Bartira	Vl Bartira
23903	SP	9625	Vila Bastos	Vl Bastos
23904	SP	9625	Vila Bela Vista	Vl Bela Vista
23905	SP	9625	Vila Boa Vista	Vl B Vista
23906	SP	9625	Vila Camilópolis	Vl Camilópolis
23907	SP	9625	Vila Cecília Maria	Vl C Maria
23908	SP	9625	Vila Clarice	Vl Clarice
23909	SP	9625	Vila Cláudio	Vl Cláudio
23910	SP	9625	Vila Curuçá	Vl Curuçá
23911	SP	9625	Vila Dora	Vl Dora
23912	SP	9625	Vila Eldízia	Vl Eldízia
23913	SP	9625	Vila Floresta	Vl Floresta
23914	SP	9625	Vila Francisco Matarazzo	Vl F Matarazzo
23915	SP	9625	Vila Gilda	Vl Gilda
23916	SP	9625	Vila Guaraciaba	Vl Guaraciaba
23917	SP	9625	Vila Guarani	Vl Guarani
23918	SP	9625	Vila Guarará	Vl Guarará
23919	SP	9625	Vila Guiomar	Vl Guiomar
23920	SP	9625	Vila Helena	Vl Helena
23921	SP	9625	Vila Homero Thon	Vl H Thon
23922	SP	9625	Vila Humaitá	Vl Humaitá
23923	SP	9625	Vila Javri	Vl Javri
23924	SP	9625	Vila João Ramalho	Vl J Ramalho
23925	SP	9625	Vila Junqueira	Vl Junqueira
23926	SP	9625	Vila Léa	Vl Léa
23927	SP	9625	Vila Leopoldina	Vl Leopoldina
23928	SP	9625	Vila Lilica	Vl Lilica
23475	SP	9566	Jardim INOCOOP	Jd INOCOOP
23476	SP	9566	Jardim Ipanema (Expansão)	Jd Ipanema (Expansão)
23477	SP	9566	Jardim Kennedy	Jd Kennedy
23478	SP	9566	Jardim Maria Cristina	Jd M Cristina
23479	SP	9566	Jardim Matheus Maniero	Jd M Maniero
23480	SP	9566	Jardim Mirassol	Jd Mirassol
23482	SP	9566	Jardim Nova Rio Claro	Jd N R Claro
23483	SP	9566	Jardim Nova Veneza	Jd N Veneza
23484	SP	9566	Jardim Novo	Jd Novo
23486	SP	9566	Jardim Novo II	Jd Novo II
23487	SP	9566	Jardim Olinda	Jd Olinda
23488	SP	9566	Jardim Panorama	Jd Panorama
23490	SP	9566	Jardim Parque Residencial	Jd Prq Residencial
23491	SP	9566	Jardim Paulista	Jd Paulista
23492	SP	9566	Jardim Paulista II	Jd Paulista II
23493	SP	9566	Jardim Portugal	Jd Portugal
23494	SP	9566	Jardim Primavera	Jd Primavera
23495	SP	9566	Jardim Quitandinha	Jd Quitandinha
23496	SP	9566	Jardim Residencial Copacabana	Jd Res Copacabana
23497	SP	9566	Jardim Residencial das Palmeiras	Jd Res Palmeiras
23498	SP	9566	Jardim Residencial Santa Eliza	Jd Res Sta Eliza
23499	SP	9566	Jardim Residencial São José	Jd Res S José
23500	SP	9566	Jardim Rio Claro	Jd R Claro
23502	SP	9566	Jardim Santa Maria	Jd Sta Maria
23503	SP	9566	Jardim São Caetano	Jd S Caetano
23505	SP	9566	Jardim São Paulo	Jd S Paulo
23506	SP	9566	Jardim São Paulo II	Jd S Paulo II
23508	SP	9566	Jardim Sigal	Jd Sigal
23510	SP	9566	Jardim Vilage	Jd Vilage
23511	SP	9566	Jardim Wenzel	Jd Wenzel
23512	SP	9566	Município	\N
23513	SP	9566	Novo Jardim Wenzel	N Jd Wenzel
23515	SP	9566	Parque das Indústrias	Prq Indústrias
23516	SP	9566	Parque dos Eucalíptos	Prq Eucalíptos
23517	SP	9566	Parque Mãe Preta	Prq M Preta
23518	SP	9566	Parque Residencial Brasília	Prq Res Brasília
23519	SP	9566	Parque São Conrado	Prq S Conrado
23520	SP	9566	Parque São Jorge	Prq S Jorge
23521	SP	9566	Parque Universitário	Prq Universitário
23522	SP	9566	Recanto Paraíso	Rec Paraíso
23524	SP	9566	Residencial Campestre Vila Rica	Res C Vl Rica
23525	SP	9566	Residencial das Flores	Res Flores
23526	SP	9566	Residencial Florença	Res Florença
23528	SP	9566	Santana	\N
23530	SP	9566	Saúde	\N
23531	SP	9566	Distrito Industrial	Dt Industrial
23532	SP	9566	Vila Alemã	Vl Alemã
23586	SP	9587	Jardim da Cidade III	Jd Cidade III
23587	SP	9587	Jardim da Cidade IV	Jd Cidade IV
23588	SP	9587	Jardim das Nações	Jd Nações
23589	SP	9587	Jardim do Divino	Jd Divino
23590	SP	9587	Jardim Donalísio	Jd Donalísio
23591	SP	9587	Jardim Elizabeth	Jd Elizabeth
23592	SP	9587	Jardim Europa	Jd Europa
23593	SP	9587	Jardim Independência	Jd Independência
23594	SP	9587	Jardim Itaguaçu	Jd Itaguaçu
23595	SP	9587	Jardim Izaura Maria	Jd I Maria
23596	SP	9587	Jardim Maria José	Jd M José
23597	SP	9587	Jardim Marília	Jd Marília
23598	SP	9587	Jardim Municipal	Jd Municipal
23599	SP	9587	Jardim Nova Era	Jd N Era
23600	SP	9587	Jardim Paraíso	Jd Paraíso
23601	SP	9587	Jardim Primavera	Jd Primavera
23602	SP	9587	Jardim Saltense	Jd Saltense
23603	SP	9587	Jardim Santa Cruz	Jd Sta Cruz
23605	SP	9587	Jardim Santa Lúcia	Jd Sta Lúcia
23606	SP	9587	Jardim Santa Terezinha	Jd Sta Terezinha
23607	SP	9587	Jardim Santo Antônio	Jd Sto Antônio
23608	SP	9587	Jardim Santo Inácio	Jd Sto Inácio
23609	SP	9587	Vila São Francisco	Vl S Francisco
23610	SP	9587	Jardim São João	Jd S João
23611	SP	9587	Jardim São Judas Tadeu	Jd S J Tadeu
23612	SP	9587	Jardim Sevilha	Jd Sevilha
23613	SP	9587	Jardim Sontag	Jd Sontag
23614	SP	9587	Jardim Três Marias	Jd T Marias
23615	SP	9587	Jardim União	Jd União
23616	SP	9587	Jardim D'Icaraí	Jd D'Icaraí
23617	SP	9587	Lajeado	\N
23618	SP	9587	Loteamento Alberto Cintra Filho	Lot A C Filho
23619	SP	9587	Nossa Senhora do Monte Serrat	N Sra Mte Serrat
23621	SP	9587	Parque Residencial Rondon	Prq Res Rondon
23622	SP	9587	Pedregulho	\N
23623	SP	9587	Porto Góes	Pto Góes
23624	SP	9587	Salto de São José	S S José
23625	SP	9587	Seco	\N
23626	SP	9587	Terras de Santa Rosa	T Sta Rosa
23627	SP	9587	Vila Flora	Vl Flora
23628	SP	9587	Vila Henrique	Vl Henrique
23629	SP	9587	Vila Ideal	Vl Ideal
23631	SP	9587	Vila Norma	Vl Norma
23632	SP	9587	Vila Nova	Vl Nova
23633	SP	9587	Vila Progresso	Vl Progresso
23634	SP	9587	Vila Roma	Vl Roma
23635	SP	9587	Vila Romão	Vl Romão
23636	SP	9587	Vila Teixeira	Vl Teixeira
23640	SP	9595	Centro	\N
23642	SP	9595	Chácara São Carlos	Ch S Carlos
23644	SP	9595	Cidade Industrial	C Industrial
23645	SP	9595	Cidade Nova	C Nova
23696	SP	9595	Jardim Rosemary	Jd Rosemary
23697	SP	9595	Jardim Sans	Jd Sans
23698	SP	9595	Jardim Santa Alice	Jd Sta Alice
23699	SP	9595	Jardim Santa Cecília	Jd Sta Cecília
23700	SP	9595	Parque Residencial Santa Inês	Prq Res Sta Inês
23701	SP	9595	Jardim Santa Rita de Cássia	Jd Sta R Cássia
23702	SP	9595	Jardim Santo Antônio	Jd Sto Antônio
23703	SP	9595	Jardim São Fernando	Jd S Fernando
23953	SP	9625	Vila São Pedro	Vl S Pedro
23704	SP	9595	Jardim São Francisco	Jd S Francisco
23705	SP	9595	Jardim São Luiz	Jd S Luiz
23706	SP	9595	Jardim Sartori	Jd Sartori
23707	SP	9595	Jardim Turmalinas	Jd Turmalinas
23708	SP	9595	Jardim Vista Alegre	Jd V Alegre
23709	SP	9595	Lagoa Seca	Lga Seca
23710	SP	9595	Loteamento Colina Santa Bárbara	Lot C Sta Bárbara
23711	SP	9595	Loteamento Industrial	Lot Industrial
23712	SP	9595	Loteamento Planalto do Sol	Lot P Sol
23714	SP	9595	N Urbanos	\N
23715	SP	9595	Parque Eldorado	Prq Eldorado
23718	SP	9595	Parque Olaria	Prq Olaria
23720	SP	9595	Parque Residencial do Lago	Prq Res Lago
23721	SP	9595	Parque Residencial Jacira III	Prq Res Jacira III
23722	SP	9595	Parque Residencial Jacyra	Prq Res Jacyra
23723	SP	9595	Parque Residencial Rochelle	Prq Res Rochelle
23724	SP	9595	Parque Residencial Santa Rosa I	Prq Res Sta Rosa I
23726	SP	9595	Parque Residencial Zabani	Prq Res Zabani
23727	SP	9595	Recreio Alvorada	Rcr Alvorada
23728	SP	9595	Residencial Furlan	Res Furlan
23729	SP	9595	Residencial São Joaquim	Res S Joaquim
23730	SP	9595	Residencial São Joaquim II	Res S Joaquim II
23731	SP	9595	Vila Alves	Vl Alves
23732	SP	9595	Vila Aparecida	Vl Aparecida
23733	SP	9595	Vila Balan	Vl Balan
23734	SP	9595	Vila Betica	Vl Betica
23735	SP	9595	Vila Boldrin	Vl Boldrin
23736	SP	9595	Vila Borges	Vl Borges
23738	SP	9595	Vila Brasil	Vl Brasil
23739	SP	9595	Vila Breda	Vl Breda
23741	SP	9595	Vila Dainese	Vl Dainese
23742	SP	9595	Vila Diva	Vl Diva
23743	SP	9595	Vila Ferrarezi	Vl Ferrarezi
23745	SP	9595	Vila Garrido	Vl Garrido
23746	SP	9595	Vila Godoy	Vl Godoy
23747	SP	9595	Vila Grego	Vl Grego
23748	SP	9595	Vila Grego II	Vl Grego II
23750	SP	9595	Vila Linópolis I	Vl Linópolis I
23752	SP	9595	Vila Mac Knight	Vl M Knight
23753	SP	9595	Vila Maria	Vl Maria
23817	SP	9625	Jardim Jamaica	Jd Jamaica
23818	SP	9625	Jardim Joaquim Eugênio de Lima	Jd J E Lima
23819	SP	9625	Jardim Las Vegas	Jd L Vegas
23820	SP	9625	Jardim Leonilda	Jd Leonilda
23821	SP	9625	Jardim Magali	Jd Magali
23822	SP	9625	Jardim Maravilhas	Jd Maravilhas
23823	SP	9625	Jardim Marek	Jd Marek
23824	SP	9625	Jardim Maria	Jd Maria
23825	SP	9625	Jardim Marieta	Jd Marieta
23826	SP	9625	Jardim Marta	Jd Marta
23827	SP	9625	Jardim Milena	Jd Milena
23828	SP	9625	Jardim Monções	Jd Monções
23829	SP	9625	Jardim Monte Líbano	Jd Mte Líbano
23830	SP	9625	Jardim Nevada	Jd Nevada
23831	SP	9625	Jardim Nice	Jd Nice
23832	SP	9625	Jardim Ocara	Jd Ocara
23833	SP	9625	Jardim Oriental	Jd Oriental
23834	SP	9625	Jardim Paraíso	Jd Paraíso
23835	SP	9625	Jardim Pilar	Jd Pilar
23836	SP	9625	Jardim Progresso	Jd Progresso
23837	SP	9625	Jardim Renata	Jd Renata
23838	SP	9625	Jardim Rina	Jd Rina
23839	SP	9625	Jardim Riviera	Jd Riviera
23840	SP	9625	Jardim Santa Cristina	Jd Sta Cristina
23841	SP	9625	Jardim Santo Alberto	Jd Sto Alberto
23842	SP	9625	Jardim Santo André	Jd Sto André
23843	SP	9625	Jardim Santo Antônio	Jd Sto Antônio
23844	SP	9625	Jardim Santo Antônio de Pádua	Jd Sto A Pádua
23845	SP	9625	Jardim Silvana	Jd Silvana
23846	SP	9625	Jardim Sílvia	Jd Sílvia
23847	SP	9625	Jardim Stella	Jd Stella
23848	SP	9625	Jardim Stetel	Jd Stetel
23849	SP	9625	Jardim Teles de Menezes	Jd T Menezes
23850	SP	9625	Jardim Utinga	Jd Utinga
23851	SP	9625	Jardim Vila Rica	Jd Vl Rica
23852	SP	9625	Paraíso	\N
23853	SP	9625	Paranapiacaba	\N
23854	SP	9625	Parque América	Prq América
23855	SP	9625	Parque Bandeirante	Prq Bandeirante
23856	SP	9625	Parque Bandeirantes	Prq Bandeirantes
23857	SP	9625	Parque Capuava	Prq Capuava
23858	SP	9625	Parque Central	Prq Central
23859	SP	9625	Parque das Nações	Prq Nações
23860	SP	9625	Parque Erasmo Assunção	Prq E Assunção
23861	SP	9625	Parque Industriário	Prq Industriário
23862	SP	9625	Parque Jaçatuba	Prq Jaçatuba
23863	SP	9625	Parque João Ramalho	Prq J Ramalho
23865	SP	9625	Parque Marajoara	Prq Marajoara
23866	SP	9625	Parque Miami	Prq Miami
23867	SP	9625	Parque Novo Oratório	Prq N Oratório
23868	SP	9625	Parque Oratório	Prq Oratório
23929	SP	9625	Vila Linda	Vl Linda
23930	SP	9625	Vila Lucinda	Vl Lucinda
23931	SP	9625	Vila Lutécia	Vl Lutécia
23932	SP	9625	Vila Luzita	Vl Luzita
23933	SP	9625	Vila Marajó	Vl Marajó
23934	SP	9625	Vila Marek	Vl Marek
23935	SP	9625	Vila Marina	Vl Marina
23936	SP	9625	Vila Mazzei	Vl Mazzei
23937	SP	9625	Vila Metalúrgica	Vl Metalúrgica
23938	SP	9625	Vila Nova	Vl Nova
23939	SP	9625	Vila Palmares	Vl Palmares
23940	SP	9625	Vila Paraíso	Vl Paraíso
23941	SP	9625	Vila Pinheirinho	Vl Pinheirinho
23942	SP	9625	Vila Pires	Vl Pires
23943	SP	9625	Vila Príncipe de Gales	Vl Prce Gales
23944	SP	9625	Vila Progresso	Vl Progresso
23945	SP	9625	Vila Prosperidade	Vl Prosperidade
23946	SP	9625	Vila Sacadura Cabral	Vl S Cabral
23948	SP	9625	Vila Santa Teresa	Vl Sta Teresa
23950	SP	9625	Vila Santo Alberto	Vl Sto Alberto
23951	SP	9625	Vila Santo Antônio	Vl Sto Antônio
23952	SP	9625	Vila São João	Vl S João
23954	SP	9625	Vila Scarpelli	Vl Scarpelli
23955	SP	9625	Vila Silvestre	Vl Silvestre
23956	SP	9625	Vila Suíça	Vl Suíça
23957	SP	9625	Vila Tibiriçá	Vl Tibiriçá
23958	SP	9625	Vila Valparaíso	Vl Valparaíso
23959	SP	9625	Vila Velha	Vl Velha
23960	SP	9625	Vila Vilma	Vl Vilma
23961	SP	9625	Vila Vitória	Vl Vitória
23962	SP	9636	Alemoa	\N
23963	SP	9636	Aparecida	\N
23964	SP	9636	Areia Branca	A Branca
23965	SP	9636	Bom Retiro	B Retiro
23966	SP	9636	Boqueirão	\N
23967	SP	9636	Campo Grande	Cpo Grande
23968	SP	9636	Caneleira	\N
23969	SP	9636	Castelo	\N
23970	SP	9636	Centro	\N
23971	SP	9636	Chapadão do Cruzeiro	Chap Cruzeiro
23972	SP	9636	Chico de Paula	C Paula
23973	SP	9636	Docas	\N
23974	SP	9636	Embaré	\N
23975	SP	9636	Encruzilhada	\N
23976	SP	9636	Estuário	\N
23977	SP	9636	Gonzaga	\N
23978	SP	9636	Jabaquara	\N
23979	SP	9636	Jardim de Santa Teresa	Jd Sta Teresa
23980	SP	9636	José Menino	J Menino
23981	SP	9636	Macuco	\N
23982	SP	9636	Marapé	\N
23983	SP	9636	Monte Serrat	Mte Serrat
23984	SP	9636	Morro Chico de Paula	Mro C Paula
23985	SP	9636	Morro da Boa Vista	Mro B Vista
23986	SP	9636	Morro da Cachoeira	Mro Cachoeira
23987	SP	9636	Morro da Caneleira	Mro Caneleira
23988	SP	9636	Morro da Penha	Mro Penha
23989	SP	9636	Morro de Nova Cintra	Mro N Cintra
24049	SP	9640	Conjunto Habitacional Trevo	Cj Hab Trevo
24050	SP	9640	Conjunto Habitacional Valéria	Cj Hab Valéria
24051	SP	9640	Conjunto Habitacional Vinte e Um de Abril	Cj Hab V E U Abril
24052	SP	9640	Conjunto Planalto	Cj Planalto
24053	SP	9640	Conjunto Residencial Antuérpia	Cj Res Antuérpia
24054	SP	9640	Conjunto Residencial Brasília	Cj Res Brasília
24055	SP	9640	Conjunto Residencial das Hortências	Cj Res Hortências
24056	SP	9640	Conjunto Residencial das Tulipas	Cj Res Tulipas
24057	SP	9640	Conjunto Residencial das Violetas	Cj Res Violetas
24058	SP	9640	Conjunto Residencial Embaré	Cj Res Embaré
24059	SP	9640	Conjunto Residencial Enseada	Cj Res Enseada
24060	SP	9640	Conjunto Residencial Everest	Cj Res Everest
24061	SP	9640	Conjunto Residencial Freitas	Cj Res Freitas
24062	SP	9640	Conjunto Residencial Guararapes	Cj Res Guararapes
24063	SP	9640	Conjunto Residencial Guararapu	Cj Res Guararapu
24064	SP	9640	Conjunto Residencial Guarujá	Cj Res Guarujá
24065	SP	9640	Conjunto Residencial Ibirapuera	Cj Res Ibirapuera
24066	SP	9640	Conjunto Residencial Ipoa	Cj Res Ipoa
24067	SP	9640	Conjunto Residencial Iracema	Cj Res Iracema
24068	SP	9640	Conjunto Residencial Itarari	Cj Res Itarari
24069	SP	9640	Conjunto Residencial Jussara	Cj Res Jussara
24070	SP	9640	Conjunto Residencial Luciana	Cj Res Luciana
24072	SP	9640	Conjunto Residencial Natália	Cj Res Natália
24073	SP	9640	Conjunto Residencial Nova Roma	Cj Res N Roma
24074	SP	9640	Conjunto Residencial Pioneiro	Cj Res Pioneiro
24075	SP	9640	Conjunto Residencial Pombeva	Cj Res Pombeva
24076	SP	9640	Conjunto Residencial Tânia Maria	Cj Res T Maria
24077	SP	9640	Cooperativa	\N
24078	SP	9640	Curucutu	\N
24079	SP	9640	Demarchi	\N
24080	SP	9640	Estoril	\N
24081	SP	9640	Ferrazópolis	\N
24082	SP	9640	Dos Finco	D Finco
24083	SP	9640	Imigrantes	\N
24084	SP	9640	Independência	\N
24086	SP	9640	Jardim Andrea Demarchi	Jd A Demarchi
24087	SP	9640	Jardim Antares	Jd Antares
24088	SP	9640	Jardim Atlântico	Jd Atlântico
24089	SP	9640	Jardim Aurora	Jd Aurora
24090	SP	9640	Jardim Balneário Alvorada	Jd Bal Alvorada
24091	SP	9640	Jardim Bartira	Jd Bartira
24092	SP	9640	Jardim Beatriz	Jd Beatriz
24148	SP	9640	Jardim Montreal	Jd Montreal
24149	SP	9640	Jardim Nascimento	Jd Nascimento
24151	SP	9640	Jardim Netuno	Jd Netuno
24152	SP	9640	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
24153	SP	9640	Jardim Nova Petrópolis	Jd N Petrópolis
24154	SP	9640	Jardim Olavo Bilac	Jd O Bilac
24155	SP	9640	Jardim Orlandina	Jd Orlandina
24156	SP	9640	Jardim Palermo	Jd Palermo
24157	SP	9640	Jardim Palmeiras	Jd Palmeiras
24158	SP	9640	Jardim Paramount	Jd Paramount
24159	SP	9640	Jardim Petroni	Jd Petroni
24160	SP	9640	Jardim Portugal	Jd Portugal
24161	SP	9640	Jardim Regina	Jd Regina
24162	SP	9640	Jardim Represa	Jd Represa
24164	SP	9640	Jardim Santo Ignácio	Jd Sto Ignácio
24165	SP	9640	Jardim São Francisco	Jd S Francisco
24166	SP	9640	Jardim São Luís	Jd S Luís
24167	SP	9640	Jardim São Paulo	Jd S Paulo
24168	SP	9640	Jardim São Pedro	Jd S Pedro
24169	SP	9640	Jardim Saracantan	Jd Saracantan
24170	SP	9640	Jardim Silva Plano	Jd S Plano
24171	SP	9640	Jardim Silvestre	Jd Silvestre
24172	SP	9640	Jardim Silvina	Jd Silvina
24173	SP	9640	Jardim Skaff	Jd Skaff
24174	SP	9640	Jardim Thelma	Jd Thelma
24175	SP	9640	Jardim Três Marias	Jd T Marias
24176	SP	9640	Jardim Trieste	Jd Trieste
24177	SP	9640	Jardim Tupã	Jd Tupã
24178	SP	9640	Jardim Uenoyama	Jd Uenoyama
24179	SP	9640	Jardim Valdibia	Jd Valdibia
24180	SP	9640	Jardim Vera Cruz	Jd V Cruz
24181	SP	9640	Jardim Via Anchieta	Jd V Anchieta
24182	SP	9640	Jardim Vista Alegre	Jd V Alegre
24183	SP	9640	Jardim Wallace Simonsen	Jd W Simonsen
24184	SP	9640	Jardim Yrajá	Jd Yrajá
24185	SP	9640	Jordanópolis	\N
24186	SP	9640	Jurubatuba	\N
24187	SP	9640	Las Palmas	L Palmas
24188	SP	9640	Montanhão	\N
24189	SP	9640	Nova Petrópolis	N Petrópolis
24190	SP	9640	Parque Anchieta	Prq Anchieta
24191	SP	9640	Parque dos Meninos	Prq Meninos
24192	SP	9640	Parque dos Pássaros	Prq Pássaros
24193	SP	9640	Parque Esmeralda	Prq Esmeralda
24194	SP	9640	Parque Espacial	Prq Espacial
24195	SP	9640	Parque Eucaliptos	Prq Eucaliptos
24196	SP	9640	Parque Municipal	Prq Municipal
24198	SP	9640	Parque Riacho Grande	Prq Riacho Grande
24199	SP	9640	Parque Rio Grande	Prq R Grande
24200	SP	9640	Parque Santo Antônio	Prq Sto Antônio
24260	SP	9640	Vila Coca	Vl Coca
24261	SP	9640	Vila Cristiane	Vl Cristiane
24262	SP	9640	Vila Cruzeiro	Vl Cruzeiro
24263	SP	9640	Vila Damásio	Vl Damásio
24264	SP	9640	Vila Danúbio	Vl Danúbio
24265	SP	9640	Vila Dayse	Vl Dayse
24266	SP	9640	Vila Delmira	Vl Delmira
24267	SP	9640	Vila do Rio Grande	\N
24268	SP	9640	Vila do Tanque	\N
24269	SP	9640	Vila dos Galvão	Vl Galvão
24270	SP	9640	Vila Dourados	Vl Dourados
24271	SP	9640	Vila Dusi	Vl Dusi
24272	SP	9640	Vila Esther	Vl Esther
24273	SP	9640	Vila Euclides	Vl Euclides
24274	SP	9640	Vila Euro	Vl Euro
24276	SP	9640	Vila Flora	Vl Flora
24277	SP	9640	Vila Flórida	Vl Flórida
24278	SP	9640	Vila Fonte Radioativa	Vl Fnt Radioativa
24279	SP	9640	Vila Formosa	Vl Formosa
24280	SP	9640	Vila Franca	Vl Franca
24281	SP	9640	Vila Gasparini	Vl Gasparini
24282	SP	9640	Vila Gonçalves	Vl Gonçalves
24283	SP	9640	Vila Helena	Vl Helena
24284	SP	9640	Vila Império	Vl Império
24285	SP	9640	Vila Industrial	Vl Industrial
24286	SP	9640	Vila Iracema	Vl Iracema
24287	SP	9640	Vila Irene	Vl Irene
24288	SP	9640	Vila Íris	Vl Íris
24289	SP	9640	Vila Israel	Vl Israel
24290	SP	9640	Vila Jahu	Vl Jahu
24292	SP	9640	Vila Jerusalém	Vl Jerusalém
24293	SP	9640	Vila Jesuíta	Vl Jesuíta
24294	SP	9640	Vila João Basso	Vl J Basso
24295	SP	9640	Vila Jordanópolis	Vl Jordanópolis
24296	SP	9640	Vila Judite	Vl Judite
24297	SP	9640	Vila Júlia	Vl Júlia
24299	SP	9640	Vila Júpiter	Vl Júpiter
24300	SP	9640	Vila Júpiter Nova	Vl J Nova
24301	SP	9640	Vila Jurubatuba	Vl Jurubatuba
24303	SP	9640	Vila Labor	Vl Labor
24304	SP	9640	Vila Leonina	Vl Leonina
24305	SP	9640	Vila Lúcia	Vl Lúcia
24306	SP	9640	Vila Luiz Casa	Vl L Casa
24307	SP	9640	Vila Lusitânia	Vl Lusitânia
24308	SP	9640	Vila Mackenzie	Vl Mackenzie
24309	SP	9640	Vila Madalena	Vl Madalena
24310	SP	9640	Vila Magnólia	Vl Magnólia
24312	SP	9640	Vila Marchi	Vl Marchi
24313	SP	9640	Vila Margarida	Vl Margarida
24314	SP	9640	Vila Maria Luísa	Vl M Luísa
24315	SP	9640	Vila Marininha	Vl Marininha
24316	SP	9640	Vila Mariza	Vl Mariza
24317	SP	9640	Vila Marlene	Vl Marlene
24318	SP	9640	Vila Marli	Vl Marli
24319	SP	9640	Vila Moraes	Vl Moraes
24320	SP	9640	Vila Mussoline	Vl Mussoline
24321	SP	9640	Vila Mussolini	Vl Mussolini
23990	SP	9636	Morro Santa Maria	Mro Sta Maria
23991	SP	9636	Morro de Santa Teresa	Mro Sta Teresa
23992	SP	9636	Morro de Santa Teresinha	Mro Sta Teresinha
23993	SP	9636	Morro de São Bento	Mro S Bento
23994	SP	9636	Morro do Belmiro	Mro Belmiro
23995	SP	9636	Morro do Bufo	Mro Bufo
23997	SP	9636	Morro do Fontana	Mro Fontana
23998	SP	9636	Morro do Jabaquara	Mro Jabaquara
23999	SP	9636	Morro do Marape	Mro Marape
24000	SP	9636	Morro do Pacheco	Mro Pacheco
24001	SP	9636	Morro do Saboo	Mro Saboo
24002	SP	9636	Morro São Jorge	Mro S Jorge
24003	SP	9636	Paquetá	\N
24004	SP	9636	Ponta da Praia	Pnt Praia
24005	SP	9636	Rádio Club	R Club
24006	SP	9636	Saboó	\N
24007	SP	9636	Santa Maria	Sta Maria
24008	SP	9636	Vila São Jorge	Vl S Jorge
24009	SP	9636	São Manoel	S Manoel
24010	SP	9636	Vale do Quilombo	Vle Quilombo
24011	SP	9636	Valongo	\N
24012	SP	9636	Vila Belmiro	Vl Belmiro
24013	SP	9636	Vila Matias	Vl Matias
24014	SP	9636	Vila Nova	Vl Nova
24015	SP	9636	Vila Progresso	Vl Progresso
24016	SP	9636	Vila São Bento	Vl S Bento
24017	SP	9640	Alto da Serra	At Serra
24018	SP	9640	Alvarenga	\N
24019	SP	9640	Alves Dias	A Dias
24020	SP	9640	Anchieta	\N
24021	SP	9640	Assunção	\N
24022	SP	9640	Assunção Alvarenga	A Alvarenga
24024	SP	9640	Balneária	\N
24025	SP	9640	Batistini	\N
24026	SP	9640	Parque Botujuru	Prq Botujuru
24027	SP	9640	Capivari	\N
24028	SP	9640	Dos Casa	D Casa
24029	SP	9640	Centro	\N
24030	SP	9640	Chácara  Dublin Paulista	Ch D Paulista
24031	SP	9640	Chácara Rialto	Ch Rialto
24032	SP	9640	Chácara Sambura	Ch Sambura
24033	SP	9640	Chácara Sergipe	Ch Sergipe
24034	SP	9640	Cidade Gertrudes	C Gertrudes
24035	SP	9640	Cidade Jardim Nova Petrópolis	C Jd N Petrópolis
24036	SP	9640	Cidade Miramar	C Miramar
24038	SP	9640	Conjunto Habitacional Alvorada	Cj Hab Alvorada
24039	SP	9640	Conjunto Habitacional Célia	Cj Hab Célia
24040	SP	9640	Conjunto Habitacional Coluna	Cj Hab Coluna
24041	SP	9640	Conjunto Habitacional Franchini	Cj Hab Franchini
24045	SP	9640	Conjunto Habitacional Parah	Cj Hab Parah
24046	SP	9640	Conjunto Habitacional Parati	Cj Hab Parati
24047	SP	9640	Conjunto Habitacional São Fernando	Cj Hab S Fernando
24048	SP	9640	Conjunto Habitacional São Silvério	Cj Hab S Silvério
24094	SP	9640	Jardim Boa Vista	Jd B Vista
24095	SP	9640	Jardim Borborema	Jd Borborema
24096	SP	9640	Jardim Borda do Campo	Jd B Campo
24097	SP	9640	Jardim Brasilândia	Jd Brasilândia
24098	SP	9640	Jardim Brasília	Jd Brasília
24099	SP	9640	Jardim Brooklin	Jd Brooklin
24100	SP	9640	Jardim Calux	Jd Calux
24101	SP	9640	Jardim Cambui	Jd Cambui
24102	SP	9640	Jardim Campestre	Jd Campestre
24103	SP	9640	Jardim Celeste	Jd Celeste
24104	SP	9640	Jardim Chácara Inglesa	Jd Ch Inglesa
24105	SP	9640	Jardim Clarice	Jd Clarice
24106	SP	9640	Jardim Cláudia	Jd Cláudia
24107	SP	9640	Jardim Colina	\N
24108	SP	9640	Jardim Colonial	Jd Colonial
24110	SP	9640	Jardim Copacabana	Jd Copacabana
24111	SP	9640	Jardim da Colina	Jd Colina
24112	SP	9640	Jardim da Represa	\N
24113	SP	9640	Jardim Dalva	Jd Dalva
24114	SP	9640	Jardim das Acácias	Jd Acácias
24115	SP	9640	Jardim das Américas	Jd Américas
24116	SP	9640	Jardim das Cerejeiras	Jd Cerejeiras
24117	SP	9640	Jardim das Orquídeas	Jd Orquídeas
24118	SP	9640	Jardim das Palmeiras	\N
24119	SP	9640	Jardim das Quatro Marias	Jd Q Marias
24120	SP	9640	Jardim Detroit	Jd Detroit
24121	SP	9640	Jardim do Imperador	Jd Imperador
24122	SP	9640	Jardim do Lago	Jd Lago
24123	SP	9640	Jardim do Lago Azul	Jd Lg Azul
24124	SP	9640	Jardim do Mar	Jd Mar
24125	SP	9640	Jardim Dom Alfonso	Jd D Alfonso
24126	SP	9640	Jardim Dona Luíza	Jd Da Luíza
24127	SP	9640	Jardim Embaré	Jd Embaré
24129	SP	9640	Jardim Fada	Jd Fada
24130	SP	9640	Jardim Farina	Jd Farina
24131	SP	9640	Vila Fênix	Vl Fênix
24132	SP	9640	Jardim Gagliardi	Jd Gagliardi
24133	SP	9640	Jardim Hollywood	Jd Hollywood
24134	SP	9640	Jardim Icarai	Jd Icarai
24135	SP	9640	Jardim Independência	Jd Independência
24136	SP	9640	Jardim Ipê	Jd Ipê
24137	SP	9640	Jardim Iracema	Jd Iracema
24138	SP	9640	Jardim Jussara	Jd Jussara
24139	SP	9640	Jardim Laura	Jd Laura
24140	SP	9640	Jardim Lauro Gomes	Jd L Gomes
24141	SP	9640	Jardim Lavínia	Jd Lavínia
24142	SP	9640	Jardim Leblon	Jd Leblon
24143	SP	9640	Jardim Maria Adelaide	Jd M Adelaide
24144	SP	9640	Jardim Maria Cecília	Jd M Cecília
24145	SP	9640	Jardim Marina	Jd Marina
24146	SP	9640	Jardim Marrocos	Jd Marrocos
24147	SP	9640	Jardim Monte Carlo	Jd Mte Carlo
24201	SP	9640	Parque São Bernardo	Prq S Bernardo
24202	SP	9640	Parque São Diogo	Prq S Diogo
24203	SP	9640	Parque São José	Prq S José
24204	SP	9640	Parque São Pedro	Prq S Pedro
24205	SP	9640	Parque Selecta(Montanhão)	Prq Selecta (Montanhão)
24206	SP	9640	Parque Silvaplana	Prq Silvaplana
24207	SP	9640	Parque Terra Nova	Prq T Nova
24208	SP	9640	Parque Terra Nova II	Prq T Nova II
24209	SP	9640	Parque Turmalina	Prq Turmalina
24210	SP	9640	Pasto da Grama	P Grama
24211	SP	9640	Paulicéia	\N
24212	SP	9640	Planalto	\N
24213	SP	9640	Recanto Pesca Rica	Rec P Rica
24214	SP	9640	Riacho Grande	\N
24215	SP	9640	Rio Grande	R Grande
24217	SP	9640	Royal Park	R Park
24218	SP	9640	Rudge Ramos	R Ramos
24219	SP	9640	Santa Terezinha	Sta Terezinha
24220	SP	9640	Santos Dumont	Stos Dumont
24221	SP	9640	São Bernardo Mirim	S B Mirim
24222	SP	9640	Sítio Bela Vista	Sit B Vista
24223	SP	9640	Sítio das Garças	Sit Garças
24224	SP	9640	Sítio Jandaia	Sit Jandaia
24225	SP	9640	Sítio Paulicéia	Sit Paulicéia
24227	SP	9640	Suíço	\N
24228	SP	9640	Taboão	\N
24229	SP	9640	Taquacetuba	\N
24230	SP	9640	Tatetos	\N
24231	SP	9640	Varginha	\N
24232	SP	9640	Vila Adriana	Vl Adriana
24233	SP	9640	Vila Afonsina	Vl Afonsina
24234	SP	9640	Vila Alcântara	Vl Alcântara
24235	SP	9640	Vila Álvaro Marques	Vl A Marques
24237	SP	9640	Vila Alvinópolis	Vl Alvinópolis
24238	SP	9640	Vila América	Vl América
24239	SP	9640	Vila Angelina	Vl Angelina
24240	SP	9640	Vila Anita	Vl Anita
24241	SP	9640	Vila Antonieta	Vl Antonieta
24242	SP	9640	Vila Antunes	Vl Antunes
24243	SP	9640	Vila Armando Bondioli	Vl A Bondioli
24244	SP	9640	Vila Artuélia	Vl Artuélia
24245	SP	9640	Vila Áurea	Vl Áurea
24246	SP	9640	Vila Aurora	Vl Aurora
24247	SP	9640	Baeta Neves	B Neves
24248	SP	9640	Vila Balneária	Vl Balneária
24249	SP	9640	Vila Beatriz	Vl Beatriz
24250	SP	9640	Vila Boa Viagem	Vl B Viagem
24251	SP	9640	Vila Brasília	Vl Brasília
24252	SP	9640	Vila Cacilda	Vl Cacilda
24253	SP	9640	Vila Camargo	Vl Camargo
24254	SP	9640	Vila Caminho do Mar	Vl Cam Mar
24255	SP	9640	Vila Campestre	Vl Campestre
24256	SP	9640	Vila Carminha	Vl Carminha
24257	SP	9640	Vila Cerâmica	Vl Cerâmica
24258	SP	9640	Vila Claraval	Vl Claraval
24259	SP	9640	Vila Clarisse	Vl Clarisse
24322	SP	9640	Vila Netuno	Vl Netuno
24323	SP	9640	Vila Normandia	Vl Normandia
24324	SP	9640	Vila Nova Santa Luzia	Vl N Sta Luzia
24325	SP	9640	Vila Odete	Vl Odete
24326	SP	9640	Vila Olga	Vl Olga
24327	SP	9640	Vila Planalto	Vl Planalto
24328	SP	9640	Vila Praia Grande	Vl Pr Grande
24329	SP	9640	Vila Primavera	Vl Primavera
24330	SP	9640	Vila Progressista	Vl Progressista
24331	SP	9640	Vila Quirino de Lima	Vl Q Lima
24332	SP	9640	Vila Rica	Vl Rica
24333	SP	9640	Vila Rio Grande	Vl R Grande
24335	SP	9640	Vila Rosa	Vl Rosa
24338	SP	9640	Vila Ruth	Vl Ruth
24339	SP	9640	Vila Sacilotto	Vl Sacilotto
24340	SP	9640	Vila Santa Angelina	Vl Sta Angelina
24341	SP	9640	Vila Santa Cássia	Vl Sta Cássia
24342	SP	9640	Vila Santa Eugênia	Vl Sta Eugênia
24343	SP	9640	Vila Santa Filomena	Vl Sta Filomena
24344	SP	9640	Vila Santa Izabel	Vl Sta Izabel
24345	SP	9640	Vila Santa Luzia	Vl Sta Luzia
24346	SP	9640	Vila Santa Rita de Cássia	Vl Sta R Cássia
24347	SP	9640	Vila Santa Terezinha	Vl Sta Terezinha
24348	SP	9640	Vila Santo Agostinho	Vl Sto Agostinho
24349	SP	9640	Vila São João	Vl S João
24351	SP	9640	Vila São Leopoldo	Vl S Leopoldo
24352	SP	9640	Vila São Marcos	Vl S Marcos
24353	SP	9640	Vila São Savino	Vl S Savino
24354	SP	9640	Vila São Silvério	Vl S Silvério
24355	SP	9640	Vila Saracatan	Vl Saracatan
24356	SP	9640	Vila Scopel	Vl Scopel
24357	SP	9640	Vila Sésamo	Vl Sésamo
24358	SP	9640	Vila Sílvia	Vl Sílvia
24359	SP	9640	Vila Simone	Vl Simone
24360	SP	9640	Vila Sônia	Vl Sônia
24362	SP	9640	Vila Suzana	Vl Suzana
24363	SP	9640	Vila Suzi	Vl Suzi
24364	SP	9640	Vila Tanque	Vl Tanque
24365	SP	9640	Vila Tereza	Vl Tereza
24366	SP	9640	Vila Tila	Vl Tila
24367	SP	9640	Vila Tocantins	Vl Tocantins
24368	SP	9640	Vila Tsukamoto	Vl Tsukamoto
24369	SP	9640	Vila Tupi	Vl Tupi
24370	SP	9640	Vila Uras	Vl Uras
24372	SP	9640	Vila Vianas	Vl Vianas
24373	SP	9640	Vila Village	Vl Village
24374	SP	9640	Vila Vivaldi	Vl Vivaldi
24375	SP	9640	Vila Washington	Vl Washington
24376	SP	9640	Vila Weida	Vl Weida
24377	SP	9640	Yara Praia	Y Praia
24378	SP	9640	Zanzala	\N
24379	SP	9642	Barcelona	\N
24380	SP	9642	Boa Vista	B Vista
24381	SP	9642	Centro	\N
24382	SP	9642	Cerâmica	\N
24383	SP	9642	Fundação	\N
24477	SP	9643	Jardim Santa Tereza	Jd Sta Tereza
24478	SP	9643	Jardim São Carlos	Jd S Carlos
24479	SP	9643	Jardim São Carlos 5	Jd S Carlos 5
24480	SP	9643	Jardim São João Batista	Jd S J Batista
24481	SP	9643	Jardim São Paulo	Jd S Paulo
24482	SP	9643	Jardim São Rafael	Jd S Rafael
24484	SP	9643	Jardim Tangará	Jd Tangará
24486	SP	9643	Loteamento Albertini	Lot Albertini
24493	SP	9643	Loteamento Habitacional São Carlos 1	Lot Hab S Carlos 1
24495	SP	9643	Loteamento Habitacional São Carlos 2	Lot Hab S Carlos 2
24498	SP	9643	Loteamento Municipal São Carlos 3	Lot M S Carlos 3
24499	SP	9643	Loteamento Municipal São Carlos 4	Lot M S Carlos 4
24502	SP	9643	Morada dos Deuses	M Deuses
24503	SP	9643	Núcleo Residencial Castelo Branco	Nuc Res C Branco
24504	SP	9643	Núcleo Residencial Silvio Vilari	Nuc Res S Vilari
24506	SP	9643	Parque Arnold Schimidt	Prq A Schimidt
24508	SP	9643	Parque Delta	Prq Delta
24515	SP	9643	Parque Paraíso	Prq Paraíso
24516	SP	9643	Parque Primavera	Prq Primavera
24517	SP	9643	Parque Residencial Maria Stella Faga	Prq Res M S Faga
24518	SP	9643	Parque Sabará	Prq Sabará
24519	SP	9643	Parque Santa Felícia Jardim	Prq Sta F Jardim
24520	SP	9643	Parque Santa Marta	Prq Sta Marta
24521	SP	9643	Parque Santa Mônica	Prq Sta Mônica
24523	SP	9643	Parque São José	Prq S José
24524	SP	9643	Parque Sisi	Prq Sisi
24526	SP	9643	Planalto Paraíso	P Paraíso
24527	SP	9643	Portal do Sol	P Sol
24531	SP	9643	Recreio São Judas Tadeu	Rcr S J Tadeu
24532	SP	9643	Residencial Samambaia	Res Samambaia
24539	SP	9643	Vila Alpes	Vl Alpes
24540	SP	9643	Vila Arnaldo	Vl Arnaldo
24541	SP	9643	Vila Bela Vista	Vl Bela Vista
24542	SP	9643	Vila Boa Vista	Vl B Vista
24546	SP	9643	Vila Boa Vista 1	Vl B Vista 1
24549	SP	9643	Vila Brasília	Vl Brasília
24551	SP	9643	Vila Carmem	Vl Carmem
24552	SP	9643	Vila Celina	Vl Celina
24553	SP	9643	Vila Conceição	Vl Conceição
24554	SP	9643	Vila Costa do Sol	Vl C Sol
24555	SP	9643	Vila Deriggi	Vl Deriggi
24556	SP	9643	Vila Elizabeth	Vl Elizabeth
24559	SP	9643	Vila Faria	Vl Faria
24560	SP	9643	Vila Irene	Vl Irene
24561	SP	9643	Vila Izabel	Vl Izabel
24562	SP	9643	Vila Jacobucci	Vl Jacobucci
24563	SP	9643	Vila Laura	Vl Laura
24624	SP	9647	Jardim Nova São João	Jd N S João
24625	SP	9647	Jardim Novo Horizonte	Jd N Horizonte
24627	SP	9647	Jardim Primeiro de Maio	Jd P Maio
24628	SP	9647	Jardim Priscila	Jd Priscila
24629	SP	9647	Jardim Progresso	Jd Progresso
24630	SP	9647	Jardim Recanto	Jd Recanto
24631	SP	9647	Jardim Recanto do Jaguari	Jd Rec Jaguari
24632	SP	9647	Jardim Recreio	Jd Recreio
24633	SP	9647	Jardim Santa Clara	Jd Sta Clara
24634	SP	9647	Jardim Santa Helena	Jd Sta Helena
24635	SP	9647	Jardim Santa Rita	Jd Sta Rita
24636	SP	9647	Jardim Santa Rita II	Jd Sta Rita II
24637	SP	9647	Jardim Santarém	Jd Santarém
24638	SP	9647	Jardim Santiago Penha	Jd S Penha
24639	SP	9647	Jardim Santo André	Jd Sto André
24640	SP	9647	Jardim São João	Jd S João
24641	SP	9647	Jardim São Jorge	Jd S Jorge
24643	SP	9647	Jardim São Manoel	Jd S Manoel
24644	SP	9647	Jardim São Nicolau	Jd S Nicolau
24645	SP	9647	Jardim São Paulo	Jd S Paulo
24646	SP	9647	Jardim São Thiago	Jd S Thiago
24647	SP	9647	Jardim Satélite	Jd Satélite
24648	SP	9647	Jardim Sol Nascente	Jd S Nascente
24649	SP	9647	Jardim Trianon	Jd Trianon
24650	SP	9647	Jardim Vale do Sol	Jd Vle Sol
24651	SP	9647	Jardim Vila Rica	Jd Vl Rica
24652	SP	9647	Lagoa dos Patos	Lga Patos
24654	SP	9647	Núcleo Durval Nicolau (Etapa 1)	Nuc D Nicolau (Etapa 1)
24655	SP	9647	Núcleo Durval Nicolau (Etapa 2)	Nuc D Nicolau (Etapa 2)
24656	SP	9647	Núcleo Habitacional Eugênio S Mathias	Nuc Hab E S Mathias
24657	SP	9647	Núcleo Residencial Durval Nicolau 3	Nuc Res D Nicolau 3
24658	SP	9647	Parque Colina da Mantiqueira	Prq C Mantiqueira
24659	SP	9647	Parque das Nações	Prq Nações
24660	SP	9647	Parque Jequitibás	Prq Jequitibás
24661	SP	9647	Parque Residencial Jardim São Domingos	Prq Res Jd S Domingos
24662	SP	9647	Parque Residencial Tereza Cristina	Prq Res T Cristina
24663	SP	9647	Perpétuo Socorro	P Socorro
24664	SP	9647	Pousada do Sol	P Sol
24665	SP	9647	Pratinha	\N
24666	SP	9647	Recanto das Paineiras	Rec Paineiras
24667	SP	9647	Recanto do Bosque	Rec Bosque
24668	SP	9647	Rosário	\N
24669	SP	9647	Solário da Mantiqueira	S Mantiqueira
24671	SP	9647	São Benedito	S Benedito
24672	SP	9647	São Lázaro	S Lázaro
24673	SP	9647	São Marcos	S Marcos
24734	SP	9659	Jardim Alto Alegre	Jd At Alegre
24735	SP	9659	Jardim Alto Rio Preto	Jd At R Preto
24736	SP	9659	Jardim Alvorada	Jd Alvorada
24737	SP	9659	Jardim América	Jd América
24739	SP	9659	Jardim Analice	Jd Analice
24740	SP	9659	Jardim Anice	Jd Anice
24741	SP	9659	Jardim Anielli	Jd Anielli
24742	SP	9659	Jardim Antunes	Jd Antunes
24743	SP	9659	Jardim Bela Vista	Jd B Vista
24745	SP	9659	Jardim Bordon	Jd Bordon
24747	SP	9659	Jardim Canaã	Jd Canaã
24748	SP	9659	Jardim Caparroz	Jd Caparroz
24749	SP	9659	Jardim Castelinho	Jd Castelinho
24751	SP	9659	Jardim Conceição	Jd Conceição
24752	SP	9659	Jardim Congonhas	Jd Congonhas
24753	SP	9659	Jardim das Oliveiras	Jd Oliveiras
24754	SP	9659	Jardim do Bosque	Jd Bosque
24755	SP	9659	Jardim do Lago	Jd Lago
24756	SP	9659	Jardim dos Gomes	Jd Gomes
24757	SP	9659	Jardim dos Seixas	Jd Seixas
24758	SP	9659	Jardim Estrela	Jd Estrela
24759	SP	9659	Jardim Europa	Jd Europa
24760	SP	9659	Jardim Francisco Fernandes	Jd F Fernandes
24761	SP	9659	Jardim Fuscaldo	Jd Fuscaldo
24762	SP	9659	Jardim Gisette	Jd Gisette
24763	SP	9659	Jardim Herculano	Jd Herculano
24764	SP	9659	Jardim Itapema	Jd Itapema
24766	SP	9659	Jardim João Paulo II	Jd J Paulo II
24767	SP	9659	Jardim Laranjeiras	Jd Laranjeiras
24768	SP	9659	Jardim Los Angeles	Jd L Angeles
24769	SP	9659	Jardim Manoel Del Arco	Jd M D Arco
24770	SP	9659	Jardim Maracanã	Jd Maracanã
24771	SP	9659	Jardim Marajó	Jd Marajó
24772	SP	9659	Jardim Maria Cândida	Jd M Cândida
24773	SP	9659	Jardim Maria Lúcia	Jd M Lúcia
24774	SP	9659	Jardim Michel Jacob	Jd M Jacob
24775	SP	9659	Jardim Mona	Jd Mona
24776	SP	9659	Jardim Morumbi	Jd Morumbi
24777	SP	9659	Jardim Moysés Miguel Haddad	Jd M M Haddad
24778	SP	9659	Jardim Mugnaini	Jd Mugnaini
24779	SP	9659	Jardim Municipal	Jd Municipal
24780	SP	9659	Jardim Nazareth	Jd Nazareth
24781	SP	9659	Jardim Norte	Jd Norte
24782	SP	9659	Jardim Novo Aeroporto	Jd N Aeroporto
24783	SP	9659	Jardim Novo Mundo	Jd N Mundo
24784	SP	9659	Jardim Nunes	Jd Nunes
24785	SP	9659	Jardim Ouro Verde	Jd O Verde
24786	SP	9659	Jardim Palmeiras	Jd Palmeiras
24787	SP	9659	Jardim Panorama	Jd Panorama
24788	SP	9659	Jardim Paraíso	Jd Paraíso
24838	SP	9659	Parque Jaguaré	Prq Jaguaré
24839	SP	9659	Parque Quinta das Paineiras	Prq Qta Paineiras
24840	SP	9659	Parque Residencial Atlântica	Prq Res Atlântica
24841	SP	9659	Parque Residencial Comendador Mancor Daud	Prq Res Cdor M Daud
24842	SP	9659	Conjunto Habitacional Cristo Rei	Cj Hab C Rei
24843	SP	9659	Parque Residencial Damha	Prq Res Damha
24844	SP	9659	Parque Residencial Dom Lafaiete Libânio	Prq Res D L Libânio
24845	SP	9659	Parque Residencial João da Silva	Prq Res J Silva
24846	SP	9659	Parque Residencial Joaquim Nabuco	Prq Res J Nabuco
24847	SP	9659	Parque Residencial Lauriano Tebar	Prq Res L Tebar
24848	SP	9659	Parque Residencial Romano Calil	Prq Res R Calil
24849	SP	9659	Parque São Miguel	Prq S Miguel
24850	SP	9659	Pinheiros	\N
24851	SP	9659	Jardim Redentor	Jd Redentor
24852	SP	9659	Residencial Ana Célia	Res A Célia
24854	SP	9659	Residencial Anna Angélica	Res A Angélica
24855	SP	9659	Residencial Cidade Jardim	Res C Jardim
24856	SP	9659	Conjunto Habitacional Duas Vendas	Cj Hab D Vendas
24857	SP	9659	Residencial Gabriela	Res Gabriela
24858	SP	9659	Residencial Garcia	Res Garcia
24859	SP	9659	Residencial Jardim Antonieta	Res Jd Antonieta
24861	SP	9659	Residencial Macedo Teles I	Res M Teles I
24862	SP	9659	Residencial Macedo Teles II	Res M Teles II
24864	SP	9659	Roseiral	\N
24865	SP	9659	Santos Dumont	Stos Dumont
24866	SP	9659	São Francisco	S Francisco
24867	SP	9659	Solo Sagrado	S Sagrado
24868	SP	9659	Solo Sagrado I	S Sagrado I
24870	SP	9659	Universitário	\N
24871	SP	9659	Vila Aeroporto	Vl Aeroporto
24872	SP	9659	Vila Anchieta	Vl Anchieta
24873	SP	9659	Vila Angélica	Vl Angélica
24874	SP	9659	Vila Aurora	Vl Aurora
24875	SP	9659	Vila Bancário	Vl Bancário
24876	SP	9659	Vila Boa Esperança	Vl B Esperança
24877	SP	9659	Vila Bom Jesus	Vl B Jesus
24878	SP	9659	Vila Clementina	Vl Clementina
24879	SP	9659	Vila Cristina	Vl Cristina
24880	SP	9659	Vila Curti	Vl Curti
24881	SP	9659	Vila Dias	Vl Dias
24882	SP	9659	Vila Diniz	Vl Diniz
24883	SP	9659	Vila Diva	Vl Diva
24884	SP	9659	Vila Dório	Vl Dório
24885	SP	9659	Vila Elmaz	Vl Elmaz
24886	SP	9659	Vila Elvira	Vl Elvira
24887	SP	9659	Vila Ercília	Vl Ercília
24384	SP	9642	Jardim São Caetano	Jd S Caetano
24385	SP	9642	Mauá	\N
24386	SP	9642	Nova Gerty	N Gerty
24387	SP	9642	Olímpico	\N
24388	SP	9642	Osvaldo Cruz	O Cruz
24389	SP	9642	Prosperidade	\N
24390	SP	9642	Santa Maria	Sta Maria
24391	SP	9642	Santa Paula	Sta Paula
24392	SP	9642	Santo Antônio	Sto Antônio
24393	SP	9642	São José	S José
24399	SP	9643	Azulville I	\N
24400	SP	9643	Azulville 2	\N
24401	SP	9643	Centreville	\N
24402	SP	9643	Centro	\N
24411	SP	9643	Chácara Parollo	Ch Parollo
24412	SP	9643	Chácara Parque Club	Ch Prq Club
24415	SP	9643	Chácara São João	Ch S João
24416	SP	9643	Cidade Aracy	C Aracy
24417	SP	9643	Cidade Jardim	C Jardim
24420	SP	9643	Distrito Industrial Miguel Abdelnur	Dt Ind M Abdelnur
24432	SP	9643	Jardim Alvorada	Jd Alvorada
24433	SP	9643	Jardim Bandeirantes	Jd Bandeirantes
24434	SP	9643	Jardim Beatriz	Jd Beatriz
24435	SP	9643	Jardim Bethânia	Jd Bethânia
24436	SP	9643	Jardim Botafogo 1	Jd Botafogo 1
24440	SP	9643	Jardim Brasil	Jd Brasil
24441	SP	9643	Jardim Cardinalli	Jd Cardinalli
24442	SP	9643	Jardim Centenário	Jd Centenário
24443	SP	9643	Jardim Cruzeiro do Sul	Jd C Sul
24445	SP	9643	Jardim das Torres	Jd Torres
24446	SP	9643	Jardim Dona Francisca	Jd Da Francisca
24447	SP	9643	Jardim Gibertoni	Jd Gibertoni
24448	SP	9643	Jardim Gonzaga	Jd Gonzaga
24449	SP	9643	Jardim Guanabara	Jd Guanabara
24450	SP	9643	Jardim Hikare	Jd Hikare
24453	SP	9643	Jardim Jóckei Club A	Jd J Club A
24454	SP	9643	Jardim Lutfalla	Jd Lutfalla
24455	SP	9643	Jardim Macarengo	Jd Macarengo
24456	SP	9643	Jardim Maracanã	Jd Maracanã
24457	SP	9643	Jardim Maria Alice	Jd M Alice
24458	SP	9643	Jardim Medeiros	Jd Medeiros
24459	SP	9643	Jardim Mercedes	Jd Mercedes
24460	SP	9643	Jardim Munique	Jd Munique
24461	SP	9643	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
24462	SP	9643	Jardim Nova Santa Paula	Jd N Sta Paula
24463	SP	9643	Jardim Nova São Carlos	Jd N S Carlos
24464	SP	9643	CEAT	\N
24465	SP	9643	Jardim Pacaembu	Jd Pacaembu
24466	SP	9643	Jardim Paraíso	Jd Paraíso
24467	SP	9643	Jardim Paulista	Jd Paulista
24468	SP	9643	Jardim Paulistano	Jd Paulistano
24469	SP	9643	Jardim Real	Jd Real
24470	SP	9643	Jardim Ricetti	Jd Ricetti
24475	SP	9643	Jardim Santa Paula	Jd Sta Paula
24565	SP	9643	Vila Lutfalla	Vl Lutfalla
24568	SP	9643	Vila Marigo	Vl Marigo
24569	SP	9643	Vila Marina	Vl Marina
24571	SP	9643	Vila Monte Carlo	Vl Mte Carlo
24572	SP	9643	Vila Monteiro (Gleba I)	Vl Monteiro (Gleba I)
24573	SP	9643	Vila Morumbi	Vl Morumbi
24575	SP	9643	Vila Nery	Vl Nery
24576	SP	9643	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
24578	SP	9643	Vila Pelicano	Vl Pelicano
24579	SP	9643	Vila Prado	Vl Prado
24580	SP	9643	Vila Pureza	Vl Pureza
24581	SP	9643	Vila Rancho Velho	Vl R Velho
24583	SP	9643	Vila Santa Madre Cabrini	Vl Sta Me Cabrini
24585	SP	9643	Chácara São Caetano	Ch S Caetano
24588	SP	9643	Vila São José	Vl S José
24589	SP	9643	Vila Sonia	Vl Sonia
24590	SP	9643	Vila Vista Alegre	Vl V Alegre
24592	SP	9647	Alto da Boa Vista	At B Vista
24593	SP	9647	Areião	\N
24594	SP	9647	Centro	\N
24595	SP	9647	Chácara Rosa Dias	Ch R Dias
24596	SP	9647	Conceição	\N
24597	SP	9647	Conjunto Residencial Nossa Senhora de Fátima	Cj Res N Sra Fátima
24598	SP	9647	Distrito Industrial	Dt Industrial
24599	SP	9647	Jardim Aeroporto Eldorado	Jd Aer Eldorado
24600	SP	9647	Jardim Amélia	Jd Amélia
24602	SP	9647	Jardim Bela Vista	Jd B Vista
24603	SP	9647	Jardim Canadá	Jd Canadá
24604	SP	9647	Jardim Cledirna	Jd Cledirna
24605	SP	9647	Jardim Crepúsculo	Jd Crepúsculo
24606	SP	9647	Jardim da Glória	Jd Glória
24607	SP	9647	Jardim Del Plata	Jd D Plata
24608	SP	9647	Jardim Dona Tereza	Jd Da Tereza
24609	SP	9647	Jardim Dona Tereza II	Jd Da Tereza II
24610	SP	9647	Jardim dos Eucaliptos	Jd Eucaliptos
24611	SP	9647	Jardim Eldorado	Jd Eldorado
24612	SP	9647	Jardim Fleming	Jd Fleming
24613	SP	9647	Jardim Guanabara	Jd Guanabara
24614	SP	9647	Jardim Industrial	Jd Industrial
24615	SP	9647	Jardim Itália	Jd Itália
24616	SP	9647	Jardim Leonor	Jd Leonor
24617	SP	9647	Jardim Magalhães	Jd Magalhães
24618	SP	9647	Jardim Michelazzo	Jd Michelazzo
24619	SP	9647	Jardim Molinari	Jd Molinari
24620	SP	9647	Jardim Nova República	Jd N República
24621	SP	9647	Jardim Nova República (2ª Etapa)	Jd N República (2ª Etapa)
24622	SP	9647	Jardim Nova República (3ª Etapa)	Jd N República (3ª Etapa)
24623	SP	9647	Jardim Nova República (4ª Etapa)	Jd N República (4ª Etapa)
24676	SP	9647	Vila Bela	Vl Bela
24677	SP	9647	Vila Brasil	Vl Brasil
24678	SP	9647	Vila Carvalho	Vl Carvalho
24680	SP	9647	Vila Clayton	Vl Clayton
24681	SP	9647	Vila Conceição	Vl Conceição
24682	SP	9647	Vila Conrado	Vl Conrado
24683	SP	9647	Vila Damáglio	Vl Damáglio
24685	SP	9647	Vila Fleming	Vl Fleming
24686	SP	9647	Vila Gomes	Vl Gomes
24688	SP	9647	Vila Loyola	Vl Loyola
24689	SP	9647	Vila Luzitana	Vl Luzitana
24690	SP	9647	Vila Magnólia	Vl Magnólia
24691	SP	9647	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
24692	SP	9647	Vila Operária	Vl Operária
24693	SP	9647	Vila Oriental	Vl Oriental
24695	SP	9647	Vila Santa Adélia	Vl Sta Adélia
24696	SP	9647	Vila Santa Edwirges	Vl Sta Edwirges
24697	SP	9647	Vila Tenente Vasconcelos	Vl Ten Vasconcelos
24698	SP	9647	Vila Trafani	Vl Trafani
24699	SP	9647	Vila Valentin	Vl Valentin
24700	SP	9647	Vila Valentin Nova	Vl V Nova
24701	SP	9647	Vila Westin	Vl Westin
24702	SP	9647	Vila Zanetti	Vl Zanetti
24703	SP	9659	Boa Vista	B Vista
24704	SP	9659	Bom Jardim	B Jardim
24705	SP	9659	Bosque da Felicidade	Bsq Felicidade
24706	SP	9659	Bosque da Saúde	Bsq Saúde
24707	SP	9659	Cecap	\N
24708	SP	9659	Centenário da Emancipação	Cent Emancipação
24709	SP	9659	Centro	\N
24710	SP	9659	Chácara Municipal	Ch Municipal
24711	SP	9659	Chácara Tranqüilidade	Ch Tranqüilidade
24713	SP	9659	Cidade Nova	C Nova
24714	SP	9659	Condomínio Bourgainville	Cond Bourgainville
24715	SP	9659	Condomínio Débora Cristina	Cond D Cristina
24716	SP	9659	Conjunto Habitacional CAIC	Cj Hab CAIC
24717	SP	9659	Conjunto Habitacional Costa do Sol	Cj Hab C Sol
24719	SP	9659	Conjunto Habitacional São Deocleciano	Cj Hab S Deocleciano
24720	SP	9659	Conjunto Habitacional São José do Rio Preto	Cj Hab S J R Preto
24721	SP	9659	Distrito Industrial	Dt Industrial
24722	SP	9659	Distrito Industrial Doutor Carlos Arnaldo e Silva	Dt Ind Dr C A E Silva
24723	SP	9659	Distrito Industrial Doutor Ulysses da Silveira Guimarães	Dt Ind Dr U S Guimarães
24726	SP	9659	Eldorado	\N
24727	SP	9659	Encantado	\N
24729	SP	9659	Gonzaga de Campos	G Campos
24730	SP	9659	Higienópolis	\N
24731	SP	9659	Jardim Aclimação	Jd Aclimação
24733	SP	9659	Jardim Alice	Jd Alice
24789	SP	9659	Jardim Paulista	Jd Paulista
24790	SP	9659	Jardim Planalto	Jd Planalto
24791	SP	9659	Jardim Primavera	Jd Primavera
24792	SP	9659	Jardim Regina Maura	Jd R Maura
24793	SP	9659	Jardim Residencial Etemp	Jd Res Etemp
24794	SP	9659	Jardim Residencial Vetorasso	Jd Res Vetorasso
24795	SP	9659	Jardim Roseana	Jd Roseana
24796	SP	9659	Jardim Rosely	Jd Rosely
24797	SP	9659	Jardim Santa Catarina	Jd Sta Catarina
24798	SP	9659	Jardim Santa Lúcia	Jd Sta Lúcia
24799	SP	9659	Jardim Santa Luzia	Jd Sta Luzia
24800	SP	9659	Jardim Santa Maria	Jd Sta Maria
24801	SP	9659	Jardim Santa Rosa I	Jd Sta Rosa I
24802	SP	9659	Jardim Santa Rosa II	Jd Sta Rosa II
24803	SP	9659	Jardim Santo Antônio	Jd Sto Antônio
24804	SP	9659	Jardim São Marco	Jd S Marco
24805	SP	9659	Jardim São Paulo	Jd S Paulo
24806	SP	9659	Jardim São Vicente	Jd S Vicente
24807	SP	9659	Jardim Seyon	Jd Seyon
24808	SP	9659	Jardim Simões	Jd Simões
24809	SP	9659	Jardim Sônia	Jd Sônia
24810	SP	9659	Jardim Soraia	Jd Soraia
24812	SP	9659	Jardim Suzana	Jd Suzana
24813	SP	9659	Jardim Tangará	Jd Tangará
24814	SP	9659	Jardim Tarraf	Jd Tarraf
24815	SP	9659	Jardim Tarraf II	Jd Tarraf II
24816	SP	9659	Jardim Urano	Jd Urano
24817	SP	9659	Jardim Urupês	Jd Urupês
24818	SP	9659	Jardim Vale do Sol	Jd Vle Sol
24819	SP	9659	Jardim Vieira	Jd Vieira
24820	SP	9659	Jardim Viena	Jd Viena
24821	SP	9659	Jardim Vitória Régia	Jd V Régia
24822	SP	9659	Jardim Vivendas	Jd Vivendas
24823	SP	9659	Jardim Walkíria	Jd Walkíria
24824	SP	9659	Jardim Yolanda	Jd Yolanda
24825	SP	9659	Loteamento João G da Silva	Lot J G Silva
24826	SP	9659	Loteamento Porto Seguro	Lot Pto Seguro
24827	SP	9659	Loteamento Village Santa Helena	Lot V Sta Helena
24828	SP	9659	Nova Redentora	N Redentora
24829	SP	9659	Parque Celeste	Prq Celeste
24830	SP	9659	Parque das Aroeiras	Prq Aroeiras
24831	SP	9659	Parque das Flores I	Prq Flores I
24832	SP	9659	Parque das Flores II	Prq Flores II
24833	SP	9659	Parque do Sol	Prq Sol
24834	SP	9659	Parque Estoril	Prq Estoril
24835	SP	9659	Parque Industrial	Prq Industrial
24836	SP	9659	Parque Industrial Campo Verde	Prq Ind Cpo Verde
24837	SP	9659	Parque Industrial Tancredo Neves	Prq Ind T Neves
24888	SP	9659	Vila Esplanada	Vl Esplanada
24889	SP	9659	Vila Falavina	Vl Falavina
24890	SP	9659	Vila Fioresi	Vl Fioresi
24891	SP	9659	Vila Gasbarro	Vl Gasbarro
24892	SP	9659	Vila Goyos	Vl Goyos
24893	SP	9659	Vila Hipódromo	Vl Hipódromo
24894	SP	9659	Vila Ideal	Vl Ideal
24895	SP	9659	Vila Imperial	Vl Imperial
24896	SP	9659	Vila Ipiranga	Vl Ipiranga
24897	SP	9659	Vila Itália	Vl Itália
24898	SP	9659	Vila Lisboa	Vl Lisboa
24899	SP	9659	Vila Maceno	Vl Maceno
24900	SP	9659	Vila Maria	Vl Maria
24901	SP	9659	Vila Mayor	Vl Mayor
24902	SP	9659	Vila Militar	Vl Militar
24903	SP	9659	Vila Moreira	Vl Moreira
24904	SP	9659	Vila Mossoró	Vl Mossoró
24905	SP	9659	Vila Nossa Senhora Aparecida	Vl N Sra Aparecida
24907	SP	9659	Vila Nossa Senhora da Paz	Vl N Sra Paz
24908	SP	9659	Vila Nossa Senhora da Penha	Vl N Sra Penha
24909	SP	9659	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
24910	SP	9659	Vila Nossa Senhora do Bonfim	Vl N Sra Bonfim
24911	SP	9659	Vila Novaes	Vl Novaes
24913	SP	9659	Vila Redentora	Vl Redentora
24914	SP	9659	Vila Romana	Vl Romana
24915	SP	9659	Vila Santa Cândida	Vl Sta Cândida
24916	SP	9659	Vila Santa Cruz	Vl Sta Cruz
24917	SP	9659	Vila Santa Isabel	Vl Sta Isabel
24918	SP	9659	Vila Santa Tereza	Vl Sta Tereza
24919	SP	9659	Vila Santo Antônio	Vl Sto Antônio
24920	SP	9659	Vila São João	Vl S João
24921	SP	9659	Vila São Joaquim	Vl S Joaquim
24922	SP	9659	Vila São Jorge	Vl S Jorge
24923	SP	9659	Vila São José	Vl S José
24924	SP	9659	Vila São José Operário	Vl S J Operário
24925	SP	9659	Vila São Judas Tadeu	Vl S J Tadeu
24926	SP	9659	Vila São Manoel	Vl S Manoel
24927	SP	9659	Vila São Pedro	Vl S Pedro
24928	SP	9659	Vila Sinibaldi	Vl Sinibaldi
24929	SP	9659	Vila Tonello	Vl Tonello
24930	SP	9659	Vila Toninho	Vl Toninho
24931	SP	9659	Vila União	Vl União
24932	SP	9659	Vila Zilda	Vl Zilda
24933	SP	9659	Jardim Zé Menino	Jd Z Menino
24935	SP	9660	Alto da Ponte	At Ponte
24936	SP	9660	Altos do Esplanada	A Esplanada
24937	SP	9660	Bom Retiro	B Retiro
24939	SP	9660	Bosque dos Eucaliptos	Bsq Eucaliptos
24941	SP	9660	Buquirinha	\N
24944	SP	9660	Campo dos Alemães	Cpo Alemães
24945	SP	9660	Campos de São José	Campos S José
24947	SP	9660	Campus do CTA	C CTA
25101	SP	9660	Mirante do Buquirinha	M Buquirinha
25102	SP	9660	Monte Castelo	Mte Castelo
25103	SP	9660	Palmeiras de São José	P S José
25106	SP	9660	Parque Industrial	Prq Industrial
25107	SP	9660	Parque Interlagos	Prq Interlagos
25108	SP	9660	Parque Nova Esperança	Prq N Esperança
25109	SP	9660	Parque Novo Horizonte	Prq N Horizonte
25110	SP	9660	Parque Residencial Aquarius	Prq Res Aquarius
25116	SP	9660	Pernambuco	\N
25117	SP	9660	Putim	\N
25118	SP	9660	Quinta das Flores	Qta Flores
25121	SP	9660	Residencial Chácaras dos Eucaliptos	Res C Eucaliptos
25128	SP	9660	Residencial Sul	Res Sul
25129	SP	9660	Residencial União	Res União
25132	SP	9660	Santana	\N
25135	SP	9660	Urbanova	\N
25145	SP	9660	Vila Adyana	Vl Adyana
25149	SP	9660	Vila Betânia	Vl Betânia
25154	SP	9660	Vila Cristina	Vl Cristina
25156	SP	9660	Vila Dirce	Vl Dirce
25158	SP	9660	Vila Tesouro	Vl Tesouro
25159	SP	9660	Vila Ema	Vl Ema
25163	SP	9660	Vila Guarani	Vl Guarani
25167	SP	9660	Vila Industrial	Vl Industrial
25172	SP	9660	Vila Kennedy	Vl Kennedy
25179	SP	9660	Vila Maria	Vl Maria
25182	SP	9660	Vila Nair	Vl Nair
25186	SP	9660	Vila Nova Guarani	Vl N Guarani
25191	SP	9660	Vila Paiva	Vl Paiva
25195	SP	9660	Vila Rica	Vl Rica
25196	SP	9660	Vila Rossi	Vl Rossi
25202	SP	9660	Vila Santa Terezinha	Vl Sta Terezinha
25206	SP	9660	Vila São Bento	Vl S Bento
25218	SP	9668	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
25219	SP	9668	Água Branca	A Branca
25220	SP	9668	Água Fria	A Fria
25221	SP	9668	Água Funda	A Funda
25222	SP	9668	Água Rasa	A Rasa
25223	SP	9668	Alto da Lapa	At Lapa
25224	SP	9668	Alto da Mooca	At Mooca
25225	SP	9668	Alto da Riviera	At Riviera
25226	SP	9668	Alto de Pinheiros	At Pinheiros
25227	SP	9668	Alto do Pari	At Pari
25228	SP	9668	Altos de Vila Prudente	A Vl Prudente
25229	SP	9668	Americanópolis	\N
25230	SP	9668	Anhangüera	\N
25231	SP	9668	Aricanduva	\N
25232	SP	9668	Artur Alvim	A Alvim
25234	SP	9668	Balneário Dom Carlos	Bal D Carlos
25235	SP	9668	Balneário Mar Paulista	Bal M Paulista
25236	SP	9668	Balneário São Francisco	Bal S Francisco
25237	SP	9668	Balneário São José	Bal S José
25238	SP	9668	Baronesa	\N
25239	SP	9668	Barra Funda	B Funda
25240	SP	9668	Barragem	\N
25241	SP	9668	Barro Branco (Zona Norte)	B Branco (Z Norte)
25242	SP	9668	Bela Aliança	B Aliança
25243	SP	9668	Bela Vista	B Vista
25244	SP	9668	Belém	\N
25245	SP	9668	Belenzinho	\N
25246	SP	9668	Boaçava	\N
25247	SP	9668	Bom Retiro	B Retiro
25248	SP	9668	Bororé	\N
25249	SP	9668	Bortolândia	\N
25250	SP	9668	Bosque da Saúde	Bsq Saúde
25251	SP	9668	Brás	\N
25252	SP	9668	Brasilândia	\N
25253	SP	9668	Brooklin Novo	B Novo
25254	SP	9668	Brooklin Paulista	\N
25255	SP	9668	Burgo Paulista	B Paulista
25256	SP	9668	Butantã	\N
25257	SP	9668	Cachoeirinha	\N
25258	SP	9668	Cambuci	\N
25259	SP	9668	Campininha	\N
25260	SP	9668	Campo Belo	Cpo Belo
25261	SP	9668	Campo Grande	Cpo Grande
25262	SP	9668	Campo Limpo	Cpo Limpo
25263	SP	9668	Campos Elíseos	C Elíseos
25264	SP	9668	Cangaíba	\N
25265	SP	9668	Canindé	\N
25266	SP	9668	Cantareira	\N
25267	SP	9668	Capão do Embira	C Embira
25268	SP	9668	Capão Redondo	C Redondo
25269	SP	9668	Capela do Socorro	C Socorro
25270	SP	9668	Carandiru	\N
25271	SP	9668	Carrão	\N
25272	SP	9668	Casa Grande	C Grande
25273	SP	9668	Casa Verde	C Verde
25274	SP	9668	Casa Verde Alta	C V Alta
25275	SP	9668	Casa Verde Baixa	C V Baixa
25276	SP	9668	Casa Verde Média	C V Média
25277	SP	9668	Catumbi	\N
25278	SP	9668	Caxingui	\N
25279	SP	9668	Centro	\N
25280	SP	9668	Cerqueira César	C César
25281	SP	9668	Chácara Bandeirantes	Ch Bandeirantes
25282	SP	9668	Chácara Belenzinho	Ch Belenzinho
25283	SP	9668	Chácara Bosque do Sol	Ch Bsq Sol
25284	SP	9668	Chácara Califórnia	Ch Califórnia
25285	SP	9668	Chácara Cocaia	Ch Cocaia
25286	SP	9668	Chácara Cruzeiro do Sul	Ch C Sul
25287	SP	9668	Chácara da Enseada	Ch Enseada
25288	SP	9668	Chácara das Corujas	Ch Corujas
25290	SP	9668	Chácara das Palmeiras	Ch Palmeiras
25291	SP	9668	Chácara do Encosto	Ch Encosto
25292	SP	9668	Chácara Dona Olívia	Ch Da Olívia
25293	SP	9668	Chácara Figueira Grande	Ch F Grande
25294	SP	9668	Chácara Flora	Ch Flora
25295	SP	9668	Chácara Flórida	Ch Flórida
25296	SP	9668	Chácara Gaivotas	Ch Gaivotas
25297	SP	9668	Chácara Inglesa	Ch Inglesa
25298	SP	9668	Chácara Itaim	Ch Itaim
25299	SP	9668	Chácara Japonesa	Ch Japonesa
25300	SP	9668	Chácara Jaraguá	Ch Jaraguá
25301	SP	9668	Chácara Mafalda	Ch Mafalda
25302	SP	9668	Chácara Maria Trindade	Ch M Trindade
25351	SP	9668	Cidade Nitro Química	C N Química
25352	SP	9668	Cidade Nova Heliópolis	C N Heliópolis
25353	SP	9668	Cidade Nova São Miguel	C N S Miguel
25354	SP	9668	Cidade Patriarca	C Patriarca
25355	SP	9668	Cidade Popular	C Popular
25356	SP	9668	Cidade São Francisco	C S Francisco
25357	SP	9668	Cidade São Mateus	C S Mateus
25358	SP	9668	Cidade São Miguel	C S Miguel
25359	SP	9668	Cidade Satelite	C Satelite
25360	SP	9668	Cidade Satélite Santa Bárbara	C S Sta Bárbara
25361	SP	9668	Cidade Tiradentes	C Tiradentes
25362	SP	9668	Cidade Vargas	C Vargas
25363	SP	9668	Cipó do Meio	C Meio
25364	SP	9668	City América	C América
25365	SP	9668	Clube Campestre de São Paulo	C C S Paulo
25367	SP	9668	Clube dos Funcionários Públicos Colônia	C F P Colônia
25368	SP	9668	Colônia (Zona Sul)	Colônia (Z Sul)
25369	SP	9668	Conjunto dos Bancários	Cj Bancários
25370	SP	9668	Conjunto Habitacional A E Carvalho	Cj Hab A E Carvalho
25371	SP	9668	Conjunto Habitacional Águia de Haia	Cj Hab A Haia
25372	SP	9668	Conjunto Habitacional Barreira Grande	Cj Hab B Grande
25373	SP	9668	Conjunto Habitacional Barro Branco I	Cj Hab B Branco I
25374	SP	9668	Conjunto Habitacional Barro Branco II	Cj Hab B Branco II
25375	SP	9668	Conjunto Habitacional Brigadeiro Eduardo Gomes	Cj Hab Brg E Gomes
25376	SP	9668	Conjunto Habitacional Brigadeiro Faria Lima	Cj Hab Brg F Lima
25377	SP	9668	Conjunto Habitacional Castro Alves	Cj Hab C Alves
25378	SP	9668	Conjunto Habitacional Fazenda do Carmo	Cj Hab Faz Carmo
25379	SP	9668	Conjunto Habitacional Inácio Monteiro	Cj Hab I Monteiro
25380	SP	9668	Conjunto Habitacional Instituto Adventista	Cj Hab I Adventista
25382	SP	9668	Conjunto Habitacional Jardim São Bento	Cj Hab Jd S Bento
25383	SP	9668	Conjunto Habitacional Jardim São Francisco	Cj Hab Jd S Francisco
25384	SP	9668	Conjunto Habitacional Jova Rural	Cj Hab J Rural
25385	SP	9668	Conjunto Habitacional Juscelino Kubitschek	Cj Hab J Kubitschek
25386	SP	9668	Conjunto Habitacional Marechal Mascarenhas de Morais	Cj Hab Mal M Morais
25387	SP	9668	Conjunto Habitacional Padre José de Anchieta	Cj Hab Pe J Anchieta
24949	SP	9660	Centro	\N
24953	SP	9660	Chácaras Pousada do Vale	C P Vale
24954	SP	9660	Chácaras Reunidas	C Reunidas
24957	SP	9660	Cidade Morumbi	C Morumbi
24958	SP	9660	Cidade Vista Verde	C V Verde
24964	SP	9660	Conjunto Residencial Dom Pedro I	Cj Res D Pedro I
24965	SP	9660	Conjunto Residencial Elmano Veloso	Cj Res E Veloso
24966	SP	9660	Conjunto Residencial Esplanada do Sol	Cj Res Esp Sol
24969	SP	9660	Conjunto Residencial Galo Branco	Cj Res G Branco
24979	SP	9660	Conjunto Residencial Trinta e Um de Março	Cj Res T E U Março
24982	SP	9660	Freitas	\N
24984	SP	9660	Eugênio de Mello	E Mello
24989	SP	9660	Jardim Allah	Jd Allah
24990	SP	9660	Jardim Altos de Santana	Jd A Santana
24992	SP	9660	Jardim Alvorada	Jd Alvorada
24993	SP	9660	Jardim América	Jd América
24994	SP	9660	Jardim Americano	Jd Americano
24998	SP	9660	Jardim Apolo	Jd Apolo
25000	SP	9660	Jardim Aquárius	Jd Aquárius
25001	SP	9660	Jardim Augusta	Jd Augusta
25003	SP	9660	Jardim Bela Vista	Jd B Vista
25008	SP	9660	Jardim Colonial	Jd Colonial
25012	SP	9660	Jardim da Granja	Jd Granja
25014	SP	9660	Jardim das Cerejeiras	Jd Cerejeiras
25015	SP	9660	Jardim das Colinas	Jd Colinas
25016	SP	9660	Jardim das Flores	Jd Flores
25017	SP	9660	Jardim das Indústrias	Jd Indústrias
25024	SP	9660	Jardim Esplanada	Jd Esplanada
25025	SP	9660	Jardim Esplanada II	Jd Esplanada II
25032	SP	9660	Jardim Ismênia	Jd Ismênia
25037	SP	9660	Jardim Limoeiro	Jd Limoeiro
25046	SP	9660	Jardim Motorama	Jd Motorama
25049	SP	9660	Jardim Nova Detroit	Jd N Detroit
25056	SP	9660	Jardim Oriente	Jd Oriente
25059	SP	9660	Jardim Paraíso do Sol	Jd P Sol
25061	SP	9660	Jardim Pararangaba	Jd Pararangaba
25062	SP	9660	Jardim Paulista	Jd Paulista
25066	SP	9660	Jardim Portugal	Jd Portugal
25074	SP	9660	Jardim Santa Hermínia	Jd Sta Hermínia
25075	SP	9660	Jardim Santa Inês I	Jd Sta Inês I
25079	SP	9660	Jardim São Dimas	Jd S Dimas
25082	SP	9660	Jardim São Judas Tadeu	Jd S J Tadeu
25084	SP	9660	Jardim São Vicente	Jd S Vicente
25085	SP	9660	Jardim Satélite	Jd Satélite
25087	SP	9660	Jardim Telespark	Jd Telespark
25091	SP	9660	Jardim Uirá	Jd Uirá
25094	SP	9660	Jardim Vale do Sol	Jd Vle Sol
25099	SP	9660	Loteamento Gazzo	Lot Gazzo
25303	SP	9668	Chácara Meyer	Ch Meyer
25304	SP	9668	Chácara Monte Alegre	Ch Mte Alegre
25305	SP	9668	Chácara Monte Sol	Ch Mte Sol
25306	SP	9668	Chácara Morro Alto	Ch Mro Alto
25307	SP	9668	Chácara Nani	Ch Nani
25308	SP	9668	Chácara Nossa Senhora Aparecida	Ch N Sra Aparecida
25309	SP	9668	Chácara Nossa Senhora do Bom Conselho	Ch N Sra B Conselho
25310	SP	9668	Chácara Paiva	Ch Paiva
25311	SP	9668	Chácara Pirajussara	Ch Pirajussara
25312	SP	9668	Chácara Pouso Alegre	Ch P Alegre
25313	SP	9668	Chácara Santa Etelvina	Ch Sta Etelvina
25314	SP	9668	Chácara Santa Maria	Ch Sta Maria
25315	SP	9668	Chácara Santana	Ch Santana
25316	SP	9668	Chácara Santo Amaro	Ch Sto Amaro
25317	SP	9668	Chácara Santo Antônio (Zona Sul)	Ch Sto Antônio (Z Sul)
25318	SP	9668	Chácara Santo Hubertus	Ch Sto Hubertus
25319	SP	9668	Chácara São João	Ch S João
25320	SP	9668	Chácara São Luís	Ch S Luís
25321	SP	9668	Chácara São Silvestre	Ch S Silvestre
25322	SP	9668	Chácara Seis de Outubro	Ch S Outubro
25323	SP	9668	Chácara Sonho Azul	Ch S Azul
25324	SP	9668	Chácara Tatuapé	Ch Tatuapé
25325	SP	9668	Chácara Três Meninas	Ch T Meninas
25326	SP	9668	Chácara Vista Alegre	Ch V Alegre
25327	SP	9668	Chácara Vovo	Ch Vovo
25328	SP	9668	Chapada	\N
25329	SP	9668	Chora Menino	C Menino
25330	SP	9668	Cidade Ademar	C Ademar
25331	SP	9668	Cidade Antônio Estevão de Carvalho	C A E Carvalho
25332	SP	9668	Cidade Auxiliadora	C Auxiliadora
25333	SP	9668	Cidade Centenário	C Centenário
25334	SP	9668	Cidade Continental	C Continental
25335	SP	9668	Cidade D'Abril	C D'Abril
25336	SP	9668	Cidade Domitila	C Domitila
25337	SP	9668	Cidade dos Bandeirantes	C Bandeirantes
25338	SP	9668	Cidade Dutra	C Dutra
25339	SP	9668	Cidade Fim de Semana	C F Semana
25340	SP	9668	Cidade Ipava	C Ipava
25341	SP	9668	Cidade Jardim	C Jardim
25342	SP	9668	Cidade Júlia	C Júlia
25343	SP	9668	Cidade Kemel	C Kemel
25344	SP	9668	Cidade Leonor	C Leonor
25345	SP	9668	Cidade Líder	C Líder
25346	SP	9668	Cidade Mãe do Céu	C M Céu
25347	SP	9668	Cidade Monções	C Monções
25348	SP	9668	Cidade Munhoz Junior	C M Junior
25349	SP	9668	Cidade Nautica	C Nautica
25350	SP	9668	Cidade Nitro Operária	C N Operária
25388	SP	9668	Conjunto Habitacional Padre Manoel da Nóbrega	Cj Hab Pe M Nóbrega
25389	SP	9668	Conjunto Habitacional Padre Manoel de Paiva	Cj Hab Pe M Paiva
25390	SP	9668	Conjunto Habitacional Pirajussara	Cj Hab Pirajussara
25391	SP	9668	Conjunto Habitacional Recanto dos Humildes	Cj Hab Rec Humildes
25392	SP	9668	Conjunto Habitacional Santa Etelvina I	Cj Hab Sta Etelvina I
25393	SP	9668	Conjunto Habitacional Santa Etelvina II	Cj Hab Sta Etelvina II
25394	SP	9668	Conjunto Habitacional Santa Etelvina III	Cj Hab Sta Etelvina III
25395	SP	9668	Conjunto Habitacional Sitio Caraguata	Cj Hab S Caraguata
25396	SP	9668	Conjunto Habitacional Sitio Conceição	Cj Hab S Conceição
25397	SP	9668	Conjunto Habitacional Teotonio Vilela	Cj Hab T Vilela
25398	SP	9668	Conjunto Habitacional Vila Nova Cachoeirinha	Cj Hab Vl N Cachoeirinha
25399	SP	9668	Conjunto Promorar Estrada da Parada	Cj P Est Parada
25400	SP	9668	Conjunto Promorar Raposo Tavares	Cj P R Tavares
25401	SP	9668	Conjunto Promorar Rio Claro	Cj P R Claro
25402	SP	9668	Conjunto Promorar São Luis	Cj P S Luis
25403	SP	9668	Conjunto Promorar Sapopemba	Cj P Sapopemba
25404	SP	9668	Conjunto Promorar Vila Maria III	Cj P Vl Maria III
25405	SP	9668	Conjunto Residencial Alpes do Jaraguá	Cj Res A Jaraguá
25406	SP	9668	Conjunto Residencial Bandeirantes	Cj Res Bandeirantes
25407	SP	9668	Conjunto Residencial Butantã	Cj Res Butantã
25408	SP	9668	Conjunto Residencial Elisio Teixeira Leite	Cj Res E T Leite
25409	SP	9668	Conjunto Residencial Ingai	Cj Res Ingai
25410	SP	9668	Conjunto Residencial Jardim Canaã	Cj Res Jd Canaã
25411	SP	9668	Conjunto Residencial José Bonifácio	Cj Res J Bonifácio
25412	SP	9668	Conjunto Residencial Morumbi	Cj Res Morumbi
25413	SP	9668	Conjunto Residencial Novo Pacaembu	Cj Res N Pacaembu
25414	SP	9668	Conjunto Residencial Paraíso	Cj Res Paraíso
25415	SP	9668	Conjunto Residencial Pinheirinho	Cj Res Pinheirinho
25416	SP	9668	Conjunto Residencial Prestes Maia	Cj Res P Maia
25417	SP	9668	Conjunto Residencial Salvador Tolezani	Cj Res S Tolezani
25418	SP	9668	Conjunto Residencial Santa Maria	Cj Res Sta Maria
25483	SP	9668	Jardim Aladim	Jd Aladim
25485	SP	9668	Jardim Alfredo	Jd Alfredo
25486	SP	9668	Jardim Almanara	Jd Almanara
25487	SP	9668	Jardim Almeida Prado	Jd A Prado
25488	SP	9668	Jardim Alpino	Jd Alpino
25489	SP	9668	Jardim Alteza	Jd Alteza
25490	SP	9668	Jardim Alto Alegre (São Rafael)	Jd At Alegre (S Rafael)
25491	SP	9668	Jardim Alto do Rio Bonito	Jd At R Bonito
25492	SP	9668	Jardim Alto Pedroso	Jd At Pedroso
25493	SP	9668	Jardim Alva	Jd Alva
25494	SP	9668	Jardim Alvarenga	Jd Alvarenga
25495	SP	9668	Jardim Alvina	Jd Alvina
25496	SP	9668	Jardim Alviverde	Jd Alviverde
25497	SP	9668	Jardim Alvorada (Zona Sul)	Jd Alvorada (Z Sul)
25498	SP	9668	Jardim Alzira	Jd Alzira
25499	SP	9668	Jardim Amália	Jd Amália
25500	SP	9668	Jardim Amaralina	Jd Amaralina
25501	SP	9668	Jardim América	Jd América
25502	SP	9668	Jardim América da Penha	Jd A Penha
25503	SP	9668	Jardim Ampliação	Jd Ampliação
25504	SP	9668	Jardim Ana Lúcia	Jd A Lúcia
25505	SP	9668	Jardim Ana Maria	Jd A Maria
25506	SP	9668	Jardim Ana Rosa	Jd A Rosa
25507	SP	9668	Jardim Anália Franco	Jd A Franco
25508	SP	9668	Jardim Anchieta	Jd Anchieta
25509	SP	9668	Jardim Andaraí	Jd Andaraí
25510	SP	9668	Jardim Ângela (Zona Sul)	Jd Ângela (Z Sul)
25511	SP	9668	Jardim Ângela (Zona Leste)	Jd Ângela (Z Leste)
25512	SP	9668	Jardim Anhangüera	Jd Anhangüera
25513	SP	9668	Jardim Antártica	Jd Antártica
25514	SP	9668	Jardim Aparecida	Jd Aparecida
25515	SP	9668	Jardim Apurá	Jd Apurá
25516	SP	9668	Jardim Aracati	Jd Aracati
25517	SP	9668	Jardim Arco-Iris	Jd Arco-Iris
25518	SP	9668	Jardim Aricanduva	Jd Aricanduva
25519	SP	9668	Jardim Arize	Jd Arize
25520	SP	9668	Jardim Arizona	Jd Arizona
25521	SP	9668	Jardim Arpoador	Jd Arpoador
25522	SP	9668	Jardim Artur Alvim	Jd A Alvim
25523	SP	9668	Jardim Assunção	Jd Assunção
25524	SP	9668	Jardim Ataliba Leonel	Jd A Leonel
25525	SP	9668	Jardim Atibaia	Jd Atibaia
25526	SP	9668	Jardim Atlântico	Jd Atlântico
25527	SP	9668	Jardim Augusta	Jd Augusta
25528	SP	9668	Jardim Augusto	Jd Augusto
25529	SP	9668	Jardim Aurélia	Jd Aurélia
25530	SP	9668	Jardim Aurélio	Jd Aurélio
25531	SP	9668	Jardim Aurora (Zona Leste)	Jd Aurora (Z Leste)
25532	SP	9668	Jardim Avelino	Jd Avelino
25582	SP	9668	Jardim Carombé	Jd Carombé
25583	SP	9668	Jardim Casa Grande	Jd C Grande
25584	SP	9668	Jardim Casa Pintada	Jd C Pintada
25585	SP	9668	Jardim Casablanca	Jd Casablanca
25586	SP	9668	Jardim Castelo	Jd Castelo
25587	SP	9668	Jardim Catanduva	Jd Catanduva
25588	SP	9668	Jardim Catarina	Jd Catarina
25589	SP	9668	Jardim Cecy	Jd Cecy
25591	SP	9668	Jardim Cedro do Líbano	Jd C Líbano
25592	SP	9668	Jardim Celeste	Jd Celeste
25593	SP	9668	Jardim Célia	Jd Célia
25594	SP	9668	Jardim Centenário	Jd Centenário
25595	SP	9668	Jardim Central	Jd Central
25596	SP	9668	Jardim Cercado da Estrada	Jd C Estrada
25597	SP	9668	Jardim Chester	Jd Chester
25598	SP	9668	Jardim Cibele	Jd Cibele
25599	SP	9668	Jardim Cidade Pirituba	Jd C Pirituba
25601	SP	9668	Jardim Cimobil	Jd Cimobil
25602	SP	9668	Jardim Cinco de Julho	Jd C Julho
25603	SP	9668	Jardim Clara Regina	Jd C Regina
25604	SP	9668	Jardim Clarice	Jd Clarice
25605	SP	9668	Jardim Cláudia	Jd Cláudia
25606	SP	9668	Jardim Cleide	Jd Cleide
25607	SP	9668	Jardim Célia (Zona Sul)	Jd Célia (Z Sul)
25608	SP	9668	Jardim Clímax	Jd Clímax
25609	SP	9668	Jardim Cliper	Jd Cliper
25610	SP	9668	Jardim Coimbra	Jd Coimbra
25612	SP	9668	Jardim Colina	Jd Colina
25613	SP	9668	Jardim Colombo	Jd Colombo
25614	SP	9668	Jardim Colonial	Jd Colonial
25615	SP	9668	Jardim Colorado	Jd Colorado
25616	SP	9668	Jardim Comercial	Jd Comercial
25617	SP	9668	Jardim Concórdia	Jd Concórdia
25618	SP	9668	Jardim Consórcio	Jd Consórcio
25619	SP	9668	Jardim Consupler	Jd Consupler
25620	SP	9668	Jardim Copacabana	Jd Copacabana
25621	SP	9668	Jardim Cordeiro	Jd Cordeiro
25622	SP	9668	Jardim Cotching	Jd Cotching
25623	SP	9668	Jardim Cotiana	Jd Cotiana
25624	SP	9668	Jardim Cotinha	Jd Cotinha
25625	SP	9668	Jardim Cristal	Jd Cristal
25626	SP	9668	Jardim Cristália	Jd Cristália
25627	SP	9668	Jardim Cristina	Jd Cristina
25628	SP	9668	Jardim Cruzeiro	Jd Cruzeiro
25630	SP	9668	Jardim D'Abril	Jd D'Abril
25631	SP	9668	Jardim da Campina	Jd Campina
25632	SP	9668	Jardim da Conquista (Zona Oeste)	Jd Conquista (Z Oeste)
25633	SP	9668	Jardim da Glória	\N
25635	SP	9668	Jardim da Saúde	\N
25636	SP	9668	Jardim Dalmo	Jd Dalmo
25637	SP	9668	Jardim Damasceno	Jd Damasceno
25689	SP	9668	Jardim dos Prados	Jd Prados
25690	SP	9668	Jardim Dracena	Jd Dracena
25691	SP	9668	Jardim Drumond	Jd Drumond
25692	SP	9668	Jardim Duprat	Jd Duprat
25693	SP	9668	Jardim Edda	Jd Edda
25694	SP	9668	Jardim Edi	Jd Edi
25695	SP	9668	Jardim Edilene	Jd Edilene
25696	SP	9668	Jardim Edith	Jd Edith
25697	SP	9668	Jardim Edwiges	Jd Edwiges
25698	SP	9668	Jardim Egle	Jd Egle
25699	SP	9668	Jardim Elba	Jd Elba
25700	SP	9668	Jardim Eledy	Jd Eledy
25701	SP	9668	Jardim Eliana	Jd Eliana
25702	SP	9668	Jardim Eliane	Jd Eliane
25703	SP	9668	Jardim Elisa Maria	Jd E Maria
25704	SP	9668	Jardim Elisio	Jd Elisio
25705	SP	9668	Jardim Eliza	Jd Eliza
25706	SP	9668	Jardim Elizabeth	Jd Elizabeth
25707	SP	9668	Jardim Ellus	Jd Ellus
25708	SP	9668	Jardim Elza	Jd Elza
25709	SP	9668	Jardim Emilia	Jd Emilia
25710	SP	9668	Jardim Engenheiro Visconti	Jd Eng Visconti
25711	SP	9668	Jardim Ernestina	Jd Ernestina
25712	SP	9668	Jardim Esmeralda	Jd Esmeralda
25713	SP	9668	Jardim Esperança	Jd Esperança
25714	SP	9668	Jardim Ester	Jd Ester
25715	SP	9668	Jardim Ester Yolanda	Jd E Yolanda
25716	SP	9668	Jardim Estrela	Jd Estrela
25717	SP	9668	Jardim Etelvina	Jd Etelvina
25718	SP	9668	Jardim Europa	Jd Europa
25719	SP	9668	Jardim Eva	Jd Eva
25720	SP	9668	Jardim Everest	Jd Everest
25721	SP	9668	Jardim Faria Lima	Jd F Lima
25722	SP	9668	Jardim Felicidade (Zona Oeste)	Jd Felicidade (Z Oeste)
25723	SP	9668	Jardim Fernandes	Jd Fernandes
25724	SP	9668	Jardim Figueira Grande	Jd F Grande
25725	SP	9668	Jardim Fim de Semana	Jd F Semana
25726	SP	9668	Jardim Flamingo	Jd Flamingo
25727	SP	9668	Jardim Floresta	Jd Floresta
25728	SP	9668	Jardim Flórida Paulista	Jd F Paulista
25729	SP	9668	Jardim Fluminense	Jd Fluminense
25730	SP	9668	Jardim Fonte do Morumbi	Jd Fnt Morumbi
25731	SP	9668	Jardim Fonte São Miguel	Jd Fnt S Miguel
25732	SP	9668	Jardim Franca	Jd Franca
25733	SP	9668	Jardim Francisco Mentem	Jd F Mentem
25734	SP	9668	Jardim Franganielo	Jd Franganielo
25735	SP	9668	Jardim Fraternidade	Jd Fraternidade
25736	SP	9668	Jardim Fujihara	Jd Fujihara
25737	SP	9668	Jardim Galli	Jd Galli
25738	SP	9668	Jardim Germânia	Jd Germânia
25739	SP	9668	Jardim Gianetti	Jd Gianetti
25792	SP	9668	Jardim Internacional	Jd Internacional
25793	SP	9668	Jardim Ipanema (São Miguel)	Jd Ipanema (S Miguel)
25794	SP	9668	Jardim Ipê	Jd Ipê
25795	SP	9668	Jardim Iporã	Jd Iporã
25796	SP	9668	Jardim Iporanga	Jd Iporanga
25797	SP	9668	Jardim Iracema	Jd Iracema
25798	SP	9668	Jardim Irapiranga	Jd Irapiranga
25799	SP	9668	Jardim Irene	Jd Irene
25800	SP	9668	Jardim Íris	Jd Íris
25801	SP	9668	Jardim Itacolomi	Jd Itacolomi
25803	SP	9668	Jardim Itajai	Jd Itajai
25804	SP	9668	Jardim Itália	Jd Itália
25805	SP	9668	Jardim Itamaraty	Jd Itamaraty
25806	SP	9668	Jardim Itaoca	Jd Itaoca
25807	SP	9668	Jardim Itapemirim	Jd Itapemirim
25808	SP	9668	Jardim Itapeva	Jd Itapeva
25809	SP	9668	Jardim Itápolis	Jd Itápolis
25810	SP	9668	Jardim Itapura	Jd Itapura
25811	SP	9668	Jardim Itatiaia	Jd Itatiaia
25812	SP	9668	Jardim Itatinga	Jd Itatinga
25813	SP	9668	Jardim Iva	Jd Iva
25814	SP	9668	Jardim Ivana	Jd Ivana
25815	SP	9668	Jardim Ivete	Jd Ivete
25816	SP	9668	Jardim Ivone	Jd Ivone
25817	SP	9668	Jardim Jabaquara	Jd Jabaquara
25818	SP	9668	Jardim Jaçanã	Jd Jaçanã
25819	SP	9668	Jardim Jamaica	Jd Jamaica
25820	SP	9668	Jardim Japão	Jd Japão
25821	SP	9668	Jardim Jaqueline	Jd Jaqueline
25822	SP	9668	Jardim Jaraguá	Jd Jaraguá
25823	SP	9668	Jardim Jaú (Zona Leste)	Jd Jaú (Z Leste)
25824	SP	9668	Jardim Jeriva	Jd Jeriva
25825	SP	9668	Jardim Joamar	Jd Joamar
25826	SP	9668	Jardim Joana D'Arc	Jd J D'Arc
25827	SP	9668	Jardim João XXIII	Jd João XXIII
25829	SP	9668	Jardim Jordão	Jd Jordão
25830	SP	9668	Jardim Jua	Jd Jua
25831	SP	9668	Jardim Julieta	Jd Julieta
25832	SP	9668	Jardim Jurema	Jd Jurema
25833	SP	9668	Jardim Jussara	Jd Jussara
25834	SP	9668	Jardim Kagohara	Jd Kagohara
25835	SP	9668	Jardim Kaj	Jd Kaj
25836	SP	9668	Jardim Keralux	Jd Keralux
25837	SP	9668	Jardim Kika	Jd Kika
25838	SP	9668	Jardim Kioto	Jd Kioto
25839	SP	9668	Jardim Lajeado	Jd Lajeado
25840	SP	9668	Jardim Lallo	Jd Lallo
25841	SP	9668	Jardim Laone	Jd Laone
25842	SP	9668	Jardim Lapena	Jd Lapena
25843	SP	9668	Lar São Paulo	L S Paulo
25844	SP	9668	Jardim Laranjal	Jd Laranjal
25845	SP	9668	Jardim Laranjeiras	Jd Laranjeiras
25846	SP	9668	Jardim Laura	Jd Laura
25847	SP	9668	Jardim Leila	Jd Leila
25848	SP	9668	Jardim Leme	Jd Leme
25849	SP	9668	Jardim Leni	Jd Leni
25850	SP	9668	Jardim Leonardo	Jd Leonardo
25851	SP	9668	Jardim Leônidas Moreira	Jd L Moreira
25852	SP	9668	Jardim Leonor	Jd Leonor
25853	SP	9668	Jardim Leonor Mendes de Barros	Jd L M Barros
25854	SP	9668	Jardim Letícia	Jd Letícia
25855	SP	9668	Jardim Líbano	Jd Líbano
25856	SP	9668	Jardim Lice	Jd Lice
25857	SP	9668	Jardim Lider	Jd Lider
25858	SP	9668	Jardim Liderança	Jd Liderança
25859	SP	9668	Jardim Lídia	Jd Lídia
25860	SP	9668	Jardim Lilah	Jd Lilah
25861	SP	9668	Jardim Lisboa	Jd Lisboa
25862	SP	9668	Jardim Londrina	Jd Londrina
25863	SP	9668	Jardim Los Angeles	Jd L Angeles
25864	SP	9668	Jardim Lourdes	Jd Lourdes
25865	SP	9668	Jardim Luanda	Jd Luanda
25866	SP	9668	Jardim Lucélia	Jd Lucélia
25867	SP	9668	Jardim Lúcia	Jd Lúcia
25868	SP	9668	Jardim Luciana	Jd Luciana
25869	SP	9668	Jardim Lucinda	Jd Lucinda
25870	SP	9668	Jardim Lúcio de Castro	Jd L Castro
25871	SP	9668	Jardim Lugo	Jd Lugo
25872	SP	9668	Jardim Luísa	Jd Luísa
25873	SP	9668	Jardim Luso	Jd Luso
25874	SP	9668	Jardim Luzitânia	Jd Luzitânia
25875	SP	9668	Jardim Mabel	Jd Mabel
25876	SP	9668	Jardim Macedônia	Jd Macedônia
25877	SP	9668	Jardim Machado	Jd Machado
25878	SP	9668	Jardim Maggi	Jd Maggi
25879	SP	9668	Jardim Maia	Jd Maia
25880	SP	9668	Jardim Mália I	Jd Mália I
25881	SP	9668	Jardim Mália II	Jd Mália II
25882	SP	9668	Jardim Mangalot	Jd Mangalot
25883	SP	9668	Jardim Marabá	Jd Marabá
25884	SP	9668	Jardim Maracá	Jd Maracá
25885	SP	9668	Jardim Maracanã	Jd Maracanã
25886	SP	9668	Jardim Marajoara	Jd Marajoara
25887	SP	9668	Jardim Marcel	Jd Marcel
25888	SP	9668	Jardim Marcelo	Jd Marcelo
25889	SP	9668	Jardim Marciano	Jd Marciano
25890	SP	9668	Jardim Marco Paulo	Jd M Paulo
25891	SP	9668	Jardim Margarida	Jd Margarida
25892	SP	9668	Jardim Maria Amália	Jd M Amália
25893	SP	9668	Jardim Maria Duarte	Jd M Duarte
25894	SP	9668	Jardim Maria Emília	Jd M Emília
25895	SP	9668	Jardim Maria Estela	Jd M Estela
25896	SP	9668	Parque Maria Fernandes	Prq M Fernandes
25897	SP	9668	Jardim Maria Lúcia	Jd M Lúcia
25898	SP	9668	Jardim Maria Luiza	Jd M Luiza
25899	SP	9668	Jardim Maria Margarida	Jd M Margarida
25419	SP	9668	Conjunto Residencial Santa Terezinha	Cj Res Sta Terezinha
25420	SP	9668	Conjunto Residencial Sitio Oratório	Cj Res S Oratório
25421	SP	9668	Conjunto Residencial Vista Verde	Cj Res V Verde
25422	SP	9668	Consolação	\N
25423	SP	9668	Copacabana	\N
25425	SP	9668	Cursino	\N
25426	SP	9668	Educandário	\N
25427	SP	9668	Eldorado	\N
25428	SP	9668	Embu Mirim	E Mirim
25429	SP	9668	Embura	\N
25430	SP	9668	Engenheiro Goulart	Eng Goulart
25431	SP	9668	Engenheiro Marsilac	Eng Marsilac
25432	SP	9668	Engenheiro Trindade	Eng Trindade
25433	SP	9668	Ermelino Matarazzo	E Matarazzo
25434	SP	9668	Estância Jaraguá	Etn Jaraguá
25435	SP	9668	Estância Mirim	Etn Mirim
25436	SP	9668	Estância Tangara	Etn Tangara
25437	SP	9668	Vila Nova Jaguaré	Vl N Jaguaré
25438	SP	9668	Fazenda Aricanduva	Faz Aricanduva
25439	SP	9668	Fazenda Itaim	Faz Itaim
25440	SP	9668	Fazenda da Juta	Faz Juta
25441	SP	9668	Fazenda Morumbi	Faz Morumbi
25442	SP	9668	Ferreira	\N
25443	SP	9668	Freguesia do Ó	F do Ó
25444	SP	9668	Furnas	\N
25445	SP	9668	Gleba do Pêssego	G Pêssego
25446	SP	9668	Grajaú	\N
25447	SP	9668	Granja Julieta	Gja Julieta
25448	SP	9668	Granja Nossa Senhora Aparecida	Gja N Sra Aparecida
25449	SP	9668	Guacuri	\N
25450	SP	9668	Guaianazes	\N
25451	SP	9668	Guaiaúna	\N
25452	SP	9668	Guapira	\N
25453	SP	9668	Guarapiranga	\N
25454	SP	9668	Guavirutuba	\N
25455	SP	9668	Higienópolis	\N
25456	SP	9668	Horto	\N
25457	SP	9668	Horto Florestal	H Florestal
25458	SP	9668	Ibirapuera	\N
25459	SP	9668	Iguatemi	\N
25460	SP	9668	Imirim	\N
25461	SP	9668	Indianópolis	\N
25462	SP	9668	Instituto de Previdência	I Previdência
25463	SP	9668	Interlagos	\N
25464	SP	9668	Ipiranga	\N
25465	SP	9668	Itaberaba	\N
25466	SP	9668	Itaim	\N
25467	SP	9668	Itaim Bibi	I Bibi
25468	SP	9668	Itaim Paulista	I Paulista
25469	SP	9668	Itaquera	\N
25470	SP	9668	Itupu	\N
25471	SP	9668	Jabaquara	\N
25472	SP	9668	Jaçanã	\N
25473	SP	9668	Jaguaré	\N
25474	SP	9668	Jaraguá	\N
25475	SP	9668	Jardim Adelaide	Jd Adelaide
25476	SP	9668	Jardim Adelfiore	Jd Adelfiore
25477	SP	9668	Jardim Adélia	Jd Adélia
25478	SP	9668	Jardim Adhemar de Barros	Jd A Barros
25479	SP	9668	Jardim Adutora	Jd Adutora
25480	SP	9668	Jardim Aeroporto	Jd Aeroporto
25481	SP	9668	Jardim Aida	Jd Aida
25482	SP	9668	Jardim Aimoré	Jd Aimoré
25533	SP	9668	Jardim Avenida	Jd Avenida
25534	SP	9668	Jardim Bandeirante	Jd Bandeirante
25535	SP	9668	Jardim Bandeirantes	Jd Bandeirantes
25536	SP	9668	Jardim Barros	Jd Barros
25537	SP	9668	Jardim Bartira	Jd Bartira
25538	SP	9668	Jardim Batalha	Jd Batalha
25539	SP	9668	Jardim Beatriz	Jd Beatriz
25540	SP	9668	Jardim Bela Vista (Zona Norte)	Jd B Vista (Z Norte)
25541	SP	9668	Jardim Belaura	Jd Belaura
25542	SP	9668	Jardim Belcito	Jd Belcito
25543	SP	9668	Jardim Belém	Jd Belém
25544	SP	9668	Jardim Bélgica	Jd Bélgica
25545	SP	9668	Jardim Benfica	Jd Benfica
25546	SP	9668	Jardim Bibi	Jd Bibi
25547	SP	9668	Jardim Bichinhos	\N
25548	SP	9668	Jardim Boa Esperança	Jd B Esperança
25549	SP	9668	Jardim Boa Sorte	Jd B Sorte
25550	SP	9668	Jardim Boa Vista (Zona Oeste)	Jd B Vista (Z Oeste)
25551	SP	9668	Jardim Bom Clima	Jd B Clima
25552	SP	9668	Jardim Bom Pastor	Jd B Pastor
25553	SP	9668	Jardim Bom Refúgio	Jd B Refúgio
25554	SP	9668	Jardim Bonfiglioli	Jd Bonfiglioli
25555	SP	9668	Jardim Bonito	Jd Bonito
25556	SP	9668	Jardim Borba Gato	Jd B Gato
25557	SP	9668	Jardim Bosque do Sol	Jd Bsq Sol
25558	SP	9668	Jardim Botucatu	Jd Botucatu
25559	SP	9668	Jardim Brasil (Zona Norte)	Jd Brasil (Z Norte)
25560	SP	9668	Jardim Brasília (Zona Leste)	Jd Brasília (Z Leste)
25561	SP	9668	Jardim Britânia	Jd Britânia
25562	SP	9668	Jardim Bronzato	Jd Bronzato
25563	SP	9668	Jardim Buriti	Jd Buriti
25564	SP	9668	Jardim Caboré	Jd Caboré
25565	SP	9668	Jardim Cabuçu	Jd Cabuçu
25566	SP	9668	Jardim Cachoeira	\N
25567	SP	9668	Jardim Caguassu	Jd Caguassu
25568	SP	9668	Jardim Camara	Jd Camara
25569	SP	9668	Jardim Camargo Novo	Jd C Novo
25570	SP	9668	Jardim Cambara	Jd Cambara
25571	SP	9668	Jardim Campinas	Jd Campinas
25572	SP	9668	Jardim Campo dos Ferreiros	Jd Cpo Ferreiros
25573	SP	9668	Jardim Campo Grande	Jd Cpo Grande
25574	SP	9668	Jardim Campo Limpo	Jd Cpo Limpo
25575	SP	9668	Jardim Campos	Jd Campos
25576	SP	9668	Jardim Capão Redondo	Jd C Redondo
25577	SP	9668	Jardim Capela	Jd Capela
25578	SP	9668	Jardim Capelinha	Jd Capelinha
25579	SP	9668	Jardim Caravelas	Jd Caravelas
25580	SP	9668	Jardim Carlu	Jd Carlu
25581	SP	9668	Jardim Carolina	Jd Carolina
25638	SP	9668	Jardim Danfer	Jd Danfer
25639	SP	9668	Jardim das Acácias	Jd Acácias
25640	SP	9668	Jardim das Bandeiras	Jd Bandeiras
25641	SP	9668	Jardim das Camélias	Jd Camélias
25642	SP	9668	Jardim das Esmeraldas	Jd Esmeraldas
25643	SP	9668	Jardim das Flores	Jd Flores
25644	SP	9668	Jardim das Graças	Jd Graças
25645	SP	9668	Jardim das Imbuias	Jd Imbuias
25646	SP	9668	Jardim das Laranjeiras	\N
25647	SP	9668	Jardim das Oliveiras	Jd Oliveiras
25648	SP	9668	Jardim das Palmas	Jd Palmas
25649	SP	9668	Jardim das Palmeiras	Jd Palmeiras
25650	SP	9668	Jardim das Pedras	Jd Pedras
25651	SP	9668	Jardim das Praias	Jd Praias
25652	SP	9668	Jardim das Rosas (Zona Sul)	Jd Rosas (Z Sul)
25653	SP	9668	Jardim das Vertentes	Jd Vertentes
25654	SP	9668	Jardim Daysy	Jd Daysy
25655	SP	9668	Jardim de Lorenzo	Jd Lorenzo
25656	SP	9668	Jardim Denyse	Jd Denyse
25657	SP	9668	Jardim Deolinda	Jd Deolinda
25658	SP	9668	Jardim Dinorah	Jd Dinorah
25659	SP	9668	Jardim Diomar	Jd Diomar
25660	SP	9668	Jardim Dionisio	Jd Dionisio
25661	SP	9668	Jardim do Alto	Jd Alto
25662	SP	9668	Jardim do Campo	Jd Campo
25663	SP	9668	Jardim do Carmo	Jd Carmo
25664	SP	9668	Jardim do Centro	Jd Centro
25665	SP	9668	Jardim do Colégio	Jd Colégio
25666	SP	9668	Jardim do Divino	Jd Divino
25667	SP	9668	Jardim do Lago	Jd Lago
25668	SP	9668	Jardim do Russo	\N
25669	SP	9668	Jardim do Sol	Jd Sol
25670	SP	9668	Jardim do Tiro	Jd Tiro
25671	SP	9668	Jardim Dom Bosco	Jd D Bosco
25672	SP	9668	Jardim Dom Fernando	Jd D Fernando
25673	SP	9668	Jardim Dom José	Jd D José
25674	SP	9668	Jardim Domitila	Jd Domitila
25675	SP	9668	Jardim Dona Deolinda	Jd Da Deolinda
25676	SP	9668	Jardim Dona Sinhá	Jd Da Sinhá
25677	SP	9668	Jardim Donária	Jd Donária
25678	SP	9668	Jardim dos Álamos	Jd Álamos
25679	SP	9668	Jardim dos Bichinhos	Jd Bichinhos
25680	SP	9668	Jardim dos Cataldis	Jd Cataldis
25681	SP	9668	Jardim dos Estados	Jd Estados
25682	SP	9668	Jardim dos Eucaliptos	Jd Eucaliptos
25683	SP	9668	Jardim dos Francos	Jd Francos
25684	SP	9668	Jardim dos Ipês	Jd Ipês
25685	SP	9668	Jardim dos Jacarandás	Jd Jacarandás
25686	SP	9668	Jardim dos Lagos	Jd Lagos
25687	SP	9668	Jardim dos Manacás	Jd Manacás
25688	SP	9668	Jardim dos Pinheiros	\N
25740	SP	9668	Jardim Gilberto	Jd Gilberto
25741	SP	9668	Jardim Gilda Maria	Jd G Maria
25742	SP	9668	Jardim Glória	Jd Glória
25743	SP	9668	Jardim Gonzaga	Jd Gonzaga
25744	SP	9668	Jardim Grimaldi	Jd Grimaldi
25745	SP	9668	Jardim Guacuri	Jd Guacuri
25746	SP	9668	Jardim Guaianazes	Jd Guaianazes
25747	SP	9668	Jardim Guairaca	Jd Guairaca
25748	SP	9668	Jardim Guanabara	Jd Guanabara
25749	SP	9668	Jardim Guanca	Jd Guanca
25750	SP	9668	Jardim Guanhembu	Jd Guanhembu
25751	SP	9668	Jardim Guapira	Jd Guapira
25752	SP	9668	Jardim Guarani	Jd Guarani
25753	SP	9668	Jardim Guarapiranga	Jd Guarapiranga
25754	SP	9668	Jardim Guarau	Jd Guarau
25755	SP	9668	Jardim Guarujá	Jd Guarujá
25756	SP	9668	Jardim Guedala	Jd Guedala
25757	SP	9668	Jardim Guiomar	Jd Guiomar
25758	SP	9668	Jardim Gustavo	Jd Gustavo
25759	SP	9668	Jardim Hadad	Jd Hadad
25760	SP	9668	Jardim Haia do Carrão	Jd H Carrão
25761	SP	9668	Jardim Harmonia	Jd Harmonia
25762	SP	9668	Jardim Helena	Jd Helena
25763	SP	9668	Jardim Helga	Jd Helga
25765	SP	9668	Jardim Heliomar	Jd Heliomar
25766	SP	9668	Jardim Heloisa	Jd Heloisa
25767	SP	9668	Jardim Hercilia	Jd Hercilia
25768	SP	9668	Jardim Herculano	Jd Herculano
25769	SP	9668	Jardim Herplin	Jd Herplin
25770	SP	9668	Jardim Hípico	Jd Hípico
25771	SP	9668	Jardim Horizonte Azul	Jd H Azul
25772	SP	9668	Jardim Horto Florestal	Jd H Florestal
25773	SP	9668	Jardim Humaitá	Jd Humaitá
25774	SP	9668	Jardim Humberto Nastari	Jd H Nastari
25775	SP	9668	Jardim Iae	Jd Iae
25776	SP	9668	Jardim Iara	Jd Iara
25777	SP	9668	Jardim Ibirapuera	Jd Ibirapuera
25778	SP	9668	Jardim Ibiratiba	Jd Ibiratiba
25779	SP	9668	Jardim Ibitirama	Jd Ibitirama
25780	SP	9668	Jardim Icara	Jd Icara
25781	SP	9668	Jardim Icaraí	Jd Icaraí
25782	SP	9668	Jardim Ida Guedes	Jd I Guedes
25783	SP	9668	Jardim Ideal	Jd Ideal
25784	SP	9668	Jardim Iguatemi	Jd Iguatemi
25785	SP	9668	Jardim Imbé	Jd Imbé
25786	SP	9668	Jardim Imperador (Zona Leste)	Jd Imperador (Z Leste)
25787	SP	9668	Jardim Imperial	Jd Imperial
25788	SP	9668	Jardim Império	Jd Império
25789	SP	9668	Jardim Indaiá	Jd Indaiá
25790	SP	9668	Jardim Independência	Jd Independência
25791	SP	9668	Jardim Ingá	Jd Ingá
25900	SP	9668	Jardim Maria Nazaré	Jd M Nazaré
25901	SP	9668	Jardim Maria Rita	Jd M Rita
25902	SP	9668	Jardim Maria Sampaio	Jd M Sampaio
25903	SP	9668	Jardim Maria Virginia	Jd M Virginia
25904	SP	9668	Jardim Mariane	Jd Mariane
25905	SP	9668	Jardim Marilda	Jd Marilda
25906	SP	9668	Jardim Marília	Jd Marília
25907	SP	9668	Jardim Mariliza	Jd Mariliza
25908	SP	9668	Jardim Marilu	Jd Marilu
25909	SP	9668	Jardim Marina	Jd Marina
25910	SP	9668	Jardim Maringá	Jd Maringá
25911	SP	9668	Jardim Marisa	Jd Marisa
25912	SP	9668	Jardim Maristela	Jd Maristela
25913	SP	9668	Jardim Marpu	Jd Marpu
25914	SP	9668	Jardim Marquesa	Jd Marquesa
25915	SP	9668	Jardim Martha	Jd Martha
25916	SP	9668	Jardim Martini	Jd Martini
25917	SP	9668	Jardim Martinica	Jd Martinica
25918	SP	9668	Jardim Martins Silva	Jd M Silva
25919	SP	9668	Jardim Mascarenhas	Jd Mascarenhas
25920	SP	9668	Jardim Matarazzo	Jd Matarazzo
25921	SP	9668	Jardim Mazza	Jd Mazza
25922	SP	9668	Jardim Meliunas	Jd Meliunas
25923	SP	9668	Jardim Melo	Jd Melo
25924	SP	9668	Jardim Mikail	Jd Mikail
25925	SP	9668	Jardim Mimar	Jd Mimar
25926	SP	9668	Jardim Miragaia	Jd Miragaia
25927	SP	9668	Jardim Mirante	Jd Mirante
25928	SP	9668	Jardim Miriam	Jd Miriam
25929	SP	9668	Jardim Mitsutani	Jd Mitsutani
25930	SP	9668	Jardim Modelo	Jd Modelo
25931	SP	9668	Jardim Mônica	Jd Mônica
25932	SP	9668	Jardim Monjolo	Jd Monjolo
25933	SP	9668	Jardim Monte Alegre	Jd Mte Alegre
25934	SP	9668	Jardim Monte Azul	Jd Mte Azul
25935	SP	9668	Jardim Monte Belo	Jd Mte Belo
25936	SP	9668	Jardim Monte Kemel	Jd Mte Kemel
25937	SP	9668	Jardim Morais Prado	Jd M Prado
25938	SP	9668	Jardim Moreno	Jd Moreno
25939	SP	9668	Jardim Morganti	Jd Morganti
25940	SP	9668	Jardim Morro Verde	Jd Mro Verde
25941	SP	9668	Jardim Morumbi	Jd Morumbi
25942	SP	9668	Jardim Mutinga	Jd Mutinga
25943	SP	9668	Jardim Myrna	Jd Myrna
25944	SP	9668	Jardim Nadir	Jd Nadir
25945	SP	9668	Jardim Nagib Salem	Jd N Salem
25946	SP	9668	Jardim Nair	Jd Nair
25947	SP	9668	Jardim Nakamura	Jd Nakamura
25948	SP	9668	Jardim Namba	Jd Namba
25949	SP	9668	Jardim Nardini	Jd Nardini
25950	SP	9668	Jardim Nastari	Jd Nastari
25951	SP	9668	Jardim Natal	Jd Natal
25952	SP	9668	Jardim Naufal	Jd Naufal
26007	SP	9668	Jardim Paulo Afonso	Jd P Afonso
26008	SP	9668	Jardim Paulo Borba	Jd P Borba
26009	SP	9668	Jardim Paulo VI	Jd Paulo VI
26010	SP	9668	Jardim Pedra Branca	Jd P Branca
26011	SP	9668	Jardim da Pedreira	Jd Pedreira
26012	SP	9668	Jardim Pedro José Nunes	Jd P J Nunes
26013	SP	9668	Jardim Penha	Jd Penha
26014	SP	9668	Jardim Pereira Leite	Jd P Leite
26015	SP	9668	Jardim Peri	Jd Peri
26016	SP	9668	Jardim Peri Novo	Jd P Novo
26017	SP	9668	Jardim Peri Peri	Jd P Peri
26018	SP	9668	Jardim Perus	Jd Perus
26019	SP	9668	Jardim Petisco	Jd Petisco
26020	SP	9668	Jardim Petrópolis	Jd Petrópolis
26021	SP	9668	Jardim Picolo	Jd Picolo
26022	SP	9668	Jardim Pinheiros	Jd Pinheiros
26023	SP	9668	Jardim Piqueri	Jd Piqueri
26024	SP	9668	Jardim Piqueroby	Jd Piqueroby
26025	SP	9668	Jardim Piracema	Jd Piracema
26026	SP	9668	Jardim Piracuama	Jd Piracuama
26027	SP	9668	Jardim Pirajussara	Jd Pirajussara
26028	SP	9668	Jardim Piratininga	Jd Piratininga
26029	SP	9668	Jardim Pirituba	Jd Pirituba
26030	SP	9668	Jardim Planalto	Jd Planalto
26031	SP	9668	Jardim Pongilutti	Jd Pongilutti
26032	SP	9668	Jardim Ponte Rasa	Jd Pte Rasa
26033	SP	9668	Jardim Popular	Jd Popular
26034	SP	9668	Jardim Porteira Grande	Jd P Grande
26035	SP	9668	Jardim Pouso Alegre	Jd P Alegre
26037	SP	9668	Jardim Presidente	Jd Presidente
26038	SP	9668	Jardim Previdência	Jd Previdência
26039	SP	9668	Jardim Primavera (Zona Norte)	Jd Primavera (Z Norte)
26040	SP	9668	Jardim Princesa	Jd Princesa
26041	SP	9668	Jardim Progresso	Jd Progresso
26042	SP	9668	Jardim Promissão	Jd Promissão
26043	SP	9668	Jardim Prudência	Jd Prudência
26044	SP	9668	Jardim Quarto Centenário	Jd Q Centenário
26045	SP	9668	Jardim Quisisana (Vila Nova Curuçá)	Jd Quisisana (Vl N Curuçá)
26046	SP	9668	Jardim Ramala	Jd Ramala
26047	SP	9668	Jardim Raposo Tavares	Jd R Tavares
26048	SP	9668	Jardim Real	Jd Real
26049	SP	9668	Jardim Recanto do Sol	Jd Rec Sol
26050	SP	9668	Jardim Record	Jd Record
26051	SP	9668	Jardim Recreio	Jd Recreio
26052	SP	9668	Jardim Redenção	Jd Redenção
26053	SP	9668	Jardim Redil	Jd Redil
26054	SP	9668	Jardim Regina	Jd Regina
26056	SP	9668	Jardim Regis	Jd Regis
26057	SP	9668	Jardim Reimberg	Jd Reimberg
26108	SP	9668	Jardim Santa Lucrécia	Jd Sta Lucrécia
26109	SP	9668	Jardim Santa Luísa	Jd Sta Luísa
26110	SP	9668	Jardim Santa Marcelina	Jd Sta Marcelina
26111	SP	9668	Jardim Santa Margarida	Jd Sta Margarida
26112	SP	9668	Jardim Santa Maria	Jd Sta Maria
26113	SP	9668	Jardim Santa Mônica	Jd Sta Mônica
26114	SP	9668	Jardim Santa Rita	Jd Sta Rita
26115	SP	9668	Jardim Santa Terezinha (Zona Leste)	Jd Sta Terezinha (Z Leste)
26116	SP	9668	Jardim Santa Tereza	Jd Sta Tereza
26117	SP	9668	Jardim Santa Terezinha	Jd Sta Terezinha
26118	SP	9668	Jardim Santa Zélia	Jd Sta Zélia
26119	SP	9668	Jardim Santana	Jd Santana
26120	SP	9668	Jardim Santo Alberto	Jd Sto Alberto
26121	SP	9668	Jardim Santo Amaro	Jd Sto Amaro
26122	SP	9668	Jardim Santo André	Jd Sto André
26123	SP	9668	Jardim Santo Antoninho	Jd Sto Antoninho
26124	SP	9668	Jardim Santo Antônio	Jd Sto Antônio
26125	SP	9668	Jardim Santo Elias	Jd Sto Elias
26126	SP	9668	Jardim Santo Onofre	Jd Sto Onofre
26127	SP	9668	Jardim Santos Dumont	Jd Stos Dumont
26128	SP	9668	Jardim São Benedito	Jd S Benedito
26129	SP	9668	Jardim São Bento	Jd S Bento
26130	SP	9668	Jardim São Bento Novo	Jd S B Novo
26131	SP	9668	Jardim São Bernardo	Jd S Bernardo
26132	SP	9668	Jardim São Carlos (Zona Leste)	Jd S Carlos (Z Leste)
26133	SP	9668	Jardim São Cristóvão	Jd S Cristóvão
26134	SP	9668	Jardim São Domingos	Jd S Domingos
26135	SP	9668	Jardim São Francisco	Jd S Francisco
26136	SP	9668	Jardim São Francisco de Assis	Jd S F Assis
26137	SP	9668	Jardim São Gabriel	Jd S Gabriel
26138	SP	9668	Jardim São Gonçalo	Jd S Gonçalo
26139	SP	9668	Jardim São Januário	Jd S Januário
26140	SP	9668	Jardim São João (São Rafael)	Jd S João (S Rafael)
26141	SP	9668	Jardim São Joaquim	Jd S Joaquim
26142	SP	9668	Jardim São Jorge	Jd S Jorge
26143	SP	9668	Jardim São José (Zona Norte)	Jd S José (Z Norte)
26144	SP	9668	Jardim São Judas Tadeu	Jd S J Tadeu
26145	SP	9668	Jardim São Lourenço	Jd S Lourenço
26146	SP	9668	Jardim São Luís	Jd S Luís
26147	SP	9668	Jardim São Manoel	Jd S Manoel
26148	SP	9668	Jardim São Martinho	Jd S Martinho
26149	SP	9668	Jardim São Mateus	Jd S Mateus
26150	SP	9668	Jardim São Miguel	Jd S Miguel
26201	SP	9668	Jardim Textil	Jd Textil
26202	SP	9668	Jardim Thealia	Jd Thealia
26203	SP	9668	Jardim Thomaz	Jd Thomaz
26204	SP	9668	Jardim Tietê	Jd Tietê
26205	SP	9668	Jardim Tiro ao Pombo	Jd T Pombo
26206	SP	9668	Jardim Toca	Jd Toca
26207	SP	9668	Jardim Tremembé	Jd Tremembé
26208	SP	9668	Jardim Três Corações	Jd T Corações
26209	SP	9668	Jardim Três Marias	Jd T Marias
26210	SP	9668	Jardim Triana	Jd Triana
26211	SP	9668	Jardim Tricolor	Jd Tricolor
26212	SP	9668	Jardim Tropical	Jd Tropical
26213	SP	9668	Jardim Trussardi	Jd Trussardi
26214	SP	9668	Jardim Tuã	Jd Tuã
26215	SP	9668	Jardim Tupã	Jd Tupã
26216	SP	9668	Jardim Tupi	Jd Tupi
26217	SP	9668	Jardim Turquesa	Jd Turquesa
26218	SP	9668	Jardim Uberaba	Jd Uberaba
26219	SP	9668	Jardim Ubirajara (Zona Leste)	Jd Ubirajara (Z Leste)
26220	SP	9668	Jardim Uirapuru	Jd Uirapuru
26221	SP	9668	Jardim Umarizal	Jd Umarizal
26222	SP	9668	Jardim Umuarama	Jd Umuarama
26223	SP	9668	Jardim União	Jd União
26224	SP	9668	Jardim Universal	Jd Universal
26225	SP	9668	Jardim Universidade Pinheiros	Jd U Pinheiros
26226	SP	9668	Jardim Universitário	Jd Universitário
26227	SP	9668	Jardim Vale das Virtudes	Jd Vle Virtudes
26228	SP	9668	Jardim Vale do Ribeira	Jd Vle Ribeira
26229	SP	9668	Jardim Valquiria	Jd Valquiria
26230	SP	9668	Jardim Varginha	Jd Varginha
26231	SP	9668	Jardim Vaz de Lima	Jd V Lima
26232	SP	9668	Jardim Vazani	Jd Vazani
26233	SP	9668	Jardim Vera Cruz(Zona Sul)	Jd V Cruz (Z Sul)
26234	SP	9668	Jardim Vergueiro (Sacomã)	Jd Vergueiro (Sacomã)
26235	SP	9668	Jardim Verônia	Jd Verônia
26236	SP	9668	Jardim Viana	Jd Viana
26237	SP	9668	Jardim Vieira	Jd Vieira
26238	SP	9668	Jardim Vila Carrão	Jd Vl Carrão
26239	SP	9668	Jardim Vila Formosa	Jd Vl Formosa
26240	SP	9668	Jardim Vila Mariana	Jd Vl Mariana
26241	SP	9668	Jardim Vila Nova Progresso	Jd Vl N Progresso
26242	SP	9668	Jardim Vilas Boas	Jd V Boas
26243	SP	9668	Jardim Vilma	Jd Vilma
26244	SP	9668	Jardim Virginia	Jd Virginia
26245	SP	9668	Jardim Virginia Bianca	Jd V Bianca
26246	SP	9668	Jardim Vista Alegre	Jd V Alegre
26247	SP	9668	Jardim Vista Linda	Jd V Linda
26248	SP	9668	Jardim Vitória Régia	Jd V Régia
26249	SP	9668	Jardim Vivan	Jd Vivan
25953	SP	9668	Jardim Nazareth	Jd Nazareth
25954	SP	9668	Jardim Neide	Jd Neide
25955	SP	9668	Jardim Neila	Jd Neila
25956	SP	9668	Jardim Nélia	Jd Nélia
25960	SP	9668	Jardim Nelia IV	Jd Nelia IV
25962	SP	9668	Jardim Nelly	Jd Nelly
25963	SP	9668	Jardim Nice	Jd Nice
25964	SP	9668	Jardim Niteroi	Jd Niteroi
25965	SP	9668	Jardim Nizia	Jd Nizia
25966	SP	9668	Jardim Noemia	Jd Noemia
25967	SP	9668	Jardim Nordeste	Jd Nordeste
25968	SP	9668	Jardim Norma	Jd Norma
25969	SP	9668	Jardim Noronha	Jd Noronha
25970	SP	9668	Jardim Nossa Senhora do Carmo	Jd N Sra Carmo
25971	SP	9668	Jardim Nosso Lar	Jd N Lar
25972	SP	9668	Jardim Nova Brasília	Jd N Brasília
25973	SP	9668	Jardim Nova Colonia	Jd N Colonia
25974	SP	9668	Jardim Nova Germania	Jd N Germania
25975	SP	9668	Jardim Nova Guaianazes	Jd N Guaianazes
25976	SP	9668	Jardim Nova Tereza	Jd N Tereza
25977	SP	9668	Jardim Nove de Julho	Jd N Julho
25978	SP	9668	Jardim Novo Carrão	Jd N Carrão
25979	SP	9668	Jardim Novo Horizonte	Jd N Horizonte
25980	SP	9668	Jardim Novo Mundo	Jd N Mundo
25981	SP	9668	Jardim Novo Parelheiros	Jd N Parelheiros
25982	SP	9668	Jardim Novo Santo Amaro	Jd N Sto Amaro
25983	SP	9668	Jardim Novo Taboão	Jd N Taboão
25984	SP	9668	Jardim Odete	Jd Odete
25985	SP	9668	Jardim Olinda	Jd Olinda
25986	SP	9668	Jardim Olympia	Jd Olympia
25987	SP	9668	Jardim Ondina	Jd Ondina
25988	SP	9668	Jardim Orbam	Jd Orbam
25989	SP	9668	Jardim Oriental	Jd Oriental
25990	SP	9668	Jardim Orion	Jd Orion
25991	SP	9668	Jardim Orly	Jd Orly
25992	SP	9668	Jardim Ormendina	Jd Ormendina
25993	SP	9668	Jardim Outono	Jd Outono
25994	SP	9668	Jardim Palmares (Zona Sul)	Jd Palmares (Z Sul)
25995	SP	9668	Jardim Panorama	Jd Panorama
25996	SP	9668	Jardim Panorama D'Oeste	Jd P D'Oeste
25997	SP	9668	Jardim Paquetá (Zona Sul)	Jd Paquetá (Z Sul)
25998	SP	9668	Jardim Pará	Jd Pará
25999	SP	9668	Jardim Paraguaçu	Jd Paraguaçu
26000	SP	9668	Jardim Paris	Jd Paris
26001	SP	9668	Jardim Parque Morumbi	Jd Prq Morumbi
26002	SP	9668	Jardim Patente	Jd Patente
26003	SP	9668	Jardim Patente Novo	Jd Patente Novo
26004	SP	9668	Jardim Pauliceia	Jd Pauliceia
26005	SP	9668	Jardim Paulista	Jd Paulista
26006	SP	9668	Jardim Paulistano	Jd Paulistano
26058	SP	9668	Jardim Remo	Jd Remo
26059	SP	9668	Jardim Represa	Jd Represa
26060	SP	9668	Jardim República	Jd República
26061	SP	9668	Jardim Ricardo	Jd Ricardo
26062	SP	9668	Jardim Rincão	Jd Rincão
26063	SP	9668	Jardim Rio Bonito	Jd R Bonito
26064	SP	9668	Jardim Rio Douro	Jd R Douro
26065	SP	9668	Jardim Rio Pequeno	Jd R Pequeno
26066	SP	9668	Jardim Riviera	Jd Riviera
26067	SP	9668	Jardim Rizzo	Jd Rizzo
26068	SP	9668	Jardim Robru	Jd Robru
26069	SP	9668	Jardim Rodolfo Pirani	Jd R Pirani
26070	SP	9668	Jardim Romano	Jd Romano
26071	SP	9668	Jardim Roni	Jd Roni
26072	SP	9668	Jardim Rosa Maria	Jd R Maria
26073	SP	9668	Jardim Rosalina	Jd Rosalina
26074	SP	9668	Jardim Rosana	Jd Rosana
26075	SP	9668	Jardim Roseli	Jd Roseli
26076	SP	9668	Jardim Rosider	Jd Rosider
26077	SP	9668	Jardim Rosina	Jd Rosina
26078	SP	9668	Jardim Rossin	Jd Rossin
26079	SP	9668	Jardim Rubilene	Jd Rubilene
26080	SP	9668	Jardim Rubio	Jd Rubio
26081	SP	9668	Jardim Russo	Jd Russo
26082	SP	9668	Jardim Ruth	Jd Ruth
26083	SP	9668	Jardim S Kemel	Jd S Kemel
26084	SP	9668	Jardim Sabará	Jd Sabará
26085	SP	9668	Jardim Sabiá	Jd Sabiá
26086	SP	9668	Jardim Sagrado Coração	Jd S Coração
26087	SP	9668	Jardim Samambaia	Jd Samambaia
26088	SP	9668	Jardim Samara	Jd Samara
26089	SP	9668	Jardim Samas	Jd Samas
26090	SP	9668	Jardim Sandra	Jd Sandra
26092	SP	9668	Jardim Santa Adélia	Jd Sta Adélia
26093	SP	9668	Jardim Santa Bárbara	Jd Sta Bárbara
26094	SP	9668	Jardim Santa Branca	Jd Sta Branca
26095	SP	9668	Jardim Santa Cecília	Jd Sta Cecília
26096	SP	9668	Jardim Santa Cruz (Zona Norte)	Jd Sta Cruz (Z Norte)
26097	SP	9668	Jardim Santa Edwiges (Grajaú)	Jd Sta Edwiges (Grajaú)
26098	SP	9668	Jardim Santa Efigênia	Jd Sta Efigênia
26099	SP	9668	Jardim Santa Emília	Jd Sta Emília
26100	SP	9668	Jardim Santa Etelvina	Jd Sta Etelvina
26101	SP	9668	Jardim Santa Fé (Zona Sul)	Jd Sta Fé (Z Sul)
26102	SP	9668	Jardim Santa Filomena	Jd Sta Filomena
26103	SP	9668	Jardim Santa Francisca Cabrini	Jd Sta F Cabrini
26104	SP	9668	Jardim Santa Gertrudes	Jd Sta Gertrudes
26105	SP	9668	Jardim Santa Helena	Jd Sta Helena
26106	SP	9668	Jardim Santa Inês	Jd Sta Inês
26107	SP	9668	Jardim Santa Josefina	Jd Sta Josefina
26151	SP	9668	Jardim São Nicolau	Jd S Nicolau
26152	SP	9668	Jardim São Paulo(Zona Leste)	Jd S Paulo (Z Leste)
26153	SP	9668	Jardim São Pedro	Jd S Pedro
26154	SP	9668	Jardim São Rafael	Jd S Rafael
26155	SP	9668	Jardim São Remo	Jd S Remo
26156	SP	9668	Jardim São Ricardo	Jd S Ricardo
26157	SP	9668	Jardim São Roberto	Jd S Roberto
26158	SP	9668	Jardim São Roque	Jd S Roque
26159	SP	9668	Jardim São Savério	Jd S Savério
26160	SP	9668	Jardim São Sebastião	Jd S Sebastião
26161	SP	9668	Jardim São Silvestre	Jd S Silvestre
26162	SP	9668	Jardim São Vicente	Jd S Vicente
26163	SP	9668	Jardim São Vitor	Jd S Vitor
26164	SP	9668	Jardim Sapopemba	Jd Sapopemba
26165	SP	9668	Jardim Sarah	Jd Sarah
26166	SP	9668	Jardim Satélite	Jd Satélite
26167	SP	9668	Jardim Saúde	Jd Saúde
26168	SP	9668	Jardim Scaff	Jd Scaff
26169	SP	9668	Jardim Seckler	Jd Seckler
26170	SP	9668	Jardim Selma	Jd Selma
26171	SP	9668	Jardim Senice	Jd Senice
26172	SP	9668	Jardim Sertãozinho	Jd Sertãozinho
26173	SP	9668	Jardim Sete de Setembro	Jd S Setembro
26174	SP	9668	Jardim Shangrilá (Zona Norte)	Jd Shangrilá (Z Norte)
26175	SP	9668	Jardim Silva Teles	Jd S Teles
26176	SP	9668	Jardim Silveira	Jd Silveira
26177	SP	9668	Jardim Sílvia (Zona Leste)	Jd Sílvia (Z Leste)
26178	SP	9668	Jardim Soares	Jd Soares
26179	SP	9668	Jardim Solange	Jd Solange
26180	SP	9668	Jardim Somara	Jd Somara
26181	SP	9668	Jardim Sônia (Zona Sul)	Jd Sônia (Z Sul)
26182	SP	9668	Jardim Sônia Inga	Jd S Inga
26183	SP	9668	Jardim Sonia Marly	Jd S Marly
26184	SP	9668	Jardim Sônia Regina	Jd S Regina
26185	SP	9668	Jardim Soraia	Jd Soraia
26186	SP	9668	Jardim Souza	Jd Souza
26187	SP	9668	Jardim Sul São Paulo	Jd S S Paulo
26188	SP	9668	Jardim Suzana	Jd Suzana
26189	SP	9668	Jardim Sydney	Jd Sydney
26190	SP	9668	Jardim Taboão	Jd Taboão
26191	SP	9668	Jardim Taipas	Jd Taipas
26192	SP	9668	Jardim Tamoio	Jd Tamoio
26193	SP	9668	Jardim Tanay	Jd Tanay
26194	SP	9668	Jardim Tango	Jd Tango
26195	SP	9668	Jardim Tapera	Jd Tapera
26196	SP	9668	Jardim Taquaral	Jd Taquaral
26197	SP	9668	Jardim Teixeira	Jd Teixeira
26198	SP	9668	Jardim Tenani	Jd Tenani
26199	SP	9668	Jardim Teresa	Jd Teresa
26200	SP	9668	Jardim Teresa Cristina	Jd T Cristina
26250	SP	9668	Jardim Wanda	Jd Wanda
26251	SP	9668	Jardim Wilma Flor	Jd W Flor
26252	SP	9668	Jardim Yara	Jd Yara
26253	SP	9668	Jardim Ymay	Jd Ymay
26254	SP	9668	Jardim Zaira	Jd Zaira
26255	SP	9668	Jardim Zelia	Jd Zelia
26256	SP	9668	Jardim Zilda	Jd Zilda
26257	SP	9668	Jordanópolis	\N
26258	SP	9668	José Bonifacio	J Bonifacio
26259	SP	9668	Jurubatuba	\N
26260	SP	9668	Lajeado	\N
26261	SP	9668	Lapa	\N
26262	SP	9668	Lapa de Baixo	L Baixo
26263	SP	9668	Lauzane Paulista	L Paulista
26264	SP	9668	Liberdade	\N
26265	SP	9668	Limão	\N
26266	SP	9668	Limoeiro	\N
26267	SP	9668	Loteamento City Jaragua	Lot C Jaragua
26269	SP	9668	Luz	\N
26270	SP	9668	Mandaqui	\N
26271	SP	9668	Maranhão	\N
26272	SP	9668	Mata Fria	M Fria
26273	SP	9668	Miami Paulista	M Paulista
26274	SP	9668	Mirandópolis	\N
26275	SP	9668	Moinho Velho	M Velho
26276	SP	9668	Mooca	\N
26277	SP	9668	Conjunto Residencial Morada do Sol	Cj Res M Sol
26278	SP	9668	Morro do Índio	Mro Índio
26279	SP	9668	Morro dos Ingleses	Mro Ingleses
26280	SP	9668	Morro Grande	Mro Grande
26281	SP	9668	Morumbi	\N
26282	SP	9668	Nossa Senhora do Ó	N Sra do Ó
26283	SP	9668	Nova Piraju	N Piraju
26284	SP	9668	Núcleo Carvalho de Araújo	Nuc C Araújo
26285	SP	9668	Núcleo Lageado	Nuc Lageado
26286	SP	9668	Pacaembu	\N
26287	SP	9668	Paineiras do Morumbi	\N
26288	SP	9668	Parada	\N
26289	SP	9668	Cidade Nova América	C N América
26290	SP	9668	Parada Inglesa	Pda Inglesa
26291	SP	9668	Parada XV de Novembro	Pda XV Novembro
26292	SP	9668	Paraíso	\N
26293	SP	9668	Paraíso do Morumbi	P Morumbi
26294	SP	9668	Paraisópolis	\N
26295	SP	9668	Parelheiros	\N
26296	SP	9668	Pari	\N
26297	SP	9668	Parque Alto do Rio Bonito	Prq At R Bonito
26298	SP	9668	Parque Alves de Lima	Prq A Lima
26299	SP	9668	Parque Amazonas	Prq Amazonas
26300	SP	9668	Parque Amélia	Prq Amélia
26301	SP	9668	Parque América	Prq América
26302	SP	9668	Parque Anhangüera	Prq Anhangüera
26303	SP	9668	Parque Anhembi	Prq Anhembi
26304	SP	9668	Parque Arariba	Prq Arariba
26305	SP	9668	Parque Artur Alvim	Prq A Alvim
26306	SP	9668	Parque Atlântico	Prq Atlântico
26307	SP	9668	Parque Bairro Morumbi	Prq B Morumbi
26308	SP	9668	Parque Belém	Prq Belém
26309	SP	9668	Parque Boa Esperança	Prq B Esperança
26310	SP	9668	Parque Bologne	Prq Bologne
26360	SP	9668	Parque Lagoa Rica	Prq Lga Rica
26361	SP	9668	Parque Lagoinha	Prq Lagoinha
26363	SP	9668	Parque Ligia	Prq Ligia
26364	SP	9668	Parque Luis Mucciolo	Prq L Mucciolo
26365	SP	9668	Parque Malagoli	Prq Malagoli
26366	SP	9668	Parque Mandaqui	Prq Mandaqui
26367	SP	9668	Parque Mandi	Prq Mandi
26368	SP	9668	Parque Maria Alice	Prq M Alice
26369	SP	9668	Parque Maria Domitila	Prq M Domitila
26370	SP	9668	Parque Maria Helena	Prq M Helena
26371	SP	9668	Parque Maria Luiza	Prq M Luiza
26372	SP	9668	Parque Monteiro Soares	Prq M Soares
26373	SP	9668	Parque Morro Doce	Prq Mro Doce
26374	SP	9668	Parque Muciolo	Prq Muciolo
26375	SP	9668	Parque Munhoz	Prq Munhoz
26376	SP	9668	Parque Nações Unidas	Prq N Unidas
26377	SP	9668	Parque Novo Grajaú	Prq N Grajaú
26378	SP	9668	Parque Novo Lar	Prq N Lar
26379	SP	9668	Parque Novo Mundo	Prq N Mundo
26380	SP	9668	Parque Novo Santo Amaro	Prq N Sto Amaro
26381	SP	9668	Parque Paineiras	Prq Paineiras
26382	SP	9668	Parque Paiolzinho	Prq Paiolzinho
26383	SP	9668	Parque Panamericano	Prq Panamericano
26384	SP	9668	Parque Paulistano	Prq Paulistano
26385	SP	9668	Parque Penha	Prq Penha
26386	SP	9668	Parque Pereira	Prq Pereira
26387	SP	9668	Parque Peruche	Prq Peruche
26388	SP	9668	Parque Petrópolis	Prq Petrópolis
26389	SP	9668	Parque Planalto	Prq Planalto
26390	SP	9668	Parque Primavera	Prq Primavera
26391	SP	9668	Parque Ramos Freitas	Prq R Freitas
26392	SP	9668	Parque Reboucas	Prq Reboucas
26393	SP	9668	Parque Recreio	Prq Recreio
26394	SP	9668	Parque Regina	Prq Regina
26395	SP	9668	Parque Residencial Cocaia	Prq Res Cocaia
26396	SP	9668	Parque Residencial D'Abril	Prq Res D'Abril
26397	SP	9668	Parque Residencial da Lapa	Prq Res Lapa
26398	SP	9668	Parque Residencial dos Lagos	Prq Res Lagos
26399	SP	9668	Parque Residencial Julia	Prq Res Julia
26400	SP	9668	Parque Residencial Oratorio	Prq Res Oratorio
26401	SP	9668	Parque Residencial Rio Bonito	Prq Res R Bonito
26402	SP	9668	Parque Rodrigues Alves	Prq R Alves
26403	SP	9668	Parque Sabara	Prq Sabara
26404	SP	9668	Parque Santa Amélia	Prq Sta Amélia
26405	SP	9668	Parque Santa Bárbara	Prq Sta Bárbara
26406	SP	9668	Parque Santa Cecília	Prq Sta Cecília
26463	SP	9668	Real Parque	R Parque
26464	SP	9668	Recanto Ana Maria	Rec A Maria
26465	SP	9668	Recanto Campo Belo	Rec Cpo Belo
26466	SP	9668	Recanto dos Sonhos	Rec Sonhos
26467	SP	9668	Recanto Marisa	Rec Marisa
26468	SP	9668	Recanto Monte Alegre	Rec Mte Alegre
26469	SP	9668	Recanto Paraíso	Rec Paraíso
26470	SP	9668	Recanto Santo Antônio	Rec Sto Antônio
26471	SP	9668	Recanto Verde do Sol	Rec V Sol
26472	SP	9668	República	\N
26474	SP	9668	Residencial Morumbi	Res Morumbi
26475	SP	9668	Residencial Sol Nascente	Res S Nascente
26476	SP	9668	Residencial Taipas	Res Taipas
26477	SP	9668	Retiro Morumbi	Rer Morumbi
26478	SP	9668	Rio Bonito	R Bonito
26479	SP	9668	Rio Pequeno	R Pequeno
26480	SP	9668	Riviera Paulista	R Paulista
26481	SP	9668	Rolinópolis	\N
26482	SP	9668	Sacomã	\N
26483	SP	9668	Santa Amélia	Sta Amélia
26484	SP	9668	Santa Cecília	Sta Cecília
26485	SP	9668	Santa Efigênia	Sta Efigênia
26486	SP	9668	Santa Etelvina	Sta Etelvina
26487	SP	9668	Santa Inês	Sta Inês
26488	SP	9668	Santa Maria	Sta Maria
26489	SP	9668	Santa Teresinha	Sta Teresinha
26490	SP	9668	Santana	\N
26491	SP	9668	Santo Amaro	Sto Amaro
26492	SP	9668	São Domingos	S Domingos
26493	SP	9668	São João Clímaco	S J Clímaco
26494	SP	9668	São Judas	S Judas
26495	SP	9668	São Lucas	S Lucas
26496	SP	9668	São Mateus	S Mateus
26497	SP	9668	São Miguel Paulista	S M Paulista
26498	SP	9668	São Salvador	S Salvador
26499	SP	9668	Sapopemba	\N
26500	SP	9668	Saúde	\N
26501	SP	9668	Sete Praias	S Praias
26502	SP	9668	Siciliano	\N
26503	SP	9668	Sítio Areião	Sit Areião
26504	SP	9668	Sítio Barrocada	Sit Barrocada
26505	SP	9668	Sitio Boa Vista	S B Vista
26506	SP	9668	Sítio Botuquara	Sit Botuquara
26507	SP	9668	Sítio Búfalo	Sit Búfalo
26508	SP	9668	Sítio Canela Branca	Sit C Branca
26509	SP	9668	Sítio Caraguata	Sit Caraguata
26510	SP	9668	Sítio Cocaia	Sit Cocaia
26511	SP	9668	Sítio da Figueira	Sit Figueira
26512	SP	9668	Sítio do Mandaqui	Sit Mandaqui
26513	SP	9668	Sítio do Morro	Sit Morro
26514	SP	9668	Sítio do Piqueri	Sit Piqueri
26515	SP	9668	Sítio Itaberaba I	Sit Itaberaba I
26516	SP	9668	Sítio Laredo	Sit Laredo
26517	SP	9668	Sítio Matsumura	Sit Matsumura
26518	SP	9668	Sítio Morro Grande	Sit Mro Grande
26580	SP	9668	Vila Aparecida	Vl Aparecida
26581	SP	9668	Vila Aparecida Ivone	Vl A Ivone
26582	SP	9668	Vila Apoena	Vl Apoena
26583	SP	9668	Vila Araguaia	Vl Araguaia
26584	SP	9668	Vila Arapuã	Vl Arapuã
26585	SP	9668	Vila Arcádia	Vl Arcádia
26586	SP	9668	Vila Aricanduva	Vl Aricanduva
26587	SP	9668	Vila Arriete	Vl Arriete
26588	SP	9668	Vila Arruda	Vl Arruda
26589	SP	9668	Vila Augusto	Vl Augusto
26590	SP	9668	Vila Aurea	Vl Aurea
26591	SP	9668	Vila Aurora (Zona Norte)	Vl Aurora (Z Norte)
26592	SP	9668	Vila Azevedo	Vl Azevedo
26593	SP	9668	Vila Babilônia	Vl Babilônia
26594	SP	9668	Vila Baby	Vl Baby
26595	SP	9668	Vila Bancária	Vl Bancária
26596	SP	9668	Vila Bancária Munhoz	Vl Banca Munhoz
26597	SP	9668	Vila Bandeirantes	Vl Bandeirantes
26599	SP	9668	Vila Barbosa	Vl Barbosa
26600	SP	9668	Vila Barreto	Vl Barreto
26601	SP	9668	Vila Baruel	Vl Baruel
26602	SP	9668	Vila Basileia	Vl Basileia
26603	SP	9668	Vila Bauab	Vl Bauab
26604	SP	9668	Vila Beatriz	Vl Beatriz
26605	SP	9668	Vila Bela	Vl Bela
26606	SP	9668	Vila Bela Aliança	Vl B Aliança
26607	SP	9668	Vila Bela do Sapopemba	Vl B Sapopemba
26608	SP	9668	Vila Bela Vista (Zona Norte)	Vl B Vista (Z Norte)
26609	SP	9668	Vila Belo Horizonte	Vl B Horizonte
26610	SP	9668	Vila Bertioga	Vl Bertioga
26611	SP	9668	Vila Bianca	Vl Bianca
26612	SP	9668	Vila Boaçava	Vl Boaçava
26613	SP	9668	Vila Bom Jardim	Vl B Jardim
26614	SP	9668	Vila Bonilha	Vl Bonilha
26615	SP	9668	Vila Bonilha Nova	Vl B Nova
26616	SP	9668	Vila Borges	Vl Borges
26617	SP	9668	Vila Botoni	Vl Botoni
26618	SP	9668	Vila Bozzini	Vl Bozzini
26619	SP	9668	Vila Brasil	Vl Brasil
26620	SP	9668	Vila Brasilândia	Vl Brasilândia
26621	SP	9668	Vila Brasília (Zona Sul)	Vl Brasília (Z Sul)
26622	SP	9668	Vila Brasilina	Vl Brasilina
26623	SP	9668	Vila Brasílio Machado	Vl B Machado
26624	SP	9668	Vila Buarque	Vl Buarque
26625	SP	9668	Vila Buenos Aires	Vl B Aires
26627	SP	9668	Vila Butantã	Vl Butantã
26628	SP	9668	Vila Cachoeira	Vl Cachoeira
26629	SP	9668	Vila Cachoeirinha	Vl Cachoeirinha
26630	SP	9668	Vila Caiçara	Vl Caiçara
26631	SP	9668	Vila Caiúba	Vl Caiúba
26632	SP	9668	Vila Caju	Vl Caju
26633	SP	9668	Vila Califórnia	Vl Califórnia
26634	SP	9668	Vila Calu	Vl Calu
26690	SP	9668	Vila Dalila	Vl Dalila
26691	SP	9668	Vila Dalva	Vl Dalva
26692	SP	9668	Vila Damaceno	Vl Damaceno
26693	SP	9668	Vila Danubio Azul	Vl D Azul
26694	SP	9668	Vila Darli	Vl Darli
26695	SP	9668	Vila das Belezas	Vl Belezas
26696	SP	9668	Vila das Mercês	Vl Mercês
26697	SP	9668	Vila Deodoro	Vl Deodoro
26698	SP	9668	Vila Dinorah	Vl Dinorah
26699	SP	9668	Vila Dionisia	Vl Dionisia
26700	SP	9668	Vila Diva (Zona Leste)	Vl Diva (Z Leste)
26701	SP	9668	Vila Divina Pastora	Vl D Pastora
26702	SP	9668	Vila do Bosque	Vl Bosque
26703	SP	9668	Vila do Castelo	Vl Castelo
26704	SP	9668	Vila do Encontro	Vl Encontro
26705	SP	9668	Vila Dom José	Vl D José
26706	SP	9668	Vila Dom Pedro I	Vl D Pedro I
26707	SP	9668	Vila Dom Pedro II	Vl D Pedro II
26708	SP	9668	Vila Domitila	Vl Domitila
26709	SP	9668	Vila Dona Augusta	Vl Da Augusta
26710	SP	9668	Vila Dona Meta	Vl Da Meta
26711	SP	9668	Vila Dona Sara	Vl Da Sara
26712	SP	9668	Vila Dorna	Vl Dorna
26713	SP	9668	Vila dos Andradas	Vl Andradas
26714	SP	9668	Vila dos Andrades	Vl Andrades
26715	SP	9668	Vila dos Minérios	Vl Minérios
26716	SP	9668	Vila dos Palmares	Vl Palmares
26717	SP	9668	Vila dos Remédios	Vl Remédios
26718	SP	9668	Vila Doutor Eiras	Vl Dr Eiras
26719	SP	9668	Vila Duarte	Vl Duarte
26720	SP	9668	Vila Ede	Vl Ede
26721	SP	9668	Vila Elba	Vl Elba
26722	SP	9668	Vila Eliana	Vl Eliana
26723	SP	9668	Vila Elias Nigri	Vl E Nigri
26724	SP	9668	Vila Elida	Vl Elida
26725	SP	9668	Vila Eliete	Vl Eliete
26726	SP	9668	Vila Elisio	Vl Elisio
26727	SP	9668	Vila Elvira	Vl Elvira
26728	SP	9668	Vila Elze	Vl Elze
26729	SP	9668	Vila Ema	Vl Ema
26730	SP	9668	Vila Emir	Vl Emir
26731	SP	9668	Vila Erna	Vl Erna
26732	SP	9668	Vila Ernesto	Vl Ernesto
26733	SP	9668	Vila Escolar	Vl Escolar
26734	SP	9668	Vila Esmeralda	Vl Esmeralda
26735	SP	9668	Vila Espanhola	Vl Espanhola
26736	SP	9668	Vila Esperança	Vl Esperança
26737	SP	9668	Vila Ester (Zona Norte)	Vl Ester (Z Norte)
26738	SP	9668	Vila Euthalia	Vl Euthalia
26739	SP	9668	Vila Fachini	Vl Fachini
26740	SP	9668	Vila Fanton	Vl Fanton
26741	SP	9668	Vila Fátima	Vl Fátima
26742	SP	9668	Vila Fazzeoni	Vl Fazzeoni
26743	SP	9668	Vila Feliz	Vl Feliz
26744	SP	9668	Vila Fernandes	Vl Fernandes
26311	SP	9668	Parque Boturussu	Prq Boturussu
26312	SP	9668	Parque Brasil	Prq Brasil
26313	SP	9668	Parque Bristol	Prq Bristol
26314	SP	9668	Parque Casa de Pedra	Prq C Pedra
26315	SP	9668	Parque Central	Prq Central
26316	SP	9668	Parque Císper	Prq Císper
26317	SP	9668	Parque Claudia	Prq Claudia
26318	SP	9668	Parque Cocaia	Prq Cocaia
26319	SP	9668	Parque Colonial	Prq Colonial
26320	SP	9668	Parque Continental	Prq Continental
26321	SP	9668	Parque Cristina	Prq Cristina
26322	SP	9668	Parque Cruzeiro do Sul	Prq C Sul
26323	SP	9668	Parque da Mooca	Prq Mooca
26324	SP	9668	Parque da Vila Prudente	\N
26325	SP	9668	Parque das Árvores	Prq Árvores
26326	SP	9668	Parque das Cerejeiras	Prq Cerejeiras
26327	SP	9668	Parque das Paineiras	\N
26328	SP	9668	Parque Deizy	Prq Deizy
26329	SP	9668	Parque do Carmo	Prq Carmo
26330	SP	9668	Parque do Castelo	Prq Castelo
26331	SP	9668	Parque do Engenho	Prq Engenho
26332	SP	9668	Parque do Estado	Prq Estado
26333	SP	9668	Parque do Lago	Prq Lago
26334	SP	9668	Parque do Morumbi	Prq Morumbi
26335	SP	9668	Parque do Otero	Prq Otero
26336	SP	9668	Parque do Terceiro Lago	Prq T Lago
26337	SP	9668	Parque Dom João Neri	Prq D J Neri
26338	SP	9668	Parque Doroteia	Prq Doroteia
26339	SP	9668	Parque dos Bancários	Prq Bancários
26340	SP	9668	Parque dos Príncipes	Prq Príncipes
26341	SP	9668	Parque Edu Chaves	Prq E Chaves
26342	SP	9668	Parque Esmeralda	Prq Esmeralda
26343	SP	9668	Parque Esperança	Prq Esperança
26344	SP	9668	Parque Fernanda	Prq Fernanda
26345	SP	9668	Parque Flamengo	Prq Flamengo
26346	SP	9668	Parque Florestal	Prq Florestal
26347	SP	9668	Parque Fongaro	Prq Fongaro
26348	SP	9668	Parque Grajaú	Prq Grajaú
26349	SP	9668	Parque Guaianazes	Prq Guaianazes
26350	SP	9668	Parque Guarani	Prq Guarani
26351	SP	9668	Parque Ibirapuera	Prq Ibirapuera
26352	SP	9668	Parque Imperial	Prq Imperial
26353	SP	9668	Parque Independência	Prq Independência
26354	SP	9668	Parque Industrial	Prq Industrial
26355	SP	9668	Parque Industrial Tomas Edson	Prq Ind T Edson
26356	SP	9668	Parque Ipê	Prq Ipê
26357	SP	9668	Parque Itaberaba	Prq Itaberaba
26358	SP	9668	Parque Jabaquara	Prq Jabaquara
26359	SP	9668	Parque Jardim Mirassol	Prq Jd Mirassol
26408	SP	9668	Parque Santa Madalena	Prq Sta Madalena
26409	SP	9668	Parque Santa Rita	Prq Sta Rita
26410	SP	9668	Parque Santana	Prq Santana
26411	SP	9668	Parque Santo Amaro	Prq Sto Amaro
26412	SP	9668	Parque Santo Antônio	Prq Sto Antônio
26413	SP	9668	Parque Santo Eduardo	Prq Sto Eduardo
26414	SP	9668	Parque São Domingos	Prq S Domingos
26415	SP	9668	Parque São Joaquim	Prq S Joaquim
26416	SP	9668	Parque São Jorge	Prq S Jorge
26417	SP	9668	Parque São José	Prq S José
26418	SP	9668	Parque São Lourenço	Prq S Lourenço
26419	SP	9668	Parque São Lucas	Prq S Lucas
26420	SP	9668	Parque São Luís	Prq S Luís
26421	SP	9668	Parque São Miguel	Prq S Miguel
26422	SP	9668	Parque São Paulo	Prq S Paulo
26423	SP	9668	Parque São Rafael	Prq S Rafael
26424	SP	9668	Parque Savoy City	Prq S City
26425	SP	9668	Parque Sevilha	Prq Sevilha
26426	SP	9668	Parque Sonia	Prq Sonia
26427	SP	9668	Parque Taipas	Prq Taipas
26428	SP	9668	Parque Tamari	Prq Tamari
26429	SP	9668	Parque Tietê	Prq Tietê
26430	SP	9668	Parque Tomas Saraiva	Prq T Saraiva
26431	SP	9668	Parque Universitário Espírita	Prq Univ Espírita
26432	SP	9668	Parque Veloso	Prq Veloso
26433	SP	9668	Parque Veredas	Prq Veredas
26434	SP	9668	Parque Vila Maria	Prq Vl Maria
26435	SP	9668	Parque Vila Prudente	Prq Vl Prudente
26436	SP	9668	Parque Vitória	Prq Vitória
26437	SP	9668	Pedreira	\N
26438	SP	9668	Penha de França	P França
26439	SP	9668	Perdizes	\N
26440	SP	9668	Jardim dos Pereiras	Jd Pereiras
26441	SP	9668	Perus	\N
26442	SP	9668	Pinheiros	\N
26443	SP	9668	Piqueri	\N
26444	SP	9668	Pirajussara	\N
26445	SP	9668	Piraporinha	\N
26446	SP	9668	Pirituba	\N
26447	SP	9668	Planalto Paulista	P Paulista
26448	SP	9668	Polvilho	\N
26449	SP	9668	Ponte Pequena	Pte Pequena
26450	SP	9668	Ponte Rasa	Pte Rasa
26451	SP	9668	Praia Azul	Pr Azul
26452	SP	9668	Praia da Lagoa	Pr Lagoa
26453	SP	9668	Praia do Leblon	Pr Leblon
26454	SP	9668	Praia Paulistinha	Pr Paulistinha
26455	SP	9668	Praias Paulistanas	P Paulistanas
26456	SP	9668	Promorar Vila Maria	P Vl Maria
26457	SP	9668	Protendit	\N
26458	SP	9668	Quarta Parada	Q Parada
26459	SP	9668	Quinta da Paineira	Qta Paineira
26461	SP	9668	Rancho Geraldo	R Geraldo
26462	SP	9668	Raposo Tavares	R Tavares
26519	SP	9668	Sítio Pinheirinho	Sit Pinheirinho
26520	SP	9668	Sitio Ponderosa	S Ponderosa
26521	SP	9668	Sítio Represa	Sit Represa
26522	SP	9668	Sitio Tapera	S Tapera
26523	SP	9668	Sítio Vale Verde	Sit Vle Verde
26524	SP	9668	Socorro	\N
26525	SP	9668	Sumaré	\N
26526	SP	9668	Sumarezinho	\N
26527	SP	9668	Super Quadra Morumbi	S Q Morumbi
26528	SP	9668	Taipas	\N
26530	SP	9668	Tatuapé	\N
26531	SP	9668	Terceira Divisão	T Divisão
26532	SP	9668	Terceira Divisão de Interlagos	T D Interlagos
26533	SP	9668	Tremembé	\N
26534	SP	9668	Três Cruzes	T Cruzes
26535	SP	9668	Tucuruvi	\N
26536	SP	9668	Tuparacoera	\N
26537	SP	9668	Umarizal	\N
26539	SP	9668	Usina Piratininga	U Piratininga
26540	SP	9668	Valo Velho	V Velho
26541	SP	9668	Várzea da Barra Funda	V B Funda
26542	SP	9668	Várzea de Baixo	V Baixo
26543	SP	9668	Veleiros	\N
26544	SP	9668	Vila ABC	Vl ABC
26545	SP	9668	Vila Acre	Vl Acre
26546	SP	9668	Vila Adalgisa	Vl Adalgisa
26547	SP	9668	Vila Ademar	Vl Ademar
26548	SP	9668	Vila Água Funda	Vl A Funda
26549	SP	9668	Vila Agueda	Vl Agueda
26550	SP	9668	Vila Aimoré	Vl Aimoré
26551	SP	9668	Vila Alabama	Vl Alabama
26552	SP	9668	Vila Alba	Vl Alba
26553	SP	9668	Vila Albano	Vl Albano
26554	SP	9668	Vila Albertina	Vl Albertina
26555	SP	9668	Vila Alexandria	Vl Alexandria
26556	SP	9668	Vila Almeida	Vl Almeida
26557	SP	9668	Vila Alpina	Vl Alpina
26558	SP	9668	Vila Alteza	Vl Alteza
26559	SP	9668	Vila Alzira	Vl Alzira
26560	SP	9668	Vila Amália (Zona Norte)	Vl Amália (Z Norte)
26561	SP	9668	Vila Amélia	Vl Amélia
26562	SP	9668	Vila América	Vl América
26563	SP	9668	Vila Americana	Vl Americana
26564	SP	9668	Vila Ana Cláudia	Vl A Cláudia
26565	SP	9668	Vila Ana Rosa	Vl A Rosa
26566	SP	9668	Vila Anadir	Vl Anadir
26567	SP	9668	Vila Analia	Vl Analia
26569	SP	9668	Vila Anastácio	Vl Anastácio
26570	SP	9668	Vila Andes	Vl Andes
26571	SP	9668	Vila Andrade	Vl Andrade
26572	SP	9668	Vila Angélica	Vl Angélica
26573	SP	9668	Vila Angelina	Vl Angelina
26574	SP	9668	Vila Anglo Brasileira	Vl A Brasileira
26575	SP	9668	Vila Anhangüera	Vl Anhangüera
26576	SP	9668	Vila Antonieta	Vl Antonieta
26577	SP	9668	Vila Antonina	Vl Antonina
26578	SP	9668	Vila Antônio	Vl Antônio
26579	SP	9668	Vila Antônio dos Santos	Vl A Santos
26635	SP	9668	Vila Campanela	Vl Campanela
26636	SP	9668	Vila Campestre	Vl Campestre
26637	SP	9668	Vila Campo Grande	Vl Cpo Grande
26638	SP	9668	Vila Canero	Vl Canero
26639	SP	9668	Vila Capela	Vl Capela
26640	SP	9668	Vila Caraguatá	Vl Caraguatá
26641	SP	9668	Vila Carbone	Vl Carbone
26642	SP	9668	Vila Cardoso	Vl Cardoso
26643	SP	9668	Vila Cardoso Franco	Vl C Franco
26644	SP	9668	Vila Carioca	Vl Carioca
26645	SP	9668	Vila Carlos de Campos	Vl C Campos
26646	SP	9668	Vila Carmem	Vl Carmem
26647	SP	9668	Vila Carmosina	Vl Carmosina
26648	SP	9668	Vila Carolina	Vl Carolina
26649	SP	9668	Vila Carrão	Vl Carrão
26650	SP	9668	Vila Castelo	\N
26651	SP	9668	Vila Castro	Vl Castro
26652	SP	9668	Vila Catupia	Vl Catupia
26653	SP	9668	Vila Cavaton	Vl Cavaton
26654	SP	9668	Vila Caxambu	Vl Caxambu
26655	SP	9668	Vila Celeste	Vl Celeste
26656	SP	9668	Vila Centenário	Vl Centenário
26657	SP	9668	Vila Central	Vl Central
26658	SP	9668	Vila Chabilândia	Vl Chabilândia
26659	SP	9668	Vila Chalot	Vl Chalot
26660	SP	9668	Vila Charlote	Vl Charlote
26661	SP	9668	Vila Chavantes	Vl Chavantes
26662	SP	9668	Vila Chica Luisa	Vl C Luisa
26663	SP	9668	Vila Chuca	Vl Chuca
26664	SP	9668	Vila Cisper	Vl Cisper
26665	SP	9668	Vila Clara	Vl Clara
26666	SP	9668	Vila Clarice	Vl Clarice
26667	SP	9668	Vila Cláudia	Vl Cláudia
26668	SP	9668	Vila Clélia	Vl Clélia
26669	SP	9668	Vila Clementino	Vl Clementino
26670	SP	9668	Vila Cleonice	Vl Cleonice
26671	SP	9668	Vila Comercial	Vl Comercial
26672	SP	9668	Vila Conceição	Vl Conceição
26673	SP	9668	Vila Conde do Pinhal	Vl Cd Pinhal
26674	SP	9668	Vila Congonhas	Vl Congonhas
26675	SP	9668	Vila Constança	Vl Constança
26676	SP	9668	Vila Continental	Vl Continental
26677	SP	9668	Vila Corberi	Vl Corberi
26678	SP	9668	Vila Cordeiro	Vl Cordeiro
26679	SP	9668	Vila Cosmopolita	Vl Cosmopolita
26680	SP	9668	Vila Costa Melo	Vl C Melo
26681	SP	9668	Vila Cristália	Vl Cristália
26682	SP	9668	Vila Cruz das Almas	Vl C Almas
26683	SP	9668	Vila Cruzeiro	Vl Cruzeiro
26684	SP	9668	Vila Cruzeiro Novo	Vl C Novo
26685	SP	9668	Vila Cunha Bueno	Vl C Bueno
26686	SP	9668	Vila Curuçá	Vl Curuçá
26688	SP	9668	Vila da Paz	Vl Paz
26689	SP	9668	Vila da Saúde	Vl Saúde
26745	SP	9668	Vila Fiat Lux	Vl F Lux
26746	SP	9668	Vila Fidalgo	Vl Fidalgo
26747	SP	9668	Vila Fidelis Ribeiro	Vl F Ribeiro
26748	SP	9668	Vila Firmiano Pinto	Vl F Pinto
26750	SP	9668	Vila Formosa	Vl Formosa
26751	SP	9668	Vila Franca	Vl Franca
26752	SP	9668	Vila Franci	Vl Franci
26753	SP	9668	Vila Francos	Vl Francos
26754	SP	9668	Vila Friburgo	Vl Friburgo
26755	SP	9668	Vila Frugoli	Vl Frugoli
26756	SP	9668	Vila Fukuya	Vl Fukuya
26757	SP	9668	Vila Gabriel	Vl Gabriel
26758	SP	9668	Vila Gea	Vl Gea
26759	SP	9668	Vila Germaine	Vl Germaine
26760	SP	9668	Vila Germinal	Vl Germinal
26761	SP	9668	Vila Gertrudes	Vl Gertrudes
26762	SP	9668	Vila Gil	Vl Gil
26763	SP	9668	Vila Gilda	Vl Gilda
26764	SP	9668	Vila Giordano	Vl Giordano
26765	SP	9668	Vila Gomes	Vl Gomes
26766	SP	9668	Vila Gomes Cardim	Vl G Cardim
26767	SP	9668	Vila Gouveia	Vl Gouveia
26768	SP	9668	Vila Graciosa	Vl Graciosa
26769	SP	9668	Vila Granada	Vl Granada
26770	SP	9668	Vila Graziela	Vl Graziela
26771	SP	9668	Vila Guaca	Vl Guaca
26772	SP	9668	Vila Guacuri	Vl Guacuri
26773	SP	9668	Vila Guaraciaba	Vl Guaraciaba
26774	SP	9668	Vila Guarani (Z Sul)	Vl Guarani (Z Sul)
26775	SP	9668	Vila Guedes	Vl Guedes
26776	SP	9668	Vila Guilherme	Vl Guilherme
26777	SP	9668	Vila Guilhermina	Vl Guilhermina
26778	SP	9668	Vila Gumercindo	Vl Gumercindo
26779	SP	9668	Vila Gustavo	Vl Gustavo
26780	SP	9668	Vila Hadad	Vl Hadad
26781	SP	9668	Vila Hamburguesa	Vl Hamburguesa
26782	SP	9668	Vila Hebe	Vl Hebe
26783	SP	9668	Vila Helena	Vl Helena
26784	SP	9668	Vila Heliópolis	Vl Heliópolis
26785	SP	9668	Vila Hermínia	Vl Hermínia
26786	SP	9668	Vila Homero	Vl Homero
26787	SP	9668	Vila Hungaresa	Vl Hungaresa
26788	SP	9668	Vila Icarai	Vl Icarai
26789	SP	9668	Vila Ida	Vl Ida
26790	SP	9668	Vila Iguaçu	Vl Iguaçu
26791	SP	9668	Vila Império	Vl Império
26792	SP	9668	Vila Inácio	Vl Inácio
26793	SP	9668	Vila Inah	Vl Inah
26794	SP	9668	Vila Independência	Vl Independência
26795	SP	9668	Vila Indiana	Vl Indiana
26796	SP	9668	Vila Industrial	Vl Industrial
26797	SP	9668	Vila Inglesa	Vl Inglesa
26798	SP	9668	Vila Invernada	Vl Invernada
26799	SP	9668	Vila Iório	Vl Iório
26800	SP	9668	Vila Ipojuca	Vl Ipojuca
26801	SP	9668	Vila Iracema	Vl Iracema
26860	SP	9668	Vila Marilena	Vl Marilena
26861	SP	9668	Vila Marina	Vl Marina
26862	SP	9668	Vila Maringá	Vl Maringá
26863	SP	9668	Vila Mariza Mazzei	Vl M Mazzei
26864	SP	9668	Vila Marte	Vl Marte
26865	SP	9668	Vila Mascote	Vl Mascote
26866	SP	9668	Vila Matias	Vl Matias
26867	SP	9668	Vila Matilde	Vl Matilde
26868	SP	9668	Vila Mazzei	Vl Mazzei
26869	SP	9668	Vila Medeiros	Vl Medeiros
26870	SP	9668	Vila Mendes	Vl Mendes
26871	SP	9668	Vila Mercedes	Vl Mercedes
26872	SP	9668	Vila Mesquita	Vl Mesquita
26873	SP	9668	Vila Miami	Vl Miami
26874	SP	9668	Vila Michelina	Vl Michelina
26875	SP	9668	Vila Minerva	Vl Minerva
26876	SP	9668	Vila Mira	Vl Mira
26877	SP	9668	Vila Mirante	Vl Mirante
26878	SP	9668	Vila Miriam	Vl Miriam
26879	SP	9668	Vila Mirim	Vl Mirim
26880	SP	9668	Vila Missionária	Vl Missionária
26881	SP	9668	Vila Moderna	Vl Moderna
26882	SP	9668	Vila Moinho Velho	Vl M Velho
26883	SP	9668	Vila Monte Alegre	Vl Mte Alegre
26884	SP	9668	Vila Monte Santo	Vl Mte Santo
26885	SP	9668	Vila Monumento	Vl Monumento
26886	SP	9668	Vila Moraes	Vl Moraes
26887	SP	9668	Vila Moreira	Vl Moreira
26888	SP	9668	Vila Morgadouro	Vl Morgadouro
26889	SP	9668	Vila Morro Grande	Vl Mro Grande
26890	SP	9668	Vila Morse	Vl Morse
26891	SP	9668	Vila Morumbi	Vl Morumbi
26892	SP	9668	Vila Nair	Vl Nair
26893	SP	9668	Vila Nancy	Vl Nancy
26894	SP	9668	Vila Nascente	Vl Nascente
26895	SP	9668	Vila Natal	Vl Natal
26896	SP	9668	Vila Natália	Vl Natália
26897	SP	9668	Vila Neila	Vl Neila
26898	SP	9668	Vila Nelson	Vl Nelson
26899	SP	9668	Vila Nhocune	Vl Nhocune
26900	SP	9668	Vila Nilo	Vl Nilo
26901	SP	9668	Vila Nilva	Vl Nilva
26902	SP	9668	Vila Nina	Vl Nina
26903	SP	9668	Vila Nitro Operária	Vl N Operária
26904	SP	9668	Vila Nitro Química	Vl N Química
26905	SP	9668	Vila Nivi	Vl Nivi
26906	SP	9668	Vila Noca	Vl Noca
26907	SP	9668	Vila Nogueira	Vl Nogueira
26908	SP	9668	Vila Norma	Vl Norma
26909	SP	9668	Vila Nossa Senhora Aparecida	Vl N Sra Aparecida
26910	SP	9668	Vila Nossa Senhora da Conceição	Vl N Sra Conceição
26912	SP	9668	Vila Nossa Senhora do Retiro	Vl N Sra Retiro
26913	SP	9668	Vila Nova	Vl Nova
26914	SP	9668	Vila Nova Alba	Vl N Alba
26915	SP	9668	Vila Nova Cachoeirinha	Vl N Cachoeirinha
26967	SP	9668	Vila Popular	Vl Popular
26968	SP	9668	Vila Portugal	Vl Portugal
26969	SP	9668	Vila Portuguesa	Vl Portuguesa
26970	SP	9668	Vila Prado	Vl Prado
26971	SP	9668	Vila Praia	Vl Praia
26972	SP	9668	Vila Prel	Vl Prel
26973	SP	9668	Vila Primavera	Vl Primavera
26974	SP	9668	Vila Primeiro de Outubro	Vl P Outubro
26975	SP	9668	Vila Princesa Isabel	Vl Prca Isabel
26976	SP	9668	Vila Progredior	Vl Progredior
26977	SP	9668	Vila Progresso (Zona Leste)	Vl Progresso (Z Leste)
26978	SP	9668	Vila Prudente	Vl Prudente
26979	SP	9668	Vila Quarto Centenário	Vl Q Centenário
26980	SP	9668	Vila Quintana	Vl Quintana
26981	SP	9668	Vila Ramos	Vl Ramos
26982	SP	9668	Vila Rancho Alegre	Vl R Alegre
26983	SP	9668	Vila Raquel	Vl Raquel
26984	SP	9668	Vila Ré	Vl Ré
26985	SP	9668	Vila Regente Feijó	Vl Reg Feijó
26986	SP	9668	Vila Regina ( Zona Leste)	Vl Regina (Z Leste)
26987	SP	9668	Vila Reis	Vl Reis
26988	SP	9668	Vila Remo	Vl Remo
26989	SP	9668	Vila Renato (Zona Norte)	Vl Renato (Z Norte)
26990	SP	9668	Vila Represa	Vl Represa
26991	SP	9668	Vila Ribeiro de Barros	Vl R Barros
26992	SP	9668	Vila Rica	Vl Rica
26993	SP	9668	Vila Rio Branco	Vl R Branco
26994	SP	9668	Vila Robertina	Vl Robertina
26995	SP	9668	Vila Rodrigues	Vl Rodrigues
26996	SP	9668	Vila Romana	Vl Romana
26997	SP	9668	Vila Romano	Vl Romano
26998	SP	9668	Vila Romero	Vl Romero
26999	SP	9668	Vila Roque	Vl Roque
27000	SP	9668	Vila Rosa Molla	Vl R Molla
27001	SP	9668	Vila Rosaria	Vl Rosaria
27002	SP	9668	Vila Roschel	Vl Roschel
27003	SP	9668	Vila Rosina	Vl Rosina
27004	SP	9668	Vila Rubi	Vl Rubi
27005	SP	9668	Vila Rui Barbosa	Vl R Barbosa
27006	SP	9668	Vila Sabrina	Vl Sabrina
27007	SP	9668	Vila Salete	Vl Salete
27008	SP	9668	Vila Sampaio	Vl Sampaio
27009	SP	9668	Vila Santa Catarina	Vl Sta Catarina
27010	SP	9668	Vila Santa Clara	Vl Sta Clara
27011	SP	9668	Vila Santa Cruz (Zona Leste)	Vl Sta Cruz (Z Leste)
27012	SP	9668	Vila Santa Delfina	Vl Sta Delfina
27013	SP	9668	Vila Santa Edwiges	Vl Sta Edwiges
27014	SP	9668	Vila Santa Eulalia	Vl Sta Eulalia
27015	SP	9668	Vila Santa Inês	Vl Sta Inês
27016	SP	9668	Vila Santa Isabel	Vl Sta Isabel
27017	SP	9668	Vila Santa Lúcia	Vl Sta Lúcia
27069	SP	9668	Vila Talarico	Vl Talarico
27070	SP	9668	Vila Taquari	Vl Taquari
27071	SP	9668	Vila Teresinha	Vl Teresinha
27072	SP	9668	Vila Tiradentes	Vl Tiradentes
27073	SP	9668	Vila Tolstoi	Vl Tolstoi
27074	SP	9668	Vila Tramontano	Vl Tramontano
27075	SP	9668	Vila Uberabinha	Vl Uberabinha
27076	SP	9668	Vila União (Zona Leste)	Vl União (Z Leste)
27077	SP	9668	Vila Universitária	Vl Universitária
27078	SP	9668	Vila Ursulina	Vl Ursulina
27079	SP	9668	Vila Valdemar	Vl Valdemar
27080	SP	9668	Vila Vasconcelos	Vl Vasconcelos
27081	SP	9668	Vila Vera	Vl Vera
27082	SP	9668	Vila Verde	Vl Verde
27083	SP	9668	Vila Vermelha	Vl Vermelha
27084	SP	9668	Vila Vessoni	Vl Vessoni
27085	SP	9668	Vila Virginia	Vl Virginia
27087	SP	9668	Vila Vitório Mazzei	Vl V Mazzei
27088	SP	9668	Vila Yara	Vl Yara
27089	SP	9668	Vila Iolanda(Lajeado)	Vl Iolanda (Lajeado)
27090	SP	9668	Vila Zat	Vl Zat
27091	SP	9668	Vila Zefira	Vl Zefira
27092	SP	9668	Vila Zelina	Vl Zelina
27093	SP	9668	Vila Zilda	Vl Zilda
27094	SP	9668	Vila Zulmira	Vl Zulmira
27095	SP	9668	Vista Alegre	V Alegre
27097	SP	9671	Centro	\N
27099	SP	9671	Esplanada Mendes Moraes	Esp M Moraes
27100	SP	9671	Estação	\N
27102	SP	9671	Jardim Bandeirantes	Jd Bandeirantes
27103	SP	9671	Jardim Bela Vista	Jd Bela Vista
27104	SP	9671	Jardim Boa Vista	Jd B Vista
27105	SP	9671	Jardim Brasil	Jd Brasil
27106	SP	9671	Jardim Brasília	Jd Brasília
27107	SP	9671	Jardim Carambeí	Jd Carambeí
27108	SP	9671	Jardim Conceição	Jd Conceição
27109	SP	9671	Jardim das Flores	Jd Flores
27110	SP	9671	Jardim Esther	Jd Esther
27111	SP	9671	Jardim Flórida	Jd Flórida
27113	SP	9671	Jardim Guaçu	Jd Guaçu
27115	SP	9671	Jardim Maria Trindade	Jd M Trindade
27116	SP	9671	Jardim Marieta	Jd Marieta
27117	SP	9671	Jardim Meny	Jd Meny
27118	SP	9671	Jardim Mosteiro	Jd Mosteiro
27120	SP	9671	Jardim Quinta dos Teixeiras	Jd Qta Teixeiras
27121	SP	9671	Jardim Rene	Jd Rene
27122	SP	9671	Jardim Santa Maria	Jd Sta Maria
27124	SP	9671	Jardim São José	Jd S José
27125	SP	9671	Jardim Suíça Paulista	Jd S Paulista
27126	SP	9671	Jardim Tanzi	Jd Tanzi
27127	SP	9671	Jardim Villaça	Jd Villaça
27128	SP	9671	Marmeleiro	\N
27129	SP	9671	Paisagem Colonial	P Colonial
26802	SP	9668	Vila Irene	Vl Irene
26803	SP	9668	Vila Irmãos Arnoni	Vl Imos Arnoni
26804	SP	9668	Vila Isa	Vl Isa
26805	SP	9668	Vila Isabel	Vl Isabel
26807	SP	9668	Vila Isolina Mazzei	Vl I Mazzei
26808	SP	9668	Vila Itaberaba	Vl Itaberaba
26809	SP	9668	Vila Itaim	Vl Itaim
26810	SP	9668	Vila Ivg	Vl Ivg
26811	SP	9668	Vila Ivone	Vl Ivone
26812	SP	9668	Vila Jacuí	Vl Jacuí
26813	SP	9668	Vila Jaguara	Vl Jaguara
26814	SP	9668	Vila Jaguari	Vl Jaguari
26815	SP	9668	Vila Jaraguá	Vl Jaraguá
26817	SP	9668	Vila Joaniza	Vl Joaniza
26818	SP	9668	Vila João Batista	Vl J Batista
26819	SP	9668	Vila Judith	Vl Judith
26820	SP	9668	Vila Julio	Vl Julio
26821	SP	9668	Vila Julio Cesar	Vl J Cesar
26822	SP	9668	Vila Jurema	Vl Jurema
26823	SP	9668	Vila Jussara	Vl Jussara
26824	SP	9668	Vila Klaunig	Vl Klaunig
26825	SP	9668	Vila Lageado	Vl Lageado
26826	SP	9668	Vila Laís	Vl Laís
26827	SP	9668	Vila Lar Nacional	Vl L Nacional
26828	SP	9668	Vila Leme	Vl Leme
26829	SP	9668	Vila Leonor	Vl Leonor
26830	SP	9668	Vila Leopoldina	Vl Leopoldina
26831	SP	9668	Vila Libanesa	Vl Libanesa
26832	SP	9668	Vila Lisboa	Vl Lisboa
26833	SP	9668	Vila Liviero	Vl Liviero
26834	SP	9668	Vila Londrina	Vl Londrina
26835	SP	9668	Vila Lourdes	Vl Lourdes
26836	SP	9668	Vila Lúcia	Vl Lúcia
26837	SP	9668	Vila Lúcia Elvira	Vl L Elvira
26838	SP	9668	Vila Macedópolis	Vl Macedópolis
26839	SP	9668	Vila Madalena	Vl Madalena
26840	SP	9668	Vila Mafra	Vl Mafra
26841	SP	9668	Vila Malvina	Vl Malvina
26842	SP	9668	Vila Mangalot	Vl Mangalot
26843	SP	9668	Vila Mara	Vl Mara
26844	SP	9668	Vila Maracanã	Vl Maracanã
26845	SP	9668	Vila Marari	Vl Marari
26846	SP	9668	Vila Marcelo	Vl Marcelo
26847	SP	9668	Vila Marconi	Vl Marconi
26848	SP	9668	Vila Margareth	Vl Margareth
26849	SP	9668	Vila Margarida	Vl Margarida
26850	SP	9668	Vila Maria	Vl Maria
26851	SP	9668	Vila Maria Alta	Vl M Alta
26852	SP	9668	Jardim Maria Augusta	Jd M Augusta
26853	SP	9668	Vila Maria Baixa	Vl M Baixa
26854	SP	9668	Vila Maria Eugenia	Vl M Eugenia
26855	SP	9668	Vila Maria Luisa	Vl M Luisa
26856	SP	9668	Vila Maria Trindade	Vl M Trindade
26857	SP	9668	Vila Maria Zélia	Vl M Zélia
26858	SP	9668	Vila Mariana	Vl Mariana
26859	SP	9668	Vila Marieta	Vl Marieta
26916	SP	9668	Vila Nova Caledônia	Vl N Caledônia
26917	SP	9668	Vila Nova Carolina	Vl N Carolina
26918	SP	9668	Vila Nova Conceição	Vl N Conceição
26919	SP	9668	Vila Nova Curuçá	Vl N Curuçá
26920	SP	9668	Vila Nova das Belezas	Vl N Belezas
26921	SP	9668	Vila Nova Galvão	Vl N Galvão
26922	SP	9668	Vila Nova Jaraguá	Vl N Jaraguá
26923	SP	9668	Vila Nova Manchester	Vl N Manchester
26924	SP	9668	Vila Nova Mazzei	Vl N Mazzei
26925	SP	9668	Vila Nova Pauliceia	Vl N Pauliceia
26926	SP	9668	Vila Nova Perus	Vl N Perus
26927	SP	9668	Vila Nova Pirajussara	Vl N Pirajussara
26928	SP	9668	Vila Nova São Miguel	Vl N S Miguel
26929	SP	9668	Vila Nova Savoia	Vl N Savoia
26930	SP	9668	Vila Nova Teresa	Vl N Teresa
26931	SP	9668	União de Vila Nova	\N
26932	SP	9668	Vila Nova Utinga	Vl N Utinga
26933	SP	9668	Vila Nova York	Vl N York
26934	SP	9668	Vila Odete	Vl Odete
26935	SP	9668	Vila Olga	Vl Olga
26936	SP	9668	Vila Olímpia	Vl Olímpia
26937	SP	9668	Vila Olinda	Vl Olinda
26938	SP	9668	Vila Oratório	Vl Oratório
26939	SP	9668	Vila Paiva	Vl Paiva
26940	SP	9668	Vila Palmeiras	Vl Palmeiras
26941	SP	9668	Vila Paranaguá	Vl Paranaguá
26942	SP	9668	Vila Parque Jabaquara	Vl Prq Jabaquara
26943	SP	9668	Vila Patrimonial	Vl Patrimonial
26944	SP	9668	Vila Paulicéia	Vl Paulicéia
26945	SP	9668	Vila Paulina	Vl Paulina
26946	SP	9668	Vila Paulista	Vl Paulista
26947	SP	9668	Vila Paulistana	Vl Paulistana
26948	SP	9668	Vila Paulistania	Vl Paulistania
26949	SP	9668	Vila Paulo Silas	Vl P Silas
26950	SP	9668	Vila Pedra Branca	Vl P Branca
26951	SP	9668	Vila Pedroso	Vl Pedroso
26952	SP	9668	Vila Penteado	Vl Penteado
26953	SP	9668	Vila Pereira Barreto	Vl P Barreto
26954	SP	9668	Vila Pereira Cerca	Vl P Cerca
26955	SP	9668	Vila Perus	Vl Perus
26956	SP	9668	Vila Piauí	Vl Piauí
26957	SP	9668	Vila Picinin	Vl Picinin
26958	SP	9668	Vila Pierina	Vl Pierina
26959	SP	9668	Vila Piracicaba	Vl Piracicaba
26960	SP	9668	Vila Pirajussara	Vl Pirajussara
26961	SP	9668	Vila Pirituba	Vl Pirituba
26962	SP	9668	Vila Pita	Vl Pita
26963	SP	9668	Vila Plana	Vl Plana
26964	SP	9668	Vila Polopoli	Vl Polopoli
26965	SP	9668	Vila Pompéia	Vl Pompéia
26966	SP	9668	Vila Ponte Rasa	Vl Pte Rasa
27018	SP	9668	Vila Santa Maria	Vl Sta Maria
27019	SP	9668	Vila Santa Teresa (Zona Leste)	Vl Sta Teresa (Z Leste)
27020	SP	9668	Vila Santa Teresinha	Vl Sta Teresinha
27021	SP	9668	Vila Santa Terezinha (Zona Norte)	Vl Sta Terezinha (Z Norte)
27022	SP	9668	Vila Santa Virginia	Vl Sta Virginia
27023	SP	9668	Vila Santana	Vl Santana
27024	SP	9668	Vila Santista	Vl Santista
27025	SP	9668	Vila Santo Antônio	Vl Sto Antônio
27026	SP	9668	Vila Santo Estéfano	Vl Sto Estéfano
27027	SP	9668	Vila Santo Estevam Reis	Vl Sto E Reis
27028	SP	9668	Vila Santo Estevão	Vl Sto Estevão
27029	SP	9668	Vila Santo Henrique	Vl Sto Henrique
27030	SP	9668	Vila Santos	Vl Santos
27031	SP	9668	Vila São Camilo	Vl S Camilo
27032	SP	9668	Vila São Domingos	Vl S Domingos
27033	SP	9668	Vila São Francisco	Vl S Francisco
27034	SP	9668	Vila São Geraldo	Vl S Geraldo
27035	SP	9668	Vila São José	Vl S José
27036	SP	9668	Vila São Judas	Vl S Judas
27037	SP	9668	Vila São Luís(Zona Oeste)	Vl S Luís (Z Oeste)
27038	SP	9668	Vila São Nicolau	Vl S Nicolau
27039	SP	9668	Vila São Paulo	Vl S Paulo
27040	SP	9668	Vila São Pedro	Vl S Pedro
27041	SP	9668	Vila São Sebastião	Vl S Sebastião
27042	SP	9668	Vila São Silvestre	Vl S Silvestre
27043	SP	9668	Vila São Vicente	Vl S Vicente
27044	SP	9668	Vila Sapopemba	Vl Sapopemba
27045	SP	9668	Vila Sara	Vl Sara
27046	SP	9668	Vila Savoy	Vl Savoy
27047	SP	9668	Vila Seabra	Vl Seabra
27048	SP	9668	Vila Sérgio	Vl Sérgio
27049	SP	9668	Vila Serralheiro	Vl Serralheiro
27050	SP	9668	Vila Silva Teles	Vl S Teles
27051	SP	9668	Vila Silveira	Vl Silveira
27052	SP	9668	Vila Sílvia	Vl Sílvia
27053	SP	9668	Vila Simone	Vl Simone
27054	SP	9668	Vila Sinhá	Vl Sinhá
27055	SP	9668	Vila Siqueira (Zona Norte)	Vl Siqueira (Z Norte)
27056	SP	9668	Vila Sirene	Vl Sirene
27057	SP	9668	Vila Siria	Vl Siria
27058	SP	9668	Vila Socorro	Vl Socorro
27059	SP	9668	Vila Sofia	Vl Sofia
27060	SP	9668	Vila Sol	Vl Sol
27061	SP	9668	Vila Solange	Vl Solange
27062	SP	9668	Vila Sônia	Vl Sônia
27063	SP	9668	Vila Souza	Vl Souza
27064	SP	9668	Vila Stela	Vl Stela
27065	SP	9668	Vila Suiça	Vl Suiça
27066	SP	9668	Vila Sulina	Vl Sulina
27067	SP	9668	Vila Suzana	Vl Suzana
27068	SP	9668	Vila Taiau	Vl Taiau
27130	SP	9671	Parque Aliança	Prq Aliança
27132	SP	9671	Parque IX de Julho	Prq IX Julho
27133	SP	9671	Parque Primavera	Prq Primavera
27134	SP	9671	Parque Varanguera	Prq Varanguera
27135	SP	9671	Vila Aguiar	Vl Aguiar
27136	SP	9671	Vila Amaral	Vl Amaral
27138	SP	9671	Vila Borghesi	Vl Borghesi
27144	SP	9671	Vila Irene	Vl Irene
27145	SP	9671	Vila Junqueira	Vl Junqueira
27146	SP	9671	Vila Marques	Vl Marques
27148	SP	9671	Vila Mike	Vl Mike
27150	SP	9671	Vila Nossa Senhora Aparecida	Vl N Sra Aparecida
27151	SP	9671	Vila Nova São Roque	Vl N S Roque
27152	SP	9671	Vila Santa Isabel	Vl Sta Isabel
27155	SP	9671	Vila Santa Rita	Vl Sta Rita
27156	SP	9671	Vila Santa Rosália	Vl Sta Rosália
27158	SP	9671	Vila Santo Antônio	Vl Sto Antônio
27159	SP	9671	Vila São Domingos	Vl S Domingos
27160	SP	9671	Vila São Rafael	Vl S Rafael
27161	SP	9671	Taboão	\N
27163	SP	9671	Vinhas João Paulo II	V J Paulo II
27164	SP	9678	Belvedere Mar Pequeno	Belv M Pequeno
27165	SP	9678	Catiapoa	\N
27166	SP	9678	Centro	\N
27167	SP	9678	Cidade Naútica	C Naútica
27168	SP	9678	Conjunto Residencial Humaitá	Cj Res Humaitá
27169	SP	9678	Conjunto Residencial Tancredo Neves	Cj Res T Neves
27170	SP	9678	Esplanada dos Barreiros	Esp Barreiros
27171	SP	9678	Ilha Porchat	Ia Porchat
27172	SP	9678	Itararé	\N
27173	SP	9678	Japuí	\N
27174	SP	9678	Jardim Bechara	Jd Bechara
27175	SP	9678	Jardim Guassu	Jd Guassu
27176	SP	9678	Jardim Independência	Jd Independência
27177	SP	9678	Jardim Nosso Lar	Jd N Lar
27178	SP	9678	Jardim Paraíso	Jd Paraíso
27179	SP	9678	Jardim Quarentenário	Jd Quarentenário
27180	SP	9678	Jardim Recanto São Vicente	Jd Rec S Vicente
27181	SP	9678	Jardim Rio Branco	Jd R Branco
27182	SP	9678	Jardim Rio Negro	Jd R Negro
27183	SP	9678	Jardim Sorocabanos	Jd Sorocabanos
27184	SP	9678	Morro dos Barbosas	Mro Barbosas
27185	SP	9678	Parque Bitaru	Prq Bitaru
27186	SP	9678	Parque Continental	Prq Continental
27187	SP	9678	Parque das Bandeiras	Prq Bandeiras
27188	SP	9678	Parque Prainha	Prq Prainha
27189	SP	9678	Parque São Vicente	Prq S Vicente
27190	SP	9678	Planalto Bela Vista	P B Vista
27191	SP	9678	Sá Catarina de Moraes	S C Moraes
27192	SP	9678	Samarita	\N
27193	SP	9678	Vila Cascatinha	Vl Cascatinha
27242	SP	9686	Jardim Liberdade	Jd Liberdade
27243	SP	9686	Jardim Lopes da Silva	Jd L Silva
27244	SP	9686	Jardim Nova Sertãozinho	Jd N Sertãozinho
27245	SP	9686	Jardim Paraíso	Jd Paraíso
27246	SP	9686	Jardim Primeiro de Maio	Jd P Maio
27247	SP	9686	Jardim Recreio	Jd Recreio
27248	SP	9686	Jardim Recreio dos Bandeirantes	Jd Rcr Bandeirantes
27249	SP	9686	Jardim Santa Paula	Jd Sta Paula
27250	SP	9686	Jardim São José	Jd S José
27251	SP	9686	Jardim São Sebastião	Jd S Sebastião
27252	SP	9686	Jardim Soljumar	Jd Soljumar
27253	SP	9686	Jardim Sumaré	Jd Sumaré
27256	SP	9686	Jardim 5 de Dezembro	Jd 5 Dezembro
27257	SP	9686	Parque Residencial dos Ipês	Prq Res Ipês
27258	SP	9686	Parque Residencial Francisco Paschoal	Prq Res F Paschoal
27259	SP	9686	São João	S João
27260	SP	9686	Shangri-Lá	\N
27261	SP	9686	Vila Industrial	Vl Industrial
27264	SP	9696	Além Linha	A Linha
27265	SP	9696	Além Ponte	A Ponte
27268	SP	9696	Aparecida	\N
27271	SP	9696	Boa Vista	B Vista
27273	SP	9696	Brigadeiro Tobias	Brg Tobias
27274	SP	9696	Caguassu	\N
27275	SP	9696	Cajuru do Sul	C Sul
27276	SP	9696	Caputera	\N
27278	SP	9696	Central Parque Sorocaba	C Prq Sorocaba
27279	SP	9696	Centro	\N
27286	SP	9696	Chácara Três Marias	Ch T Marias
27288	SP	9696	Chácaras Reunidas São Jorge	C R S Jorge
27289	SP	9696	Cidade Jardim	C Jardim
27290	SP	9696	Condomínio Residencial Village Vert	Cond Res V Vert
27291	SP	9696	Condomínio Residencial Village D'Avignon	Cond Res V D'Avignon
27292	SP	9696	Conjunto Habitacional Herbert de Souza	Cj Hab H Souza
27293	SP	9696	Conjunto Habitacional Júlio de Mesquita Filho	Cj Hab J M Filho
27294	SP	9696	Conjunto Habitacional Doutor Ulisses Guimarães	Cj Hab Dr U Guimarães
27297	SP	9696	Éden	\N
27299	SP	9696	Granja Olga I	Gja Olga I
27301	SP	9696	Granja Olga III	Gja Olga III
27304	SP	9696	Ipanema do Meio	I Meio
27305	SP	9696	Ipanema Ville	I Ville
27306	SP	9696	Ipiranga	\N
27307	SP	9696	Iporanga	\N
27311	SP	9696	Jardim Abaeté	Jd Abaeté
27312	SP	9696	Jardim Abatiá	Jd Abatiá
27313	SP	9696	Jardim das Acácias	Jd Acácias
27315	SP	9696	Jardim Aeroporto	Jd Aeroporto
27316	SP	9696	Jardim Alegria	Jd Alegria
27317	SP	9696	Jardim Altos do Itavuvu	Jd A Itavuvu
27396	SP	9696	Jardim Henrique	Jd Henrique
27397	SP	9696	Jardim Hungares	Jd Hungares
27398	SP	9696	Jardim Ibiti do Paço	Jd I Paço
27401	SP	9696	Jardim Imperial	Jd Imperial
27402	SP	9696	Jardim Ipanema	Jd Ipanema
27403	SP	9696	Ipatinga	\N
27404	SP	9696	Jardim Ipê	Jd Ipê
27407	SP	9696	Jardim Isaura	Jd Isaura
27408	SP	9696	Jardim Itanguá	Jd Itanguá
27410	SP	9696	Jardim Itapemirim	Jd Itapemirim
27411	SP	9696	Jardim Itapuã	Jd Itapuã
27412	SP	9696	Jardim Jatobá	Jd Jatobá
27414	SP	9696	Jardim Gutierres	Jd Gutierres
27415	SP	9696	Jardim Josane	Jd Josane
27416	SP	9696	Jardim Judith	Jd Judith
27417	SP	9696	Jardim Juliana	Jd Juliana
27418	SP	9696	Jardim Leandro Dromani	Jd L Dromani
27419	SP	9696	Jardim Leocádia	Jd Leocádia
27420	SP	9696	Jardim Liberdade	Jd Liberdade
27423	SP	9696	Jardim Los Angeles	Jd L Angeles
27425	SP	9696	Jardim Luciana Maria	Jd L Maria
27429	SP	9696	Jardim Marcelo Augusto	Jd M Augusto
27430	SP	9696	Jardim Marco Antônio	Jd M Antônio
27434	SP	9696	Jardim Maria Antônia Prado	Jd M A Prado
27435	SP	9696	Jardim Maria Cristina	Jd M Cristina
27436	SP	9696	Jardim Maria do Carmo	Jd M Carmo
27437	SP	9696	Jardim Maria Eugênia	Jd M Eugênia
27442	SP	9696	Jardim Marnilda	Jd Marnilda
27449	SP	9696	Jardim Monte Hey	Jd Mte Hey
27450	SP	9696	Jardim Monterrey	Jd Monterrey
27451	SP	9696	Jardim Montevidéo	Jd Montevidéo
27452	SP	9696	Jardim Montreal	Jd Montreal
27453	SP	9696	Jardim Morumbi	Jd Morumbi
27457	SP	9696	Jardim Nair	Jd Nair
27460	SP	9696	Jardim Nogueira	Jd Nogueira
27463	SP	9696	Jardim Nova Esperança	Jd N Esperança
27464	SP	9696	Jardim Nova Manchester	Jd N Manchester
27466	SP	9696	Jardim Novo Bandeirantes	Jd N Bandeirantes
27469	SP	9696	Jardim Novo Eldorado	Jd N Eldorado
27470	SP	9696	Jardim Novo Horizonte	Jd N Horizonte
27471	SP	9696	Jardim Nova Ipanema	Jd N Ipanema
27472	SP	9696	Jardim Novo Mundo	Jd N Mundo
27475	SP	9696	Jardim Pacaembu	Jd Pacaembu
27477	SP	9696	Jardim Pagliato	Jd Pagliato
27480	SP	9696	Jardim Paraíso	Jd Paraíso
27481	SP	9696	Jardim Paraná	Jd Paraná
27483	SP	9696	Jardim Paulistano	Jd Paulistano
27484	SP	9696	Jardim Pelegrino	Jd Pelegrino
27487	SP	9696	Jardim Piratininga	Jd Piratininga
27582	SP	9696	Parque Manchester	Prq Manchester
27583	SP	9696	Parque Santa Isabel	Prq Sta Isabel
27584	SP	9696	Parque São Bento	Prq S Bento
27585	SP	9696	Parque Três Meninos	Prq T Meninos
27586	SP	9696	Parque Reserva Fazenda Imperial	Prq R Faz Imperial
27587	SP	9696	Parque Vitória Régia	Prq V Régia
27589	SP	9696	Parque das Paineiras	Prq Paineiras
27598	SP	9696	Rancho Dirce	R Dirce
27599	SP	9696	Recanto do Jataí	Rec Jataí
27600	SP	9696	Recreio dos Sorocabanos	Rcr Sorocabanos
27601	SP	9696	Recreio Marajoara	Rcr Marajoara
27604	SP	9696	Retiro São João	Rer S João
27609	SP	9696	Jardim Santa Marina	Jd Sta Marina
27616	SP	9696	Vila Acácia Marina	Vl A Marina
27617	SP	9696	Vila Adélia	Vl Adélia
27619	SP	9696	Vila Aeroporto	Vl Aeroporto
27624	SP	9696	Vila Almeida	Vl Almeida
27626	SP	9696	Vila Ana Maria	Vl A Maria
27627	SP	9696	Vila Angélica	Vl Angélica
27628	SP	9696	Vila Antão	Vl Antão
27633	SP	9696	Vila Assis	Vl Assis
27635	SP	9696	Vila Augusta	Vl Augusta
27639	SP	9696	Vila Barão	Vl Barão
27640	SP	9696	Vila Barcelona	Vl Barcelona
27642	SP	9696	Vila Bom Jesus	Vl B Jesus
27652	SP	9696	Vila Carvalho	Vl Carvalho
27653	SP	9696	Vila Casanova	Vl Casanova
27654	SP	9696	Vila Cássia Maria	Vl C Maria
27661	SP	9696	Vila Colorau	Vl Colorau
27665	SP	9696	Vila da Fonte	Vl Fonte
27666	SP	9696	Vila Dálmatas	Vl Dálmatas
27671	SP	9696	Vila Elza	Vl Elza
27673	SP	9696	Vila Eros	Vl Eros
27674	SP	9696	Vila Esperança	Vl Esperança
27675	SP	9696	Vila Espírito Santo	Vl E Santo
27678	SP	9696	Vila Fiori	Vl Fiori
27679	SP	9696	Vila Fleury	Vl Fleury
27681	SP	9696	Vila Formosa	Vl Formosa
27683	SP	9696	Vila Gabriel	Vl Gabriel
27688	SP	9696	Vila Gomes	Vl Gomes
27690	SP	9696	Vila Guilherme	Vl Guilherme
27691	SP	9696	Vila Guimarães	Vl Guimarães
27692	SP	9696	Vila Hanickel	Vl Hanickel
27693	SP	9696	Vila Haro	Vl Haro
27694	SP	9696	Vila Helena	Vl Helena
27696	SP	9696	Vila Hortência	Vl Hortência
27697	SP	9696	Vila Independência	Vl Independência
27701	SP	9696	Vila Jardini	Vl Jardini
27704	SP	9696	Vila João Romão	Vl J Romão
27705	SP	9696	Vila Josefina	Vl Josefina
27708	SP	9696	Vila Leão	Vl Leão
27709	SP	9696	Vila Leopoldina	Vl Leopoldina
27710	SP	9696	Vila Louzada	Vl Louzada
27819	SP	9700	Jardim Alvorada	Jd Alvorada
27820	SP	9700	Jardim Amélia	Jd Amélia
27821	SP	9700	Jardim Barcelona (Nova Veneza)	Jd Barcelona (N Veneza)
27822	SP	9700	Jardim Basilicata	Jd Basilicata
27823	SP	9700	Jardim Bela Vista	Jd B Vista
27824	SP	9700	Jardim Bom Retiro (Nova Veneza)	Jd B Retiro (N Veneza)
27825	SP	9700	Jardim Calegari (Nova Veneza)	Jd Calegari (N Veneza)
27826	SP	9700	Jardim Campo Belo	Jd Cpo Belo
27828	SP	9700	Jardim Cidade Nova (Nova Veneza)	Jd C Nova (N Veneza)
27829	SP	9700	Jardim Conceição (Nova Veneza)	Jd Conceição (N Veneza)
27830	SP	9700	Jardim Consteca	Jd Consteca
27831	SP	9700	Jardim Dall'Orto	Jd Dall'Orto
27832	SP	9700	Jardim Danúbio Azul (Nova Veneza)	Jd D Azul (N Veneza)
27833	SP	9700	Jardim das Oliveiras (Nova Veneza)	Jd Oliveiras (N Veneza)
27834	SP	9700	Jardim das Palmeiras	Jd Palmeiras
27835	SP	9700	Jardim Denadai (Nova Veneza)	Jd Denadai (N Veneza)
27837	SP	9700	Jardim do Trevo (Nova Veneza)	Jd Trevo (N Veneza)
27838	SP	9700	Jardim Dulce (Nova Veneza)	Jd Dulce (N Veneza)
27839	SP	9700	Jardim Eldorado	Jd Eldorado
27840	SP	9700	Jardim Eunice (Nova Veneza)	Jd Eunice (N Veneza)
27842	SP	9700	Jardim Fantinatti (Nova Veneza)	Jd Fantinatti (N Veneza)
27843	SP	9700	Jardim Ipiranga (Nova Veneza)	Jd Ipiranga (N Veneza)
27844	SP	9700	Jardim João Paulo II	Jd J Paulo II
27845	SP	9700	Jardim Lucélia	Jd Lucélia
27846	SP	9700	Jardim Lúcia (Nova Veneza)	Jd Lúcia (N Veneza)
27847	SP	9700	Jardim Luiz Cia	Jd L Cia
27849	SP	9700	Jardim Macarenko	Jd Macarenko
27850	SP	9700	Jardim Manchester (Nova Veneza)	Jd Manchester (N Veneza)
27851	SP	9700	Jardim Maracanã (Nova Veneza)	Jd Maracanã (N Veneza)
27852	SP	9700	Jardim Maria Antonia (Nova Veneza)	Jd M Antonia (N Veneza)
27853	SP	9700	Jardim Marchissolo	Jd Marchissolo
27854	SP	9700	Jardim Martins (Nova Veneza)	Jd Martins (N Veneza)
27855	SP	9700	Jardim Mineápolis (Nova Veneza)	Jd Mineápolis (N Veneza)
27856	SP	9700	Jardim Minezotta (Nova Veneza)	Jd Minezotta (N Veneza)
27858	SP	9700	Jardim Monte Santo	Jd Mte Santo
27859	SP	9700	Jardim Morumbi (Nova Veneza)	Jd Morumbi (N Veneza)
27194	SP	9678	Vila Ema	Vl Ema
27195	SP	9678	Vila Iolanda	Vl Iolanda
27196	SP	9678	Vila Jockei Clube	Vl J Clube
27197	SP	9678	Vila Margarida	Vl Margarida
27198	SP	9678	Vila Mateo Bei	Vl M Bei
27199	SP	9678	Vila Matias	Vl Matias
27200	SP	9678	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
27201	SP	9678	Vila Nova São Vicente	Vl N S Vicente
27202	SP	9678	Jardim Irmã Dolores	Jd Ima Dolores
27203	SP	9678	Vila São Jorge	Vl S Jorge
27204	SP	9678	Vila Valença	Vl Valença
27205	SP	9678	Vila Voturua	Vl Voturua
27206	SP	9686	Alto do Ginásio	At Ginásio
27207	SP	9686	Alvorada	\N
27208	SP	9686	Centro	\N
27209	SP	9686	Conjunto Habitacional Albino Baptista Sicchieri	Cj Hab A B Sicchieri
27210	SP	9686	Conjunto Habitacional Antônio Costa Patrão	Cj Hab A C Patrão
27211	SP	9686	Conjunto Habitacional Antônio Nadaletto Mazzer	Cj Hab A N Mazzer
27212	SP	9686	Conjunto Habitacional Antônio Pedro Ortolan	Cj Hab A P Ortolan
27213	SP	9686	Conjunto Habitacional Doutor Ulysses Silveira Guimarães	Cj Hab Dr U S Guimarães
27214	SP	9686	Conjunto Habitacional Doutor Walter Antônio de Pádua Becker	Cj Hab Dr W A P Becker
27215	SP	9686	Conjunto Habitacional Lourenço Domenici	Cj Hab L Domenici
27216	SP	9686	Conjunto Habitacional Lúcia Fabro Sverzut	Cj Hab L F Sverzut
27217	SP	9686	Conjunto Habitacional Luís Carlos Zequim	Cj Hab L C Zequim
27218	SP	9686	Conjunto Habitacional Maurílio Biagi	Cj Hab M Biagi
27219	SP	9686	Distrito Industrial Maria Lúcia Biagi Americano	Dt Ind M L B Americano
27224	SP	9686	Jardim Alexandre Balbo	Jd A Balbo
27225	SP	9686	Jardim América	Jd América
27226	SP	9686	Jardim Athenas	Jd Athenas
27227	SP	9686	Jardim Bela Vista	Jd Bela Vista
27228	SP	9686	Jardim Bonsucesso	Jd Bonsucesso
27229	SP	9686	Jardim Brasília	Jd Brasília
27230	SP	9686	Jardim Cajubá	Jd Cajubá
27231	SP	9686	Jardim Canaã	Jd Canaã
27233	SP	9686	Jardim das Palmeiras	Jd Palmeiras
27234	SP	9686	Jardim Diamante	Jd Diamante
27235	SP	9686	Jardim Eldorado	Jd Eldorado
27236	SP	9686	Jardim Europa	Jd Europa
27238	SP	9686	Jardim Golive	Jd Golive
27239	SP	9686	Jardim Iracema	Jd Iracema
27240	SP	9686	Jardim Itapuã	Jd Itapuã
27241	SP	9686	Jardim Jamaica	Jd Jamaica
27318	SP	9696	Jardim Alvorada	Jd Alvorada
27319	SP	9696	Jardim América	Jd América
27320	SP	9696	Jardim Americano	Jd Americano
27321	SP	9696	Jardim Ana Maria	Jd A Maria
27326	SP	9696	Jardim Atílio Silvano	Jd A Silvano
27327	SP	9696	Jardim Avore Pilungo	Jd A Pilungo
27328	SP	9696	Jardim Bandeirantes	Jd Bandeirantes
27333	SP	9696	Jardim Bertanha	Jd Bertanha
27334	SP	9696	Jardim Betânia	Jd Betânia
27335	SP	9696	Jardim Boa Esperança	Jd B Esperança
27336	SP	9696	Jardim Boa Vista	Jd B Vista
27337	SP	9696	Jardim Botânico	Jd Botânico
27338	SP	9696	Jardim Botucatu	Jd Botucatu
27339	SP	9696	Jardim Brasilândia	Jd Brasilândia
27341	SP	9696	Jardim Califórnia	Jd Califórnia
27342	SP	9696	Jardim Camila	Jd Camila
27343	SP	9696	Jardim Capitão	Jd Capitão
27344	SP	9696	Jardim Carolina	Jd Carolina
27345	SP	9696	Jardim Casa Branca	Jd C Branca
27346	SP	9696	Jardim Celeste	Jd Celeste
27349	SP	9696	Jardim Santa Claudia	Jd Sta Claudia
27352	SP	9696	Jardim Constantino Matucci	Jd C Matucci
27354	SP	9696	Jardim Cruzeiro do Sul	Jd C Sul
27355	SP	9696	Jardim das Estrelas	Jd Estrelas
27356	SP	9696	Jardim das Flores	Jd Flores
27357	SP	9696	Jardim das Magnólias	Jd Magnólias
27360	SP	9696	Ipanema das Pedras	I Pedras
27363	SP	9696	Jardim do Paço	Jd Paço
27364	SP	9696	Jardim do Sol	Jd Sol
27365	SP	9696	Jardim Dois Corações	Jd D Corações
27368	SP	9696	Jardim dos Estados	Jd Estados
27371	SP	9696	Jardim Edgar Marques	Jd E Marques
27373	SP	9696	Jardim Eltonville	Jd Eltonville
27375	SP	9696	Jardim Embaixador	Jd Embaixador
27376	SP	9696	Jardim Emília	Jd Emília
27377	SP	9696	Jardim Europa	Jd Europa
27378	SP	9696	Jardim Excelsior	Jd Excelsior
27379	SP	9696	Jardim Faculdade	Jd Faculdade
27381	SP	9696	Jardim Ferreira	Jd Ferreira
27383	SP	9696	Jardim Francini	Jd Francini
27385	SP	9696	Jardim Germiniani	Jd Germiniani
27386	SP	9696	Jardim Gonçalves	Jd Gonçalves
27387	SP	9696	Jardim Gramados de Sorocaba	Jd G Sorocaba
27388	SP	9696	Jardim Guadalajara	Jd Guadalajara
27389	SP	9696	Jardim Guadalupe	Jd Guadalupe
27391	SP	9696	Jardim Guaíba	Jd Guaíba
27393	SP	9696	Jardim Guarujá	Jd Guarujá
27394	SP	9696	Jardim Harmonia	Jd Harmonia
27395	SP	9696	Jardim Helena Cristina	Jd H Cristina
27488	SP	9696	Jardim Pires de Mello	Jd P Mello
27489	SP	9696	Jardim Pitangui	Jd Pitangui
27490	SP	9696	Jardim Planalto	Jd Planalto
27492	SP	9696	Jardim Portal da Colina	Jd P Colina
27493	SP	9696	Jardim Prestes de Barros	Jd P Barros
27495	SP	9696	Quintais do Imperador	Q Imperador
27496	SP	9696	Jardim Real	Jd Real
27498	SP	9696	Jardim Refúgio	Jd Refúgio
27500	SP	9696	Jardim Rodrigo	Jd Rodrigo
27503	SP	9696	Jardim Rosália Alcolea	Jd R Alcolea
27504	SP	9696	Jardim J S Carvalho	Jd J S Carvalho
27506	SP	9696	Jardim Saira	Jd Saira
27510	SP	9696	Jardim Sandra	Jd Sandra
27511	SP	9696	Jardim Santa Bárbara	Jd Sta Bárbara
27512	SP	9696	Jardim Santa Cecília	Jd Sta Cecília
27513	SP	9696	Jardim Santa Fé	Jd Sta Fé
27516	SP	9696	Jardim Santa Luiza	Jd Sta Luiza
27522	SP	9696	Jardim Santa Rosália	Jd Sta Rosália
27524	SP	9696	Jardim Santo Amaro	Jd Sto Amaro
27525	SP	9696	Jardim Santo André	Jd Sto André
27528	SP	9696	Jardim São Camilo	Jd S Camilo
27529	SP	9696	Jardim São Carlos	Jd S Carlos
27530	SP	9696	Jardim São Conrado	Jd S Conrado
27531	SP	9696	Jardim São Guilherme	Jd S Guilherme
27534	SP	9696	Jardim São Judas Tadeu	Jd S J Tadeu
27535	SP	9696	Jardim São Lourenzo	Jd S Lourenzo
27538	SP	9696	Jardim São Marcos	Jd S Marcos
27540	SP	9696	Jardim São Paulo	Jd S Paulo
27542	SP	9696	Jardim Simus	Jd Simus
27543	SP	9696	Jardim Siriema	Jd Siriema
27545	SP	9696	Jardim Sol Nascente	Jd S Nascente
27546	SP	9696	Jardim Sônia Maria	Jd S Maria
27547	SP	9696	Jardim Sorocabano	Jd Sorocabano
27550	SP	9696	Jardim Tatiana	Jd Tatiana
27551	SP	9696	Jardim Tortelli	Jd Tortelli
27552	SP	9696	Jardim Tupinambá	Jd Tupinambá
27554	SP	9696	Jardim Vera Cruz	Jd V Cruz
27557	SP	9696	Jardim Vergueiro	Jd Vergueiro
27561	SP	9696	Jardim Village Saint Claire	Jd V S Claire
27564	SP	9696	Jardim Zezo Miguel	Jd Z Miguel
27565	SP	9696	Jardim Zulmira	Jd Zulmira
27568	SP	9696	Lopes de Oliveira	L Oliveira
27569	SP	9696	Loteamento Dinorá Rosa	Lot D Rosa
27574	SP	9696	Morros	\N
27577	SP	9696	Parque Campolim	Prq Campolim
27578	SP	9696	Parque das Laranjeiras	Prq Laranjeiras
27580	SP	9696	Parque dos Eucaliptos	Prq Eucaliptos
27581	SP	9696	Parque Esmeralda	Prq Esmeralda
27711	SP	9696	Vila Lucy	Vl Lucy
27717	SP	9696	Vila Marina Dias	Vl Mna Dias
27723	SP	9696	Vila Melges	Vl Melges
27725	SP	9696	Vila Mineirão	Vl Mineirão
27726	SP	9696	Vila Netinho	Vl Netinho
27727	SP	9696	Vila Nicanor Marques	Vl N Marques
27731	SP	9696	Vila Nova Sorocaba	Vl N Sorocaba
27733	SP	9696	Vila Odin	Vl Odin
27735	SP	9696	Vila Olímpia	Vl Olímpia
27744	SP	9696	Vila Primavera	Vl Primavera
27745	SP	9696	Vila Progresso	Vl Progresso
27749	SP	9696	Vila Rica	Vl Rica
27755	SP	9696	Vila Sabiá	Vl Sabiá
27757	SP	9696	Vila Santa Francisca	Vl Sta Francisca
27759	SP	9696	Vila Santa Rita	Vl Sta Rita
27760	SP	9696	Vila Santa Tereza	Vl Sta Tereza
27762	SP	9696	Vila Santana	Vl Santana
27767	SP	9696	Vila São Bernardo	Vl S Bernardo
27768	SP	9696	Vila São Caetano	Vl S Caetano
27770	SP	9696	Vila São João	Vl S João
27771	SP	9696	Vila São Jorge	Vl S Jorge
27780	SP	9696	Vila Soares	Vl Soares
27782	SP	9696	Vila Sônia	Vl Sônia
27784	SP	9696	Vila Teodolinda	Vl Teodolinda
27785	SP	9696	Vila Terron	Vl Terron
27786	SP	9696	Vila Tortelli	Vl Tortelli
27787	SP	9696	Vila Trujillo	Vl Trujillo
27790	SP	9696	Vila Zacarias	Vl Zacarias
27794	SP	9696	Vivendas do Lago	V Lago
27796	SP	9696	Wanel Ville	W Ville
27799	SP	9696	Zona Industrial	Z Industrial
27800	SP	9700	Altos de Sumaré	A Sumaré
27801	SP	9700	Jardim Nova Esperança I	Jd N Esperança I
27802	SP	9700	Jardim Nova Esperança II	Jd N Esperança II
27803	SP	9700	Jardim Nova Esperança III	Jd N Esperança III
27804	SP	9700	Centro	\N
27805	SP	9700	Chácara Bela Vista	Ch B Vista
27806	SP	9700	Chácara Cruzeiro do Sul	Ch C Sul
27807	SP	9700	Chácara Estrela D'Alva	Ch E D'Alva
27808	SP	9700	Chácara Monte Alegre	Ch Mte Alegre
27810	SP	9700	Chácara Primavera	Ch Primavera
27811	SP	9700	Vila San Martin (Nova Veneza)	Vl S Martin (N Veneza)
27812	SP	9700	Chácara Santa Antonieta (Nova Veneza)	Ch Sta Antonieta (N Veneza)
27814	SP	9700	Chácaras Reunidas Anhangüera (Nova Veneza)	C R Anhangüera (N Veneza)
27815	SP	9700	Condomínio Coronel (Nova Veneza)	Cond Coronel (N Veneza)
27816	SP	9700	Conjunto Habitacional Angelo Tomazin	Cj Hab A Tomazin
27818	SP	9700	Jardim Aclimação (Nova Veneza)	Jd Aclimação (N Veneza)
27861	SP	9700	Jardim Nova Aurora (Nova Veneza)	Jd N Aurora (N Veneza)
27862	SP	9700	Jardim Nova Terra (Nova Veneza)	Jd N Terra (N Veneza)
27863	SP	9700	Jardim Nova Veneza (Nova Veneza)	Jd N Veneza (N Veneza)
27864	SP	9700	Jardim Novo Paraná	Jd N Paraná
27865	SP	9700	Jardim Paraíso I (Nova Veneza)	Jd Paraíso I (N Veneza)
27866	SP	9700	Jardim Paraíso II (Nova Veneza)	Jd Paraíso II (N Veneza)
27867	SP	9700	Jardim Paulista	Jd Paulista
27868	SP	9700	Jardim Paulistano	Jd Paulistano
27870	SP	9700	Jardim Picerno I	Jd Picerno I
27871	SP	9700	Jardim Picerno II	Jd Picerno II
27872	SP	9700	Jardim Primavera	Jd Primavera
27873	SP	9700	Jardim Puch	Jd Puch
27874	SP	9700	Parque Rosa e Silva	Prq R E Silva
27876	SP	9700	Jardim San Martins (Nova Veneza)	Jd S Martins (N Veneza)
27878	SP	9700	Jardim Santa Carolina (Nova Veneza)	Jd Sta Carolina (N Veneza)
27880	SP	9700	Jardim Santa Clara (Nova Veneza)	Jd Sta Clara (N Veneza)
27881	SP	9700	Jardim Santa Eliza (Nova Veneza)	Jd Sta Eliza (N Veneza)
27882	SP	9700	Jardim Santa Julia (Nova Veneza)	Jd Sta Julia (N Veneza)
27883	SP	9700	Jardim Santa Lúcia (Nova Veneza)	Jd Sta Lúcia (N Veneza)
27884	SP	9700	Jardim Santa Madalena	Jd Sta Madalena
27885	SP	9700	Jardim Santa Maria (Nova Veneza)	Jd Sta Maria (N Veneza)
27886	SP	9700	Jardim Santa Olivia (Nova Veneza)	Jd Sta Olivia (N Veneza)
27887	SP	9700	Jardim Santa Rosa (Nova Veneza)	Jd Sta Rosa (N Veneza)
27888	SP	9700	Jardim Santa Terezinha (Nova Veneza)	Jd Sta Terezinha (N Veneza)
27889	SP	9700	Jardim Santiago (Nova Veneza)	Jd Santiago (N Veneza)
27891	SP	9700	Jardim São Carlos	Jd S Carlos
27892	SP	9700	Jardim São Domingos	Jd S Domingos
27893	SP	9700	Jardim São Francisco (Nova Veneza)	Jd S Francisco (N Veneza)
27894	SP	9700	Jardim São Gerônimo (Nova Veneza)	Jd S Gerônimo (N Veneza)
27896	SP	9700	Jardim São Judas Tadeu (Nova Veneza)	Jd S J Tadeu (N Veneza)
27897	SP	9700	Jardim São Luiz (Nova Veneza)	Jd S Luiz (N Veneza)
27898	SP	9700	Jardim São Roque	Jd S Roque
27900	SP	9700	Jardim Viel	Jd Viel
27901	SP	9700	Parque Residencial Virginio Basso	Prq Res V Basso
27902	SP	9700	Jardim Vitória (Nova Veneza)	Jd Vitória (N Veneza)
27939	SP	9700	Vila Carlos Basso	Vl C Basso
27940	SP	9700	Vila Carlota	Vl Carlota
27942	SP	9700	Vila Diva (Nova Veneza)	Vl Diva (N Veneza)
27943	SP	9700	Vila Juliana	Vl Juliana
27944	SP	9700	Vila Menuzzo	Vl Menuzzo
27945	SP	9700	Vila Miranda	Vl Miranda
27947	SP	9700	Vila Rebouças	Vl Rebouças
27948	SP	9700	Vila Santa Terezinha	Vl Sta Terezinha
27949	SP	9700	Vila Santana	Vl Santana
27950	SP	9700	Vila Valle	Vl Valle
27951	SP	9700	Vila Yolanda Costa e Silva	Vl Y C E Silva
27953	SP	9700	Vila Zilda Natel	Vl Z Natel
27954	SP	9703	Jardim Silvestre	Jd Silvestre
27956	SP	9703	Caxangá	\N
27957	SP	9703	Centro	\N
27958	SP	9703	Chácara Estância Paulista	Ch Etn Paulista
27959	SP	9703	Chácara Faggion	Ch Faggion
27960	SP	9703	Cidade Miguel Badra (Gleba 02)	C M Badra (Gleba 02)
27961	SP	9703	Chácara Nossa Senhora Aparecida I	Ch N Sra Aparecida I
27962	SP	9703	Chácara Ouro Branco	Ch O Branco
27963	SP	9703	Chácara Primavera	Ch Primavera
27964	SP	9703	Chácara Recreio Internacional	Ch Rcr Internacional
27965	SP	9703	Chácaras Bonanza	C Bonanza
27966	SP	9703	Chácaras Casemiro	C Casemiro
27967	SP	9703	Chácaras Ceres	C Ceres
27969	SP	9703	Chácaras Duchen	C Duchen
27970	SP	9703	Chácaras Monte Carlo	C Mte Carlo
27971	SP	9703	Chácara Nossa Senhora Aparecida II	Ch N Sra Aparecida II
27972	SP	9703	Chácaras Nova Suzano	C N Suzano
27973	SP	9703	Chácaras Reunidas Guaio	C R Guaio
27974	SP	9703	Chácaras São Judas Tadeu	C S J Tadeu
27975	SP	9703	Chácaras Virginia	C Virginia
27976	SP	9703	Cidade Boa Vista	C B Vista
27977	SP	9703	Cidade Cruzeiro do Sul	C C Sul
27978	SP	9703	Cidade Edson	C Edson
27979	SP	9703	Clube dos Oficiais	C Oficiais
27981	SP	9703	Conjunto Residencial Irai	Cj Res Irai
27982	SP	9703	Estância Americana	Etn Americana
27983	SP	9703	Estância Angelina	Etn Angelina
27984	SP	9703	Estância Piratininga	Etn Piratininga
27985	SP	9703	Estância São Luís	Etn S Luís
27986	SP	9703	Estância Tijuco Preto	Etn T Preto
27987	SP	9703	Fazenda Aya	Faz Aya
27988	SP	9703	Ipelândia	\N
27989	SP	9703	Jardim Aeródromo Internacional	Jd A Internacional
27990	SP	9703	Jardim Alterópolis	Jd Alterópolis
27991	SP	9703	Jardim Altos de Suzano	Jd A Suzano
27992	SP	9703	Jardim Amazonas	Jd Amazonas
27994	SP	9703	Jardim Anzai	Jd Anzai
27995	SP	9703	Jardim Belém	Jd Belém
27996	SP	9703	Jardim Brasil	Jd Brasil
27997	SP	9703	Jardim Cacique	Jd Cacique
27998	SP	9703	Jardim Campestre	Jd Campestre
27999	SP	9703	Jardim Carlos Cooper	Jd C Cooper
28000	SP	9703	Jardim Carmem	Jd Carmem
28001	SP	9703	Jardim Casa Branca	Jd C Branca
28002	SP	9703	Jardim Chácara Méa	Jd Ch Méa
28003	SP	9703	Jardim das Flores	Jd Flores
28004	SP	9703	Jardim das Lavras	Jd Lavras
28005	SP	9703	Jardim das Lavras II	Jd Lavras II
28006	SP	9703	Jardim das Lavras Mirim	Jd L Mirim
28007	SP	9703	Jardim do Lago	Jd Lago
28008	SP	9703	Jardim Dona Benta	Jd Da Benta
28009	SP	9703	Jardim Dora	Jd Dora
28010	SP	9703	Jardim dos Eucaliptos	Jd Eucaliptos
28011	SP	9703	Jardim dos Pinheirais	Jd Pinheirais
28012	SP	9703	Jardim Esperança	Jd Esperança
28013	SP	9703	Jardim Etan	Jd Etan
28014	SP	9703	Jardim Europa	Jd Europa
28015	SP	9703	Jardim Fernandes	Jd Fernandes
28016	SP	9703	Jardim Gardênia Azul	Jd G Azul
28017	SP	9703	Jardim Graziela	Jd Graziela
28019	SP	9703	Jardim Guatambu	Jd Guatambu
28020	SP	9703	Jardim Ikeda	Jd Ikeda
28021	SP	9703	Jardim Imperador	Jd Imperador
28022	SP	9703	Jardim Itamaracá	Jd Itamaracá
28024	SP	9703	Jardim Japão	Jd Japão
28025	SP	9703	Jardim Josué	Jd Josué
28026	SP	9703	Jardim Lazzareschi	Jd Lazzareschi
28027	SP	9703	Jardim Leblon	Jd Leblon
28028	SP	9703	Jardim Leymar	Jd Leymar
28029	SP	9703	Jardim Lígia	Jd Lígia
28030	SP	9703	Jardim Lincoln	Jd Lincoln
28031	SP	9703	Jardim Luella	Jd Luella
28032	SP	9703	Jardim Maite	Jd Maite
28033	SP	9703	Jardim Marcato	Jd Marcato
28034	SP	9703	Jardim Margareth	Jd Margareth
28035	SP	9703	Jardim Maria Emília	Jd M Emília
28036	SP	9703	Jardim Mimosa	Jd Mimosa
28037	SP	9703	Jardim Míriam	Jd Míriam
28038	SP	9703	Jardim Modelo	Jd Modelo
28039	SP	9703	Jardim Monte Cristo	Jd Mte Cristo
28040	SP	9703	Jardim Natal	Jd Natal
28041	SP	9703	Jardim Nazareth	Jd Nazareth
28042	SP	9703	Jardim Nena	Jd Nena
28043	SP	9703	Jardim Nova América	Jd N América
28044	SP	9703	Jardim Nova Ipelândia	Jd N Ipelândia
28046	SP	9703	Jardim Paulista	Jd Paulista
28047	SP	9703	Jardim Planalto	Jd Planalto
28102	SP	9703	Recreio Sertãozinho	Rcr Sertãozinho
28103	SP	9703	Rincão das Lendas	R Lendas
28104	SP	9703	Rio Abaixo	R Abaixo
28105	SP	9703	Sesc	\N
28106	SP	9703	Sítio São José	Sit S José
28108	SP	9703	Taba Marajoara	T Marajoara
28109	SP	9703	Vale das Serras	Vle Serras
28110	SP	9703	Veraneio Juruá	V Juruá
28111	SP	9703	Veraneio Suzano	V Suzano
28112	SP	9703	Vila Adelina	Vl Adelina
28113	SP	9703	Vila Adelino	Vl Adelino
28115	SP	9703	Vila Amorim	Vl Amorim
28116	SP	9703	Vila Aparecida	Vl Aparecida
28117	SP	9703	Vila Barros	Vl Barros
28118	SP	9703	Vila Beatriz	Vl Beatriz
28119	SP	9703	Vila Bela Vista	Vl B Vista
28121	SP	9703	Vila Cabrera	Vl Cabrera
28122	SP	9703	Vila Célia	Vl Célia
28124	SP	9703	Vila Colorado	Vl Colorado
28125	SP	9703	Vila Costa	Vl Costa
28126	SP	9703	Vila Fátima	Vl Fátima
28127	SP	9703	Vila Figueira	Vl Figueira
28128	SP	9703	Vila Helena	Vl Helena
28130	SP	9703	Vila Laura	Vl Laura
28131	SP	9703	Vila Maluf	Vl Maluf
28132	SP	9703	Vila Maneira	Vl Maneira
28133	SP	9703	Vila Maria de Maggi	Vl M Maggi
28134	SP	9703	Vila Mazza	Vl Mazza
28135	SP	9703	Vila Mifune	Vl Mifune
28136	SP	9703	Vila Monte Sion	Vl Mte Sion
28137	SP	9703	Vila Nova Amorim	Vl N Amorim
28138	SP	9703	Vila Nova das Lavras	Vl N Lavras
28139	SP	9703	Vila Nova Urupês	Vl N Urupês
28140	SP	9703	Vila Paiva	Vl Paiva
28142	SP	9703	Vila Real Santista	Vl R Santista
28143	SP	9703	Vila Rica	Vl Rica
28147	SP	9703	Vila Santana	Vl Santana
28148	SP	9703	Vila São Francisco	Vl S Francisco
28149	SP	9703	Vila São Jorge	Vl S Jorge
28150	SP	9703	Vila São Pedro	Vl S Pedro
28151	SP	9703	Vila Sol Nascente	Vl S Nascente
28154	SP	9703	Vila Theodoro	Vl Theodoro
28155	SP	9703	Vila Urupês	Vl Urupês
28156	SP	9703	Vila Voeges	Vl Voeges
28157	SP	9703	Zona Jaguari	Z Jaguari
28158	SP	9703	Zona Planalto	Z Planalto
28160	SP	9703	Zona Ribeirão	Z Ribeirão
28161	SP	9707	Arraial Paulista	A Paulista
28162	SP	9707	Centro	\N
28163	SP	9707	Chácara Agrindus	Ch Agrindus
28164	SP	9707	Cidade Intercap	C Intercap
28165	SP	9707	Condomínio Iolanda	Cond Iolanda
28166	SP	9707	Jardim Altos do Taboao	Jd A Taboao
28167	SP	9707	Jardim América	Jd América
28168	SP	9707	Jardim Beatriz	Jd Beatriz
27903	SP	9700	Jardim Volobueff (Nova Veneza)	Jd Volobueff (N Veneza)
27905	SP	9700	Parque Bandeirantes I (Nova Veneza)	Prq Bandeirantes I (N Veneza)
27906	SP	9700	Parque Bandeirantes II (Nova Veneza)	Prq Bandeirantes II (N Veneza)
27907	SP	9700	Parque da Amizade (Nova Veneza)	Prq Amizade (N Veneza)
27908	SP	9700	Parque Dante Marmiroli	Prq D Marmiroli
27909	SP	9700	Parque das Indústrias (Nova Veneza)	Prq Indústrias (N Veneza)
27910	SP	9700	Parque das Nações (Nova Veneza)	Prq Nações (N Veneza)
27911	SP	9700	Parque Emília	Prq Emília
27912	SP	9700	Parque Euclides Miranda	Prq E Miranda
27913	SP	9700	Parque Florely (Nova Veneza)	Prq Florely (N Veneza)
27914	SP	9700	Parque Residencial Florença	Prq Res Florença
27915	SP	9700	Parque Franceschini	Prq Franceschini
27916	SP	9700	Parque General Osório (Nova Veneza)	Prq Gen Osório (N Veneza)
27917	SP	9700	Parque Hongaro	Prq Hongaro
27918	SP	9700	Parque Ideal (Nova Veneza)	Prq Ideal (N Veneza)
27919	SP	9700	Parque Itália (Nova Veneza)	Prq Itália (N Veneza)
27920	SP	9700	Parque Jatobá (Nova Veneza)	Prq Jatobá (N Veneza)
27921	SP	9700	Parque João de Vasconcelos	Prq J Vasconcelos
27922	SP	9700	Parque Manoel de Vasconcelos	Prq M Vasconcelos
27923	SP	9700	Parque Nova Veneza/Inocoop (Nova Veneza)	Prq N Veneza/Inocoop (N Veneza)
27924	SP	9700	Parque Progresso (Nova Veneza)	Prq Progresso (N Veneza)
27925	SP	9700	Parque Residencial Casarão	Prq Res Casarão
27926	SP	9700	Parque Residencial Regina (Nova Veneza)	Prq Res Regina (N Veneza)
27927	SP	9700	Parque Residencial Salerno (Nova Veneza)	Prq Res Salerno (N Veneza)
27928	SP	9700	Parque Santo Antônio (Nova Veneza)	Prq Sto Antônio (N Veneza)
27929	SP	9700	Parque São Bento	Prq S Bento
27931	SP	9700	Parque Sevilha (Nova Veneza)	Prq Sevilha (N Veneza)
27932	SP	9700	Parque Silva Azevedo (Nova Veneza)	Prq S Azevedo (N Veneza)
27933	SP	9700	Parque Residencial Versailles	Prq Res Versailles
27934	SP	9700	Parque Virgílio Viel	Prq V Viel
27935	SP	9700	Parque Yolanda (Nova Veneza)	Prq Yolanda (N Veneza)
27936	SP	9700	Planalto do Sol	P Sol
27937	SP	9700	Residencial Recanto das Árvores	Res Rec Árvores
28048	SP	9703	Jardim Pompéia	Jd Pompéia
28050	SP	9703	Jardim Realce	Jd Realce
28052	SP	9703	Jardim Residencial Suzano	Jd Res Suzano
28053	SP	9703	Jardim Restinga	Jd Restinga
28054	SP	9703	Jardim Revista	Jd Revista
28055	SP	9703	Jardim Santa Helena	Jd Sta Helena
28056	SP	9703	Jardim Santa Inês	Jd Sta Inês
28057	SP	9703	Jardim Santa Lúcia	Jd Sta Lúcia
28058	SP	9703	Jardim Santa Maria	Jd Sta Maria
28059	SP	9703	Jardim Santa Rita de Cássia	Jd Sta R Cássia
28060	SP	9703	Jardim Santo Antônio	Jd Sto Antônio
28062	SP	9703	Jardim São Bernardino	Jd S Bernardino
28063	SP	9703	Jardim São José	Jd S José
28064	SP	9703	Jardim São Luís	Jd S Luís
28066	SP	9703	Jardim São Marcos	Jd S Marcos
28067	SP	9703	Jardim São Paulo	Jd S Paulo
28068	SP	9703	Jardim São Silvestre	Jd S Silvestre
28069	SP	9703	Jardim Saúde	Jd Saúde
28070	SP	9703	Jardim Suzano	Jd Suzano
28071	SP	9703	Jardim Suzanópolis	Jd Suzanópolis
28073	SP	9703	Jardim Varan	Jd Varan
28074	SP	9703	Jardim Vitória	Jd Vitória
28075	SP	9703	Meu Cantinho	M Cantinho
28076	SP	9703	Meu Sossego	M Sossego
28077	SP	9703	Palmeiras de São Paulo	P S Paulo
28078	SP	9703	Parque Alvorada	Prq Alvorada
28079	SP	9703	Parque Astúrias	Prq Astúrias
28080	SP	9703	Parque Buenos Aires	Prq B Aires
28081	SP	9703	Parque Cerejeiras	Prq Cerejeiras
28082	SP	9703	Parque das Lavras	Prq Lavras
28083	SP	9703	Parque do Colégio	Prq Colégio
28084	SP	9703	Parque do Heroísmo	Prq Heroísmo
28085	SP	9703	Parque Maria Helena	Prq M Helena
28086	SP	9703	Parque Mirim	Prq Mirim
28087	SP	9703	Parque Palmeiras	Prq Palmeiras
28088	SP	9703	Parque Residencial Casa Branca	Prq Res C Branca
28089	SP	9703	Parque Residencial Samambaia	Prq Res Samambaia
28090	SP	9703	Parque Santa Rosa	Prq Sta Rosa
28091	SP	9703	Parque Suzano	Prq Suzano
28092	SP	9703	Parque Umuarama	Prq Umuarama
28094	SP	9703	Recanto Feliz	Rec Feliz
28095	SP	9703	Recanto Maria de Jesus	Rec M Jesus
28096	SP	9703	Recanto Ouro Fino	Rec O Fino
28097	SP	9703	Recanto São José	Rec S José
28098	SP	9703	Recreio Bela Vista	Rcr B Vista
28099	SP	9703	Recreio das Palmas	Rcr Palmas
28100	SP	9703	Recreio Rio Bonito	Rcr R Bonito
28101	SP	9703	Recreio Santa Rita	Rcr Sta Rita
28169	SP	9707	Jardim Bom Tempo	Jd B Tempo
28170	SP	9707	Jardim Bonanza	Jd Bonanza
28171	SP	9707	Jardim Caner	Jd Caner
28172	SP	9707	Jardim Clementino	Jd Clementino
28173	SP	9707	Jardim da Glória	Jd Glória
28174	SP	9707	Jardim Elizabete	Jd Elizabete
28175	SP	9707	Jardim Flórida	Jd Flórida
28176	SP	9707	Jardim Frei Galvão	Jd Fr Galvão
28177	SP	9707	Jardim Freitas Júnior	Jd F Júnior
28178	SP	9707	Jardim Guaciara	Jd Guaciara
28179	SP	9707	Jardim Guayana	Jd Guayana
28180	SP	9707	Jardim Helena	Jd Helena
28181	SP	9707	Jardim Henriqueta	Jd Henriqueta
28182	SP	9707	Jardim Iracema	Jd Iracema
28183	SP	9707	Jardim Irapua	Jd Irapua
28184	SP	9707	Jardim Kuabara	Jd Kuabara
28185	SP	9707	Jardim Leme	Jd Leme
28186	SP	9707	Jardim Lotec	Jd Lotec
28187	SP	9707	Jardim Margarida	Jd Margarida
28188	SP	9707	Jardim Maria da Costa	Jd M Costa
28189	SP	9707	Jardim Maria Helena	Jd M Helena
28190	SP	9707	Jardim Maria Luiza	Jd M Luiza
28191	SP	9707	Jardim Maria Rosa	Jd M Rosa
28192	SP	9707	Jardim Maria Sampaio	Jd M Sampaio
28193	SP	9707	Jardim Marlene	Jd Marlene
28194	SP	9707	Jardim Mirna	Jd Mirna
28195	SP	9707	Jardim Mituzi	Jd Mituzi
28196	SP	9707	Jardim Monte Alegre	Jd Mte Alegre
28197	SP	9707	Jardim Olinda	Jd Olinda
28198	SP	9707	Jardim Oliveiras	Jd Oliveiras
28199	SP	9707	Jardim Ouro Preto	Jd O Preto
28200	SP	9707	Jardim Panorama	Jd Panorama
28201	SP	9707	Jardim Paraíso	Jd Paraíso
28202	SP	9707	Jardim Pazini	Jd Pazini
28203	SP	9707	Jardim Pedro Gonçalves	Jd P Gonçalves
28204	SP	9707	Jardim Pirajussara	Jd Pirajussara
28205	SP	9707	Jardim Record	Jd Record
28206	SP	9707	Jardim Roberto	Jd Roberto
28207	SP	9707	Jardim Saint Moritz	Jd S Moritz
28208	SP	9707	Jardim Salete	Jd Salete
28209	SP	9707	Jardim Santa Cecília	Jd Sta Cecília
28210	SP	9707	Jardim Santa Cruz	Jd Sta Cruz
28211	SP	9707	Jardim Santa Rosa	Jd Sta Rosa
28212	SP	9707	Jardim Santa Terezinha	Jd Sta Terezinha
28213	SP	9707	Jardim Santo Onofre	Jd Sto Onofre
28214	SP	9707	Jardim São João	Jd S João
28215	SP	9707	Jardim São Judas Tadeu	Jd S J Tadeu
28216	SP	9707	Jardim São Luiz	Jd S Luiz
28217	SP	9707	Jardim São Mateus	Jd S Mateus
28218	SP	9707	Jardim São Miguel	Jd S Miguel
28273	SP	9725	Fundação Educacional Manoel Guedes	F E M Guedes
28275	SP	9725	Jardim Aeroporto	Jd Aeroporto
28276	SP	9725	Jardim América	Jd América
28278	SP	9725	Jardim Andrea Ville	Jd A Ville
28279	SP	9725	Jardim Andrea Ville II	Jd A Ville II
28280	SP	9725	Jardim Bela Vista	Jd B Vista
28281	SP	9725	Jardim das Perdizes	Jd Perdizes
28282	SP	9725	Jardim Europa	Jd Europa
28283	SP	9725	Jardim Fortunato Minghini	Jd F Minghini
28284	SP	9725	Jardim das Garças	Jd Garças
28285	SP	9725	Jardim Gonzaga	Jd Gonzaga
28286	SP	9725	Jardim Gramado	Jd Gramado
28287	SP	9725	Jardim Lírio	Jd Lírio
28288	SP	9725	Jardim Lucila	Jd Lucila
28289	SP	9725	Jardim Manoel de Abreu	Jd M Abreu
28290	SP	9725	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
28291	SP	9725	Jardim Novo Horizonte	Jd N Horizonte
28292	SP	9725	Jardim Palmira	Jd Palmira
28293	SP	9725	Jardim Paulista	Jd Paulista
28294	SP	9725	Jardim Primavera	Jd Primavera
28295	SP	9725	Jardim Primavera II	Jd Primavera II
28297	SP	9725	Jardim Rosa Garcia	Jd R Garcia
28298	SP	9725	Jardim Saba	Jd Saba
28301	SP	9725	Jardim Santa Rita de Cássia	Jd Sta R Cássia
28303	SP	9725	Jardim São João	Jd S João
28304	SP	9725	Jardim São Luiz	Jd S Luiz
28305	SP	9725	Jardim São Paulo	Jd S Paulo
28306	SP	9725	Jardim Tatuí	Jd Tatuí
28307	SP	9725	Jardim Ternura	Jd Ternura
28308	SP	9725	Jardim Thomaz Guedes	Jd T Guedes
28309	SP	9725	Jardim Tokio	Jd Tokio
28310	SP	9725	Jardim Vale da Lua	Jd Vle Lua
28311	SP	9725	Jardim Wanderley	Jd Wanderley
28312	SP	9725	Jardim XI de Agosto	Jd XI Agosto
28313	SP	9725	Lincoln Parque	L Parque
28314	SP	9725	Loteamento Amaro Padilha	Lot A Padilha
28315	SP	9725	Loteamento Modena	Lot Modena
28316	SP	9725	Nova Tatuí	N Tatuí
28317	SP	9725	Parque Gerbeli	Prq Gerbeli
28318	SP	9725	Parque Marajoara	Prq Marajoara
28319	SP	9725	Parque Residencial Colina das Estrelas	Prq Res C Estrelas
28320	SP	9725	Residencial Guedes	Res Guedes
28321	SP	9725	Parque Residencial São Marcos	Prq Res S Marcos
28322	SP	9725	Parque Santa Maria	Prq Sta Maria
28323	SP	9725	Parque São Rafael	Prq S Rafael
28325	SP	9725	Portal das Nogueiras	P Nogueiras
28326	SP	9725	São Judas Tadeu	S J Tadeu
28327	SP	9725	Vale dos Lagos	Vle Lagos
28443	SP	9726	Jardim Santa Cruz	Jd Sta Cruz
28445	SP	9726	Jardim Santa Tereza	Jd Sta Tereza
28454	SP	9726	Loteamento Industrial	Lot Industrial
28460	SP	9726	Monte Belo	Mte Belo
28461	SP	9726	Morada dos Nobres	M Nobres
28463	SP	9726	Parque Aeroporto	Prq Aeroporto
28471	SP	9726	Parque Piratininga	Prq Piratininga
28475	SP	9726	Parque Residencial Bom Conselho	Prq Res B Conselho
28478	SP	9726	Parque Santo Antônio	Prq Sto Antônio
28479	SP	9726	Parque São Cristóvão	Prq S Cristóvão
28481	SP	9726	Parque São Luís	Prq S Luís
28482	SP	9726	Parque Senhor do Bonfim	Prq Sr Bonfim
28489	SP	9726	Quiririm	\N
28493	SP	9726	Residencial Dalla Rosa	Res D Rosa
28496	SP	9726	Residencial Paraíso	Res Paraíso
28499	SP	9726	Residencial Sítio Santo Antônio	Res Sit Sto Antônio
28507	SP	9726	Terra Nova	T Nova
28509	SP	9726	Vila Bela	Vl Bela
28516	SP	9726	Vila Iapi	Vl Iapi
28517	SP	9726	Vila Jaboticabeira	Vl Jaboticabeira
28526	SP	9726	Vila Nossa Senhora das Graças	Vl N Sra Graças
28531	SP	9726	Vila Regedor	Vl Regedor
28537	SP	9726	Vila São Geraldo	Vl S Geraldo
28539	SP	9726	Vila São José	Vl S José
28541	SP	9748	Centro	\N
28542	SP	9748	Chácara Velini	Ch Velini
28543	SP	9748	Conjunto Habitacional Antônio Pereira Gaspar	Cj Hab A P Gaspar
28544	SP	9748	Conjunto Habitacional Cinqüentenário	Cj Hab Cinqüentenário
28545	SP	9748	Conjunto Habitacional Cônego Eduardo Rebouças de Carvalho	Cj Hab Con E R Carvalho
28546	SP	9748	Conjunto Habitacional Doutor Walter Pimentel	Cj Hab Dr W Pimentel
28547	SP	9748	Conjunto Habitacional José Maria Gonçalves Gameiro	Cj Hab J M G Gameiro
28548	SP	9748	Conjunto Habitacional Severino Fortunato da Silva	Cj Hab S F Silva
28550	SP	9748	Conjunto Habitacional Vereador Joaquim Ribeiro Porto	Cj Hab Ver J R Porto
28551	SP	9748	Fredyville	\N
28552	SP	9748	Jardim América	Jd América
28553	SP	9748	Jardim Apoema	Jd Apoema
28554	SP	9748	Jardim Aritana	Jd Aritana
28556	SP	9748	Jardim Cerejeiras	Jd Cerejeiras
28557	SP	9748	Jardim Cybelle	Jd Cybelle
28558	SP	9748	Jardim Guanabara	Jd Guanabara
28559	SP	9748	Jardim Guarujá	Jd Guarujá
28560	SP	9748	Jardim Ideal	Jd Ideal
28561	SP	9748	Jardim Ipiranga	Jd Ipiranga
28625	SP	9748	Vila Santa Amália	Vl Sta Amália
28627	SP	9748	Vila Santa Clara	Vl Sta Clara
28628	SP	9748	Vila Santa Helena	Vl Sta Helena
28629	SP	9748	Vila Santa Inez	Vl Sta Inez
28630	SP	9748	Vila Santa Rita de Cássia	Vl Sta R Cássia
28631	SP	9748	Vila Santa Terezinha	Vl Sta Terezinha
28632	SP	9748	Vila São Jorge	Vl S Jorge
28633	SP	9748	Vila São José	Vl S José
28634	SP	9748	Vila São Paulo	Vl S Paulo
28635	SP	9748	Vila Sevilha	Vl Sevilha
28636	SP	9748	Vila Siduro	Vl Siduro
28637	SP	9748	Vila Teixeira	Vl Teixeira
28638	SP	9748	Vila Tupã Mirim I	Vl T Mirim I
28640	SP	9748	Vila Vargas	Vl Vargas
28641	SP	9748	Vila Viaduto	Vl Viaduto
28642	SP	9748	Vila Vitória	Vl Vitória
28643	SP	9768	Bela Vista	B Vista
28644	SP	9768	Capuava	\N
28645	SP	9768	Castelo	\N
28646	SP	9768	Centro	\N
28647	SP	9768	Chácara das Nações	Ch Nações
28648	SP	9768	Chácara Flora	Ch Flora
28649	SP	9768	Chácara Nova Era	Ch N Era
28650	SP	9768	Chácara Previtale	Ch Previtale
28651	SP	9768	Chácaras Alpina	C Alpina
28652	SP	9768	Chácaras São Bento	C S Bento
28653	SP	9768	Chácaras Silvania	C Silvania
28654	SP	9768	Colina dos Pinheiros	C Pinheiros
28655	SP	9768	Colinas dos Álamos	C Álamos
28656	SP	9768	Dois Córregos	D Córregos
28657	SP	9768	Estância Recreativa San Fernando	Etn R S Fernando
28658	SP	9768	Fazenda Hotel São Bento do Recreio	Faz H S B Recreio
28659	SP	9768	Jardim Alto da Boa Vista	Jd At B Vista
28660	SP	9768	Jardim Alto da Colina	Jd At Colina
28661	SP	9768	Jardim América	Jd América
28662	SP	9768	Jardim América II	Jd América II
28663	SP	9768	Jardim Bela Vista	Jd B Vista
28664	SP	9768	Jardim Bom Retiro	Jd B Retiro
28665	SP	9768	Jardim Celani	Jd Celani
28666	SP	9768	Jardim Centenário	Jd Centenário
28667	SP	9768	Jardim das Figueiras	Jd Figueiras
28668	SP	9768	Jardim das Palmeiras	Jd Palmeiras
28669	SP	9768	Jardim das Vitórias Régias	Jd V Régias
28670	SP	9768	Jardim do Lago	Jd Lago
28671	SP	9768	Jardim dos Manacás	Jd Manacás
28672	SP	9768	Jardim Eliza	Jd Eliza
28673	SP	9768	Jardim Europa	Jd Europa
28674	SP	9768	Jardim Imperial	Jd Imperial
28675	SP	9768	Jardim Itapuã	Jd Itapuã
28676	SP	9768	Jardim Jurema	Jd Jurema
28677	SP	9768	Jardim Lorena	Jd Lorena
28731	SP	9768	Vila Anhangüera	Vl Anhangüera
28732	SP	9768	Vila Bissoto	Vl Bissoto
28733	SP	9768	Vila Boa Esperança	Vl B Esperança
28734	SP	9768	Vila Capuava	Vl Capuava
28735	SP	9768	Vila Clayton	Vl Clayton
28736	SP	9768	Vila Coqueiro	Vl Coqueiro
28737	SP	9768	Vila D'Agostinho	Vl D'Agostinho
28738	SP	9768	Vila El Aiub	Vl E Aiub
28739	SP	9768	Vila Embaré	Vl Embaré
28740	SP	9768	Vila Faustina I	Vl Faustina I
28741	SP	9768	Vila Faustina II	Vl Faustina II
28742	SP	9768	Vila Franceschini	Vl Franceschini
28743	SP	9768	Vila Genoveva	Vl Genoveva
28744	SP	9768	Vila Independência	Vl Independência
28745	SP	9768	Vila Jair	Vl Jair
28746	SP	9768	Vila Martina	Vl Martina
28747	SP	9768	Vila Moletta	Vl Moletta
28748	SP	9768	Vila Negrello	Vl Negrello
28749	SP	9768	Vila Norma	Vl Norma
28750	SP	9768	Vila Nova São Sebastião	Vl N S Sebastião
28751	SP	9768	Vila Nova Valinhos	Vl N Valinhos
28752	SP	9768	Vila Olivo	Vl Olivo
28753	SP	9768	Vila Pagano	Vl Pagano
28754	SP	9768	Vila Papelão	Vl Papelão
28755	SP	9768	Vila Progresso	Vl Progresso
28756	SP	9768	Vila Ramaciotti	Vl Ramaciotti
28757	SP	9768	Vila Santana	Vl Santana
28758	SP	9768	Vila Santo Antônio	Vl Sto Antônio
28759	SP	9768	Vila São Cristóvão	Vl S Cristóvão
28760	SP	9768	Vila São Joaquim	Vl S Joaquim
28761	SP	9768	Vila São José	Vl S José
28762	SP	9768	Vila São Luiz	Vl S Luiz
28763	SP	9768	Vila São Sebastião	Vl S Sebastião
28764	SP	9768	Vila Sonia	Vl Sonia
28766	SP	9768	Vila Thereza	Vl Thereza
28767	SP	9768	Village Sans Souci	V S Souci
28768	SP	9768	Village Visconde de Itamaracá	V Vsc Itamaracá
28769	SP	9775	Aldeia Primavera	A Primavera
28770	SP	9775	Área Industrial	A Industrial
28771	SP	9775	Centro	\N
28772	SP	9775	Chácaras Aracary	C Aracary
28773	SP	9775	Chácaras Clube Castanheiro	C C Castanheiro
28774	SP	9775	Chácaras Paulista	C Paulista
28775	SP	9775	Chácaras Santa Martha	C Sta Martha
28776	SP	9775	Chácaras São Guido	C S Guido
28777	SP	9775	Cidade Nova II	C Nova II
28778	SP	9775	Ieiri	\N
28779	SP	9775	Jardim Itapoan	Jd Itapoan
28780	SP	9775	Jardim Alessandra	Jd Alessandra
28781	SP	9775	Jardim América	Jd América
28785	SP	9775	Jardim Bela Vista	Jd Bela Vista
28786	SP	9775	Jardim Bertioga	Jd Bertioga
28787	SP	9775	Jardim Boa Vista	Jd B Vista
28788	SP	9775	Jardim Buriti	Jd Buriti
28789	SP	9775	Jardim Cruz Alta	Jd C Alta
28790	SP	9775	Jardim da Felicidade	Jd Felicidade
28791	SP	9775	Jardim das Acácias	Jd Acácias
28792	SP	9775	Jardim das Palmeiras	Jd Palmeiras
28793	SP	9775	Jardim Diana	Jd Diana
28794	SP	9775	Jardim do Lar	Jd Lar
28795	SP	9775	Jardim Itajaí	Jd Itajaí
28796	SP	9775	Jardim Maria de Fátima	Jd M Fátima
28797	SP	9775	Jardim Mirante	Jd Mirante
28798	SP	9775	Jardim Olívio Moro	Jd O Moro
28799	SP	9775	Jardim Paulista	Jd Paulista
28800	SP	9775	Jardim Primavera	Jd Primavera
28801	SP	9775	Jardim Promeca	Jd Promeca
28802	SP	9775	Jardim Santa Lúcia	Jd Sta Lúcia
28803	SP	9775	Jardim São Gonçalo	Jd S Gonçalo
28804	SP	9775	Núcleo Residencial Satélite	Nuc Res Satélite
28805	SP	9775	Núcleo Residencial Sequoia	Nuc Res Sequoia
28806	SP	9775	Parque Guarani	Prq Guarani
28807	SP	9775	Pinheirinho	\N
28808	SP	9775	Portal das Azaléias	P Azaléias
28809	SP	9775	Portal das Hortências	P Hortências
28810	SP	9775	Portal das Paineiras	P Paineiras
28811	SP	9775	Residencial Aimoré	Res Aimoré
28812	SP	9775	Residencial das Flores	Res Flores
28813	SP	9775	Ponte Seca	Pte Seca
28814	SP	9775	Sítio do Morro	Sit Morro
28815	SP	9775	Sítio do Mursa	Sit Mursa
28816	SP	9775	Vale da Colina	Vle Colina
28817	SP	9775	Vila Bela Cintra	Vl B Cintra
28818	SP	9775	Vila Cristo Redentor	Vl C Redentor
28819	SP	9775	Vila Iguaçu	Vl Iguaçu
28820	SP	9775	Vila Indaia	Vl Indaia
28821	SP	9775	Vila Jeriva	Vl Jeriva
28822	SP	9775	Vila Marajó	Vl Marajó
28823	SP	9775	Jardim Paraíso	Jd Paraíso
28824	SP	9775	Vila Popular	Vl Popular
28825	SP	9775	Vila Santa Catarina	Vl Sta Catarina
28826	SP	9775	Vila Santa Terezinha	Vl Sta Terezinha
28827	SP	9775	Vila São José	Vl S José
28828	SP	9775	Vila Souza	Vl Souza
28829	SP	9775	Vila Tupi	Vl Tupi
28830	SP	9788	Barra Funda	B Funda
28832	SP	9788	Centro	\N
28833	SP	9788	Chácaras Residenciais Santa Maria	C R Sta Maria
28834	SP	9788	Chave	\N
28835	SP	9788	Colina Santa Mônica	C Sta Mônica
28837	SP	9788	Conjunto Habitacional Jardim Serrano	Cj Hab Jd Serrano
28838	SP	9788	Conjunto Habitacional Santa Maria	Cj Hab Sta Maria
28840	SP	9788	Fornazari	\N
28219	SP	9707	Jardim São Paulo	Jd S Paulo
28220	SP	9707	Jardim São Salvador	Jd S Salvador
28221	SP	9707	Jardim Saporito	Jd Saporito
28222	SP	9707	Jardim Scândia	Jd Scândia
28223	SP	9707	Jardim Sílvia	Jd Sílvia
28224	SP	9707	Jardim Sílvio Sampaio	Jd S Sampaio
28225	SP	9707	Jardim Suína	Jd Suína
28226	SP	9707	Jardim Taboão	Jd Taboão
28227	SP	9707	Jardim Três Irmãos	Jd T Irmãos
28228	SP	9707	Jardim Três Marias	Jd T Marias
28229	SP	9707	Jardim Triângulo	Jd Triângulo
28230	SP	9707	Jardim Trianon	Jd Trianon
28231	SP	9707	Jardim Virgínia	Jd Virgínia
28232	SP	9707	Jardim Wanda	Jd Wanda
28233	SP	9707	Núcleo Residencial Isabela	Nuc Res Isabela
28234	SP	9707	Parque Albina	Prq Albina
28235	SP	9707	Parque Assunção	Prq Assunção
28236	SP	9707	Parque das Cigarreiras	Prq Cigarreiras
28237	SP	9707	Parque Industrial Daci	Prq Ind Daci
28238	SP	9707	Parque Industrial das Oliveiras	Prq Ind Oliveiras
28239	SP	9707	Parque Industrial Taboão da Serra	Prq Ind T Serra
28240	SP	9707	Parque Jacarandá	Prq Jacarandá
28241	SP	9707	Parque Laguna	Prq Laguna
28242	SP	9707	Parque Marabá	Prq Marabá
28243	SP	9707	Parque Monte Alegre	Prq Mte Alegre
28244	SP	9707	Parque Pinheiros	Prq Pinheiros
28245	SP	9707	Parque Residencial Mônica	Prq Res Mônica
28246	SP	9707	Parque Santos Dumont	Prq Stos Dumont
28247	SP	9707	Parque São Joaquim	Prq S Joaquim
28248	SP	9707	Parque Taboão	Prq Taboão
28249	SP	9707	Sítio das Madres	Sit Madres
28251	SP	9707	Vila Carmelina Gonçalves	Vl C Gonçalves
28252	SP	9707	Vila das Oliveiras	Vl Oliveiras
28253	SP	9707	Vila Francisco Remeikis	Vl F Remeikis
28254	SP	9707	Vila Iasi	Vl Iasi
28255	SP	9707	Vila Indiana	Vl Indiana
28256	SP	9707	Vila Mafalda	Vl Mafalda
28257	SP	9707	Vila Santa Luzia	Vl Sta Luzia
28258	SP	9707	Vila Sônia do Taboão	Vl S Taboão
28262	SP	9725	Jardim Santa Cruz	Jd Sta Cruz
28263	SP	9725	Cecap	\N
28264	SP	9725	Centro	\N
28265	SP	9725	Chácara Flora	Ch Flora
28267	SP	9725	Chácara Junqueira	Ch Junqueira
28269	SP	9725	Colina Verde	C Verde
28270	SP	9725	Conjunto Habitacional Amaro Padilha	Cj Hab A Padilha
28271	SP	9725	Conjunto Habitacional Orlando Lisboa de Almeida	Cj Hab O L Almeida
28272	SP	9725	Enxovia	\N
28328	SP	9725	Vila Americana	Vl Americana
28329	SP	9725	Vila Angélica	Vl Angélica
28330	SP	9725	Vila Bandeirantes	Vl Bandeirantes
28331	SP	9725	Vila Brasil	Vl Brasil
28334	SP	9725	Vila Doutor Laurindo	Vl Dr Laurindo
28335	SP	9725	Vila Esperança	Vl Esperança
28336	SP	9725	Vila Ezequiel	Vl Ezequiel
28338	SP	9725	Vila Juca Menezes	Vl J Menezes
28339	SP	9725	Vila Jurema	Vl Jurema
28340	SP	9725	Vila Paulina	Vl Paulina
28342	SP	9725	Vila Santa Adelia	Vl Sta Adelia
28343	SP	9725	Vila Santa Emília	Vl Sta Emília
28344	SP	9725	Vila Santa Helena	Vl Sta Helena
28345	SP	9725	Vila Santa Luzia	Vl Sta Luzia
28346	SP	9725	Vila São Cristóvão	Vl S Cristóvão
28347	SP	9725	Vila São Lázaro	Vl S Lázaro
28348	SP	9725	Vila São Manoel	Vl S Manoel
28349	SP	9725	Vila São Paulo	Vl S Paulo
28355	SP	9726	Alto São Pedro	At S Pedro
28357	SP	9726	Bel Recanto	B Recanto
28359	SP	9726	Bosque da Saúde	Bsq Saúde
28360	SP	9726	Campos Elíseos	C Elíseos
28362	SP	9726	Cecap	\N
28364	SP	9726	Centro	\N
28366	SP	9726	Chácara do Visconde	Ch Visconde
28368	SP	9726	Piracangaguá (Chácara Flórida)	Piracangaguá (Ch Flórida)
28374	SP	9726	Chácara São Félix	Ch S Félix
28375	SP	9726	Chácara São Silvestre	Ch S Silvestre
28377	SP	9726	Chácaras Cataguá	C Cataguá
28380	SP	9726	Cidade Jardim	C Jardim
28392	SP	9726	Esplanada Independência	Esp Independência
28393	SP	9726	Esplanada Santa Terezinha	Esp Sta Terezinha
28394	SP	9726	Estiva	\N
28398	SP	9726	Granjas Rurais Reunidas São Judas Tadeu	G R R S J Tadeu
28403	SP	9726	Jardim Ana Rosa	Jd A Rosa
28404	SP	9726	Jardim Baronesa	Jd Baronesa
28406	SP	9726	Jardim Bela Vista	Jd B Vista
28411	SP	9726	Jardim da Luz	Jd Luz
28412	SP	9726	Jardim das Bandeiras	Jd Bandeiras
28414	SP	9726	Jardim das Monções	Jd Monções
28415	SP	9726	Jardim das Nações	Jd Nações
28419	SP	9726	Jardim Eulália	Jd Eulália
28422	SP	9726	Jardim Gurilândia	Jd Gurilândia
28426	SP	9726	Jardim Independência	Jd Independência
28428	SP	9726	Jardim Jaraguá	Jd Jaraguá
28429	SP	9726	Jardim Julieta	Jd Julieta
28431	SP	9726	Jardim Maria Augusta	Jd M Augusta
28433	SP	9726	Itapecirica	\N
28440	SP	9726	Jardim Sandra Maria	Jd S Maria
28442	SP	9726	Jardim Santa Clara	Jd Sta Clara
28562	SP	9748	Jardim Itaipu	Jd Itaipu
28563	SP	9748	Jardim Unesp	Jd Unesp
28564	SP	9748	Jardim Jaçanã	Jd Jaçanã
28565	SP	9748	Jardim Marabá	Jd Marabá
28566	SP	9748	Jardim Nossa Senhora de Fátima	Jd N Sra Fátima
28567	SP	9748	Jardim Paulista	Jd Paulista
28568	SP	9748	Jardim Rubiácea	Jd Rubiácea
28569	SP	9748	Jardim Santa Adélia	Jd Sta Adélia
28570	SP	9748	Jardim Santa Maria	Jd Sta Maria
28571	SP	9748	Jardim Santo Antônio	Jd Sto Antônio
28574	SP	9748	Núcleo Habitacional Augusto Rosin	Nuc Hab A Rosin
28575	SP	9748	Parque Aliança	Prq Aliança
28576	SP	9748	Parque Bela Vista	Prq B Vista
28577	SP	9748	Parque das Nações	Prq Nações
28578	SP	9748	Parque Dom Bosco	Prq D Bosco
28579	SP	9748	Parque Guaianazes	Prq Guaianazes
28580	SP	9748	Parque Ibirapuera	Prq Ibirapuera
28581	SP	9748	Parque Industrial	Prq Industrial
28582	SP	9748	Parque Industrial II	Prq Industrial II
28583	SP	9748	Parque Ipanema	Prq Ipanema
28584	SP	9748	Parque Ipiranga	Prq Ipiranga
28585	SP	9748	Parque Irajá	Prq Irajá
28586	SP	9748	Parque Maria Cristina	Prq M Cristina
28587	SP	9748	Parque Presidente Kenedy	Prq Pres Kenedy
28589	SP	9748	Parque São Pedro	Prq S Pedro
28590	SP	9748	Parque Tabajaras	Prq Tabajaras
28591	SP	9748	Parque Universitário	Prq Universitário
28592	SP	9748	Vila Abarca	Vl Abarca
28594	SP	9748	Vila Alvorada	Vl Alvorada
28598	SP	9748	Vila Aviação	Vl Aviação
28600	SP	9748	Vila Barcelona	Vl Barcelona
28602	SP	9748	Vila Brasília	Vl Brasília
28603	SP	9748	Vila das Indústrias	Vl Indústrias
28605	SP	9748	Vila Espanha	Vl Espanha
28606	SP	9748	Vila Europa	Vl Europa
28607	SP	9748	Vila Faut	Vl Faut
28608	SP	9748	Vila Formosa	Vl Formosa
28609	SP	9748	Vila Frias	Vl Frias
28610	SP	9748	Vila Giovanetti	Vl Giovanetti
28611	SP	9748	Vila Independência	Vl Independência
28612	SP	9748	Vila Inglesa	Vl Inglesa
28614	SP	9748	Vila Lahoz	Vl Lahoz
28615	SP	9748	Vila Liberdade	Vl Liberdade
28616	SP	9748	Vila Marajoara	Vl Marajoara
28618	SP	9748	Vila Munhoz	Vl Munhoz
28619	SP	9748	Vila Naibra	Vl Naibra
28620	SP	9748	Vila Nova I	Vl Nova I
28621	SP	9748	Vila Nova II	Vl Nova II
28622	SP	9748	Vila Paraíso	Vl Paraíso
28624	SP	9748	Vila Romana	Vl Romana
28678	SP	9768	Jardim Maracanã	Jd Maracanã
28679	SP	9768	Jardim Maria Rosa	Jd M Rosa
28680	SP	9768	Jardim Monte Verde	Jd Mte Verde
28681	SP	9768	Parque Nova Suíça	Prq N Suíça
28682	SP	9768	Jardim Novo Horizonte	Jd N Horizonte
28683	SP	9768	Jardim Novo Mundo	Jd N Mundo
28684	SP	9768	Jardim Paiquerê	Jd Paiquerê
28685	SP	9768	Jardim Panorama	Jd Panorama
28686	SP	9768	Jardim Paulista	Jd Paulista
28687	SP	9768	Jardim Pinheiros	Jd Pinheiros
28688	SP	9768	Jardim Planalto	Jd Planalto
28689	SP	9768	Jardim Portugal	Jd Portugal
28690	SP	9768	Jardim Primavera	Jd Primavera
28691	SP	9768	Jardim Recanto	Jd Recanto
28692	SP	9768	Jardim Ribeiro	Jd Ribeiro
28693	SP	9768	Jardim Santa Rosa	Jd Sta Rosa
28694	SP	9768	Jardim Santana	Jd Santana
28695	SP	9768	Jardim Santo Antônio	Jd Sto Antônio
28696	SP	9768	Jardim São Felipe	Jd S Felipe
28697	SP	9768	Jardim São Francisco	Jd S Francisco
28698	SP	9768	Jardim São Jorge	Jd S Jorge
28699	SP	9768	Jardim São Luiz	Jd S Luiz
28700	SP	9768	Jardim São Paulo	Jd S Paulo
28701	SP	9768	Jardim São Pedro	Jd S Pedro
28702	SP	9768	Jardim Soleil	Jd Soleil
28703	SP	9768	Jardim União	Jd União
28704	SP	9768	Jardim Valença	Jd Valença
28705	SP	9768	Jardim Vila Rosa	Jd Vl Rosa
28706	SP	9768	Joapiranga	\N
28707	SP	9768	Lenheiro	\N
28708	SP	9768	Macuco	\N
28710	SP	9768	Ortizes	\N
28711	SP	9768	Parque Cecap	Prq Cecap
28712	SP	9768	Parque das Colinas	Prq Colinas
28713	SP	9768	Parque Florence	Prq Florence
28714	SP	9768	Parque Lausanne	Prq Lausanne
28715	SP	9768	Parque Residencial Colina do Sol	Prq Res C Sol
28716	SP	9768	Parque Residencial Maison Blanche	Prq Res M Blanche
28717	SP	9768	Parque Residencial Planalto Paulista	Prq Res P Paulista
28718	SP	9768	Parque Santana	Prq Santana
28719	SP	9768	Parque Terranova	Prq Terranova
28720	SP	9768	Parque Valinhos	Prq Valinhos
28721	SP	9768	Pinheiro	\N
28722	SP	9768	Ponte Alta	Pte Alta
28723	SP	9768	Residencial São Luiz	Res S Luiz
28724	SP	9768	Samambaia	\N
28725	SP	9768	Santa Cruz	Sta Cruz
28726	SP	9768	Santa Marina	Sta Marina
28727	SP	9768	Sítio Recreio dos Cafezais	Sit Rcr Cafezais
28728	SP	9768	Vale do Itamaracá	Vle Itamaracá
28729	SP	9768	Vale Verde	Vle Verde
28730	SP	9768	Vila Angeli	Vl Angeli
28841	SP	9788	Green Valley	G Valley
28842	SP	9788	Itapeva	\N
28843	SP	9788	Jardim Ana Claudia	Jd A Claudia
28844	SP	9788	Jardim Antônio Cassillo	Jd A Cassillo
28845	SP	9788	Jardim Antônio Rodrigues e Rodrigues	Jd A R E Rodrigues
28846	SP	9788	Jardim Araújo	Jd Araújo
28847	SP	9788	Jardim Archila	Jd Archila
28848	SP	9788	Jardim Bertioga	Jd Bertioga
28849	SP	9788	Jardim Clarice I	Jd Clarice I
28851	SP	9788	Jardim Daniel Antônio	Jd D Antônio
28852	SP	9788	Jardim das Colinas	Jd Colinas
28853	SP	9788	Jardim Devito	Jd Devito
28854	SP	9788	Jardim Bandeirantes	Jd Bandeirantes
28855	SP	9788	Jardim Europa	Jd Europa
28856	SP	9788	Jardim Icatu	Jd Icatu
28859	SP	9788	Jardim Karolyne	Jd Karolyne
28861	SP	9788	Jardim Maria Lúcia	Jd M Lúcia
28862	SP	9788	Jardim Mirante dos Ovnis	Jd M Ovnis
28863	SP	9788	Jardim Monte Sião	Jd Mte Sião
28864	SP	9788	Jardim Novo Mundo	Jd N Mundo
28865	SP	9788	Jardim Palmira	Jd Palmira
28866	SP	9788	Jardim Paraíso	Jd Paraíso
28867	SP	9788	Jardim Paulista	Jd Paulista
28870	SP	9788	Jardim Santo Antônio II	Jd Sto Antônio II
28871	SP	9788	Jardim São Lucas	Jd S Lucas
28872	SP	9788	Jardim São Luís	Jd S Luís
28873	SP	9788	Jardim São Matheus	Jd S Matheus
28874	SP	9788	Jardim São Pedro	Jd S Pedro
28875	SP	9788	Jardim Serrano	Jd Serrano
28877	SP	9788	Jardim Simone	Jd Simone
28878	SP	9788	Jardim Tatiana	Jd Tatiana
28879	SP	9788	Jardim Toledo	Jd Toledo
28880	SP	9788	Jardim União	Jd União
28883	SP	9788	Nova Votorantim	N Votorantim
28884	SP	9788	Parque Bela Vista	Prq B Vista
28885	SP	9788	Parque Jataí	Prq Jataí
28887	SP	9788	Parque Morumbi	Prq Morumbi
28888	SP	9788	Parque Santa Márcia	Prq Sta Márcia
28889	SP	9788	Parque Santos Dumont	Prq Stos Dumont
28890	SP	9788	Pro-Morar	\N
28891	SP	9788	Protestantes	\N
28892	SP	9788	Rio Acima	R Acima
28893	SP	9788	Vila Helena	Vl Helena
28894	SP	9788	Vale do Sol	Vle Sol
28896	SP	9788	Vila Aldo Damini	Vl A Damini
28897	SP	9788	Vila Amorim	Vl Amorim
28898	SP	9788	Vila Angelo Vial	Vl A Vial
28900	SP	9788	Vila Dylze	Vl Dylze
28901	SP	9788	Vila Domingues	Vl Domingues
28902	SP	9788	Vila Dominguinho	Vl Dominguinho
28904	SP	9788	Vila Gali	Vl Gali
28906	SP	9788	Vila Guilherme	Vl Guilherme
28973	SP	9789	Parque Residencial Santa Amélia	Prq Res Sta Amélia
28974	SP	9789	Parque Rio Vermelho	Prq R Vermelho
28975	SP	9789	Parque Roselândia	Prq Roselândia
28976	SP	9789	Parque Santa Felícia	Prq Sta Felícia
28977	SP	9789	Patrimônio Novo	P Novo
28978	SP	9789	Patrimônio Velho	P Velho
28979	SP	9789	Pólo Comercial e Industrial de Votuporanga	P C E Ind Votuporanga
28980	SP	9789	Pozzobon	\N
28981	SP	9789	Propovo	\N
28982	SP	9789	Recanto dos Esportes	Rec Esportes
28983	SP	9789	San Remo	S Remo
28984	SP	9789	Santa Eliza	Sta Eliza
28985	SP	9789	Santa Luzia	Sta Luzia
28986	SP	9789	São Cosme	S Cosme
28987	SP	9789	São Damião	S Damião
28988	SP	9789	São João	S João
28989	SP	9789	Vale do Sol	Vle Sol
28990	SP	9789	Vila América	Vl América
28991	SP	9789	Vila Budin	Vl Budin
28992	SP	9789	Vila Formosa	Vl Formosa
28994	SP	9789	Vila Hercília	Vl Hercília
28995	SP	9789	Vila Marim	Vl Marim
28996	SP	9789	Vila Muniz	Vl Muniz
28997	SP	9789	Vila Paes	Vl Paes
28998	SP	9789	Vila São Vicente	Vl S Vicente
29207	SP	9082	Residencial Recanto Verde	Res Rec Verde
29208	SP	9668	Jardim Bárbara	Jd Bárbara
29209	SP	9082	Santana	\N
29210	SP	9183	Jardim Santa Lídia	Jd Sta Lídia
29211	SP	9082	Chácara Nossa Senhora de Fátima Taboleiro Verde	Ch N Sra F T Verde
29212	SP	9082	Colina (Caucaia do Alto)	Colina (C Alto)
29213	SP	9082	Jardim Honória	Jd Honória
29216	SP	9094	Núcleo Habitacional Caviúna	Nuc Hab Caviúna
29217	SP	9625	Conjunto Habitacional Avenida dos Estados	Cj Hab Av Estados
29223	SP	9355	Vila Real	Vl Real
29224	SP	9355	Jardim Éden	Jd Éden
29225	SP	9355	Jardim Elizabeth	Jd Elizabeth
29226	SP	9355	Chácara Maria Aparecida	Ch M Aparecida
29227	SP	9355	Chácara Maria Francisca	Ch M Francisca
29228	SP	9355	Sítio Bela Vista	Sit B Vista
29229	SP	9355	Jardim Cerqueira Leite	Jd C Leite
29230	SP	9355	Loteamento Industrial Coral	Lot Ind Coral
29231	SP	9355	Jardim Flórida	Jd Flórida
29232	SP	9355	Jardim Oratório	Jd Oratório
29234	SP	9355	Sítio Taquarassu	Sit Taquarassu
29235	SP	9355	Vila Ana	Vl Ana
29236	SP	9355	Jardim São Jorge	Jd S Jorge
29237	SP	9355	Vila São José	Vl S José
29238	SP	9355	Jardim Hélida	Jd Hélida
29239	SP	9355	Chácara São Lucido	Ch S Lucido
29240	SP	9355	Fazenda Oratório	Faz Oratório
29241	SP	9094	Núcleo Habitacional Vila Olinda	Nuc Hab Vl Olinda
29242	SP	9094	Vila Gazuza	Vl Gazuza
29243	SP	9094	Jardim das Pirâmides	Jd Pirâmides
29244	SP	9640	Jardim Novo Horizonte I	Jd N Horizonte I
29245	SP	9640	Jardim Novo Horizonte II	Jd N Horizonte II
29246	SP	9640	Jardim Anchieta	Jd Anchieta
29247	SP	9640	Jardim Senhor do Bonfim	Jd Sr Bonfim
29248	SP	9640	Jardim Industrial	Jd Industrial
29249	SP	9640	Jardim Nova Canaã	Jd N Canaã
29250	SP	9640	Jardim Ipanema	Jd Ipanema
29251	SP	9640	Jardim João de Barro	Jd J Barro
29252	SP	9640	Jardim Sabatini	Jd Sabatini
29253	SP	9640	Jardim América do Sul	Jd A Sul
29255	SP	9640	Jardim Vida Nova	Jd V Nova
29256	SP	9640	Jardim Marco Polo	Jd M Polo
29257	SP	9640	Jardim Nosso Lar	Jd N Lar
29258	SP	9640	Jardim Castelo Branco	Jd C Branco
29259	SP	9640	Jardim Nova Patente	Jd N Patente
29260	SP	9640	Jardim Vale do Sol	Jd Vle Sol
29261	SP	9640	Recanto dos Pássaros	Rec Pássaros
28907	SP	9788	Vila Irineu	Vl Irineu
28908	SP	9788	Vila José Ramos	Vl J Ramos
28910	SP	9788	Vila Mercedes	Vl Mercedes
28913	SP	9788	Vila Pardini	Vl Pardini
28914	SP	9788	Vila Pedroso	Vl Pedroso
28916	SP	9788	Vila Rodrigues	Vl Rodrigues
28917	SP	9788	Vila Santo Antônio	Vl Sto Antônio
28918	SP	9788	Jardim Maria José	Jd M José
28920	SP	9788	Vila Vasques	Vl Vasques
28921	SP	9788	Vila Votocel	Vl Votocel
28922	SP	9788	Vossoroca	\N
28925	SP	9789	Cecap I	\N
28926	SP	9789	Cecap II	\N
28928	SP	9789	Chácara Aviação	Ch Aviação
28929	SP	9789	Chácara das Paineiras	Ch Paineiras
28932	SP	9789	Chácara Vera	Ch Vera
28933	SP	9789	Chris II	\N
28934	SP	9789	COHAB	\N
28936	SP	9789	Estação	\N
28937	SP	9789	Estela Parque Residencial	E Prq Residencial
28938	SP	9789	Jardim Alvorada	Jd Alvorada
28939	SP	9789	Jardim Bela Vista	Jd B Vista
28940	SP	9789	Jardim Bom Clima	Jd B Clima
28941	SP	9789	Jardim Botura	Jd Botura
28942	SP	9789	Jardim das Palmeiras I	Jd Palmeiras I
28943	SP	9789	Jardim das Palmeiras II	Jd Palmeiras II
28944	SP	9789	Jardim Eldorado	Jd Eldorado
28945	SP	9789	Jardim Marim	Jd Marim
28947	SP	9789	Jardim Planalto	Jd Planalto
28948	SP	9789	Jardim Primavera	Jd Primavera
28949	SP	9789	Jardim Progresso	Jd Progresso
28950	SP	9789	Jardim Santo Antônio	Jd Sto Antônio
28951	SP	9789	Jardim Santos Dumont	Jd Stos Dumont
28952	SP	9789	Jardim São Judas Tadeu	Jd S J Tadeu
28954	SP	9789	Jardim Umuarama	Jd Umuarama
28955	SP	9789	Jardim Yolanda	Jd Yolanda
28957	SP	9789	Loteamento Bandeirantes	Lot Bandeirantes
28958	SP	9789	Loteamento José Marin Cruz	Lot J M Cruz
28959	SP	9789	Loteamento Nova Boa Vista	Lot N B Vista
28960	SP	9789	Loteamento Residencial Jardim Santa Paula	Lot Res Jd Sta Paula
28961	SP	9789	Marão	\N
28962	SP	9789	Parque Brasília	Prq Brasília
28963	SP	9789	Parque das Brisas	Prq Brisas
28964	SP	9789	Parque das Nações	Prq Nações
28966	SP	9789	Parque Guarani	Prq Guarani
28967	SP	9789	Parque Industrial I	Prq Industrial I
28968	SP	9789	Parque Industrial II	Prq Industrial II
28969	SP	9789	Parque Oito de Agosto	Prq O Agosto
28970	SP	9789	Parque Residencial do Lago	Prq Res Lago
28971	SP	9789	Parque Residencial Friozi	Prq Res Friozi
29149	SP	9082	Jardim das Flores	Jd Flores
29150	SP	9082	São Paulo II	S Paulo II
29151	SP	9082	Parque Rizzo	Prq Rizzo
29157	SP	9082	Jardim Maranhão	Jd Maranhão
29158	SP	9082	Chácara Represinha	Ch Represinha
29160	SP	9082	Chácara Recanto Verde	Ch Rec Verde
29161	SP	9082	Jardim Nova Pacaembu	Jd N Pacaembu
29162	SP	9082	Residencial Park	Res Park
29164	SP	9082	Morada Santa Fé	M Sta Fé
29165	SP	9082	Palos Verdes	P Verdes
29166	SP	9082	Jardim Museu	Jd Museu
29167	SP	9082	Chácara das Rosas	Ch Rosas
29168	SP	9082	Granja Caiapiá	Gja Caiapiá
29169	SP	9082	Algarve	\N
29170	SP	9082	Chácara Progresso	Ch Progresso
29173	SP	9082	Petit Village	P Village
29174	SP	9082	Jardim Mediterrâneo	Jd Mediterrâneo
29175	SP	9082	Parque Frondoso	Prq Frondoso
29176	SP	9082	Jardim Glória	Jd Glória
29179	SP	9082	Pununduva	\N
29180	SP	9082	Chácara Ondas Verdes	Ch O Verdes
29181	SP	9082	Chácara São José	Ch S José
29183	SP	9082	Parque Realeza	Prq Realeza
29184	SP	9082	Parque São Paulo	Prq S Paulo
29185	SP	9082	Vila São Francisco de Assis	Vl S F Assis
29186	SP	8956	Residencial Mel Ville	Res M Ville
29191	SP	9082	Vila Santo Antônio do Portão	Vl Sto A Portão
29192	SP	9082	Chácara Granja Velha	Ch Gja Velha
29193	SP	9082	Jardim Gramado II	Jd Gramado II
29195	SP	9113	Desembargador Aroaldo Azevedo	Des A Azevedo
29196	SP	9239	Chácara Balbina	Ch Balbina
29197	SP	9239	Jardim Nogueira	Jd Nogueira
29198	SP	9239	Morro da Mandioca	Mro Mandioca
29199	SP	9239	Parque Santo Antônio	Prq Sto Antônio
29200	SP	9239	Jardim Horacina	Jd Horacina
29201	SP	9239	Jardim do Carmo II	Jd Carmo II
29202	SP	9183	Orquidiama Parque Ribeirão	O Prq Ribeirão
29203	SP	9183	Aguazul	\N
29204	SP	9183	Chácara das Lavras	Ch Lavras
29205	SP	9183	Parque Residencial Bambi	Prq Res Bambi
29206	SP	9369	Socorro	\N
29262	SP	9640	Jardim Pinheiros	Jd Pinheiros
29263	SP	9640	Parque São Rafael	Prq S Rafael
29264	SP	9640	Jardim Cantareira	Jd Cantareira
29265	SP	9640	Recanto da Amizade	Rec Amizade
29266	SP	9640	Parque das Garças	Prq Garças
29267	SP	9640	Vila Vitória	Vl Vitória
29268	SP	9640	Jardim Tiradentes	Jd Tiradentes
29269	SP	9640	Jardim Monte Sião	Jd Mte Sião
29270	SP	9640	Jardim São Jorge	Jd S Jorge
29271	SP	9640	Parque dos Bandeirantes	Prq Bandeirantes
29272	SP	9640	Jardim São José	Jd S José
29273	SP	9640	Jardim Nova América	Jd N América
29274	SP	9640	Parque Ideal	Prq Ideal
29275	SP	9640	Parque dos Químicos	Prq Químicos
29276	SP	9640	Jardim São Judas Tadeu	Jd S J Tadeu
29277	SP	9640	Jardim Uiriçaba	Jd Uiriçaba
29278	SP	9640	Jardim Ana Faletti	Jd A Faletti
29279	SP	9640	Jardim dos Químicos	Jd Químicos
29280	SP	9640	Parque das Flores	Prq Flores
29281	SP	9640	Chácara Royal Park	Ch R Park
29282	SP	9640	Jardim União e Força	Jd U E Força
29283	SP	9640	Jardim Nosso Teto	Jd N Teto
29284	SP	9640	Parque Veneza	Prq Veneza
29285	SP	9640	Jardim Fei Mizuho	Jd F Mizuho
29286	SP	9355	Centro	\N
29288	SP	9668	Jardim Jaú (Zona Sul)	Jd Jaú (Z Sul)
29289	SP	9369	Chácara Jafet	Ch Jafet
29310	SP	9355	Jardim Camargo	Jd Camargo
29311	SP	9625	Jardim Cipreste	Jd Cipreste
29314	SP	9094	Núcleo Habitacional União	Nuc Hab União
29318	SP	9250	Jardim Rio Negro	Jd R Negro
29370	SP	9082	Nova Vida	N Vida
29376	SP	9082	Portal Roselândia	P Roselândia
29377	SP	9082	Parque Green Village	Prq G Village
29378	SP	9082	San Fernando Park	S F Park
29380	SP	9082	Sítio Mandu	Sit Mandu
29386	SP	9625	Montanhão	\N
29400	SP	9668	Sé	\N
29401	SP	9668	Aclimação	\N
29404	SP	9668	Vila Rosa	Vl Rosa
29406	SP	9668	Vila Luzimar	Vl Luzimar
29407	SP	9183	Parque Santo Agostinho	Prq Sto Agostinho
29408	SP	9703	Jardim do Bosque	Jd Bosque
29409	SP	9668	Vila Iolanda II	Vl Iolanda II
29410	SP	9044	Jardim Angélica	Jd Angélica
29492	SP	9622	Centro	\N
29493	SP	9369	Vila Rei	Vl Rei
29494	SP	9622	Aldeia da Serra	A Serra
29495	SP	9622	Alpes de Parnaíba	A Parnaíba
29496	SP	9622	Jardim Anhembi	Jd Anhembi
29497	SP	9622	Jardim Isaura	Jd Isaura
29498	SP	9622	Recanto Sombra do Ipê	Rec S Ipê
29499	SP	9622	Germano	\N
29500	SP	9622	Sítio do Rosário	Sit Rosário
29501	SP	9622	Parque Mirante de Parnaíba	Prq M Parnaíba
29502	SP	9622	Parque Santana	Prq Santana
29503	SP	9622	Jardim Rancho Alegre	Jd R Alegre
29504	SP	9622	Tarumã	\N
29505	SP	9622	Chácaras Clarice	C Clarice
29506	SP	9622	Chácaras Maria Inês	C M Inês
29507	SP	9622	Engenho Novo	E Novo
29508	SP	9622	Vila Industrial	Vl Industrial
29509	SP	9622	Sítio do Morro	Sit Morro
29510	SP	9622	Parque Alvorada	Prq Alvorada
29511	SP	9622	Parque Paraíso	Prq Paraíso
29512	SP	9622	Quintas do Ingaí	Qtas Ingaí
29513	SP	9622	Quintas de Maria Elvira	Qtas M Elvira
29514	SP	9622	Morada dos Pinheiros (Aldeia da Serra)	M Pinheiros (A Serra)
29515	SP	9622	Morada das Flores (Aldeia da Serra)	M Flores (A Serra)
29516	SP	9622	Chácaras Boa Vista	C B Vista
29517	SP	9622	Portal da Serra	P Serra
29518	SP	9622	Terras de San Nicolau	T S Nicolau
29519	SP	9622	Recanto Maravilha III	Rec Maravilha III
29520	SP	9622	Portal das Acácias	P Acácias
29521	SP	9622	Morada do Sol	M Sol
29522	SP	9622	Cururuquara	\N
29523	SP	9622	Residencial Santa Helena - Gleba I	Res Sta Helena - Gleba I
29524	SP	9622	Residencial Santa Helena - Gleba II	Res Sta Helena - Gleba II
29525	SP	9622	Vila Poupança	Vl Poupança
29526	SP	9622	Jardim Itapuã	Jd Itapuã
29527	SP	9622	Chácara das Garças	Ch Garças
29528	SP	9622	Chácara do Solar III	Ch Solar III
29529	SP	9622	Jardim Espacial	Jd Espacial
29530	SP	9622	Jardim Rachel	Jd Rachel
29531	SP	9622	Jardim Alagoas	Jd Alagoas
29532	SP	9622	Vila Maria Nazaré	Vl M Nazaré
29533	SP	9622	Jardim Amazonas	Jd Amazonas
29534	SP	9622	Várzea do Souza	V Souza
29535	SP	9622	Jardim do Luar (Fazendinha)	Jd Luar (Fazendinha)
29536	SP	9622	Jardim Luíza (Fazendinha)	Jd Luíza (Fazendinha)
29595	SP	9622	Cristal Park	C Park
29596	SP	9622	Refúgio dos Bandeirantes	R Bandeirantes
29597	SP	9622	Voturuna	\N
29598	SP	9622	Condomínio Voturuna	Cond Voturuna
29599	SP	9622	Rancho Tucsons	R Tucsons
29856	SP	9622	Suru	\N
29857	SP	9622	Sítio do Moinho	Sit Moinho
29922	SP	9668	Alto da Boa Vista	At B Vista
29939	SP	9659	Parque Juriti	Prq Juriti
29940	SP	9659	Residencial Alto das Andorinhas	Res At Andorinhas
29941	SP	9659	Residencial Monte Verde	Res Mte Verde
29942	SP	9527	Jardim Marília	Jd Marília
29943	SP	9527	Jardim Aprazível	Jd Aprazível
29946	SP	9659	Vila Borguese	Vl Borguese
30019	SP	9183	Parque Primavera	Prq Primavera
30020	SP	9183	Residencial Cerconi	Res Cerconi
30021	SP	9183	Mikail II	\N
30022	SP	9183	Jardim Beirute	Jd Beirute
30023	SP	9183	Jardim Odete	Jd Odete
30024	SP	9183	Parque das Laranjeiras	Prq Laranjeiras
30025	SP	9775	Jardim Gauchinha	Jd Gauchinha
30028	SP	9775	Jardim São Paulo	Jd S Paulo
30060	SP	9183	Vila União	Vl União
30062	SP	9183	Parque Industrial do Jardim São Geraldo	Prq Ind Jd S Geraldo
29319	SP	9707	Conjunto Residencial Belo Horizonte	Cj Res B Horizonte
29324	SP	9703	Chácara Sete Cruzes	Ch S Cruzes
29341	SP	9082	San Diego Park	S D Park
29343	SP	9082	Colinas de São Fernando	C S Fernando
29345	SP	9082	Colonial Village (Caucaia do Alto)	C Village (C Alto)
29346	SP	9082	Jardim Monte Verde (Caucaia do Alto)	Jd Mte Verde (C Alto)
29347	SP	9082	Vila de São Fernando	Vl S Fernando
29348	SP	9082	Paisagem Casa Grande	P C Grande
29349	SP	9082	Pinheiros Tênis Village	P T Village
29351	SP	9082	Chácara Recanto	Ch Recanto
29353	SP	9082	Parque Silvino Pereira	Prq S Pereira
29355	SP	9082	Avelino Pires de Oliveira	A P Oliveira
29356	SP	9082	Chácaras dos Lagos	C Lagos
29357	SP	9082	Chácara Eliana	Ch Eliana
29358	SP	9082	Condominio Granja Colonial	C Gja Colonial
29359	SP	9082	Condominio das Graças	C Graças
29360	SP	9082	Chácara Nossa Senhora de Fátima	Ch N Sra Fátima
29363	SP	9082	Jardim Paineira	Jd Paineira
29364	SP	9082	Jardim Ipês	Jd Ipês
29456	SP	9183	Vila Cocaia	Vl Cocaia
29468	SP	9088	Vale Verde	Vle Verde
29483	SP	9703	Estância dos Pinheirais	Etn Pinheirais
29486	SP	9668	Jardim Sabiá II	Jd Sabiá II
29537	SP	9622	Jardim Santa Marta (Fazendinha)	Jd Sta Marta (Fazendinha)
29538	SP	9622	Jardim Represa (Fazendinha)	Jd Represa (Fazendinha)
29539	SP	9622	Jardim Leda (Fazendinha)	Jd Leda (Fazendinha)
29540	SP	9622	Jardim Nina (Fazendinha)	Jd Nina (Fazendinha)
29541	SP	9622	Chácara do Solar I (Fazendinha)	Ch Solar I (Fazendinha)
29542	SP	9622	Parque dos Eucaliptos (Fazendinha)	Prq Eucaliptos (Fazendinha)
29543	SP	9622	Jardim Sabrina (Fazendinha)	Jd Sabrina (Fazendinha)
29544	SP	9622	Recanto Silvestre (Fazendinha)	Rec Silvestre (Fazendinha)
29545	SP	9622	Jardim das Avencas (Fazendinha)	Jd Avencas (Fazendinha)
29546	SP	9622	Chácara do Solar II (Fazendinha)	Ch Solar II (Fazendinha)
29547	SP	9622	Tanquinho	\N
29548	SP	9622	Vila Velha	Vl Velha
29550	SP	9622	Jardim Paula	Jd Paula
29551	SP	9622	Parque Sinai	Prq Sinai
29552	SP	9622	Chácara Jaguari (Fazendinha)	Ch Jaguari (Fazendinha)
29553	SP	9622	Parque Panorama II (Fazendinha)	Prq Panorama II (Fazendinha)
29554	SP	9622	Jardim Jurupari (Fazendinha)	Jd Jurupari (Fazendinha)
29555	SP	9622	Parque Jaguari (Fazendinha)	Prq Jaguari (Fazendinha)
29556	SP	9622	Bosque do Sol (Fazendinha)	Bsq Sol (Fazendinha)
29557	SP	9622	Parque Panorama I (Fazendinha)	Prq Panorama I (Fazendinha)
29558	SP	9622	Cidade São Pedro - Gleba A	C S Pedro - Gleba A
29559	SP	9622	Cidade São Pedro - Gleba B	C S Pedro - Gleba B
30674	SP	9703	Jardim dos Ipês	Jd Ipês
29560	SP	9622	Cidade São Pedro - Gleba C	C S Pedro - Gleba C
29561	SP	9622	Colinas da Anhangüera	C Anhangüera
29579	SP	9622	Tamboré	\N
29580	SP	9622	Jardim Parnaíba	Jd Parnaíba
29581	SP	9622	Campo da Vila	Cpo Vila
29582	SP	9622	Jardim Professor Benoá	Jd Prf Benoá
29583	SP	9622	Maria Mercedes	M Mercedes
29584	SP	9622	Jardim Frediani	Jd Frediani
29585	SP	9622	Chácara Estela	Ch Estela
29586	SP	9622	Jardim Bandeirantes	Jd Bandeirantes
29587	SP	9622	Votuparim	\N
29588	SP	9622	Sítio Recreio (Capela Velha)	Sit Recreio (C Velha)
29589	SP	9622	Jardim Deghi	Jd Deghi
29590	SP	9622	Jardim São Luís	Jd S Luís
29591	SP	9622	Parque Fernão Dias	Prq F Dias
29592	SP	9622	Itaim Mirim	I Mirim
29593	SP	9622	Parque Vila Rica	Prq Vl Rica
29594	SP	9622	Chácaras São Luís	C S Luís
29947	SP	9659	Parque Residencial Cambuí	Prq Res Cambuí
29948	SP	9659	Estância São João	Etn S João
29949	SP	9659	Recanto dos Eduardos	Rec Eduardos
29950	SP	9659	Jardim Marambáia	Jd Marambáia
29951	SP	9527	Jardim Alice	Jd Alice
29954	SP	8891	Conjunto Habitacional Antônio Ricardo Pegoraro	Cj Hab A R Pegoraro
29955	SP	8907	Concórdia II	\N
29956	SP	8907	Concórdia I	\N
29957	SP	8907	Conjunto Residencial Toyokazu Kawata	Cj Res T Kawata
29958	SP	8907	Conjunto Habitacional Ivo Tozzi	Cj Hab I Tozzi
29961	SP	8907	Residencial Vista Verde	Res V Verde
29962	SP	8907	Jardim Universo	Jd Universo
29963	SP	8907	Jardim das Oliveiras	Jd Oliveiras
29966	SP	8907	Verde Parque	V Parque
29977	SP	9668	Parque das Flores	Prq Flores
29981	SP	8907	Residencial Nobreville	Res Nobreville
30007	SP	9183	Jardim Acácio	Jd Acácio
30128	SP	9640	Alto Industrial	At Industrial
30129	SP	9640	Vila São Pedro	Vl S Pedro
30131	SP	9640	Vila Esperança	Vl Esperança
30132	SP	9659	Residencial Rio das Flores	Res R Flores
30134	SP	9668	Jardim São Gilberto	Jd S Gilberto
30138	SP	9315	Jardim Angélica	Jd Angélica
30140	SP	9183	Parque Continental I	Prq Continental I
30141	SP	9315	Jardim Renascença	Jd Renascença
30142	SP	9183	Parque Continental II	Prq Continental II
30144	SP	9183	Vila Rica	Vl Rica
30152	SP	9315	Distrito Industrial	Dt Industrial
30153	SP	9315	Jardim do Sol	Jd Sol
30155	SP	9315	Jardim Travagin	Jd Travagin
30156	SP	9315	Conjunto Habitacional Francisco Coelho	Cj Hab F Coelho
30157	SP	9315	Jardim Clube do Bosque	Jd C Bosque
30158	SP	9315	Jardim Letícia	Jd Letícia
30219	SP	9005	Chácara São Judas Tadeu	Ch S J Tadeu
30220	SP	9005	Sítio Santa Eufrosina	Sit Sta Eufrosina
30221	SP	9005	São João da Boa Vista	S J B Vista
30222	SP	9005	Condomínio Bom Jesus	Cond B Jesus
30223	SP	9005	Chácara Ipês	Ch Ipês
30224	SP	9005	Santa Mônica	Sta Mônica
30225	SP	9005	Perinho	\N
30226	SP	9005	Jardim Panorama	Jd Panorama
30228	SP	9005	Chácara Recreio Taquaral	Ch Rcr Taquaral
30233	SP	9005	Residencial Esperança	Res Esperança
30238	SP	9005	Loteamento Jomabe II	Lot Jomabe II
30239	SP	9005	Quinta Samambaia	Qta Samambaia
30240	SP	9005	Sapé I	\N
30244	SP	9355	Jardim Cruzeiro do Sul	Jd C Sul
30246	SP	8912	Parque Gramado II	Prq Gramado II
30249	SP	8912	Jardim dos Industriários	Jd Industriários
30252	SP	8912	8º Distrito Industrial	8º Dt Industrial
30253	SP	8912	Condomínio Satélite	Cond Satélite
30254	SP	9355	Sertãozinho	\N
30256	SP	9355	Contry Park	C Park
30257	SP	9355	Recanto Vital Brasil	Rec V Brasil
30259	SP	9265	Loteamento Monte Bianco	Lot Mte Bianco
30260	SP	9636	Morro do Monte Serrat	Mro Mte Serrat
30261	SP	9265	Jardim Solar do Cedro	Jd S Cedro
30263	SP	9678	Ponte Nova	Pte Nova
30267	SP	9265	Colina Verde	C Verde
30270	SP	9265	Residencial Jaboticabal	Res Jaboticabal
30271	SP	9265	Jardim Pery	Jd Pery
30272	SP	9265	Loteamento Santo Antônio	Lot Sto Antônio
30343	SP	8969	Residencial Jardim do Trevo	Res Jd Trevo
30344	SP	8969	Residencial Prado	Res Prado
30345	SP	8969	Residencial Portal da Pérola	Res P Pérola
30346	SP	8969	João Crevelaro	J Crevelaro
30347	SP	8969	Jardim Brasília	Jd Brasília
30348	SP	8969	Residencial Eurico Caetano	Res E Caetano
30349	SP	8969	Colinas Park Residencial	C P Residencial
30350	SP	8969	Colinas Park II	C Park II
30352	SP	8969	Alto Colinas	At Colinas
30353	SP	9668	Jardins	\N
30363	SP	9726	Conjunto Habitacional C.D.H.U.	Cj Hab C.D.H.U.
30368	SP	9726	UNA	\N
30390	SP	9625	Tamarutaca	\N
30391	SP	9355	Vila Nova Canaã	Vl N Canaã
30393	SP	9044	Jardim São Daniel	Jd S Daniel
30394	SP	9250	Jardim Amazonas	Jd Amazonas
30395	SP	9250	Terra Prometida	T Prometida
30397	SP	9768	Loteamento Residencial Ana Carolina	Lot Res A Carolina
30398	SP	9768	Loteamento Residencial Nova Itália	Lot Res N Itália
30399	SP	9768	Loteamento Paiquerê	Lot Paiquerê
30400	SP	9768	Loteamento Pedra Verde	Lot P Verde
30463	SP	9239	Chácara Colorado	Ch Colorado
30466	SP	9369	Conjunto Primavera	Cj Primavera
30467	SP	9239	Jardim Maribel	Jd Maribel
30473	SP	9668	Conjunto Residencial Sabará - Campo Grande	Cj Res Sabará - Cpo Grande
30474	SP	9239	Aldeinha	\N
30478	SP	9368	Conjunto Habitacional Jacintho Pisani	Cj Hab J Pisani
30483	SP	9368	Ari Estevão	A Estevão
30500	SP	9668	Palanque	\N
30501	SP	9668	Vila Independente	Vl Independente
30509	SP	9668	Jardim Filhos da Terra	Jd F Terra
30510	SP	9265	Residencial São Judas Tadeu	Res S J Tadeu
30511	SP	8912	Estrela e Kanashiro	E E Kanashiro
30514	SP	9183	Vila GPM	Vl GPM
30515	SP	9183	Vila das Malvinas	Vl Malvinas
30516	SP	9183	Jardim Santa Edwirges	Jd Sta Edwirges
30518	SP	9183	Jardim Crepúsculo	Jd Crepúsculo
30519	SP	9183	Jardim Okuyama	Jd Okuyama
30520	SP	8912	Jardim do Bosque	Jd Bosque
30521	SP	8912	Parque Igaçaba	Prq Igaçaba
30522	SP	8912	Jardim Residencial Elvio Lupo	Jd Res E Lupo
30524	SP	8912	Jardim Residencial Lupo II	Jd Res Lupo II
30159	SP	9315	Jardim Alto da Boa Vista	Jd At B Vista
30160	SP	9315	Jardim Alto da Glória	Jd At Glória
30161	SP	9315	Jardim Ana Lúcia	Jd A Lúcia
30164	SP	9315	Jardim Residencial Quáglia	Jd Res Quáglia
30165	SP	9315	Jardim Imperial	Jd Imperial
30172	SP	9183	Jardim Ponte Alta II	Jd Pte Alta II
30174	SP	9183	Jardim Castanha	Jd Castanha
30176	SP	9183	Jardim Hanna	Jd Hanna
30180	SP	9775	Jardim Continente	Jd Continente
30181	SP	9775	Residencial Alexandria	Res Alexandria
30183	SP	9183	Jardim Nova Cidade	Jd N Cidade
30205	SP	9005	Chácara Germana	Ch Germana
30206	SP	9005	Pousada Bandeirantes	P Bandeirantes
30207	SP	9183	Parque Continental III	Prq Continental III
30209	SP	9005	Chácara Marambaia	Ch Marambaia
30210	SP	9005	Chácara Itamarati	Ch Itamarati
30211	SP	9005	Chácara São Joaquim	Ch S Joaquim
30212	SP	9005	Residencial Aldeias da Serra	Res A Serra
30217	SP	9005	Portal Mantiqueira	P Mantiqueira
30323	SP	9244	Jardim Galego	Jd Galego
30325	SP	9244	Parque Progresso	Prq Progresso
30326	SP	9244	Parque Industrial Juvenal Leite	Prq Ind J Leite
30327	SP	9703	Vila Real	Vl Real
30335	SP	9726	Residencial Estoril	Res Estoril
30340	SP	9082	Granja Carneiro Viana	Gja C Viana
30341	SP	8969	Quemil	\N
30342	SP	8969	Residencial Pedro Marin Berbel	Res P M Berbel
30401	SP	9768	Loteamento Residencial Santa Gertrudes	Lot Res Sta Gertrudes
30402	SP	9768	Loteamento Nova Espírito Santo	Lot N E Santo
30403	SP	9768	Residencial Santa Maria	Res Sta Maria
30404	SP	9768	Jardim Morada do Sol	Jd M Sol
30405	SP	9768	Jardim Nova Palmares	Jd N Palmares
30406	SP	9768	Apaga Fogo	A Fogo
30407	SP	9768	Jardim São Marcos	Jd S Marcos
30408	SP	9768	Jardim Alvorada	Jd Alvorada
30409	SP	9768	Jardim Universo	Jd Universo
30410	SP	9768	Jardim Samambaia	Jd Samambaia
30411	SP	9768	Fazenda Santana	Faz Santana
30412	SP	9768	Jardim Recanto dos Pássaros II	Jd Rec Pássaros II
30414	SP	9668	Sítio Itaberaba II	Sit Itaberaba II
30415	SP	9668	Jardim Rosinha	Jd Rosinha
30416	SP	9707	Jardim Nova Esperança	Jd N Esperança
30417	SP	9668	Vila Guiomar	Vl Guiomar
30418	SP	9082	Jardim Torino	Jd Torino
30421	SP	9659	Jardim Felicidade	Jd Felicidade
30422	SP	9659	Jardim Jandira	Jd Jandira
30423	SP	9082	Jardim das Graças	Jd Graças
30424	SP	9668	Vila Jaci	Vl Jaci
30425	SP	9668	Jardim Pérola II	Jd Pérola II
30426	SP	9668	Vila Roseira II	Vl Roseira II
30427	SP	9668	Jardim Pedra Branca II	Jd P Branca II
30428	SP	9668	Vila Paulista I	Vl Paulista I
30429	SP	9668	Barro Branco II	B Branco II
30460	SP	9239	Jardim Acácias	Jd Acácias
30461	SP	9239	Jaceguava	\N
30462	SP	9239	Parque Santa Adélia	Prq Sta Adélia
30538	SP	8912	7º Distrito Industrial (Antonio Zanin)	7º Dt Industrial (A Zanin)
30544	SP	8912	Jardim Paulista	Jd Paulista
30545	SP	8912	Jardim Santa Júlia III	Jd Sta Júlia III
30546	SP	8912	Jardim Uirapuru	Jd Uirapuru
30547	SP	8912	Jardim dos Flamboyants	Jd Flamboyants
30548	SP	8912	Jardim Pinheiros II	Jd Pinheiros II
30550	SP	9668	Conjunto City Jaraguá	Cj C Jaraguá
30553	SP	9668	Jardim Pérola III	Jd Pérola III
30556	SP	9668	Jardim Pérola I	Jd Pérola I
30557	SP	9668	Jardim Vitória	Jd Vitória
30558	SP	9668	Jardim São Raimundo	Jd S Raimundo
30563	SP	9703	Cidade Miguel Badra	C M Badra
30569	SP	9668	Associação Sobradinho	A Sobradinho
30571	SP	9668	Jardim Recanto Verde	Jd Rec Verde
30572	SP	9668	Jardim Felicidade (Zona Norte)	Jd Felicidade (Z Norte)
30573	SP	9668	Jardim Fontalis	Jd Fontalis
30574	SP	9668	Jardim Palmares (Zona Norte)	Jd Palmares (Z Norte)
30579	SP	9243	Polo Industrial	P Industrial
30580	SP	9668	Condomínio São Marcos	Cond S Marcos
30582	SP	9239	Jardim Pinheiros	Jd Pinheiros
30583	SP	9239	Jardim Convento	Jd Convento
30585	SP	9239	Sítio Pinheiros	Sit Pinheiros
30586	SP	9239	Chácara Jardim Flórida	Ch Jd Flórida
30587	SP	9239	Chácara Iracema	Ch Iracema
30588	SP	9239	Chácara Recanto Bela Vista	Ch Rec B Vista
30590	SP	9239	Chácara Guarani	Ch Guarani
30596	SP	9239	Vila Leonor	Vl Leonor
30597	SP	9239	Jardim Palmeiras	Jd Palmeiras
30664	SP	9668	Cohab Monet	C Monet
30665	SP	9052	Parque Glória VI	Prq Glória VI
30666	SP	9052	Loteamento Residencial Isabella	Lot Res Isabella
30667	SP	9052	Conjunto  Habitacional Vereador Lucio Cacciari	Cj Hab Ver L Cacciari
30669	SP	9052	Pólo Industrial Pedro Luís Boso	P Ind P L Boso
30670	SP	9239	Chácara Alice	Ch Alice
30671	SP	9052	Residencial Juliatti Carvalho	Res J Carvalho
30672	SP	9052	Residencial Sebastião Moraes	Res S Moraes
30673	SP	9707	Parque Iracema	Prq Iracema
30679	SP	9183	Vila Nova União	Vl N União
30681	SP	9052	Parque Residencial Agudo Romão II	Prq Res A Romão II
30686	SP	8907	Concórdia III	\N
30687	SP	9052	Loteamento Cidade Jardim	Lot C Jardim
30689	SP	8907	Mini Distrito Industrial Alexandre Biagi	M Dt Ind A Biagi
30690	SP	8907	Parque Industrial de Grandes Resíduos	Prq Ind G Resíduos
30691	SP	8907	Jardim Residencial Etemp	Jd Res Etemp
30695	SP	9052	Conjunto Habitacional Pedro Luis Boso	Cj Hab P L Boso
30696	SP	9696	Conjunto Habitacional Professor Benedicto Cleto	Cj Hab Prf B Cleto
30697	SP	9696	Jardim Residencial Tivoli Park	Jd Res T Park
30698	SP	9696	Habiteto - Ana Paula Eleutério	Habiteto - A P Eleutério
30700	SP	9696	Jardim Residencial Deolinda Guerra	Jd Res D Guerra
30705	SP	9640	Conjunto Habitacional Calux	Cj Hab Calux
30707	SP	9640	Vila das Valsas	Vl Valsas
30708	SP	9094	Vila Nova Conceição	Vl N Conceição
30709	SP	9660	Bairro da Pernambucana	B Pernambucana
30711	SP	9094	Núcleo Habitacional José Bonifácio	Nuc Hab J Bonifácio
30713	SP	9559	Santa Clara	Sta Clara
30714	SP	8956	Fazenda Itaquiti	Faz Itaquiti
30796	SP	9622	Jardim Sílvio	Jd Sílvio
30797	SP	9622	Vila Maclape	Vl Maclape
30798	SP	9622	Vila Yolanda	Vl Yolanda
30799	SP	9622	Vila Marly	Vl Marly
30800	SP	9622	Jardim da Várzea	Jd Várzea
30801	SP	9622	Vila Campos (Fazendinha)	Vl Campos (Fazendinha)
30802	SP	9622	Vila César (Fazendinha)	Vl César (Fazendinha)
30803	SP	9622	Jardim Primavera (Fazendinha)	Jd Primavera (Fazendinha)
30804	SP	9622	Jardim Samambaia	Jd Samambaia
30805	SP	9622	Jardim das Acácias (Fazendinha)	Jd Acácias (Fazendinha)
30806	SP	9622	Jardim Ceará (Fazendinha)	Jd Ceará (Fazendinha)
30807	SP	9622	Vila Grecco (Fazendinha)	Vl Grecco (Fazendinha)
30808	SP	9622	Jardim Bahia (Fazendinha)	Jd Bahia (Fazendinha)
30809	SP	9622	Vila Safári (Fazendinha)	Vl Safári (Fazendinha)
30810	SP	9622	Jardim Amapá (Fazendinha)	Jd Amapá (Fazendinha)
30811	SP	9622	Jardim Diva (Fazendinha)	Jd Diva (Fazendinha)
30813	SP	9622	Jardim Acre (Fazendinha)	Jd Acre (Fazendinha)
30814	SP	9622	Jardim Pará (Fazendinha)	Jd Pará (Fazendinha)
30815	SP	9622	Vila São Vicente (Fazendinha)	Vl S Vicente (Fazendinha)
30816	SP	9622	Jardim das Camélias (Fazendinha)	Jd Camélias (Fazendinha)
30817	SP	9622	Jardim Santa Clara (Fazendinha)	Jd Sta Clara (Fazendinha)
30819	SP	9622	Jardim Arco Íris	Jd A Íris
30820	SP	9369	Barroso	\N
30821	SP	9369	Pindorama	\N
30822	SP	9369	Quatinga	\N
30824	SP	9668	Cantinho do Céu	C Céu
30826	SP	9668	Chácara Bambú	Ch Bambú
30827	SP	9659	Jardim do Cedro	Jd Cedro
30830	SP	9052	Loteamento Conjunto Habitacional Comendador Theodoro Rosa Filho	Lot Cj Hab Cdor T R Filho
30831	SP	9052	Polo Comercial Industrial Raul de Carvalho	P C Ind R Carvalho
30836	SP	8969	Residencial Ipê	Res Ipê
30837	SP	8969	Residencial Jardim Santa Luzia	Res Jd Sta Luzia
30838	SP	8969	Residencial São Pedro	Res S Pedro
30839	SP	8969	Residencial Simões	Res Simões
30840	SP	8969	Jardim Sant'Ana	Jd Sant'Ana
30841	SP	8969	Jardim Vista Alegre	Jd V Alegre
30897	SP	8961	Conjunto Habitacional Isaura Pitta Garms	Cj Hab I P Garms
30898	SP	8961	Residencial Village Campo Novo	Res V Cpo Novo
30899	SP	8961	Residencial Lago Sul	Res Lg Sul
30901	SP	8961	Residencial Vanessa	Res Vanessa
30902	SP	8961	Vila Nova Nise	Vl N Nise
30904	SP	8961	Vila Santa Clara	Vl Sta Clara
30905	SP	8961	Pousada da Esperança II	P Esperança II
30906	SP	8961	Vila Pacífico II	Vl Pacífico II
30907	SP	8961	Jardim São Jorge	Jd S Jorge
30910	SP	9145	Residencial União dos Palmares	Res U Palmares
30912	SP	9145	Jardim Elba	Jd Elba
30913	SP	9668	Jardim Fanganiello	Jd Fanganiello
30914	SP	9668	Jardim Áurea	Jd Áurea
30916	SP	8933	Altos da Boa Vista	A B Vista
30920	SP	9625	Vila Elclor	Vl Elclor
30921	SP	9668	Parque Palmas do Tremembé	Prq P Tremembé
30923	SP	9028	Vila Abernéssia	Vl Abernéssia
30924	SP	9668	Colônia (Zona Leste)	Colônia (Z Leste)
30934	SP	9295	Bairro dos Fernandes	B Fernandes
30939	SP	9285	Parque Residencial Primavera	Prq Res Primavera
30940	SP	9285	Jardim Maria Luiza II	Jd M Luiza II
30941	SP	9285	Jardim Maria Luiza III	Jd M Luiza III
30942	SP	9285	Jardim Santa Terezinha	Jd Sta Terezinha
30943	SP	9285	Vila Franzolin	Vl Franzolin
30944	SP	9285	Jardim Pires I	Jd Pires I
30945	SP	9285	Conjunto Habitacional dos Comerciários I	Cj Hab Comerciários I
30946	SP	9285	Jardim João Ballan	Jd J Ballan
30947	SP	9285	Jardim Maria Luiza IV	Jd M Luiza IV
30948	SP	9285	Jardim Conde Pinhal II	Jd Cd Pinhal II
30949	SP	9668	Jardim Vitória Régia (Zona Norte)	Jd V Régia (Z Norte)
31001	SP	9560	Jardim Mário Paiva Arantes	Jd M P Arantes
31003	SP	9560	Jardim Eugênio Mendes Lopes	Jd E M Lopes
31005	SP	9560	Engenheiro Carlos de Lacerda Chaves	Eng C L Chaves
31006	SP	9560	Conjunto Habitacional Sílvio Passalacqua	Cj Hab S Passalacqua
31007	SP	9560	Jardim Herculano Fernandes	Jd H Fernandes
31008	SP	9560	Parque das Oliveiras	Prq Oliveiras
31009	SP	9560	Jardim Palma Travassos	Jd P Travassos
31010	SP	9768	Condomínio Residencial Mirante do Lenheiro	Cond Res M Lenheiro
31012	SP	9703	Jardim Novo Horizonte	Jd N Horizonte
31013	SP	9703	Jardim Alto da Boa Vista	Jd At B Vista
31014	SP	8989	Parque Santa Inês	Prq Sta Inês
31016	SP	8989	Conjunto Habitacional Joaquim Vernini	Cj Hab J Vernini
30894	SP	8961	Rio Verde	R Verde
31017	SP	8989	Parque Residencial dos Comerciários	Prq Res Comerciários
31018	SP	8989	Conjunto Habitacional Morada do Sol	Cj Hab M Sol
31024	SP	8989	Distrito Industrial I	Dt Industrial I
31029	SP	8989	Jardim Shangri-lá	Jd Shangri-lá
31030	SP	8989	Residencial Arlindo Durante	Res A Durante
31036	SP	9707	Jardim Vitória	Jd Vitória
31037	SP	9082	da Graça	Graça
31041	SP	9668	Jardim São Carlos (Zona Sul)	Jd S Carlos (Z Sul)
31044	SP	9668	Jardim das Palmeiras (Zona Sul)	Jd Palmeiras (Z Sul)
31045	SP	9668	Jardim São Luís (Zona Norte)	Jd S Luís (Z Norte)
31046	SP	9668	Vila Vanda	Vl Vanda
30598	SP	9239	Jardim Neuza	Jd Neuza
30599	SP	9768	Loteamento Residencial Fonte Nova	Lot Res Fnt Nova
30600	SP	9768	Loteamento Residencial Fazenda São José	Lot Res Faz S José
30601	SP	9768	Jardim Pacaembu	Jd Pacaembu
30617	SP	9668	Jardins Recanto das Rosas	J Rec Rosas
30618	SP	8886	Chácara das Águas (Três Pontes)	Ch Águas (T Pontes)
30619	SP	8886	Parque Modelo	Prq Modelo
30620	SP	8886	Vale Verde	Vle Verde
30621	SP	8886	Jardim Silvestre IV	Jd Silvestre IV
30623	SP	9668	Jardim Danubio Azul	Jd D Azul
30637	SP	9239	Ita Park	I Park
30638	SP	9239	Refúgio da Serra	R Serra
30639	SP	9239	Jardim Bela Vista	Jd B Vista
30640	SP	9696	Jardim Tropical	Jd Tropical
30644	SP	9696	Jardim Santa Lúcia	Jd Sta Lúcia
30645	SP	9696	Jardim Portal do Itavuvu	Jd P Itavuvu
30646	SP	9696	Jardim Piazza di Roma	Jd P di Roma
30647	SP	9703	Vila Varpa	Vl Varpa
30662	SP	9182	Paecara	\N
30663	SP	9052	Conjunto Residencial Anuar Pacha	Cj Res A Pacha
30724	SP	9082	Jardim Acoty	Jd Acoty
30730	SP	9756	Silop	\N
30731	SP	9136	Centro	\N
30732	SP	9464	Centro	\N
30734	SP	8853	Centro	\N
30735	SP	9237	Vila São Paulo	Vl S Paulo
30736	SP	8924	Centro	\N
30737	SP	9608	Centro	\N
30738	SP	9013	Região Central	R Central
30739	SP	9015	Centro	\N
30740	SP	9480	Centro	\N
30741	SP	9549	Centro	\N
30742	SP	9673	Centro	\N
30743	SP	9783	Barra Funda	B Funda
30744	SP	8958	Centro	\N
30745	SP	9654	Centro	\N
30746	SP	9197	Centro	\N
30747	SP	9720	Centro	\N
30748	SP	9366	Centro	\N
30749	SP	9425	Centro	\N
30750	SP	9274	Centro	\N
30751	SP	9477	Centro	\N
30752	SP	8949	Centro	\N
30753	SP	9150	Centro	\N
30754	SP	9665	Centro	\N
30755	SP	9602	Centro	\N
30756	SP	9201	Centro	\N
30757	SP	9252	Centro	\N
30758	SP	9058	Centro	\N
30759	SP	9735	Nova Tietê	N Tietê
30760	SP	9518	Centro	\N
30761	SP	9533	Centro	\N
30762	SP	9434	Centro	\N
30763	SP	9103	Centro	\N
30764	SP	9176	Centro	\N
30765	SP	8970	Centro	\N
30766	SP	9584	Centro	\N
30767	SP	9499	Centro	\N
30768	SP	9668	Jardim Poleti	Jd Poleti
30769	SP	9301	Centro	\N
30775	SP	9145	Jardim São João	Jd S João
30776	SP	9145	Jardim Vassouras I	Jd Vassouras I
30779	SP	9668	Jardim Sandra Maria	Jd S Maria
30780	SP	9668	Jardim Pantanal	Jd Pantanal
30781	SP	9668	Vila Nova Parada	Vl N Parada
30786	SP	9622	Jardim Brasil	Jd Brasil
30787	SP	9622	Recanto do Mané	Rec Mané
30788	SP	9622	Recanto Pereira	Rec Pereira
30789	SP	9622	Jardim Celeste	Jd Celeste
30790	SP	9622	Jardim Nova Granada	Jd N Granada
30791	SP	9622	Vila Wilson	Vl Wilson
30792	SP	9622	Jardim Bela Vista	Jd B Vista
30793	SP	9622	Vila Amaral	Vl Amaral
30794	SP	9622	Vila França	Vl França
30795	SP	9622	Vila Anoral	Vl Anoral
30842	SP	8969	Residencial das Aroeiras	Res Aroeiras
30845	SP	8969	Residencial Cristo Redentor	Res C Redentor
30849	SP	9700	Vila Sol Nascente	Vl S Nascente
30850	SP	9703	Jardim Bela Vista	Jd B Vista
30851	SP	8886	Residencial Paulistano	Res Paulistano
30852	SP	8886	Eucalíptos	\N
30853	SP	8886	Jardim São Sebastião	Jd S Sebastião
30854	SP	8886	Residencial Santa Maria Amparo	Res Sta M Amparo
30862	SP	9082	Residencial Pastoreiro	Res Pastoreiro
30869	SP	8933	Braz II	\N
30870	SP	8933	Conjunto Habitacional Água Branca	Cj Hab A Branca
30871	SP	8933	Vila Martins I	Vl Martins I
30872	SP	8933	Jardim Rino e Rino	Jd R E Rino
30875	SP	8933	Vila Martins III	Vl Martins III
30876	SP	8933	Jardim Bom Sucesso II	Jd B Sucesso II
30877	SP	8933	Parque Santa Elizabeth IV	Prq Sta Elizabeth IV
30879	SP	8933	Parque Santa Elizabeth III	Prq Sta Elizabeth III
30880	SP	8933	Parque Residencial Gilberto Filgueiras II	Prq Res G Filgueiras II
30881	SP	8933	Jardim Botânico	Jd Botânico
30882	SP	8933	Distrito Industrial Nova Avaré	Dt Ind N Avaré
30883	SP	8933	Alto da Colina II	At Colina II
30884	SP	8933	Avaré Golf Country	A G Country
30885	SP	8933	Jardim Europa II	Jd Europa II
30886	SP	8933	Distrito Industrial Primavera	Dt Ind Primavera
30887	SP	8933	Jardim Europa III	Jd Europa III
30888	SP	8933	Jardim Jubran	Jd Jubran
30889	SP	8933	Residencial Nova Avaré	Res N Avaré
30890	SP	8933	Braz I	\N
30891	SP	8933	Vila Martins II	Vl Martins II
30892	SP	8933	Parque Santa Elizabeth I	Prq Sta Elizabeth I
30893	SP	8961	Residencial Villaggio	Res Villaggio
30895	SP	8961	Residencial Nova Flórida	Res N Flórida
30896	SP	8961	Núcleo Habitacional Nobuji Nagasawa	Nuc Hab N Nagasawa
30951	SP	9026	Área Industrial - 3	A Industrial - 3
30952	SP	9700	Jardim das Orquídeas	Jd Orquídeas
30956	SP	9700	Parque Villa Flores	Prq V Flores
30958	SP	9700	Vila Davina	Vl Davina
30959	SP	9700	Parque Florença	Prq Florença
30960	SP	9144	Recanto Elimar II	Rec Elimar II
30961	SP	9144	Prolongamento Recanto Elimar	Prl Rec Elimar
30963	SP	9144	Residencial Jovita de Melo	Res J Melo
30964	SP	9144	Residencial Atlanta Park	Res A Park
30965	SP	9144	Jardim Simões	Jd Simões
30966	SP	9144	Jardim Cambuí	Jd Cambuí
30967	SP	9686	Jardim Santa Isabel	Jd Sta Isabel
30968	SP	9686	Jardim Belo Horizonte do Tambury	Jd B H Tambury
30969	SP	9686	Chácaras Recreio Planalto	C Rcr Planalto
30970	SP	9686	Jardim Campo Belo	Jd Cpo Belo
30971	SP	9686	Jardim Boa Vista	Jd B Vista
30975	SP	9560	Nova Aliança	N Aliança
30976	SP	9560	Jardim Progresso	Jd Progresso
30977	SP	9668	Jardim São Luís (Zona Leste)	Jd S Luís (Z Leste)
30979	SP	9668	Vila Ester	Vl Ester
30983	SP	9560	Portal do Alto	P Alto
30984	SP	9560	Jardim Arlindo Laguna	Jd A Laguna
30985	SP	9250	Jardim Moraes	Jd Moraes
30989	SP	9560	Jamil Seme Cury	J S Cury
30990	SP	9560	Jardim Paiva	Jd Paiva
30994	SP	9560	Parque Residencial Emir Garcia	Prq Res E Garcia
31056	SP	8913	Distrito Industrial I	Dt Industrial I
31057	SP	8913	Jardim Campestre	Jd Campestre
31059	SP	8913	Distrito Industrial III	Dt Industrial III
31060	SP	9668	Vila Bela Vista (Zona Sul)	Vl B Vista (Z Sul)
31071	SP	8907	Chácaras Patrimônio Santana	C P Santana
31084	SP	8907	Água Branca I	A Branca I
31085	SP	8907	Água Branca II	A Branca II
31086	SP	8907	São Sebastião	S Sebastião
31087	SP	9082	Parque Industrial San José	Prq Ind S José
31088	SP	8907	Amizade	\N
31108	SP	9703	Baruel	\N
31206	SP	9025	Fazenda Pau D'Alho	Faz P D'Alho
31239	SP	9707	Jardim Comunitário	Jd Comunitário
31246	SP	9319	Residencial Bom Recreio	Res B Recreio
31247	SP	9319	Residencial Jardim Monte Verde	Res Jd Mte Verde
31117	SP	9668	Jardim Imperador (Zona Sul)	Jd Imperador (Z Sul)
31137	SP	9647	Jardim Recanto dos Pássaros	Jd Rec Pássaros
31138	SP	9703	Jardim Três Américas	Jd T Américas
31139	SP	8907	Água Branca III	A Branca III
31316	SP	9640	Nova Baeta	N Baeta
31317	SP	9640	Vila Feliz	Vl Feliz
31318	SP	9640	Vila da Biquinha(Montanhão)	Vl Biquinha (Montanhão)
31655	SP	8951	Centro	\N
31664	SP	9176	Lambari	\N
31674	SP	8967	Centro	\N
31675	SP	8967	Riviera de São Lourenço	R S Lourenço
31679	SP	9013	Laranjeiras	\N
31681	SP	9290	Jordanésia	\N
31682	SP	9016	Centro	\N
31683	SP	9030	Centro	\N
31684	SP	8921	Centro	\N
31685	SP	9108	Centro	\N
31686	SP	9108	Batatal	\N
31687	SP	9108	Vergueiro	\N
31688	SP	8991	Braço	\N
31689	SP	9241	Vila Itapeuna	Vl Itapeuna
31690	SP	9114	Centro	\N
31691	SP	9114	Cipó	\N
31692	SP	9210	Centro	\N
31693	SP	9210	Barra do Ribeira	B Ribeira
31694	SP	9210	Rócio	\N
31695	SP	9211	Centro	\N
31696	SP	9211	Pedrinhas	\N
31698	SP	9237	Belas Artes	B Artes
31700	SP	9253	Centro	\N
31701	SP	8887	Ana Dias	A Dias
31702	SP	9271	Centro	\N
31703	SP	9299	Centro	\N
31704	SP	9301	Palmeiras	\N
31705	SP	9301	Barnabés	\N
31706	SP	9338	Centro	\N
31707	SP	9338	Terra Preta	T Preta
31708	SP	9316	Residencial Açaí I	Res Açaí I
31709	SP	9316	Residencial Açaí II	Res Açaí II
31710	SP	9316	Jardim do Caju II	Jd Caju II
31712	SP	9362	Centro	\N
31713	SP	9374	Centro	\N
31714	SP	9374	Agenor de Campos	A Campos
31715	SP	9476	Centro	\N
31716	SP	9457	Centro	\N
31717	SP	9568	Vila Figueredo	Vl Figueredo
31718	SP	9661	Centro	\N
31719	SP	9401	Nossa Senhora dos Remédios	N Sra Remédios
31720	SP	9687	Centro	\N
31721	SP	9773	Centro	\N
31829	SP	9189	Chácaras Panaino	C Panaino
31830	SP	9189	Jardim Aline	Jd Aline
31831	SP	9189	Jardim Boa Esperança	Jd B Esperança
31832	SP	9189	Jardim Conceição	Jd Conceição
31833	SP	9189	Jardim Estefânia	Jd Estefânia
31834	SP	9189	Jardim Nova Europa	Jd N Europa
31835	SP	9189	Jardim Nova Hortolândia II	Jd N Hortolândia II
31838	SP	9189	Jardim Paulistinha	Jd Paulistinha
31839	SP	9189	Jardim Ipê	Jd Ipê
31840	SP	9189	Jardim Santiago	Jd Santiago
31841	SP	9189	Jardim São Benedito	Jd S Benedito
31842	SP	9189	Jardim Terras de Santo Antônio	Jd T Sto Antônio
31844	SP	9189	Jardim Villagio Ghiraldelli	Jd V Ghiraldelli
31847	SP	9189	Loteamento Recanto do Sol	Lot Rec Sol
31851	SP	9189	Núcleo Santa Isabel	Nuc Sta Isabel
31855	SP	9189	Parque Horizonte	Prq Horizonte
31863	SP	9189	Parque Perón	Prq Perón
31865	SP	9189	Vila América	Vl América
31866	SP	9189	Vila Conquista	Vl Conquista
31867	SP	9189	Vila Guedes	Vl Guedes
32089	SP	9513	Centro	\N
31740	SP	9659	Residencial Nato Vetorasso	Res N Vetorasso
31763	SP	9189	Chácaras Nova Boa Vista	C N B Vista
32096	SP	8962	Residencial Doutor Hércules Pereira Hortal	Res Dr H P Hortal
32097	SP	8962	Jardim São Francisco	Jd S Francisco
32098	SP	8962	Residencial San Conrado	Res S Conrado
32099	SP	8962	Estância Vila Verde	Etn Vl Verde
32100	SP	8962	Jardim São Carlos	Jd S Carlos
32101	SP	8962	Distrito Industrial IV	Dt Industrial IV
32128	SP	9668	Chácara Santo Antônio (Zona Leste)	Ch Sto Antônio (Z Leste)
32248	SP	9435	Jardim Brilhante	Jd Brilhante
32250	SP	9435	Jardim Quebec	Jd Quebec
32252	SP	9435	Jardim Vale do Sol	Jd Vle Sol
32348	SP	9317	Jardim São Lourenço	Jd S Lourenço
32349	SP	9317	Jardim Palmeiras	Jd Palmeiras
32350	SP	9317	Jardim Residencial Guimarães	Jd Res Guimarães
32351	SP	9317	Jardim Vitório Lucato	Jd V Lucato
32353	SP	9317	Jardim Ipanema	Jd Ipanema
32355	SP	9317	Residencial Fênix	Res Fênix
32356	SP	9317	Jardim Vitória	Jd Vitória
32357	SP	9317	Jardim Residencial Basteli	Jd Res Basteli
32358	SP	9317	Jardim Campo Belo	Jd Cpo Belo
32359	SP	9317	Jardim Residencial Alto da Graminha	Jd Res At Graminha
32362	SP	9317	Jardim Nova Conquista	Jd N Conquista
32367	SP	9703	Jardim Carla	Jd Carla
32515	SP	9242	Vila dos Comerciários	Vl Comerciários
32516	SP	9242	Jardim Primavera	Jd Primavera
32517	SP	9242	Colina dos Pinheiros	C Pinheiros
32789	SP	9348	Cavalieri II	\N
32431	SP	9668	Jardim Santa Terezinha (Parelheiros)	Jd Sta Terezinha (Parelheiros)
32837	SP	9560	Horto Florestal	H Florestal
32838	SP	9560	Jardim José Figueira	Jd J Figueira
32855	SP	8907	Santa Luzia	Sta Luzia
32856	SP	8907	Avenida	\N
32863	SP	9668	Jardim Santa Fé (Zona Oeste)	Jd Sta Fé (Z Oeste)
32864	SP	9348	Conjunto Residencial Sargento José Carlos Alves Ferreira	Cj Res Srg J C A Ferreira
32865	SP	9348	Jardim Tangará	Jd Tangará
32866	SP	9348	Antonio Carlos Nascimento da Silva	A C N Silva
32922	SP	9686	Jardim Santa Marta	Jd Sta Marta
32923	SP	9686	Jardim Porto Seguro	Jd Pto Seguro
33084	SP	9748	Vila Industrial	Vl Industrial
33085	SP	9748	Parque Residencial Casari	Prq Res Casari
33086	SP	9748	Delta Ville Tênis Club	D V T Club
33097	SP	9647	Parque Universitário	Prq Universitário
33098	SP	9647	Jardim São Salvador	Jd S Salvador
33099	SP	9647	Jardim Ipê	Jd Ipê
33101	SP	9647	Jardim dos Reis	Jd Reis
33297	SP	9696	Parque Ouro Fino	Prq O Fino
33302	SP	9566	Jardim Araucaria	Jd Araucaria
33303	SP	9566	Jardim Progresso	Jd Progresso
33304	SP	9566	Benjamim de Castro	B Castro
33305	SP	9566	Jardim Brasília II	Jd Brasília II
33306	SP	9643	Parque Faber Castell II	Prq F Castell II
33309	SP	9643	Jardim Acapulco	Jd Acapulco
33310	SP	9643	Parque Fehr	Prq Fehr
33311	SP	9643	Jardim Ipanema	Jd Ipanema
33312	SP	9643	Conjunto Habitacional Santa Angelina	Cj Hab Sta Angelina
33313	SP	9643	Jardim dos Coqueiros	Jd Coqueiros
33314	SP	9643	Residencial  Astolpho Luiz do Prado	Res A L Prado
33315	SP	9643	Residencial Itamarati	Res Itamarati
33317	SP	9643	Jardim de Cresci	Jd Cresci
33318	SP	9643	Mirante da Bela Vista	M B Vista
33319	SP	9643	Jardim Bicão	Jd Bicão
33320	SP	9643	Jardim Social Belvedere	Jd S Belvedere
33328	SP	9789	V Distrito Industrial Alcides Alves da Silva	V Dt Ind A A Silva
33329	SP	9789	Jardim Morini	Jd Morini
33344	SP	9348	Jardim Edisom da Silva Lima	Jd E S Lima
33372	SP	9348	Conjunto Habitacional Vila dos Comerciários II	Cj Hab Vl Comerciários II
32874	SP	9348	Edson Jorge Júnior	E J Júnior
32875	SP	9144	Parque Franville	Prq Franville
32876	SP	9144	Chácara Ouro Verde	Ch O Verde
32915	SP	9686	Jardim Eugênio Mazzer	Jd E Mazzer
32917	SP	9686	Jardim Nassim Mamed	Jd N Mamed
32920	SP	9686	Jardim Domingos Biagi	Jd D Biagi
32921	SP	9686	Jardim Ouro Preto	Jd O Preto
32984	SP	8954	Hussein Gemha	H Gemha
33253	SP	9267	Jardim Santa Marina	Jd Sta Marina
33254	SP	9267	Loteamento Villa Branca	Lot V Branca
33260	SP	9267	Parque dos Príncipes	Prq Príncipes
33262	SP	9660	Jardim Cruzeiro do Sul	Jd C Sul
33263	SP	9660	Parque dos Ipês	Prq Ipês
33265	SP	9660	Jardim República	Jd República
33266	SP	9660	Eldorado	\N
33267	SP	9660	Residencial Bosque dos Ipês	Res Bsq Ipês
33268	SP	9660	Conjunto Residencial Dom Pedro II	Cj Res D Pedro II
33274	SP	9348	Jardim Sancho Floro da Costa	Jd S F Costa
33275	SP	9748	Distrito Industrial Eizi Hirano	Dt Ind E Hirano
33276	SP	9315	Serelepe	\N
33278	SP	9315	Jardim Eldorado	Jd Eldorado
33279	SP	9315	Jardim Jequitibá	Jd Jequitibá
33280	SP	9315	Jardim Residencial Pavani	Jd Res Pavani
33284	SP	9315	Jardim Santa Marta	Jd Sta Marta
33286	SP	8961	Residencial Village Via Verde	Res V V Verde
33287	SP	9315	Jardim São Joaquim	Jd S Joaquim
33289	SP	9748	Conjunto Habitacional Pioneiro José Feliciano	Cj Hab Pion J Feliciano
33373	SP	9595	Jardim Nova Conquista	Jd N Conquista
33374	SP	9595	Chácara Recreio Cruzeiro do Sul	Ch Rcr C Sul
33376	SP	9595	Planalto do Sol II	P Sol II
33377	SP	9595	Vale das Cigarras	Vle Cigarras
33378	SP	9595	Recanto das Andorinhas	Rec Andorinhas
33469	SP	9025	Conjunto Residencial Parque Bandeirantes	Cj Res Prq Bandeirantes
33526	SP	9025	Vila Aeroporto III	Vl Aeroporto III
33527	SP	9025	Jardim Santa Maria	Jd Sta Maria
33544	SP	9254	Jardim da Luz	Jd Luz
33545	SP	9254	Distrito Industrial Alfredo Relo	Dt Ind A Relo
33546	SP	9254	Núcleo Habitacional Roberto Panzarin	Nuc Hab R Panzarin
35626	SP	9324	Centro	\N
33547	SP	9254	Loteamento Padovani	Lot Padovani
33548	SP	9254	Chácaras Bredariol	C Bredariol
33549	SP	9254	Terras de Santa Cruz	T Sta Cruz
33550	SP	9254	Fazenda Malabar	Faz Malabar
33551	SP	9254	Vila Rita	Vl Rita
33552	SP	9254	Residencial Flamboyant	Res Flamboyant
33553	SP	9254	Residencial Fazenda Serrinha	Res Faz Serrinha
33554	SP	9254	Parque da Colina	Prq Colina
33555	SP	9254	Bairro dos Pintos	B Pintos
33556	SP	9254	Bairro Morro Azul	B Mro Azul
33557	SP	9254	Loteamento Itatiba Park	Lot I Park
33558	SP	9254	Bairro Tapera Grande	B T Grande
33559	SP	9254	Bairro da Aparecidinha	B Aparecidinha
33560	SP	9254	Loteamento Vila Real	Lot Vl Real
33561	SP	9254	Ville de France	V France
33563	SP	9254	Bairro dos Machados	B Machados
33565	SP	9254	Giardino D' Itália	G D Itália
33566	SP	9254	Bairro das Brotas	B Brotas
33620	SP	9025	Chácara Leandro	Ch Leandro
33621	SP	9025	Loteamento Chácaras Vale das Garças	Lot C Vle Garças
33622	SP	9025	Vila São José	Vl S José
33623	SP	9025	Jardim São José	Jd S José
33625	SP	9725	Bosques do Junqueira	B Junqueira
33627	SP	9587	Village Milioni	V Milioni
33628	SP	9725	Village Engenheiro Campos	V Eng Campos
33630	SP	9725	Jardins Tatuí	\N
33638	SP	9725	Residencial Ecopark	Res Ecopark
33673	SP	9725	Parque Industrial	Prq Industrial
33674	SP	9725	Vila Monte Verde	Vl Mte Verde
33675	SP	9725	Jardim Planalto	Jd Planalto
33676	SP	9725	Residencial Atlanta	Res Atlanta
33677	SP	9725	Europark	\N
33678	SP	9725	Residencial Astória	Res Astória
33679	SP	9725	Residencial São Conrado	Res S Conrado
33681	SP	9775	Vila Real	Vl Real
33685	SP	9260	Chácaras Rincão	C Rincão
33686	SP	9260	Chácara Residencial Paraíso Marriot	Ch Res P Marriot
33687	SP	9260	Conjunto Habitacional União	Cj Hab União
33688	SP	9260	Vila Vivenda	Vl Vivenda
33689	SP	9260	Jardim Novo Mundo	Jd N Mundo
33690	SP	9260	Jardim Europa	Jd Europa
33691	SP	9260	Parque Village Castelo	Prq V Castelo
33692	SP	9260	Chácara Harmonia I	Ch Harmonia I
33693	SP	9260	Chácara Harmonia II	Ch Harmonia II
33967	SP	9025	Residencial Vila Verde	Res Vl Verde
33968	SP	9025	Fazenda São Quirino	Faz S Quirino
33980	SP	9025	Vila Nova São José	Vl N S José
33981	SP	9025	Jardim Andorinhas	Jd Andorinhas
33983	SP	9321	Cecap	\N
33984	SP	9025	Vila Laércio Teixeira (Sousas)	Vl L Teixeira (Sousas)
33986	SP	9025	Núcleo Residencial Guararapes	Nuc Res Guararapes
33987	SP	9321	Vila dos Comerciários I	Vl Comerciários I
33988	SP	9321	Vila dos Comerciários II	Vl Comerciários II
33989	SP	9321	Ponte Nova	Pte Nova
33990	SP	9025	Bananal	\N
33991	SP	9239	Jardim Horizonte Azul	Jd H Azul
33992	SP	9025	Fazenda Monte D'Este	Faz Mte D'Este
33993	SP	9295	Parque Residencial Nove de Julho	Prq Res N Julho
33994	SP	9295	Chácara Recreio Lagoa dos Patos	Ch Rcr Lga Patos
33995	SP	9295	Castanho	\N
33996	SP	9025	Conjunto Habitacional Vila Santana (Sousas)	Cj Hab Vl Santana (Sousas)
33997	SP	9295	Fazenda Grande	Faz Grande
33998	SP	9295	Parque Cidade Jardim II	Prq C Jardim II
33999	SP	9295	Conjunto Residencial Iapi	Cj Res Iapi
34000	SP	9295	Loteamento Residencial Quinta das Laranjeiras	Lot Res Qta Laranjeiras
34002	SP	9295	Jardim Nogueira	Jd Nogueira
34003	SP	9295	Vila Alati	Vl Alati
34004	SP	9295	Santa Clara	Sta Clara
34005	SP	9295	Chácara Terra Nova	Ch T Nova
34006	SP	9295	Loteamento Capital Ville	Lot C Ville
34007	SP	9295	Parque Morangaba	Prq Morangaba
34008	SP	9668	Conjunto Habitacional Turística	Cj Hab Turística
34009	SP	9295	Horto Santo Antonio	H Sto Antonio
34011	SP	9295	Loteamento Ermida	Lot Ermida
34012	SP	9295	Parque Almerinda Pereira Chaves	Prq A P Chaves
34013	SP	9587	Residencial Porto Seguro	Res Pto Seguro
34014	SP	9587	Terras de Santa Rosa II	T Sta Rosa II
34015	SP	9295	Chácara Segre	Ch Segre
33470	SP	9726	São Gonçalo	S Gonçalo
33473	SP	9025	Vila São Paulo	Vl S Paulo
33474	SP	9025	Ponte Preta I	Pte Preta I
33475	SP	9025	Vila Discola	Vl Discola
33479	SP	9532	Conjunto Habitacional Eme Antonio Pioch Fontolan	Cj Hab E A P Fontolan
33480	SP	9532	Parque Residencial Funada	Prq Res Funada
33481	SP	9532	Parque Residencial Francisco Belo Galindo	Prq Res F B Galindo
33483	SP	9532	Residencial Florenza	Res Florenza
33484	SP	9532	Residencial Green Ville	Res G Ville
33485	SP	9532	Residencial III Milênio	Res III Milênio
33486	SP	9532	Residencial Maré Mansa	Res M Mansa
33487	SP	9532	Residencial Monte Carlo	Res Mte Carlo
33488	SP	9640	Jardim Santa Mônica	Jd Sta Mônica
33489	SP	9025	Chácaras São Martinho	C S Martinho
33490	SP	9696	Jardim Residencial Vicente de Moraes	Jd Res V Moraes
33491	SP	8992	Residencial das Ilhas	Res Ilhas
33492	SP	9643	Vila Marcelino	Vl Marcelino
33493	SP	8992	Núcleo Residencial Henedina Rodrigues Cortez	Nuc Res H R Cortez
33494	SP	9643	Jardim Santa Maria II	Jd Sta Maria II
33495	SP	9696	Aparecidinha	\N
33497	SP	9216	Village Terras de Indaiá	V T Indaiá
33498	SP	8992	Residencial Euroville	Res Euroville
33499	SP	9025	Swift	\N
33508	SP	9025	Jardim das Bandeiras	Jd Bandeiras
33509	SP	9643	Residencial Monsenhor Romeu Tortorelli	Res Mns R Tortorelli
33510	SP	9025	Jardim Nova Califórnia	Jd N Califórnia
33514	SP	9025	Fazenda Tamburi	Faz Tamburi
33515	SP	9025	Jardim São Jorge	Jd S Jorge
33516	SP	9025	Jardim Santa Maria II	Jd Sta Maria II
33517	SP	9025	Região do Aeroporto de Viracopos	R Aer Viracopos
33518	SP	9025	Jardim Novo Itaguaçu	Jd N Itaguaçu
33520	SP	9025	Recinto do Aeroporto Internacional de Viracopos	R Aer I Viracopos
33522	SP	9025	Parque União da Vitória	Prq U Vitória
33523	SP	9025	Residencial São José	Res S José
33524	SP	9025	Jardim Aeroporto de Viracopos	Jd Aer Viracopos
33525	SP	9025	Vila Aeroporto II	Vl Aeroporto II
33567	SP	9254	Núcleo Habitacional Prefeito Erasmo Chrispim	Nuc Hab Pref E Chrispim
33571	SP	9595	Jardim Residencial do Lago	Jd Res Lago
33572	SP	9025	Chácaras Campos dos Amarais	C C Amarais
33573	SP	9025	Residencial Terra Nova	Res T Nova
33574	SP	9025	Chácara de Recreio Barão	Ch Rcr Barão
33576	SP	9025	Jardim Rosália IV	Jd Rosália IV
33577	SP	9025	Chácara Boa Vista	Ch Boa Vista
33578	SP	9260	Jardim Theodora	Jd Theodora
33579	SP	9260	Jardim Paraíso II	Jd Paraíso II
33580	SP	9260	Parque América	Prq América
33581	SP	9260	Jardim São Jorge	Jd S Jorge
33582	SP	9260	Vila Santa Rita	Vl Sta Rita
33583	SP	9260	Vila São Paulo	Vl S Paulo
33584	SP	9025	Agostinho Luís Pattaro	A L Pattaro
33586	SP	9025	Jardim Santa Genebra II (Barão Geraldo)	Jd Sta Genebra II (Br Geraldo)
33587	SP	9260	Jardim Santa Laura	Jd Sta Laura
33588	SP	9260	Fazenda da Mata	Faz Mata
33589	SP	9260	Chácaras Berro D'Água	C B D'Água
33591	SP	9025	Jardim Rosália II	Jd Rosália II
33594	SP	8883	Jardim Nielsen Ville	Jd N Ville
33595	SP	8883	Jardim dos Lírios	Jd Lírios
33596	SP	8883	Jardim das Flores	Jd Flores
33597	SP	9587	Conjunto Habitacional Monte Pascoal	Cj Hab Mte Pascoal
33598	SP	9587	Jardim Alvorada	Jd Alvorada
33599	SP	9587	Jardim Arco-Íris	Jd Arco-Íris
33600	SP	9587	Jardim Eldorado	Jd Eldorado
33601	SP	9587	Jardim Planalto	Jd Planalto
33603	SP	9587	Jardim Santa Efigênia	Jd Sta Efigênia
33604	SP	9587	Jardim Santa Marta	Jd Sta Marta
33605	SP	9587	Loteamento Terras de São Pedro e São Paulo	Lot T S P E S Paulo
33606	SP	9587	Núcleo Industrial Alert	Nuc Ind Alert
33607	SP	9587	Residencial Santo Stéfano	Res Sto Stéfano
33608	SP	9587	Residencial São Gabriel	Res S Gabriel
33609	SP	9587	Salto Ville	S Ville
33610	SP	9696	Vila Artura	Vl Artura
33612	SP	9025	Loteamento Residencial Vila Bella	Lot Res Vl Bella
33613	SP	9025	Tijuco das Telhas	T Telhas
33614	SP	9025	Polo II de Alta Tecnologia (Campinas)	P II A Tecnologia (Campinas)
33616	SP	8883	Vila Nossa Senhora de Fátima	Vl N Sra Fátima
33617	SP	8883	Jardim Mirandola	Jd Mirandola
33618	SP	8883	Bairro da Lagoa	B Lagoa
33619	SP	9025	Loteamento Solar Campinas	Lot S Campinas
33694	SP	9260	Shamballa Village	S Village
33929	SP	9216	Vila Inglesa	Vl Inglesa
33932	SP	9216	Recanto dos Pássaros	Rec Pássaros
33933	SP	9216	Jardim Umuarama	Jd Umuarama
33934	SP	9216	Jardim Jequitibá	Jd Jequitibá
33935	SP	9216	Jardim Kioto I	Jd Kioto I
33936	SP	9216	Jardim Kioto II	Jd Kioto II
33937	SP	9216	João Pioli	J Pioli
33938	SP	9216	Lauro Bueno de Camargo	L B Camargo
33939	SP	9216	Jardim Villa Romana	Jd V Romana
33940	SP	9216	Residencial Monte Verde	Res Mte Verde
33941	SP	9216	Jardim Regina	Jd Regina
33942	SP	9216	Jardim Santa Rita	Jd Sta Rita
33944	SP	9216	Aqui se Vive	A S Vive
33945	SP	9216	Recanto Campestre Internacional de Viracopos Gleba 7	Rec C I V Gleba 7
33946	SP	9216	Helvétia	\N
33947	SP	9216	Chácaras Videiras de Itaici	C V Itaici
33948	SP	9216	Recanto das Flores	Rec Flores
33949	SP	9260	Parque São Camilo	Prq S Camilo
33950	SP	9216	Distrito Industrial João Narezzi	Dt Ind J Narezzi
33952	SP	8961	Jardim Helena	Jd Helena
33953	SP	9260	Jardim Residencial Itaim	Jd Res Itaim
33954	SP	9260	Vila Swevia	Vl Swevia
33955	SP	9260	Vila Fragnani	Vl Fragnani
33956	SP	9260	Jardim Pedreira	Jd Pedreira
33957	SP	9260	Jardim Estância Bom Viver	Jd Etn B Viver
33958	SP	9260	Parque Residencial Potiguara	Prq Res Potiguara
33959	SP	9260	Jardim Emicol	Jd Emicol
33960	SP	9260	Jardim Vila Verde I	Jd Vl Verde I
33961	SP	9260	Jardim Vila Verde II	Jd Vl Verde II
33962	SP	9260	Estância Vila Verde	Etn Vl Verde
33964	SP	9216	Jardim Esplanada	Jd Esplanada
34016	SP	9295	Condomínio Vila de Jundiaí	Cond Vl Jundiaí
34020	SP	9643	Parque Belvedere	Prq Belvedere
34029	SP	9005	Borda da Mata	B Mata
34030	SP	9005	Vila Velha	Vl Velha
34031	SP	9005	São Leopoldo	S Leopoldo
34032	SP	9025	Colônia Fazenda Santa Elisa	Col Faz Sta Elisa
34033	SP	9005	Chácara Santo Antonio	Ch Sto Antonio
34035	SP	9005	Roseirinha	\N
34036	SP	9005	Vila Favorino	Vl Favorino
34037	SP	9005	Vila Bandeirantes	Vl Bandeirantes
34039	SP	9748	Conjunto Habitacional Vereador Antônio Caran	Cj Hab Ver A Caran
34041	SP	9025	Residencial São Luís	Res S Luís
34043	SP	9025	Jardim Novo Campos Elíseos	Jd N C Elíseos
34044	SP	9025	Jardim Campina Grande	Jd C Grande
34048	SP	9025	Jardim Sul América	Jd S América
34052	SP	9025	Jardim Conceição	Jd Conceição
34053	SP	9025	Jardim Conceição (Sousas)	Jd Conceição (Sousas)
34056	SP	9295	Chácara Recreio Santa Camila	Ch Rcr Sta Camila
34057	SP	9295	Vale dos Cebrantes	Vle Cebrantes
34058	SP	9295	Jardim Eldorado	Jd Eldorado
34059	SP	9295	Jardim Sorocabana	Jd Sorocabana
34060	SP	9295	Portal do Paraíso II	P Paraíso II
34061	SP	9295	Mirante de Jundiaí	M Jundiaí
34063	SP	9295	Chácara Pai Jacó	Ch P Jacó
34064	SP	9244	Jardim Raquel	Jd Raquel
34066	SP	9295	Loteamento Pinheirinho	Lot Pinheirinho
34067	SP	9295	Horto Florestal	H Florestal
34068	SP	9295	Champirra	\N
34069	SP	9295	Parque Espelho  D'Água	Prq E D'Água
34070	SP	9295	Loteamento Portal da Colina	Lot P Colina
34071	SP	9295	Portal do Sol	P Sol
34072	SP	9295	Jardim Marajoara	Jd Marajoara
34073	SP	9295	Vila Cidadania	Vl Cidadania
34074	SP	9295	Vila Nova República	Vl N República
34076	SP	9295	Parque Carolina	Prq Carolina
34078	SP	9295	Residencial São Domingos	Res S Domingos
34145	SP	9369	Jardim Margarida	Jd Margarida
34149	SP	9668	Jardim Alvorada (Zona Norte)	Jd Alvorada (Z Norte)
34150	SP	9668	Jardim Alvorada (Zona Oeste)	Jd Alvorada (Z Oeste)
34155	SP	8979	Centro	\N
34157	SP	8908	Centro	\N
34158	SP	9479	Centro	\N
34171	SP	9703	Jardim Márcia	Jd Márcia
34172	SP	9669	Centro	\N
34173	SP	8858	Centro	\N
34177	SP	9741	Centro	\N
34178	SP	9049	Centro	\N
34179	SP	9668	Jardim Ipanema (Zona Oeste)	Jd Ipanema (Z Oeste)
34180	SP	9668	Jardim Ipanema (Zona Sul)	Jd Ipanema (Z Sul)
34191	SP	9493	Convívio Green Village	C G Village
34211	SP	9668	Jardim Aurora (Zona Oeste)	Jd Aurora (Z Oeste)
34313	SP	9244	Conjunto Habitacional Humberto Carlos Passarela	Cj Hab H C Passarela
34314	SP	9244	Flávio Zacchi	F Zacchi
34315	SP	9587	Guaraú II	\N
34316	SP	9668	Vila Ayrosa	Vl Ayrosa
34319	SP	9501	Vila Santa Fé	Vl Sta Fé
34321	SP	9725	Residencial Alvorada	Res Alvorada
34328	SP	9668	Jardim das Rosas (Zona Norte)	Jd Rosas (Z Norte)
34329	SP	9668	Jardim das Rosas (Zona Leste I)	Jd Rosas (Z Leste I)
34331	SP	8865	Centro	\N
34332	SP	9668	Jardim das Rosas (Iguatemi)	Jd Rosas (Iguatemi)
34333	SP	9038	Centro	\N
34334	SP	9183	Jardim Monte Alto	Jd Mte Alto
34338	SP	9660	Residencial São Francisco	Res S Francisco
34344	SP	9668	Vila Narciso	Vl Narciso
34346	SP	9668	Jardim Prainha	Jd Prainha
34348	SP	9668	Jardim Monte Verde	Jd Mte Verde
34363	SP	9369	Jardim Piatã A	Jd Piatã A
34369	SP	9267	Jardim Terras de Santa Helena	Jd T Sta Helena
34479	SP	9668	Vila Pedrosa	Vl Pedrosa
34556	SP	9675	São Sebastião da Serra	S S Serra
34557	SP	9046	Vila Alves	Vl Alves
34079	SP	9295	Bosque dos Pinheirinhos	Bsq Pinheirinhos
34080	SP	9005	Chácara Recanto Itamarati II	Ch Rec Itamarati II
34081	SP	9295	Terras de São Carlos	T S Carlos
34082	SP	9295	Jardim Fepasa	Jd Fepasa
34084	SP	9295	Chácara Itamar	Ch Itamar
34085	SP	9295	Quartier Les Residences	Q L Residences
34086	SP	9295	Vale Azul	Vle Azul
34091	SP	9240	Vila José Salem	Vl J Salem
34092	SP	9647	Vila Isabel	Vl Isabel
34094	SP	9369	Residencial Novo Horizonte	Res N Horizonte
34095	SP	9647	Santo Antônio	Sto Antônio
34096	SP	9240	Parque São Bento	Prq S Bento
34098	SP	9485	Residencial Arco-Íris	Res Arco-Íris
34099	SP	9647	Vila Estrela	Vl Estrela
34100	SP	9668	Jardim Shangrilá (Zona Sul)	Jd Shangrilá (Z Sul)
34101	SP	9668	Jardim São Pedro (Zona Sul)	Jd S Pedro (Z Sul)
34102	SP	9789	Votuporanga I	\N
34103	SP	9789	Vila Nova	Vl Nova
34109	SP	9595	Parque Residencial Santa Rosa II	Prq Res Sta Rosa II
34110	SP	9668	Jardim Sipramar	Jd Sipramar
34111	SP	9668	Condomínio Jequirituba	Cond Jequirituba
34112	SP	9668	Jardim Novo Jaú	Jd N Jaú
34113	SP	9595	Parque Frezarin	Prq Frezarin
34114	SP	9595	Chácara São Sebastião	Ch S Sebastião
34115	SP	9595	Parque Planalto	Prq Planalto
34118	SP	9493	Perdizes	\N
34124	SP	9789	Jardim dos Pinheiros	Jd Pinheiros
34226	SP	9240	Vila La Brunetti	Vl L Brunetti
34241	SP	8969	Residencial Prefeito Mário Crêm dos Santos	Res Pref M C Santos
34297	SP	9025	Jardim Paraíso I	Jd Paraíso I
34302	SP	8961	Residencial Jardins do Sul	Res J Sul
34308	SP	9025	Arruamento Luiz Pa'ttaro	A L Pa'ttaro
34310	SP	9183	Parque Flamengo	Prq Flamengo
34311	SP	9668	Jardim das Laranjeiras (Zona Sul)	Jd Laranjeiras (Z Sul)
34402	SP	9005	Sítio Adriana	Sit Adriana
34565	SP	8998	Centro	\N
34568	SP	9668	Jardim Paulistano (Zona Norte)	Jd Paulistano (Z Norte)
34745	SP	9317	Jardim Lagoa Nova	Jd Lga Nova
34746	SP	9317	Jardim Santa Adélia	Jd Sta Adélia
34811	SP	9659	Jardim Bosque das Vivendas	Jd Bsq Vivendas
34812	SP	9647	Alegre	\N
34817	SP	9371	Parque Real	Prq Real
34819	SP	9371	Jardim Luciana	Jd Luciana
34820	SP	9371	Jardim Murayama	Jd Murayama
34828	SP	9371	Jardim Patrícia	Jd Patrícia
34829	SP	9371	Distrito Industrial	Dt Industrial
34830	SP	9371	Condomínio Morro Vermelho	Cond Mro Vermelho
34945	SP	9260	Chácara Carolina	Ch Carolina
34946	SP	9146	Estância Green Valley	Etn G Valley
34947	SP	9146	Pólo Industrial	P Industrial
34952	SP	9668	Jardim Sílvia (Zona Oeste)	Jd Sílvia (Z Oeste)
34958	SP	9668	Vila Amália (Zona Leste)	Vl Amália (Z Leste)
34972	SP	9146	Aldeia Ivoturucaia	A Ivoturucaia
34976	SP	9254	Village do Sol	V Sol
34989	SP	9625	Jardim Alteza	Jd Alteza
34995	SP	9315	Conjunto Habitacional Victório Bonfanti	Cj Hab V Bonfanti
34998	SP	9501	Jardim Cidade Nova	Jd C Nova
35011	SP	9146	Campos de São Benedito	C S Benedito
35152	SP	9696	Jardim Bonsucesso	Jd Bonsucesso
35176	SP	9668	Jardim Bela Vista (Zona Sul)	Jd B Vista (Z Sul)
35177	SP	9144	Conjunto Habitacional Octávio Cirluzo	Cj H O Cirluzo
34747	SP	9317	Parque Residencial Belinha Ometto	Prq Res B Ometto
34748	SP	9643	Residencial Parati	Res Parati
34749	SP	9643	Residencial Américo Alves Margarido	Res A A Margarido
34750	SP	9643	Parque dos Timburis	Prq Timburis
34751	SP	9643	Recreio dos Bandeirantes	Rcr Bandeirantes
34752	SP	9643	Romeu Santini	R Santini
34755	SP	9369	Jardim Piatã B	Jd Piatã B
34756	SP	9668	Jardim São João (Zona Norte)	Jd S João (Z Norte)
34757	SP	9146	Vila dos Comerciários	Vl Comerciários
34758	SP	9146	Vila Palmares	Vl Palmares
34759	SP	9146	Vila Leopolis	Vl Leopolis
34760	SP	9146	Parque dos Eucaliptos	Prq Eucaliptos
34761	SP	9146	Parque Pretoria	Prq Pretoria
34762	SP	9146	Jardim Pinho	Jd Pinho
34767	SP	9647	Jardim das Flores	Jd Flores
34768	SP	9647	Jardim Primavera	Jd Primavera
34770	SP	9647	Jardim das Paineiras	Jd Paineiras
34772	SP	9371	CDHU	\N
34773	SP	9371	Mogi-Mirim II	\N
34775	SP	9668	Jardim Portal I e II	Jd P I e II
34776	SP	9668	Jardim Hebrom	Jd Hebrom
34777	SP	9668	Jardim Apuana	Jd Apuana
34778	SP	9668	Jardim Campo Limpo (Zona Norte)	Jd Cpo Limpo (Z Norte)
34779	SP	9668	Jardim Flor de Maio	Jd F Maio
34780	SP	9668	Jardim da Cachoeira	Jd Cachoeira
34781	SP	9668	Jardim Estrela D'alva	Jd E D'alva
34782	SP	9668	Jardim Uniserve	Jd Uniserve
34783	SP	9668	Jardim Corisco	Jd Corisco
34784	SP	9668	Jardim Francisco Mendes	Jd F Mendes
34785	SP	9668	Jardim Vila Rica	Jd Vl Rica
34786	SP	9668	Jardim Labitary	Jd Labitary
34787	SP	9668	Núcleo do Engordador	Nuc Engordador
34788	SP	9668	Jardim Brasil Novo	Jd B Novo
34789	SP	9668	Jardim Denise	Jd Denise
34892	SP	9640	Conjunto 13 de Maio	Cj 13 Maio
34894	SP	8883	Cidade Jardim II	C Jardim II
34895	SP	8883	Chácara Machadinho II	Ch Machadinho II
34896	SP	8883	Loteamento Industrial Machadinho	Lot Ind Machadinho
34914	SP	9237	Balneário São Jorge	Bal S Jorge
34915	SP	9030	Itapitangui	\N
34928	SP	8883	Jardim América II	Jd América II
34929	SP	9640	Sítio Bom Jesus	Sit B Jesus
34933	SP	9260	Residencial Veneto	Res Veneto
34934	SP	9260	Vila Bandeirantes	Vl Bandeirantes
34935	SP	9260	Chácara Palma	Ch Palma
34936	SP	9640	Areião	\N
34937	SP	9260	Chácaras Reunidas Ipê	C R Ipê
34938	SP	9260	Residencial Dona Lila	Res Da Lila
34940	SP	9260	Progresso	\N
34941	SP	9146	Chácaras das Colinas	C Colinas
34942	SP	9260	Residencial Rio Araguaia	Res R Araguaia
34943	SP	9260	Residencial Sete Quedas	Res S Quedas
34944	SP	9260	Chácara Sete Quedas	Ch S Quedas
35026	SP	9146	Chácaras do Rosário	C Rosário
35039	SP	9025	Residencial Unicamp	Res Unicamp
35066	SP	8913	Jardim Residencial Alvorada	Jd Res Alvorada
35067	SP	8913	Residêncial Morada do Sol	R M Sol
35068	SP	8913	Jardim Monte Verde	Jd Mte Verde
35069	SP	8913	Jardim José Ometto IV	Jd J Ometto IV
35070	SP	8913	Jardim José Ometto V	Jd J Ometto V
35071	SP	8913	Parque Dom Pedro	Prq D Pedro
35073	SP	8913	Jardim Bela Vista	Jd B Vista
35074	SP	8913	Jardim Tangará	Jd Tangará
35075	SP	8913	Jardim Ouro Verde II	Jd O Verde II
35076	SP	8913	Parque Terras de Santa Olívia	Prq T Sta Olívia
35077	SP	8913	Jardim Dom Bosco	Jd D Bosco
35078	SP	8913	Jardim Florença	Jd Florença
35079	SP	9659	Parque da Cidadania	Prq Cidadania
35089	SP	9660	Jardim Santa Matilde	Jd Sta Matilde
35192	SP	8933	Parque Santa Elizabeth II	Prq Sta Elizabeth II
35198	SP	8989	Conjunto Habitacional José Bicudo Filho	Cj Hab J B Filho
35199	SP	8989	Conjunto Habitacional Leandro Alarcão Dias	Cj Hab L A Dias
35200	SP	9435	Parque Olavo Ferreira de Sá	Prq O F Sá
35201	SP	9435	Jardim Independência	Jd Independência
35202	SP	9435	Jardim Manhatan	Jd Manhatan
35203	SP	9435	Residencial Parque dos Diamantes	Res Prq Diamantes
35204	SP	9435	Loteamento Águas do Eloy	Lot A Eloy
35205	SP	9348	Jardim David Leuder Pereira Alves	Jd D L P Alves
35206	SP	8989	Colinas do Paraíso	C Paraíso
35207	SP	9316	Distrito Industrial I	Dt Industrial I
35208	SP	9316	Jardim João Paccola	Jd J Paccola
35209	SP	9319	Parque dos Trabalhadores	Prq Trabalhadores
35210	SP	9319	Residencial Real Parque	Res R Parque
35211	SP	9435	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
35212	SP	9435	Água do Jacu	A Jacu
35213	SP	9435	Chumbeaba	\N
35214	SP	9348	Jardim Dom Frei Daniel Tomasella	Jd D Fr D Tomasella
35392	SP	9082	Jardim das Cerejeiras	Jd Cerejeiras
35403	SP	9094	Jardim Santo Inácio	Jd Sto Inácio
35608	SP	9424	Centro	\N
35609	SP	9104	Centro	\N
35610	SP	9552	Centro	\N
35611	SP	9142	Centro	\N
35612	SP	9554	Centro	\N
35613	SP	9570	Centro	\N
35614	SP	9149	Centro	\N
35615	SP	9155	Centro	\N
35616	SP	9588	Centro	\N
35617	SP	9452	Centro	\N
35618	SP	9456	Centro	\N
35619	SP	9667	Centro	\N
35620	SP	9680	Centro	\N
35621	SP	9439	Centro	\N
35622	SP	9556	Centro	\N
35623	SP	9175	Centro	\N
35624	SP	8860	Centro	\N
35625	SP	9717	Centro	\N
35627	SP	9670	Centro	\N
35628	SP	9681	Centro	\N
35629	SP	9709	Centro	\N
35630	SP	9721	Centro	\N
35631	SP	9364	Centro	\N
35632	SP	9728	Centro	\N
35633	SP	9736	Centro	\N
35634	SP	8861	Centro	\N
35635	SP	8888	Centro	\N
35636	SP	9061	Centro	\N
35637	SP	9070	Centro	\N
35638	SP	9072	Centro	\N
35639	SP	9078	Centro	\N
35640	SP	8873	Centro	\N
35641	SP	8878	Centro	\N
35642	SP	8879	Centro	\N
35643	SP	8917	Centro	\N
35644	SP	9468	Centro	\N
35645	SP	8931	Centro	\N
35646	SP	8932	Centro	\N
35647	SP	9223	Centro	\N
35648	SP	9495	Centro	\N
35649	SP	9227	Centro	\N
35650	SP	9090	Centro	\N
35651	SP	9025	Parque da Figueira	Prq Figueira
35652	SP	9256	Centro	\N
35653	SP	9502	Centro	\N
35654	SP	8940	Centro	\N
35655	SP	9258	Centro	\N
35656	SP	9511	Centro	\N
35657	SP	8947	Centro	\N
35658	SP	9567	Centro	\N
35659	SP	9529	Centro	\N
35660	SP	9535	Centro	\N
35661	SP	8984	Centro	\N
35662	SP	8995	Centro	\N
35663	SP	9598	Centro	\N
35664	SP	9607	Centro	\N
35665	SP	9630	Centro	\N
35666	SP	9674	Centro	\N
35667	SP	9318	Centro	\N
35668	SP	9540	Centro	\N
35669	SP	9187	Centro	\N
35670	SP	9565	Centro	\N
35671	SP	9003	Centro	\N
35672	SP	9160	Centro	\N
35673	SP	9161	Centro	\N
35674	SP	9769	Centro	\N
35675	SP	9777	Centro	\N
35676	SP	9172	Centro	\N
35677	SP	9230	Centro	\N
35678	SP	9684	Centro	\N
35679	SP	9693	Centro	\N
35680	SP	8857	Centro	\N
35681	SP	9190	Centro	\N
35682	SP	9206	Centro	\N
35683	SP	9236	Centro	\N
35684	SP	9248	Centro	\N
35685	SP	9298	Centro	\N
35686	SP	9750	Centro	\N
35687	SP	9293	Centro	\N
35688	SP	9325	Centro	\N
35689	SP	9327	Centro	\N
35690	SP	9008	Centro	\N
35691	SP	9093	Centro	\N
35692	SP	9097	Centro	\N
35693	SP	9328	Centro	\N
35694	SP	9331	Centro	\N
35695	SP	9446	Centro	\N
35696	SP	9360	Centro	\N
35697	SP	9423	Centro	\N
35698	SP	9429	Centro	\N
35699	SP	9124	Centro	\N
35700	SP	9601	Centro	\N
35701	SP	9718	Centro	\N
35702	SP	9616	Centro	\N
35703	SP	9772	Centro	\N
35704	SP	8901	Centro	\N
35705	SP	9483	Centro	\N
35706	SP	9658	Centro	\N
35707	SP	9484	Campo Grande	Cpo Grande
35810	SP	9073	Centro	\N
35811	SP	9139	Terminal Rodoviario	Ter Rodoviario
35812	SP	9148	Centro	\N
35813	SP	9156	Centro	\N
35814	SP	9168	Centro	\N
35815	SP	9186	Centro	\N
35816	SP	9353	Centro	\N
35817	SP	9365	Centro	\N
35818	SP	9191	Centro	\N
35819	SP	9445	Centro	\N
35821	SP	9447	Centro	\N
35822	SP	9220	Centro	\N
35823	SP	9349	Centro	\N
35824	SP	9531	Centro	\N
35825	SP	9538	Centro	\N
35826	SP	9544	Centro	\N
35827	SP	9547	Centro	\N
35828	SP	9624	Centro	\N
35829	SP	8926	Jardim Monte Carlo	Jd Mte Carlo
35830	SP	9313	Centro	\N
35831	SP	8966	Centro	\N
35832	SP	9057	Centro	\N
35833	SP	9062	Centro	\N
35834	SP	9221	Centro	\N
35835	SP	9255	Vila Nova Itatinga	Vl N Itatinga
35836	SP	9310	Centro	\N
35837	SP	9494	Centro	\N
35839	SP	9590	Centro	\N
35840	SP	8926	Jardim Morumbi	Jd Morumbi
35841	SP	9347	Centro	\N
35842	SP	9381	Centro	\N
35843	SP	9392	Centro	\N
35844	SP	9411	Centro	\N
35845	SP	9412	Centro	\N
35846	SP	9437	Centro	\N
35847	SP	9455	Centro	\N
35848	SP	9463	Centro	\N
35849	SP	9481	Centro	\N
35850	SP	9541	Centro	\N
35851	SP	9575	Centro	\N
35853	SP	9581	Centro	\N
35854	SP	9585	Centro	\N
35855	SP	9614	Centro	\N
35856	SP	9635	Centro	\N
35858	SP	9652	Centro	\N
35859	SP	8870	Centro	\N
35860	SP	8894	Centro	\N
35861	SP	8983	Centro	\N
35862	SP	9011	Centro	\N
35863	SP	9014	Centro	\N
35864	SP	9086	Centro	\N
35865	SP	9107	Centro	\N
35866	SP	9128	Centro	\N
35867	SP	9143	Centro	\N
35868	SP	9204	Centro	\N
35869	SP	9217	Centro	\N
35870	SP	9288	Centro	\N
35871	SP	9342	Centro	\N
35872	SP	9343	Centro	\N
35873	SP	9394	Centro	\N
35874	SP	9433	Centro	\N
35875	SP	9490	Centro	\N
35876	SP	9500	Centro	\N
35877	SP	9507	Centro	\N
35878	SP	9591	Centro	\N
35879	SP	9634	Centro	\N
35880	SP	9708	Centro	\N
35881	SP	8926	Cdhu	\N
35882	SP	9723	Centro	\N
35883	SP	9729	Centro	\N
35884	SP	9573	Centro	\N
35885	SP	9129	Centro	\N
35887	SP	9330	Centro	\N
35888	SP	9534	Porto Primavera	Pto Primavera
35890	SP	8926	Nova Assis	N Assis
35894	SP	8926	Patrimônio Bispado	P Bispado
35275	SP	9295	Jardim Merci II	Jd Merci II
35276	SP	9295	Jardim Paulista I	Jd Paulista I
35277	SP	9295	Jardim Pitangueiras II	Jd Pitangueiras II
35278	SP	9295	Vila Arens II	Vl Arens II
35279	SP	9295	Vila Japi II	Vl Japi II
35280	SP	9295	Vila Santana II	Vl Santana II
35281	SP	9295	Uirapuru	\N
35306	SP	9048	Caruara	\N
35533	SP	9625	Jardim Sorocaba	Jd Sorocaba
35534	SP	8916	Centro	\N
35535	SP	8977	Centro	\N
35536	SP	8896	Centro	\N
35537	SP	8942	Centro	\N
35538	SP	9007	Centro	\N
35539	SP	9039	Centro	\N
35540	SP	8918	Centro	\N
35541	SP	9214	Centro	\N
35542	SP	9309	Centro	\N
35543	SP	9314	Centro	\N
35544	SP	9384	Centro	\N
35545	SP	9491	Centro	\N
35546	SP	9395	Centro	\N
35547	SP	9448	Centro	\N
35548	SP	9546	Centro	\N
35549	SP	9574	Centro	\N
35550	SP	9596	Centro	\N
35551	SP	9632	Centro	\N
35552	SP	9639	Centro	\N
35553	SP	9657	Centro	\N
35554	SP	9663	Centro	\N
35555	SP	9690	Centro	\N
35556	SP	8859	Centro	\N
35557	SP	8923	Vila Queiroz	Vl Queiroz
35558	SP	9079	Centro	\N
35559	SP	9110	Centro	\N
35560	SP	9209	Centro	\N
35561	SP	9261	Centro	\N
35562	SP	9273	Centro	\N
35563	SP	9283	Centro	\N
35564	SP	9287	Centro	\N
35565	SP	9323	Vila Nova	Vl Nova
35566	SP	9372	Centro	\N
35567	SP	9376	Centro	\N
35568	SP	9276	Centro	\N
35569	SP	9382	Centro	\N
35570	SP	9388	Centro	\N
35571	SP	9396	Centro	\N
35572	SP	9415	Centro	\N
35573	SP	9469	Centro	\N
35574	SP	8893	Centro	\N
35575	SP	9473	Centro	\N
35576	SP	8862	Centro	\N
35577	SP	8910	Centro	\N
35578	SP	9487	Centro	\N
35579	SP	8919	Centro	\N
35580	SP	9492	Centro	\N
35581	SP	9543	Centro	\N
35582	SP	9628	Centro	\N
35583	SP	8976	Centro	\N
35584	SP	8892	Centro	\N
35585	SP	9029	Centro	\N
35586	SP	8957	Centro	\N
35587	SP	8945	Centro	\N
35588	SP	9000	Centro	\N
35589	SP	9004	Centro	\N
35590	SP	9059	Centro	\N
35591	SP	9165	Centro	\N
35592	SP	9178	Centro	\N
35593	SP	9222	Centro	\N
35594	SP	9225	Centro	\N
35595	SP	9231	Centro	\N
35596	SP	9247	Centro	\N
35597	SP	9519	Centro	\N
35598	SP	9337	Centro	\N
35599	SP	9071	Centro	\N
35600	SP	9075	Centro	\N
35601	SP	9131	Centro	\N
35602	SP	8875	Vila Industrial	Vl Industrial
35603	SP	9196	Centro	\N
35604	SP	9233	Centro	\N
35605	SP	9009	Centro	\N
35606	SP	9517	Centro	\N
35607	SP	9340	Centro	\N
35709	SP	8885	Centro	\N
35710	SP	8937	Centro	\N
35711	SP	8930	Centro	\N
35712	SP	9516	Centro	\N
35713	SP	8941	Centro	\N
35714	SP	9140	Centro	\N
35715	SP	9001	Centro	\N
35716	SP	9017	Centro	\N
35717	SP	9268	Centro	\N
35718	SP	9356	Centro	\N
35719	SP	9367	Centro	\N
35720	SP	9046	Centro	\N
35721	SP	9056	Centro	\N
35722	SP	9080	Centro	\N
35723	SP	9373	Centro	\N
35724	SP	9414	Centro	\N
35725	SP	9127	Centro	\N
35726	SP	9428	Centro	\N
35727	SP	9430	Centro	\N
35728	SP	9152	Centro	\N
35729	SP	9154	Centro	\N
35730	SP	9164	Centro	\N
35731	SP	9169	Centro	\N
35732	SP	9509	Centro	\N
35733	SP	9515	Centro	\N
35734	SP	9195	Centro	\N
35735	SP	9569	Centro	\N
35736	SP	9682	Centro	\N
35737	SP	9291	Centro	\N
35738	SP	9752	Centro	\N
35739	SP	9759	Centro	\N
35740	SP	8897	Centro	\N
35741	SP	9580	Centro	\N
35742	SP	9100	Centro	\N
35743	SP	9171	Centro	\N
35744	SP	9378	Centro	\N
35745	SP	9185	Centro	\N
35746	SP	9397	Centro	\N
35747	SP	9399	Centro	\N
35748	SP	9398	Centro	\N
35749	SP	9403	Centro	\N
35750	SP	9249	Centro	\N
35751	SP	9410	Centro	\N
35752	SP	9332	Centro	\N
35753	SP	9441	Centro	\N
35754	SP	9333	Centro	\N
35755	SP	9443	Centro	\N
35756	SP	9466	Centro	\N
35757	SP	9335	Centro	\N
35758	SP	9357	Centro	\N
35759	SP	9478	Centro	\N
35760	SP	9361	Centro	\N
35761	SP	9454	Centro	\N
35762	SP	9504	Centro	\N
35763	SP	9471	Centro	\N
35764	SP	9522	Centro	\N
35765	SP	9213	Centro	\N
35766	SP	9612	Centro	\N
35767	SP	9577	Centro	\N
35768	SP	9593	Centro	\N
35769	SP	9597	Centro	\N
35770	SP	9621	Centro	\N
35771	SP	9615	Centro	\N
35772	SP	9606	Centro	\N
35773	SP	9644	Centro	\N
35774	SP	9648	Centro	\N
35775	SP	9688	Centro	\N
35776	SP	9698	Centro	\N
35777	SP	9739	Centro	\N
35778	SP	9705	Centro	\N
35779	SP	9715	Centro	\N
35780	SP	9753	Centro	\N
35781	SP	9743	Centro	\N
35782	SP	9757	Centro	\N
35783	SP	9758	Centro	\N
35784	SP	9761	Centro	\N
35785	SP	8975	Centro	\N
35786	SP	9767	Centro	\N
35787	SP	8948	Centro	\N
35788	SP	9099	Centro	\N
35789	SP	9053	Centro	\N
35790	SP	9218	Centro	\N
35791	SP	9762	Centro	\N
35792	SP	9202	Centro	\N
35793	SP	9530	Centro	\N
35794	SP	8965	Centro	\N
35795	SP	8920	Centro	\N
35796	SP	8968	Centro	\N
35797	SP	8972	Centro	\N
35798	SP	8877	Centro	\N
35799	SP	8985	Centro	\N
35800	SP	9034	Centro	\N
35801	SP	9068	Centro	\N
35802	SP	9018	Centro	\N
35803	SP	9033	Centro	\N
35804	SP	9098	Centro	\N
35805	SP	9135	Centro	\N
35806	SP	9179	Centro	\N
35807	SP	9229	Centro	\N
35808	SP	9051	Centro	\N
35809	SP	9065	Centro	\N
35896	SP	8926	Parque Acácias	Prq Acácias
35897	SP	9265	Parque Industrial Bruno Verardino	Prq Ind B Verardino
35898	SP	8933	Loteamento Porto Seguro	Lot Pto Seguro
35899	SP	8933	Jardim Santa Mônica	Jd Sta Mônica
35900	SP	8854	Centro	\N
35901	SP	8871	Centro	\N
35902	SP	8876	Centro	\N
35903	SP	9493	Terras de Piracicaba	T Piracicaba
35904	SP	9493	Jardim Sol Nascente	Jd S Nascente
35905	SP	9370	Jardim Ipê V	Jd Ipê V
35906	SP	9370	Jardim Ipê VI	Jd Ipê VI
35907	SP	9370	Jardim Ipê VII	Jd Ipê VII
35908	SP	9368	Parque das Canoas	Prq Canoas
35909	SP	8989	Parque Residencial Serra Negra	Prq Res S Negra
35910	SP	9295	Bairro do Moisés	B Moisés
35911	SP	9295	Tijuco Preto	T Preto
35913	SP	9660	Chácaras Boa Esperança	C B Esperança
35914	SP	9348	Thomaz Mascaro	T Mascaro
35915	SP	8907	Residencial Jardim Atlântico	Res Jd Atlântico
35916	SP	9295	Jardim Novo Horizonte	Jd N Horizonte
35917	SP	9025	Vila Aeroporto I	Vl Aeroporto I
35922	SP	9025	Núcleo Residencial Vila Vitória	Nuc Res Vl Vitória
35928	SP	8912	Chácara Bela Vista do Chibarro	Ch B V Chibarro
35929	SP	8912	Jardim das Flores	Jd Flores
35931	SP	9183	Aeroporto	\N
35932	SP	9025	Jardim Uruguai	Jd Uruguai
35936	SP	8912	Jardim Veneza	Jd Veneza
35945	SP	9025	Chácara Bela Vista	Ch B Vista
35947	SP	9025	Jardim São Francisco (Sousas)	Jd S Francisco (Sousas)
35948	SP	9435	Jardim Santa Fé IV	Jd Sta Fé IV
35951	SP	9025	Jardim Proença I	Jd Proença I
35952	SP	9025	Sítios de Recreio Novo Gramado	S Rcr N Gramado
35953	SP	9183	Residencial Mazzei	Res Mazzei
36085	SP	9668	Vila Siqueira (Zona Leste)	Vl Siqueira (Z Leste)
36237	SP	9668	Jardim da Laranjeira (Zona Leste)	Jd Laranjeira (Z Leste)
36239	SP	9668	Jardim Bandeirante (São Rafael)	Jd Bandeirante (S Rafael)
36240	SP	9668	Jardim Maria Lídia	Jd M Lídia
36260	SP	9015	Polvilho (Polvilho)	\N
36270	SP	9432	Jardim Primeiro de Maio (Chácara Fazendinha)	Jd P Maio (Ch Fazendinha)
36274	SP	9668	Jardim Limoeiro	Jd Limoeiro
36294	SP	9668	Jardim Alto Alegre (Zona Leste)	Jd At Alegre (Z Leste)
36296	SP	9622	Vila Emplarel	Vl Emplarel
36401	SP	9668	Jardim São João	Jd S João
36402	SP	9668	Vila do Sol	\N
36403	SP	9668	Jardim São João (Zona Leste)	Jd S João (Z Leste)
36405	SP	9668	Jardim Bandeirantes (Zona Norte)	Jd Bandeirantes (Z Norte)
36406	SP	9668	Jardim São Francisco (Zona Leste)	Jd S Francisco (Z Leste)
36459	SP	9094	Parque Industrial	Prq Industrial
35954	SP	9183	Portal dos Gramados	P Gramados
35955	SP	9183	Vila Operária	Vl Operária
35958	SP	8969	Residencial Atenas	Res Atenas
35959	SP	9183	Parque Continental IV	Prq Continental IV
35960	SP	8969	Residencial Portal da Pérola II	Res P Pérola II
35983	SP	8956	Alphaville Conde I	A Conde I
35984	SP	8956	Alphaville Conde II	A Conde II
35985	SP	9622	Parque dos Monteiros I	Prq Monteiros I
35988	SP	8956	Bethaville I	\N
35989	SP	8956	Bethaville II	\N
35990	SP	8956	Centro Comercial Jubran	C C Jubran
35991	SP	9025	Jardim Bonfim I	Jd Bonfim I
35992	SP	9025	Vila Paraíso I	Vl Paraíso I
35993	SP	9239	Parque Horizonte Azul	Prq H Azul
35994	SP	9138	Parque Santa Laura	Prq Sta Laura
36183	SP	9668	Vila Progresso (Zona Norte)	Vl Progresso (Z Norte)
36184	SP	9668	Vila Progresso (Zona Sul)	Vl Progresso (Z Sul)
36339	SP	9668	Jardim São João (Guaianazes)	Jd S João (Guaianazes)
36783	SP	9126	Centro	\N
36784	SP	9564	Centro	\N
36785	SP	9245	Centro	\N
36786	SP	9553	Centro	\N
36902	SP	9521	Centro	\N
37264	SP	9668	Chácara do Sol	Ch Sol
37406	SP	9768	Condomínio Residencial Terras do Caribe	Cond Res T Caribe
37407	SP	9768	Condomínio Residencial Terras do Oriente	Cond Res T Oriente
37557	SP	9095	Centro	\N
37558	SP	9102	Jardim Paulista	Jd Paulista
37559	SP	9105	Centro	\N
37560	SP	9111	Centro	\N
37561	SP	9112	Centro	\N
37562	SP	9115	Centro	\N
37563	SP	9118	Centro	\N
37564	SP	9125	Centro	\N
37566	SP	9025	Horto da Boa Vista	H B Vista
37567	SP	9539	Centro	\N
37568	SP	9548	Centro	\N
37569	SP	9550	Centro	\N
37570	SP	9555	Centro	\N
37571	SP	9558	Centro	\N
37572	SP	9563	Centro	\N
37573	SP	9582	Jardim do Sol	Jd Sol
37574	SP	9162	Centro	\N
37575	SP	9583	Centro	\N
37576	SP	9586	Centro	\N
37577	SP	9592	Centro	\N
37578	SP	9604	Centro	\N
37579	SP	9610	Centro	\N
37580	SP	9184	Centro	\N
37585	SP	9192	Centro	\N
37586	SP	9193	Centro	\N
37587	SP	9560	Jardim Botânico	Jd Botânico
37588	SP	9144	Residencial Colina do Espraiado	Res C Espraiado
37589	SP	9144	Residencial José de Carlos	Res J Carlos
37590	SP	9144	Vila Real	Vl Real
37591	SP	9144	Jardim Pulicano	Jd Pulicano
37592	SP	9144	Jardim Luiza II	Jd Luiza II
37593	SP	9144	Residencial Chico Neca	Res C Neca
37594	SP	9144	Residencial Ana Dorothéa	Res A Dorothéa
37596	SP	8928	Ponte Alta	Pte Alta
37597	SP	9167	Centro	\N
37598	SP	8982	Centro	\N
37599	SP	9199	Centro	\N
37600	SP	9317	Vila Agostinho Francisco de Assis	Vl A F Assis
37601	SP	9208	Centro	\N
37602	SP	9036	Centro	\N
37603	SP	9226	Centro	\N
37604	SP	9235	Centro	\N
37605	SP	9238	Centro	\N
37608	SP	9246	Centro	\N
37609	SP	9262	Centro	\N
37610	SP	9264	Centro	\N
37611	SP	9282	Centro	\N
37612	SP	9286	Centro	\N
37613	SP	9257	Centro	\N
37614	SP	9728	Águas Virtuosas	A Virtuosas
37615	SP	9322	Centro	\N
37617	SP	9255	Engenheiro Serra	Eng Serra
37618	SP	9326	Centro	\N
37619	SP	9344	Centro	\N
37620	SP	9006	Cachoeira de Emas	C Emas
37622	SP	9320	Centro	\N
37624	SP	9232	Centro	\N
37625	SP	9022	Centro	\N
37626	SP	9389	Centro	\N
37629	SP	9358	Centro	\N
37630	SP	9359	Centro	\N
37631	SP	9183	Jardim Guaracy	Jd Guaracy
37632	SP	9059	Turvo	\N
37634	SP	9337	Dona Catarina	Da Catarina
37635	SP	9618	Centro	\N
37636	SP	9626	Centro	\N
37637	SP	9629	Centro	\N
37638	SP	9061	Recreio	\N
37639	SP	9655	Centro	\N
37733	SP	8980	Centro	\N
37734	SP	9489	Pioneiros	\N
37735	SP	9665	Tancredo Neves	T Neves
37736	SP	9407	Socimbra	\N
37737	SP	9471	Dulcelina	\N
37738	SP	9354	Jardim Senhor Bom Jesus	Jd Sr B Jesus
37739	SP	9354	Jardim Esperança	Jd Esperança
37740	SP	8908	Barreirinho	\N
37745	SP	9505	Planalto	\N
37746	SP	8902	Apiaí-Mirim	\N
37747	SP	9066	Centro	\N
37748	SP	9416	Centro	\N
37749	SP	8914	Araxás	\N
37750	SP	9174	Guarapuá	\N
37751	SP	9007	Embaú	\N
37752	SP	9091	Curupá	\N
37753	SP	9228	Irapé	\N
37754	SP	9461	Centro	\N
37755	SP	9269	Centro	\N
37756	SP	9275	Centro	\N
37757	SP	9679	Sapezal	\N
37758	SP	9059	Fazenda Velha	Faz Velha
37759	SP	9123	Centro	\N
37760	SP	9011	Graminha	\N
37761	SP	9263	Iubatinga	\N
37762	SP	9151	Centro	\N
37763	SP	9544	Agisse	\N
37764	SP	9638	Centro	\N
37765	SP	9021	Centro	\N
37766	SP	9779	Centro	\N
37767	SP	9339	Centro	\N
37768	SP	9733	Centro	\N
37769	SP	8938	Centro	\N
37770	SP	8973	Centro	\N
37771	SP	9553	Distrito de Guarapiranga	Dt Guarapiranga
37772	SP	8864	Distrito de Ferraz	Dt Ferraz
37773	SP	9600	Santa Cruz da Estrela	Sta C Estrela
37774	SP	8864	Distrito Ajapi	Dt Ajapi
37775	SP	8999	Centro	\N
37776	SP	9133	Centro	\N
37778	SP	8989	Vila Santa Catarina	Vl Sta Catarina
37779	SP	9532	Parque Residencial Damha II	Prq Res Damha II
37783	SP	9703	Jardim Ana Rosa (Palmeiras)	Jd A Rosa (Palmeiras)
37785	SP	9703	Jardim Ana Rosa	Jd A Rosa
37786	SP	9355	Chácara São Braz	Ch S Braz
37788	SP	9355	Jardim Nilza Miranda	Jd N Miranda
37792	SP	9116	Centro	\N
37793	SP	9141	Floresta do Sul	F Sul
37795	SP	9506	Planalto do Sul	P Sul
37796	SP	9300	Centro	\N
37797	SP	9311	Centro	\N
37798	SP	9350	Centro	\N
37799	SP	8898	Aparecida de Monte Alto	A Mte Alto
37800	SP	9443	Dalas	\N
37802	SP	9613	Santa Maria do Gurupá	Sta M Gurupá
37803	SP	9284	Jatobá	\N
37804	SP	9666	São Martinho D'Oeste	S M D'Oeste
37805	SP	9292	Juliânia	\N
37806	SP	9101	Domélia	\N
37807	SP	9323	Padre Sanches	Pe Sanches
37808	SP	9334	Macucos	\N
37809	SP	9594	Santa América	Sta América
37893	SP	9162	São José do Albertópolis	S J Albertópolis
37894	SP	9391	Centro	\N
37895	SP	8911	Centro	\N
37897	SP	8858	Cascata	\N
37898	SP	8944	Centro	\N
37899	SP	9109	Centro	\N
37900	SP	9731	Centro	\N
37901	SP	9246	Quadro	\N
37902	SP	9716	Centro	\N
37903	SP	9404	Centro	\N
37904	SP	8881	Centro	\N
37905	SP	9364	Primeira Aliança	P Aliança
37906	SP	9364	Segunda Aliança	S Aliança
37907	SP	9422	Oásis	\N
37908	SP	9730	Balneário Mendes Sei	Bal M Sei
37909	SP	9605	Santa Eudóxia	Sta Eudóxia
37910	SP	8856	Água Vermelha	A Vermelha
37911	SP	9691	Simões	\N
37912	SP	8936	Centro	\N
37914	SP	9295	Condomínio Vista Alegre	Cond V Alegre
37915	SP	9121	Esmeralda	\N
37916	SP	9020	Cambaratiba	\N
37917	SP	9266	Jacaré	\N
37918	SP	9485	Laerte Assunção	L Assunção
37919	SP	9485	Azeredo	\N
37920	SP	9485	Marieta Azeredo	M Azeredo
37921	SP	9485	Cícero Prado	C Prado
37922	SP	9485	Mantiqueira	\N
37923	SP	9485	Jardim Regina (Moreira César)	Jd Regina (M César)
37926	SP	8942	Rancho Grande	R Grande
37928	SP	9260	Melissa	\N
37929	SP	9623	Centro	\N
37930	SP	9153	Centro	\N
37931	SP	9564	Taquaral	\N
37932	SP	9496	Pirambóia	\N
37933	SP	8904	Aracaçu	\N
37934	SP	9578	Ruilândia	\N
37935	SP	9054	Catucaba	\N
37936	SP	9513	Vila Barbacena	Vl Barbacena
37938	SP	9575	Caramuru	\N
37939	SP	9545	Centro	\N
37940	SP	9387	Centro	\N
37941	SP	9157	Centro	\N
37942	SP	9158	Centro	\N
37944	SP	9226	Capelinha	\N
37945	SP	9646	Centro	\N
37946	SP	9557	Centro	\N
37947	SP	9727	Centro	\N
37948	SP	9656	Centro	\N
37949	SP	9343	Santa Cruz da Boa Vista	Sta C B Vista
37950	SP	9074	Centro	\N
37951	SP	9768	Roncáglia	\N
37955	SP	9768	Morro das Pedras	Mro Pedras
37958	SP	9295	Parque da Fazenda II	Prq Fazenda II
37959	SP	9640	Jardim Porto Novo	Jd Pto Novo
37962	SP	9183	Jardim Santa Paula	Jd Sta Paula
37965	SP	9560	Central Park	C Park
37482	SP	9668	Recanto Frei Damião	Rec Fr Damião
37489	SP	9189	Jardim Nossa Senhora de Lourdes	Jd N Sra Lourdes
37490	SP	8925	Centro	\N
37492	SP	8950	Centro	\N
37493	SP	8955	Centro	\N
37494	SP	8872	Centro	\N
37495	SP	8884	São Judas Tadeu	S J Tadeu
37496	SP	8906	Centro	\N
37497	SP	8909	Centro	\N
37499	SP	8981	Centro	\N
37501	SP	8986	Centro	\N
37502	SP	9377	Centro	\N
37503	SP	9379	Centro	\N
37504	SP	9386	Centro	\N
37505	SP	9390	Centro	\N
37506	SP	9406	Centro	\N
37507	SP	9407	Centro	\N
37508	SP	9409	Centro	\N
37509	SP	9420	Centro	\N
37510	SP	9421	Centro	\N
37511	SP	9431	Centro	\N
37512	SP	9442	Centro	\N
37513	SP	9449	Centro	\N
37532	SP	9458	Centro	\N
37533	SP	9462	Centro	\N
37538	SP	9485	Vila Suiça	Vl Suiça
37540	SP	9472	Usina Estreito	U Estreito
37541	SP	9474	Centro	\N
37542	SP	9486	Centro	\N
37543	SP	9497	Centro	\N
37544	SP	9503	Centro	\N
37545	SP	9512	Centro	\N
37546	SP	9526	Centro	\N
37547	SP	9485	Castolira	\N
37548	SP	9485	Distrito Industrial	Dt Industrial
37550	SP	8997	Centro	\N
37552	SP	9002	Centro	\N
37553	SP	9050	Centro	\N
37554	SP	9067	Centro	\N
37555	SP	9083	Centro	\N
37556	SP	9084	Centro	\N
37641	SP	9677	Centro	\N
37642	SP	9683	Centro	\N
37643	SP	9061	Paraisolândia	\N
37644	SP	9061	Santa Luzia	Sta Luzia
37645	SP	9685	Centro	\N
37646	SP	9706	Centro	\N
37647	SP	9710	Centro	\N
37649	SP	9298	Duas Barras	D Barras
37651	SP	9262	Aparecida do Alto	A Alto
37652	SP	9599	Centro	\N
37653	SP	9245	Ribeirão da Várzea	R Várzea
37654	SP	9031	Centro	\N
37655	SP	9435	Jardim Primavera	Jd Primavera
37657	SP	9668	Jardim Cidália	Jd Cidália
37658	SP	9668	Cupecê	\N
37659	SP	9537	Centro	\N
37660	SP	9619	Centro	\N
37661	SP	9786	Centro	\N
37662	SP	9771	Centro	\N
37663	SP	9722	Centro	\N
37664	SP	8874	Centro	\N
37665	SP	9205	Centro	\N
37666	SP	9712	Centro	\N
37667	SP	9470	Centro	\N
37668	SP	9603	Centro	\N
37669	SP	9714	Centro	\N
37670	SP	9724	Centro	\N
37671	SP	9732	Centro	\N
37672	SP	9738	Centro	\N
37673	SP	9763	Centro	\N
37674	SP	9252	Cerrado	\N
37675	SP	9784	Centro	\N
37676	SP	9668	Jardim Cupecê	Jd Cupecê
37677	SP	9785	Centro	\N
37678	SP	9790	Centro	\N
37679	SP	9252	Santa Bárbara	Sta Bárbara
37685	SP	9348	Loteamento Residencial Vale do Canaã	Lot Res Vle Canaã
37686	SP	8978	Centro	\N
37687	SP	9004	Pinhal	\N
37688	SP	9657	Formoso	\N
37689	SP	9285	Jardim João Ballan II	Jd J Ballan II
37690	SP	9119	Engenheiro Maia	Eng Maia
37691	SP	9751	Centro	\N
37692	SP	8996	Centro	\N
37693	SP	9649	Centro	\N
37694	SP	9536	Centro	\N
37695	SP	9408	Centro	\N
37696	SP	8899	Centro	\N
37697	SP	9328	Santa Terezinha	Sta Terezinha
37698	SP	9694	Centro	\N
37699	SP	9518	Avecuia do Alto	A Alto
37700	SP	9747	Centro	\N
37701	SP	9272	Centro	\N
37703	SP	9166	Centro	\N
37704	SP	8953	Centro	\N
37705	SP	9154	Nova Palmira	N Palmira
37706	SP	9154	São Luiz do Japiúba	S L Japiúba
37707	SP	9467	Centro	\N
37708	SP	9024	Centro	\N
37709	SP	9041	Centro	\N
37710	SP	8927	Centro	\N
37712	SP	9032	Candia	\N
37713	SP	9224	Centro	\N
37714	SP	9609	Centro	\N
37715	SP	8960	Centro	\N
37716	SP	9424	Mandaguari	\N
37717	SP	9719	Centro	\N
37718	SP	8994	Centro	\N
37719	SP	8900	Centro	\N
37720	SP	9181	Centro	\N
37721	SP	9180	Centro	\N
37722	SP	9305	Centro	\N
37723	SP	9720	Vila Negri	Vl Negri
37724	SP	8908	Povoado de Jundiaqua	P Jundiaqua
37725	SP	9528	Centro	\N
37726	SP	9746	Centro	\N
37727	SP	9340	São Berto	S Berto
37728	SP	9438	Arabá	\N
37819	SP	9529	São Luiz do Guaricanga	S L Guaricanga
37820	SP	9183	Jardim Cristin Alice	Jd C Alice
37827	SP	9492	Batatuba	\N
37833	SP	9295	Vivenda	\N
37834	SP	9295	Condomínio Piemonte	Cond Piemonte
37835	SP	9295	Chácara Companheiros	Ch Companheiros
37836	SP	9295	Recanto da Prata	Rec Prata
37837	SP	9295	Roseira	\N
37838	SP	9295	Fazenda Campo Verde	Faz Cpo Verde
37839	SP	9295	Jardim Tarantela	Jd Tarantela
37840	SP	9495	Corredeira	\N
37841	SP	9495	Santo Antônio da Estiva	Sto A Estiva
37842	SP	9495	Pradínia	\N
37843	SP	8859	Pimentéis	\N
37844	SP	9283	Maracanã	\N
37848	SP	9235	Nova Cardoso	N Cardoso
37850	SP	9363	Miraluz	\N
37851	SP	9715	Ecatu	\N
37852	SP	9027	Campos de Cunha	C Cunha
37853	SP	9215	Indaiá do Aguapeí	I Aguapeí
37854	SP	8929	Atlântida	\N
37855	SP	9194	Ibiporanga	\N
37856	SP	8943	Bandeirantes D'Oeste	B D'Oeste
37857	SP	9383	Monte Verde Paulista	Mte V Paulista
37858	SP	9304	Jurupeba	\N
37859	SP	9106	Duplo Céu	D Céu
37860	SP	8939	Bairro Alto	B Alto
37861	SP	9669	Theodoro de Souza Barros	T S Barros
37862	SP	9023	Centro	\N
37863	SP	8935	Centro	\N
37864	SP	9222	George Oettrer	G Oettrer
37865	SP	8905	Centro	\N
37866	SP	9294	Centro	\N
37867	SP	9465	Centro	\N
37868	SP	9137	Centro	\N
37869	SP	9524	Centro	\N
37870	SP	9438	Centro	\N
37871	SP	9514	Centro	\N
37872	SP	9702	Centro	\N
37873	SP	9117	Centro	\N
37874	SP	9219	Centro	\N
37875	SP	9234	Centro	\N
37876	SP	9297	Centro	\N
37877	SP	9341	Centro	\N
37878	SP	9413	Centro	\N
37879	SP	9427	Centro	\N
37880	SP	9291	Santa Luzia	Sta Luzia
37881	SP	9650	Centro	\N
37882	SP	9699	Centro	\N
37883	SP	9755	Centro	\N
37884	SP	9353	Laranja Doce	L Doce
37885	SP	9302	Centro	\N
37886	SP	9740	Centro	\N
37887	SP	9393	Centro	\N
37888	SP	9147	Centro	\N
37889	SP	9402	Centro	\N
37890	SP	9631	Porto Almeida	Pto Almeida
37891	SP	9783	Capela	\N
37892	SP	9418	Centro	\N
37976	SP	9183	Nova Ponte Alta	N Pte Alta
37977	SP	9668	Vila Guarani(Zona Leste)	Vl Guarani (Z Leste)
37979	SP	9295	Chácara das Videiras	Ch Videiras
37981	SP	9295	Loteamento Bertaci	Lot Bertaci
37982	SP	9668	Jardim Angelina	Jd Angelina
37991	SP	9138	Bairro do Tanquinho	B Tanquinho
37992	SP	9493	Conjunto Habitacional Água Branca	Cj Hab A Branca
37994	SP	9493	Parque Água Branca	Prq A Branca
37995	SP	9493	Jardim Oriente	Jd Oriente
37996	SP	9493	Residencial Serra Verde	Res S Verde
37998	SP	9493	Panorama	\N
37999	SP	9501	Jardim Bela Vista	Jd B Vista
38000	SP	9501	Jardim Cachoeira	Jd Cachoeira
38001	SP	9501	Jardim Europa	Jd Europa
38002	SP	9501	Jardim Limoeiro	Jd Limoeiro
38003	SP	9501	Jardim Nossa Senhora Aparecida	Jd N Sra Aparecida
38004	SP	9501	Jardim São Jorge	Jd S Jorge
38005	SP	9501	Vertentes do Mamonal	V Mamonal
38006	SP	9501	Vila dos Cabos e Taifeiros	Vl C E Taifeiros
38007	SP	9501	Vila dos Oficiais	Vl Oficiais
38008	SP	9501	Vila dos Sargentos e Sub Oficiais	Vl S E S Oficiais
38009	SP	9501	Vila Real	Vl Real
38015	SP	9044	Sítio Pereira Leite	Sit P Leite
38017	SP	9493	Jardim Residencial Javary II	Jd Res Javary II
38457	SP	9237	Centro	\N
38018	SP	9493	Parque Residencial Monte Rey	Prq Res Mte Rey
38019	SP	9493	Jardim Taiguara I	Jd Taiguara I
38020	SP	9493	Residencial Andorinhas	Res Andorinhas
38021	SP	9493	Vila Belém	Vl Belém
38022	SP	9493	Conjunto Residencial Mário Dedini	Cj Res M Dedini
38026	SP	9668	Jardim Almeida	Jd Almeida
38027	SP	9493	Residencial Altos do Piracicaba	Res A Piracicaba
38029	SP	9703	Jardim Santos	Jd Santos
38030	SP	9285	Villagio Di Roma	V Di Roma
38031	SP	9317	Jardim Santa Amália	Jd Sta Amália
38032	SP	9317	Jardim Ernesto Kuhl	Jd E Kuhl
38033	SP	9317	Vila Residencial Treviso	Vl Res Treviso
38034	SP	9317	Vila Fior	Vl Fior
38053	SP	9082	do Apache	Apache
38514	SP	9651	Centro	\N
38515	SP	9308	Centro	\N
38516	SP	9776	Centro	\N
38572	SP	9668	Jardim Brasil (Zona Sul)	Jd Brasil (Z Sul)
39545	SP	9267	Jardim Altos de Santana I	Jd A Santana I
39546	SP	9043	Balneário dos Golfinhos	Bal Golfinhos
39547	SP	9177	Parque Residencial Anna Guilhermina Rois Alves	Prq Res A G R Alves
39548	SP	9177	Parque das Alamedas	Prq Alamedas
39549	SP	9177	Parque Residencial Beira Rio	Prq Res B Rio
39550	SP	9177	Residencial Village Santana	Res V Santana
39555	SP	8912	Jardim Califórnia	Jd Califórnia
39558	SP	8913	Chácara Morada do Sol	Ch M Sol
39559	SP	8913	Jardim Samantha	Jd Samantha
39560	SP	9013	Jardim Marcelino	Jd Marcelino
39565	SP	9668	Jardim Arantes	Jd Arantes
39566	SP	9668	Jardim Vera Cruz	Jd V Cruz
39567	SP	9668	Jardim Vera Cruz(Zona Leste)	Jd V Cruz (Z Leste)
39568	SP	9668	Jardim São Francisco(Zona Sul)	Jd S Francisco (Z Sul)
39570	SP	9668	Chácaras Lago Grande	C Lg Grande
39571	SP	9668	Lagoa Grande	Lga Grande
39587	SP	9044	Alto da Vila Menck	At Vl Menck
39588	SP	9239	Jardim Victória	Jd Victória
39589	SP	9113	Jardim dos Ipês	Jd Ipês
39590	SP	9044	Sítio Guarehy	Sit Guarehy
39596	SP	9013	Vila Gertrudes	Vl Gertrudes
39597	SP	9435	Jardim Ouro Fino	Jd O Fino
40430	SP	9668	Fazenda Caguaçu	Faz Caguaçu
40588	SP	9250	Conjunto Habitacional Jardim Odete II	Cj Hab Jd Odete II
39515	SP	9622	Jardim Rubi	Jd Rubi
39517	SP	9239	Chácara Macedo	Ch Macedo
39518	SP	9113	Jardim Vitória	Jd Vitória
39519	SP	9508	Conjunto Residencial Bela Vista	Cj Res B Vista
40300	SP	9748	Jardim Residencial Aoki	Jd Res Aoki
40301	SP	9668	Jardim Dinar	Jd Dinar
40302	SP	9700	Jardim Dom Bosco I	Jd D Bosco I
40303	SP	9700	Jardim Residencial Parque da Floresta	Jd Res Prq Floresta
40307	SP	9348	São Judas Tadeu	S J Tadeu
40308	SP	9317	Jardim Canaã	Jd Canaã
40309	SP	8992	Chácara Portal das Estâncias	Ch P Estâncias
40311	SP	9447	Vila Nova	Vl Nova
40320	SP	9285	Loteamento Industrial Quinta da Colina	Lot Ind Qta Colina
40449	SP	9355	Jardim Aracy	Jd Aracy
40470	SP	9668	Jardim do Colégio (Zona Norte)	Jd Colégio (Z Norte)
40651	SP	9183	Jardim Munira	Jd Munira
40866	SP	9668	Jardim Marabá(Zona Sul)	Jd Marabá (Z Sul)
40871	SP	9668	Vila Califórnia(Zona Sul)	Vl Califórnia (Z Sul)
41051	SP	9250	Jardim Santa Rita	Jd Sta Rita
41219	SP	9668	Jardim São Paulo(Zona Norte)	Jd S Paulo (Z Norte)
41220	SP	9668	Jardim das Camélias (Zona Sul)	Jd Camélias (Z Sul)
41188	SP	9668	Vila Santa Teresa (Zona Sul)	Vl Sta Teresa (Z Sul)
41559	SP	9668	Jardim das Pedras(Zona Sul)	Jd Pedras (Z Sul)
41566	SP	9013	Cresciúma	\N
41567	SP	9013	Jardim Santo Antônio	Jd Sto Antônio
41760	SP	9668	Jardim Azano I	Jd Azano I
41761	SP	9668	Jardim Azano II	Jd Azano II
41820	SP	9668	Vila União(Zona Norte)	Vl União (Z Norte)
41835	SP	9668	Vila Diva (Zona Norte)	Vl Diva (Z Norte)
42000	SP	9138	Jardim Europa	Jd Europa
42758	SP	9317	Vila Garibaldi	Vl Garibaldi
42759	SP	9317	Jardim Residencial Alto do Flamboyant	Jd Res At Flamboyant
42760	SP	9317	Portal de São Clemente	P S Clemente
42761	SP	9317	Jardim Residencial Graminha II	Jd Res Graminha II
42762	SP	9317	Jardim Residencial Graminha III	Jd Res Graminha III
42763	SP	9317	Jardim Residencial Antônio Simonetti	Jd Res A Simonetti
42764	SP	9317	Jardim Águas da Serra	Jd A Serra
42765	SP	9317	Jardim das Paineiras	Jd Paineiras
42771	SP	9668	Jardim São João (Jaraguá)	Jd S João (Jaraguá)
42981	SP	9216	Jardim Bom Princípio	Jd B Princípio
42982	SP	9216	Jardim Recanto do Valle	Jd Rec Valle
42983	SP	9216	Jardim Vila Paradiso	Jd Vl Paradiso
42984	SP	9216	Jardim do Valle II	Jd Valle II
42985	SP	9216	Jardim Hubert	Jd Hubert
42986	SP	9216	Jardim dos Laranjais	Jd Laranjais
42987	SP	9216	Jardim Europa	Jd Europa
42988	SP	9216	Jardim Europa II	Jd Europa II
42989	SP	9216	Jardim Regente	Jd Regente
42990	SP	9216	Jardim Novo Horizonte	Jd N Horizonte
43060	SP	9696	Jardim Flamboyant	Jd Flamboyant
43061	SP	9696	Jardim Humberto de Campos	Jd H Campos
43067	SP	9659	Jardim Arroyo	Jd Arroyo
43068	SP	9659	Mini Distrito Adail Vetorasso	M Dt A Vetorasso
43069	SP	9659	Residencial Caetano	Res Caetano
43070	SP	9659	Residencial Colorado	Res Colorado
43071	SP	9659	Parque das Aroeiras II	Prq Aroeiras II
43072	SP	9659	Estância Jóckei Club	Etn J Club
43074	SP	8913	Jardim Residencial Pedras Preciosas	Jd Res P Preciosas
43075	SP	8913	Jardim das Nações II	Jd Nações II
43076	SP	8913	Jardim Santo André	Jd Sto André
43077	SP	8913	Jardim Costa Verde	Jd C Verde
43078	SP	8913	Jardim das Nações	Jd Nações
43079	SP	8913	Jardim Haise Maria	Jd H Maria
43080	SP	8913	Jardim Nova Europa	Jd N Europa
43082	SP	8913	Jardim Ouro Verde	Jd O Verde
43083	SP	8913	Jardim Santa Efigênia	Jd Sta Efigênia
43096	SP	8956	Melville Empresarial II	M Empresarial II
43157	SP	9668	Cidade Luz	C Luz
43169	SP	9703	Chácara Boa Vista Palmeiras	Ch B V Palmeiras
43176	SP	9369	Vila Moraes	Vl Moraes
43178	SP	9183	Jardim Mediterrâneo	Jd Mediterrâneo
43356	SP	9025	Chácaras Bocaiúva Nova	C B Nova
43365	SP	9493	Bosque dos Lenheiros	Bsq Lenheiros
43366	SP	9493	Santana	\N
42102	SP	9183	Jardim Aeródromo	Jd Aeródromo
42991	SP	9216	Jardim Sevilha	Jd Sevilha
42992	SP	9183	Sítios de Recreio \\"Rober\\"	S Rcr \\"Rober\\"
42994	SP	9560	Núcleo Vida Nova	Nuc V Nova
42995	SP	9560	Residencial Léo Gomes de Moraes	Res L G Moraes
42996	SP	9560	Distrito Empresarial Prefeito Luiz Roberto Jábali	Dt E Pref L R Jábali
43019	SP	8956	Praça da Aldeia da Serra I	Pç A Serra I
43021	SP	9183	Jardim dos Olivas	Jd Olivas
43023	SP	9177	Cooperi	\N
43024	SP	9005	Santa Luzia	Sta Luzia
43025	SP	9005	Tijuco Preto	T Preto
43026	SP	9005	Residencial Santa Helena	Res Sta Helena
43605	SP	9788	Carafá	\N
43027	SP	9005	Parque Residencial Santo André	Prq Res Sto André
43028	SP	9005	Sítio Portal Vila Rica	Sit P Vl Rica
43039	SP	9005	Village das Flores	V Flores
43044	SP	9696	Jardim Piazza Di Roma II	Jd P Di Roma II
43045	SP	9696	Parque Residencial Villa dos Inglezes	Prq Res V Inglezes
43046	SP	9696	Jardim Wanel Ville IV	Jd W Ville IV
43048	SP	9696	Jardim Rubi	Jd Rubi
43049	SP	9696	Jardim Vila Inglesa	Jd Vl Inglesa
43053	SP	9696	Jardim Primavera	Jd Primavera
43054	SP	9696	Jardim Nilton Torres	Jd N Torres
43055	SP	9696	Jardim Horizonte	Jd Horizonte
43111	SP	9025	Jardim Santa Judith	Jd Sta Judith
43112	SP	9025	Núcleo Residencial Bairro da Conquista/Vila Ypê	Nuc Res B C Ypê
43113	SP	9025	Núcleo Residencial Bairro da Vitória	Nuc Res B Vitória
43114	SP	9025	Techno Park	T Park
43115	SP	9025	Núcleo Residencial Sete de Setembro	Nuc Res S Setembro
43116	SP	9025	Vila Renascença	Vl Renascença
43117	SP	9025	Chácara Mendonça	Ch Mendonça
43118	SP	9025	Vila Chico Amaral	Vl C Amaral
43119	SP	9025	Núcleo Residencial Jossiara	Nuc Res Jossiara
43120	SP	9025	Vila Aero Aeroporto	Vl A Aeroporto
43121	SP	9025	Eldorado dos Carajás	E Carajás
43122	SP	9025	Núcleo Residencial Princesa D'Oeste	Nuc Res Prca D'Oeste
43123	SP	9025	Núcleo Residencial Recanto dos Pássaros	Nuc Res Rec Pássaros
43124	SP	9025	Jardim Alto do Ipaussurama	Jd At Ipaussurama
43125	SP	9025	Núcleo Residencial Novo Ipaussurama	Nuc Res N Ipaussurama
43126	SP	9025	Parque Social	Prq Social
43130	SP	9025	Três Vendas	T Vendas
43131	SP	9025	Pedra Branca	P Branca
43133	SP	9726	Residencial D'Napoli	Res D'Napoli
43134	SP	9726	Jardim Continental	Jd Continental
43137	SP	9660	Residencial Ana Maria	Res A Maria
43138	SP	9660	Jardim Santa Luzia	Jd Sta Luzia
43139	SP	9660	Residencial de Ville	Res Ville
43140	SP	9660	Jardim San Marino	Jd S Marino
43141	SP	9660	Jardim San Rafael	Jd S Rafael
43142	SP	9660	Jardim Mariana I	Jd Mariana I
43143	SP	9660	Jardim Mariana II	Jd Mariana II
43144	SP	9660	Vila Unidos	Vl Unidos
43149	SP	9640	Vila Boa Vista	Vl B Vista
43150	SP	9640	Vila Mariana	Vl Mariana
43151	SP	9640	Golden Park	G Park
43155	SP	9082	do Tijuco Preto	T Preto
43250	SP	9183	Jardim Maria do Carmo	Jd M Carmo
43253	SP	9595	Residencial Parque Rochele II	Res Prq Rochele II
43255	SP	9595	Chácaras Pinheirinho	C Pinheirinho
43258	SP	9087	Vila Comerciários	Vl Comerciários
43267	SP	9267	Vila Pinheiro	Vl Pinheiro
43268	SP	9267	Jardim Novo Amanhecer	Jd N Amanhecer
43279	SP	9183	Conjunto Marcos Freire	Cj M Freire
43280	SP	9668	Jardim Boa Vista (Zona Sul)	Jd Boa Vista
43283	SP	9189	Vila Real Continuaçao	Vl R Continuaçao
43284	SP	9189	Jardim Nova América	Jd N América
43285	SP	9189	Jardim Residencial Firenze	Jd Res Firenze
43292	SP	9025	Núcleo Residencial Três Estrelas	Nuc Res T Estrelas
43367	SP	9493	Santa Olímpia	Sta Olímpia
43368	SP	9493	Jardim Matilde II	Jd Matilde II
43500	SP	9368	Chácara São Pelegrino	Ch S Pelegrino
43501	SP	9368	Chácara São Domingos Shop	Ch S D Shop
43502	SP	9368	Jardim José Justi	Jd J Justi
43503	SP	9368	Conjunto Habitacional Nelson Niero	Cj Hab N Niero
43504	SP	9368	Jardim Planalto Verde	Jd P Verde
43505	SP	9368	Jardim Central Prícoli	Jd C Prícoli
43506	SP	9368	Jardim São José	Jd S José
43507	SP	9368	Jardim José André de Lima	Jd J A Lima
43508	SP	9368	Conjunto Habitacional Francisco Garófalo	Cj Hab F Garófalo
43509	SP	9368	Jardim Colina Verde	Jd C Verde
43510	SP	9368	Jardim das Figueiras	Jd Figueiras
43511	SP	9368	Condomínio Casas do Monte Belo	Cond C Mte Belo
43512	SP	9368	Jardim Santa Luzia	Jd Sta Luzia
43513	SP	9368	Chácara Palmeirinha	Ch Palmeirinha
43514	SP	9368	Chácara dos Ipês	Ch Ipês
43515	SP	9368	Jardim do Imperador	Jd Imperador
43516	SP	9025	Núcleo Residencial Vinte e Oito de Fevereiro	Nuc Res V E O Fevereiro
43525	SP	9768	Loteamento Residencial Água Nova	Lot Res A Nova
43526	SP	9768	Loteamento Porto Seguro Village	Lot Pto S Village
43527	SP	9768	Loteamento Shangrilá	Lot Shangrilá
43528	SP	9768	Contendas	\N
43529	SP	9768	Lopes	\N
43530	SP	9768	Jardim Maria Ilydia	Jd M Ilydia
43531	SP	9725	Residencial Village Vitória	Res V Vitória
43532	SP	9768	Residencial Jardim Paraná	Res Jd Paraná
43533	SP	9725	City Parque	C Parque
43534	SP	9725	Jardim Lageado	Jd Lageado
43535	SP	8907	Residencial e Comercial Carazza	Res E C Carazza
43537	SP	9700	Residencial Bordon	Res Bordon
43539	SP	9493	Alto da Pompéia	At Pompéia
43540	SP	9493	Jardim Santa Ignês I	Jd Sta Ignês I
43541	SP	9493	Jardim Santa Ignês II	Jd Sta Ignês II
43542	SP	9493	Pompéia	\N
43543	SP	9493	Terra Nova	T Nova
43544	SP	9493	Jardim Astúrias I	Jd Astúrias I
43545	SP	9493	Jardim Astúrias II	Jd Astúrias II
43546	SP	9493	Jardim Astúrias III	Jd Astúrias III
43596	SP	9566	Jardim Itapuã	Jd Itapuã
43597	SP	9788	Morros	\N
43598	SP	9788	Bosque São Francisco	Bsq S Francisco
43599	SP	9788	Capoavinha	\N
43600	SP	9788	Conjunto Habitacional Augustinho Kriguer	Cj Hab A Kriguer
43601	SP	9788	Conjunto Habitacional Votorantim C	Cj Hab Votorantim C
43602	SP	9788	Jardim Primavera	Jd Primavera
43603	SP	9788	Jardim Santo Antônio I	Jd Sto Antônio I
43604	SP	9788	Jardim Sarkis Abibe	Jd S Abibe
43606	SP	9788	Parque São João	Prq S João
43607	SP	9788	Residencial Vasques Martins	Res V Martins
43608	SP	9788	Chácaras Leão	C Leão
43609	SP	9295	Vila Anchieta	Vl Anchieta
43610	SP	9295	Portal do Medeiros	P Medeiros
43611	SP	9295	Parque Residencial Jundiaí	Prq Res Jundiaí
43612	SP	9295	Água Doce	A Doce
43613	SP	9295	Bom Jardim	B Jardim
43614	SP	9647	Recanto do Lago	Rec Lago
43615	SP	9370	Jardim Ipê VIII	Jd Ipê VIII
43616	SP	9647	Jardim Maestro Mourão	Jd Mto Mourão
43617	SP	9370	Jardim Guaçuano	Jd Guaçuano
43618	SP	9370	Jardim São Martinho	Jd S Martinho
43619	SP	9370	Jardim São José	Jd S José
43620	SP	9370	Jardim Boa Esperança	Jd B Esperança
43621	SP	9370	Jardim Santa Marta	Jd Sta Marta
43622	SP	9647	Jardim Recanto do Bosque	Jd Rec Bosque
43623	SP	9370	Jardim Alto dos Ypês	Jd At Ypês
43624	SP	9647	Jardim Almeida	Jd Almeida
43625	SP	9370	Jardim Boa Vista	Jd B Vista
43626	SP	9370	Jardim Suécia	Jd Suécia
43627	SP	9370	Jardim Victória	Jd Victória
43628	SP	9647	Jardim Amoreiras	Jd Amoreiras
43629	SP	9370	Jardim Pansani	Jd Pansani
43630	SP	9370	Parque Residencial Nova Canaã	Prq Res N Canaã
43631	SP	9025	Vila Marta	Vl Marta
43632	SP	9370	Parque Industrial João Batista Caruso	Prq Ind J B Caruso
43633	SP	9370	Chácara Ouro Preto	Ch O Preto
43634	SP	9726	Conjunto Habitacional Água Quente	Cj Hab A Quente
43635	SP	9254	Recanto do Parque	Rec Parque
43636	SP	9037	Vila Brasil	Vl Brasil
43637	SP	9643	Residencial Parque Douradinho	Res Prq Douradinho
43638	SP	9643	Jardim Veneza	Jd Veneza
43741	SP	9025	Residencial Nova Bandeirante	Res N Bandeirante
43743	SP	9659	Chácara Jockey Club (Zona Rural)	Ch J Club (Z Rural)
43744	SP	9659	Morada Campestre	M Campestre
43745	SP	9659	Estância Recreio (Zona Rural)	Etn Recreio (Z Rural)
43746	SP	9659	Estância Santa Luzia (Zona Rural)	Etn Sta Luzia (Z Rural)
43747	SP	9659	Chácara Recreio Parque do Sabiá (Zona Rural)	Ch Rcr Prq Sabiá (Z Rural)
43748	SP	9659	Fazenda Retiro (Zona Rural)	Faz Retiro (Z Rural)
43749	SP	9659	Chácara Recreio Terras de São José (Zona Rural)	Ch Rcr T S José (Z Rural)
43750	SP	9659	Chácaras de Recreio Felicidade (Zona Rural)	C Rcr Felicidade (Z Rural)
43751	SP	9659	Estância Santa Helena	Etn Sta Helena
43752	SP	9659	Fazenda Piedade (Zona Rural)	Faz Piedade (Z Rural)
43753	SP	9659	Residencial Floresta Park (Zona Rural)	Res F Park (Z Rural)
43754	SP	9659	Estância Vista Bonita (Zona Rural)	Etn V Bonita (Z Rural)
43755	SP	9659	Estância São Carlos (Zona Rural)	Etn S Carlos (Z Rural)
43756	SP	9659	Estância Nossa Senhora Aparecida (Zona Rural)	Etn N Sra Aparecida (Z Rural)
43757	SP	9659	Estância Bela Vista (Zona Rural)	Etn B Vista (Z Rural)
43457	SP	9668	Vila Renato (Zona Leste)	Vl Renato (Z Leste)
43463	SP	9587	Jardim Santa Rita	Jd Sta Rita
43464	SP	9587	Jardim Sol D'Icaraí	Jd S D'Icaraí
43465	SP	9587	Terras de Mont Serrat	T M Serrat
43466	SP	9587	Residencial Fabbri	Res Fabbri
43467	SP	9370	Jardim Hermínio Bueno	Jd H Bueno
43470	SP	9295	Aldeia Primavera	A Primavera
43473	SP	9260	Chácaras Agrícolas Bandeirantes	C A Bandeirantes
43474	SP	9260	Vila Residencial São Domingos	Vl Res S Domingos
43482	SP	9725	Jardins de Tatuí	J Tatuí
43483	SP	9725	Residencial Donato Flores	Res D Flores
43484	SP	9725	Residencial Vice-Prefeito Nelson Fiuza	Res V-Pref N Fiuza
43485	SP	9725	Loteamento Empresarial Tatuí-I	Lot E Tatuí-I
43486	SP	8891	Residencial Nova Canaã	Res N Canaã
43487	SP	8891	Jardim Bela Vista	Jd B Vista
43489	SP	8969	Residencial Modelo	Res Modelo
43491	SP	9725	San Marino	S Marino
43547	SP	9493	Residencial Nova Água Branca II	Res N A Branca II
43548	SP	9493	Prezoto	\N
43549	SP	9493	Jardim Borghesi	Jd Borghesi
43550	SP	9493	Sertãozinho	\N
43551	SP	9493	Jardim Aman	Jd Aman
43552	SP	9493	Chácaras Água Branca	C A Branca
43553	SP	9493	Chicó	\N
43554	SP	9493	Irmãos Camolesi	Imos Camolesi
43555	SP	9493	Residencial Bela Vista	Res B Vista
43556	SP	9493	Jardim Água Viva	Jd A Viva
43557	SP	9493	Residencial Itaporanga	Res Itaporanga
43558	SP	9493	Jardim Modelo	Jd Modelo
43559	SP	9493	Loteamento Chácaras Nazareth II	Lot C Nazareth II
43560	SP	9493	Residencial Santo Antônio	Res Sto Antônio
43563	SP	9242	Jardim Santa Marina	Jd Sta Marina
43564	SP	9242	Jardim São Paulo	Jd S Paulo
43571	SP	9026	Vila Ipê (Botujuru)	Vl Ipê (Botujuru)
43572	SP	9026	Privê Gramados de Santa Rita	P G Sta Rita
43575	SP	9244	Parque Residencial Braz Cavenaghi	Prq Res B Cavenaghi
43576	SP	9244	Loteamento Popular Istor Luppi	Lot P I Luppi
43577	SP	9244	Parque Santa Bárbara	Prq Sta Bárbara
43579	SP	9371	Distrito Industrial II	Dt Industrial II
43580	SP	9371	Chácaras Sol Nascente	C S Nascente
43581	SP	9371	Chácaras São Francisco	C S Francisco
43582	SP	9371	Jardim Europa	Jd Europa
43583	SP	9371	Loteamento Linda Chaib	Lot L Chaib
43584	SP	9371	Condomínio Santa Mônica	Cond Sta Mônica
43585	SP	9371	Condomínio Santa Úrsula	Cond Sta Úrsula
43586	SP	9371	Paraíso da Cachoeira	P Cachoeira
43591	SP	9501	Jardim Anversa	Jd Anversa
43592	SP	9285	Conjunto Residencial Bernardi	Cj Res Bernardi
43593	SP	8907	Machado de Mello	M Mello
43594	SP	9240	Morada do Sol	M Sol
43595	SP	9566	Residencial dos Bosques	Res Bosques
49758	SP	8928	Marmeleiro	\N
43645	SP	9660	Jardim São José Leste	Jd S J Leste
43646	SP	9660	Residencial Dom Bosco	Res D Bosco
43647	SP	9660	Portal de Minas	P Minas
43650	SP	9043	Jardim Mariella	Jd Mariella
43651	SP	9643	Jardim Novo Horizonte	Jd N Horizonte
43652	SP	9317	Residencial Nobreville	Res Nobreville
43653	SP	9317	Residencial Jardim dos Ipês	Res Jd Ipês
43662	SP	9560	Parque dos Sabiás	Prq Sabiás
43663	SP	8912	Jardim Uirapuru II	Jd Uirapuru II
43664	SP	8912	Jardim Victório Antônio de Santi II	Jd V A Santi II
43665	SP	8912	Portal das Araucárias	P Araucárias
43666	SP	8912	Recanto dos Nobres	Rec Nobres
43667	SP	9354	Residencial Maria Cândida	Res M Cândida
43670	SP	9686	Jardim Amália	Jd Amália
43671	SP	9686	Jardim Carlos Cézar Sacomani	Jd C C Sacomani
43672	SP	9686	Jardim Santa Clara	Jd Sta Clara
43673	SP	9686	Jardim Vitória	Jd Vitória
43674	SP	9686	Salomão Zatiti	S Zatiti
43675	SP	9265	Jardim São Paulo	Jd S Paulo
43676	SP	9144	Jardim Paulo Archetti	Jd P Archetti
43677	SP	9144	Jardim Vera Cruz III	Jd V Cruz III
43678	SP	9144	Residencial Amazonas	Res Amazonas
43679	SP	9144	Residencial Dourado	Res Dourado
43680	SP	9144	Residencial Júlio D'Élia	Res J D'Élia
43681	SP	9560	Jardim Porto Seguro	Jd Pto Seguro
43682	SP	9560	Residencial Morro do Ipê	Res Mro Ipê
43683	SP	9560	Jardim Ouro Branco	Jd O Branco
43684	SP	9144	Residencial São Vicente	Res S Vicente
43685	SP	9144	Vila Monte Verde	Vl Mte Verde
43697	SP	9052	Residencial Moreschi	Res Moreschi
43698	SP	8949	Jardim Vista Alegre	Jd V Alegre
43758	SP	9659	Estância Pousada dos Pássaros (Zona Rural)	Etn P Pássaros (Z Rural)
43759	SP	9659	Estância Todos os Santos (Zona Rural)	Etn T O Santos (Z Rural)
43760	SP	9659	Estância Santa Edwirges (Zona Rural)	Etn Sta Edwirges (Z Rural)
43761	SP	9659	Fazenda Vista Alegre (Zona Rural)	Faz V Alegre (Z Rural)
43762	SP	9659	Estância Alvorada (Zona Rural)	Etn Alvorada (Z Rural)
43763	SP	9659	Jardim Jéssica (Zona Rural)	Jd Jéssica (Z Rural)
43764	SP	9659	Estância Suíça (Zona Rural)	Etn Suíça (Z Rural)
43765	SP	9659	Fazenda São Pedro (Zona Rural)	Faz S Pedro (Z Rural)
43766	SP	9659	Estância São Pedro II (Zona Rural)	Etn S Pedro II (Z Rural)
43767	SP	9659	Recanto das Aves (Zona Rural)	Rec Aves (Z Rural)
43768	SP	9659	Condomínio São Luiz (Zona Rural)	Cond S Luiz (Z Rural)
43769	SP	9659	Loteamento Galiléia (Zona Rural)	Lot Galiléia (Z Rural)
43770	SP	9659	Loteamento Oásis (Zona Rural)	Lot Oásis (Z Rural)
43771	SP	9659	Estância Beira-Rio (Zona Rural)	Etn Beira-Rio (Z Rural)
43772	SP	9659	Estância São Felício (Zona Rural)	Etn S Felício (Z Rural)
43773	SP	9659	Estância São Pedro I (Zona Rural)	Etn S Pedro I (Z Rural)
43774	SP	9659	Condomínio Nossa Senhora de Lourdes (Zona Rural)	Cond N Sra Lourdes (Z Rural)
43775	SP	9659	Condomínio Morada do Sol (Zona Rural)	Cond M Sol (Z Rural)
43776	SP	9659	Residencial Bela Vista I (Zona Rural)	Res B Vista I (Z Rural)
43777	SP	9659	Residencial Bela Vista II (Zona Rural)	Res B Vista II (Z Rural)
43778	SP	9659	Residencial Cavalari (Zona Rural)	Res Cavalari (Z Rural)
43779	SP	9659	Estância Santa Ana (Zona Rural)	Etn Sta Ana (Z Rural)
43780	SP	9659	Fazenda Velha (Zona Rural)	Faz Velha (Z Rural)
43781	SP	9659	Estância Santa Clara (Zona Rural)	Etn Sta Clara (Z Rural)
43782	SP	9659	Estância Bosque Verde (Zona Rural)	Etn Bsq Verde (Z Rural)
43783	SP	9659	Estância Vitória (Zona Rural)	Etn Vitória (Z Rural)
43784	SP	9659	Estância Gramado (Zona Rural)	Etn Gramado (Z Rural)
43785	SP	9659	Estância Primavera (Zona Rural)	Etn Primavera (Z Rural)
43786	SP	9659	Estância San Carlos (Zona Rural)	Etn San Carlos
43819	SP	9659	Estância Ivone (Zona Rural)	Etn Ivone (Z Rural)
43820	SP	9659	Recanto São Lucas (Zona Rural)	Rec S Lucas (Z Rural)
43821	SP	9659	Estância Unitra (Zona Rural)	Etn Unitra (Z Rural)
43822	SP	9659	Fazenda Palmeira (Zona Rural)	Faz Palmeira (Z Rural)
43823	SP	9659	Jardim Veneza (Zona Rural)	Jd Veneza (Z Rural)
43824	SP	9659	Condomínio Vila Velha (Zona Rural)	Cond Vl Velha (Z Rural)
43825	SP	9659	Condomínio João Bernardino Souza (Zona Rural)	Cond J B Souza (Z Rural)
43826	SP	9659	Estância Nova  Veneza (Zona Rural)	Etn N Veneza (Z Rural)
43827	SP	9659	Estância São Pedro (Zona Rural)	Etn S Pedro (Z Rural)
43828	SP	9659	Estância Alto Giro (Zona Rural)	Etn At Giro (Z Rural)
43829	SP	9659	Estância Santa Maria (Zona Rural)	Etn Sta Maria (Z Rural)
43830	SP	9659	Estância São Marcos II e IV (Zona Rural)	Etn S M II e IV (Z Rural)
43831	SP	9659	Estância Chácara Santa Inês (Zona Rural)	Etn Ch Sta Inês (Z Rural)
43832	SP	9659	Residencial Vista Alegre I (Zona Rural)	Res V Alegre I (Z Rural)
43833	SP	9659	Estância Parque Azul (Zona Rural)	Etn Prq Azul (Z Rural)
43834	SP	9659	Parque das Nascentes (Zona Rural)	Prq Nascentes (Z Rural)
43835	SP	9659	Estância Navarrete (Zona Rural)	Etn Navarrete (Z Rural)
43836	SP	9659	Vila Azul (Zona Rural)	Vl Azul (Z Rural)
43837	SP	9659	Estância Vila Azul (Zona Rural)	Etn Vl Azul (Z Rural)
43838	SP	9659	Estância Sobrinho (Zona Rural)	Etn Sobrinho (Z Rural)
43839	SP	9659	Condomínio São Miguel Arcanjo (Zona Rural)	Cond S M Arcanjo (Z Rural)
43840	SP	9659	Estância Santa Apolônia (Zona Rural)	Etn Sta Apolônia (Z Rural)
43841	SP	9659	Estância Matinha (Zona Rural)	Etn Matinha (Z Rural)
43842	SP	9659	Fazenda Palhinha (Zona Rural)	Faz Palhinha (Z Rural)
43843	SP	9659	Estância Santo Antônio (Zona Rural)	Etn Sto Antônio (Z Rural)
43844	SP	9371	Martim Francisco	M Francisco
43845	SP	9371	Jardim Mandaio (Martim Francisco)	Jd Mandaio (M Francisco)
49759	SP	9668	Recanto Alegre	Rec Alegre
43846	SP	9659	Estância Chácara Primavera (Zona Rural)	Etn Ch Primavera (Z Rural)
43847	SP	9659	Chácara Recreio Nossa Senhora do Líbano (Zona Rural)	Ch Rcr N Sra Líbano (Z Rural)
44034	SP	9174	Centro	\N
44035	SP	9668	Jardim Ipanema (Cidade Líder)	Jd Ipanema (C Líder)
44066	SP	9183	Água Chata	A Chata
44067	SP	9183	Vale dos Machados	Vle Machados
44082	SP	9554	Itaboa	\N
44083	SP	9554	Campina de Fora	C Fora
44220	SP	9177	Vila Bela	Vl Bela
44222	SP	9668	Jardim Lourdes (Zona Sul)	Jd Lourdes (Z Sul)
44226	SP	9183	Sítio São Francisco	Sit S Francisco
44228	SP	9369	Loteamento Rio Acima	Lot R Acima
44229	SP	9369	Núcleo Industrial Vereador Alcides Celestino Filho	Nuc Ind Ver A C Filho
44231	SP	8913	Desmembramento Fachini	D Fachini
44232	SP	9317	Jardim Residencial Antonio Simonetti II	Jd Res A Simonetti II
44233	SP	9317	Jardim Residencial Antonio Simonetti III	Jd Res A Simonetti III
44234	SP	9508	Jardim Tamandaré	Jd Tamandaré
44235	SP	9668	Chácara do Conde	Ch Conde
44240	SP	9660	Vila Cândida	Vl Cândida
44242	SP	9370	Jardim Chaparral	Jd Chaparral
44246	SP	9622	Vila Nova	Vl Nova
44247	SP	9493	Castelinho	\N
44248	SP	9725	Pederneiras	\N
44249	SP	8933	Jardim Santa Mônica IV	Jd Sta Mônica IV
44250	SP	8933	Jardim Santa Mônica III	Jd Sta Mônica III
44251	SP	8933	Jardim Santa Mônica II	Jd Sta Mônica II
44271	SP	9177	Vila Alves	Vl Alves
44272	SP	9177	Jardim Modelo	Jd Modelo
43791	SP	9659	Estância Verão (Zona Rural)	Etn Verão (Z Rural)
43792	SP	9659	São Benedito da Capelinha (Zona Rural)	S B Capelinha (Z Rural)
43793	SP	9659	Pica-pau-amarelo (Zona Rural)	Pica-pau-amarelo (Z Rural)
43794	SP	9659	Estância São Judas Tadeu (Zona Rural)	Etn S J Tadeu (Z Rural)
43795	SP	9659	Estância Santa Paula (Zona Rural)	Etn Sta Paula (Z Rural)
43796	SP	9659	Condomínio Vera Cruz (Zona Rural)	Cond V Cruz (Z Rural)
43797	SP	9659	Estância São Manoel (Zona Rural)	Etn S Manoel (Z Rural)
43798	SP	9659	Estância Raquel (Zona Rural)	Etn Raquel (Z Rural)
43799	SP	9659	Estância Santa Rita (Zona Rural)	Etn Sta Rita (Z Rural)
43800	SP	9659	Estância Sossego (Zona Rural)	Etn Sossego (Z Rural)
43801	SP	9659	Estância Pingo D'Água (Zona Rural)	Etn P D'Água (Z Rural)
43802	SP	9659	Terra de São Lucas (Zona Rural)	T S Lucas (Z Rural)
43803	SP	9659	Loteamento São Roque (Z Rural)	Lot S Roque (Z Rural)
43804	SP	9659	Estância São Francisco (Zona Rural)	Etn S Francisco (Z Rural)
43805	SP	9659	Estância Nossa Senhora de Fátima (Zona Rural)	Etn N Sra Fátima (Z Rural)
43806	SP	9659	Estância dos Manacáz (Zona Rural)	Etn Manacáz (Z Rural)
43807	SP	9659	Estância Santa Catarina (Zona Rural)	Etn Sta Catarina (Z Rural)
43808	SP	9659	Residencial Ana Cláudia (Zona Rural)	Res A Cláudia (Z Rural)
43809	SP	9659	Estância Bela Vista III (Zona Rural)	Etn B Vista III (Z Rural)
43810	SP	9659	Loteamento Edem Leste (Zona Rural)	Lot E Leste (Z Rural)
43811	SP	9659	Fazenda da Mata (Zona Rural)	Faz Mata (Z Rural)
43812	SP	9659	Fazenda Monte Alto (Zona Rural)	Faz Mte Alto (Z Rural)
43813	SP	9659	Estância Pica-pau-amarelo (Zona Rural)	Etn Pica-pau-amarelo (Z Rural)
43814	SP	9659	Recanto Feliz (Zona Rural)	Rec Feliz (Z Rural)
43815	SP	9659	Condomínio São João II (Zona Rural)	Cond S João II (Z Rural)
43816	SP	9659	Condomínio São João I (Zona Rural)	Cond S João I (Z Rural)
43818	SP	9659	Fazenda Felicidade (Zona Rural)	Faz Felicidade (Z Rural)
43848	SP	9659	Estância Santa Inês (Zona Rural)	Etn Sta Inês (Z Rural)
43849	SP	9659	Estância Chácara Gramado (Zona Rural)	Etn Ch Gramado (Z Rural)
43850	SP	9659	Estância Chácara Santo Antônio (Zona Rural)	Etn Ch Sto Antônio (Z Rural)
43851	SP	9659	Residencial Vista Alegre II e III (Zona Rural)	Res V A II e III (Z Rural)
43859	SP	9668	Jardim Santa Terezinha (Pedreira)	Jd Sta Terezinha (Pedreira)
43861	SP	9783	Centro	\N
43862	SP	9783	Jardim Itália	Jd Itália
43874	SP	9668	Jardim das Oliveiras (Zona Sul)	Jd Oliveiras (Z Sul)
43991	SP	9668	Jardim Novo Lar	Jd Novo Lar
43993	SP	9625	Cata Preta	C Preta
43995	SP	9082	Jardim Primavera	Jd Primavera
43996	SP	9668	Jardim Beatriz (Zona Leste)	Jd Beatriz (Z Leste)
43997	SP	9668	Vila Arco Íris	Vl A Íris
43998	SP	9668	Jardim Vergueiro	Jd Vergueiro
43999	SP	9668	Jardim Myrna II	Jd Myrna II
44003	SP	9668	Jardim Itapema	Jd Itapema
44017	SP	9668	Jardim Brasília (Zona Norte)	Jd Brasília (Z Norte)
44018	SP	9668	Jardim Brasília	Jd Brasília
44023	SP	9658	Vila Maschieto	Vl Maschieto
44291	SP	9660	Jardim Guimarães	Jd Guimarães
44292	SP	8912	Jardim Gardênias	Jd Gardênias
44294	SP	9673	Boiçucanga	\N
44295	SP	9673	Juquey	\N
44296	SP	9757	Vila Maria	Vl Maria
45878	SP	9668	Jardim Santa Cruz (Campo Grande)	Jd Sta Cruz (Cpo Grande)
45879	SP	9668	Jardim Ubirajara (Zona Sul)	Jd Ubirajara (Z Sul)
45880	SP	9267	Jardim Marcondes	Jd Marcondes
45881	SP	9726	Residencial Novo Horizonte	Res N Horizonte
45882	SP	9447	Roseta	\N
45884	SP	9317	Jardim José Cortez	Jd J Cortez
45885	SP	9370	Loteamento Morro Amarelo	Lot Mro Amarelo
45886	SP	8883	Jardim Governador Mário Covas II	Jd Gov M Covas II
45887	SP	8883	Jardim Governador Mário Covas III	Jd Gov M Covas III
45891	SP	9369	Cidade Jardim	C Jardim
45894	SP	9668	Parque Santa Cecília (Grajaú)	Prq Sta Cecília (Grajaú)
45896	SP	9183	Parque das Seringueiras	Prq Seringueiras
45897	SP	9369	Residencial Novo Horizonte I	Res N Horizonte I
45898	SP	9250	Jardim Roseli	Jd Roseli
45899	SP	9250	Jardim Maria Rosa	Jd M Rosa
45900	SP	9250	Jardim Maria Rosa II	Jd M Rosa II
45901	SP	9250	Jardim Tamem	Jd Tamem
45906	SP	9432	Bonfim	\N
45907	SP	9432	Cidade das Flores	C Flores
45910	SP	9432	Industrial Remédios	Ind Remédios
45915	SP	9177	Vila Eliana Maria	Vl E Maria
45919	SP	9432	São Pedro	S Pedro
46509	SP	9493	Jardim Paraíso	Jd Paraíso
46511	SP	9493	Parque dos Sabiás	Prq Sabiás
46513	SP	9700	Jardim Casa Verde	Jd C Verde
46675	SP	9485	Residencial Nova Esperança	Res N Esperança
46680	SP	9625	Parque Gerassi	Prq Gerassi
46681	SP	9560	Bosque das Juritis	Bsq Juritis
46682	SP	8928	Ressaca	\N
48108	SP	9668	Jardim Santa Cruz (Parelheiros)	Jd Sta Cruz (Parelheiros)
48113	SP	9668	Jardim Jaraguá (São Domingos)	Jd Jaraguá (S Domingos)
48114	SP	9668	Parque Anhangüera (São Domingos)	Prq Anhangüera (S Domingos)
48115	SP	9668	Jardim São José (Artur Alvim)	Jd S José (A Alvim)
48116	SP	9668	Jardim São José (São Mateus)	Jd S José (S Mateus)
48117	SP	9668	Jardim São José	Jd S José
48118	SP	9668	Vila São José (Ipiranga)	Vl S José (Ipiranga)
48119	SP	9668	Vila São José (Cidade Dutra)	Vl S José (C Dutra)
48120	SP	9668	Vila São José (Itaim Paulista)	Vl S José (I Paulista)
48121	SP	9668	Vila São José (Guaianazes)	Vl S José (Guaianazes)
48125	SP	9668	Jardim Santo Elias (São Miguel)	Jd Sto Elias (S Miguel)
48462	SP	8933	Conjunto Habitacional Camargo	Cj Hab Camargo
48463	SP	9026	Jardim Amarilis	Jd Amarilis
48464	SP	9647	Riviera de São João	R S João
48467	SP	8928	Parque Arco Iris	Prq A Iris
48516	SP	9370	Chácaras Paraíso das Samambaias	C P Samambaias
48517	SP	9370	Chácara Alvorada	Ch Alvorada
48518	SP	9668	Vila Santa Cruz	Vl Sta Cruz
48519	SP	8961	Residencial Tivoli II	Res Tivoli II
48520	SP	9370	Parque Residencial Murayama	Prq Res Murayama
48521	SP	9370	Jardim Murayama	Jd Murayama
48524	SP	9144	Polo Industrial São Bernardo	P Ind S Bernardo
48527	SP	9700	Jardim Maria Luíza	Jd M Luíza
48528	SP	9700	Jardim dos Ipês	Jd Ipês
48545	SP	8928	Laranja Azeda	L Azeda
48550	SP	9668	Vila Aurora	Vl Aurora
48551	SP	9668	Jardim Panorama (Zona Leste)	Jd Panorama (Z Leste)
48552	SP	9668	Jardim Panorama (Zona Sul)	Jd Panorama (Z Sul)
48553	SP	9668	Jardim Esmeralda (Zona Sul)	Jd Esmeralda (Z Sul)
48554	SP	9622	Jardim Clementino (Fazendinha)	Jd Clementino (Fazendinha)
48555	SP	9728	Ribeirão Bonito	R Bonito
48592	SP	8956	Parque Esmeralda	Prq Esmeralda
48595	SP	9622	Alphaville	\N
48597	SP	9668	Vila Bruna	Vl Bruna
48599	SP	9659	Residencial Marcia	Res Marcia
48600	SP	9659	Recanto Real	Rec Real
48602	SP	9659	Loteamento Pazote (Zona Rural)	Lot Pazote (Z Rural)
45006	SP	9668	Jardim Vera Cruz (Parelheiros)	Jd V Cruz (Parelheiros)
45867	SP	9668	Parque Cruzeiro do Sul (Vila Formosa)	Prq C Sul (Vl Formosa)
45869	SP	9703	Jardim Quaresmeira	Jd Quaresmeira
45874	SP	9668	Jardim Roschel	Jd Roschel
45875	SP	9216	Sítios de Recreio Jardins de Itaici	S Rcr J Itaici
45876	SP	8883	Jardim Imperador	Jd Imperador
45953	SP	9668	Jardim Santa Cruz (Sacomã)	Jd Sta Cruz (Sacomã)
45954	SP	9726	Jardim América	Jd América
45955	SP	9700	Jardim Recanto dos Sonhos	Jd Rec Sonhos
45956	SP	9216	Jardim Esplanada II	Jd Esplanada II
45957	SP	9668	Jardim Oriental (Parelheiros)	Jd Oriental (Parelheiros)
45959	SP	8912	Vila Flórida	Vl Flórida
45961	SP	9668	Vila São Silvestre (Zona Leste)	Vl S Silvestre (Z Leste)
45962	SP	9369	Residencial Colinas	Res Colinas
45964	SP	9145	Jardim Nossa Senhora do Rosário	Jd N Sra Rosário
45965	SP	9145	Parque São Joaquim	Prq S Joaquim
45966	SP	9145	Vila São Jorge	Vl S Jorge
45976	SP	8954	Residencial Ide Daher	Res I Daher
46486	SP	9354	Residencial Beniamino Cadioli	Res B Cadioli
46504	SP	9660	Jardim Souto	Jd Souto
48468	SP	9668	Jardim Jaraguá (Itaim Paulista)	Jd Jaraguá (I Paulista)
48469	SP	9501	Parque Clayton Malaman	Prq C Malaman
48470	SP	9216	Jardim Valença	Jd Valença
48471	SP	9216	Colinas de Indaiatuba II	C Indaiatuba II
48472	SP	9315	Residencial Rocco Lenci	Res R Lenci
48473	SP	8913	Jardim Morumbi	Jd Morumbi
48474	SP	8913	Distrito Industrial IV	Dt Industrial IV
48476	SP	8956	Parque das Nações	Prq Nações
48478	SP	8912	Jardim Magnólias	Jd Magnólias
48479	SP	9250	Jardim Morada Feliz	Jd M Feliz
48480	SP	9250	Jardim Serra Dourada	Jd S Dourada
48481	SP	9138	Jardim Oséias Genuíno	Jd O Genuíno
48482	SP	9138	Jardim Recanto dos Pássaros	Jd Rec Pássaros
48483	SP	9138	Conjunto Residencial Itajuíbe	Cj Res Itajuíbe
48484	SP	9138	CDHU Fazenda Itajuíbe	C Faz Itajuíbe
48485	SP	9668	Jardim das Fontes	Jd Fontes
48488	SP	9183	Jardim Kátia	Jd Kátia
48500	SP	9005	Vila Pantaleão	Vl Pantaleão
48502	SP	9696	Granja Olga II	Gja Olga II
48507	SP	9371	Parque Residencial Murayama	Prq Res Murayama
48508	SP	9370	Jardim Santa Cecília	Jd Sta Cecília
48509	SP	9726	Distrito Industrial do Una II	Dt Ind Una II
48510	SP	9370	Parque Industrial Getúlio Vargas	Prq Ind G Vargas
48511	SP	9370	Parque Industrial Getúlio Vargas II	Prq Ind G Vargas II
48512	SP	9370	Parque Industrial Mogi Guaçu	Prq Ind M Guaçu
48513	SP	9370	Distrito Industrial IV	Dt Industrial IV
48514	SP	9370	Chácaras Horizonte Azul	C H Azul
48515	SP	9370	Chácaras Paraíso dos Pescadores	C P Pescadores
48603	SP	9659	Estância Ponte Grande (Zona Rural)	Etn Pte Grande (Z Rural)
48604	SP	9659	Parque Belvedere	Prq Belvedere
48605	SP	9659	Parque Residencial Universo	Prq Res Universo
48606	SP	9659	Jardim Astúrias	Jd Astúrias
48607	SP	9659	Condomínio Vilage La Montagne	Cond V L Montagne
48608	SP	9659	Condomínio Alphaville (Zona Rural)	Cond Alphaville (Z Rural)
48615	SP	9390	Vila Malzone	Vl Malzone
48616	SP	9665	Parque Albatroz	Prq Albatroz
48618	SP	9081	Centro	\N
48619	SP	9673	Costa Norte	C Norte
48620	SP	9089	Centro	\N
48621	SP	9059	Distrito Fazenda Velha	Dt Faz Velha
48622	SP	9000	Indaiatuba/Matão	\N
48623	SP	9718	Itaiquara	\N
48624	SP	9270	Centro	\N
48625	SP	9307	Centro	\N
48626	SP	9346	Centro	\N
48627	SP	9618	Liliana Urtiaga	L Urtiaga
48628	SP	9038	Porto	\N
48629	SP	9673	Topolândia	\N
48630	SP	9717	Turvo	\N
48634	SP	9775	Jardim Itália	Jd Itália
48636	SP	9640	Santa Cruz	Sta Cruz
48637	SP	9696	Residencial Jardim Villagio Sola	Res Jd V Sola
48643	SP	9587	Residencial Primavera	Res Primavera
48645	SP	9113	Embu Mirim	E Mirim
48653	SP	9113	Chácaras Pirajussara	C Pirajussara
48669	SP	9082	Nhambuca ( Caucaia do Alto)	Nhambuca (C Alto)
48728	SP	9559	Barro Branco	B Branco
48729	SP	9559	Roncon	\N
48730	SP	9559	Ponte Seca	Pte Seca
48731	SP	9559	Represa	\N
48732	SP	9559	Centro Alto	C Alto
48733	SP	9559	Suíssa	\N
48734	SP	9559	Bocaina	\N
48740	SP	9559	Santa Luzia	Sta Luzia
48741	SP	9559	Pilar Velho	P Velho
48742	SP	9559	Quarta Divisão	Q Divisão
48743	SP	9559	Tanque Caio	T Caio
48744	SP	9559	Tecelão	\N
48745	SP	9559	Pouso Alegre	P Alegre
48746	SP	9559	Itrapoá	\N
48747	SP	9559	Centro de Ouro Fino Paulista	C O F Paulista
48748	SP	9559	Casa Vermelha	C Vermelha
48749	SP	9559	Somma	\N
48750	SP	9700	Jardim Residencial Veccon	Jd Res Veccon
48751	SP	9668	Jardim Mar Lune	Jd M Lune
48752	SP	9237	Jardim Sabaúna	Jd Sabaúna
48756	SP	9138	Jardim Sol Nascente	Jd S Nascente
48757	SP	9138	Jardim Santa Izabel	Jd Sta Izabel
48758	SP	9138	Jardim Metrópole	Jd Metrópole
48759	SP	9138	Jardim Arakaki	Jd Arakaki
48760	SP	9267	Jardim Didinha	Jd Didinha
48762	SP	9177	Parque Residencial Mirante do Vale	Prq Res M Vale
48768	SP	9138	Jardim Vasconcelos	Jd Vasconcelos
48769	SP	9138	Jardim Hélio Fugagnolli	Jd H Fugagnolli
48770	SP	9138	Jardim Valentim	Jd Valentim
48771	SP	9138	Jardim Igaratá	Jd Igaratá
48772	SP	9138	Jardim Galimberti	Jd Galimberti
48773	SP	9138	Jardim Santa Catarina	Jd Sta Catarina
48774	SP	9138	Jardim Elizabethy	Jd Elizabethy
48775	SP	9138	Sítio do Paiolzinho	Sit Paiolzinho
48776	SP	9138	Jardim das Flores	Jd Flores
48777	SP	9138	Jardim Eugênia	Jd Eugênia
48778	SP	9138	Jardim Gentile	Jd Gentile
48779	SP	9138	Conjunto Habitacional José Chacon Moriel	Cj Hab J C Moriel
48780	SP	9138	Chácara Bogossian	Ch Bogossian
48781	SP	9138	Jardim Faleiros	Jd Faleiros
48782	SP	9138	Jardim José Ferreira	Jd J Ferreira
48783	SP	9244	José Tonolli	J Tonolli
48784	SP	9138	Vila Pery	Vl Pery
48785	SP	9138	Jardim Verão	Jd Verão
48786	SP	9138	Jardim Capim-Guassu	Jd Capim-Guassu
48787	SP	9138	Jardim Ayres	Jd Ayres
48866	SP	9113	Conjunto Habitacional Embu N	Cj Hab Embu N
48867	SP	9210	Icapara	\N
48868	SP	9113	Jardim Nayara	Jd Nayara
48871	SP	9315	Jardim Serelepe	Jd Serelepe
48872	SP	9668	Flor da Cantareira	F Cantareira
48880	SP	9668	Jardim Paquetá (Zona Norte)	Jd Paquetá (Z Norte)
48881	SP	9183	Jardim Planalto	Jd Planalto
48884	SP	9668	Jardim da Conquista (Zona Leste)	Jd Conquista (Z Leste)
48954	SP	9696	Recanto dos Juritis	Rec Juritis
48959	SP	9207	Centro	\N
48981	SP	9668	Jardim Papai Noel	Jd P Noel
48986	SP	9696	Jardim Sorocaba Park	Jd S Park
48987	SP	9696	Jardim Santa Esmeralda	Jd Sta Esmeralda
48988	SP	9362	Oliveira Barros	O Barros
48992	SP	9082	Parque dos Manacás	Prq Manacás
48994	SP	9668	Jardim Aristocrata	Jd Aristocrata
48995	SP	9668	Jardim São Norberto	Jd S Norberto
49009	SP	9640	Vila Sabesp	Vl Sabesp
49011	SP	9640	Novo Horizonte	N Horizonte
49012	SP	9640	Água Limpa	A Limpa
49013	SP	9640	Vila dos Pescadores	Vl Pescadores
49014	SP	9640	Santa Filomena	Sta Filomena
49015	SP	9355	Parque Idel	Prq Idel
49016	SP	9355	Jardim Maria Aparecida	Jd M Aparecida
49017	SP	9355	Jardim Pajussara	Jd Pajussara
49086	SP	9216	Jardim Belo Horizonte	Jd B Horizonte
49087	SP	9216	Jardim Esplendor	Jd Esplendor
49093	SP	9560	Jardim Professor Antônio Palocci	Jd Prf A Palocci
49094	SP	9243	Parque Wey	Prq Wey
49095	SP	9668	Recanto das Andorinhas	Rec Andorinhas
49096	SP	9559	Km 4	\N
49099	SP	9686	Zona Industrial	Z Industrial
49113	SP	9216	Jardim Cidade Jardim	Jd C Jardim
49115	SP	9122	Esperança D'Oeste	E D'Oeste
49116	SP	9045	Centro	\N
49117	SP	8863	Centro	\N
49119	SP	9314	Pinheiros	\N
49120	SP	8869	Centro	\N
49125	SP	8877	Parque dos Pinheiros	Prq Pinheiros
49126	SP	9730	Termas de Ibirá	T Ibirá
49127	SP	9587	Olaria	\N
49128	SP	8866	Alberto Moreira	A Moreira
49129	SP	9198	Ibitiruna	\N
49130	SP	8954	Conjunto Habitacional Michel Jorge Naben	Cj Hab M J Naben
49131	SP	8883	Parque Nova Carioba	Prq N Carioba
49136	SP	9643	Parque Faber Castell I	Prq F Castell I
49138	SP	9560	Jardim Maria de Lourdes	Jd M Lourdes
49139	SP	9267	Jardim do Portal	Jd Portal
49141	SP	9295	Jardim Sarapiranga	Jd Sarapiranga
48670	SP	9315	Jardim Casarão	Jd Casarão
48672	SP	9113	Chácaras Três Paineiras	C T Paineiras
48673	SP	8928	Vila dos Netos	Vl Netos
48674	SP	8928	Vila Rica	Vl Rica
48675	SP	9696	Jardim Residencial Martinez	Jd Res Martinez
48676	SP	9696	Jardim Vila São Domingos	Jd Vl S Domingos
48677	SP	9696	Jardim Copaíba	Jd Copaíba
48678	SP	9113	Jardim Santa Tereza	Jd Sta Tereza
48680	SP	9726	Piracangaguá (Jardim dos Pássaros)	Piracangaguá (Jd Pássaros)
48681	SP	8912	Jardim Maria Luiza III	Jd M Luiza III
48682	SP	8912	Vila Nossa Senhora Aparecida	Vl N Sra Aparecida
48683	SP	8912	Jardim Imperador II	Jd Imperador II
48684	SP	8886	Figueira	\N
48685	SP	8886	Conjunto Habitacional Doutor Attílio Mazzini (Arcadas)	Cj Hab Dr A Mazzini (Arcadas)
48686	SP	8886	Jardim Bela Vista (Arcadas)	Jd B Vista (Arcadas)
48707	SP	9493	Anhumas	\N
48708	SP	8928	Tanque	\N
48709	SP	9532	Residencial Parque dos Girassóis	Res Prq Girassóis
48712	SP	8928	Guaxinduva	\N
48713	SP	8928	Jardim Residencial Santa Luiza	Jd Res Sta Luiza
48717	SP	9371	Loteamento Nossa Senhora das Graças	Lot N Sra Graças
48718	SP	9354	Pedreira	\N
48723	SP	9726	Vila Aparecida	Vl Aparecida
48724	SP	9559	Colônia	\N
48725	SP	9559	Aliança	\N
48726	SP	9559	Santana	\N
48727	SP	9559	Pastoril	\N
48788	SP	9138	Vila São João	Vl S João
48789	SP	9138	Jardim Planalto	Jd Planalto
48790	SP	9138	Jardim  Hernandez	Jd Hernandez
48791	SP	9138	Jardim Bataglia	Jd Bataglia
48792	SP	9138	Jardim Soeiro	Jd Soeiro
48793	SP	9138	Jardim Barão	Jd Barão
48794	SP	9138	Jardim Barroso	Jd Barroso
48795	SP	9138	Jardim Nova Cidade	Jd N Cidade
48796	SP	9669	Santa Cruz	Sta Cruz
48820	SP	9696	Residencial Villazul	Res Villazul
48821	SP	9113	Jardim Santa Rita	Jd Sta Rita
48822	SP	9113	Vila Bonfim	Vl Bonfim
48823	SP	9315	Jardim Dibi	Jd Dibi
48824	SP	9113	Jardim Indaiá	Jd Indaiá
48825	SP	9668	Jardim Santa Edwiges (Capela do Socorro)	Jd Sta Edwiges (C Socorro)
48827	SP	9668	Jardim São José (Zona Sul)	Jd S José (Z Sul)
48828	SP	9668	Jardim Castro Alves	Jd C Alves
48830	SP	9643	Jardim Citelli	Jd Citelli
48831	SP	9177	Chácara Selles	Ch Selles
48843	SP	9726	Parque Esperança	Prq Esperança
48904	SP	9668	Jardim Vale do Sol	Jd Vle Sol
48925	SP	9025	Chácaras São Francisco do Aeroporto	C S F Aeroporto
48932	SP	9532	Jardim Prudentino	Jd Prudentino
48933	SP	9647	Yolanda	\N
48934	SP	9647	Jardim do Trevo	Jd Trevo
48939	SP	9267	Jardim América	Jd América
48940	SP	9267	Jardim Elza Maria	Jd E Maria
48941	SP	9267	Residencial São Paulo	Res S Paulo
48942	SP	9267	Santa Cruz dos Lázaros	Sta C Lázaros
48943	SP	9267	Jardim Independência	Jd Independência
48944	SP	9768	Residencial Nova Era	Res N Era
48945	SP	9532	Residencial Itapuã	Res Itapuã
48951	SP	9501	Jardim Itália	Jd Itália
49025	SP	9678	Vila Nova Mariana	Vl N Mariana
49026	SP	9678	Tancredo Neves	T Neves
49027	SP	9182	CING	\N
49028	SP	9182	Vila da Noite	Vl Noite
49029	SP	9182	Morro do Engenho	Mro Engenho
49030	SP	9182	Vila Selma	Vl Selma
49031	SP	9182	Morro Sorocotuba	Mro Sorocotuba
49032	SP	9182	Vila Nova Perequê	Vl N Perequê
49033	SP	9182	Jardim Umuarama	Jd Umuarama
49034	SP	9182	Maré Mansa	M Mansa
49035	SP	9182	Jardim Cunhambebe	Jd Cunhambebe
49036	SP	9182	Sítio Paecara	Sit Paecara
49037	SP	9182	Vila Áurea	Vl Áurea
49040	SP	9088	Afonso Schmidt	A Schmidt
49041	SP	9527	Tude Bastos	T Bastos
49042	SP	9527	Caieiras	\N
49043	SP	9369	Chácara Guanabara	Ch Guanabara
49044	SP	9369	Colinas do Paratehy	C Paratehy
49045	SP	9369	Jardim Vieira	Jd Vieira
49046	SP	9668	Jardim Valparaiso	Jd Valparaiso
49047	SP	9250	Jardim Horto do Ipê	Jd H Ipê
49063	SP	8956	Jardim Graziela	Jd Graziela
49166	SP	8976	São Roque Novo	S R Novo
49167	SP	9668	Conjunto Habitacional Parque Valo Velho II	Cj Hab Prq V Velho II
49170	SP	9026	Moinho	\N
49180	SP	9146	Lago Azul Ortiz	Lg A Ortiz
49185	SP	8989	Conjunto Residencial Morada do Sol I	Cj Res M Sol I
49186	SP	8989	Conjunto Residencial Morada do Sol II	Cj Res M Sol II
49189	SP	8989	Jardim Iolanda	Jd Iolanda
49191	SP	9668	Jardim Monte Alegre (Zona Norte)	Jd Mte Alegre (Z Norte)
49192	SP	9668	Jardim Monte Belo (Raposo Tavares)	Jd Mte Belo (R Tavares)
49195	SP	9560	Jardim Pedra Branca	Jd P Branca
49258	SP	9726	Barranco	\N
49259	SP	9321	Loteamento Village das Palmeiras	Lot V Palmeiras
49260	SP	9493	Nova Suiça	N Suiça
49263	SP	9660	Jardim Anhembi	Jd Anhembi
49268	SP	8961	Jardim Imperatriz	Jd Imperatriz
49269	SP	8961	Residencial Francisco Lemos de Almeida	Res F L Almeida
49270	SP	9295	Residencial Canto das Aves II	Res C Aves II
49271	SP	9295	Vila Palma	Vl Palma
49272	SP	9493	Loteamento Distrito Industrial Uninorte	Lot Dt Ind Uninorte
49273	SP	9493	Parque Conceição	Prq Conceição
49274	SP	8928	Rosário	\N
49276	SP	8883	Jardim Boer I	Jd Boer I
49287	SP	9700	Residencial Parque Pavan	Res Prq Pavan
49290	SP	8961	Jardim Silvestri II	Jd Silvestri II
49291	SP	9025	Residencial Terras do Barão	Res T Barão
49292	SP	8912	Condomínio Manoela	Cond Manoela
49293	SP	9321	Sapé	\N
49295	SP	9321	Loteamento Jardim Primavera	Lot Jd Primavera
49296	SP	9560	Jardim Nova Aliança Sul	Jd N A Sul
49297	SP	9560	Vila do Golf	Vl Golf
49312	SP	9183	Jardim Vermelhão	Jd Vermelhão
49313	SP	9216	Vila Mariana	Vl Mariana
49314	SP	9216	Jardim Bela Vista	Jd B Vista
49315	SP	9216	Mato Dentro	M Dentro
49316	SP	9216	Tombadouro	\N
49383	SP	9369	Jardim Nathalie	Jd Nathalie
49385	SP	9485	Loteamento Eduardo da Silva Neto	Lot E S Neto
49388	SP	8954	Jardim Vale do Verde	Jd Vle Verde
49389	SP	8954	Conjunto Habitacional Newton Siqueira Sopa	Cj Hab N S Sopa
49390	SP	8954	Residencial Grande Horizonte	Res G Horizonte
49406	SP	9703	Quinta Divisão	Qta Divisão
49407	SP	8912	Altos do Jaraguá	A Jaraguá
49410	SP	9696	Jardim Nápoli	Jd Nápoli
49411	SP	9354	Azulville I	\N
49412	SP	9354	Azulville II	\N
49413	SP	9587	Micai	\N
49414	SP	9026	Jardim Santa Branca	Jd Sta Branca
49415	SP	9177	Village Mantiqueira	V Mantiqueira
49433	SP	9354	Jardim Santa Marta	Jd Sta Marta
49496	SP	9659	Residencial Califórnia	Res Califórnia
49497	SP	9659	Green Valley Edge City	G V E City
49498	SP	9659	Residencial Eco Village	Res E Village
49501	SP	9254	Loteamento Parque Empresarial Adelelmo Corradini	Lot Prq E A Corradini
49507	SP	9113	Granja Nossa Senhora Aparecida	Gja N Sra Aparecida
49508	SP	9668	Residencial Vilela	Res Vilela
49523	SP	9260	Jardim dos Ipês	Jd Ipês
49529	SP	9254	Loteamento Aída Haddad Jafet	Lot A H Jafet
49530	SP	9595	Jardim São Camilo	Jd S Camilo
49532	SP	8901	Lageado	\N
49533	SP	9668	Jardim Paraíso	Jd Paraíso
49534	SP	9725	Conjunto Habitacional Osvaldo Del Fiol	Cj Hab O D Fiol
49535	SP	8928	Vila Gardênia	Vl Gardênia
49536	SP	9625	Bangú	\N
49198	SP	8989	Jardim Cambuí	Jd Cambuí
49199	SP	8989	Residencial Cedro	Res Cedro
49200	SP	9696	Jardim Eden Ville	Jd E Ville
49201	SP	9595	Jardim Vila Rica	Jd Vl Rica
49204	SP	8949	Vila Narcisa	Vl Narcisa
49205	SP	9369	Chácara dos Baianos	Ch Baianos
49206	SP	9369	Varinhas	\N
49207	SP	9369	Nove de Julho	N Julho
49208	SP	9183	Jardim dos Cardoso	Jd Cardoso
49209	SP	9696	Jardim Wanel Ville V	Jd W Ville V
49214	SP	9501	Jardim Veneza	Jd Veneza
49215	SP	9707	Jardim Novo Record	Jd N Record
49223	SP	9025	Jardim Ouro Preto	Jd O Preto
49229	SP	9277	Mirante de Jandira	M Jandira
49233	SP	9668	Jardim Represa (Parelheiros)	Jd Represa (Parelheiros)
49234	SP	9668	Vila Paulista II	Vl Paulista II
49243	SP	9595	Jardim Dona Regina	Jd Da Regina
49348	SP	8913	Chácaras de Recreio Colina Verde	C Rcr C Verde
49349	SP	8913	Jardim Santa Olívia II	Jd Sta Olívia II
49350	SP	9369	Conjunto Bom Pastor	Cj B Pastor
49351	SP	9369	Conjunto Oropó	Cj Oropó
49352	SP	9369	Boa Vista	B Vista
49353	SP	9369	Biritiba Ussu	B Ussu
49436	SP	9660	Chácaras São José	C S José
49437	SP	9696	Vila Odim Antão	Vl O Antão
49438	SP	9660	Residencial Altos do Bosque	Res A Bosque
49439	SP	9696	Jardim Residencial Villa Amato	Jd Res V Amato
49440	SP	9243	Residencial Colinas de São José	Res C S José
49441	SP	8928	Planalto Atibaia	P Atibaia
49442	SP	8883	Jardim Novo Paraíso	Jd N Paraíso
49443	SP	9368	Jardim São Benedito	Jd S Benedito
49444	SP	9643	Loteamento Social Antenor Garcia	Lot S A Garcia
49445	SP	9660	Jardim Sul	Jd Sul
49446	SP	9660	Residencial Gazzo	Res Gazzo
49447	SP	9647	Terras de São José	T S José
49448	SP	9370	Parque dos Eucaliptos	Prq Eucaliptos
49449	SP	9566	Jardim Residencial San Marino	Jd Res S Marino
49450	SP	9532	Jardim São Sebastião	Jd S Sebastião
49451	SP	9748	Parque Carajás II	Prq Carajás II
49452	SP	9748	Nova Tupã	N Tupã
49453	SP	9748	Parque Universitário III	Prq Universitário III
49454	SP	9748	Jardim Morumbi	Jd Morumbi
49461	SP	8928	Jardim Paraíso da Usina	Jd P Usina
49464	SP	9587	Joana Leite	J Leite
49465	SP	9560	Bom Jesus	B Jesus
49467	SP	9696	Inhayba	\N
49473	SP	9726	Jardim Ana Emilia	Jd A Emilia
49474	SP	9560	Recanto das Palmeiras	Rec Palmeiras
49596	SP	9660	Vila das Flores	Vl Flores
49597	SP	9696	Jardim Santa Catarina	Jd Sta Catarina
49598	SP	9696	Jardim Residencial Imperatriz	Jd Res Imperatriz
49599	SP	9696	Jardim Paulista	Jd Paulista
49605	SP	9660	Jardim Juliana	Jd Juliana
49606	SP	9005	Vila Independência	Vl Independência
49607	SP	9369	Do Taboão	D Taboão
49608	SP	9005	Vila Nossa Senhora das Graças	Vl N Sra Graças
49609	SP	9005	Residencial Nancy	Res Nancy
49610	SP	9005	Vila Paraíso	Vl Paraíso
49611	SP	9321	Residencial Vila Rica	Res Vl Rica
49612	SP	9660	Cajuru	\N
49613	SP	9696	Jardim Santa Rosa	Jd Sta Rosa
49615	SP	9660	Vila Terezinha	Vl Terezinha
49617	SP	9660	Jardim São José II	Jd S José II
49622	SP	9660	Parque Residencial Flamboyant	Prq Res Flamboyant
49623	SP	8928	Samambaia Parque Residencial	S Prq Residencial
49624	SP	9668	Jardim Alto Paulistano	Jd At Paulistano
49626	SP	9668	Jardim Nova Conquista	Jd N Conquista
49627	SP	8928	Jardim Roseli	Jd Roseli
49628	SP	9025	Conjunto Habitacional Residencial Olímpia	Cj Hab Res Olímpia
49689	SP	9659	Mariza Cristina II	M Cristina II
49690	SP	9659	Mariza Cristina I	M Cristina I
49691	SP	9659	Jardim Vista Alegre	Jd V Alegre
49694	SP	9686	CINEP - Cidade Industrial e Empresarial	CINEP - C Ind Empresarial
49695	SP	9177	Jardim Bela Vista	Jd B Vista
49696	SP	9177	Jardim Bela Vista II	Jd B Vista II
49697	SP	9177	Vila Galvão	Vl Galvão
49698	SP	9660	Buquirinha II	\N
49709	SP	8928	Loteamento Vale das Flores	Lot Vle Flores
49710	SP	9260	Residencial Itaim II	Res Itaim II
49711	SP	8883	Residencial Horto Florestal Jacyra I	Res H F Jacyra I
49712	SP	9267	Jardim Marister	Jd Marister
49714	SP	9267	Conjunto Habitacional Marinho	Cj Hab Marinho
49715	SP	9267	Vila Machado	Vl Machado
49716	SP	9371	SEHAC	\N
49717	SP	9660	Jardim Apolo I	Jd Apolo I
49718	SP	9660	Jardim Apolo II	Jd Apolo II
49719	SP	9660	Jardim Santa Madalena	Jd Sta Madalena
49720	SP	9660	Vila Guaianazes	Vl Guaianazes
49721	SP	9660	Jardim Fátima	Jd Fátima
49722	SP	9660	Jardim Margareth	Jd Margareth
49723	SP	9660	Jardim Maringá	Jd Maringá
49724	SP	9789	Residencial Bortoloti	Res Bortoloti
49725	SP	9726	Residencial Bardan	Res Bardan
49726	SP	9726	Parque Urupês	Prq Urupês
49727	SP	9726	Parque Taubateguassu	Prq Taubateguassu
49728	SP	9726	Vila Albina	Vl Albina
49729	SP	9726	Jardim Canuto Borges	Jd C Borges
49730	SP	9560	Residencial Doutor Rubem Cione	Res Dr R Cione
49731	SP	9726	Lavadouro de Areia	L Areia
49732	SP	9768	Jardim Santa Cecília	Jd Sta Cecília
49735	SP	9177	Loteamento São Pedro	Lot S Pedro
49736	SP	9177	Núcleo Residencial Adhemar de Barros	Nuc Res A Barros
49737	SP	9177	Jardim Indepedência	Jd Indepedência
49790	SP	8928	Jardim Colonial	Jd Colonial
49808	SP	9082	Outeiro de Passárgada	O Passárgada
49809	SP	9113	Ressaca	\N
49815	SP	9087	Jardim Primavera	Jd Primavera
49816	SP	9660	Floradas de São José	F S José
49830	SP	9660	Vila Sinhá	Vl Sinhá
49831	SP	9660	Vila Monte Alegre	Vl Mte Alegre
49834	SP	9696	Jardim Tulipas	Jd Tulipas
49835	SP	9668	Gramado	\N
49839	SP	9696	Jardim Astro	Jd Astro
49840	SP	9177	Jardim Ícaro	Jd Ícaro
49841	SP	9696	Jardim Amalia	Jd Amalia
49898	SP	8907	Conjunto Habitacional Elias Stefan	Cj H E Stefan
49899	SP	9260	Residencial Dona Tonica	Res Da Tonica
49903	SP	9183	Vila Real	Vl Real
49912	SP	9025	Parque dos Resedás	Prq Resedás
49931	SP	9660	Jardim Del Rey	Jd D Rey
49933	SP	9660	Jardim Madureira	Jd Madureira
49942	SP	9660	Jardim Nova República	Jd N República
50031	SP	9317	Residencial Casalbuono	Res Casalbuono
50032	SP	9660	Jardim Santo Onofre	Jd Sto Onofre
50039	SP	9587	Julio Ustrito	J Ustrito
50045	SP	9295	Mirante da Colonia	M Colonia
50048	SP	9267	Jardim Altos de Santana II	Jd A Santana II
50049	SP	9587	Jardim Soberano	Jd Soberano
50050	SP	9431	Jardim Boa Vista	Jd B Vista
50051	SP	9673	São Francisco da Praia	S F Praia
50053	SP	9254	Loteamento Residencial Dolce Vita	Lot Res D Vita
50066	SP	9595	Jardim Flamboyant	Jd Flamboyant
50084	SP	9240	Jardim Nova Aliança	Jd N Aliança
50085	SP	9295	Parque da Colônia	Prq Colônia
50086	SP	9316	Jardim Maria Luíza I	Jd M Luíza I
50087	SP	9316	Jardim Santana	Jd Santana
49632	SP	9671	Parque Recreio Mirante	Prq Rcr Mirante
49639	SP	9216	Jardim Portal dos Ipês	Jd P Ipês
49640	SP	9216	Vila Residencial Green Park	Vl Res G Park
49641	SP	9216	Jardim Portal de Itaici	Jd P Itaici
49642	SP	9216	Comercial Vitória Martini	C V Martini
49643	SP	9216	Américan Park Empresarial NR	A P E NR
49644	SP	9216	Jardim Colonial	Jd Colonial
49645	SP	9005	Guamirim	\N
49648	SP	9783	Distrito Industrial	Dt Industrial
49650	SP	9254	Loteamento Parque da Colina II	Lot Prq Colina II
49651	SP	8992	Jardim Lago do Moinho	Jd Lg Moinho
49654	SP	9726	Parque Jaraguá	Prq Jaraguá
49655	SP	9726	Jardim dos Estados	Jd Estados
49658	SP	9285	Residencial Morada do Sol	Res M Sol
49661	SP	9668	Jardim São Francisco de Assis (Parelheiros)	Jd S F Assis (Parelheiros)
49668	SP	9087	Jardim Europa	Jd Europa
49672	SP	9485	Vitória Vale II	V Vale II
49675	SP	8933	Jardim Vitória	Jd Vitória
49680	SP	9254	Bairro Pedras de Ouro	B P Ouro
49681	SP	9254	Loteamento Residencial Terra Nova	Lot Res T Nova
49682	SP	9254	Jardim Nova Esperança	Jd N Esperança
49683	SP	9254	Bairro dos Baldos	B Baldos
49684	SP	9254	Loteamento Residencial Central Park II	Lot Res C Park II
49685	SP	9025	Núcleo Residencial Gênesis	Nuc Res Gênesis
49686	SP	9025	Núcleo Jardim Novo Nilópolis	Nuc Jd N Nilópolis
49687	SP	9025	Jardim Novo Horizonte	Jd N Horizonte
49738	SP	9177	CECAP	\N
49739	SP	9177	Residencial Esplanada	Res Esplanada
49744	SP	9560	Condomínio Guaporé	Cond Guaporé
49745	SP	9265	Jardim Guanabara	Jd Guanabara
49746	SP	9025	Vila Saltinho	Vl Saltinho
49747	SP	9659	Residencial Helena	Res Helena
49748	SP	9726	Conjunto Habitacional Taubaté E	Cj Hab Taubaté E
49749	SP	9566	Conjunto Habitacional de Interesse Social Rio Claro H	Cj Hab I S R Claro H
49750	SP	9726	Granja Daniel	Gja Daniel
49754	SP	9052	Jardim Eldorado	Jd Eldorado
49755	SP	9260	Granjas Bela Vista	G B Vista
49756	SP	9177	Jardim São Manoel	Jd S Manoel
49760	SP	9726	Itaim	\N
49761	SP	9668	Jardim Nova Vitória I	Jd N Vitória I
49762	SP	9668	Jardim Nova Vitória II	Jd N Vitória II
49763	SP	9177	Pedrinha	\N
49764	SP	9177	Bom Jardim II	B Jardim II
49765	SP	9177	Bom Jardim III	B Jardim III
49766	SP	9177	Parque das Garças	Prq Garças
49767	SP	9177	Jardim Alvorada	Jd Alvorada
49770	SP	9726	Jardim Sonia Maria	Jd Sonia Maria
49771	SP	9668	Jardim Nova Harmonia	Jd N Harmonia
49772	SP	9243	Residencial Vale do Sol	Res Vle Sol
49774	SP	9595	Chácaras de Recreio Hélico	C Rcr Hélico
49777	SP	9595	Jardim Souza Queiroz	Jd S Queiroz
49779	SP	9595	Acampamento Presbiteriano	Acamp Presbiteriano
49782	SP	9267	Jardim das Oliveiras	Jd Oliveiras
49783	SP	9267	Vila Nova Aliança	Vl N Aliança
49842	SP	9696	Jardim Turmalina	Jd Turmalina
49845	SP	9643	Jardim Embaré	Jd Embaré
49851	SP	11239	Centro	\N
49855	SP	11240	Centro	\N
49869	SP	9643	Condomínio Residencial Montreal	Cond Res Montreal
49883	SP	9265	Jardim Mariana	Jd Mariana
49893	SP	8928	Jardim Itaperi	Jd Itaperi
49999	SP	9668	Jardim Premiano	Jd Premiano
50010	SP	9369	Parque Olimpico	Prq Olimpico
50011	SP	9369	Vila Municipal	Vl Municipal
50014	SP	8992	Guaripocaba	\N
50016	SP	9355	Jardim Maria Eneida	Jd M Eneida
50017	SP	8961	Quinta Ranieri	Qta Ranieri
50018	SP	9647	Jardim Boa Vista	Jd Boa Vista
50019	SP	9348	Jardim Damasco III	Jd Damasco III
50021	SP	9113	Jardim Bela Vista	Jd B Vista
50023	SP	9183	Jardim Princesa	Jd Princesa
50027	SP	8954	Jardim Residencial ETEMP	Jd Res ETEMP
50089	SP	9369	Jardim Cambuci	Jd Cambuci
50092	SP	8883	Jardim Dona Judith	Jd Da Judith
50097	SP	9660	Residencial Armando Moreira Righi	Res A M Righi
50101	SP	9645	São Francisco da Praia	S F Praia
50102	SP	9645	Centro	\N
50103	SP	9660	Jardim Colorado	Jd Colorado
50104	SP	9660	Parque Martim Cecerê	Prq M Cecerê
50105	SP	8883	Jardim da Mata	Jd Mata
50109	SP	9183	Jardim Oliveira I	Jd Oliveira I
50110	SP	9183	Jardim Oliveira II	Jd Oliveira II
50111	SP	9183	Jardim Maria Clara	Jd M Clara
50112	SP	9183	Jardim Vida Nova	Jd V Nova
50113	SP	9493	Jardim Califórnia	Jd Califórnia
50114	SP	9788	Altos da Fortaleza	A Fortaleza
50115	SP	9788	Altos de Votorantim	A Votorantim
50117	SP	8883	Jardim Novo Horizonte	Jd N Horizonte
50118	SP	9146	Portal das Alamedas	P Alamedas
50119	SP	8992	Cidade Jardim	C Jardim
50120	SP	8992	Recanto Amapola	Rec Amapola
50121	SP	9216	Jardim Residencial Santa Clara	Jd Res Sta Clara
50122	SP	9216	Portal das Acácias	P Acácias
50123	SP	9216	Jardim Residencial Villa Suíça	Jd Res V Suíça
50124	SP	9216	Residencial Moradas de Itaici	Res M Itaici
50125	SP	8883	Loteamento Jardim Progresso	Lot Jd Progresso
50128	SP	9660	Vila Zizinha	Vl Zizinha
50129	SP	9660	Vila Nova Cristina	Vl N Cristina
50130	SP	9660	Vila Jaci	Vl Jaci
50131	SP	9660	Vila Rangel	Vl Rangel
50132	SP	9660	Jardim Ouro Preto	Jd O Preto
50158	SP	9660	Jardim Terras do Sul	Jd T Sul
50159	SP	9660	Residencial Sol Nascente	Res S Nascente
50160	SP	8883	Jardim Bertoni	Jd Bertoni
50162	SP	9660	Vila São Geraldo	Vl S Geraldo
50163	SP	9660	Recanto Caeté	Rec Caeté
50164	SP	9660	Jardim Boa Vista	Jd Boa Vista
50165	SP	9660	Altos da Vila Paiva	A Vl Paiva
50166	SP	9025	Parque Industrial Lisboa	Prq Ind Lisboa
50167	SP	9789	Residencial Esther	Res Esther
50168	SP	9726	Conjunto Habitacional Humberto Passarelli	Cj H H Passarelli
50169	SP	9595	Chácara Pedroso	Ch Pedroso
50170	SP	8912	Jardim Altos de Pinheiros I e II	Jd A P I e II
50171	SP	9177	Jardim Esperança	Jd Esperança
50172	SP	9315	Jardim Anteghini	Jd Anteghini
50174	SP	9501	Jardim Terras de San José	Jd T S José
50175	SP	9501	Jardim Verona II	Jd Verona II
50176	SP	9501	Jardim Milenium	Jd Milenium
50238	SP	9659	Condomínio Residencial Parque da Liberdade I	Cond Res Prq Liberdade I
50241	SP	9254	Paraíso das Aves	P Aves
50245	SP	9587	Residencial Santa Madre Paulina	Res Sta Me Paulina
50246	SP	9587	Jardim Nair Maria	Jd N Maria
50247	SP	9660	Jardim Santa Rosa	Jd Sta Rosa
50248	SP	9668	Jardim das Carmelitas	Jd Carmelitas
50249	SP	9775	Jardim Gianfrancesco	Jd Gianfrancesco
50250	SP	9369	Porteira Preta	P Preta
50251	SP	9267	Jardim Conquista	Jd Conquista
50252	SP	9189	Jardim Novo Cambuí	Jd N Cambuí
50253	SP	9189	Parque Gabriel	Prq Gabriel
50254	SP	9189	Jardim Nova Alvorada	Jd N Alvorada
50255	SP	9189	Jardim Interlagos	Jd Interlagos
50256	SP	8933	Costa Azul I	C Azul I
50257	SP	8933	Costa Azul II	C Azul II
50258	SP	8933	Costa Azul III	C Azul III
50259	SP	9595	Jardim Santa Luzia	Jd Sta Luzia
50260	SP	9595	Vila Bortoletto	Vl Bortoletto
50261	SP	8912	Jardim Altos do Cecap I e II	Jd A C I e II
50262	SP	8912	Jardim Cruzeiro do Sul I e II	Jd C S I e II
50263	SP	8912	Jardim Athenas	Jd Athenas
50264	SP	8992	Quinta da Baroneza II	Qta Baroneza II
50266	SP	8883	Jardim da Balsa I	Jd Balsa I
50267	SP	8883	Jardim da Balsa II	Jd Balsa II
50268	SP	9317	Jardim Porto Real	Jd Pto Real
50269	SP	9317	Jardim Porto Real II	Jd Pto Real II
50270	SP	9025	Parque Eldorado	Prq Eldorado
50271	SP	9025	Chácaras Recanto da Colina Verde	C Rec C Verde
50272	SP	9659	Jardim Bianco	Jd Bianco
50276	SP	9250	Sítio São Francisco	Sit S Francisco
50277	SP	9177	Vila Paraíba	Vl Paraíba
50278	SP	9177	Residencial Alberto Byington	Res A Byington
50280	SP	9659	Condomínio Renascer	Cond Renascer
50287	SP	9659	Vila Mafalda II	Vl Mafalda II
50293	SP	9668	Jardim Paraná	Jd Paraná
50294	SP	9177	Pedreira	\N
50295	SP	9177	Alto das Almas	At Almas
50339	SP	9726	Jardim Hípica Pinheiro	Jd H Pinheiro
50340	SP	9317	Jardim Grêmio	Jd Grêmio
50341	SP	9501	Jardim Velloso	Jd Velloso
50342	SP	9485	Bom Sucesso	B Sucesso
50345	SP	9216	Jardim Juscelino Kubitschek	Jd J Kubitschek
50346	SP	9671	Guaçu	\N
50347	SP	9659	Residencial Sebastião Guilhem Padilha	Res S G Padilha
50348	SP	8992	Jardim Estancia Santana	Jd E Santana
50364	SP	9659	Parque Residencial Maria Zorita	Prq Res M Zorita
50366	SP	9317	Parque Residencial Roland	Prq Res Roland
50368	SP	8913	Jardim do Lago	Jd Lago
50370	SP	9696	Jardim Nova Aparecidinha	Jd N Aparecidinha
50374	SP	9182	Jardim Brasil I	Jd Brasil I
50375	SP	9182	Jardim Brasil II	Jd Brasil II
50377	SP	9295	Chácara São Jorge	Ch S Jorge
50378	SP	9260	Parque Residencial Quinta das Laranjeiras	Prq Res Qta Laranjeiras
50213	SP	9660	Ronda	\N
50214	SP	9348	Conjunto Habitacional Leonel de Moura Brizola	Cj H L M Brizola
50215	SP	9768	Jardim Santa Helena	Jd Sta Helena
50216	SP	9660	Jardim Serimbura	Jd Serimbura
50217	SP	9370	Jardim Carmen Lídia II	Jd C Lídia II
50218	SP	9317	Jardim Chácaras de Recreio Santa Helena	Jd C Rcr Sta Helena
50221	SP	9686	Jardim Bothânico	Jd Bothânico
50222	SP	9660	Conjunto Residencial Intervale	Cj Res Intervale
50223	SP	9660	Residencial Planalto	Res Planalto
50224	SP	9660	Loteamento Residencial Vista Linda	Lot Res V Linda
50225	SP	9660	Vila Tatetuba	Vl Tatetuba
50226	SP	8913	Chácaras Granja São Francisco	C Gja S Francisco
50227	SP	9725	Ponte Preta	Pte Preta
50228	SP	9643	Parque Itaipu	Prq Itaipu
50229	SP	9493	Jardim Residencial Javary III	Jd Res Javary III
50230	SP	9493	Parque Residencial Monte Rey II	Prq Res Mte Rey II
50231	SP	9493	Parque Residencial Monte Rey III	Prq Res Mte Rey III
50232	SP	9493	Parque São Matheus	Prq S Matheus
50233	SP	9789	Park Residencial Colinas	P Res Colinas
50234	SP	9659	Loteamento San Fernando Valley	Lot S F Valley
50235	SP	9659	Loteamento Parque dos Pássaros	Lot Prq Pássaros
50236	SP	9789	Café	\N
50296	SP	9177	Jardim David Fernandes Coelho	Jd D F Coelho
50297	SP	9660	Jardim Estoril	Jd Estoril
50298	SP	9660	Conjunto Papa João Paulo II	Cj P J Paulo II
50299	SP	9748	Parque Carajás I	Prq Carajás I
50301	SP	9240	Cambuí	\N
50302	SP	8928	Casas Populares	C Populares
50303	SP	8928	Jardim das Palmeiras	Jd Palmeiras
50304	SP	8928	Jardim Alvinópolis II	Jd Alvinópolis II
50305	SP	9267	Residencial Santa Paula	Res Sta Paula
50307	SP	9025	Polo de Alta Tecnologia de Campinas - Polo I	P A T Campinas - Polo I
50308	SP	9025	Jardim Mirassol	Jd Mirassol
50309	SP	9668	Jardim São Jorge (Raposo Tavares)	Jd S Jorge (R Tavares)
50312	SP	8928	Vila Santo Antônio	Vl Sto Antônio
50315	SP	9025	Jardim Fernanda - Continuação	Jd Fernanda - Continuação
50316	SP	9250	Jardim Odete II	Jd Odete II
50318	SP	8992	Jardim das Laranjeiras	Jd Laranjeiras
50319	SP	8992	Jardim Doutor Júlio de Mesquita Filho	Jd Dr J M Filho
50320	SP	9726	Residencial Portal da Mantiqueira	Res P Mantiqueira
50321	SP	9295	Jardim Colonial	Jd Colonial
50322	SP	9660	Jardim Santa Inês II	Jd Sta Inês II
50323	SP	9660	Jardim Santa Inês III	Jd Sta Inês III
50324	SP	9295	Jardim Marambaia	Jd Marambaia
50326	SP	9368	Residencial Jardim José Justi II	Res Jd J Justi II
50327	SP	9315	Jardim Imperial II	Jd Imperial II
50328	SP	9315	Jardim Residencial Crishmara	Jd Res Crishmara
50329	SP	9315	Jardim Portal do Bosque	Jd P Bosque
50330	SP	9315	Jardim Silvana	Jd Silvana
50331	SP	9789	Loteamento São Vicente de Paula	Lot S V Paula
50332	SP	9789	Vila Anna	Vl Anna
50333	SP	9789	Conjunto Habitacional Votuporanga C	Cj H Votuporanga C
50335	SP	8928	Jardim Pacaembu	Jd Pacaembu
50336	SP	8928	Vila Junqueira	Vl Junqueira
50337	SP	9485	Alto do Piracuama	At Piracuama
50403	SP	8928	San Fernando Valley	S F Valley
50404	SP	8928	Ribeirão dos Porcos	R Porcos
50405	SP	8928	Jardim Maristela II	Jd Maristela II
50407	SP	9660	Jardim Itapoã	Jd Itapoã
50408	SP	9660	Jardim Oswaldo Cruz	Jd O Cruz
50409	SP	9354	Villa Romana	V Romana
50410	SP	8912	Machados	\N
50411	SP	9370	Chácara Santa Felicidade	Ch Sta Felicidade
50412	SP	9144	Chácaras Residenciais Ana Dorothéa	C R A Dorothéa
50413	SP	9144	Franca Pólo Club	F P Club
50414	SP	9725	Tanque Novo	T Novo
50416	SP	9214	Perequê	\N
50417	SP	9177	Parque Residencial André Broca Filho	Prq Res A B Filho
50418	SP	9177	Parque São Francisco III	Prq S Francisco III
50419	SP	9177	Parque Santa Clara	Prq Sta Clara
50420	SP	9177	Vila dos Comerciários I	Vl Comerciários I
50421	SP	9177	Vila dos Comerciários II	Vl Comerciários II
50422	SP	9177	Vila Municipal I	Vl Municipal I
50423	SP	9775	Jardim Itália II	Jd Itália II
50425	SP	8883	Vila Conquista	Vl Conquista
50426	SP	9532	Central Park Residence	C P Residence
50427	SP	9668	Jardim Cris	Jd Cris
50428	SP	9696	Terras de Arieta	T Arieta
50429	SP	9643	Cooperativa Habitacional Azulville	C H Azulville
50430	SP	8928	Portão	\N
50432	SP	9668	Vila São Francisco (Zona Sul)	Vl S Francisco (Z Sul)
50433	SP	9668	Vila São Francisco (Zona Leste)	Vl S Francisco (Z Leste)
50442	SP	9295	Terras de Santa Cruz	T Sta Cruz
50443	SP	8928	Estância San Remo	Etn S Remo
50444	SP	9789	Vila Lupo	Vl Lupo
50445	SP	9789	Villágio San Remo	V S Remo
50446	SP	9789	Jardim Orlando Mastrocola	Jd O Mastrocola
50447	SP	9789	Residencial Parque Saúde	Res Prq Saúde
50448	SP	9789	Jardim Residencial Dharma	Jd Res Dharma
50449	SP	9789	Nossa Senhora Aparecida	N Sra Aparecida
50503	SP	9082	Portal do Areião (Caucaia do Alto)	P Areião (C Alto)
50505	SP	9260	Braiaia	\N
50506	SP	9660	Residencial Cambuí	Res Cambuí
50515	SP	9240	Conjunto Habitacional Itapetininga F3	Cj H I F3
50516	SP	9240	Vila Palmeira	Vl Palmeira
50517	SP	9240	Jardim São Camilo	Jd S Camilo
50521	SP	9493	Centro (Ártemis)	\N
50522	SP	9493	Estância Lago Azul (Ártemis)	Etn Lg Azul (Ártemis)
50523	SP	9493	Colinas do Piracicaba (Ártemis)	C Piracicaba (Ártemis)
50524	SP	9493	Jardim Itaiçaba (Ártemis)	Jd Itaiçaba (Ártemis)
50530	SP	9660	Jardim do Lago	Jd Lago
50531	SP	9660	Vila Iracema	Vl Iracema
50532	SP	9660	Residencial Jatobá	Res Jatobá
50533	SP	9660	Jardim São Leopoldo	Jd S Leopoldo
50534	SP	9660	Conjunto Residencial Nosso Teto	Cj Res N Teto
50538	SP	9660	Condomínio Espelho D'água	Cond E D'água
50540	SP	9566	Loteamento Fontes e Bosques Alam Grei	Lot F E B A Grei
50542	SP	9659	Residencial Jardins	Res Jardins
50543	SP	9659	Village Flamboyant	V Flamboyant
50544	SP	9659	Condomínio Harmonia Residence	Cond H Residence
50545	SP	9659	Parque Residencial Damha IV	Prq Res Damha IV
50546	SP	9659	Parque Residencial Damha V	Prq Res Damha V
50547	SP	9659	Residencial Gaivota I	Res Gaivota I
50548	SP	9659	Condomínio Village Rio Preto	Cond V R Preto
50609	SP	8913	Jardim Residencial Flamboyant	Jd Res Flamboyant
50610	SP	8913	Jardim Dalla Costa	Jd D Costa
50611	SP	8926	D'Ville Residencial	D Residencial
50614	SP	8926	Jardim Nova Olinda	Jd N Olinda
50617	SP	9726	Taboão	\N
50618	SP	9371	Jardim Santa Júlia	Jd Sta Júlia
50619	SP	8912	Jardim Serra Azul	Jd S Azul
50620	SP	9321	Vila Portugal	Vl Portugal
50625	SP	8913	Distrito Industrial V	Dt Industrial V
50626	SP	8913	Distrito Industrial VI	Dt Industrial VI
50627	SP	9189	Jardim Green Park Residence	Jd G P Residence
50633	SP	9725	Chácara Ramiro Soares	Ch R Soares
50634	SP	8913	Residencial Santa Mônica	Res Sta Mônica
50636	SP	9768	Bosque dos Eucaliptos	Bsq Eucaliptos
50642	SP	9354	São Lourenço do Turvo	S L Turvo
50644	SP	9265	Jardim Bothânico	Jd Bothânico
50645	SP	9686	Vila Áurea Mendes Gimenes	Vl A M Gimenes
50646	SP	9686	Jardim Montreal	Jd Montreal
50647	SP	9686	Residencial e Comercial Wilson Bernardi	Res E C W Bernardi
50648	SP	9686	Jardim Helena	Jd Helena
50651	SP	9043	Recanto Som do Mar	Rec S Mar
50652	SP	9647	Jardim Del Plata II	Jd D Plata II
50656	SP	9789	Conjunto Habitacional Sonho Meu	Cj H S Meu
50657	SP	9789	Jardim Residencial Noroeste	Jd Res Noroeste
50658	SP	9789	Jardim dos Ypês	Jd Ypês
50659	SP	9789	Jardim Residencial Portal do Sol	Jd Res P Sol
50712	SP	9726	Vila Costa	Vl Costa
50713	SP	9726	Jardim São Benedito	Jd S Benedito
50714	SP	9726	Parque Tabaeté	Prq Tabaeté
50715	SP	9321	Aterrado	\N
50720	SP	9660	Vila Rubi	Vl Rubi
50722	SP	9026	Privê Gramados de Santa Rita II	P G Sta Rita II
50723	SP	9285	Jardim Alvorada II	Jd Alvorada II
50727	SP	9285	1º Distrito Industrial	1º Dt Industrial
50728	SP	9044	Vila Cristina	Vl Cristina
50729	SP	8992	Chácaras São Conrado	C S Conrado
50731	SP	9726	Vila Santa Isabel	Vl Sta Isabel
50732	SP	9726	Chácara Leal	Ch Leal
50733	SP	9726	Parque das Flores	Prq Flores
50734	SP	9726	Residencial Vila Velha	Res Vl Velha
50735	SP	9726	Vila Odete	Vl Odete
50740	SP	9043	Jardim Rio Santos	Jd R Santos
50741	SP	9043	Vila Nossa Senhora Aparecida	Vl N Sra Aparecida
50742	SP	9043	Vila Ponte Seca	Vl Pte Seca
50743	SP	9726	Esplanada Santa Helena	Esp Sta Helena
50744	SP	9726	Monção	\N
50745	SP	9726	Água Quente	A Quente
50794	SP	9660	Loteamento Jardim Helena	Lot Jd Helena
50795	SP	9726	Parque São Jorge	Prq S Jorge
50796	SP	9726	Vila Areao	Vl Areao
50797	SP	9726	Jardim Mourisco	Jd Mourisco
50798	SP	9726	Jardim Garcez	Jd Garcez
50799	SP	9726	Parque Arco Íris	Prq A Íris
50800	SP	9726	Parque Sabará	Prq Sabará
50804	SP	9267	Loteamento Vila Romana	Lot Vl Romana
50813	SP	9435	Jardim Esplendor	Jd Esplendor
50814	SP	9501	Pólo Industrial Guilherme Müller Filho	P Ind G M Filho
50815	SP	8913	Sítios de Recreio Independência	S Rcr Independência
50816	SP	8913	Vila Candinha	Vl Candinha
50817	SP	9560	Colina Verde	C Verde
50818	SP	9560	Condomínio Buritis	Cond Buritis
50819	SP	9560	Jardim dos Gerânios	Jd Gerânios
50820	SP	9560	Jardim dos Hibiscos	Jd Hibiscos
50821	SP	9254	Loteamento Residencial Central Park I	Lot Res C Park I
50822	SP	9726	Alto de São João	At S João
50823	SP	9726	Chácara Doutor Hipólito	Ch Dr Hipólito
50824	SP	9726	Jardim Russi	Jd Russi
50825	SP	9726	Santa Luzia	Sta Luzia
50826	SP	9726	Vila Jaboticabeiras	Vl Jaboticabeiras
50827	SP	9726	Adélia Afonso	A Afonso
50828	SP	9726	Cidade Deus	C Deus
50829	SP	9726	Jardim Humaitá	Jd Humaitá
50830	SP	9726	Santa Rita	Sta Rita
50831	SP	9726	Vila José Pedro da Cunha	Vl J P Cunha
50836	SP	9265	Residencial Verdeville	Res Verdeville
50837	SP	9265	Residencial Royal Park	Res R Park
50904	SP	9587	Distrito Industrial do Lageado	Dt Ind Lageado
50905	SP	9725	Sena Ville	S Ville
50909	SP	9671	Saboó	\N
50910	SP	9587	Recanto do Guarau	Rec Guarau
50937	SP	9144	Esplanada Primo Menegheti	Esp Pmo Menegheti
50938	SP	9144	Jardim Piratininga	Jd Piratininga
50941	SP	8969	Parque Residencial Laluce II	Prq Res Laluce II
50942	SP	9660	Vila Alexandrina	Vl Alexandrina
50943	SP	9660	Morada do Sol	M Sol
50945	SP	9643	Jardim Social Presidente Collor	Jd S Pres Collor
50946	SP	9643	Jardim das Rosas	Jd Rosas
50947	SP	9643	Jardim Martinelli	Jd Martinelli
50450	SP	9789	Vila Residencial Morini	Vl Res Morini
50451	SP	9789	Conjunto Habitacional Jamir D'Antônio	Cj H J D'Antônio
50454	SP	9560	Jardim Saint Gerard	Jd S Gerard
50456	SP	9748	Centro(Varpa)	Centro (Varpa)
50457	SP	9748	Centro(Universo)	Centro (Universo)
50458	SP	9748	Centro(Parnaso)	Centro (Parnaso)
50462	SP	9660	Vila São Pedro	Vl S Pedro
50472	SP	9660	Jardim Diamante	Jd Diamante
50473	SP	9295	Parque Industrial II (Fazenda Grande)	Prq Industrial II (Faz Grande)
50474	SP	9295	Parque Industrial III (Fazenda Grande)	Prq Industrial III (Faz Grande)
50479	SP	8989	Vila Santa Elizabeth	Vl Sta Elizabeth
50482	SP	9566	Jardim Leblon	Jd Leblon
50483	SP	8928	Vila Santa Helena	Vl Sta Helena
50484	SP	8928	Vila Boa Esperança	Vl B Esperança
50485	SP	9660	Jardim Topázio	Jd Topázio
50486	SP	9660	Jardim Aparecida	Jd Aparecida
50489	SP	9260	Jardim Paulista	Jd Paulista
50490	SP	9560	Residencial Jatobá	Res Jatobá
50491	SP	9560	Residencial Greenville	Res Greenville
50492	SP	9560	Residencial Jequitibá	Res Jequitibá
50498	SP	9660	Jardim Valparaíba	Jd Valparaíba
50500	SP	9659	Residencial Jardim das Acácias	Res Jd Acácias
50501	SP	9659	Residencial Vitória Régia	Res V Régia
50502	SP	9660	Jardim Nova Michigan	Jd N Michigan
50567	SP	9025	Residencial Aruanã	Res Aruanã
50570	SP	8928	CTB	\N
50571	SP	8928	Ponte	\N
50572	SP	8928	Jardim do Trevo	Jd Trevo
50573	SP	8928	Jardim Terceiro Centenário	Jd T Centenário
50575	SP	9726	Jardim Morumby	Jd Morumby
50576	SP	9726	Areão	\N
50577	SP	9726	Vila Marly	Vl Marly
50578	SP	9726	Vila São Jorge	Vl S Jorge
50579	SP	9726	Vila Boa Vista	Vl B Vista
50580	SP	9726	Vila Nogueira	Vl Nogueira
50581	SP	9087	Vila Paulista	Vl Paulista
50584	SP	8913	Jardim São Conrado	Jd S Conrado
50585	SP	9321	Santa Lucrécia	Sta Lucrécia
50586	SP	9696	Jardim Parada do Alto	Jd Pda Alto
50587	SP	9647	Jardim Serra da Paulista	Jd S Paulista
50588	SP	9726	Jardim do Sol	Jd Sol
50589	SP	9726	Parque Paduan	Prq Paduan
50590	SP	9285	Vila Real	Vl Real
50591	SP	8912	Jardim Bandeirantes	Jd Bandeirantes
50592	SP	9726	Pinhão	\N
50597	SP	9177	Jardim Pérola	Jd Pérola
50598	SP	9025	Residencial Parque das Araucárias	Res Prq Araucárias
50599	SP	9265	Parque das Araras	Prq Araras
50603	SP	9726	Barreiro	\N
50604	SP	9052	Quilômetro Sete	Q Sete
50605	SP	9052	Agrícola	\N
50606	SP	9700	Jardim Santa Catarina	Jd Sta Catarina
50662	SP	9686	Quinta da Boa Sorte	Qta B Sorte
50663	SP	9686	Jardim Grande Aliança	Jd G Aliança
50664	SP	9686	Jardim Gimenez	Jd Gimenez
50665	SP	9183	Jardim Rodolfo	Jd Rodolfo
50666	SP	9005	Vila Naly	Vl Naly
50667	SP	9005	Vila Prado	Vl Prado
50668	SP	9177	Chácaras Piagui	C Piagui
50669	SP	8992	Taboão	\N
50670	SP	8992	Jardim Primavera	Jd Primavera
50671	SP	8992	Lagos de Santa Helena	L Sta Helena
50672	SP	8992	Vila Davis Lang	Vl D Lang
50673	SP	8992	Jardim do Sul	Jd Sul
50674	SP	8992	Chácara Fernão Dias	Ch F Dias
50675	SP	8992	Bosques da Pedra	B Pedra
50676	SP	9177	Jardim do Vale I	Jd Vale I
50677	SP	9177	Jardim do Vale II	Jd Vale II
50678	SP	9726	Jardim Columbia	Jd Columbia
50684	SP	9267	Da Cerejeira	D Cerejeira
50686	SP	9354	Portal da Baronesa	P Baronesa
50694	SP	9043	Balneário Copacabana	Bal Copacabana
50696	SP	9643	Jardim Santa Maria	Jd Sta Maria
50697	SP	9643	Conjunto Habitacional Dom Constantino Amstalden	Cj H D C Amstalden
50698	SP	9146	Portal da Estação	P Estação
50699	SP	8989	Domingos Lopes	D Lopes
50702	SP	9647	Jardim dos Comerciários	Jd Comerciários
50703	SP	9647	Jardim Lucas Teixeira	Jd L Teixeira
50704	SP	9647	Jardim Flamboyant	Jd Flamboyant
50705	SP	8992	Portal São Marcelo	P S Marcelo
50710	SP	9726	Vila Edmundo	Vl Edmundo
50711	SP	9726	Vila Santa Fé	Vl Sta Fé
50840	SP	8928	Condomínio Parque das Garças I	Cond Prq Garças I
50866	SP	9260	Itaim Guaçu	I Guaçu
50875	SP	8961	Parque Rossi	Prq Rossi
50894	SP	8883	Vila Vitória	Vl Vitória
50895	SP	9668	Jardim Colibri	Jd Colibri
50900	SP	9240	Jardim São Sebastião	Jd S Sebastião
50902	SP	9560	Jardim Monte Carlo	Jd Mte Carlo
51009	SP	8928	Vila Helena	Vl Helena
51010	SP	9177	Núcleo Residencial Costa e Silva	Nuc Res C E Silva
51011	SP	9177	Vila Indiana	Vl Indiana
51013	SP	9659	Residencial Santa Filomena	Res Sta Filomena
51014	SP	9659	Parque das Perdizes	Prq Perdizes
51015	SP	9659	Residencial Vila Flora	Res Vl Flora
51113	SP	9216	Jardim Paulista I	Jd Paulista I
51114	SP	9216	Jardim Paulista II	Jd Paulista II
51115	SP	9216	Jardim Paulistano	Jd Paulistano
51116	SP	9183	Jardim Nova Canaã	Jd N Canaã
51117	SP	9183	Parque Jandaia II	Prq Jandaia II
51118	SP	9348	Jardim Altos do Palmital	Jd A Palmital
51126	SP	8992	Brasil	\N
51128	SP	9647	Jardim Santa Águida	Jd Sta Águida
51129	SP	9144	Residencial São Domingos	Res S Domingos
51134	SP	8992	Jardins	\N
51139	SP	8928	Jardim Suiça	Jd Suiça
51140	SP	8928	Vila Esperia ou Giglio	Vl E O Giglio
51141	SP	8977	Novo Mundo	N Mundo
51142	SP	9686	Jardim Santa Rosa	Jd Sta Rosa
51143	SP	9686	Jardim Santa Bárbara	Jd Sta Bárbara
51144	SP	9686	Jardim Santa Lucia	Jd Sta Lucia
51145	SP	8989	Zona Rural	Z Rural
51223	SP	9025	Alto Belém	At Belém
51224	SP	9696	Jardim Santa Helena	Jd Sta Helena
51227	SP	9025	Loteamento Center Santa Genebra	Lot C Sta Genebra
51228	SP	9025	Jardim Irajá	Jd Irajá
51264	SP	8928	Vila Esperança	Vl Esperança
51267	SP	9025	Santa Clara	Sta Clara
51268	SP	9319	Novo Milênio	N Milênio
51278	SP	8926	Jardim Aeroporto	Jd Aeroporto
51287	SP	9043	Jardim Terralão	Jd Terralão
51288	SP	9043	Costa Nova	C Nova
51289	SP	9043	Park Imperial	P Imperial
51292	SP	9265	Jardim Paraty	Jd Paraty
51341	SP	9671	Centro (São João Novo)	Centro (S J Novo)
51342	SP	9671	Vila Bello (São João Novo)	Vl Bello (S J Novo)
51343	SP	9671	Vila Holf (São João Novo)	Vl Holf (S J Novo)
51344	SP	9671	Volta Grande (São João Novo)	V Grande (S J Novo)
51345	SP	9595	Vila Pântano II	Vl Pântano II
51347	SP	9260	Parque do Varvito	Prq Varvito
51399	SP	9668	Vila Hortência	Vl Hortência
51016	SP	9659	Condomínio Green Palm	Cond G Palm
51017	SP	9659	Green Fields Residence Club	G F R Club
51018	SP	9659	Residencial Eco Village I	Res E Village I
51019	SP	8969	Jandaia II Residencial Parque	J II Res Parque
51020	SP	9044	Águas da Fazendinha	A Fazendinha
51022	SP	9659	Residencial Amazonas	Res Amazonas
51023	SP	9659	Residencial Machado I	Res Machado I
51024	SP	9267	Terras de Sant'Anna	T Sant'Anna
51029	SP	9560	Condomínio Vista Alegre	Cond V Alegre
51030	SP	9560	Condomínio Garden Ville	Cond G Ville
51037	SP	9005	Jardim Julieta	Jd Julieta
51040	SP	9660	Condomínio Villagio Fazendão	Cond V Fazendão
51041	SP	9043	Praia da Mococa	Pr Mococa
51042	SP	9560	Jardim Ângelo Jurca	Jd A Jurca
51046	SP	9043	Parque Balneário Poiares	Prq Bal Poiares
51047	SP	9254	Bairro do Morro	B Morro
51049	SP	9660	Condomínio Residencial Jardins	Cond Res Jardins
51052	SP	9566	Jardim Figueira	Jd Figueira
51053	SP	9295	Residencial Pellizzari	Res Pellizzari
51056	SP	9005	Chácaras Encosta de São Carlos	C E S Carlos
51061	SP	9183	Jardim Giovana	Jd Giovana
51174	SP	9082	da Capelinha	Capelinha
51175	SP	8928	Condomínio da Represa	Cond Represa
51186	SP	9560	Jardim Doutor Paulo Gomes Romeo	Jd Dr P G Romeo
51187	SP	9660	Residencial Ribeira	Res Ribeira
51199	SP	9668	Parque da Lapa	Prq Lapa
51208	SP	8913	Jardim Portal do Parque	Jd P Parque
51209	SP	8917	Santa Izabel	Sta Izabel
51213	SP	8928	Vila Mira	Vl Mira
51214	SP	8913	Jardim Itamaraty	Jd Itamaraty
51216	SP	9371	Residencial Salvato	Res Salvato
51217	SP	8928	Itapetinga	\N
51221	SP	9493	CECAP	\N
51306	SP	9696	Jardim Cardoso	Jd Cardoso
51307	SP	9696	Jardim Maria Elvira	Jd M Elvira
51314	SP	9043	Balneário Califórnia	Bal Califórnia
51316	SP	9671	Centro (Canguera)	\N
51317	SP	9671	Centro (Mailasqui)	\N
51318	SP	9671	Bairro do Carmo (Canguera)	B Carmo (Canguera)
51319	SP	9671	Durando Mumare (Mailasqui)	D Mumare (Mailasqui)
51320	SP	9671	Vila Vilma (Mailasqui)	Vl Vilma (Mailasqui)
51321	SP	9671	Taipas De Pedras (Mailasqui)	T D Pedras (Mailasqui)
51322	SP	9671	Loteamento Sítio Pinheiral (Mailasqui)	Lot Sit Pinheiral (Mailasqui)
51323	SP	9671	Juca Rocha (Mailasqui)	J Rocha (Mailasqui)
51324	SP	9671	Pavão (Canguera)	\N
51325	SP	9671	Caete (Mailasqui)	\N
51326	SP	9671	Campininha (Canguera)	\N
51327	SP	9671	Alto Da Serra (Mailasqui)	At D Serra (Mailasqui)
51328	SP	9671	Alpes Paulista (Mailasqui)	A Paulista (Mailasqui)
51329	SP	9671	Jardim Dos Andes (Mailasqui)	Jd D Andes (Mailasqui)
51330	SP	9671	Jardim Vera Cruz (Mailasqui)	Jd V Cruz (Mailasqui)
51331	SP	9671	Bairro do Rosário (Mailasqui)	B Rosário (Mailasqui)
51332	SP	9671	Jardim Caparelli (Mailasqui)	Jd Caparelli (Mailasqui)
51333	SP	9671	Jardim Vinhas Do Sol (Mailasqui)	Jd V D Sol (Mailasqui)
51334	SP	9671	Jardim Ponta-Porã (Mailasqui)	Jd Ponta-Porã (Mailasqui)
51335	SP	9671	Jardim Cardoso (Mailasqui)	Jd Cardoso (Mailasqui)
51336	SP	9671	Vila Darcy Penteado (Mailasqui)	Vl D Penteado (Mailasqui)
51338	SP	9532	Residencial São Paulo	Res S Paulo
51457	SP	9450	Centro	\N
51539	SP	8883	Parque Universitário	Prq Universitário
51555	SP	9370	Jardim Canaã II	Jd Canaã II
51558	SP	9595	Chácaras de Recreio Paraíso	C Rcr Paraíso
51563	SP	9043	Delfim Verde	D Verde
51985	SP	9660	Jardim Beira Rio	Jd B Rio
51565	SP	9043	Portal da Fazendinha	P Fazendinha
51566	SP	9043	Capricónio III	\N
51568	SP	9043	Capricórnio II	\N
51570	SP	9043	Jardim Santa Rosa	Jd Sta Rosa
51571	SP	9043	Mirante da Orla	M Orla
51590	SP	8992	Vila Esperança	Vl Esperança
51591	SP	8992	Parque dos Estados	Prq Estados
51592	SP	8992	Chácara Julieta Cristina	Ch J Cristina
51612	SP	9317	Residencial dos Girassóis	Res Girassóis
51613	SP	9317	Residencial Las Palmas	Res L Palmas
51679	SP	9295	Parque dos Ingás	Prq Ingás
51680	SP	9285	Jardim Dona Emília	Jd Da Emília
51681	SP	9647	Jardim América do Sul	Jd A Sul
51682	SP	9025	Condomínio Residencial Espaço Verde I	Cond Res E Verde I
51683	SP	9025	Condomínio Residencial Espaço Verde II	Cond Res E Verde II
51692	SP	9493	Parque Conceição II	Prq Conceição II
51693	SP	9317	Bairro da Geada	B Geada
51694	SP	9726	Chácara Santa Luzia	Ch Sta Luzia
51695	SP	9726	Santa Luzia Rural	Sta L Rural
51699	SP	9025	Swiss Park	S Park
51701	SP	9177	Parque das Árvores	Prq Árvores
51702	SP	9726	Caixa D'água	C D'água
51703	SP	9726	Jardim Liete	Jd Liete
51704	SP	9726	Chácaras Reunidas Brasil	C R Brasil
51705	SP	9144	Residencial Itapuã	Res Itapuã
51710	SP	9348	Centro (Amadeu Amaral)	Centro (A Amaral)
51717	SP	9348	Avencas (Avencas)	\N
51723	SP	8992	Vila Edna	Vl Edna
51724	SP	9113	Quinhaú	\N
51725	SP	9348	Américo José de Oliveira (Rosália)	A J Oliveira (Rosália)
51726	SP	9348	Centro (Rosália)	\N
51727	SP	9025	Núcleo Residencial Parque Pinheiros	Nuc Res Prq Pinheiros
51778	SP	9348	Sítios de Recreio Shangrilá (Padre Nóbrega)	S Rcr Shangrilá (Pe Nóbrega)
51779	SP	9348	Sítios de Recreio Santa Rosa (Padre Nóbrega)	S Rcr Sta Rosa (Pe Nóbrega)
51787	SP	9267	Estância Porto Velho	Etn Pto Velho
51792	SP	9647	Jardim Europa	Jd Europa
51804	SP	8992	Jardim do Cedro	Jd Cedro
51805	SP	9285	Jardim Orlando Chesini Ometto II	Jd O C Ometto II
51809	SP	9315	Jardim Vila Rica	Jd Vl Rica
51810	SP	8992	Vila São Caetano	Vl S Caetano
51811	SP	8992	Vale Encantado	Vle Encantado
51814	SP	9315	Jardim Universitário	Jd Universitário
51825	SP	9587	Canjica	\N
51828	SP	8992	Jardim Carlota	Jd Carlota
51834	SP	8938	Baguacu	\N
51835	SP	8953	Barrânia	\N
51841	SP	8992	Jardim Paturi	Jd Paturi
51842	SP	8992	Jardim Nova América	Jd N América
51935	SP	8912	Jardim Residencial Maggiore	Jd Res Maggiore
51954	SP	9696	Jardim Santa Paula	Jd Sta Paula
51491	SP	9025	Núcleo Residencial Getúlio Vargas	Nuc Res G Vargas
51497	SP	9025	Conjunto Habitacional Campinas F	Cj H Campinas F
51503	SP	8933	Reserva do Horto	R Horto
51508	SP	8969	Villa do Chafariz	V Chafariz
51617	SP	9660	Condomínio Colinas do Parahyba	Cond C Parahyba
51622	SP	9043	Capricórnio III	\N
51625	SP	9025	Loteamento Residencial Jaguari (Sousas)	Lot Res Jaguari (Sousas)
51628	SP	9485	Loteamento Residencial e Comercial Vila São Paulo	Lot Res C Vl S Paulo
51633	SP	9348	Dirceu (Distrito de Marilia)	Dirceu (Dt Marilia)
51635	SP	9660	Conjunto Residencial Vila Leila	Cj Res Vl Leila
51638	SP	9493	Centro (Tupi)	\N
51639	SP	9493	Parque Peória (Tupi)	Prq Peória (Tupi)
51640	SP	9493	Jardim Bartira (Tupi)	Jd Bartira (Tupi)
51662	SP	9560	Condomínio Chácaras Itambé	Cond C Itambé
51663	SP	9043	Capricórnio I	\N
51664	SP	8992	Jardim Anchieta	Jd Anchieta
51666	SP	9005	Loteamento Real Park	Lot R Park
51668	SP	8961	Chácaras Odete	C Odete
51669	SP	8961	Residencial Tavano	Res Tavano
51670	SP	8961	Residencial Sauípe	Res Sauípe
51671	SP	8961	Residencial Ilha de Capri	Res Ia Capri
51742	SP	9696	Jardim Millenium	Jd Millenium
51743	SP	9696	Jardim Portobello	Jd Portobello
51744	SP	8992	Curitibanos	\N
51745	SP	8992	Quintas de Bragança	Qtas Bragança
51746	SP	9189	Sítio Panorama	Sit Panorama
51748	SP	9144	Residencial Anna Terra	Res A Terra
51754	SP	8992	Quinta do Barão	Qta Barão
51755	SP	8992	Residencial dos Lagos	Res Lagos
51756	SP	9317	Villaggio San Pietro	V S Pietro
51757	SP	9636	Pompéia	\N
51758	SP	9756	Centro	\N
51761	SP	8913	Jardim Residencial Lago Azul	Jd Res Lg Azul
51765	SP	8992	Conjunto Habitacional Francisco Sabella	Cj H F Sabella
51766	SP	9348	Centro (Lácio)	\N
51767	SP	9348	José Ferreira da Costa Júnior (Lácio)	J F C Júnior (Lácio)
51768	SP	9348	CDHU (Lácio)	\N
51769	SP	9348	Pedro Pereira de Mesquita (Lácio)	P P Mesquita (Lácio)
51770	SP	9348	Centro (Padre Nóbrega)	Centro (Pe Nóbrega)
51771	SP	9348	Parque dos Sabiás (Padre Nóbrega)	Prq Sabiás (Pe Nóbrega)
51772	SP	9348	Parque dos Sabiás II (Padre Nóbrega)	Prq Sabiás II (Pe Nóbrega)
51773	SP	9348	Jardim Santa Rosa (Padre Nóbrega)	Jd Sta Rosa (Pe Nóbrega)
51774	SP	9348	Por do Sol (Padre Nóbrega)	P Sol (Pe Nóbrega)
51775	SP	9348	Chácara de Recreio Letícia II (Padre Nóbrega)	Ch Rcr Letícia II (Pe Nóbrega)
51777	SP	9348	Sítios de Recreio Letícia (Padre Nóbrega)	S Rcr Letícia (Pe Nóbrega)
51844	SP	8992	Centro Industrial Rafael Diniz	C Ind R Diniz
51852	SP	9671	Sorocamirim (Canguera)	\N
51854	SP	9660	Vila Adriana	Vl Adriana
51868	SP	9025	Núcleo Residencial Padre Josimo	Nuc Res Pe Josimo
51869	SP	9348	Residencial Portal da Serra	Res P Serra
51881	SP	9660	Jardim Rodolfo	Jd Rodolfo
51886	SP	9371	Condomínio Residencial dos Jequitibás	Cond Res Jequitibás
51992	SP	9725	Jardim Mantovani	Jd Mantovani
51995	SP	9082	do Ribeirão	Ribeirão
51999	SP	9216	Villaggio Di Itaici	V Di Itaici
52006	SP	9485	Residencial Jardim Aurora	Res Jd Aurora
52007	SP	8928	Altos da Floresta	A Floresta
52008	SP	9485	Residencial Liberdade (Moreira César)	Res Liberdade (M César)
52009	SP	9726	Registro	\N
52010	SP	9660	Jardim Nova América	Jd N América
52011	SP	9660	Conjunto Residencial Vale dos Pinheiros	Cj Res Vle Pinheiros
52012	SP	9660	Vila Santa Rita	Vl Sta Rita
52014	SP	9660	Condomínio Royal Park	Cond R Park
52030	SP	8992	Conjunto Habitacional Nova Cidade	Cj H N Cidade
52038	SP	9244	Mário Cega	M Cega
52039	SP	9244	Nenê Cega	N Cega
52052	SP	8969	Residencial Art Ville	Res A Ville
52053	SP	9014	Núcleo do Assentamento da Agrovila III	Nuc A Agrovila III
52054	SP	9485	Borba	\N
52058	SP	9043	Balneário Recanto do Sol	Baln Rec Sol
52130	SP	9485	Água Preta	A Preta
52131	SP	9485	Cruz Pequena	C Pequena
52132	SP	9485	Socorro	\N
52135	SP	9660	Conjunto Habitacional da Policia Militar	Cj H P Militar
52144	SP	9726	Conjunto Habitacional José Benedito de Moura Bona	Cj H J B M Bona
52145	SP	9726	Vila dos Comerciários 2	Vl Comerciários 2
52152	SP	9260	Jardim Santos Dumont	Jd Stos Dumont
52154	SP	9189	Jardim Estrela	Jd Estrela
52158	SP	9189	Paraíso Novo Ângulo	P N Ângulo
52159	SP	9189	Jardim Brasil	Jd Brasil
52160	SP	9189	Jardim Flamboyant	Jd Flamboyant
52163	SP	9267	Jardim Coleginho	Jd Coleginho
52168	SP	9082	Recreio Topázio (Caucaia do Alto)	Rcr Topázio (C Alto)
52170	SP	9317	Jardim Recanto Verde	Jd Rec Verde
52171	SP	9025	Alphaville Dom Pedro	A D Pedro
52225	SP	9274	Vila Nossa Senhora Aparecida	Vl N Sra Aparecida
52226	SP	9274	Conjunto Habitacional Roque Viola	Cj H R Viola
52227	SP	9274	Conjunto Habitacional Vereador Dercilio Joaquim Carvalho	Cj H Ver D J Carvalho
52228	SP	9274	Conjunto Habitacional Vereador Santo Hernandes Argentina	Cj H Ver Sto H Argentina
52229	SP	9274	Residencial Big Plaza	Res B Plaza
52230	SP	9274	Jardim América - Primeira Parte	Jd América - P Parte
52231	SP	9274	Jardim América - Segunda Parte	Jd América - S Parte
52232	SP	9274	Jardim América - Quarta Parte	Jd América - Q Parte
52233	SP	9274	Jardim América - Terceira Parte	Jd América - T Parte
52234	SP	9274	Jardim Trianon	Jd Trianon
52235	SP	9274	Vila União	Vl União
52236	SP	9274	Jardim Romero	Jd Romero
52237	SP	9274	Jardim Europa	Jd Europa
52238	SP	9274	Loteamento Avenida	Lot Avenida
52239	SP	9274	Jardim Nova Vida	Jd N Vida
52240	SP	9274	Vila Rodrigues	Vl Rodrigues
52241	SP	9274	Loteamento Fassa	Lot Fassa
52242	SP	9274	Vila Micena	Vl Micena
52243	SP	9274	Vila Goldoni	Vl Goldoni
52244	SP	9274	Jardim Micena	Jd Micena
52245	SP	9274	Vila Helizabeth	Vl Helizabeth
52246	SP	9274	Vila Santa Ignez	Vl Sta Ignez
52247	SP	9274	Jardim Castelo	Jd Castelo
52248	SP	9274	Jardim Monterey	Jd Monterey
52249	SP	9274	Aeroporto Municipal	Aer Municipal
52250	SP	9274	Parque Industrial I	Prq Industrial I
52251	SP	9274	Jardim do Bosque	Jd Bosque
52252	SP	9274	Parque das Flores	Prq Flores
52253	SP	9274	Jardim Pêgolo	Jd Pêgolo
52254	SP	9274	Vila São José	Vl S José
52256	SP	9274	IV Centenário	\N
52257	SP	9274	Vila Pinheiro	Vl Pinheiro
52258	SP	9274	Vila Norma	Vl Norma
52259	SP	9274	Jardim Maria Paula	Jd M Paula
52260	SP	9274	Residencial Maria Silveira	Res M Silveira
52261	SP	9274	Jardim Morumbi	Jd Morumbi
52262	SP	9274	Jardim Bom Jesus	Jd B Jesus
52263	SP	9274	Jardim São Jorge	Jd S Jorge
52264	SP	9274	Vila Ines	Vl Ines
52265	SP	9274	Jardim Brasil	Jd Brasil
52266	SP	9274	Vila Talma	Vl Talma
52267	SP	9274	Jardim Tangará	Jd Tangará
52268	SP	9274	Jardim Eldorado	Jd Eldorado
52269	SP	9274	Jardim Guarani	Jd Guarani
52270	SP	9274	Parque São Bernardo	Prq S Bernardo
52179	SP	9144	Pólo Industrial Amazonas	P Ind Amazonas
52180	SP	9144	Polo Industrial Abilio Nogueira	P Ind A Nogueira
52183	SP	8928	Vila Salles	Vl Salles
52189	SP	9485	Residencial Campo Belo	Res Cpo Belo
52191	SP	9696	Itavuvu	\N
52192	SP	8992	Chácara Alvorada	Ch Alvorada
52193	SP	8992	Jardim Iguatemi	Jd Iguatemi
52194	SP	8992	Jardim Vista Alegre	Jd V Alegre
52195	SP	8992	Campo Novo	Cpo Novo
52196	SP	8992	Altos de Bragança	A Bragança
52209	SP	9348	Distrito Industrial Luiz Toffoli (Lácio)	Dt Ind L Toffoli (Lácio)
52210	SP	9348	Sebastiana Seixas Dias Toffoli (Lácio)	S S D Toffoli (Lácio)
52211	SP	8928	Parque Piracema	Prq Piracema
52212	SP	8928	Recreio São Vicente	Rcr S Vicente
52214	SP	9274	Jardim Santo Expedito	Jd Sto Expedito
52215	SP	9274	Jardim Ana Cristina	Jd A Cristina
52216	SP	9274	Jardim Samambaia	Jd Samambaia
52217	SP	9274	Jardim Aclimação	Jd Aclimação
52218	SP	9274	Jardim Estados Unidos	Jd E Unidos
52219	SP	9274	Jardim Paulista	Jd Paulista
52220	SP	9274	Jardim São Gabriel	Jd S Gabriel
52221	SP	9274	Parque Industrial III	Prq Industrial III
52222	SP	9274	Conjunto Habitacional Doutor Arnaldo Silveira	Cj H Dr A Silveira
52223	SP	9274	Jardim Paraíso	Jd Paraíso
52224	SP	9274	São Judas Tadeu	S J Tadeu
52271	SP	9274	Jardim São Francisco de Assis	Jd S F Assis
52272	SP	9274	FACIP	\N
52273	SP	9274	Jardim Soraia	Jd Soraia
52274	SP	9274	Aeroporto	\N
52275	SP	9274	Jardim Municipal	Jd Municipal
52276	SP	9274	Conjunto Habitacional Renascer	Cj H Renascer
52277	SP	9274	Conjunto Habitacional Nelzia Stellutte	Cj H N Stellutte
52278	SP	9274	Jardim Pires de Andrade	Jd P Andrade
52279	SP	9274	Alto do Ipê	At Ipê
52280	SP	9274	Vila Nascimento	Vl Nascimento
52281	SP	9274	Vila Stafusa	Vl Stafusa
52282	SP	9274	Jardim Oiti	Jd Oiti
52283	SP	9274	Residencial São Lucas	Res S Lucas
52284	SP	9274	Jardim das Palmeiras	Jd Palmeiras
52285	SP	9274	Jardim Primavera	Jd Primavera
52286	SP	9274	Vila Santa Izabel	Vl Sta Izabel
52287	SP	9274	Chácaras Alto do Marimbondo	C At Marimbondo
52288	SP	9274	Chácara Bela Vista	Ch B Vista
52289	SP	9274	Chácaras Bandeirantes	C Bandeirantes
52290	SP	9274	Jardim Pêgolo II	Jd Pêgolo II
52291	SP	9274	Vila Nossa Senhora Aparecida da Boa Vista	Vl N Sra A B Vista
52292	SP	9274	Residencial Duana	Res Duana
52293	SP	9274	Subida Preta	Sub Preta
52294	SP	9274	Vila Maria	Vl Maria
52295	SP	9274	Jardim Paulo VI	Jd Paulo VI
52296	SP	9274	Jardim Novo Mundo	Jd N Mundo
52297	SP	9274	Jardim Brasília	Jd Brasília
52298	SP	9274	Córrego do Açude	Crg Açude
52299	SP	9274	Jardim Ipiranga	Jd Ipiranga
52300	SP	9274	Jardim Zaffani	Jd Zaffani
52301	SP	9274	Jardim Arapuã	Jd Arapuã
52302	SP	9274	Conjunto Habitacional Jardim Arapuã	Cj H Jd Arapuã
52303	SP	9274	Conjunto Habitacional Doutor Pedro Nogueira	Cj H Dr P Nogueira
52304	SP	9274	Jardim Residencial Alvorada	Jd Res Alvorada
52305	SP	9274	Conjunto Habitacional José Antonio Caparroz Bogaz II	Cj H J A C Bogaz II
52306	SP	9274	Conjunto Habitacional José Antonio Caparroz Bogaz	Cj H J A C Bogaz
52307	SP	9274	Parque Industrial II	Prq Industrial II
52308	SP	9274	Jardim Doutor Euplhy Jalles	Jd Dr E Jalles
52315	SP	9216	Pimenta	\N
52316	SP	9216	Jardim Aquarius	Jd Aquarius
52369	SP	9044	Aldeia da Fazendinha	\N
52372	SP	9295	Conjunto Habitacional Vista Alegre	Cj H V Alegre
52373	SP	9266	Jardim Serra II	Jd Serra II
52375	SP	9775	Condomínio Chacur	Cond Chacur
52378	SP	9037	Querência do Turvo	Q Turvo
52379	SP	9725	Boqueirão	\N
52380	SP	9660	Residencial Tatetuba	Res Tatetuba
52381	SP	9025	Agreste	\N
52384	SP	9493	Conceição	\N
52387	SP	9216	Jardim Portal do Sol	Jd P Sol
52388	SP	9726	Jardim Santa Catarina	Jd Sta Catarina
52389	SP	9768	Jardim Nova Palmares II	Jd N Palmares II
52391	SP	8928	Jardim São Felipe	Jd S Felipe
52392	SP	8928	Campos de Atibaia	C Atibaia
52393	SP	8928	Pau Arcado	P Arcado
52394	SP	8928	Chácara Brisa da serra	Ch B serra
52396	SP	9267	Jardim Vista Verde	Jd V Verde
52397	SP	9267	Jardim Beira Rio	Jd B Rio
52399	SP	9768	Parque dos Cocais	Prq Cocais
52400	SP	9267	Jardim Olympia	Jd Olympia
52401	SP	8992	Lavapés	\N
52402	SP	8992	Vila Gato	Vl Gato
52404	SP	8992	Jardim Recanto Alegre	Jd Rec Alegre
52405	SP	8992	Jardim Paulista	Jd Paulista
52409	SP	8992	Jardim Bela Vista	Jd B Vista
52413	SP	8992	Jardim da Fraternidade	Jd Fraternidade
52577	SP	9660	Jardim Castanheira	Jd Castanheira
52578	SP	9660	Jardim Santa Maria	Jd Sta Maria
52646	SP	9113	Parque Industrial de Embu	Prq Ind Embu
52655	SP	9700	Residencial Amália Luíza	Res A Luíza
52657	SP	8928	Rio Acima	R Acima
52659	SP	9686	Distrito Industrial e Empresarial 2	Dt Ind Empresarial 2
52660	SP	9686	Distrito Industrial e Empresarial 3	Dt Ind Empresarial 3
52661	SP	8912	Jardim Florença	Jd Florença
52662	SP	9317	Residencial Ilha de Bali	Res Ia Bali
52663	SP	9317	Bairro dos Lopes	B Lopes
52665	SP	9726	Vila Velha II	Vl Velha II
52669	SP	8913	Jardim Santa Catarina	Jd Sta Catarina
52680	SP	9043	Benfica	\N
52681	SP	9043	Ipiranga	\N
52684	SP	8992	Vila Celina	Vl Celina
52740	SP	8961	Residencial Villa Lobos	Res V Lobos
52744	SP	8933	Loteamento São Judas Tadeu IV	Lot S J Tadeu IV
52748	SP	9435	Loteamento Jardim Esmeralda	Lot Jd Esmeralda
52749	SP	9285	Condomínio Flamboyant	Cond Flamboyant
52750	SP	8933	Cid Ferreira	C Ferreira
52751	SP	9493	Residencial Portal da Água Branca	Res P A Branca
52752	SP	9267	Jardim Pitoresco	Jd Pitoresco
52754	SP	9671	Vila Santa Terezinha(São João Novo)	Vl Sta Terezinha (S J Novo)
52766	SP	9315	Vale Verde	Vle Verde
52769	SP	9242	Conjunto Habitacional Danilo Lucano Gimenez	Cj H D L Gimenez
52770	SP	9696	Jardim Golden Park Residencial	Jd G P Residencial
52773	SP	9493	Loteamento Humberto Venturini	Lot H Venturini
52777	SP	8992	Jardim do Lago	Jd Lago
52778	SP	9700	Jardim Residencial Ravagnani	Jd Res Ravagnani
52779	SP	8992	Vila Sônia	Vl Sônia
52781	SP	9671	Jardim Santa Vitória (Canguera)	Jd Sta Vitória (Canguera)
52317	SP	9696	Ibiti Royal Park	I R Park
52330	SP	9595	Jardim Mollon	Jd Mollon
52332	SP	9595	Jardim Adélia II	Jd Adélia II
52338	SP	9323	Jardim Niero	Jd Niero
52340	SP	8992	Recanto Maranata	Rec Maranata
52341	SP	8992	Estância Bragança	Etn Bragança
52353	SP	9295	Jardim Marambaia II (Jardim Santa Gertrudes)	Jd Marambaia II (Jd Sta Gertrudes)
52361	SP	9659	Parque Setorial	Prq Setorial
52364	SP	9144	Distrito Industrial Abdalla Hajel	Dt Ind A Hajel
52365	SP	9144	Distrito Industrial Onofre Jacometi	Dt Ind O Jacometi
52367	SP	9216	Jardim Amstalden Residence	Jd A Residence
52453	SP	9668	Cidade de Deus	C Deus
52483	SP	9005	Vila Quirino	Vl Quirino
52484	SP	9043	Jardim Tarumãs	Jd Tarumãs
52486	SP	8912	Residencial Village Damha	Res V Damha
52487	SP	8912	Parque Residencial Damha	Prq Res Damha
52493	SP	9285	Loteamento Residencial Maria Isabel	Lot Res M Isabel
52497	SP	9659	Parque Residencial Lauriano Tebar II	Prq Res L Tebar II
52498	SP	9659	Residencial Quinta da Mata	Res Qta Mata
52499	SP	9659	Residencial Palestra	Res Palestra
52500	SP	9659	Residencial Quinta do Golfe	Res Qta Golfe
52501	SP	9659	Chácara Bela Vista	Ch B Vista
52502	SP	9659	Residencial Village Damha Rio Preto II	Res V D R Preto II
52503	SP	9659	Residencial Bom Sucesso	Res B Sucesso
52507	SP	9144	Residencial Peres Elias	Res P Elias
52523	SP	9144	Residencial Santa Clara	Res Sta Clara
52579	SP	9660	Jardim Castanheira II	Jd Castanheira II
52580	SP	9267	Jardim do Marquês	Jd Marquês
52585	SP	9144	Prolongamento Parque das Esmeraldas	Prl Prq Esmeraldas
52607	SP	9668	Vila Isabel (Parelheiros)	Vl Isabel (Parelheiros)
52608	SP	8912	Jardim Vale das Rosas II	Jd Vle Rosas II
52609	SP	8912	Jardim Imperatriz	Jd Imperatriz
52610	SP	8912	Jardim Bounganville	Jd Bounganville
52611	SP	8912	Jardim São Rafael	Jd S Rafael
52615	SP	9659	Centro (Engenheiro Schmitt)	Centro (Eng Schmitt)
52616	SP	9659	Jardim Schmitt	Jd Schmitt
52617	SP	9659	Loteamento Residencial Antoniassi	Lot Res Antoniassi
52618	SP	9659	Parque das Amoras	Prq Amoras
52620	SP	9659	Centro (Talhado)	\N
52690	SP	9369	Real Park Tietê Jundiapeba	R P T Jundiapeba
52691	SP	9369	Parque São Martinho	Prq S Martinho
52719	SP	9493	Chácara São Jorge	Ch S Jorge
52720	SP	8912	Jardim São Jorge	Jd S Jorge
52723	SP	9113	Prado Rangel	P Rangel
52806	SP	9587	Jardim Panorama	Jd Panorama
52819	SP	8969	Bosque da Saúde II	Bsq Saúde II
52820	SP	8969	Chácara de Recreio Vila Rica	Ch Rcr Vl Rica
52821	SP	9435	Jardim Oriental	Jd Oriental
52824	SP	9668	Jardim Ninho Verde II	Jd N Verde II
52825	SP	8933	Loteamento São Judas Tadeu II	Lot S J Tadeu II
52826	SP	9267	Jardim Yolanda	Jd Yolanda
52832	SP	9082	dos Neves (Caucaia do Alto)	Neves (C Alto)
52911	SP	8907	Condomínio Residencial Delta Norte	Cond Res D Norte
53035	SP	9435	Loteamento Residencial Recanto dos Pássaros	Lot Res Rec Pássaros
53036	SP	9485	Vitória Vale III	V Vale III
53041	SP	8886	Jardim Europa	Jd Europa
53042	SP	9696	Jardim Residencial Vivenda do Itavuvu	Jd Res V Itavuvu
53043	SP	9485	Residencial e Comercial Portal dos Eucaliptos	Res C P Eucaliptos
53054	SP	9267	Vila São Judas Tadeu	Vl S J Tadeu
53057	SP	9371	Morro Vermelho	Mro Vermelho
53082	SP	8913	Jardim da Colina	Jd Colina
52861	SP	9370	Jardim Santa Mônica II	Jd Sta Mônica II
52868	SP	8907	Jardim Etharari	Jd Etharari
52869	SP	8907	Jardim Moreira	Jd Moreira
52876	SP	9244	Loteamento José Casimiro Rodrigues	Lot J C Rodrigues
52877	SP	9285	Residencial Chácara Botelho	Res Ch Botelho
52899	SP	9267	Jardim São Luiz	Jd S Luiz
52994	SP	9485	Mombaça	\N
53001	SP	9015	Parque Empresarial	Prq Empresarial
53010	SP	8912	Jardim São Francisco	Jd S Francisco
53013	SP	9435	Jardim Ideal	Jd Ideal
53014	SP	9348	Jardim Colorado	Jd Colorado
53016	SP	8883	Loteamento Residencial Jardim Jacyra	Lot Res Jd Jacyra
53019	SP	9668	Jardim Novo Pantanal	Jd N Pantanal
53032	SP	9183	Parque Industrial Arami	Prq Ind Arami
53110	SP	9671	Planalto Verde	P Verde
53111	SP	9660	Condomínio Chácara Serimbura	Cond Ch Serimbura
53114	SP	9643	Jardim Tijuca	Jd Tijuca
53115	SP	9643	Jardim Taiti	Jd Taiti
53126	SP	9532	Conjunto Habitacional José de Souza Reis	Cj H J S Reis
53127	SP	9725	Jardim San Raphael	Jd S Raphael
53129	SP	8989	Vila Aparecida	Vl Aparecida
53132	SP	9493	Tanquinho (Guamium)	\N
53133	SP	9183	Parque Piratininga	Prq Piratininga
53134	SP	9183	Vila Branca	Vl Branca
53136	SP	9493	Vivendas Bela Vista	V B Vista
53141	SP	9370	Cachoeira de Baixo	C Baixo
53142	SP	8913	Jardim Alto da Colina	Jd At Colina
53215	SP	9285	Jardim Olaria (Potunduva)	Jd Olaria (Potunduva)
53216	SP	9285	Jardim Concorde (Potunduva)	Jd Concorde (Potunduva)
53217	SP	9285	Distrito de Potunduva (Potunduva)	Dt Potunduva (Potunduva)
53218	SP	9285	Jardim Esperança (Potunduva)	Jd Esperança (Potunduva)
53219	SP	9285	Vila Nova Cachoeirinha (Potunduva)	Vl N Cachoeirinha (Potunduva)
53220	SP	9285	Jardim Frei Galvão (Potunduva)	Jd Fr Galvão (Potunduva)
53222	SP	9464	Vila Bressani	Vl Bressani
53223	SP	9295	Novo Horizonte	N Horizonte
53224	SP	9432	Jardim Cirino	Jd Cirino
53232	SP	8969	Residencial De Colores	Res D Colores
53234	SP	9348	Villa Flora	V Flora
53239	SP	9435	Residencial Parque das Flores	Res Prq Flores
53240	SP	9435	Jardim Vereda I	Jd Vereda I
53248	SP	9432	Jardim Nogueira	Jd Nogueira
53252	SP	9134	Fazenda Velha	Faz Velha
53316	SP	9267	Vila Ita	Vl Ita
53317	SP	9005	Bairro do Grama	B Grama
53332	SP	9317	Distrito Industrial Prefeito Sebastião Fumagalli	Dt Ind Pref S Fumagalli
53337	SP	9686	Cruz das Posses	C Posses
53339	SP	9686	Jardim Ouro Verde (Cruz das Posses)	Jd O Verde (C Posses)
53340	SP	9686	Pedro Dorascenzi (Cruz das Posses)	P Dorascenzi (C Posses)
53354	SP	8928	Nova Cerejeira	N Cerejeira
53359	SP	9696	Jardim Topázio	Jd Topázio
53367	SP	8956	Votupoca	\N
53368	SP	8956	Parque Ribeiro de Lima	Prq R Lima
53370	SP	9183	Anita Garibaldi	A Garibaldi
53417	SP	9696	Jardim Residencial Villa Olympia	Jd Res V Olympia
53420	SP	8989	Conjunto Habitacional José Antonio Lungo	Cj H J A Lungo
53421	SP	9647	Jardim Recanto dos Pássaros II	Jd Rec Pássaros II
53424	SP	8891	Bairro São Francisco	B S Francisco
53434	SP	9668	Jardim Morada do Sol	Jd M Sol
53435	SP	8926	Centro de Desenvolvimento de Assis	C D Assis
53436	SP	8989	Jardim Nossa Senhora das Graças (Rubião Junior)	Jd N Sra Graças (R Junior)
53437	SP	8989	Jardim São José (Rubião Junior)	Jd S José (R Junior)
53438	SP	8989	Vila Formosa (Rubião Junior)	Vl Formosa (R Junior)
53439	SP	8989	Vila Paraíso (Rubião Junior)	Vl Paraíso (R Junior)
53440	SP	8989	Jardim América (Rubião Junior)	Jd América (R Junior)
53441	SP	8989	Vila Santa Inês (Rubião Junior)	Vl Sta Inês (R Junior)
53442	SP	8989	Jardim Saúde (Rubião Junior)	Jd Saúde (R Junior)
53443	SP	8989	Jardim Dona Marta (Rubião Junior)	Jd Da Marta (R Junior)
53444	SP	8989	Jardim Santo Inácio (Rubião Junior)	Jd Sto Inácio (R Junior)
53445	SP	8989	Jardim Neusa Maria (Rubião Junior)	Jd N Maria (R Junior)
53449	SP	8989	Jardim Alvorada (Rubião Junior)	Jd Alvorada (R Junior)
53450	SP	9660	Condomínio Loteamento Reserva das Figueiras	Cond Lot R Figueiras
53451	SP	9643	Jardim das Torres Prolongamento	Jd T Prolongamento
53455	SP	9146	Parque Monte Verde Novo	Prq Mte V Novo
53515	SP	9659	Condomínio Residencial Jardins de Barcelona	Cond Res J Barcelona
53516	SP	9659	Condomínio Residencial Village Maria Stella	Cond Res V M Stella
53517	SP	9659	Belvedere Terra Nova	Belv T Nova
53518	SP	9659	Terra Nova Garden Village	T N G Village
53520	SP	9668	Jardim Helian	Jd Helian
53522	SP	9435	Conjunto Habitacional Helena Braz Vendramini	Cj H H B Vendramini
53523	SP	9025	Jardim Marialva	Jd Marialva
53524	SP	9768	Vivenda das Cerejeiras	V Cerejeiras
53528	SP	9566	Jardim Progresso II	Jd Progresso II
53530	SP	9025	Conjunto Habitacional Campinas H	Cj H Campinas H
53553	SP	9317	Residencial Morada das Acácias	Res M Acácias
53554	SP	9501	Jardim Veneza II	Jd Veneza II
53555	SP	9285	Parque Residencial Primavera II	Prq Res Primavera II
53556	SP	9260	Vila Mariáh	Vl Mariáh
53557	SP	9485	Ipiranga	\N
53559	SP	9317	Bairro São Francisco	B S Francisco
53560	SP	8913	Jardins de Samantha II	J Samantha II
53562	SP	9566	Jardim Hipódromo	Jd Hipódromo
53563	SP	8883	Jardim das Orquídeas	Jd Orquídeas
53567	SP	9574	Parque das Rosas	Prq Rosas
53568	SP	8954	Ibitu (Ibitu)	\N
53569	SP	8992	Toró	\N
53629	SP	9267	Lagoa Azul	Lga Azul
53633	SP	9493	Jardim Maria	Jd Maria
53634	SP	8907	Residencial Jardim Centenário	Res Jd Centenário
53636	SP	9660	Vila Sanches	Vl Sanches
53637	SP	9026	Portal da Primavera	P Primavera
53638	SP	9026	Chácaras Santa Cecília	C Sta Cecília
53639	SP	9026	Conjunto Habitacional Vila da Conquista	Cj H Vl Conquista
53642	SP	9026	Loteamento Champs Privés	Lot C Privés
53643	SP	9026	Chácaras Bonsucesso	C Bonsucesso
53644	SP	9026	Recanto das Rosas	Rec Rosas
53645	SP	8961	Residencial Jardim Estoril V	Res Jd Estoril V
53646	SP	9560	Vila Recreio	Vl Recreio
53647	SP	8989	Vitoriana	\N
53654	SP	8933	Jardim Di Fiori	Jd Di Fiori
53655	SP	8933	Jardim América II	Jd América II
53656	SP	8933	Jardim Califórnia	Jd Califórnia
53657	SP	9265	Jardim Boa Ventura	Jd B Ventura
53658	SP	9660	Torrão de Ouro II	T Ouro II
53665	SP	9348	Jardim Florença	Jd Florença
53666	SP	9686	Setor Industrial Água Vermelha	St Ind A Vermelha
53669	SP	8992	Jardim Santa Paulina	Jd Sta Paulina
53671	SP	8875	Santa Luzia	Sta Luzia
53165	SP	9660	Jardim Santa Júlia	Jd Sta Júlia
53166	SP	9255	Centro	\N
53171	SP	9068	Laranjeiras	\N
53190	SP	9643	Jardim Santa Elisa	Jd Sta Elisa
53191	SP	9088	Jardim Real	Jd Real
53192	SP	9659	Residencial Santa Ana	Res Sta Ana
53260	SP	9595	Residencial Dona Margarida	Res Da Margarida
53261	SP	9595	Jardim San Marino	Jd S Marino
53262	SP	9595	Jardim Santa Fé	Jd Sta Fé
53263	SP	9595	Terras di Siena	T di Siena
53265	SP	9285	Conjunto Habitacional Baiano da Bomba	Cj H B Bomba
53266	SP	9595	Terras de Santa Bárbara	T Sta Bárbara
53269	SP	9595	Parque Industrial Bandeirantes	Prq Ind Bandeirantes
53278	SP	8928	Jardim Brisa	Jd Brisa
53286	SP	8928	Jardim Planalto do Tanque	Jd Planalto Tanque
53289	SP	9569	Penitenciária	\N
53290	SP	9768	Nações	\N
53291	SP	9216	Vila Alpes Suíços	Vl A Suíços
53298	SP	9775	Jardim Novo Mundo	Jd N Mundo
53301	SP	9025	Parque Aeroporto	Prq Aeroporto
53309	SP	8913	Chácara Recreio Vila Rica	Ch Rcr Vl Rica
53311	SP	8912	Jardim Santa Thereza	Jd Sta Thereza
53312	SP	9267	Residencial Parque dos Sinos	Res Prq Sinos
53313	SP	9267	Jardim Terras da Conceição	Jd T Conceição
53314	SP	9005	Conjunto Residencial Inocoop	Cj Res Inocoop
53315	SP	8913	Jardim Sobradinho e Furnas	Jd S Furnas
53383	SP	9265	Córrego Rico	Crg Rico
53384	SP	9265	Residencial Mário Petrassi (Córrego Rico)	Res M Petrassi (Crg Rico)
53385	SP	9265	Conjunto Habitacional Carlos Augusto Heiland (Córrego Rico)	Cj H C A Heiland (Crg Rico)
53386	SP	9265	Lusitânia	\N
53387	SP	9265	Yukio Nakagi (Lusitânia)	Y Nakagi (Lusitânia)
53392	SP	9789	Jardim Portal dos Lagos	Jd P Lagos
53393	SP	9686	Chácaras de Recreio Pedregal - Vila Garcia	C Rcr Pedregal - Vl Garcia
53394	SP	9368	Jardim Progresso	Jd Progresso
54056	SP	9146	Bairro dos Valos	B Valos
53395	SP	9566	Parque Industrial Margarete	Prq Ind Margarete
53397	SP	9005	Boa Vista	B Vista
53399	SP	9660	Jardim Nova Flórida	Jd N Flórida
53400	SP	9005	Residencial Borda do Campo	Res B Campo
53401	SP	9696	Jardim Renascer	Jd Renascer
53403	SP	9660	Chácara dos Coqueiros	Ch Coqueiros
53411	SP	9043	Jardim Califórnia	Jd Califórnia
53416	SP	9501	Jardim Residence Rio Verde	Jd R R Verde
53473	SP	9493	Mário Dedini	M Dedini
53477	SP	9647	Jardim Recanto das Águas	Jd Rec Águas
53478	SP	9025	Parque Universal	Prq Universal
53483	SP	9025	Núcleo Residencial Vila Todescan	Nuc Res Vl Todescan
53484	SP	9025	Jardim Santo Antonio	Jd Sto Antonio
53485	SP	9025	Residencial Estância Eudóxia (Barão Geraldo)	Res Etn Eudóxia (Br Geraldo)
53486	SP	9348	Conjunto Habitacional Lindomar Gomes de Carvalho	Cj H L G Carvalho
53495	SP	9659	Residencial Jardim Norte	Res Jd Norte
53496	SP	9659	Residencial Santa Cruz	Res Sta Cruz
53498	SP	9052	Loteamento Parque José Cury	Lot Prq J Cury
53500	SP	9659	Parque Residencial Buona Vita	Prq Res B Vita
53501	SP	9659	Loteamento Recanto do Lago	Lot Rec Lago
53502	SP	9659	Residencial Alta Vista	Res A Vista
53503	SP	9660	Águas da Prata	A Prata
53505	SP	9775	Sítio São José	Sit S José
53506	SP	8928	Conjunto Habitacional José Barnet Y Vives	Cj H J B Y Vives
53510	SP	9183	Parque Cecap	Prq Cecap
53513	SP	9660	Vila Luchetti	Vl Luchetti
53573	SP	9146	Villa Verde	V Verde
53575	SP	9560	Jardim José Wilson Toni	Jd J W Toni
53576	SP	9560	Jardim Javari	Jd Javari
53577	SP	8977	Santo Antonio	Sto Antonio
53578	SP	9240	Vila Apolo	Vl Apolo
53579	SP	9254	Loteamento Itatiba Country Club	Lot I C Club
53580	SP	9005	Loteamento Pedro Rizzo I	Lot P Rizzo I
53581	SP	9005	Loteamento Pedro Rizzo II	Lot P Rizzo II
53582	SP	9005	Chácara Bela Vista	Ch B Vista
53583	SP	9005	Recanto dos Pereiras	Rec Pereiras
53584	SP	9005	Recanto dos Camargos	Rec Camargos
53585	SP	9005	Chácara Santa Rosa	Ch Sta Rosa
53586	SP	9005	Bairro do Paiol	B Paiol
53587	SP	9660	Condomínio Residencial Bell Park	Cond Res B Park
53588	SP	9660	Residencial Juritis	Res Juritis
53590	SP	9660	Jardim Torrão de Ouro	Jd T Ouro
53612	SP	9025	Conjunto Habitacional Edivaldo Antônio Orsi	Cj H E A Orsi
53625	SP	9768	Loteamento Ana Carolina II	Lot A Carolina II
53626	SP	9145	Moinho	\N
53627	SP	9043	Jardim Manari	Jd Manari
53628	SP	8992	Jardim Santa Lúcia	Jd Sta Lúcia
53678	SP	9768	Reforma Agrária	R Agrária
53679	SP	9768	Capivari	\N
53681	SP	9668	Moema	\N
53682	SP	9660	Vila Monterrey	Vl Monterrey
53683	SP	8989	Santa Maria I	Sta Maria I
53684	SP	8989	Chácara Santa Maria	Ch Sta Maria
53687	SP	9177	Residencial COOPEMI I	Res COOPEMI I
53688	SP	9321	Portal das Palmeiras	P Palmeiras
53690	SP	8989	Sociedade Hípica de Botucatu	S H Botucatu
53691	SP	9726	Fonte Imaculada	Fnt Imaculada
53692	SP	9265	Jardim Morada Nova	Jd M Nova
53693	SP	9265	Jardim Aroeira	Jd Aroeira
53694	SP	9267	Parque Mirante do Vale	Prq M Vale
53695	SP	9726	Conjunto Residencial Alaor Ferreira Lima	Cj Res A F Lima
53696	SP	9587	Loteamento Santa Edwiges	Lot Sta Edwiges
53697	SP	9560	Jardim Genésio Massaro	Jd G Massaro
53700	SP	8989	Cidade Universitária	C Universitária
53712	SP	8933	São Judas Tadeu V	S J Tadeu V
53713	SP	9566	Jardim Guanabara II	Jd Guanabara II
53714	SP	9726	Piracangaguá	\N
53722	SP	9319	Residencial Leonel Brizola	Res L Brizola
53785	SP	8989	Vila Sueleny (Rubião Junior)	Vl Sueleny (R Junior)
53786	SP	8989	Jardim Bons Ares (Rubião Junior)	Jd B Ares (R Junior)
53787	SP	9696	Jardim dos Pássaros	Jd Pássaros
53788	SP	9725	Jardim Ordália	Jd Ordália
53804	SP	9696	Bairro da Vossoroca	B Vossoroca
53805	SP	9260	Kurumin	\N
53806	SP	9260	Jardim Santa Monica	Jd Sta Monica
53807	SP	9260	Residencial Santo Inácio	Res Sto Inácio
53808	SP	9260	Terras de Santa Carolina	T Sta Carolina
53809	SP	8883	Jardim Trípoli	Jd Trípoli
53821	SP	9136	Coester	\N
53822	SP	9659	Recanto Duas Vendas	Rec D Vendas
53823	SP	9659	Residencial Vista Alegre	Res V Alegre
53828	SP	9660	Jardim Imperial	Jd Imperial
53829	SP	9775	Jardim Tanque Velho	Jd T Velho
53830	SP	9254	Núcleo Habitacional Pedro Costa	Nuc H P Costa
53832	SP	9587	João Jabour	J Jabour
53833	SP	9144	Villaggio Di Firenze	V Di Firenze
53836	SP	9260	Jardim Plaza Athénée	Jd P Athénée
53838	SP	9660	Vila São Benedito	Vl S Benedito
53892	SP	9643	Conjunto Habitacional Waldomiro Lobbe Sobrinho	Cj H W L Sobrinho
53927	SP	9686	Conjunto Habitacional José Garcia da Costa - Zé Garcia	Cj H J G Costa - Z Garcia
53931	SP	9592	Santa Rosa	Sta Rosa
53939	SP	8989	Jardim Botucatu (Rubião Júnior)	Jd Botucatu (R Júnior)
53943	SP	9686	Jardim Boa Sorte	Jd B Sorte
53944	SP	9686	Jardim Tropical	Jd Tropical
53945	SP	9686	Jardim Florenzza	Jd Florenzza
53739	SP	9788	Residencial Votorantim Park I	Res V Park I
53740	SP	9788	Residencial Votorantim Park II	Res V Park II
53741	SP	9354	Residencial Orminda Bottura Benassi	Res O B Benassi
53742	SP	8912	Jardim Residencial Quinta dos Oitis	Jd Res Qta Oitis
53743	SP	8912	Residencial Portal dos Oitis	Res P Oitis
53744	SP	9315	Taquari	\N
53745	SP	9317	Doutor João Batista Levy	Dr J B Levy
53748	SP	9668	Jardim Chácaras Oriente	Jd C Oriente
55576	SP	9013	Vila Rosina	Vl Rosina
53749	SP	9216	Jardim Maison Du Parc	Jd M D Parc
53750	SP	9216	Distrito Industrial Bartolomai	Dt Ind Bartolomai
53751	SP	9532	Residencial Portinari	Res Portinari
53752	SP	9532	Parque Residencial Jarina	Prq Res Jarina
53753	SP	9532	Jardim São Sebastião II	Jd S Sebastião II
53754	SP	9788	Área Industrial	A Industrial
53773	SP	9371	Jardim Quartieri	Jd Quartieri
53774	SP	9532	Residencial Pacaembú	Res Pacaembú
53777	SP	9244	Ponte Nova	Pte Nova
53839	SP	9660	Loteamento Conjunto Morada do Sol II	Lot Cj M Sol II
53843	SP	9144	Residencial Antônio Gonzáles	Res A Gonzáles
53850	SP	9082	Chácaras São Carlos	C S Carlos
53869	SP	9250	residencial Flamboyant	R Flamboyant
53870	SP	9317	Jardim Solar dos Nobres	Jd S Nobres
53872	SP	9177	Santa Rita	Sta Rita
53876	SP	9643	Jardim Santa Helena	Jd Sta Helena
53877	SP	9643	Loteamento Jardim Vista Alegre	Lot Jd V Alegre
53878	SP	9643	Residencial Deputado José Zavaglia	Res Dep J Zavaglia
53879	SP	9643	Parque Novo Mundo	Prq N Mundo
53880	SP	9643	Parque Espraiado	Prq Espraiado
53881	SP	9643	Jardim Jacobucci	Jd Jacobucci
53882	SP	9643	Loteamento Recreio Campestre	Lot Rcr Campestre
53883	SP	9643	Loteamento Tutoya do Vale	Lot T Vale
53884	SP	9643	Quinta dos Buritis	Qta Buritis
53885	SP	9643	Chácara Leila	Ch Leila
53886	SP	9643	Tibaia de São Fernando	T S Fernando
53887	SP	9643	Vale Santa Felicidade	Vle Sta Felicidade
53888	SP	9643	Loteamento Aracê de Santo Antonio I	Lot A Sto Antonio I
53889	SP	9643	Loteamento Aracê de Santo Antonio II	Lot A Sto Antonio II
53890	SP	9643	Encontro Valparaíso I	E Valparaíso I
53891	SP	9643	Encontro Valparaíso II	E Valparaíso II
53946	SP	9686	Jardim Esmeralda	Jd Esmeralda
53961	SP	9177	Residencial Nino	Res Nino
53964	SP	9660	Jardim Capitingal	Jd Capitingal
53966	SP	9726	Belém	\N
54060	SP	9371	Parque Jardim Murayama	Prq Jd Murayama
54064	SP	9696	Portal de São Francisco	P S Francisco
54066	SP	9370	Residencial Village da Serra	Res V Serra
54067	SP	9370	Jardim Eldorado	Jd Eldorado
54072	SP	9267	Jardim São José	Jd S José
54074	SP	8961	Vila Paraíso	Vl Paraíso
54087	SP	9144	Residencial Meireles	Res Meireles
54094	SP	9144	Residencial San Diego	Res S Diego
54095	SP	9368	Anita Venturi Prícoli	A V Prícoli
54099	SP	9370	Martinho Prado Júnior	M P Júnior
54100	SP	9370	Jardim Virgínia (Martinho Prado Júnior)	Jd Virgínia (M P Júnior)
54101	SP	9370	Jardim das Laranjeiras (Martinho Prado Júnior)	Jd Laranjeiras (M P Júnior)
54102	SP	9183	Torres Tibagy	T Tibagy
54106	SP	8886	Residencial Villaggio di Fiori	Res V di Fiori
54107	SP	8992	Bairro do Uberaba	B Uberaba
54114	SP	9043	Jardim Maristela	Jd Maristela
54173	SP	8933	Jardim das Orquídeas	Jd Orquídeas
54175	SP	9052	Conjunto Habitacional Giuseppe Spina	Cj H G Spina
54176	SP	9052	Residencial Lluminar	Res Lluminar
54181	SP	9660	Costinha	\N
54183	SP	9216	Vila Residencial Park Avenida	Vl Res P Avenida
54213	SP	9668	Vila Olga Cecília	Vl O Cecília
54221	SP	9355	Chácara do Carneiro	Ch Carneiro
54378	SP	9183	Jardim City	Jd City
54380	SP	9317	Distrito São Lucas II	Dt S Lucas II
54385	SP	9532	Montalvão	\N
54386	SP	9532	Residencial Daiane (Montalvão)	Res Daiane (Montalvão)
54403	SP	9177	Residencial Santa Bárbara	Res Sta Bárbara
54410	SP	9177	Beira Rio II	B Rio II
54411	SP	9177	Residencial Hípica	Res Hípica
54412	SP	9177	Campinho	\N
54413	SP	9177	São Gonçalo	S Gonçalo
54414	SP	9177	Vila Antunes	Vl Antunes
54415	SP	9177	Vila Frei Galvão	Vl Fr Galvão
54418	SP	9660	Jardim das Paineiras II	Jd Paineiras II
54424	SP	9295	Vila Nova Maringá	Vl N Maringá
54491	SP	9532	Vila Rotária \\"Arch C. Klumph\\"	Vl R \\" C Klumph\\"
54492	SP	8926	Park Residencial Colinas	P Res Colinas
54493	SP	8926	Residencial Esmeralda Park	Res E Park
54499	SP	8989	Parque Bela Vista (Rubião Junior)	Prq B Vista (R Junior)
54501	SP	8989	Parque Santo Antonio da Cascatinha (Rubião Junior)	Prq Sto A Cascatinha (R Junior)
54504	SP	9216	Jardim Figueira	Jd Figueira
54505	SP	9285	Residencial Marcio Soufen Redi	Res M S Redi
54511	SP	8992	Boa Vista dos Silva	B V Silva
54521	SP	8886	São Roque (Três Pontes)	S Roque (T Pontes)
54522	SP	9726	Vila Rezende	Vl Rezende
54523	SP	9726	Vila Prosperidade	Vl Prosperidade
54524	SP	9726	Recanto dos Coqueirais	Rec Coqueirais
54525	SP	9726	Parque Ipanema	Prq Ipanema
54526	SP	9726	Vila Elvira	Vl Elvira
54527	SP	9177	Vila Angelina	Vl Angelina
54528	SP	9177	Vila Brasil	Vl Brasil
54529	SP	9177	Jardim Primavera	Jd Primavera
54531	SP	9265	Condomínio Parque dos Girassóis	Cond Prq Girassóis
54532	SP	9265	Cerradinho	\N
54534	SP	9369	Cocuera	\N
54536	SP	9660	Residencial Terra Nova	Res T Nova
54541	SP	9244	Residencial Alonso Carmona Ortiz	Res A C Ortiz
54014	SP	9668	Jardim Camargo Velho	Jd C Velho
54025	SP	9668	Vila Nova Esperança	Vl N Esperança
54030	SP	9668	Conjunto Habitacional Morro da Esperança (Cachoeirinha)	Cj H Mro Esperança (Cachoeirinha)
54031	SP	9659	Jardins de Athenas	J Athenas
54032	SP	9183	Sítio dos Britos	Sit Britos
54037	SP	9532	Terras de Imoplan	T Imoplan
54038	SP	9183	Itaim	\N
54050	SP	9668	Morada do Sol	M Sol
54054	SP	9146	Bairro dos Penhas	B Penhas
54055	SP	9146	Bairro da Vargem Grande	B V Grande
54057	SP	9696	Jardim das Azaléias	Jd Azaléias
54059	SP	9700	Loteamento Industrial Veccon Zeta	Lot Ind V Zeta
54119	SP	9560	Jardim Santa Ângela	Jd Sta Ângela
54146	SP	9317	Vila Santa Lúcia	Vl Sta Lúcia
54161	SP	9265	Jardim Barcelona	Jd Barcelona
54163	SP	9265	Residencial dos Ipês	Res Ipês
54164	SP	9265	Residencial Bom Jesus	Res B Jesus
54165	SP	9265	Distrito Industrial José Aparecido Tomé	Dt Ind J A Tomé
54166	SP	9265	Parque Industrial Carlos Tonnani	Prq Ind C Tonnani
54171	SP	8989	Jardim Ypê	Jd Ypê
54172	SP	9671	Jardim Camargo (Canguera)	Jd Camargo (Canguera)
54226	SP	9789	Jardim Residencial Vilar	Jd Res Vilar
54229	SP	9493	Cidade Jardim	C Jardim
54230	SP	9025	Ville Sainte Hélène	V S Hélène
54241	SP	9668	Vila Genioli	Vl Genioli
54254	SP	9355	Jardim Santana	Jd Santana
54259	SP	9659	Loteamento Parque Nova Esperança	Lot Prq N Esperança
54260	SP	8989	Jardim Itália	Jd Itália
54263	SP	8989	Residencial Santa Helena	Res Sta Helena
54334	SP	9265	Jardim Primavera (Córrego Rico)	Jd Primavera (Crg Rico)
54342	SP	8989	Loteamento Recreio Barra do Capivara (Vitoriana)	Lot Rcr B Capivara (Vitoriana)
54343	SP	8989	Residencial Vila Di Capri	Res Vl Di Capri
54344	SP	8989	Alvorada de Barra Bonita (Vitoriana)	A B Bonita (Vitoriana)
54345	SP	8989	Chácara Silveira (Vitoriana)	Ch Silveira (Vitoriana)
54346	SP	8989	Querência do Rio Bonito (Vitoriana)	Q R Bonito (Vitoriana)
54347	SP	8989	Recreio Retiro do Rio Bonito (Vitoriana)	Rcr Rer R Bonito (Vitoriana)
54348	SP	8989	Recreio Jardim da Mina (Vitoriana)	Rcr Jd Mina (Vitoriana)
54349	SP	8989	Porto Said (Vitoriana)	Pto Said (Vitoriana)
54350	SP	8989	Vila Real de Barra Bonita (Vitoriana)	Vl R B Bonita (Vitoriana)
54351	SP	8989	Rancho Alvorada (Vitoriana)	R Alvorada (Vitoriana)
54353	SP	9295	Jardim Alice	Jd Alice
54354	SP	9295	Jardim Santa Rosa	Jd Sta Rosa
54362	SP	9668	Sítio da Barra	Sit Barra
54363	SP	9371	Jardim Hélio Cruz	Jd H Cruz
54364	SP	9216	Jardim Maringá	Jd Maringá
54365	SP	9216	Jardim Residencial Terra Nobre	Jd Res T Nobre
54366	SP	9216	Jardim Quintas da Terracota	Jd Qtas Terracota
54367	SP	9216	Residencial Beira da Mata	Res B Mata
54368	SP	9216	Jardim Reserva Bom Viver de Indaiatuba	Jd R B V Indaiatuba
54369	SP	9216	Conjunto Habitacional Residencial Veredas da Conquista	Cj H Res V Conquista
54437	SP	8992	Jardim Sevilha	Jd Sevilha
54438	SP	9267	Jardim Crystal Park	Jd C Park
54439	SP	9267	Parque Residencial Jequitibá	Prq Res Jequitibá
54441	SP	9668	Vila Regina	Vl Regina
54443	SP	8912	Jardim Salto Grande	Jd S Grande
54448	SP	8883	Jardim Werner Plaas VII	Jd W Plaas VII
54456	SP	9587	Residencial São Bento	Res S Bento
54473	SP	9566	Jardim do Horto	Jd Horto
54485	SP	9295	Jardim Natália	Jd Natália
54488	SP	8962	Andes	\N
54489	SP	8962	Botafogo	\N
54490	SP	8962	Turvínea	\N
54544	SP	9316	Jardim Maria Luiza II	Jd M Luiza II
54546	SP	9316	Jardim Maria Luiza IV	Jd M Luiza IV
54547	SP	9316	Jardim Grajaú	Jd Grajaú
54548	SP	9316	Jardim Europa	Jd Europa
54549	SP	9316	Residencial Santa Terezinha I	Res Sta Terezinha I
54550	SP	9316	Residencial Santa Terezinha II	Res Sta Terezinha II
54551	SP	9316	Conjunto Habitacional Lençóis Paulista D	Cj H L Paulista D
54552	SP	9316	Jardim Santa Lúcia	Jd Sta Lúcia
54553	SP	9316	Jardim Nelli	Jd Nelli
54557	SP	9316	Jardim Maria Luiza III	Jd M Luiza III
54559	SP	8891	Jardim das Tulipas	Jd Tulipas
54560	SP	9726	Granjas Panorama	G Panorama
54561	SP	8992	Jardim Aracati	Jd Aracati
54562	SP	8992	Jardim Araguari	Jd Araguari
54564	SP	8992	Bom Retiro	B Retiro
54572	SP	9566	Jardim Porto Fino	Jd Pto Fino
54574	SP	9371	Residencial Portal do Lago	Res P Lago
54577	SP	8992	Vila David	Vl David
54585	SP	8992	Vila Sant' Ana	Vl S Ana
54586	SP	8992	Vila Garcia	Vl Garcia
54587	SP	9369	Residencial Algarve	Res Algarve
54588	SP	9369	Jardins do Paraíso	J Paraíso
54590	SP	9532	Centro (Ameliópolis)	\N
54593	SP	9686	Jardim Mediterrâneo I	Jd Mediterrâneo I
54594	SP	9686	Jardim Mediterrâneo II	Jd Mediterrâneo II
54595	SP	9686	Jardim Morada das Estrelas	Jd M Estrelas
54666	SP	9659	Parque das Amoras II	Prq Amoras II
54667	SP	9659	Jardim Caetano II	Jd Caetano II
54668	SP	8928	Boa Vista	B Vista
54669	SP	8928	Loteamento Quadra dos Príncipes	Lot Q Príncipes
54670	SP	9789	Residencial Jardins Athenas	Res J Athenas
54687	SP	8883	Jardim Terramérica I	Jd Terramérica I
54688	SP	8883	Jardim Terramérica II	Jd Terramérica II
54689	SP	8883	Jardim Terramérica III	Jd Terramérica III
54695	SP	9485	Vila Nehemia	Vl Nehemia
54698	SP	9369	Residencial Granja Anita	Res Gja Anita
54699	SP	9348	Vereador Eduardo Andrade Reis	Ver E A Reis
54702	SP	9668	Vila Industrial ( Vila Nova Curuçá)	Vl Industrial (Vl N Curuçá)
54762	SP	8989	Residencial Indaiá	Res Indaiá
54763	SP	9285	Jardim Juliana	Jd Juliana
54764	SP	9643	Tibaia de São Fernando II	T S Fernando II
54765	SP	9317	Jardim Campo Verde I	Jd Cpo Verde I
54766	SP	9317	Parque Pompeo	Prq Pompeo
54794	SP	8912	Jardim Altos de Pinheiros III	Jd A Pinheiros III
54799	SP	8912	Residencial Stephanie Merissa	Res S Merissa
54800	SP	9686	Chácaras Recreio dos Pampas	C Rcr Pampas
54801	SP	9144	Residencial Rodrigo Salloum	Res R Salloum
54802	SP	9144	Residencial Engenho Queimado	Res E Queimado
54803	SP	9144	Residencial Palermo City	Res P City
54804	SP	9144	Residencial Palermo	Res Palermo
54805	SP	9144	Villagio Novo Mundo	V N Mundo
54806	SP	9144	Residencial Zanetti	Res Zanetti
54598	SP	9686	Colinas de São Pedro	C S Pedro
54599	SP	9686	Condomínio Green Park	Cond G Park
54600	SP	9686	Condomínio Burle Marx	Cond B Marx
54608	SP	11239	Distrito da Varginha	Dt Varginha
54614	SP	9696	Jardim do Carmo	Jd Carmo
54623	SP	9267	Chácaras Rurais Bela Vista II	C R B Vista II
54624	SP	9267	Chácaras Rurais Bela Vista I	C R B Vista I
54626	SP	9285	Condomínio Residencial Bela Vista	Cond Res B Vista
54627	SP	9435	Loteamento Santa Fé Gold Place	Lot Sta F G Place
54628	SP	8962	Residencial Doutor Pedro Paschoal	Res Dr P Paschoal
54629	SP	8962	Residencial Parati III	Res Parati III
54632	SP	8992	Parque das Faculdades	Prq Faculdades
54636	SP	9788	Jardim Residencial Chácara Ondina	Jd Res Ch Ondina
54637	SP	9025	Núcleo Residencial Nossa Senhora Aparecida	Nuc Res N Sra Aparecida
54638	SP	8992	Parque Caetê	Prq Caetê
54703	SP	8962	Condomínio João Ismael	Cond J Ismael
54704	SP	8962	Conjunto Residencial Vila das Laranjeiras	Cj Res Vl Laranjeiras
54715	SP	9144	Parque das Águas	Prq Águas
54717	SP	9643	Parque Técnológico	Prq Técnológico
54718	SP	9789	Jardim Residencial Monte Verde	Jd Res Mte Verde
54719	SP	9789	Jardim Portal das Brisas	Jd P Brisas
54720	SP	9789	Vila Comercial Ramalho Mota	Vl C R Mota
54721	SP	9789	Vila Residencial Orlando Nogueira Cardoso	Vl Res O N Cardoso
54722	SP	9789	Vila Bela	Vl Bela
54723	SP	9789	Vila Recanto das Águas	Vl Rec Águas
54724	SP	9789	Jardim Residencial Eulália	Jd Res Eulália
54725	SP	9789	Jardim Universitário	Jd Universitário
54729	SP	9587	Jardim Saltense II	Jd Saltense II
54730	SP	9317	Jardim Manacá	Jd Manacá
54751	SP	9355	Núcleo Cincinato Braga	Nuc C Braga
54824	SP	9144	Vale Belo	Vle Belo
54825	SP	9144	Vila Santa Eugênia	Vl Sta Eugênia
54833	SP	9566	Santa Cruz	Sta Cruz
54835	SP	9671	Mombaça	\N
54836	SP	9370	Chácara Pantanal Engenho Velho	Ch P E Velho
54848	SP	9260	Altos de Itu	A Itu
54854	SP	8992	Residencial Vem Viver	Res V Viver
54856	SP	9668	Parque Santo Antônio (Aricanduva)	Prq Sto Antônio (Aricanduva)
54858	SP	9243	Jardim Santa Rosa	Jd Sta Rosa
54859	SP	9671	Bairro do Cambará	B Cambará
54860	SP	8891	Loteamento Residencial Morada do Sol	Lot Res M Sol
54863	SP	9138	Parque Atlântica	Prq Atlântica
54936	SP	9082	das Brotas	Brotas
54937	SP	9493	Loteamento Jardim Santa Maria	Lot Jd Sta Maria
54938	SP	9082	Residencial dos Lagos	Res Lagos
54941	SP	9277	Bosque de Jandira	Bsq Jandira
54970	SP	9038	Iperozinho	\N
54971	SP	9464	Jardim Fortaleza	Jd Fortaleza
54972	SP	9464	Jardim dos Calegaris	Jd Calegaris
54973	SP	9464	Jardim Vista Alegre	Jd V Alegre
54974	SP	9464	Jardim de Itapoan	Jd Itapoan
54975	SP	9464	Nova Paulínia	N Paulínia
54976	SP	9464	Santa Cecília	Sta Cecília
55114	SP	9686	Jardim Santa Rosa II	Jd Sta Rosa II
55115	SP	9686	Jardim Campo Alegre	Jd Cpo Alegre
55116	SP	9686	Jardim Alto Alegre	Jd At Alegre
55118	SP	9355	Vila Oratório	Vl Oratório
55119	SP	9267	Jardim Mesquita	Jd Mesquita
55121	SP	9005	Tataúba	\N
55122	SP	9686	Cidade Jardim	C Jardim
55123	SP	8992	Bocaina	\N
55129	SP	9686	Jardim Imperial	Jd Imperial
55130	SP	9686	Jardim Santa Rita	Jd Sta Rita
55131	SP	9686	Conjunto Habitacional Anélio Celline	Cj H A Celline
55136	SP	8989	Nova Califórnia II (Rubião Junior)	N Califórnia II (R Junior)
55137	SP	8954	Condomínio Residencial Batista Anania	Cond Res B Anania
55138	SP	8954	Jardim Universitário	Jd Universitário
55139	SP	8954	Jardim Luis Spina	Jd L Spina
55144	SP	9501	Residencial Ilha do Sol	Res Ia Sol
55145	SP	9501	Jardim Residencial Ferrari	Jd Res Ferrari
55152	SP	9479	Estação de Pereiras	Etc Pereiras
55154	SP	8928	Cachoeira	\N
55155	SP	9267	Parateí do Meio	P Meio
55156	SP	9493	Loteamento Residencial Reserva do Engenho	Lot Res R Engenho
55164	SP	9216	Recanto Campestre Viracopos Gleba 1	Rec C V Gleba 1
55176	SP	8992	Chácaras Luzia Vicente	C L Vicente
55183	SP	9788	Condomínio Residencial Flores	Cond Res Flores
55194	SP	8992	Jardim Flamboyan	Jd Flamboyan
55195	SP	9622	Paiol Velho	P Velho
55201	SP	9725	Tanquinho	\N
55202	SP	9725	Jardim Camargo	Jd Camargo
55203	SP	9037	Laranjeiras	\N
55212	SP	9622	Sítio de Baixo	Sit Baixo
55213	SP	9622	Capela Velha	C Velha
55215	SP	9622	Aldeia da Harmonia	A Harmonia
55216	SP	9566	Loteamento Residencial Bosques de Rio Claro	Lot Res B R Claro
55217	SP	9566	Chácara Rupiara	Ch Rupiara
55218	SP	9643	Parque Tecnológico Damha São Carlos	Prq T D S Carlos
55219	SP	9493	Pau D'Alhinho	P D'Alhinho
55220	SP	9052	Residencial Acapulco	Res Acapulco
55221	SP	9315	Pólo Industrial Paulo Kinock II	P Ind P Kinock II
55294	SP	9354	Parque das Laranjeiras	Prq Laranjeiras
55295	SP	9354	Jardim Novo Mundo	Jd N Mundo
55296	SP	9354	Portal Terra da Saudade	P T Saudade
55297	SP	9354	Residencial São Gabriel	Res S Gabriel
55298	SP	9267	Jardim Luiza	Jd Luiza
55299	SP	9348	Jardim Esmeralda	Jd Esmeralda
55300	SP	9348	Jardim Verona	Jd Verona
55302	SP	9354	Residencial Trolli	Res Trolli
55307	SP	9082	Do Cruzeirão (Caucaia do Alto)	D Cruzeirão (C Alto)
55325	SP	9696	Jardim Residencial Mont Blanc	Jd Res M Blanc
55328	SP	9668	Jardim Primavera (Zona Sul)	Jd Primavera (Z Sul)
55333	SP	9660	Jardim Veneza	Jd Veneza
55340	SP	9082	Maranhão	\N
55343	SP	9025	Parque das Quaresmeiras	Prq Quaresmeiras
55344	SP	9493	Ondas	\N
54864	SP	9025	Residencial Vitória Ropole (Barão Geraldo)	Res V Ropole (Br Geraldo)
54865	SP	9250	Jardim Santa Rita II	Jd Sta Rita II
54866	SP	9138	Loteamento Baxmann	Lot Baxmann
54870	SP	9177	Jardim França I	Jd França I
54871	SP	9647	Jardim Monte Verde	Jd Mte Verde
54873	SP	9696	Jardim Residencial Morada das Flores	Jd Res M Flores
54874	SP	8891	Loteamento Residencial Nova Esperança	Lot Res N Esperança
54875	SP	9485	Mandú	\N
54876	SP	9726	Granjas Santa Terezinha	G Sta Terezinha
54877	SP	9726	Jardim Paulista	Jd Paulista
54878	SP	9660	Loteamento Santa Edwiges	Lot Sta Edwiges
54879	SP	9660	Jardim dos Bandeirantes	Jd Bandeirantes
54881	SP	9025	Jardim Monte Cristo/Parque Oziel	Jd Mte C Oziel
54885	SP	9671	Recanto das Acácias	Rec Acácias
54887	SP	9025	Núcleo Residencial Vila Nilza	Nuc Res Vl Nilza
54890	SP	9254	Santa Cruz	Sta Cruz
54891	SP	9254	Parque Industrial San Francisco	Prq Ind S Francisco
54898	SP	9532	Colina do Sol	C Sol
54900	SP	8969	Condomínio Chácaras Villa Verde	Cond C V Verde
54902	SP	9696	Jardim Alpes de Sorocaba	Jd A Sorocaba
54903	SP	9696	Jardim Residencial Colinas do Sol	Jd Res C Sol
54906	SP	9189	Conjunto Habitacional Jardim Primavera	Cj H Jd Primavera
54907	SP	9532	Jardim Bom-Mart	Jd Bom-Mart
54908	SP	8928	Jardim Tapajós	Jd Tapajós
54909	SP	8928	Chácara da Colina	Ch Colina
54977	SP	9464	Vila Presidente Médici	Vl Pres Médici
54978	SP	9464	Vila José Paulino Nogueira	Vl J P Nogueira
54979	SP	9464	Vila Monte Alegre	Vl Mte Alegre
54980	SP	9464	Jardim Ypê	Jd Ypê
54981	SP	9464	Nossa Senhora Aparecida	N Sra Aparecida
54982	SP	9464	Jardim América	Jd América
54983	SP	9464	Morumbi	\N
54984	SP	9464	Santa Terezinha	Sta Terezinha
54985	SP	9464	Parque da Figueira	Prq Figueira
54986	SP	9464	Parque Brasil 500	Prq Brasil 500
54987	SP	9464	Parque Bom Retiro	Prq B Retiro
54988	SP	9464	Jardim Flamboyant	Jd Flamboyant
54989	SP	9464	São Bento	S Bento
54990	SP	9464	Jardim Harmonia	Jd Harmonia
54991	SP	9464	Parque da Represa	Prq Represa
54992	SP	9464	Belvedere do Lago	Belv Lago
54993	SP	9464	Nova Veneza	N Veneza
54994	SP	9464	Balneário Tropical	Baln Tropical
54995	SP	9464	Bela Vista	B Vista
54996	SP	9464	São Luiz	S Luiz
54997	SP	9464	Jardim Planalto	Jd Planalto
54998	SP	9464	Alto de Pinheiros	At Pinheiros
54999	SP	9464	Dona Edith Campos Fávero	Da E C Fávero
55000	SP	9464	São Domingos	S Domingos
55001	SP	9464	Saltinho	\N
55002	SP	9464	João Aranha	J Aranha
55003	SP	9464	Cascata	\N
55004	SP	9464	Bonfim	\N
55005	SP	9464	Recanto dos Pássaros	Rec Pássaros
55006	SP	9464	Boa Esperança	B Esperança
55007	SP	9464	Betel	\N
55012	SP	9355	Núcleo Dr. Sampaio Vidal	Nuc D S Vidal
55014	SP	9668	Jardim Cruz do Corisco	Jd C Corisco
55015	SP	9025	Loteamento Residencial Campina Verde	Lot Res C Verde
55016	SP	8883	Jardim Residencial Dona Rosa	Jd Res Da Rosa
55017	SP	9595	Loteamento Pólo Industrial	Lot P Industrial
55021	SP	9789	Jardim Monte Alto	Jd Mte Alto
55022	SP	9660	Residencial Frei Galvão	Res Fr Galvão
55023	SP	9700	Jardim Conceição II (Nova Veneza)	Jd Conceição II (N Veneza)
55073	SP	9355	Núcleo Dr. Carlos de Campos	Nuc D C Campos
55113	SP	9686	Jardim do Engenho	Jd Engenho
55237	SP	9371	Loteamento Fádua Goraieb Marum (Martim Francisco)	Lot F G Marum (M Francisco)
55261	SP	9560	Parque Industrial Lagoinha	Prq Ind Lagoinha
55263	SP	8928	Chácara Parque São Pedro	Ch Prq S Pedro
55265	SP	9560	Condomínio Aroeira	Cond Aroeira
55271	SP	9354	Residencial Villa de Cappri	Res V Cappri
55272	SP	9354	Parque dos Ipês	Prq Ipês
55273	SP	9354	Parque Mônaco	Prq Mônaco
55274	SP	9354	Parque Petrópolis	Prq Petrópolis
55275	SP	9354	Residencial Valerio Morandi	Res V Morandi
55281	SP	8992	Morro Grande da Boa Vista	Mro G B Vista
55284	SP	8992	Jardim São Cristóvão	Jd S Cristóvão
55286	SP	9660	Jardim Aeroporto	Jd Aeroporto
55287	SP	9660	Vila Letônia	Vl Letônia
55349	SP	9660	Residencial Independência	Res Independência
55354	SP	9660	Jardim das Paineiras I	Jd Paineiras I
55359	SP	8954	Celina	\N
55362	SP	9660	Jardim São José Centro	Jd S J Centro
55363	SP	9566	Parque Flórida	Prq Flórida
55375	SP	9295	Loteamento Vivenda Centenário	Lot V Centenário
55376	SP	9369	Loteamento Alvorada	Lot Alvorada
55377	SP	9369	Cidade Parquelandia	C Parquelandia
55378	SP	9113	Invernada	\N
55382	SP	9277	Jardim Camila	Jd Camila
55383	SP	8912	Jardim Acácias	Jd Acácias
55505	SP	9696	Horto Florestal	H Florestal
55506	SP	9240	Chapada Grande	C Grande
55507	SP	9527	Nova Mirim	N Mirim
55566	SP	9549	Vila Cabral	Vl Cabral
55567	SP	9013	Nova Caieiras	N Caieiras
55568	SP	9013	Melhoramentos	\N
55569	SP	9013	Serpa	\N
55570	SP	9013	Vera Tereza	V Tereza
55571	SP	9013	Calcárea	\N
55572	SP	9013	Nova Era	N Era
55573	SP	9013	Morro Grande	Mro Grande
55574	SP	9013	Alpes de Caieiras	A Caieiras
55575	SP	9013	Santa Inês	Sta Inês
55662	SP	9025	Núcleo Residencial Jardim Yeda II	Nuc Res Jd Yeda II
55663	SP	9493	Jardim Paulista	Jd Paulista
55670	SP	9113	Tingidor	\N
55674	SP	9788	Vila São José	Vl S José
55675	SP	9144	Villa Santa Gianna	V Sta Gianna
55676	SP	9144	Prolongamento Residencial Ana Dorothéa	Prl Res A Dorothéa
55677	SP	9660	Parque Santos Dumont	Prq Stos Dumont
55678	SP	9686	Condomínio Villa Borghese	Cond V Borghese
55682	SP	9726	Jardim Neusa Maria	Jd N Maria
55684	SP	9726	Vila São Carlos	Vl S Carlos
55685	SP	9485	Vila Nossa Senhora Auxiliadora	Vl N Sra Auxiliadora
55686	SP	9660	Jardim Minas Gerais	Jd M Gerais
55688	SP	8912	Condomínio Buona Vita	Cond B Vita
55689	SP	8912	Jardim Maria Luiza V	Jd M Luiza V
55691	SP	9025	São Charbel	S Charbel
55692	SP	9267	Parque Nova América	Prq N América
55513	SP	9647	Pedregulho	\N
55514	SP	9285	Parque Frei Galvão	Prq Fr Galvão
55525	SP	9647	Jardim das Azaléias	Jd Azaléias
55526	SP	9216	Jardim Residencial Helvétia Park I	Jd Res H Park I
55527	SP	9216	Jardim Residencial Helvétia Park II	Jd Res H Park II
55528	SP	9216	Jardim Residencial Helvétia Park III	Jd Res H Park III
55529	SP	9216	Green View Village	G V Village
55530	SP	9216	Jardim dos Lagos	Jd Lagos
55531	SP	8969	Condomínio Residencial Guatambu Park	Cond Res G Park
55532	SP	9216	Parque das Bandeiras 2	Prq Bandeiras 2
55632	SP	9355	Núcleo Sampaio Vidal	Nuc S Vidal
55637	SP	9660	Residencial Caminho das Montanhas	Res Cam Montanhas
55646	SP	8928	Mato Dentro	M Dentro
55647	SP	9267	Jardim Real	Jd Real
55648	SP	8907	Porto Real I	Pto Real I
55649	SP	9177	Vila Jacobelli	Vl Jacobelli
55650	SP	9177	Vila São Bento	Vl S Bento
55651	SP	9177	Vila Guará	Vl Guará
55652	SP	9177	Pólo Industrial José Pires de Castro	P Ind J P Castro
55653	SP	9177	Vila Regina	Vl Regina
55654	SP	9177	Internacional Park	I Park
55655	SP	9177	Chácaras Vitória	C Vitória
55656	SP	9177	Chácaras Santa Maria I	C Sta Maria I
55657	SP	9726	Central Parque	C Parque
55658	SP	9726	Conjunto Residencial São Francisco	Cj Res S Francisco
55659	SP	9726	Chácara Olaria	Ch Olaria
55660	SP	9355	Várzea Capitão João	V Cap João
55661	SP	9025	Núcleo Residencial Jardim Yeda I	Nuc Res Jd Yeda I
55776	SP	9177	Residencial Augusto Filippo	Res A Filippo
55777	SP	9177	Aroeira	\N
55778	SP	9177	Vila Santa Maria	Vl Sta Maria
55779	SP	9177	Jardim Padroeira	Jd Padroeira
55780	SP	9726	Jardim Califórnia	Jd Califórnia
55781	SP	9726	Residencial São Charbel	Res S Charbel
55782	SP	9726	Parque Mauá	Prq Mauá
55783	SP	9726	Jardim Alice	Jd Alice
55784	SP	9025	Parque Viracopos	Prq Viracopos
55804	SP	9485	Pinhão do Borba	P Borba
55805	SP	9485	Loteamento Residencial e Comercial Araguaia	Lot Res C Araguaia
55806	SP	9321	Campinho	\N
55807	SP	9087	Entre Rios	E Rios
55851	SP	9267	Vila Aprazível	Vl Aprazível
55854	SP	8969	Residencial Veneza	Res Veneza
55974	SP	9587	Jardim Santa Marta III	Jd Sta Marta III
55975	SP	9260	Itaim Mirim	I Mirim
55980	SP	9700	Sítio Sertãozinho	Sit Sertãozinho
55989	SP	9748	Conjunto Habitacional Deputado Jamil Dualibi	Cj H Dep J Dualibi
55992	SP	9216	Recanto Campestre Viracopos Gleba 3	Rec C V Gleba 3
55993	SP	9216	Recanto Campestre Internacional de Viracopos Gleba 2	Rec C I V Gleba 2
55995	SP	9295	Residencial Santa Giovana	Res Sta Giovana
55996	SP	9295	Chácaras Maltoni	C Maltoni
55997	SP	9295	Nova Cidade Jardim	N C Jardim
55998	SP	9295	Parque Residencial Jundiaí II	Prq Res Jundiaí II
56049	SP	9703	Jardim Janina	Jd Janina
56050	SP	8928	Iara	\N
56052	SP	9260	Jardim Paulista II	Jd Paulista II
56053	SP	9260	Itu Novo Centro	I N Centro
56060	SP	9789	Simonsen	\N
56071	SP	9660	Jardim Três José	Jd T José
56072	SP	9660	Jardim Majestic	Jd Majestic
56073	SP	9267	Jardim Liberdade	Jd Liberdade
56074	SP	8992	Vila Flora	Vl Flora
56075	SP	8992	Boa Vista	B Vista
56076	SP	9371	Jardim dos Manacás	Jd Manacás
56077	SP	9371	Flores do Campo	F Campo
56088	SP	9243	Colinas de Itapevi	C Itapevi
56089	SP	9686	Distrito Industrial Waldemar Balbo Júnior (Cruz das Posses)	Dt Ind W B Júnior (C Posses)
56091	SP	9044	Golf Park	G Park
56092	SP	9044	Golf Gardens	G Gardens
56093	SP	9560	Jardim Vilico Cantarelli	Jd V Cantarelli
56094	SP	8992	Conjunto Habitacional Saada Nader Abi Chedid	Cj H S N A Chedid
56095	SP	9726	Parque Bandeirantes	Prq Bandeirantes
55808	SP	9177	Jardim Panorama	Jd Panorama
55809	SP	9177	Jardim Panorama II	Jd Panorama II
55811	SP	9317	Jardim Residencial Vale das Flores	Jd Res Vle Flores
55812	SP	8883	Loteamento Residencial Jardim Esperança	Lot Res Jd Esperança
55813	SP	9315	Jardim Residencial Altos da Santa Rita	Jd Res A Sta Rita
55814	SP	9371	Parque Real II	Prq Real II
55815	SP	9595	Loteamento Residencial Mac Knight	Lot Res M Knight
55816	SP	9244	Conjunto Habitacional Hélio Nicolai	Cj H H Nicolai
55817	SP	9315	Jardim Graminha	Jd Graminha
55818	SP	9726	Padre Cursino	Pe Cursino
55819	SP	9726	Independência	\N
55820	SP	9726	Vila Paulista	Vl Paulista
55821	SP	9587	Distrito Industrial dos Bandeirantes	Dt Ind Bandeirantes
55831	SP	9686	Setor Industrial	St Industrial
55841	SP	8883	Jardim Esplanada	Jd Esplanada
55842	SP	9643	Loteamento São Carlos Club	Lot S C Club
55843	SP	9643	Jardim Santa Júlia	Jd Sta Júlia
56002	SP	9587	Residencial Parque Laguna	Res Prq Laguna
56005	SP	9660	Jardim Copacabana	Jd Copacabana
56006	SP	9660	Jardim Maracanã	Jd Maracanã
56007	SP	9660	Jardim São Jorge	Jd S Jorge
56008	SP	9660	Jardim Olímpia	Jd Olímpia
56010	SP	9660	Chácara dos Eucalíptos	Ch Eucalíptos
56011	SP	9660	Vila Ester	Vl Ester
56017	SP	9005	Chácara Santa Cecília	Ch Sta Cecília
56018	SP	9348	Jardim das Rosas	Jd Rosas
56030	SP	8933	Residencial do Camargo	Res Camargo
56034	SP	8928	Usina	\N
56047	SP	8883	Loteamento Residencial Jardim dos Ipês Amarelos	Lot Res Jd I Amarelos
56048	SP	9671	Gabriel Piza	G Piza
56097	SP	9317	Jardim Residencial Campo Novo	Jd Res Cpo Novo
56098	SP	9696	Jardim Regente	Jd Regente
56099	SP	9493	Capim Fino	C Fino
56100	SP	9493	Água Santa	A Santa
56110	SP	9725	Vila Vicente Corrêa	Vl V Corrêa
56112	SP	9319	Residencial Ventura	Res Ventura
56116	SP	9696	Vila Borghesi	Vl Borghesi
56123	SP	9144	Parque dos Ipês	Prq Ipês
56153	SP	9354	Matão K	\N
56154	SP	9354	Residencial Alto da Boa Vista	Res At B Vista
56155	SP	9725	Jardim Residencial Santa Cruz	Jd Res Sta Cruz
56156	SP	9696	Jardim Eliana	Jd Eliana
56158	SP	8992	Arara dos Pereiras	A Pereiras
56236	SP	9025	Loteamento Residencial Porto Seguro	Lot Res Pto Seguro
56237	SP	9370	Vila Residencial Moacir Guzoni	Vl Res M Guzoni
56244	SP	9317	Jardim Residencial Antonio Simonetti IV	Jd Res A Simonetti IV
56245	SP	9025	Residencial Cittá Di Firenze	Res C Di Firenze
56246	SP	9768	Santana dos Cuiabanos	S Cuiabanos
56247	SP	9768	Fontoura	\N
56248	SP	9660	Recanto dos Pinheiros	Rec Pinheiros
56256	SP	9242	Vila Camargo I	Vl Camargo I
56308	SP	8989	Residencial Plaza Martin	Res P Martin
56309	SP	8989	Residencial Ouro Verde	Res O Verde
56310	SP	8989	Jardim Regina	Jd Regina
56311	SP	8989	Conjunto Habitacional Flora Rica	Cj H F Rica
56312	SP	8912	Vila Maria Helena	Vl M Helena
56313	SP	9348	Jardim Trieste Cavichioli (Padre Nóbrega)	Jd T Cavichioli (Pe Nóbrega)
56327	SP	9243	das Pitas	Pitas
56333	SP	8912	Jardim Santa Júlia II	Jd Sta Júlia II
56334	SP	8912	5º Distrito Industrial	5º Dt Industrial
56337	SP	9025	Núcleo Santa Rita de Cássia	Nuc Sta R Cássia
56339	SP	9025	Loteamento Chácara Prado	Lot Ch Prado
56340	SP	8912	Jardim Diamante	Jd Diamante
56341	SP	8912	Jardim Marialice	Jd Marialice
56342	SP	9435	Loteamento Jardim Veredas II	Lot Jd Veredas II
56343	SP	9435	Loteamento Jardim das Acácias	Lot Jd Acácias
56344	SP	9435	Residencial Oswaldo Brizola	Res O Brizola
56345	SP	9435	Residencial Regina Brizola	Res R Brizola
56346	SP	9660	Residencial Dunamis	Res Dunamis
56409	SP	8989	Residencial Terras Altas	Res T Altas
56411	SP	8992	Residencial Campos do Conde	Res C Conde
56412	SP	8992	Bairro da Marina	B Marina
56414	SP	9295	Jardim Tupi	Jd Tupi
56448	SP	9696	Ana Maria	A Maria
56451	SP	9250	Residencial Promissão	Res Promissão
56453	SP	9696	Village Cajuru	V Cajuru
56456	SP	9082	dos Mendes (Caucaia do Alto)	Mendes (C Alto)
56457	SP	9267	Silveira	\N
56458	SP	9082	Projeto Jardim	P Jardim
56459	SP	9082	dos Pires (Caucaia do Alto)	Pires (C Alto)
56505	SP	9025	Residencial da Paz	Res Paz
56506	SP	9025	Jardim Santos Dumont II	Jd Stos Dumont II
56507	SP	9025	Jardim Novo Planalto	Jd N Planalto
56508	SP	9025	Jardim Filadélfia	Jd Filadélfia
56509	SP	8907	Residencial Águas Claras	Res A Claras
56514	SP	9560	Condomínio Caimbé	Cond Caimbé
56515	SP	9560	Condomínio Pitangueiras	Cond Pitangueiras
56516	SP	9560	Condomínio Figueira Branca	Cond F Branca
56517	SP	9560	Condomínio Laranjeiras	Cond Laranjeiras
56518	SP	9560	Condomínio Paineiras	Cond Paineiras
56520	SP	9087	Parque Dona Arminda Candida de Jesus	Prq Da A C Jesus
56521	SP	9726	Morumbi	\N
56522	SP	8891	Jardim das Orquídeas	Jd Orquídeas
56526	SP	8891	Conjunto Habitacional Andradina F	Cj H Andradina F
56527	SP	9317	Graminha	\N
56529	SP	9371	Jardim Regina	Jd Regina
56530	SP	9371	Recanto Di Verona	Rec Di Verona
56531	SP	9113	Jardim Lavorato	Jd Lavorato
56536	SP	9700	Jardim Residencial Vaughan	Jd Res Vaughan
56537	SP	9700	Residencial Portal Bordon II	Res P Bordon II
56538	SP	9700	Residencial Portal do Lago	Res P Lago
56540	SP	9700	Residencial Guairá	Res Guairá
56541	SP	9113	Paranapanema	\N
56546	SP	8924	Pedreira	\N
56554	SP	9659	Residencial Gaivota II	Res Gaivota II
56555	SP	9659	Residencial Mirante	Res Mirante
56160	SP	9493	Loteamento Residencial Santo Antônio II	Lot Res Sto Antônio II
56163	SP	9493	Jardim Sol Nascente II	Jd S Nascente II
56175	SP	9354	Retiro	\N
56177	SP	9788	Villa Toscana	V Toscana
56178	SP	9788	Alphaville Nova Esplanada	A N Esplanada
56179	SP	9788	Residencial Cristal	Res Cristal
56181	SP	8928	Bairro das Brotas	B Brotas
56186	SP	9493	Jardim São José	Jd S José
56187	SP	9370	Jardim Chaparral II	Jd Chaparral II
56188	SP	9368	Loteamento Santa Emília	Lot Sta Emília
56189	SP	9368	Residencial Samambaia	Res Samambaia
56190	SP	8913	Jardim Terras de Santa Elisa	Jd T Sta Elisa
56191	SP	8913	Jardim Nova Rosana	Jd N Rosana
56192	SP	9370	Jardim Santa Cruz	Jd Sta Cruz
56195	SP	9370	Jardim Santa Mônica I	Jd Sta Mônica I
56197	SP	9660	Jardim Petrópolis	Jd Petrópolis
56205	SP	8912	Central Park Morada do Sol	C P M Sol
56257	SP	9242	Conjunto Habitacional Jardim Vitória	Cj H Jd Vitória
56258	SP	9242	Bairro de Cima	B Cima
56259	SP	9242	Kantiã	\N
56261	SP	9254	Bairro dos Pires	B Pires
56262	SP	9696	Jardim Monteiro	Jd Monteiro
56263	SP	9493	Jardim dos Manacás	Jd Manacás
56264	SP	9647	Jardim das Tulipas	Jd Tulipas
56265	SP	9295	Chácara da Alegria	Ch Alegria
56266	SP	9696	Jardim Santa Madre Paulina	Jd Sta Me Paulina
56267	SP	9696	Jardim Eucalíptos	Jd Eucalíptos
56268	SP	9240	Loteamento Gramado I	Lot Gramado I
56269	SP	9240	Loteamento Gramado II	Lot Gramado II
56271	SP	9260	Vila da Paz	Vl Paz
56272	SP	9671	Ibaté	\N
56273	SP	9493	Itaperu	\N
56274	SP	9493	Residencial Terras de Ártemis (Ártemis)	Res T Ártemis (Ártemis)
56275	SP	9025	Jardim das Cerejeiras	Jd Cerejeiras
56279	SP	9532	Condomínio Residencial Jardins de Anahy	Cond Res J Anahy
56280	SP	9216	Vila Florença	Vl Florença
56281	SP	9316	Zona Rural	Z Rural
56289	SP	8883	Loteamento Residencial de Interesse Social Vila Nova Esperança - ASTA 4	Lot Res I S Vl N Esperança - ASTA 4
56290	SP	8992	Guaripocaba dos Souzas	G Souzas
56292	SP	8883	Jardim Portal da Colina	Jd P Colina
56294	SP	8992	Água Comprida	A Comprida
56295	SP	9660	Jardim Mesquita	Jd Mesquita
56296	SP	9703	Jardim Quaresmeira II	Jd Quaresmeira II
56349	SP	9285	Jardim Itatiaia	Jd Itatiaia
56350	SP	9285	Residencial Pedro Julian (Potunduva)	Res P Julian (Potunduva)
56365	SP	8928	Loteamento Atibaia Park I	Lot A Park I
56366	SP	8992	Núcleo Habitacional Padre Aldo Bolini	Nuc H Pe A Bolini
56384	SP	9566	Jardim Dona Regina Picelli	Jd Da R Picelli
56385	SP	9317	Jardim Cidade Universitária I	Jd C Universitária I
56386	SP	9317	Jardim Residencial e Comercial Alto dos Laranjais	Jd Res C At Laranjais
56387	SP	9317	Terras de São Bento I	T S Bento I
56400	SP	8912	Vila Aracoara	Vl Aracoara
56408	SP	8989	Jardim Maria Luiza	Jd M Luiza
56461	SP	9277	Sítio Pedra Bonita	Sit P Bonita
56463	SP	8956	Vila do Conde	Vl Conde
56471	SP	9025	Loteamento Residencial Rosário	Lot Res Rosário
56472	SP	9025	Loteamento Parque das Sapucaias	Lot Prq Sapucaias
56473	SP	9025	Loteamento Parque dos Alecrins	Lot Prq Alecrins
56476	SP	8912	Jardim Quitandinha II	Jd Quitandinha II
56480	SP	9527	Andaraguá	\N
56481	SP	8933	Chácara Elisa	Ch Elisa
56484	SP	8907	Residencial Beatriz	Res Beatriz
56496	SP	9254	Barreiro	\N
56497	SP	9025	Jardim Itaguaçu I	Jd Itaguaçu I
56498	SP	9025	Jardim Itaguaçu II	Jd Itaguaçu II
56499	SP	9025	Jardim Ibirapuera	Jd Ibirapuera
56500	SP	9025	Jardim Bassoli	Jd Bassoli
56501	SP	9025	Vila Ipanema	Vl Ipanema
56502	SP	9025	Jardim Puccamp	Jd Puccamp
56503	SP	9025	Jardim Dom Gilberto	Jd D Gilberto
56504	SP	9025	Jardim Campituba	Jd Campituba
56556	SP	9659	Residencial das Américas	Res Américas
56557	SP	9659	Parque Residencial Damha VI	Prq Res Damha VI
56558	SP	9659	Parque Residencial J. Macedo	Prq Res J Macedo
56566	SP	9113	Jardim Santa Maria	Jd Sta Maria
56571	SP	8924	Portão	\N
56572	SP	8924	Fontes	\N
56573	SP	8924	Pirituba	\N
56576	SP	8992	Bairro do Menin	B Menin
56578	SP	8992	Torozinho	\N
56580	SP	9660	Chácaras Oliveiras	C Oliveiras
56581	SP	8924	Perová	\N
56582	SP	8924	Perobal	\N
56583	SP	8924	Caputera	\N
56584	SP	8924	São Bento	S Bento
56585	SP	9113	Quinta do Morro	Qta Morro
56586	SP	9295	Residencial Village das Flores	Res V Flores
56606	SP	9005	Padre Marcelo	Pe Marcelo
56661	SP	9295	Villaggio San Marco	V S Marco
56667	SP	9025	Parque Dom Bosco	Prq D Bosco
56670	SP	9189	Jardim das Figueiras I	Jd Figueiras I
56671	SP	9189	Jardim das Figueiras II	Jd Figueiras II
56675	SP	9025	Residencial Colina das Nascentes	Res C Nascentes
56676	SP	9643	Estância Maria Alice Prolongamento	Etn M A Prolongamento
56677	SP	9643	Estância Maria Alice	Etn M Alice
56690	SP	9113	Gramado	\N
56691	SP	9189	Condomínio Jardim de Mônaco	Cond Jd Mônaco
56692	SP	9113	Água Espraiada	A Espraiada
56693	SP	9216	Jardim dos Colibris	Jd Colibris
56694	SP	9216	Jardim Turim	Jd Turim
56695	SP	9216	Vila Verde	Vl Verde
56696	SP	8912	Chácaras do Trevo	C Trevo
56697	SP	9501	Jardim dos Ipês	Jd Ipês
56699	SP	9726	Vila dos Comerciários I	Vl Comerciários I
56700	SP	9726	Vila Bela II	Vl Bela II
56701	SP	9113	Itatuba	\N
56702	SP	9113	Cooperativa	\N
56706	SP	9237	Jardim Oásis	Jd Oásis
56710	SP	9189	Residencial Anauá	Res Anauá
56711	SP	9189	Jardim Golden Park Residence	Jd Golden P Residence
56712	SP	9189	Parque Terras de Santa Maria	Prq T Sta Maria
56714	SP	9025	Loteamento Mont Blanc Residence	Lot M B Residence
56774	SP	8967	Loteamento Balneário Mogiano	Lot Baln Mogiano
56775	SP	8989	Conjunto Residencial Jardim do Mirante	Cj Res Jd Mirante
56776	SP	9768	Jurema	\N
56777	SP	9660	Rio Comprido	R Comprido
56781	SP	9082	Aguassaí (Caucaia do Alto)	Aguassaí (C Alto)
56784	SP	9686	Jardim Alto dos Bandeirantes	Jd At Bandeirantes
56790	SP	8992	Chácaras Santo André	C Sto André
56791	SP	9622	Parque dos Monteiros II	Prq Monteiros II
56796	SP	9025	Núcleo Residencial Paranapanema	Nuc Res Paranapanema
56802	SP	8928	Parque Residencial Atibaia	Prq Res Atibaia
56803	SP	9025	Jardim Cidade Singer II	Jd C Singer II
56804	SP	9025	Jardim Campo Belo II	Jd Cpo Belo II
56808	SP	9595	Caiubi	\N
56809	SP	9240	Mato Seco	M Seco
56811	SP	9113	Água Morna	A Morna
56812	SP	9113	Parque Francisco Rizzo	Prq F Rizzo
56813	SP	9242	Jardim Bonfiglioli	Jd Bonfiglioli
56814	SP	9113	Bosque Capuava	Bsq Capuava
56815	SP	9348	Rubens de Abreu Izique	R A Izique
56816	SP	8992	Parque Residencial Rosa do Sul	Prq Res R Sul
56817	SP	8992	Jardim Solar	Jd Solar
56818	SP	9788	Real Parque	R Parque
56819	SP	9748	Conjunto Habitacional Alberto Lasman(Varpa)	Cj H A Lasman (Varpa)
56865	SP	9082	Cândido Pinto (Caucaia do Alto)	C Pinto (C Alto)
56866	SP	9082	do Lageado	Lageado
56867	SP	9668	Jardim Paineiras	Jd Paineiras
56883	SP	9707	Recanto dos Pássaros	Rec Pássaros
56884	SP	9452	Campos de Holambra	C Holambra
56895	SP	8924	Canjicas	\N
56896	SP	9052	Jardim Monte Carlo	Jd Mte Carlo
56897	SP	9700	Residencial Real Parque Sumaré	Res R Prq Sumaré
56898	SP	9025	Residencial Vila Penteado	Res Vl Penteado
56899	SP	9700	Estância Árvore da Vida	Etn A Vida
56900	SP	9113	Perovê	\N
56901	SP	9113	Parque Industrial do Pinheirinho	Prq Ind Pinheirinho
56902	SP	8992	Condomínio Berbari II	Cond Berbari II
56904	SP	9183	Jardim Maria Alice	Jd M Alice
56905	SP	9485	Piracuama	\N
56907	SP	9660	Jardim Ebenézer	Jd Ebenézer
56616	SP	9005	Bairro da Germana	B Germana
56640	SP	9177	Parque Industrial II	Prq Industrial II
56641	SP	8992	Paineiras de Bragança	P Bragança
56645	SP	9371	Residencial do Bosque	Res Bosque
56646	SP	9315	Jardim Residencial Mariana	Jd Res Mariana
56647	SP	9317	Residencial Villa do Sol	Res V Sol
56648	SP	8886	Recanto das Paineiras	Rec Paineiras
56649	SP	8886	Conjunto Habitacional de Interesse Social Vila das Pedras	Cj H I S Vl Pedras
56657	SP	8992	Residencial Quinta dos Vinhedos	Res Qta Vinhedos
56659	SP	9025	Jardim Maringá	Jd Maringá
56716	SP	9560	Vila Hípica	Vl Hípica
56717	SP	9696	Jardim Residencial Sunset Village	Jd Res S Village
56718	SP	9560	Recanto Princesa Isabel	Rec Prca Isabel
56719	SP	8912	Fonte Luminosa	Fnt Luminosa
56723	SP	8992	Green Park	G Park
56724	SP	9267	Residencial Fogaça	Res Fogaça
56733	SP	8956	Vila Viana	Vl Viana
56734	SP	9317	Jardim Porto Real IV	Jd Pto Real IV
56738	SP	8956	Conjunto Habitacional Mirante dos Altos	Cj H M Altos
56745	SP	9267	Jardim Leblon	Jd Leblon
56746	SP	9660	Residencial Interlagos	Res Interlagos
56747	SP	8992	Mãe dos Homens	M Homens
56757	SP	8883	Jardim Boer II	Jd Boer II
56760	SP	8992	Conjunto Habitacional Bragança Paulista F	Cj H B Paulista F
56767	SP	9659	Loteamento Clube V	Lot Clube V
56822	SP	9113	Vila Real	Vl Real
56823	SP	9113	Moinho Real	M Real
56824	SP	9044	Granja Viana	Gja Viana
56825	SP	9789	Vila Filomena	Vl Filomena
56827	SP	9696	Jardim Residencial Giverny	Jd Res Giverny
56844	SP	9113	Caminho do Indio	Cam Indio
56847	SP	8883	Recanto	\N
56849	SP	9260	Chácaras Leonardi	C Leonardi
56850	SP	9748	Conjunto Habitacional José Serrano(Parnaso)	Cj H J Serrano (Parnaso)
56851	SP	9748	Conjunto Habitacional Izidoro Giroto(Universo)	Cj H I Giroto (Universo)
56856	SP	9025	Núcleo Residencial Parque Família	Nuc Res Prq Família
56858	SP	9696	Jardim Santa Paula II	Jd Sta Paula II
56859	SP	9319	Residencial San Fernando	Res S Fernando
56922	SP	9274	Residencial Nova Jales	Res N Jales
56923	SP	9274	Residencial Alpha Jales	Res A Jales
56924	SP	9274	Conjunto Habitacional João Batista Colodetti	Cj H J B Colodetti
56925	SP	9274	Residencial Paineiras	Res Paineiras
56926	SP	9274	Residencial Paineiras II	Res Paineiras II
56933	SP	8928	Maracanã	\N
56934	SP	9239	Jardim Los Angeles	Jd L Angeles
56938	SP	9113	Pedreira	\N
56939	SP	9113	Pataxós	\N
57032	SP	9285	Residencial Frei Galvão	Res Fr Galvão
57033	SP	9285	Residencial Ângelo Grizzo	Res A Grizzo
57035	SP	9025	Núcleo Residencial Dois de Julho	Nuc Res D Julho
57037	SP	9260	Varejão	\N
57038	SP	9025	Residencial Campo Florido	Res Cpo Florido
57039	SP	9025	Núcleo Residencial São Judas Tadeu	Nuc Res S J Tadeu
57041	SP	8928	Rancho Caioçara	R Caioçara
57042	SP	8992	Residencial dos Ipês I	Res Ipês I
57043	SP	8992	Residencial dos Ipês III	Res Ipês III
57044	SP	8992	Araras dos Mori	A Mori
57047	SP	8928	Loteamento Atibaia Park II	Lot A Park II
57057	SP	9082	Jardim dos Palmares (Caucaia do Alto)	Jd Palmares (C Alto)
57058	SP	9007	Alto da Bela Vista	At B Vista
57060	SP	9285	Parque Ferreira Dias	Prq F Dias
57140	SP	9183	Pimentas	\N
57154	SP	9696	Jardim Residencial Morada das Artes	Jd Res M Artes
57155	SP	9267	Vila Célio Honorato de Souza	Vl C H Souza
57156	SP	9485	Condomínio Village do Sol	Cond V Sol
57157	SP	9315	Jardim São Rafael	Jd S Rafael
57158	SP	9696	Conjunto Residencial Jardim Villagio Torino	Cj Res Jd V Torino
57161	SP	9559	Guapituba	\N
57173	SP	9254	Village de Piemonte	V Piemonte
57175	SP	9485	Residencial Solo Rico	Res S Rico
57176	SP	9485	Loteamento Industrial e Comercial Jathay	Lot Ind C Jathay
57177	SP	9748	Conjunto Habitacional São Francisco I	Cj H S Francisco I
57178	SP	9748	Jardim Residencial Toledo Ville	Jd Res T Ville
57179	SP	9748	Conjunto Habitacional Papa João Paulo II	Cj H P J Paulo II
57184	SP	8912	Parque Residencial Laura Molina	Prq Res L Molina
57185	SP	8912	Parque Residencial Valle Verde	Prq Res V Verde
57186	SP	8912	Jardim dos Oitis	Jd Oitis
57259	SP	8926	Portal de São Francisco	P S Francisco
57260	SP	8989	Loteamento Residencial Spazio Verde	Lot Res S Verde
57261	SP	9144	Village do Sol	V Sol
57262	SP	9789	Jardim Villa Lobos	Jd V Lobos
57263	SP	9789	Jardim das Carobeiras	Jd Carobeiras
57264	SP	9789	Distrito Industrial Valdevir Davanço	Dt Ind V Davanço
57265	SP	9789	Vila Célio Honório Junior	Vl C H Junior
57266	SP	9789	Parque Cidade Jardim	Prq C Jardim
57271	SP	9216	Casa Bella Bosque Residencial	C B Bsq Residencial
57272	SP	9671	Jardim Nova Brasília	Jd N Brasília
57274	SP	9560	Quinta da Primavera	Qta Primavera
57275	SP	9560	Jardim Cybelli	Jd Cybelli
57324	SP	9177	Olaria José Benedito	O J Benedito
57326	SP	9532	Village Damha Presidente Prudente	V D Pres Prudente
57327	SP	9532	Parque Residencial Damha III	Prq Res Damha III
57328	SP	8969	Jandaia III Residencial Parque	J III Res Parque
57329	SP	8969	Residencial San Marino	Res S Marino
57330	SP	9532	Residencial Beatriz	Res Beatriz
57334	SP	9485	Campo Alegre	Cpo Alegre
57335	SP	9485	Goiabal	\N
57336	SP	9025	Loteamento Residencial Flavia	Lot Res Flavia
57337	SP	9532	Residencial Tapajós	Res Tapajós
57338	SP	9532	Jardim Panorâmico	Jd Panorâmico
57343	SP	9464	Loteamento Terras do Cancioneiro	Lot T Cancioneiro
57344	SP	9726	Água Grande	A Grande
57345	SP	9265	Condomínio Jabuticabeiras	Cond Jabuticabeiras
57346	SP	9265	Morada do Campo	M Campo
57347	SP	9768	Loteamento Reserva das Palmeiras	Lot R Palmeiras
57354	SP	8913	Conjunto Residencial Prefeito Warley Colombini	Cj Res Pref W Colombini
57355	SP	9726	Pouso Frio	P Frio
57356	SP	9726	Chácara Belo Horizonte	Ch B Horizonte
57357	SP	9775	Loteamento Jardim Bahia II	Lot Jd Bahia II
57358	SP	9775	Loteamento Serra dos Cristais	Lot S Cristais
57359	SP	9254	Mato Dentro	M Dentro
57360	SP	9254	Bairro da Posse	B Posse
57361	SP	9700	Loteamento Jardim das Estâncias	Lot Jd Estâncias
57362	SP	9700	Loteamento Jardim das Águas	Lot Jd Águas
57029	SP	9285	Jardim Geraldo Valentim (Potunduva)	Jd G Valentim (Potunduva)
57030	SP	9285	Distrito Empresarial	Dt Empresarial
57031	SP	8912	Jardim Maria Luiza II	Jd M Luiza II
57088	SP	9532	Residencial Bela Vista I	Res B Vista I
57104	SP	9025	Chácaras Morumbi	C Morumbi
57105	SP	9317	Residencial Alto do Lago	Res At Lago
57106	SP	9696	Parque Tecnológico de Sorocaba	Prq T Sorocaba
57107	SP	8961	Monte Verde	Mte Verde
57108	SP	9368	Loteamento Altos do Vale	Lot A Vale
57119	SP	9625	Jardim Alzira Franco II	Jd A Franco II
57187	SP	8912	Jardim Boa Vista	Jd B Vista
57188	SP	8912	Jardim São Rafael I	Jd S Rafael I
57189	SP	9696	Jardim Villagio Milano	Jd V Milano
57190	SP	9144	Recanto Bom Jardim	Rec B Jardim
57195	SP	9369	Fazenda Rodeio	Faz Rodeio
57196	SP	9113	Maria Imaculada	M Imaculada
57203	SP	9317	Residencial São Miguel	Res S Miguel
57204	SP	9671	Mont Serrat	M Serrat
57205	SP	9671	Vila Vinhas	Vl Vinhas
57206	SP	9671	Vila Antartica	Vl Antartica
57217	SP	9348	Sítios de Recreio Vale do Sol	S Rcr Vle Sol
57220	SP	9643	Condomínio Residencial Quebec	Cond Res Quebec
57221	SP	9113	Ponta Porã	Pnt Porã
57225	SP	8989	Residencial Parque Laguna I	Res Prq Laguna I
57226	SP	8989	Residencial Parque Laguna II	Res Prq Laguna II
57227	SP	9260	Terras de Santa Carolina II	T Sta Carolina II
57228	SP	8992	Vila Bianchi	Vl Bianchi
57229	SP	9370	Parque dos Eucaliptos II	Prq Eucaliptos II
57230	SP	9371	Residencial Floresta	Res Floresta
57231	SP	9025	Residencial Jatibela	Res Jatibela
57279	SP	9348	Primeiro de Maio	P Maio
57280	SP	9686	Jardim Santa Maria	Jd Sta Maria
57281	SP	9315	Arcindo Rinaldi	A Rinaldi
57282	SP	8992	Residencial Alvorada	Res Alvorada
57283	SP	8992	Residencial Vale das Emas	Res Vle Emas
57284	SP	9686	Jardim Nova Europa	Jd N Europa
57285	SP	8969	Parque das Árvores	Prq Árvores
57286	SP	9587	Jardim São Gabriel II	Jd S Gabriel II
57287	SP	9265	Jardim Monterrey	Jd Monterrey
57288	SP	8969	Residencial Aero Park	Res A Park
57289	SP	9748	Conjunto Habitacional São Francisco II	Cj H S Francisco II
57290	SP	9696	Jardim Itália	Jd Itália
57294	SP	9696	Jardim Residencial Chácara Ondina	Jd Res Ch Ondina
57297	SP	8961	Conjunto Habitacional Moradas do Buriti	Cj H M Buriti
57301	SP	9240	Vila Maria Isabel	Vl M Isabel
57302	SP	9696	Jardim Residencial dos Reis	Jd Res Reis
57303	SP	9177	Residencial Colinas dos Resedás	Res C Resedás
57305	SP	9231	Tomé	\N
57306	SP	9025	Chácaras Marisa	C Marisa
57310	SP	9726	Vista Alegre	V Alegre
57315	SP	8969	Residencial Esplanada das Colinas	Res Esp Colinas
57316	SP	8969	Residencial Colina Verde	Res C Verde
57317	SP	8926	Residencial Parque Bambu	Res Prq Bambu
57366	SP	9216	Jardim União	Jd União
57367	SP	9216	Jardim das Maritacas	Jd Maritacas
57368	SP	9216	Jardins do Império	J Império
57369	SP	9216	Jardim Park Real	Jd P Real
57370	SP	9216	Jardim Residencial Veneza	Jd Res Veneza
57371	SP	9244	Recanto do Bié I	Rec Bié I
57372	SP	9244	Recanto do Bié II	Rec Bié II
57374	SP	9671	Dona Catarina	Da Catarina
57376	SP	9216	Jardim Santorini	Jd Santorini
57379	SP	8913	Jardim Morumbi II	Jd Morumbi II
57380	SP	8913	Desmembramento Chácaras Zago	D C Zago
57381	SP	8926	Alto dos Ipês	At Ipês
57382	SP	8926	Jardim Santa Clara	Jd Sta Clara
57387	SP	8956	Aldeia	\N
57393	SP	8926	Conjunto Habitacional Danusa	Cj H Danusa
57394	SP	8926	Residencial Vale Verde	Res Vle Verde
57395	SP	9660	Conjunto Habitacional Santa Luzia	Cj H Sta Luzia
57396	SP	9726	da Pedra Negra	P Negra
57397	SP	9144	Residencial São Jerônimo	Res S Jerônimo
57398	SP	9560	Condomínio Jardim Sul	Cond Jd Sul
57399	SP	9368	Residencial Carlito Quilici	Res C Quilici
57400	SP	9501	Residencial Vila Romana	Res Vl Romana
57401	SP	9254	Jardim Verona	Jd Verona
57402	SP	9321	Residencial Doutor João Aldo Nassif	Res Dr J A Nassif
57403	SP	9560	Reserva Sul Condomínio Resort	R S Cond Resort
57404	SP	9560	Evidence Condomínio Resort	E Cond Resort
57405	SP	9295	Rio Abaixo	R Abaixo
57409	SP	9726	do Barranco	Barranco
57411	SP	9636	Piratininga	\N
57474	SP	9659	Chácara Recreativa Residencial Cortina DAmpezzo	Ch R Res C DAmpezzo
57475	SP	9317	Vale das Oliveiras	Vle Oliveiras
57485	SP	9660	Primavera I	\N
57486	SP	9660	Primavera II	\N
57505	SP	9501	Jardim Treviso	Jd Treviso
57506	SP	9005	Jardim América	Jd América
57507	SP	9005	Vila Prudente	Vl Prudente
57509	SP	9368	Terras de Santa Marina	T Sta Marina
57510	SP	8886	Loteamento Jardim Guarani	Lot Jd Guarani
57511	SP	9493	Residencial Bertolucci	Res Bertolucci
57512	SP	9493	Residencial Mont Carlo	Res M Carlo
57513	SP	9452	Holambra II	\N
57517	SP	9696	Jardim Portal da Primavera	Jd P Primavera
57518	SP	9696	Jardim Solar do Bosque	Jd S Bosque
57414	SP	9295	Residencial Paracatu	Res Paracatu
57416	SP	9025	Residencial Sírius	Res Sírius
57440	SP	9726	Chácaras Ingrid	C Ingrid
57441	SP	9560	Condomínio Itamaraty	Cond Itamaraty
57442	SP	9025	Residencial Parque da Fazenda	Res Prq Fazenda
57520	SP	9725	Alto da Santa Cruz	At Sta Cruz
57523	SP	9088	Sítio Cafezal	Sit Cafezal
57531	SP	9052	Residencial dos Ipês	Res Ipês
57532	SP	9052	Vivenda 7 de Setembro	V 7 Setembro
57533	SP	9052	Residencial Alto da Boa Vista	Res At B Vista
57535	SP	9435	Distrito Industrial Luis Henrique Fernandes	Dt Ind L H Fernandes
57537	SP	9026	Vila Industrial	Vl Industrial
57544	SP	9435	Jardim Julia	Jd Julia
57666	SP	9250	Jardim Canaã	Jd Canaã
57671	SP	9082	Parque Doutor Mendonça Cortez(Caucaia do Alto)	Prq Dr M Cortez (C Alto)
57691	SP	9595	Jardim Cândido Bertini II	Jd C Bertini II
57692	SP	9254	Reserva Santa Rosa	R Sta Rosa
57695	SP	9371	Pederneiras	\N
57696	SP	8912	Residencial Village Damha II	Res V Damha II
57745	SP	9015	Água Fria	A Fria
57746	SP	9015	Empresarial Anhanguera	E Anhanguera
57747	SP	9015	Empresarial Mirim	E Mirim
57748	SP	9015	Guaturinho	\N
57749	SP	9015	Pinheiros	\N
57750	SP	9015	Teles	\N
57751	SP	9015	Vau Novo	V Novo
57752	SP	9015	Empresarial dos Eucaliptos	E Eucaliptos
57753	SP	9015	Lavra Velha	L Velha
57754	SP	9015	Ponunduva	\N
57755	SP	9015	Empresarial Paineira (Jordanésia)	E Paineira (Jordanésia)
57756	SP	9015	Jordanésia (Jordanésia)	\N
57757	SP	9015	Cristais (Jordanésia)	\N
57758	SP	9015	Empresarial do Bosque (Jordanésia)	E Bosque (Jordanésia)
57759	SP	9015	São Benedito (Jordanésia)	S Benedito (Jordanésia)
57760	SP	9015	Torres (Jordanésia)	\N
57761	SP	9015	Serra dos Lagos (Jordanésia)	S Lagos (Jordanésia)
57762	SP	9015	São Jorge (Jordanésia)	S Jorge (Jordanésia)
57763	SP	9015	Empresarial Bandeirantes (Jordanésia)	E Bandeirantes (Jordanésia)
57764	SP	9015	Roseira (Jordanésia)	\N
57765	SP	9015	Empresarial Paoletti (Jordanésia)	E Paoletti (Jordanésia)
57766	SP	9015	Santa Terezinha (Jordanésia)	Sta Terezinha (Jordanésia)
57767	SP	9015	Altos de Jordanésia (Jordanésia)	A Jordanésia (Jordanésia)
57768	SP	9015	São Roberto (Jordanésia)	S Roberto (Jordanésia)
57769	SP	9015	Colina Maria Luíza (Jordanésia)	Clna M Luíza (Jordanésia)
57770	SP	9015	Alpes dos Araçás (Jordanésia)	A Araçás (Jordanésia)
57771	SP	9015	Empresarial Gato Preto (Jordanésia)	E G Preto (Jordanésia)
57772	SP	9015	Empresarial Itaim (Polvilho)	E Itaim (Polvilho)
57773	SP	9015	Empresarial Mirante de Cajamar (Polvilho)	E M Cajamar (Polvilho)
57774	SP	9015	Portais (Polvilho)	\N
57775	SP	9015	Ipês (Polvilho)	\N
57776	SP	9015	Aldeia do Sol (Polvilho)	A Sol (Polvilho)
57777	SP	9015	Panorama (Polvilho)	\N
57778	SP	9015	Jardins (Polvilho)	\N
57779	SP	9015	São Luiz (Polvilho)	S Luiz (Polvilho)
57780	SP	9015	Paraíso (Polvilho)	\N
57781	SP	9686	Jardim Porto Real	Jd Pto Real
57782	SP	9686	Jardim Veneto I	Jd Veneto I
57783	SP	9686	Villa Romana	V Romana
57784	SP	9686	Jardim Veneto II	Jd Veneto II
57785	SP	9025	Vila dos Plátanos	Vl Plátanos
57850	SP	9348	Loteamento Professora Marina Moretti Ferreira	Lot Prfa Mna M Ferreira
57860	SP	9696	Jardim Portugal	Jd Portugal
57870	SP	9317	Residencial Vermont	Res Vermont
57871	SP	9315	Desmembramento Orlando Anteghini	D O Anteghini
57872	SP	9368	Residencial Barra Feita	Res B Feita
57873	SP	9368	Altos do Vale II	A Vale II
57874	SP	9216	Jardim Residencial Dona Lucilla	Jd Res Da Lucilla
57939	SP	9659	Loteamento Moradas Rio Preto	Lot M R Preto
57940	SP	9087	Vila Abgail	Vl Abgail
57953	SP	9472	Centro	\N
57954	SP	9532	Parque Residencial José Libânio Netto	Prq Res J L Netto
57955	SP	9371	NIAS Vereador Antonio Carlos Guarnieri	N Ver A C Guarnieri
57956	SP	8928	Residencial Reserva Ecológica Atibaia	Res R E Atibaia
57957	SP	8928	Condomínio Altos da Floresta	Cond A Floresta
57958	SP	9532	Porto Bello Residence	Pto B Residence
57959	SP	9177	Santa Edwirges	Sta Edwirges
57960	SP	9659	Residencial Santa Regina	Res Sta Regina
57961	SP	9659	Ideal Life Ecolazer Residence	I L E Residence
57962	SP	9659	Residencial Maza	Res Maza
57963	SP	9659	Loteamento Parque Residencial da Lealdade	Lot Prq Res Lealdade
57964	SP	9659	Loteamento Parque Residencial da Amizade	Lot Prq Res Amizade
57965	SP	9659	Praças Golfe	P Golfe
57966	SP	9659	Loteamento Auferville III	Lot Auferville III
57967	SP	9659	Centro Empresarial Coplan	C E Coplan
57968	SP	9659	SETSUL	\N
57969	SP	9005	Bairro da Serrinha	B Serrinha
57980	SP	8954	Residencial Jockey Club	Res J Club
57985	SP	9667	Gramadão	\N
57986	SP	8901	Palmitalzinho	\N
57988	SP	9560	Jardim Maria das Graças	Jd M Graças
57989	SP	9726	Água Grande II	A Grande II
58039	SP	9267	Loteamento Jardim Sol Nascente	Lot Jd S Nascente
58041	SP	8992	Condomínio Villa Real de Bragança	Cond V R Bragança
58042	SP	8992	Vila Vicchiatti	Vl Vicchiatti
58043	SP	9660	Condomínio Residencial Altos da Quinta	Cond Res A Quinta
58044	SP	9660	Condomínio Residencial Montserrat	Cond Res Montserrat
58045	SP	9660	Condomínio Loteamento Reserva da Barra	Cond Lot R Barra
58048	SP	9660	Condomínio Residencial Campo Belo	Cond Res Cpo Belo
58056	SP	9726	Condomínio Residencial Tecoara	Cond Res Tecoara
58057	SP	9789	Sítio de Recreio Alto da Boa Vista	Sit Rcr At B Vista
58058	SP	9789	Parque Boa Vista I	Prq B Vista I
58059	SP	9789	Parque Boa Vista II	Prq B Vista II
58060	SP	9789	Jardim Saint Raphael	Jd S Raphael
58149	SP	9435	Conjunto Habitacional Ourinhos H	Cj H Ourinhos H
58150	SP	9485	Rodeio	\N
58151	SP	9043	Loteamento Balneário Camburi	Lot Baln Camburi
58152	SP	9043	Verde Mar	V Mar
58154	SP	9659	Rios de Spagna	R Spagna
58155	SP	9659	Setparque Avenida 2	S Avenida 2
58156	SP	9659	Residencial Luzia Poloto	Res L Poloto
58157	SP	9659	Residencial Morada do Sol	Res M Sol
58158	SP	9659	Loteamento Jorge Rodrigues	Lot J Rodrigues
58159	SP	9659	Residencial São Thomaz	Res S Thomaz
58162	SP	8933	O Estribo	\N
58166	SP	9141	Conjunto Habitacional Laureta Ceravo	Cj H L Ceravo
58167	SP	9141	Conjunto Habitacional Ernesto Balotari	Cj H E Balotari
57698	SP	9775	Loteamento Olaria Parque Empresarial	Lot O Prq Empresarial
57699	SP	8928	Jardim São José I	Jd S José I
57700	SP	9216	Centro Empresarial de Indaiatuba	C E Indaiatuba
57701	SP	9216	Europark Comercial	E Comercial
57702	SP	9595	Vila São José	Vl S José
57703	SP	9595	Vila Pacheco	Vl Pacheco
57711	SP	9595	Centro Industrial e Tecnológico de Santa Bárbara D'Oeste	C Ind T Sta B D'Oeste
57716	SP	9532	Residencial Golden Village	Res G Village
57717	SP	9532	Residencial Quinta das Flores	Res Qta Flores
57718	SP	9560	Villas Mabel	V Mabel
57721	SP	9493	Loteamento Residencial e Comercial Villa D'Aquila	Lot Res C V D'Aquila
57722	SP	8969	Jardim Alto do Silvares	Jd At Silvares
57723	SP	9659	Loteamento Residencial Luz da Esperança	Lot Res L Esperança
57726	SP	9587	Residencial Central Parque	Res C Parque
57728	SP	9560	Condomínio Chácaras Hípica	Cond C Hípica
57730	SP	9696	Jardim Via Reggio	Jd V Reggio
57732	SP	9532	Rotta do Sol	R Sol
57733	SP	9043	Portal do Patrimonium	P Patrimonium
57736	SP	9261	Parque Amarylis	Prq Amarylis
57743	SP	9079	Jardim Bela Vista	Jd B Vista
57744	SP	9015	Empresarial Colina	E Colina
57836	SP	8928	Condomínio Residencial Pedra Grande	Cond Res P Grande
57893	SP	8992	Residencial Floresta São Vicente	Res F S Vicente
57894	SP	8992	Cidade Universitária	C Universitária
57899	SP	9532	Residencial Cremonezi	Res Cremonezi
57924	SP	9177	Loteamento Prefeito Gilberto Filippo	Lot Pref G Filippo
57925	SP	9659	Iguatemi	\N
57926	SP	9659	Residencial Figueira II	Res Figueira II
57927	SP	9659	Giardino	\N
57928	SP	9659	Rios di Itália	R di Itália
57929	SP	9659	Villa Cassini	V Cassini
57930	SP	9659	Village Damha Rio Preto III	V D R Preto III
57931	SP	9659	Condomínio Residencial Parque da Liberdade II	Cond Res Prq Liberdade II
57932	SP	9659	Condomínio Residencial Parque da Liberdade III	Cond Res Prq Liberdade III
57933	SP	9659	Condomínio Residencial Parque da Liberdade IV	Cond Res Prq Liberdade IV
57934	SP	9659	Condomínio Residencial Parque da Liberdade V	Cond Res Prq Liberdade V
57935	SP	9659	Condomínio Residencial Parque da Liberdade VI	Cond Res Prq Liberdade VI
57936	SP	9659	Residencial Ary Attab II	Res A Attab II
57937	SP	9659	Residencial Ary Attab	Res A Attab
57938	SP	9659	Parque Residencial Nature I	Prq Res Nature I
57990	SP	8992	Condomínio Residencial Campos do Conde	Cond Res C Conde
57991	SP	8992	Condomínio Residencial Mirante de Bragança	Cond Res M Bragança
57993	SP	8992	Condomínio Residencial Vila Rica	Cond Res Vl Rica
57994	SP	8992	Condomínio Residencial Sunset Village	Cond Res S Village
57995	SP	8992	Condomínio Vale das Águas	Cond Vle Águas
57996	SP	9295	Jardim Gramadão I	Jd Gramadão I
57997	SP	9295	Jardim Gramadão II	Jd Gramadão II
57998	SP	9177	Jardim Vista Alegre	Jd V Alegre
57999	SP	9317	Jardim Residencial Francisco Cruãnes	Jd Res F Cruãnes
58000	SP	8992	Condomínio Residencial Fazenda Santa Helena	Cond Res Faz Sta Helena
58001	SP	8992	Condomínio Residencial e Comercial Fazenda Santa Petronilla	Cond Res C Faz Sta Petronilla
58003	SP	8928	Condomínio Serra da Estrela	Cond S Estrela
58024	SP	8928	Condomínio Residencial Água Verde	Cond Res A Verde
58026	SP	9406	Itaoca de Cima	I Cima
58028	SP	9775	Residencial São Victor	Res S Victor
58029	SP	9493	Jardim Três Marias	Jd T Marias
58030	SP	9493	Parque Orlanda II	Prq Orlanda II
58031	SP	9493	Parque Orlanda III	Prq Orlanda III
58034	SP	8933	Residencial São Rogério	Res S Rogério
58035	SP	9726	Piracangaguá II	\N
58098	SP	9686	Residencial Montes Claros	Res M Claros
58099	SP	9686	Portal das Flores	P Flores
58100	SP	9686	Jardim Esplanada	Jd Esplanada
58101	SP	9686	Parque das Araucárias	Prq Araucárias
58102	SP	9686	Parque das Aroeiras	Prq Aroeiras
58103	SP	9686	Condomínio Residencial Vitória Park	Cond Res V Park
58104	SP	9686	Centro Industrial e Comercial Barbacena	C Ind C Barbacena
58105	SP	9686	Residencial Cruz das Posses 1	Res C Posses 1
58130	SP	9660	Condomínio Sunset Park	Cond S Park
58131	SP	9435	Residencial Matioli	Res Matioli
58132	SP	9435	Jardim Santa Felicidade II	Jd Sta Felicidade II
58133	SP	9435	Conjunto Habitacional Ourinhos I	Cj H Ourinhos I
58134	SP	9660	Condomínio Residencial Jaguary	Cond Res Jaguary
58135	SP	9660	Condomínio Residencial Floresta	Cond Res Floresta
58136	SP	9660	Condomínio Bosque Imperial	Cond Bsq Imperial
58137	SP	8928	Residencial Portal das Rosas	Res P Rosas
58139	SP	9696	Jardim Bermejo	Jd Bermejo
58140	SP	9370	Parque Residencial Zaniboni III	Prq Res Zaniboni III
58144	SP	9432	Jardim Paulista	Jd Paulista
\.


--
-- Data for Name: log_controle; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.log_controle (versao, data, compl1) FROM stdin;
1401	2014-01-17 00:00:00	\N
\.


--
-- Data for Name: log_cpc; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.log_cpc (cpc_nu_sequencial, ufe_sg, loc_nu_sequencial, cep, cpc_no, cpc_endereco, cpc_tipo, cpc_abrangencia, temp) FROM stdin;
1825	SP	8858	13890990	Prefeitura Municipal	Rua Capitão João Urias, 347 - São Roque da Fartura	\N	\N	\N
1834	SP	9082	06723990	Bairro Cachoeira	Estrada da Cachoeira, 136 - Cachoeira	\N	\N	\N
1836	SP	9113	06845991	Associação dos Moradores do Caputera	Estrada Municipal, 733 - Caputera -Embu/SP	\N	\N	\N
1837	SP	9113	06844990	CPC Ressaca	Estrada da Ressaca, 356 - Colonial - Embu/SP	\N	\N	\N
1838	SP	9114	06900990	Cipó	Rua Benedito Jandira Soares, 64	\N	\N	\N
1840	SP	9114	06900992	Bairro Lagoa Grande	Largo do Amancio, 800 - Lagoa Grande	\N	\N	\N
1842	SP	9114	06900994	Vale Tranquilo	Rua Belmiro Silva, 184 - Vale Tranquilo	\N	\N	\N
1850	SP	9301	06950990	Bairro Laranjeiras	Estrada das Laranjeiras, s/n, km 18 (Arm. Xavier) - Laranjeiras	\N	\N	\N
1851	SP	9301	06950991	Bairro Palmeirinhas	Praça Daniel Vaz Pereira, 36 - Palmeirinhas	\N	\N	\N
1852	SP	9301	06950992	Condomínio R. N. Fleming	Estrada Milton Fleming, Nº 3000  - Bairro Senhorinhas	\N	\N	\N
1856	SP	9301	06950996	Palmeiras	Rua Inácio Vieira Pinto, 25	\N	\N	\N
1857	SP	9301	06950997	Bairro Juquiazinho	Estrada  Pedra Lisa, 351	\N	\N	\N
1860	SP	9338	07600990	Condomínio Jardim Iporã	Rua Hum, 02 - Jardim Iporã	\N	\N	\N
1871	SP	9479	18580990	Posto de Saúde	Rua Benedito Bento Rocha, s/n - Estação	\N	\N	\N
1872	SP	9485	12413990	Associação de Moradores do Goiabal e Lago Azul	Avenida dos Cedros, nº 754 - Goiabal	\N	\N	\N
1879	SP	9660	12214990	Sociedade Amigos do Bairro Águas de Canindu I	Rua Monte Sião, 260 - Águas de Canindu I	\N	\N	\N
1881	SP	9660	12214992	Sociedade Amigos e Moradores do Bairro Chácara Taquari	Estrada Municipal, nº 700 - Chácara Taquari	\N	\N	\N
1883	SP	9661	06890990	Bairro Despezio	Rua Antônio Despézio, 580 - Despézio	\N	\N	\N
1884	SP	9661	06890991	Bairro Fazenda Vitória	Estrada Embratel, 04	\N	\N	\N
1886	SP	9661	06890993	Bairro Paiol do Meio	Rua Santa Cruz, 59	\N	\N	\N
1888	SP	9669	13520990	Associação de Moradores do Bairro Theodoro de Souza Barros	Rua Engracia Gimenes, 87 - Theodoro de Souza Barros	\N	\N	\N
1930	SP	9114	06900995	Bairro do Penteado	Estrada do Baygton, 124 - Bairro dos Penteados - Embu-Guaçu/SP	\N	\N	\N
1940	SP	9660	12225990	Sociedade Amigos do Bairro Vila Araújo	Travessa Cesário de Araújo, nº 265 - Vila Araújo	\N	\N	\N
1941	SP	8992	12929990	Bom Retiro	Estrada Ismael Leme Mourão, s/n - Bom Retiro	\N	\N	\N
1942	SP	9771	12935990	Vargem	Estrada entre Serras e Águas, Km 2,5 - Guaraiuva	\N	\N	\N
1945	SP	9245	18385990	Ribeirão da Várzea	Rua 18, Quadra 16 - Ribeirão da Várzea	\N	\N	\N
1950	SP	9201	18155990	Administração Regional do Paruru	Rua Elídio Domingues, nº 53 - Bairro do Paruru	\N	\N	\N
1955	SP	9240	18207990	Conceição	Rua São Bento, s/nº - Distrito da Conceição	\N	\N	\N
1956	SP	9240	18207991	Associação de Colaboradores para o Desenvolvimento do Distrito de Tupy	Rua 04, s/nº - Altura da Rodovia Raposo Tavares Km 188, Distrito de Tupy	\N	\N	\N
1960	SP	8908	18190996	Sociedade Amigos dos Bairros do Monte Líbano e Santo Antonio	Rua José Gabriel Rachid Pires, Cx. Luz 184	\N	\N	\N
1965	SP	8901	18323990	Araçaíba	Via Itapeva, s/nº - Distrito de Araçaíba	\N	\N	\N
1966	SP	9023	18245990	Campina do Monte Alegre	Rua dos Dourados, nº 1200, Salto - Posto de Saúde	\N	\N	\N
1967	SP	9222	18560990	George Oetterer	Avenida José Rocha, 20 - Bairro George Oetterer	\N	\N	\N
2146	SP	9369	08850990	Posto de Medicamentos Sabaúna	Rua Antônio Jimenez Valleijo, 18	\N	\N	\N
2147	SP	9369	08751990	Paulo Ikemori - ME	Estrada Mogi Barroso, km 20	\N	\N	\N
2154	SP	9725	18270992	Jonas de Souza - ME	Estrada Bairro Enxovia de Baixo, s/nº - Bairro Enxovia de Baixo	\N	\N	\N
2218	SP	9490	19410992	Fazenda Santa Rita	Sede da Fazenda Santa Rita - Fazenda Santa Rita	\N	\N	\N
2219	SP	9490	19410990	Fazenda São José da Lagoa	Sede da Fazenda São José da Lagoa - Fazenda São José da Lagoa	\N	\N	\N
2220	SP	9490	19410991	Fazenda Santo Antonio da Lagoa	Sede da Fazenda Santo Antonio da Lagoa - Fazenda Santo Antonio da Lagoa	\N	\N	\N
2403	SP	9082	06722990	Bairro Morro Grande	Estrada do D.A.E., 51	\N	\N	\N
2406	SP	9369	08765990	Geraldo Alves de Souza	Rua Guararema, 32	\N	\N	\N
2407	SP	9584	08970990	Prefeitura Municipal de Salesópolis	Rua Antônio de Souza Prado, 15	\N	\N	\N
2408	SP	9476	11790990	Associação Morro do Bairro dos Marianos	Estrada Municipal dos Marianos, s/n	\N	\N	\N
2410	SP	9369	08745990	A.A. Bairro Ouro Verde	Rua Santa Virgínia, 59	\N	\N	\N
2412	SP	8967	11250990	Sociedade de Moradores e Amigos de Boracéia	Rua Deputado Emílio Justo, 68	\N	\N	\N
2704	SP	9182	11495990	Associação dos Moradores dos Morrinhos III e IV	Travessa - 312, nº 28 - Morrinhos III	\N	\N	\N
2735	SP	9369	08790990	Associação de Adquirentes de Unidades do Loteamento Real Park Mogi	Rua Coronel Cardoso de Siqueira, 3232 - Mogi das Cruzes	\N	\N	\N
3112	SP	9369	08772995	Mercado João de Barro de Mogi Ltda	Rua Minas Gerais, 20 - Chácara Guanabara	\N	\N	\N
3307	SP	9668	05275990	EEPG - Bairro Maria Trindade	Rua A, nº 15, Rodovia Anhangüera - Maria Trindade	\N	\N	\N
3308	SP	9566	13504990	Associação de Moradores do Condomínio Residencial Morada do Sol	Avenida 42, s/nº - Santa Elisa	\N	\N	\N
3309	SP	9049	13700991	Venda Branca	Avenida Família Anacleto - Venda Branca	\N	\N	\N
3310	SP	9049	13700990	Lagoa Branca	Praça da República - Lagoa Branca	\N	\N	\N
3341	SP	9088	11500990	Sociedade Melhoramento de Vila Light	Avenida  Principal, 313	\N	\N	\N
3342	SP	9338	07600994	Casa de Rações Mato Dentro	Estrada Municipal de Mato Dentro, S/N	\N	\N	\N
3366	SP	9675	17390990	São Sebastião da Serra	Rua Narciso Stocco, nº 70, Bairro do Patrimônio	\N	\N	\N
3380	SP	9369	08772991	Mercadinho Bernadotti Ltda -ME	Estrada do Negreiro,130 KM-7   Itapety	\N	\N	\N
3429	SP	9369	08700990	Sociedade Amigos de Vila Morais e Adjacências	Estrada Municipal do Sato, 248- Vila Morais	\N	\N	\N
3543	SP	9640	09835990	Amigos de Bairro do Núcleo Santa Cruz	Rua Hugo Vieira Pinto, 380 (Ant Rua Um) - Bairro Santa Cruz	\N	\N	\N
3593	SP	9210	11920990	Associação de Bairro Unidos Tucum , Retiro, Tabaquara e Colônia Central	Rodovia Prefeito Casimiro Teixeira - KM 31.4	\N	\N	\N
3594	SP	9636	11200990	Associação de Bairro de Caruara	Praça das Palmeiras, s/n	\N	\N	\N
3597	SP	9369	08830990	Escola Municipal Rural Margareth Unger L. Rosa	Estrada de Santa Catarina, KM 8 - Jardim São Pedro	\N	\N	\N
3618	SP	9301	06951995	Bairro Palestina	Estrada da Palestina, 7005 - Palestina -Juquitiba/SP	\N	\N	\N
3620	SP	9661	06890995	Bairro Itatuba	Estrada Maria Soares Pereira, 560	\N	\N	\N
3670	SP	9468	17285990	Guaianás	Rua Regente Feijó, L-80 - Distrito Guaianás	\N	\N	\N
3672	SP	9495	16603990	Santo Antônio da Estiva	Rua Santo Antônio, nº 221, Quadra 10 - Setor 200	\N	\N	\N
3673	SP	9285	17220990	Potunduva	Rua São José, nº 340 - Distrito Potunduva	\N	\N	\N
3674	SP	9348	17533990	Padre Nóbrega	Avenida Sampaio Vidal, nº 182	\N	\N	\N
3675	SP	9025	13051990	Associação dos Proprietários Rurais do Bairro Pedra Branca e Região	Rodovia SP-73, Km 6,5 , Pedra Branca	\N	\N	\N
3695	SP	9337	18123990	Dona Catarina	Praça de Igreja, nº 03 - Bairro Dona Catarina	\N	\N	\N
3696	SP	8892	18240990	Bom Retiro da Esperança	Rua Independência, nº 11 - Bom Retiro da Esperança	\N	\N	\N
3697	SP	9667	18230992	J J Oliveira Bar e Mercearia Ltda - ME	Rua Cônego Francisco Ribeiro, 31 - Pocinho	\N	\N	\N
3700	SP	8892	18240993	Posto de Saúde do Bairro Machadinho	Estrada Municipal do Machadinho, s/nº - Bairro do Machadinho	\N	\N	\N
3701	SP	8892	18240995	Posto de Saúde Maria Lopes dos Santos	Estrada Municipal Bairro Ribeirão Grande, s/nº - Bairro Ribeirão Grande	\N	\N	\N
3702	SP	8892	18240991	Posto de Saúde do Bairro Boa Vista	Rodovia Raposo Tavares, s/nº, km 200 - Bairro Boa Vista	\N	\N	\N
3703	SP	8892	18240992	Posto de Saúde do Bairro Guareí Velho	Estrada Municipal, s/nº - Bairro Guareí Velho	\N	\N	\N
3710	SP	8976	18590991	Associação dos Proprietários e Moradores do Jardim Santo Inácio	Avenida Silvana, nº 1783 - Jardim Santo Inácio	\N	\N	\N
3711	SP	9037	18300990	Nelsi Donizeti de Almeida - ME	Avenida Januário R. Siqueira, nº 1500 - Bairro Turvo das Almeidas	\N	\N	\N
3712	SP	8865	18220991	Posto de Saúde do Bairro Ribeirãozinho	Estrada para o Bairro da Capuavinha, s/nº - Bairro Ribeirãozinho	\N	\N	\N
3714	SP	8865	18220993	Posto de Saúde do Bairro Cerrado	Rua Sabiá, s/nº - Bairro Cerrado	\N	\N	\N
3717	SP	9000	18295990	Aracaçu	Rua Carlos Riedel, nº 65 - Distrito de Aracaçu	\N	\N	\N
3719	SP	9231	18445990	Engenheiro Maia	Rua Principal, s/n - Distrito Engenheiro Maia	\N	\N	\N
3720	SP	9231	18450990	Turiba do Sul	Rua Pedro Rosa, nº 180 - Distrito Turiba do Sul	\N	\N	\N
3721	SP	9201	18150993	Associação Amigos do Bairro da Granja Votorantim I e II	Rua L, Quadra 12, Lot.12 - Bairro da Granja Votorantim I	\N	\N	\N
3723	SP	9342	19430991	Assentamento Santo Antonio	Sede do Assentamento Santo Antonio - Assentamento Santo Antonio	\N	\N	\N
3724	SP	9342	19430990	Posto de Atendimento à Saúde Bairro Areia Branca	Posto de Atendimento à Saúde Bairro Areia Branca - Areia Branca	\N	\N	\N
3725	SP	9729	19280990	Escola Estadual Prof. Romilda L. P. dos Santos	Escola Estadual Prof. Romilda L. P. dos Santos - Gleba Água Sumida	\N	\N	\N
3726	SP	9729	19280991	Escola Estadual Prof. Francisco Ferreira de Souza	Escola Estadual Prof. Francisco Ferreira de Souza - Ribeirão Bonito	\N	\N	\N
3727	SP	9533	19400991	Escola Municipal Jardim Eldorado	Assentamento Tupanciretã - Jardim Eldorado	\N	\N	\N
3728	SP	9573	19273990	Santa Marina - Setor II	Gleba XV de Novembro, Setor II - Subprefeitura de Rosana - Fazenda Santa Marina	\N	\N	\N
3729	SP	9573	19273991	Santa Marina - Setor II	Gleba XV de Novembro, Setor II - Subprefeitura de Rosana - Fazenda Santa Marina	\N	\N	\N
3730	SP	9573	19273992	Campinho	Posto Avançado de Saúde - Campinho	\N	\N	\N
3731	SP	9217	19560990	Prefeitura Municipal (Convenente)	Centro de Saúde - Sete Copas	\N	\N	\N
3732	SP	9669	13520991	Associação dos Proprietários do Condomínio Serra Verde	Rodovia SP-304 - km 209 - Ribeirão Vermelho	\N	\N	\N
3733	SP	8912	14800990	Centro de Desenvolvimento Comunitário Bela Vista	Escola Estadual Hermínio Pagotto, s/n - Bela Vista do Chibarro	\N	\N	\N
3734	SP	8912	14800991	Mercearia Nossa Senhora de Fátima	Rodovia Abílio Augusto Correia, Km 01 - Machados	\N	\N	\N
3735	SP	9153	14813990	Nova Paulicéia	Avenida Araraquarense,s/nº - Distrito de Nova Paulicéia	\N	\N	\N
3736	SP	9660	12226991	Sociedade Amigos do Bairro Santa Cecília I	Estrada Dom José Antonio Couto nº 5007 - Santa Cecília I	\N	\N	\N
3741	SP	9177	12500990	Mercearia Pingo de Ouro	Rua Doutor Luís Ribeiro Castilho, nº 246 - Bairro Pingo de Ouro	\N	\N	\N
3748	SP	9283	13240990	Associação do Valle Esmeralda	Estrada Manuel G. Navarro, Km 13,5, Vale Esmeralda	\N	\N	\N
3749	SP	9700	13173990	Sindicato dos Trabalhadores Agric. Familiar de Sumaré e Região	Rua Luiz Vaz de Camões, nº 226 - Jardim Primavera	\N	\N	\N
3751	SP	9213	15385990	Associação dos Moradores do Bairro do Ipê	Alameda das Hortencias, s/n	\N	\N	\N
3753	SP	9239	06886990	Jardim Samambaia	Estrada Mato a Dentro, 695	\N	\N	\N
3762	SP	9673	11620992	Boiçucanga	Rua Gilmar Furtado de Oliveira, 111 - Boiçucanga	\N	\N	\N
3765	SP	9673	11620995	Juquey	Praça Simeão Faustino, 175 - Juquey	\N	\N	\N
3766	SP	9673	11620998	Associação dos Moradores da Vila Baiana	Rua Ricardo Queiroz nº 280 - Vila Baiana - Bairro do Sahy	\N	\N	\N
3768	SP	9082	06724990	Bairro dos Mendes	Estrada dos Mendes, 310	\N	\N	\N
3769	SP	9591	19250990	Centro de Saúde do Assentamento Bom Pastor	Centro de Saúde do Assentamento Bom Pastor -  Assentamento Bom Pastor	\N	\N	\N
3770	SP	9086	19860990	Posto de Atendimento à Saúde	Dependências do PAS - Bairro do Cateto	\N	\N	\N
3771	SP	9533	19400990	Posto de Saúde do Assentamento Primavera	Posto de Saúde do Assentamento Primavera - Primavera	\N	\N	\N
3773	SP	9005	12280994	Mercearia Paulina - ME	Estrada do Tataúba, nº 4277 - Bairro Perinho	\N	\N	\N
3775	SP	9157	18218990	Gramadinho	Rua Elias Jorge Daniel, nº 56 - Distrito de Gramadinho	\N	\N	\N
3796	SP	9564	14830990	Bairro do Taquaral	Bairro do Taquaral	\N	\N	\N
3822	SP	9719	14765990	Taquaral	Rua do Cafezal, n. 746, Centro	\N	\N	\N
3837	SP	9668	05276990	Jardim Paineiras Perus	Rua Minas Gerais, 46 -Jardim das Paineiras- Morro Doce -Perus/SP	\N	\N	\N
3842	SP	8908	18190997	Aguinaldo Antônio de Oliveira Araçoiaba ME	Estrada do Cercado, s/n, cx 837, Bairro do Cercado	\N	\N	\N
3845	SP	9668	04891990	EEPG Prof. Regina Miranda Brant de Carvalho	Rua Filomena Belmont, 75 - Eng. Marsilac -São Paulo/Capital	\N	\N	\N
3852	SP	9640	09835991	Sociedade Amigos de Bairro Taquacetuba	Estrada Taquacetuba, 207 - Bairro Taquacetuba	\N	\N	\N
3853	SP	9640	09842993	Sociedade Amigos e Bairro Jardim Represa	Estrada Galvão Bueno, 30.125 - Jardim Represa	\N	\N	\N
3913	SP	9668	04948990	Associação dos Moradores da Chácara Bananal	Rua Projetada, 21	\N	\N	\N
4169	SP	9406	18435992	Bairro do Braganceiro	Estrada Municipal do Bairro do Braganceiro, s/n, Braganceiro	\N	\N	\N
4170	SP	9247	18480990	Santo Antônio	Rua Gerson de Souza Lima, 1041, Santo Antônio	\N	\N	\N
4171	SP	9247	18480991	Ribeirão Branco	Rua Mato Grosso, 167, Ribeirão Branco	\N	\N	\N
4172	SP	9097	13780990	Três Barras	Rua Francisca Rameires Grespan, 28, Três Barras	\N	\N	\N
4173	SP	9097	13780991	Ribeirão Santo Antônio	Praça Ziconeca, 87, Ribeirão Santo Antônio	\N	\N	\N
4175	SP	8992	12924990	Araras do Mori	Rodovia Capitão Barduíno, km 104,5 - Araras do Mori	\N	\N	\N
4176	SP	8961	17036990	Vale do Igapó Empreendimentos Ltda	Alameda das Tachã, s/n, Q BN Lote 1, Vale do Igapó	\N	\N	\N
4177	SP	8928	12940991	Cachoeira	Estrada do Bairro Boa Vista, km 10 - Boa Vista	\N	\N	\N
4178	SP	8928	12940992	Associação Comunitária do Bairro Pedreira	Estrada dos Pires s/n Loteamento Pedra Bela - ao lado da Pedreira Atibaia	\N	\N	\N
4179	SP	8928	12948990	Portão	Rua Antônio da Cunha Leite, 3209 - Portão	\N	\N	\N
4180	SP	8906	18147990	Associação dos Moradores do Bairro Santa Ella	Estrada Municipal Imperial, 4656, Santa Ella	\N	\N	\N
4181	SP	8875	18125990	Sociedade Melhoramentos Recanto dos Pássaros	Rodovia Raposo Tavares, Km 82, Bairro Genebra	\N	\N	\N
4594	SP	9114	06900998	Chácara Califórnia	Avenida Dois, 13 - Chácara Califórnia - Embu-Guaçu/SP	\N	\N	\N
4707	SP	8928	12940993	Associação do Centro comunitário do Bairro da Boa Vista	Estrada Luciano Rocha Peçanha, s/n - Bairro da Cachoeira	\N	\N	\N
4708	SP	9717	18180990	Prefeitura Municipal de Tapirai	Avenida José Garcia de Salles, 1003, Rio Turvo	\N	\N	\N
4709	SP	9093	13690990	Parque Pantanal	Rua Padre Jeremias José Nogueira, 274, Parque Pantanal	\N	\N	\N
4710	SP	9201	18150994	Sociedade de Amigos do Recreio Residencial de Ibiúna	Estrada Municipal, 1000, Recreio	\N	\N	\N
4711	SP	9223	13537990	Associação dos Prop de Lotes no Loteam Núcleo Lageado Portal dos Nobres	Rodovia SP 191 Rio Claro/Ipeúna	\N	\N	\N
4713	SP	9660	12213991	Associação de Moradores do Bairro Bengalar	Estrada do Bengalar, 982 - Bengalar	\N	\N	\N
4721	SP	9660	12225991	Sociedade Amigos do Bairro Chácara Santa Helena	Rua Dois, nº 160 - Chácaras Santa Helena	\N	\N	\N
4766	SP	9476	11790991	Posto de Atendimento de Manoel da Nóbrega	Estrada Municipal, s/n	\N	\N	\N
4767	SP	9476	11790992	Assoc. Rural de Três Barras	Estrada Municipal, s/n	\N	\N	\N
4768	SP	9237	11740991	Associação de Bairro Jardim Anchieta	Rua Radamés Incontri Filho, 60	\N	\N	\N
4779	SP	9432	06172990	Associação Habitacional Casa Para Todos - Vila Nova Quitauna	Olívio Basílio Marçal , 270	\N	\N	\N
4158	SP	9114	06900997	Bairro de Santa Fé	Estrada Antônio Gerassi, 2000	\N	\N	\N
4161	SP	9369	08772990	Mercadinho e Bar Nova Geração Mogi Ltda-ME	Estrada Taboão do Paratei Km 25 s/n -Taboão	\N	\N	\N
4163	SP	9789	15507990	Associação dos Moradores da Vila Carvalho	Rua 3, n.91, Vila Carvalho	\N	\N	\N
4164	SP	9770	17282990	Vanglória	Rua Pedro Dias Barbosa, 140, Centro	\N	\N	\N
4166	SP	9531	19470990	Prefeitura Municipal de Presidente Epitácio	Estrada Vicinal para Caiuá, s/n, Lagoinha	\N	\N	\N
4167	SP	9406	18435990	Itaóca	Rodovia João Ferreira da Silva, s/n, Itaóca	\N	\N	\N
4168	SP	9406	18435991	Bairro do Barreiro	Rodovia Luiz José Squário, s/n, Barreiro	\N	\N	\N
4637	SP	9625	09170990	Associação dos Proprietários e Moradores do Jardim Cipreste	Caminho dos Vianas, 801 - Jardim Cipreste	\N	\N	\N
4753	SP	9499	06550990	Pununduva	Estrada Francisco Misse, 1200 - Purunduva-Pirapora do Bom Jesus	\N	\N	\N
4754	SP	8967	11250992	Associação dos Condominos do Loteamento Morada da Praia	Rod. Dr. Manoel Hippolito do Rego, KM 193	\N	\N	\N
4755	SP	9016	11950990	Escola Municipal de Capitão Braz	Estrada Municipal, s/n	\N	\N	\N
4756	SP	9016	11950991	Escola Municipal de Vila Andreia	Estrada Municipal, s/n	\N	\N	\N
4757	SP	9016	11950992	Escola Municipal de Barra do Azeite	Estrada Municipal, s/n	\N	\N	\N
4758	SP	9016	11950993	Escola Municipal do Bairro Jacupiranguinha	Estrada Municipal, s/n	\N	\N	\N
4759	SP	9016	11950994	Escola Municipal da Vila Tatu	Estrada Municipal, s/n	\N	\N	\N
4760	SP	9182	11435990	Associação de Moradores do Morro do Engenho	Rua Leopoldo Xavier, 45	\N	\N	\N
4761	SP	9362	11850991	EMEI Maria José de Carvalho - Ribeirão Bonito	Sí´tio Ribeirão Bonito, s/n	\N	\N	\N
4763	SP	9636	11220991	Sociedade Melhoramentos de Monte Cabrão	Av. Principal de Monte Cabrão, 02	\N	\N	\N
4765	SP	9678	11365990	Sociedade Melhoramentos Dique Sambaiatuba	Rua 02, 19/21 - Fundos	\N	\N	\N
4798	SP	9082	06729990	Capelinha	Estrada da Capelinha, 8917 - Terra de São Felipe (Caucaia do Alto)	\N	\N	\N
4799	SP	9082	06729991	Bairro dos Neves	Estrada dos Neves, 480 - Bairro dos Neves	\N	\N	\N
4800	SP	9014	19450990	Agrovila III	Rua Dois,s/n, Agrovila III	\N	\N	\N
4801	SP	9014	19450991	Agrovila IV	Rua Um, 24, Agrovila IV	\N	\N	\N
4802	SP	9014	19450992	Sao Francisco	Estrada Vicinal Presidente Epitácio, s/n, Fazenda São Francisco	\N	\N	\N
4803	SP	9174	17310990	Guarapuá	Rua Setímio Izidro Tidei, 647, Guarapuã	\N	\N	\N
4804	SP	8936	16520991	Bacuriti	Rua Doze de Outubro, s/n, Centro	\N	\N	\N
4805	SP	9691	16510990	Simões	Rua Coronel Armando Simões, s/n, Simões	\N	\N	\N
4813	SP	9660	12214994	Associação dos Proprietários das Chácaras Bonsucesso	Estrada Juca de Carvalho, 15100,  Pau de Saia	\N	\N	\N
4814	SP	9660	12213992	Sociedade Amigos do Bairro Altos do Caetê e Adjacências	Estrada do Bonsucesso,  km 2,5   Altos do Caete	\N	\N	\N
4815	SP	9729	19280992	Santa Zélia	Posto de Atendimento á Saúde - Assentamento Santa Zélia	\N	\N	\N
4816	SP	9729	19280993	Escola Estadual Laudenor de Souza	Escola Estadual Laudenor de Souza - Assentamento Laudenor de Souza	\N	\N	\N
4822	SP	9114	06901990	Jardim Paulistinha	Estrada Municipal da Paulistinha, 70 -A  Jardim Paulistinha	\N	\N	\N
4825	SP	8992	12924992	Atibaianos	Estrada Domício Franco de Camargo, km 3 - Atibaianos	\N	\N	\N
4827	SP	9432	06266990	CPC Associação Açucará	Assembléia, 32  Jardim Açucará	\N	\N	\N
5028	SP	9669	13520992	Residencial Botânico	Alameda dos Angicos, 472 - Jardim Botânico	\N	\N	\N
6033	SP	8967	11250993	Associação de Moradores do Jardim Ana Paula	Rua C, nº 11 Km 220,5	\N	\N	\N
5076	SP	9646	12249990	Sub Prefeitura do Distrito de São Francisco Xavier	Praça Cônego Manzi, s/n - Distrito de São Francisco Xavier	\N	\N	\N
5079	SP	9667	18230994	Murosaki & Marczuk	Rua Avelino Antonio Vieira, 219 - Gramadão	\N	\N	\N
5081	SP	9369	08766990	Paulo Roberto Editore - ME	Rodovia Mogi-Bertioga Km 75, nº 771 - Bairro: Manuel Ferreira	\N	\N	\N
5089	SP	9038	18195991	Centro de Saúde do Bairro do Porto	Avenida Bom Jesus, s/n, Bairro Porto	\N	\N	\N
5090	SP	9640	09851990	Associação do Conjunto Habitacional de Vila Ferreira	Rua da Vitória, 3.315 - Vila Ferreira	\N	\N	\N
5169	SP	8992	12902990	Água Comprida	Rodovia Padre Aldo Bolini, km 70 - Água Comprida	\N	\N	\N
5617	SP	9260	13308990	Associação dos Proprietários e Amigos do Empreendimento Eldorado APAEE	Estrada Taquaral s/n - Bairro Taquaral	\N	\N	\N
5639	SP	9667	18230995	Panificadora Santa Cruz	Rua Euclides de Almeida Bueno, 362 - Santa Cruz dos Matos	\N	\N	\N
5647	SP	9671	18140990	São João Novo	Rua Faustina Maria das Dores, 30 - Distrito de São João Novo	\N	\N	\N
5818	SP	9176	08900990	Bar da Dona Raimunda	Estrada Itapeti do Salto nº 10511 térreo - Itapeti, Guararema	\N	\N	\N
5819	SP	9608	07500990	Sociedade Amigos das Chácaras Boa Vista	Rua Horácio José do Prado nº 471, km 55, Chácaras Boa Vista	\N	\N	\N
5871	SP	9182	11446990	Sociedade Moradores e Amigos da Cachoeira	Estrada Guarujá Bertioga  Km 13	\N	\N	\N
5874	SP	9369	08767991	São João	Estrada Kem Saito, nº305	\N	\N	\N
5881	SP	9182	11442990	Associação de Moradores do Bairro Cidade Atlântica	Rua Uruguai nº 1721	\N	\N	\N
5933	SP	8970	08940991	CPC Rio Acima	Estrada do Eroy nº 315 Bairro Rio Acima	\N	\N	\N
5944	SP	8860	18770990	Parque dos Lagos	Chalé nº 02, Prainha Tarcis Negrão - Parque dos Lagos	\N	\N	\N
5948	SP	9660	12213993	Altos do Caetê II - Soc. Amigos do Bairro Alto do Caetê e Adjacências	Estrada Municipal Juca de Carvalho, 2004 - Bar e Mercearia do Tonho	\N	\N	\N
5989	SP	8924	07400990	Bairro do Correia	Estrada Esmera Maria Rodrigues, 1369	\N	\N	\N
6058	SP	9608	07500992	Bairro Granja Urupês	Via das Perobas nº 176, Bairro Granja Urupês	\N	\N	\N
6064	SP	9088	11543990	Sociedade de Melhoramentos do Caminho dos Pilões	Caminho dos Pilões s/nº	\N	\N	\N
6065	SP	9237	11740993	Centro de Ref. e Apoio aos Pequenos e Médios Proprietários do Raminho	Estrada do Raminho nº 1995	\N	\N	\N
6066	SP	9237	11740994	Associação dos Moradores do Parque Real e Adjacências	Rua Doze nº 1452	\N	\N	\N
5360	SP	8961	17110990	Tibiriçá	Rua Figueira de Melo, Quadra 3, s/n - Centro	\N	\N	\N
5367	SP	9668	08372990	Associação de Moradores Jardim Nova Vitória	Avenida Vitória nº 27 - Bairro Jardim Nova Vitória - São Paulo	\N	\N	\N
5373	SP	8989	18605990	Rural Green Valley	Alameda das Primaveras, 101,  Green Valley	\N	\N	\N
5374	SP	9129	19275990	Centro de Saúde do Bairro Santa Rita do Pontal	Rua Dois, s/n, Santa Rita do Pontal	\N	\N	\N
5375	SP	9129	19275991	Centro de Saúde do Bairro Agrovila Rosanela	Rua Central, s/n, Agrovila Rosanela	\N	\N	\N
5377	SP	9452	18720990	EMEF Serrinha da Prata	Rodovia Raposo Tavares, km 251, Paranapanema	\N	\N	\N
5380	SP	9468	17288990	Posto de Saúde de Santelmo	Rua Eliazar Braga, Q-123, Santelmo	\N	\N	\N
5386	SP	9669	13520993	EMEIF Dr. Celso Silveira Mello	Rua Rio Piracicaba, s/n, Bairro Vertentes	\N	\N	\N
5387	SP	9660	12214995	Ass. dos Moradores do Jardim Cristina, Ouro Preto e Portal de Minas	Rua Servidão, nº 2  4ª   Travessa,  - Bairro dos Freitas	\N	\N	\N
5388	SP	9369	08766991	Bairro São João	Estrada Kem Saito nº 205 - Bairro São João	\N	\N	\N
5496	SP	9518	18540991	CAIC Agrovila	Rua Três, s/n, Posto de Saúde, Fazenda CAIC, Agrovila	\N	\N	\N
5503	SP	9025	13054990	Pouso Alegre e Vista Alegre (ASSAMPA)	Estrada Municipal, s/n, Lote 10, Chácara Vista Alegre	\N	\N	\N
5514	SP	8992	12902991	Guaripocaba	Estrada do Guaripocaba s/n - Bairro Guaripocaba	\N	\N	\N
5536	SP	8908	18190991	Guarda Municipal de Araçoiaba da Serra	Avenida D. Pedro II, nº 192 - Araçoiabinha	\N	\N	\N
5544	SP	9025	13056990	Associação dos Moradores do Núcleo Res N Sra Aparecida - A.N.S.A	Rua 10, nº 7 - Nossa Senhora Aparecida	\N	\N	\N
5561	SP	9088	11538990	Associação de Moradores da Vila Noel	Avenida Principal, 03	\N	\N	\N
5570	SP	9640	09725990	Associação Civil Comunitária do D.E.R. e Vila das Paineiras	Rua Maria Adelaide L. Quelhas, 261 A - DER - Vila das Paineiras	\N	\N	\N
5653	SP	9640	09761991	Sociedade Amigos dos Moradores do Parque São Bernardo	Rua Minas Gerais, s/n - Parque São Bernardo	\N	\N	\N
5654	SP	9640	09783990	Sociedade Amigos do Bairro Vila Esperança	Rua Jardim, 395 - Vila Esperança	\N	\N	\N
5655	SP	9640	09820990	Associação de Moradores do Jardim Nossa Senhora de Fátima	Mario Missiroli, 15029 - Jardim Nossa Senhora de Fátima	\N	\N	\N
5727	SP	9640	09782991	Conselho Comunitário do Núcleo Jesus de Nazaré	Avenida Jesus de Nazaré, 59.525 - Ferrazópolis	\N	\N	\N
5730	SP	9640	09792992	Sociedade Amigos da Vila Sabesp	Rua das Colinas, 32069 - Montanhão - Vila Sabesp	\N	\N	\N
5731	SP	9640	09791991	Conselho Comunitário do Núcleo Cafezais do Bairro Montanhão	Passagem dos Cafezais, 64.673 - Montanhão	\N	\N	\N
5737	SP	9660	12226990	Sociedade Amigos do Portal do Céu, Santa Lúcia e Santa Rita	Avenida Brasil, 31 - Mercearia do Cezar	\N	\N	\N
5767	SP	9667	18230990	Valmaris Minimercado	Rua Laurindo Gomes Ferreira, 142 - Abaitinga	\N	\N	\N
5772	SP	9524	17790990	Pracinha	Rua José Bonifácio, 349 - Centro	\N	\N	\N
5838	SP	9640	09781992	Conselho Comunitário do Jardim Limpão e Jardim Regina	Rua Alberto Benecasa, 68133	\N	\N	\N
5839	SP	9176	08900992	Capela São josé	Estrada do Rio Comprido	\N	\N	\N
5842	SP	9668	04855990	Caixa Postal Comunitária Casa Branca	Rua Vitória nº 17-B - Parque São Miguel (Zona Sul)	\N	\N	\N
5845	SP	9365	19260990	Antonio Conselheiro	Posto de Saúde Familiar - Assentamento Antonio Conselheiro	\N	\N	\N
5847	SP	9669	13520994	Chácaras Primavera	Avenida Principal nº 2	\N	\N	\N
5848	SP	9584	08970991	CPC Ribeirão do Pote	Rua do Casarão, nº 13	\N	\N	\N
5849	SP	9369	08767990	Chácara Novo Horizonte	Rua Novo Horizonte, nº 30	\N	\N	\N
5893	SP	9687	11910990	Associação Comunitária do Bairro Barra do Ribeirão da Serra	Rua Beija Flor  nº 169	\N	\N	\N
5949	SP	9608	07500991	Monte Negro	Estrada do Monte Negro Km 8, Bairro Monte Negro	\N	\N	\N
6032	SP	9182	11446991	Sociedade Amigos do Perequê	Estrada Guarujá Bertioga	\N	\N	\N
6034	SP	8967	11250994	Instituto Aliança com a Vida	Rua Engenheiro José Sanches Ferrari nº 87A	\N	\N	\N
6037	SP	9671	18145990	Canguera	Rua Amaro Godinho da Silva, 660 - Distrito de Canguera	\N	\N	\N
6042	SP	9146	07863990	Vargem Grande	Estrada da Vargem Grande, 4713	\N	\N	\N
6072	SP	8923	13160990	Sítio Novo	Estrada Vicinal Artur Nogueira/Limeira, km 0, Bairro Sítio Novo	\N	\N	\N
6085	SP	9703	08665990	Jardim Alto de Suzano	Rua Marcos Prado de Almeida	\N	\N	\N
6141	SP	8908	18190993	Papelaria Lia Lua	Rua Doutor Celso Charuri, 223 - Jundiaquara	\N	\N	\N
6152	SP	9640	09790990	Associação Beneficente Plante Sorrisos	Passagem da Biquinha, 86	\N	\N	\N
6107	SP	9025	13108990	Serra das Cabras	Estrada Prof Lídia Abdalla, s/n, km 10	\N	\N	\N
6122	SP	9369	08880990	Escola Municipal Fujitaro Nagao	Estrada Fujitaro Nagao	\N	\N	\N
6123	SP	9668	04884990	Jardim Manacá da Serra	Rua Amaro Alves do Rosário, 3213	\N	\N	\N
6169	SP	9668	04875990	ASSOCIAÇÃO DOS MORADORES DO NOVO SÃO NORBERTO	RUA BEM-TE-VI, 117 - PARELHEIROS - SÃO PAULO	\N	\N	\N
6172	SP	8992	12924993	Araras dos Pereiras	Estrada Municipal Ulysses da Silveira Guimarães, s/n - Araras dos Pereiras	\N	\N	\N
6173	SP	9499	06550991	Colinas de Shidharta	Rua Pardal, 01 - Colinas de Shidharta - Piarapora do Bom Jesus/SP.	\N	\N	\N
6180	SP	9527	11717990	Centro Comunitário de Vila Mirim Nossa Senhora Aparecida	Rua Julio Prestes de Albuquerque s/nº	\N	\N	\N
6181	SP	9668	04884992	Associação Unidos do Bairro Jardim Bom Clima	Rua João Ferreira de Freitas, 55 - Jardim Bom Clima - São Paulo - SP	\N	\N	\N
6190	SC	8507	88317990	CPC ESPINHEIRINHO	RUA CLARINDO SEBASTIÃO DA CUNHA - POSTO DE SAÚDE	\N	\N	\N
6194	SP	8992	12929991	Marina	Rua Marinópolis, 4 - Mercearia Dona Neusa	\N	\N	\N
6195	SP	9640	09781990	Associação Comunitária do Jardim Regina	Rua João de Barros, 222	\N	\N	\N
6199	SP	8967	11250995	Associação Condominial Parque Caiubura	Avenida Caiubura nº 10	\N	\N	\N
6203	SP	9182	11446992	Associação de Moradores Futura Geração da Cachoeira	Viela Santo Amaro 142	\N	\N	\N
6208	SP	9088	11540990	Associação de Educação Ambiental Cubatão de Bem com o Mangue	Rua Larissa Cokner, 378	\N	\N	\N
6209	SP	9673	11620991	Caixa Postal Comunitário do Bairro Tropicanga	Rua Tropicanganº 22	\N	\N	\N
6224	SP	9183	07177990	Centro Comunitário Habitacional e Educacional Betel	Rua Ecologia, 14	\N	\N	\N
6234	SP	9756	11680990	Associação dos Moradores do Sertão do Ubatumirim	Estrada Pasto Grande, 3160 Sertão do Ubatumirim	\N	\N	\N
6250	SP	9369	08880991	União dos Moradores do bairro Cocuera	Estrada Katsuji Kitagushi, 82	\N	\N	\N
6252	SP	8976	18590990	São Roque Novo	Praça Luiz Francisco Vieira, s/n	\N	\N	\N
6255	SP	9362	11850992	Associação de Moradores do Bairro Engano e Adjacências	Rodovia Regis Bittencourt, 81 - Engano	\N	\N	\N
\.


--
-- Data for Name: log_faixa_bairro; Type: TABLE DATA; Schema: public; Owner: sindserv
--

COPY public.log_faixa_bairro (bai_nu_sequencial, fcb_nu_ordem, fcb_rad_ini, fcb_suf_ini, fcb_rad_fim, fcb_suf_fim) FROM stdin;
1	1	69918	040	69918	069
2	1	69901	160	69901	199
3	1	69911	030	69911	119
5	1	69906	000	69906	129
6	1	69900	830	69900	899
7	1	69911	560	69911	649
8	1	69911	650	69911	759
9	1	69901	310	69901	359
10	1	69900	001	69900	049
12	1	69900	370	69900	769
13	1	69905	400	69905	489
14	1	69905	190	69905	269
15	1	69914	310	69914	439
16	1	69905	000	69905	049
17	1	69900	050	69900	099
18	1	69905	050	69905	079
19	1	69917	520	69917	599
20	1	69918	750	69918	859
22	1	69920	160	69920	309
24	1	69918	160	69918	239
25	1	69912	290	69912	509
26	1	69918	860	69918	879
27	1	69900	330	69900	369
28	1	69900	190	69900	269
29	1	69918	240	69918	339
30	1	69915	500	69915	579
31	1	69915	410	69915	499
32	1	69900	770	69900	829
33	1	69911	420	69911	479
36	1	69901	040	69901	159
37	1	69918	340	69918	409
38	1	69911	380	69911	419
39	1	69911	200	69911	219
40	1	69900	100	69900	119
41	1	69902	750	69902	789
42	1	69912	180	69912	289
43	1	69900	120	69900	189
45	1	69905	490	69905	569
46	1	69907	620	69907	779
47	1	69918	700	69918	729
48	1	69901	510	69901	639
50	1	69905	570	69905	699
51	1	69912	000	69912	049
52	1	69921	680	69921	809
53	1	69906	390	69906	519
55	1	69906	260	69906	309
57	1	69909	730	69909	879
59	1	57312	250	57312	529
60	1	57307	000	57307	299
61	4	57305	330	57305	559
62	3	57303	200	57303	399
63	1	57313	000	57313	899
64	1	57310	410	57310	899
65	2	57304	460	57304	649
66	1	57311	180	57311	549
67	1	57302	000	57302	899
68	1	57310	000	57310	239
69	2	57306	350	57306	899
70	1	57300	000	57300	899
71	1	57306	000	57306	349
72	2	57303	400	57303	759
73	1	57314	000	57314	899
74	3	57307	300	57307	899
75	1	57316	000	57316	299
76	1	57305	000	57305	329
77	1	57316	300	57316	599
78	3	57312	530	57312	899
79	1	57303	760	57303	899
80	1	57301	000	57301	239
81	1	57308	000	57308	899
82	3	57305	560	57305	899
83	1	57304	000	57304	459
84	2	57310	240	57310	409
85	1	57312	000	57312	249
86	2	57301	240	57301	699
87	2	57315	000	57315	899
88	1	57311	550	57311	899
89	1	57303	000	57303	199
90	11	57075	000	57076	999
91	2	57048	000	57048	999
91	3	57083	000	57083	999
92	5	57045	000	57045	799
93	5	57017	600	57018	399
95	5	57084	000	57086	999
96	4	57017	200	57017	499
97	4	57080	000	57080	499
98	2	57020	000	57020	999
99	4	57018	400	57018	599
100	1	57038	000	57038	499
101	12	57050	000	57051	999
101	13	57055	000	57055	499
102	4	57042	200	57043	999
103	1	57070	000	57070	499
104	6	57039	700	57039	999
105	7	57052	400	57052	999
107	11	57038	500	57038	699
108	1	57040	000	57042	199
109	2	57022	000	57022	999
110	7	57035	500	57036	999
111	9	57017	000	57017	199
112	1	57031	000	57031	999
112	10	57037	000	57037	999
113	5	57017	500	57017	599
114	7	57045	800	57045	999
115	1	57030	000	57030	499
116	1	57055	500	57055	999
116	2	57057	000	57057	999
117	11	57052	000	57052	399
118	2	57025	000	57025	999
119	8	57030	500	57030	999
120	1	57014	000	57014	999
121	3	57035	000	57035	499
122	5	57010	800	57010	999
123	1	57010	000	57010	369
124	5	57039	200	57039	599
125	2	57070	500	57070	999
126	2	57063	000	57063	999
128	19	57046	000	57046	999
129	1	57060	000	57061	999
129	4	57081	000	57081	999
130	4	57010	370	57010	799
131	16	57015	000	57015	999
132	1	57600	550	57600	799
133	1	57600	000	57600	549
134	1	57606	000	57606	899
135	1	57607	000	57607	299
136	1	57603	000	57603	899
137	1	57608	000	57608	699
138	1	57602	000	57602	169
139	1	57602	520	57602	899
140	1	57601	000	57601	899
141	1	57602	260	57602	489
142	1	57600	800	57600	899
144	1	57607	300	57607	899
146	1	57605	010	57605	399
147	2	69057	000	69057	099
147	3	69057	250	69057	259
147	4	69057	270	69057	899
148	4	69060	000	69060	899
148	7	69083	000	69083	899
149	1	69042	000	69042	340
149	2	69042	360	69042	440
149	5	69042	570	69042	591
149	6	69042	770	69042	780
149	7	69042	820	69043	899
149	10	69046	000	69046	754
149	11	69048	320	69048	370
149	12	69048	400	69048	840
150	1	69010	270	69010	280
150	2	69010	300	69010	450
150	3	69010	480	69010	550
150	4	69010	580	69010	580
151	2	69089	000	69089	999
152	1	69073	020	69073	091
152	2	69073	290	69073	331
152	3	69073	370	69073	381
152	4	69073	410	69073	429
152	5	69073	440	69073	441
152	6	69073	450	69073	450
152	7	69073	490	69073	510
152	8	69073	550	69073	551
152	9	69073	590	69073	591
152	11	69073	640	69073	651
152	12	69073	690	69073	820
152	13	69073	830	69073	831
153	1	69065	000	69065	390
154	1	69005	000	69005	460
154	2	69010	000	69010	260
154	3	69010	290	69010	290
154	4	69010	460	69010	470
154	5	69010	560	69010	570
154	6	69020	010	69020	039
154	7	69020	041	69020	089
154	8	69020	100	69020	140
154	9	69020	150	69020	170
154	10	69020	220	69020	362
154	12	69020	540	69020	629
154	14	69020	640	69020	660
154	15	69020	671	69020	760
154	16	69025	000	69025	046
154	17	69025	070	69025	070
154	18	69025	090	69025	140
154	19	69025	190	69025	190
154	20	69025	280	69025	286
154	21	69025	410	69025	420
155	1	69050	001	69050	001
155	2	69050	010	69050	029
155	3	69050	040	69050	151
155	4	69050	570	69050	591
155	5	69050	740	69050	750
155	6	69050	593	69050	640
156	1	69090	000	69090	630
156	18	69090	640	69090	640
156	19	69090	650	69090	650
156	20	69090	660	69090	660
156	21	69090	670	69090	899
156	22	69094	000	69095	509
156	23	69095	511	69095	519
156	24	69095	601	69095	679
156	25	69095	810	69095	810
156	26	69095	812	69096	240
156	27	69096	242	69096	699
156	28	69097	000	69097	000
156	29	69097	060	69097	170
156	30	69097	172	69097	210
156	31	69097	220	69097	220
156	32	69097	230	69097	230
156	33	69097	238	69097	238
156	34	69097	240	69097	240
156	35	69097	250	69097	250
156	36	69097	260	69097	260
156	37	69097	270	69097	270
156	38	69097	280	69097	280
156	39	69097	290	69097	290
156	40	69097	300	69097	300
156	41	69097	310	69097	310
156	42	69097	320	69097	320
156	43	69097	330	69097	330
156	44	69097	340	69097	340
156	45	69097	350	69097	350
156	46	69097	360	69097	360
156	47	69097	370	69097	370
156	48	69097	380	69097	380
156	49	69097	390	69097	390
156	50	69097	400	69097	400
156	51	69097	410	69097	410
156	52	69097	420	69097	420
156	53	69097	430	69097	430
156	54	69097	440	69097	440
156	55	69097	450	69097	450
156	56	69097	460	69097	460
156	57	69097	470	69097	470
156	58	69097	480	69097	480
156	59	69097	490	69097	490
156	60	69097	711	69097	899
157	1	69008	000	69008	499
158	1	69070	140	69070	140
158	2	69070	580	69070	810
158	3	69070	830	69070	840
158	4	69073	670	69073	670
158	5	69074	010	69074	010
158	6	69074	030	69074	130
158	7	69074	150	69074	190
158	8	69074	530	69074	539
159	1	69093	000	69093	001
159	2	69093	010	69093	051
159	3	69093	060	69093	060
159	4	69093	070	69093	073
159	5	69093	080	69093	080
159	6	69093	090	69093	090
159	7	69093	100	69093	100
159	8	69093	110	69093	111
159	9	69093	120	69093	121
159	10	69093	123	69093	123
159	11	69093	130	69093	131
159	12	69093	140	69093	140
159	13	69093	150	69093	150
159	14	69093	160	69093	161
159	15	69093	170	69093	171
159	16	69093	173	69093	173
159	17	69093	175	69093	175
159	18	69093	180	69093	180
159	19	69093	190	69093	192
159	20	69093	194	69093	399
159	21	69093	770	69093	779
160	21	69015	000	69015	899
160	22	69093	002	69093	009
160	23	69093	052	69093	059
160	24	69093	061	69093	064
160	25	69093	066	69093	069
160	26	69093	074	69093	076
160	27	69093	079	69093	079
160	28	69093	091	69093	091
160	29	69093	193	69093	193
160	30	69093	400	69093	499
160	31	69093	501	69093	539
160	32	69093	570	69093	669
160	33	69093	735	69093	740
160	34	69093	756	69093	756
161	1	69030	000	69030	071
161	2	69030	090	69030	111
161	3	69030	130	69030	130
161	4	69030	150	69030	160
161	5	69030	171	69030	201
161	6	69030	220	69030	500
161	7	69030	550	69030	565
161	8	69030	730	69030	740
161	9	69035	000	69035	030
161	10	69035	050	69036	500
162	4	69080	000	69080	841
162	5	69082	000	69082	899
163	3	69073	141	69073	189
163	4	69073	261	69073	279
163	5	69073	451	69073	459
163	6	69073	461	69073	488
163	7	69073	281	69073	282
163	8	69073	430	69073	439
163	9	69073	115	69073	129
164	1	69075	000	69075	220
164	2	69075	231	69075	231
164	3	69075	350	69075	351
164	4	69075	510	69075	699
164	10	69075	830	69075	899
165	1	69040	000	69040	750
165	2	69042	350	69042	350
165	3	69042	450	69042	561
165	4	69042	620	69042	769
165	6	69042	800	69042	819
166	1	69070	000	69070	131
166	2	69070	150	69070	570
166	3	69070	820	69070	820
166	4	69074	000	69074	000
167	1	69028	000	69028	417
167	2	69058	000	69058	110
167	3	69058	114	69058	114
167	4	69058	117	69058	118
167	5	69058	120	69058	120
167	6	69058	125	69058	260
167	7	69058	270	69058	270
167	8	69058	280	69058	283
167	9	69058	290	69058	290
167	10	69058	300	69058	380
167	11	69058	390	69058	390
167	12	69058	400	69058	472
167	13	69058	474	69058	549
167	14	69058	570	69058	570
167	15	69058	580	69058	582
167	16	69058	650	69058	744
167	17	69058	746	69058	899
168	1	69027	000	69027	000
168	2	69027	300	69027	300
168	3	69027	380	69027	459
168	4	69027	470	69027	510
168	5	69027	601	69027	690
168	6	69027	710	69027	732
168	7	69027	770	69027	770
168	8	69027	790	69027	790
169	1	69068	482	69068	482
169	2	69068	674	69068	676
169	3	69068	724	69068	724
169	4	69073	442	69073	442
169	10	69076	000	69078	999
170	2	69088	000	69088	899
170	3	69099	224	69099	224
170	6	69099	241	69099	242
170	7	69099	263	69099	263
170	8	69099	283	69099	284
170	9	69099	288	69099	288
170	10	69099	580	69099	581
170	11	69099	590	69099	590
170	12	69099	600	69099	600
170	13	69099	610	69099	610
170	14	69099	620	69099	620
170	15	69099	631	69099	631
170	16	69099	633	69099	633
170	17	69099	635	69099	639
170	18	69099	643	69099	643
170	19	69099	646	69099	646
170	20	69099	648	69099	649
170	21	69099	651	69099	651
170	22	69099	664	69099	670
170	23	69099	231	69099	239
170	24	69099	850	69099	999
170	25	69006	800	69006	999
171	2	69037	590	69038	899
172	1	69075	230	69075	230
172	2	69075	240	69075	344
172	3	69075	352	69075	500
172	4	69075	700	69075	829
173	13	69092	450	69092	899
173	14	69093	065	69093	065
173	15	69093	077	69093	078
173	16	69093	081	69093	089
173	17	69093	093	69093	099
173	18	69093	101	69093	109
173	19	69093	112	69093	119
173	20	69093	122	69093	122
173	21	69093	124	69093	129
173	22	69093	132	69093	139
173	23	69093	141	69093	149
173	24	69093	151	69093	159
173	25	69093	162	69093	169
173	26	69093	172	69093	172
173	27	69093	174	69093	174
173	28	69093	176	69093	179
173	31	69093	500	69093	500
173	32	69093	540	69093	569
173	33	69093	670	69093	734
173	34	69093	741	69093	755
173	35	69093	757	69093	769
173	36	69093	780	69093	899
173	37	69093	181	69093	189
173	38	69017	126	69017	159
173	39	69017	168	69017	169
173	40	69017	171	69017	189
174	2	69074	141	69074	141
174	3	69074	500	69074	500
174	4	69074	550	69074	620
174	5	69074	660	69074	840
175	1	69053	000	69053	050
175	2	69053	080	69053	180
175	5	69053	680	69053	770
175	6	69053	380	69053	619
175	7	69053	621	69053	669
175	8	69057	100	69057	249
175	9	69057	260	69057	269
176	1	69037	310	69037	589
177	1	69039	000	69039	810
178	1	69054	000	69055	899
178	2	69050	030	69050	030
178	3	69050	160	69050	560
178	4	69050	650	69050	730
178	5	69050	592	69050	592
178	6	69058	111	69058	113
178	7	69058	115	69058	116
178	8	69058	119	69058	119
178	9	69058	121	69058	124
179	1	69048	000	69048	311
179	3	69048	380	69048	399
179	4	69049	000	69049	169
179	5	69049	621	69049	621
179	6	69049	623	69049	623
179	7	69049	625	69049	639
180	2	69063	000	69063	010
180	3	69063	300	69063	515
180	4	69063	520	69063	690
180	5	69063	710	69063	710
180	6	69067	000	69067	831
180	8	69079	300	69079	320
180	9	69079	350	69079	399
180	10	69079	420	69079	421
181	7	69044	000	69045	849
182	1	69037	000	69037	309
183	1	69020	000	69020	000
183	2	69020	040	69020	040
183	3	69020	090	69020	090
183	4	69020	141	69020	141
183	5	69020	180	69020	210
183	7	69020	370	69020	530
183	9	69020	630	69020	630
183	10	69020	670	69020	670
184	1	69025	050	69025	069
184	2	69025	080	69025	080
184	3	69025	150	69025	180
184	4	69025	200	69025	270
184	5	69025	290	69025	400
184	6	69025	430	69025	450
185	1	69009	000	69009	899
186	1	69068	000	69068	480
186	2	69068	490	69068	670
186	3	69068	680	69068	721
186	4	69068	730	69068	760
187	1	69047	000	69047	840
187	2	69049	170	69049	620
187	3	69049	622	69049	622
187	4	69049	624	69049	624
187	5	69049	640	69049	699
188	3	69059	000	69059	660
188	4	69059	740	69059	899
188	5	69017	081	69017	125
188	6	69017	160	69017	167
188	7	69017	170	69017	170
188	8	69017	190	69017	310
189	2	69074	350	69074	490
189	4	69074	540	69074	540
189	5	69074	630	69074	650
189	6	69074	501	69074	529
189	7	69074	011	69074	029
190	1	69036	510	69036	899
191	1	69029	000	69029	610
192	1	69063	020	69063	290
192	3	69063	700	69063	700
192	5	69079	330	69079	340
192	6	69079	400	69079	410
192	7	69079	430	69079	461
192	8	69079	470	69079	490
192	9	69079	000	69079	299
192	10	69063	516	69063	519
193	1	69050	000	69050	000
193	2	69050	003	69050	005
193	3	69053	060	69053	070
193	4	69053	190	69053	370
193	5	69053	670	69053	670
193	6	69053	620	69053	620
194	1	69030	080	69030	080
194	2	69030	120	69030	121
194	3	69030	131	69030	140
194	4	69030	170	69030	170
194	5	69030	210	69030	211
194	6	69030	680	69030	680
194	7	69033	000	69033	169
194	8	69033	180	69033	699
194	9	69033	730	69033	790
194	10	69033	801	69033	841
194	11	69030	701	69030	701
195	3	69085	000	69086	115
195	5	69086	125	69086	125
195	7	69086	130	69086	133
195	8	69086	140	69086	399
195	9	69086	537	69086	544
195	10	69086	560	69086	561
195	11	69086	563	69086	599
195	12	69086	620	69086	639
195	13	69086	120	69086	121
196	1	69073	000	69073	010
196	2	69073	100	69073	114
196	3	69073	130	69073	140
196	5	69073	190	69073	260
196	6	69073	280	69073	280
196	7	69073	340	69073	350
196	8	69073	390	69073	400
196	10	69073	460	69073	460
196	11	69073	520	69073	530
196	12	69073	570	69073	580
196	13	69073	600	69073	630
196	15	69073	660	69073	661
196	16	69073	680	69073	682
196	17	69073	821	69073	821
196	18	69074	200	69074	340
196	21	69073	283	69073	289
197	1	69027	001	69027	290
197	2	69027	301	69027	370
197	3	69027	460	69027	460
197	4	69027	520	69027	600
197	5	69027	700	69027	700
197	6	69027	760	69027	760
197	7	69027	780	69027	781
198	1	69087	010	69087	899
199	1	69041	000	69041	849
199	2	69021	000	69021	999
199	3	69022	001	69022	289
200	1	69072	000	69072	299
201	1	69030	501	69030	541
201	2	69030	570	69030	679
201	3	69030	750	69030	750
201	4	69033	170	69033	170
201	5	69033	700	69033	720
201	6	69033	800	69033	800
201	7	69035	040	69035	040
201	8	69030	681	69030	700
202	1	69084	000	69084	899
203	1	69151	000	69151	409
204	1	69152	420	69152	529
205	1	69153	360	69153	409
207	1	69153	000	69153	219
208	4	69151	620	69151	699
209	1	69153	220	69153	289
210	2	69151	520	69151	549
212	3	69151	550	69151	619
213	1	69153	410	69153	469
214	5	68906	530	68906	699
215	1	68902	000	68902	030
215	5	68902	630	68902	679
215	8	68902	850	68902	850
216	4	68902	730	68902	760
216	16	68902	860	68902	899
217	1	68900	001	68900	899
218	1	68904	326	68904	399
218	2	68904	426	68904	589
220	1	68909	000	68909	100
221	1	68903	180	68903	409
221	2	68903	420	68903	480
222	6	68908	110	68908	130
223	4	68908	150	68908	220
224	8	68902	680	68902	689
224	14	68902	210	68902	610
225	13	68901	580	68901	899
226	1	68908	230	68908	390
227	13	68905	500	68905	899
228	10	68901	370	68901	570
229	10	68901	250	68901	369
230	1	68908	400	68908	580
231	11	68901	000	68901	150
232	4	48030	000	48030	650
233	2	48070	100	48071	999
234	1	48090	000	48090	999
235	1	48005	000	48010	410
236	3	48051	000	48051	999
237	1	48080	030	48080	100
238	4	48030	660	48031	999
239	2	48040	000	48040	999
240	1	48020	000	48020	999
241	1	48060	120	48060	540
243	1	48070	000	48070	090
244	1	48050	000	48050	999
245	1	48010	420	48011	999
246	2	48060	000	48060	119
247	1	48080	110	48080	999
249	1	47804	500	47804	589
250	1	47800	000	47800	249
251	1	47802	660	47802	779
253	1	47810	000	47810	449
255	1	47802	340	47802	419
256	1	47802	120	47802	339
259	1	47806	000	47806	099
260	1	47800	500	47800	629
261	1	47802	000	47802	119
262	1	47800	390	47800	499
263	1	47810	810	47810	899
264	1	47813	460	47813	609
265	2	47801	000	47801	399
266	1	47800	250	47800	349
267	1	47813	420	47813	459
268	1	47800	630	47800	689
269	2	47806	100	47806	139
270	1	47813	000	47813	189
271	1	47810	760	47810	809
273	1	42807	091	42807	091
273	2	42807	330	42807	330
273	3	42807	390	42807	500
273	4	42808	010	42808	010
273	5	42808	060	42808	120
274	1	42800	680	42800	680
274	2	42803	000	42803	000
274	3	42803	270	42803	300
274	4	42805	000	42805	000
274	5	42805	010	42805	010
274	6	42806	010	42806	030
275	1	42800	220	42800	260
275	2	42809	000	42809	050
275	3	42809	060	42809	090
276	1	42806	040	42806	100
276	2	42806	110	42806	210
276	3	42807	000	42807	080
277	1	42800	005	42800	210
277	2	42800	400	42800	530
279	1	42800	540	42800	670
280	1	42808	300	42808	430
281	1	42807	220	42807	320
281	2	42807	510	42807	730
282	1	42808	020	42808	050
282	2	42809	051	42809	051
282	3	42809	100	42809	320
283	1	42803	010	42803	260
284	1	42804	000	42804	630
285	1	42807	171	42807	171
285	2	42807	740	42807	750
285	3	42808	000	42808	000
285	4	42808	130	42808	220
286	1	42801	000	42801	080
286	2	42802	000	42802	020
286	3	42802	500	42802	530
287	1	42806	101	42806	101
287	2	42806	220	42806	390
288	1	42802	580	42802	590
289	1	42807	380	42807	380
289	2	42808	230	42808	290
290	1	42801	220	42801	600
291	1	42809	330	42809	360
291	2	42809	370	42809	420
292	1	42809	361	42809	361
292	2	42809	430	42809	590
293	1	42804	780	42804	790
294	1	42805	002	42805	002
294	2	42805	340	42805	570
295	1	42805	001	42805	001
295	2	42805	020	42805	330
296	1	42804	640	42804	770
297	1	42802	030	42802	490
299	1	42810	000	42810	500
300	1	42801	090	42801	210
301	1	42802	560	42802	570
302	1	42806	400	42806	420
302	2	42807	090	42807	090
302	3	42807	100	42807	170
302	4	42807	180	42807	210
304	1	42802	540	42802	550
305	1	43825	141	43825	220
306	1	43805	000	43805	490
306	2	43810	000	43810	130
307	1	43805	500	43805	999
307	2	43825	230	43825	450
308	1	43810	140	43810	260
309	1	43815	090	43815	450
310	1	43810	261	43810	420
311	2	43820	010	43820	240
311	3	43825	010	43825	140
312	3	43820	250	43820	500
313	1	43815	010	43815	080
314	2	43806	000	43806	150
315	2	43806	200	43806	350
316	3	45825	200	45825	400
317	1	45821	041	45821	300
318	1	45820	002	45820	570
319	2	45821	381	45821	720
320	2	45823	010	45823	080
321	1	45822	270	45822	540
322	4	45823	340	45823	570
323	2	45825	410	45825	560
324	2	45824	330	45824	470
325	1	45824	000	45824	320
325	4	45825	000	45825	191
326	1	45823	090	45823	330
327	4	45825	570	45825	650
328	2	45822	000	45822	260
329	3	45823	580	45823	750
330	1	45820	580	45820	610
331	1	45826	000	45826	030
334	4	45820	620	45820	760
336	1	44020	000	44020	899
338	1	44088	000	44089	899
340	1	44051	000	44051	899
341	1	44032	000	44035	899
342	1	44076	000	44076	599
343	1	44052	000	44052	189
345	1	44001	000	44002	899
346	1	44010	000	44013	899
347	1	44004	000	44004	269
348	1	44053	000	44053	899
349	1	44065	000	44068	899
357	1	44004	270	44004	899
358	1	44024	000	44024	899
363	1	44052	190	44052	899
364	1	44056	000	44057	899
366	1	44005	000	44006	899
369	1	44036	000	44036	899
370	1	44003	400	44003	899
371	1	44031	000	44031	899
372	1	44059	000	44062	899
373	1	44044	000	44046	899
378	1	44054	000	44055	899
380	1	44082	000	44083	899
392	1	44007	000	44007	899
394	1	44075	000	44075	899
395	1	44076	600	44076	899
396	1	44050	000	44050	899
397	1	44023	000	44023	899
398	1	44077	000	44078	899
399	1	44071	000	44072	899
400	1	44003	000	44003	399
401	1	44085	000	44086	899
403	1	44021	000	44021	899
404	1	44008	000	44009	899
406	1	44090	000	44092	899
408	1	44025	000	44030	899
409	1	44079	000	44080	699
410	1	44094	000	44094	899
417	4	45652	300	45652	469
418	2	45658	000	45658	229
422	1	45658	530	45658	629
424	3	45652	470	45652	599
426	9	45653	000	45653	659
429	1	45652	000	45652	299
430	1	45650	000	45650	829
431	4	45658	630	45658	849
433	1	45658	274	45658	499
435	1	45655	000	45655	069
436	1	45658	230	45658	272
437	1	45651	310	45651	899
441	1	45656	000	45656	299
444	1	45654	000	45654	699
449	4	45655	070	45655	199
450	3	45653	750	45653	849
455	1	45651	000	45651	309
456	1	45657	000	45657	599
460	1	45658	850	45658	899
461	1	45604	800	45604	809
463	2	45603	230	45603	370
464	1	45603	620	45603	649
465	3	45605	600	45605	699
466	2	45603	371	45603	619
467	6	45604	145	45604	380
468	1	45603	180	45603	229
469	2	45600	001	45600	329
470	1	45600	760	45600	779
471	3	45605	150	45605	349
472	3	45606	800	45606	899
473	5	45600	670	45600	759
474	2	45604	000	45604	144
475	1	45613	200	45613	399
476	1	45606	590	45606	699
477	2	45605	350	45605	459
478	2	45608	400	45608	799
481	1	45608	800	45608	899
482	1	45605	460	45605	599
483	2	45604	550	45604	650
485	2	45601	000	45601	299
486	1	45600	330	45600	599
487	1	45606	700	45606	799
488	1	45604	480	45604	549
490	1	45604	381	45604	479
491	1	45613	450	45613	549
492	1	45611	000	45611	499
495	1	45602	470	45602	589
497	1	45601	300	45601	399
499	1	45604	651	45604	669
500	3	45604	670	45604	799
501	1	45610	000	45610	199
502	1	45604	810	45604	899
503	4	45606	340	45606	589
508	1	45603	650	45603	849
509	1	45602	000	45602	469
510	2	45607	000	45607	399
511	1	45605	000	45605	149
513	2	45606	100	45606	339
515	2	45608	000	45608	179
516	1	45611	770	45611	899
517	1	45611	700	45611	769
518	1	45607	480	45607	599
519	1	45608	180	45608	399
521	1	45606	000	45606	099
522	1	45202	500	45202	640
523	2	45203	700	45203	799
524	1	45206	640	45206	720
525	1	45202	650	45202	730
528	1	45202	450	45202	490
529	3	45203	160	45203	220
529	4	45203	550	45203	660
530	2	45201	331	45201	460
531	1	45200	000	45200	540
531	4	45202	330	45202	440
531	5	45203	010	45203	150
532	1	45205	530	45205	660
533	1	45205	450	45205	520
535	2	45201	470	45201	680
536	1	45201	690	45201	820
547	3	45204	140	45205	320
547	4	45206	000	45206	590
548	4	45200	550	45201	330
548	5	45202	000	45202	290
550	1	45208	030	45208	170
551	1	45208	180	45208	450
552	1	45207	000	45208	020
553	2	45208	500	45208	650
557	1	45204	010	45204	130
559	1	45203	230	45203	390
568	1	48907	620	48907	620
569	1	48904	580	48904	680
570	1	48907	030	48907	080
571	1	48900	370	48900	440
571	2	48907	010	48907	020
572	1	48901	090	48901	090
573	1	48905	350	48905	390
574	2	48907	090	48907	150
575	1	48905	400	48905	470
576	1	48903	400	48904	390
576	2	48905	000	48905	160
577	1	48904	400	48904	530
577	2	48905	170	48905	260
578	1	48902	300	48902	440
579	1	48909	000	48909	800
580	1	48907	151	48907	229
580	2	48907	730	48907	799
581	1	48907	630	48907	720
582	1	48905	540	48905	610
583	1	48907	800	48907	899
584	1	48902	100	48902	160
585	1	48908	000	48908	390
586	1	48900	180	48900	360
587	1	48905	750	48905	750
588	1	48905	480	48905	530
589	1	48909	810	48909	810
590	1	48902	170	48902	250
591	1	48904	540	48904	570
592	1	48902	260	48902	290
593	1	48900	500	48900	600
593	2	48901	070	48901	070
594	1	48901	340	48901	520
595	1	48900	010	48900	160
595	2	48901	000	48901	060
596	1	48901	080	48901	080
597	1	48901	100	48901	330
599	1	48902	000	48902	090
599	2	48903	000	48903	260
600	1	48905	620	48905	740
601	1	48906	000	48906	349
602	1	48907	230	48907	520
603	1	48907	530	48907	600
604	1	48605	200	48605	319
605	1	48605	130	48605	199
606	1	48605	320	48605	449
607	1	48605	450	48605	719
608	1	48601	160	48602	609
609	1	48604	500	48604	599
610	5	48607	000	48607	309
611	1	48603	280	48603	479
613	1	48604	000	48604	279
614	2	48607	310	48607	429
615	1	48605	000	48605	099
616	3	48603	000	48603	269
617	1	48609	000	48609	109
618	2	48609	110	48609	349
619	1	48611	000	48611	399
620	1	48608	570	48608	619
623	14	40290	000	40290	999
625	1	40460	000	40460	999
626	9	41310	000	41311	999
628	5	41615	000	41615	999
629	1	40349	000	40349	999
630	1	41889	000	41900	999
632	1	41211	000	41211	999
633	2	41750	000	41750	999
634	1	41204	000	41204	999
638	1	40025	000	40025	999
639	11	40300	750	40301	270
640	1	40130	000	40140	999
642	1	41410	000	41410	999
643	1	41195	000	41197	999
644	1	40070	020	40070	999
645	2	40024	000	40024	999
647	10	40414	000	40414	999
650	2	41705	000	41710	999
653	1	40415	000	40415	999
655	30	40285	000	40287	999
656	2	41150	000	41150	999
657	5	41181	000	41181	999
658	1	40320	000	40323	150
659	5	41330	000	41345	999
661	4	41227	000	41228	999
662	14	40410	000	40411	999
663	3	41820	000	41820	999
664	3	40440	000	40441	999
666	1	40275	000	40276	999
667	13	41270	000	41275	999
668	1	40080	000	40080	001
668	2	40080	010	40080	121
670	1	41260	000	41261	999
671	11	40296	000	40296	999
672	1	40110	000	40110	999
673	1	40393	000	40398	999
674	1	41505	000	41507	999
675	1	41320	000	41325	999
677	1	41400	000	41405	000
679	1	40020	000	40020	999
680	1	41745	000	41745	016
681	12	40157	000	40157	999
682	7	40313	000	40315	350
682	10	40317	590	40318	200
683	1	40010	000	40015	999
684	1	40250	000	40254	999
685	3	41760	000	41760	999
686	10	40750	000	40770	999
687	14	40365	000	40366	999
688	1	40060	000	40060	999
690	2	41315	000	41316	999
691	1	40240	000	40240	079
691	2	40240	081	40245	999
692	2	40220	000	40225	600
693	1	41200	000	41202	999
694	1	40710	000	40710	470
696	1	40730	000	40731	999
698	1	40350	000	40360	999
699	5	40210	245	40215	999
699	29	40230	000	40231	999
703	1	40100	000	40105	999
705	1	40150	000	40150	999
706	4	41230	000	41230	250
709	2	40323	170	40323	999
709	7	40330	000	40330	999
709	8	40340	400	40340	999
711	1	40715	000	40715	300
712	1	41720	000	41720	999
713	4	40713	000	40713	999
713	7	40715	560	40715	999
714	2	41815	000	41815	999
714	4	41825	000	41825	020
716	1	41610	000	41610	999
716	2	41620	000	41640	999
717	5	41613	000	41613	999
720	1	40155	000	40155	999
721	1	41230	300	41230	550
724	1	41370	000	41370	999
725	8	40342	000	40342	999
729	11	40325	000	40327	999
729	27	40367	000	40375	999
730	2	40470	000	40483	999
731	2	40260	200	40260	999
732	12	40302	000	40302	999
732	13	40300	500	40300	740
735	2	41280	000	41285	999
736	11	40445	000	40445	999
737	10	40433	000	40436	999
739	1	41219	000	41225	999
740	6	40255	000	40260	195
741	1	40425	000	40425	999
742	1	41490	000	41490	999
743	2	40040	000	40040	520
743	3	40050	000	40050	003
743	5	40050	300	40055	999
743	6	40240	080	40240	080
744	95	41905	000	41906	999
745	11	41611	000	41611	999
746	1	41388	000	41388	999
747	2	40170	000	40170	999
748	3	41308	000	41309	999
749	1	41730	100	41730	500
750	8	40800	000	40800	150
750	9	40800	400	40840	999
752	1	41680	000	41681	999
753	1	41235	000	41247	270
754	8	40310	000	40310	999
754	11	40315	360	40315	999
755	1	41515	000	41515	999
756	2	40026	000	40026	999
757	1	40720	000	40720	570
757	4	40725	570	40729	999
757	8	40732	000	40740	999
758	1	41100	000	41130	999
759	5	40335	000	40340	390
760	4	41650	000	41651	999
762	8	41290	000	41297	999
764	7	41740	000	41741	999
765	8	41830	000	41830	999
765	9	41800	700	41810	999
766	3	41612	000	41612	499
767	13	40710	500	40710	999
767	14	40717	000	40718	999
768	3	40080	130	40080	260
769	1	41233	000	41233	999
770	5	41603	000	41603	999
771	4	40720	580	40725	560
773	5	40300	000	40300	490
775	1	40420	000	40421	999
776	1	40715	310	40715	559
777	12	41940	000	41950	999
778	12	40444	000	40444	999
779	1	41180	000	41180	999
781	32	41915	001	41927	999
784	1	40301	280	40301	520
785	1	40390	000	40392	999
786	1	41500	000	41500	999
786	2	41510	000	41510	999
788	3	41185	000	41190	999
790	5	41250	000	41253	999
792	1	40800	160	40800	390
794	1	40040	525	40045	999
796	2	41385	000	41387	999
799	1	41600	000	41600	999
800	3	41770	000	41770	999
801	1	41213	000	41217	999
803	1	41205	000	41210	999
805	1	40050	050	40050	290
806	2	41745	017	41745	999
807	5	40450	000	40454	999
811	1	41300	000	41305	999
814	3	41390	000	41390	999
815	3	40270	000	40270	999
817	1	40430	000	40431	999
818	1	40080	002	40080	005
818	4	40081	000	40081	999
819	1	44572	610	44572	770
820	1	44572	410	44572	600
821	2	44574	450	44574	600
822	1	44571	000	44572	120
823	1	44572	130	44572	230
824	1	44573	000	44573	130
825	1	44573	630	44573	660
826	3	44570	650	44570	760
827	3	44574	270	44574	350
828	2	44570	500	44570	600
829	1	44573	670	44573	790
830	1	44573	140	44573	520
831	1	44573	560	44573	620
832	4	44570	300	44570	490
833	1	44574	060	44574	260
835	1	45993	320	45993	379
836	4	45990	130	45990	329
838	2	45985	040	45985	089
839	1	45989	040	45989	149
840	3	45985	090	45985	269
841	1	45987	260	45987	459
844	1	45990	710	45990	829
846	1	45987	210	45987	259
847	1	45994	330	45994	439
848	1	45993	380	45993	619
849	4	45990	000	45990	129
850	1	45988	460	45988	539
851	1	45989	220	45989	349
852	1	45994	250	45994	329
853	1	45987	050	45987	079
854	2	45987	080	45987	209
855	2	45985	270	45985	389
856	1	45990	350	45990	399
857	2	45988	050	45988	139
858	1	45992	000	45992	209
860	2	45993	120	45993	279
861	1	45985	001	45985	039
863	1	45990	830	45990	899
864	1	45990	400	45990	599
865	2	45988	320	45988	359
866	2	45993	000	45993	119
867	1	45990	660	45990	679
869	2	45987	000	45987	049
875	5	45005	000	45005	899
878	1	45026	000	45027	899
881	3	45051	000	45051	899
883	2	45028	000	45029	899
884	3	45000	001	45000	899
886	1	45052	000	45053	899
890	2	45003	000	45003	899
900	2	45075	000	45075	899
907	1	45023	000	45023	899
915	5	45002	000	45002	899
917	2	45065	000	45065	899
920	3	45020	000	45020	899
930	1	45031	000	45032	899
933	1	45077	000	45079	899
936	1	61605	000	61605	179
937	2	61654	000	61655	899
937	3	61652	000	61652	079
937	4	61652	120	61652	139
938	1	61656	000	61656	899
939	1	61600	450	61600	539
940	1	61625	000	61625	739
941	1	61610	000	61610	739
942	1	61615	000	61615	459
943	1	61600	000	61600	209
944	4	61605	180	61605	389
945	1	61601	600	61601	899
946	1	61616	000	61616	899
947	2	61600	540	61600	899
947	3	61600	340	61600	449
948	1	61620	000	61620	540
948	2	61624	000	61624	899
948	3	61621	120	61621	169
949	3	61602	010	61602	899
950	2	61652	080	61652	119
950	3	61652	140	61652	899
951	1	61623	000	61623	899
952	2	61658	000	61659	899
953	1	61600	210	61600	339
954	1	61626	000	61626	899
955	1	61601	000	61601	599
956	2	61645	000	61645	899
957	1	61642	000	61642	260
958	1	61650	000	61650	010
958	2	61650	030	61650	030
958	3	61650	050	61650	050
958	4	61650	100	61650	130
958	5	61650	160	61650	170
958	6	61650	190	61650	190
958	7	61650	210	61650	310
958	8	6165