<?php

namespace Tests\Unit;

use Tests\TestCase;

class HelpersTest extends TestCase
{
    public function test_format_string_no_markup()
    {
        $this->assertEquals(format_string("teste"), "teste");
    }

    public function test_format_string_html_tags()
    {
        $this->assertEquals(format_string("<b>teste</b>"), "teste");
    }

    public function test_format_string_html_tags_entities()
    {
        $this->assertEquals(format_string("<b>teste&nbsp;</b>"), "teste");
    }

    public function test_format_string_br_tag_replaced_by_space()
    {
        $this->assertEquals(format_string("<b>primeira<br>segunda</b>"), "primeira segunda");
    }
}
