<?php

namespace Tests\Unit;

use App\Enums\TipoDesligamentoSindicatoEnum;
use App\Models\Matricula;
use App\Models\MotivoFiliacao;
use App\Models\Servidor;
use App\Services\AfiliaSindicatoService;
use App\Services\DesfiliaSindicatoService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase as TestCase;

class AfiliaSindicatoServiceTest extends TestCase
{
    use RefreshDatabase;

    public function test_afilia()
    {
        $servidor = factory(Servidor::class)->create();
        $service = new AfiliaSindicatoService($servidor, MotivoFiliacao::find(1), today(), null);

        $matricula = $service->afilia();
        $this->assertInstanceOf(Matricula::class, $matricula);
        $this->assertTrue($matricula->wasRecentlyCreated);
    }
}
