<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/servidores/registros/create-edit.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.index')); ?>">Servidor</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.edit', ['servidor' => $servidor])); ?>"><?php echo e($servidor->nome); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page">Movimentações</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Movimentações
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Descrição</th>
                            <th>Informação</th>
                            <th>Data</th>
                            <th>Usuário</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $movimentacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movimentacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($movimentacao->descricao); ?></td>
                            <td>
                                <?php if($movimentacao->evento->isEdicao()): ?>
                                <?php $__currentLoopData = $movimentacao->payload; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campo => $valor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($campo); ?>: <?php echo e($valor); ?>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($movimentacao->created_at->format('d/m/Y H:i:s')); ?></td>
                            <td><?php echo e($movimentacao->user->name); ?></td>
                            <td>
                                <?php $__env->startComponent('components.button', [
                                'route' => 'admin.servidores.movimentacoes.show',
                                'routeParams' => ['servidor' => $servidor, 'movimentacao' => $movimentacao],
                                'class' => 'btn-primary',
                                'label' => 'Exibir',
                                'icon' => 'eye'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($movimentacoes->links()); ?>


                <hr>
                <?php $__env->startComponent('components.button', [
                'route' => 'admin.servidores.edit',
                'routeParams' => ['servidor' => $servidor],
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/servidores/movimentacoes/index.blade.php ENDPATH**/ ?>