<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/admin/configuracoes.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Configuração</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Configuração
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>
                <div class="alert alert-info" role="alert">
                    Apenas usuários com perfil de super-usuário podem incluir e excluir configurações.
                </div>

                <?php if(auth()->check() && auth()->user()->hasRole('superuser')): ?>
                <?php $__env->startComponent('components.button', [
                'route' => 'admin.configuracoes.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>
                <?php endif; ?>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Categoria</th>
                            <th>Nome</th>
                            <th>Valor</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $configuracoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $configuracao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($configuracao->categoria->getValue()); ?></td>
                            <td><?php echo e($configuracao->nome); ?></td>
                            <td><?php echo e($configuracao->valor); ?></td>
                            <td>
                                <?php $__env->startComponent('components.button', [
                                'route' => 'admin.configuracoes.edit',
                                'routeParams' => ['configuracao' => $configuracao],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                                <?php if(auth()->check() && auth()->user()->hasRole('superuser')): ?>
                                <?php $__env->startComponent('components.button', [
                                'class' => 'btn-danger btn-excluir-configuracao',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.configuracoes.destroy',
                                'routeParams' => ['configuracao' => $configuracao],
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-configuracao" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-configuracao">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir a configuração?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/configuracoes/index.blade.php ENDPATH**/ ?>