<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(config('app.name')); ?> - Cancelamento seguro</title>
    <link href="<?php echo e(asset('vendors/bootstrap/dist/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressao.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressos/formulario-cancelamento-osan-dependente.css')); ?>">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        <?php $__env->startComponent('components.impressos.cabecalho'); ?><?php echo $__env->renderComponent(); ?>

        <h1>DESLIGAMENTO DE DEPENDENTES<br>CONVÊNIO OSAN/SINDSERV</h1>

        <p>
            Eu <?php echo e($servidor->nome); ?>, registro funcional nº <?php echo e($registro->numero); ?>, regime <?php echo e($registro->regime); ?> autorizo o(a) <?php echo e($empresa); ?>,
            a baixa no valor de R$ __________, (___________________________________________________________________), a partir do mês ________________,
            que refere-se ao <b>desligamento</b> do dependente abaixo relacionado, no convênio OSAN/SINDSERV.
        </p>

        <table class="col-12">
            <thead>
                <tr>
                    <th>NOME DO DEPENDENTE</th>
                    <th>PARENTESCO</th>
                    <th>VALOR (R$)</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e($dependente->nome); ?></td>
                    <td><?php echo e($dependente->grau_parentesco->getValue()); ?></td>
                    <td>&nbsp;</td>
                </tr>
            </tbody>
        </table>

        <div class="data-recebimento">Santos, <?php echo e(today()->format('d/m/Y')); ?></div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Associado
            </div>

            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Diretor
            </div>
        </div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura Funcionário SINDSERV
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/impressos/formulario-cancelamento-osan-dependente.blade.php ENDPATH**/ ?>