<?php $__env->startPush('css'); ?>
<link href="<?php echo e(asset('css/admin/servidores-create-edit.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/afilia.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.index')); ?>">Servidores</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.edit', ['servidor' => $servidor])); ?>"><?php echo e($servidor->nome); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page">Afiliar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Afiliar servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="<?php echo e(route('admin.servidores.afilia', ['servidor' => $servidor])); ?>" method="post">
                    <?php echo csrf_field(); ?>

                    <?php $__env->startComponent('components.alerts'); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <div class="form-row">
                        <?php if($matriculaDesligadaTemporariamente): ?>
                        <div class="form-group col-2">
                            <label for="matricula">Matrícula</label>
                            <input type="text" name="matricula" maxlength="100" readonly class="form-control-plaintext" value="<?php echo e($matriculaDesligadaTemporariamente->id); ?>">
                        </div>
                        <?php endif; ?>
                        <?php if(!$matriculaDesligadaTemporariamente): ?>
                        <div class="form-group col-4">
                            <label for="motivo_filiacao">Motivo *</label>
                            <select autofocus required class="form-control" name="motivo_filiacao" id="motivo_filiacao">
                                <?php $__currentLoopData = $motivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $motivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($motivo->id); ?>" <?php if(old('motivo_filiacao')==$motivo->id): ?> selected <?php endif; ?>><?php echo e($motivo->descricao); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-4" id="div-motivo-outros">
                            <label for="motivo_filiacao_outros">Detalhe do motivo *</label>
                            <input type="text" maxlength="100" name="motivo_filiacao_outros" class="form-control <?php $__errorArgs = ['motivo_filiacao_outros'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('motivo_filiacao_outros')); ?>">
                        </div>
                        <div class="form-group col-2" id="div-data-filiacao">
                            <label for="data_filiacao">Data de admissão *</label>
                            <input type="text" required name="data_filiacao" data-mask="00/00/0000" data-mask-clearifnotmatch="true" class="form-control <?php $__errorArgs = ['data_filiacao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('data_filiacao', today()->format('d/m/Y'))); ?>">
                        </div>
                        <?php endif; ?>
                    </div>

                    <div class="clearfix"></div>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'save',
                    'label' => 'Afiliar',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </form>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/servidores/afilia.blade.php ENDPATH**/ ?>