<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/funcionarios/create-edit.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route($routes['dependido']['index']['route'])); ?>"><?php echo e($dependido); ?></a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route($routes['dependido']['edit']['route'], $routes['dependido']['edit']['params'])); ?>"><?php echo e($routes['dependido']['nome']); ?></a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route($routes['dependente']['index']['route'], $routes['dependente']['index']['params'])); ?>">Dependentes</a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e($dependente->nome); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar dependente
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="<?php echo e(route($routes['dependente']['update']['route'], $routes['dependente']['update']['params'])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <?php $__env->startComponent('components.alerts'); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="nome">Nome *</label>
                            <input type="text" required autofocus name="nome" maxlength="150" class="form-control <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nome') ?? $dependente->nome); ?>">
                        </div>
                        <div class="form-group col-3">
                            <label for="grau_parentesco">Grau de parentesco *</label>
                            <select name="grau_parentesco" required class="form-control <?php $__errorArgs = ['grau_parentesco'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <?php $__currentLoopData = $graus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grau): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($grau->getIndex()); ?>" <?php echo e($dependente->grau_parentesco->isEqual($grau) ? 'selected' : ''); ?>><?php echo e($grau->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="data_nascimento">Data de nascimento *</label>
                            <input type="text" required name="data_nascimento" class="data form-control data_nascimento <?php $__errorArgs = ['data_nascimento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('data_nascimento') ?? $dependente->data_nascimento->format('d/m/Y')); ?>">
                        </div>
                        <div class="form-group col-3">
                            <label for="sexo">Sexo *</label>
                            <select name="sexo" required class="form-control <?php $__errorArgs = ['sexo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <?php $__currentLoopData = $sexos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sexo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($sexo->getIndex()); ?>" <?php echo e($dependente->sexo->isEqual($sexo) ? 'selected' : ''); ?>><?php echo e($sexo->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="data_admissao">Data de admissão *</label>
                            <input type="text" required name="data_admissao" class="data form-control <?php $__errorArgs = ['data_admissao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('data_admissao') ?? $dependente->data_admissao->format('d/m/Y')); ?>">
                        </div>
                        <div class="form-group col-2">
                            <label for="ativo">Ativo *</label>
                            <select name="ativo" required class="form-control <?php $__errorArgs = ['ativo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="1" <?php echo e($dependente->ativo ? 'selected' : ''); ?>>SIM</option>
                                <option value="0" <?php echo e(! $dependente->ativo ? 'selected' : ''); ?>>NÃO</option>
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="especial">Especial *</label>
                            <select name="especial" required class="form-control <?php $__errorArgs = ['especial'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="0" <?php echo e(! $dependente->especial ? 'selected' : ''); ?>>NÃO</option>
                                <option value="1" <?php echo e($dependente->especial ? 'selected' : ''); ?>>SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="falecido">Falecido *</label>
                            <select name="falecido" required class="form-control <?php $__errorArgs = ['falecido'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="0" <?php echo e(! $dependente->falecido ? 'selected' : ''); ?>>NÃO</option>
                                <option value="1" <?php echo e($dependente->falecido ? 'selected' : ''); ?>>SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea type="text" name="observacoes" maxlength="1000" rows="5" class="form-control <?php $__errorArgs = ['observacoes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('observacoes') ?? $dependente->observacoes); ?></textarea>
                        </div>
                    </div>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php $__env->startComponent('components.button', [
                    'route' => $routes['convenio']['index']['route'],
                    'routeParams' => $routes['convenio']['index']['params'],
                    'icon' => 'list',
                    'label' => 'Convênios',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php $__env->startComponent('components.button', [
                    'route' => $routes['dependente']['index']['route'],
                    'routeParams' => $routes['dependente']['index']['params'],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </form>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/dependentes/edit.blade.php ENDPATH**/ ?>