<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/admin/geracao-carteirinha-index.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Geração de carteirinha</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Geração de carteirinha
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <form action="<?php echo e(route('admin.geracao-carteirinha.gera')); ?>" id="form-gerar" method="post" target="new">
                    <?php echo csrf_field(); ?>
                    <div class="form-row">
                        <div class="btn-group btn-group-toggle col-2" data-toggle="buttons">
                            <label class="btn btn-outline-secondary active">
                                <input name="via" value="1" type="radio" checked> 1ª via
                            </label>
                            <label class="btn btn-outline-secondary">
                                <input name="via" value="2" type="radio"> 2ª via
                            </label>
                        </div>
                        <div class="btn-group btn-group-toggle mx-2 col-3" data-toggle="buttons">
                            <label class="btn btn-outline-secondary active">
                                <input id="radio-todos" name="selecao" value="todos" type="radio" checked> Todos
                            </label>
                            <label class="btn btn-outline-secondary">
                                <input id="radio-selecionar" name="selecao" value="selecionar" type="radio"> Selecionar
                            </label>
                        </div>
                        <div id="div-busca-servidores" class="col-7 row">
                            <select name="filtro" form="busca-servidores" class="form-control col-4" id="select-filtro">
                                <?php $__currentLoopData = $filtrosServidores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $filtro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($filtro->getIndex()); ?>" <?php if(optional($filtroSelecionado)->isEqual($filtro)): ?> selected <?php endif; ?>><?php echo e($filtro->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="input-group col-8">
                                <input type="text" form="busca-servidores" id="text-busca" autocomplete="off" value="<?php echo e($busca ?? ''); ?>" name="busca" class="form-control busca <?php $__errorArgs = ['busca'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-outline-secondary" form="busca-servidores" title="Buscar"><i data-feather="search"></i></button>
                                    <a href="<?php echo e(route('admin.geracao-carteirinha.index')); ?>" class="btn btn-outline-secondary" title="Limpar"><i data-feather="x"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="form-row">
                        <?php $__env->startComponent('components.button', [
                        'icon' => '',
                        'label' => 'Gerar',
                        'class' => 'btn-primary'
                        ]); ?>
                        <?php echo $__env->renderComponent(); ?>
                    </div>
                </form>
                <form id="busca-servidores" action="">
                </form>
            </section>

            <?php if($servidores): ?>
            <section class="hk-sec-wrapper" id="section-servidores">
                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th class="w-25">
                                <input type="checkbox" id="check-selecionar-todos" title="Selecionar todos">
                            </th>
                            <th>Nome</th>
                            <th>Registro(s) ativo(s)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $servidores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $servidor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><input type="checkbox" form="form-gerar" name="servidores[]" class="check-servidor" value="<?php echo e($servidor->id); ?>"></td>
                            <td><?php echo e($servidor->nome_exibir); ?></td>
                            <td><?php echo e(implode(', ', $servidor->registros()->ativos()->get()->pluck('numero')->toArray())); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </section>
            <?php endif; ?>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-selecione-servidores" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <p>Selecione os servidores para gerar a carteirinha, ou clique em "Todos os servidores"</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Sim</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/geracao-carteirinha/index.blade.php ENDPATH**/ ?>