<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.unidades-organizacionais.index')); ?>">Unidade Organizacional</a></li>
        <li class="breadcrumb-item active" aria-current="page"><a href="<?php echo e(route('admin.unidades-organizacionais.edit', ['unidade' => $unidade])); ?>">Editar</a></li>
        <li class="breadcrumb-item active" aria-current="page">Transferir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Transferir unidade organizacional
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>
                <?php echo $__env->make('admin.unidades-organizacionais.listagem-transferencia', ['unidades' => $unidades, 'unidadeTransferir' => $unidade], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <hr>
                <?php $__env->startComponent('components.button', [
                'icon' => 'save',
                'label' => 'Salvar',
                'class' => 'btn-primary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>
                <?php if($unidade->superior): ?>
                <?php $__env->startComponent('components.button', [
                'route' => 'admin.unidades-organizacionais.edit',
                'routeParams' => ['unidade' => $unidade->superior],
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>
                <?php else: ?>
                <?php $__env->startComponent('components.button', [
                'route' => 'admin.unidades-organizacionais.index',
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>
                <?php endif; ?>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5><?php echo e(session('status')); ?></h5>
            </div>
            <div class="modal-body">
                <p>Deseja continuar e editar a unidade ou voltar para página anterior?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="btn-continuar">Continuar e editar</button>
                <button type="button" class="btn btn-secondary" id="btn-voltar">Voltar</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/unidades-organizacionais/transferir.blade.php ENDPATH**/ ?>