<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/servidores/registros/create-edit.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.index')); ?>">Servidor</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.edit', ['servidor' => $servidor])); ?>"><?php echo e($servidor->nome); ?></a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.movimentacoes.index', ['servidor' => $servidor])); ?>">Movimentações</a></li>
        <li class="breadcrumb-item active" aria-current="page">Exibir movimentação</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Exibir movimentação
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <div class="form-row">
                    <div class="form-group col-3">
                        <label for="evento">Evento</label>
                        <input type="text" name="evento" class="form-control-plaintext" value="<?php echo e($movimentacao->evento); ?>">
                    </div>
                    <div class="form-group col-4">
                        <label for="user">Usuário</label>
                        <input type="text" name="user" class="form-control-plaintext" value="<?php echo e($movimentacao->user->name); ?>">
                    </div>
                    <div class="form-group col-2">
                        <label for="data">Data/hora</label>
                        <input type="text" name="data" class="form-control-plaintext" value="<?php echo e($movimentacao->created_at->format('d/m/Y H:i:s')); ?>">
                    </div>
                    <div class="form-group col-6">
                        <label>
                            <?php if($movimentacao->evento->isEdicao()): ?>
                                Alterações
                            <?php elseif($movimentacao->evento->isInclusao()): ?>
                                Cadastro
                            <?php endif; ?>
                        </label>
                        <div class="text-dark">
                            <?php $__currentLoopData = $movimentacao->payload; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campo => $valor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <p><?php echo e($campo); ?>: <?php echo e($valor); ?></p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <hr>
                <?php $__env->startComponent('components.button', [
                'route' => 'admin.servidores.movimentacoes.index',
                'routeParams' => ['servidor' => $servidor],
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/servidores/movimentacoes/show.blade.php ENDPATH**/ ?>