<?php $__env->startPush('css'); ?>
<link href="<?php echo e(asset('css/admin/servidores-create-edit.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.index')); ?>">Servidores</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.edit', ['servidor' => $servidor])); ?>"><?php echo e($servidor->nome); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page">Religamento extraordinário</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Religamento extraordinário de servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="<?php echo e(route('admin.servidores.religamento-extraordinario', ['servidor' => $servidor])); ?>" method="post">
                    <?php echo csrf_field(); ?>

                    <?php $__env->startComponent('components.alerts'); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="matricula">Matrícula</label>
                            <input type="text" name="matricula" maxlength="100" readonly class="form-control-plaintext" value="<?php echo e($matricula->id); ?>">
                        </div>
                        <div class="form-group col-8">
                            <label for="motivo_religamento_extraordinario">Motivo *</label>
                            <input type="text" autofocus required name="motivo_religamento_extraordinario" maxlength="100" class="form-control <?php $__errorArgs = ['motivo_religamento_extraordinario'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('motivo_religamento_extraordinario')); ?>">
                        </div>
                        <div class="form-group col-2">
                            <label for="data_religamento_extraordinario">Data *</label>
                            <input type="text" required name="data_religamento_extraordinario" data-mask="00/00/0000" class="form-control <?php $__errorArgs = ['data_religamento_extraordinario'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('data_religamento_extraordinario', today()->format('d/m/Y'))); ?>">
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'save',
                    'label' => 'Religar',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </form>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/servidores/religamento-extraordinario.blade.php ENDPATH**/ ?>