<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(config('app.name')); ?> - Desligamento sindicato</title>
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressao.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressos/formulario-desligamento-sindicato.css')); ?>">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        <?php $__env->startComponent('components.impressos.cabecalho'); ?><?php echo $__env->renderComponent(); ?>

        <p class="cabecalho">
            À<br>
            DIRETORIA COLEGIADA<br>
            DD. Sindicato dos Servidores Públicos Municipais de Santos - SINDSERV
        </p>

        <h1>DESLIGAMENTO DO SINDICATO</h1>

        <p>
            Eu <?php echo e($servidor->nome); ?>, registro funcional nº <?php echo e($registro->numero); ?>,

            <?php if($servidor->eAposentado()): ?>
            lotato no IPREV,
            <?php else: ?>
            regime <?php echo e($registro->regime); ?> lotado(a) na Secretaria <?php echo e($secretaria); ?>,
            <?php endif; ?>

            venho por meio deste solicitar o desligamento do quadro associativo
            desta entidade, e desautorizar a <?php echo e($empresa); ?>, de proceder o desconto referente ao código
            (<?php echo e($codigoMensalidade); ?> - Mensalidade Sindical).
        </p>
        <p>
            Esclareço ainda, que estou ciente que a partir desta desfiliação, cessam todos os direitos associativos,
            tais como: seguro de vida, atendimento jurídico, atendimento odontológico, convênios e outros.
        </p>
        <p class="aviso-prazo">
            A desfiliação que for realizada após o 1º dia útil sofrerá ainda o desconto da mensalidade no mês vigente.<br>
            A desautorização se dará após o devido recebimento do eventual débito junto a Entidade,
            que será feito pela <?php echo e($empresa); ?>, condicionada ao sistema de desconto em folha de pagamento que funciona
            independente do SindServ.
        </p>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Associado
            </div>

            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Diretor
            </div>
        </div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Atendente
            </div>
        </div>

        <p class="data-recebimento">Recebemos pela Secretaria Geral ________/________/__________</p>

        <?php $__env->startComponent('components.impressos.rodape'); ?><?php echo $__env->renderComponent(); ?>
    </div>
</body>

</html>
<?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/impressos/formulario-desligamento-sindicato.blade.php ENDPATH**/ ?>