<?php $__env->startPush('css'); ?>
<link href="<?php echo e(asset('vendors/daterangepicker/daterangepicker.css')); ?>" rel="stylesheet" type="text/css">
<link href="<?php echo e(asset('vendors/bootstrap-timepicker/css/bootstrap-timepicker.min.css')); ?>" rel="stylesheet" type="text/css">
<link href="<?php echo e(asset('vendors/select2/dist/css/select2.min.css')); ?>" rel="stylesheet" type="text/css">
<link href="<?php echo e(asset('css/admin/agendamentos-atendimentos-create-show.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('vendors/moment/min/moment-with-locales.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/bootstrap-timepicker/js/bootstrap-timepicker.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/daterangepicker/daterangepicker.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/select2/dist/js/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/agendamentos-atendimentos/create-show.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.agendamentos-atendimentos.index', ['tipo' => strtolower($tipo->getName())])); ?>">Agendamentos de atendimentos</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir agendamento <?php echo e($tipo->getValue()); ?>

        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form id="form-agendamento" action="<?php echo e(route('admin.agendamentos-atendimentos.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <?php $__env->startComponent('components.alerts'); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <input type="hidden" id="hidden-pessoa-sem-anamnese" value="<?php echo e(session('pessoaSemAnamnese', false)); ?>">
                    <input type="hidden" id="hidden-pessoa-recem-agendada" value="<?php echo e(session('pessoa')); ?>">
                    <input type="hidden" id="hidden-tipo-pessoa-recem-agendada" value="<?php echo e(session('tipo')); ?>">
                    <input type="hidden" id="hidden-exception-message" value="<?php echo e(session('exceptionMessage')); ?>">
                    <input type="hidden" id="hidden-ultimo-atendimento-proximo" value="<?php echo e(session('ultimoAtendimentoProximo')); ?>">
                    <input type="hidden" name="permiteAgendamentoProximo" id="hidden-permite-agendamento-proximo" value="<?php echo e(session('permiteAgendamentoProximo', 0)); ?>">
                    <input type="hidden" id="hidden-exception-sobrepoe-juridico-message" value="<?php echo e(session('exceptionSobrepoeHorarioJuridicoMessage')); ?>">
                    <input type="hidden" name="em_tratamento" id="hidden-em-tratamento" value="<?php echo e(session('emTratamento', 0)); ?>">
                    <input type="hidden" name="emergencia" id="hidden-emergencia" value="<?php echo e(session('emergencia', 0)); ?>">
                    <input type="hidden" name="extraordinario" id="hidden-extraordinario" value="<?php echo e(session('extraordinario', 0)); ?>">
                    <input type="hidden" id="hidden-route-busca" value="<?php echo e(route('admin.agendamentos-atendimentos.busca-pessoa')); ?>">
                    <input type="hidden" id="hidden-route-busca-tipo-id" value="<?php echo e(url('admin/agendamentos-atendimentos/busca-pessoa/')); ?>">
                    <input type="hidden" name="tipo_agendamento" value="<?php echo e($tipo->getName()); ?>">
                    <input type="hidden" id="hidden-pessoa-selecionada-anteriormente" value="<?php echo e(old('pessoa')); ?>">
                    <input type="hidden" id="hidden-agendamento-recem-criado" value="<?php echo e(session('agendamento')); ?>">
                    <input type="hidden" id="hidden-feriados" value="<?php echo e($feriados); ?>">

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="select-tipo">Tipo</label>
                            <select autofocus class="form-control" id="select-tipo" name="tipo">
                                <option value="associado" <?php echo e(old('tipo') == 'associado' ? 'selected' : ''); ?>>Associado</option>
                                <option value="funcionario" <?php echo e(old('tipo') == 'funcionario' ? 'selected' : ''); ?>>Funcionário</option>
                                <option value="dependente" <?php echo e(old('tipo') == 'dependente' ? 'selected' : ''); ?>>Dependente</option>
                            </select>
                        </div>
                        <div class="form-group col-5">
                            <label for="pessoa">Pessoa *</label>
                            <select required name="pessoa" id="select-pessoa" class="form-control <?php $__errorArgs = ['pessoa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"></select>
                        </div>
                        <?php if($tipo->isOdontologico()): ?>
                        <div class="form-group col-5">
                            <label for="prestador_servico_id">Profissional</label>

                            <select class="form-control" name="prestador_servico_id">
                                <?php $__currentLoopData = $prestadores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($prest->id); ?>" <?php echo e(old('prestador_servico_id', $prestador_id) == $prest->id ? 'selected' : ''); ?>><?php echo e($prest->nome); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php endif; ?>
                        <div class="form-group col-2">
                            <label for="data">Data *</label>
                            <input type="text" required autocomplete="off" name="data" class="form-control data <?php $__errorArgs = ['data'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('data') ?? $data ?? ''); ?>">
                        </div>
                        <div class="form-group col-2">
                            <label for="hora_inicio">Hora início *</label>
                            <input type="text" required id="input-hora-inicio" autocomplete="off" name="hora_inicio" class="form-control hora <?php $__errorArgs = ['hora_inicio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('hora_inicio') ?? $hora ?? ''); ?>">
                        </div>
                        <div class="form-group col-2">
                            <label for="hora_fim">Hora fim *</label>
                            <input type="text" required id="input-hora-fim" autocomplete="off" name="hora_fim" class="form-control hora <?php $__errorArgs = ['hora_fim'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('hora_fim')); ?>">
                        </div>
                        <?php if($tipo->isOdontologico()): ?>
                        <div class="form-group col-2">
                            <label for="emergencia">Emergência *</label>
                            <select name="emergencia" class="form-control">
                                <option value="0" <?php if(! old('emergencia')): ?> selected <?php endif; ?>>NÃO</option>
                                <option value="1" <?php if( old('emergencia')): ?> selected <?php endif; ?>>SIM</option>
                            </select>
                        </div>
                        <?php endif; ?>
                    </div>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.agendamentos-atendimentos.index',
                    'routeParams' => ['tipo' => $tipo->getName()],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-sucesso" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <p><?php echo e(session('status')); ?></p>
                <p class="mt-2">Paciente não tem anamnese, deseja preencher agora?</p>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-criar-anamnese" data-url="<?php echo e(url('admin/agendamentos-atendimentos/atendimentos-odontologicos/anamnese/')); ?>" class="btn btn-primary">Sim</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <p><?php echo e(session('exceptionMessage')); ?></p>
                <p class="mt-2">Deseja continuar e agendar o atendimento mesmo assim?</p>
            </div>
            <div class="modal-footer">
                <button type="submit" form="form-agendamento" class="btn btn-primary">Sim</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="modal-agendamento-extraordinario" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="form-row">
                    <p><?php echo e(session('exceptionMessage')); ?></p>
                    <p class="mt-2">Deseja continuar e agendar o atendimento mesmo assim?</p>
                </div>
                <div class="form-row">
                    <div class="form-group col-12">
                        <label for="motivo_extraordinario">Motivo *</label>
                        <input type="text" form="form-agendamento" id="text-motivo-extraordinario" maxlength="100" autocomplete="off" name="motivo_extraordinario" class="form-control <?php $__errorArgs = ['motivo_extraordinario'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('motivo_extraordinario')); ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" form="form-agendamento" class="btn btn-primary">Sim</button>
                <button type="button" class="btn btn-secondary" id="btnCancelarAgendamentoExtraordinario" data-dismiss="modal">Não</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/agendamentos-atendimentos/create.blade.php ENDPATH**/ ?>