<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(config('app.name')); ?> - Autorização de Inclusão de Dependentes</title>
    <link href="<?php echo e(asset('vendors/bootstrap/dist/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressos/autorizacao-inclusao-dependentes.css')); ?>">
</head>

<body onload="/*javascript:print()*/">
    <div id="wrapper">
        <?php $__env->startComponent('components.impressos.cabecalho'); ?><?php echo $__env->renderComponent(); ?>

        <h1>AUTORIZAÇÃO DE INCLUSÃO DE DEPENDENTES<br>CONVÊNIO OSAN/SINDSERV</h1>

        <p>
        Eu <?php echo e($servidor->nome); ?>, Registro Funcional nº <?php echo e($registro->numero); ?>, Regime <?php echo e(optional($registro->regime)->getValue()); ?>

autorizo o(a) __________, a descontar de meus vencimentos mensais, o valor de R$ _____________ (________________________),
a partir do mês _________, referente a inclusão dos dependentes abaixo relacionados, no convênio OSAN/SINDSERV.
        </p>
        <?php if($dependentes->count() > 0): ?>
        <table class="col-12 table table-bordered">
            <thead>
                <tr>
                    <th>Dependentes</th>
                    <th>Parentesco</th>
                    <th>Valor (R$)</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $dependentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dependente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($dependente->nome); ?></td>
                    <td><?php echo e($dependente->grau_parentesco->getValue()); ?></td>
                    <td></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php endif; ?>
        <div class="aviso">
            <h2>IMPORTANTE</h2>
            <p>Os valores acima serão <b>reajustados anualmente</b>, automaticamente e sem prévio aviso, conforme cláusula
de contrato firmado entre as partes.</p>
            <p>Cobertura para utilização da OSAN só se efetivará após <b>carência de 31 (trinta e um) dias a partir desta data</b>.</p>
        </div>        
        <p>Santos, ________/___________/___________</p>
        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura Diretor SINDSERV
            </div>

            <div class="assinatura">
                ______________________________________<br>
                Assinatura Associado
            </div>
        </div>

        <div class="assinaturas">
            <div class="assinatura ">
                ______________________________________<br>
                Assinatura Funcionário SINDSERV
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/impressos/autorizacao-inclusao-dependentes.blade.php ENDPATH**/ ?>