<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/telefones.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.index')); ?>">Servidores</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.edit', ['servidor' => $servidor])); ?>"><?php echo e($servidor->nome); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page">Falecimento</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Falecimento de servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="<?php echo e(route('admin.servidores.atualiza-falecimento', ['servidor' => $servidor])); ?>" method="post">
                    <?php echo csrf_field(); ?>

                    <?php $__env->startComponent('components.alerts'); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="data_falecimento">Data do falecimento</label>
                            <input type="text" autofocus name="data_falecimento" data-mask="00/00/0000" class="form-control <?php $__errorArgs = ['data_falecimento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('data_falecimento', optional($servidor->data_falecimento)->format('d/m/Y'))); ?>">
                        </div>
                        <div class="form-group col-10">
                            <label for="nome_herdeiro">Nome herdeiro</label>
                            <input type="text" name="nome_herdeiro" maxlength="150" class="form-control <?php $__errorArgs = ['nome_herdeiro'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nome_herdeiro', optional($servidor->herdeiro)->nome)); ?>">
                        </div>

                        <?php echo $__env->make('components.endereco', ['endereco' => $endereco ?? null, 'obrigatorio' => false], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <div class="div-telefones form-row col-12">
                            <?php echo $__env->make('components.telefone', ['name' => 'telefone[0]', 'tipoTelefone' => 'celular', 'obrigatorio' => false,
                            'valor' => old('telefone.0.numero', optional($telefoneCelular)->valor), 'observacoes' => old('telefone.0.observacoes', optional($telefoneCelular)->observacoes),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo $__env->make('components.telefone', ['name' => 'telefone[1]', 'valor' => old('telefone.1.numero', optional($telefoneFixo)->valor),
                            'observacoes' => old('telefone.1.observacoes', optional($telefoneFixo)->observacoes)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="form-group col-12">
                            <label for="observacao_falecimento">Observações falecimento</label>
                            <textarea name="observacao_falecimento" maxlength="255" class="form-control <?php $__errorArgs = ['observacao_falecimento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('observacao_falecimento') ?? $servidor->observacao_falecimento); ?></textarea>
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'save',
                    'label' => 'Atualizar',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </form>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/servidores/falecimento.blade.php ENDPATH**/ ?>