<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/admin/unidades-organizacionais/listagem-transferencia.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<table class="table mt-3">
    <thead>
        <tr>
            <th>Nome</th>
            <th>Sigla</th>
            <th>Hierarquia</th>
            <th>Centro de custo</th>
            <th class="w-25">Ação</th>
        </tr>
    </thead>
    <tbody>
        <?php if($unidadeTransferir->superior): ?>
        <tr>
            <td colspan="4">(RAIZ)</td>
            <td>
                <?php $__env->startComponent('components.button', [
                'class' => 'btn-primary btn-transferir-unidade',
                'icon' => 'move',
                'label' => 'Selecionar',
                'route' => 'admin.unidades-organizacionais.transferir',
                'routeParams' => ['unidadeTransferir' => $unidadeTransferir],
                ]); ?>
                <?php echo $__env->renderComponent(); ?>
            </td>
        </tr>
        <?php endif; ?>
        <?php $__currentLoopData = $unidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unidade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($unidade->nome); ?></td>
            <td><?php echo e($unidade->sigla); ?></td>
            <td><?php echo e($unidade->hierarquiaExtenso()); ?></td>
            <td><?php echo e($unidade->centro_custo); ?></td>
            <td>
                <?php $__env->startComponent('components.button', [
                'class' => 'btn-primary btn-transferir-unidade',
                'icon' => 'move',
                'label' => 'Selecionar',
                'route' => 'admin.unidades-organizacionais.transferir',
                'routeParams' => ['unidadeDestino' => $unidade, 'unidadeTransferir' => $unidadeTransferir],
                ]); ?>
                <?php echo $__env->renderComponent(); ?>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<div class="modal fade" id="modal-transferir-unidade" tabindex="-1" role="dialog">
    <form method="POST" id="form-transferir-unidade">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente transferir a unidade "<?php echo e($unidade->nome); ?>" para a unidade selecionada?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/unidades-organizacionais/listagem-transferencia.blade.php ENDPATH**/ ?>