<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(config('app.name')); ?> - Cancelamento seguro</title>
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressao.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressos/formulario-cancelamento-seguro.css')); ?>">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        <?php $__env->startComponent('components.impressos.cabecalho'); ?><?php echo $__env->renderComponent(); ?>

        <div class="cabecalho">
            <div class="data">Santos, <?php echo e(today()->format('d/m/Y')); ?></div>

            <p>
                À<br>
                DIRETORIA COLEGIADA<br>
                DD. Sindicato dos Servidores Públicos Municipais de Santos - SINDSERV
            </p>
        </div>

        <h1>CANCELAMENTO DO SEGURO</h1>

        <p>
            Eu <?php echo e($servidor->nome); ?>, registro funcional nº <?php echo e($registro->numero); ?>, regime <?php echo e($registro->regime); ?> lotado(a) na
            Secretaria <?php echo e($secretaria); ?>, venho por meio deste requerer o cancelamento do <b>SEGURO DE VIDA - código 407</b> e
            desautorizar a <?php echo e($empresa); ?>, a continuar efetuando o referido desconto.
        </p>
        <p class="aviso-ressalva">
            <b>Ressalva:</b> pelo presente documento fica insento o <b>SINDSERV</b> de eventuais descontos cometido pela Prefeitura Municipal de Santos
            quanto a operacionalização deste desligamento do <b>SEGURO DE VIDA</b> após o envio do mesmo.
        </p>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Associado
            </div>

            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Diretor
            </div>
        </div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Atendente
            </div>
        </div>

        <?php $__env->startComponent('components.impressos.rodape'); ?><?php echo $__env->renderComponent(); ?>
    </div>
</body>

</html>
<?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/impressos/formulario-cancelamento-seguro.blade.php ENDPATH**/ ?>