<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/admin/servidores/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('css'); ?>
<link href="<?php echo e(asset('css/admin/servidores.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Servidores</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Servidores
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <div class="form-row">
                    <div class="col-2">
                        <?php $__env->startComponent('components.button', [
                        'route' => 'admin.servidores.create',
                        'icon' => 'plus',
                        'label' => 'Incluir',
                        'class' => 'btn-primary'
                        ]); ?>
                        <?php echo $__env->renderComponent(); ?>
                    </div>
                    <select name="situacao" form="filtro" class="form-control col" id="select-situacao">
                        <?php $__currentLoopData = $situacoesServidores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $situacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($situacao->getIndex()); ?>" <?php echo e($situacaoSelecionada->isEqual($situacao) ? 'selected' : ''); ?>><?php echo e($situacao->getValue()); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <select name="filtro" form="filtro" class="form-control col" id="select-filtro">
                        <?php $__currentLoopData = $filtrosServidores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $filtro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($filtro->getIndex()); ?>" <?php echo e($filtroSelecionado->isEqual($filtro) ? 'selected' : ''); ?>><?php echo e($filtro->getValue()); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="input-group col-4">
                        <input type="text" form="filtro" autocomplete="off" value="<?php echo e($busca ?? ''); ?>" name="busca" class="form-control busca <?php $__errorArgs = ['busca'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <div class="input-group-append">
                            <button type="submit" class="btn btn-outline-secondary" form="filtro" title="Buscar"><i data-feather="search"></i></button>
                            <a href="<?php echo e(route('admin.servidores.index')); ?>" class="btn btn-outline-secondary" title="Limpar"><i data-feather="x"></i></a>
                        </div>
                    </div>
                    <div class="form-check mt-2">
                        <input class="form-check-input" type="checkbox" form="filtro" name="excluidos" <?php echo e($excluidos ?? false ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="excluidos">
                            Excluídos
                        </label>
                    </div>
                </div>

                <form id="filtro">
                </form>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Registro</th>
                            <th>CPF</th>
                            <th>Status</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $servidores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $servidor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        if ($situacaoSelecionada->isTodos()) {
                        if ($servidor->desfiliadoTemporariamente()) {
                        $classe = 'desfiliado-temporariamente';
                        } elseif ($servidor->desfiliadoDefinitivamente()) {
                        $classe = 'desfiliado-definitivamente';
                        } else {
                        $classe = '';
                        }

                        $registro = $servidor->registros->first();
                        }
                        ?>
                        <tr class="<?php echo e($servidor->trashed() ? 'table-danger' : ''); ?> <?php echo e($classe ?? ''); ?>">
                            <td><?php echo e($servidor->nome); ?></td>
                            <td><?php echo e(optional($registro)->numero); ?></td>
                            <td><?php echo e($servidor->cpf); ?></td>
                            <td><?php echo e($servidor->situacao()); ?></td>
                            <td>
                                <?php $__env->startComponent('components.button', [
                                'route' => 'admin.servidores.edit',
                                'routeParams' => ['servidor' => $servidor],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                                <?php $__env->startComponent('components.button', [
                                'class' => 'btn-danger btn-excluir-servidor',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.servidores.destroy',
                                'routeParams' => ['servidor' => $servidor],
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($servidores->links()); ?>

            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-servidor" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-servidor">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o servidor?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/servidores/index.blade.php ENDPATH**/ ?>