<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(config('app.name')); ?> - Ficha de inscrição</title>
    <link href="<?php echo e(asset('vendors/bootstrap/dist/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressos/ficha-inscricao.css')); ?>">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        <?php $__env->startComponent('components.impressos.cabecalho'); ?><?php echo $__env->renderComponent(); ?>

        <h1>FICHA DE INSCRIÇÃO DO ASSOCIADO</h1>

        <div class="cabecalho form-row">
            <div class="col-8"><span class="label">Matrícula Sindical:</span> <?php echo e($numeroMatricula); ?></div>
            <div class="col-4"><span class="label">Data Admissão:</span> <?php echo e(optional($dataAdmissaoSindical)->format('d/m/Y')); ?></div>
        </div>

        <div class="form-row">
            <div class="col-12"><span class="label">Nome:</span> <?php echo e($servidor->nome); ?></div>
        </div>
        <div class="form-row">
            <div class="col-6"><span class="label">Data de Nascimento:</span> <?php echo e(optional($servidor->data_nascimento)->format('d/m/Y')); ?></div>
            <div class="col-6"><span class="label">Naturalidade/UF:</span> <?php if($servidor->naturalidade): ?> <?php echo e($servidor->naturalidade); ?> / <?php echo e($servidor->naturalidade_uf); ?> <?php endif; ?></div>
        </div>
        <div class="form-row">
            <div class="col-6"><span class="label">Estado civil:</span> <?php echo e($servidor->estado_civil); ?></div>
            <div class="col-6"><span class="label">Filiação - Pai:</span> <?php echo e($servidor->nome_pai); ?></div>
        </div>
        <div class="form-row">
            <div class="col-6 offset-md-6"><span class="label">Mãe:</span> <?php echo e($servidor->nome_mae); ?></div>
        </div>
        <div class="form-row">
            <div class="col-3"><span class="label">RG:</span> <?php echo e($servidor->rg); ?></div>
            <div class="col-3"><span class="label">CPF:</span> <?php echo e($servidor->cpf); ?></div>
            <div class="col-6"><span class="label">Escolaridade:</span> <?php echo e($servidor->nivel_ensino); ?></div>
        </div>
        <div class="form-row">
            <div class="col-12"><span class="label">End. Residencial:</span>
                <?php if($enderecoServidor): ?>
                <?php echo e($enderecoServidor->logradouro); ?>,
                <?php if($enderecoServidor->numero): ?>
                <?php echo e($enderecoServidor->numero); ?>.
                <?php else: ?> S/N
                <?php endif; ?> <?php echo e(optional($enderecoServidor)->complemento); ?>

                <?php endif; ?>
            </div>
        </div>
        <div class="form-row">
            <div class="col-4"><span class="label">Bairro:</span> <?php echo e(optional($enderecoServidor)->bairro); ?></div>
            <div class="col-6"><span class="label">Cidade:</span> <?php echo e(optional($enderecoServidor)->cidade); ?> <?php if(isset($enderecoServidor->cidade)): ?> - <?php endif; ?> <?php echo e(optional($enderecoServidor)->estado); ?></div>
            <div class="col-2"><span class="label">CEP:</span> <?php echo e(optional($enderecoServidor)->cep); ?></div>
        </div>
        <div class="form-row">
            <div class="col-6"><span class="label">Telefone Fixo:</span> <?php echo e(optional($telefoneFixo)->valor); ?></div>
            <div class="col-6"><span class="label">Telefone Celular:</span> <?php echo e(optional($telefoneCelular)->valor); ?></div>
        </div>
        <div class="form-row">
            <div class="col-12"><span class="label">E-mail:</span> <?php echo e($email); ?></div>
        </div>
        <div class="form-row">
            <div class="col-8"><span class="label">Secretaria:</span> <?php echo e($secretaria); ?></div>
            <div class="col-4"><span class="label">Data Admissão PMS:</span> <?php echo e(optional($registro->data_admissao)->format('d/m/Y')); ?></div>
        </div>
        <div class="form-row">
            <div class="col-12"><span class="label">End. Local de trabalho:</span>
                <?php if($enderecoLotacao): ?>
                <?php echo e($enderecoLotacao->logradouro); ?>,
                <?php if($enderecoLotacao->numero): ?>
                <?php echo e($enderecoLotacao->numero); ?>.
                <?php else: ?> S/N
                <?php endif; ?>
                <?php echo e(optional($enderecoLotacao)->complemento); ?>

                <?php endif; ?>
            </div>
        </div>
        <div class="form-row">
            <div class="col-4"><span class="label">Bairro:</span> <?php echo e(optional($enderecoLotacao)->bairro); ?></div>
            <div class="col-6"><span class="label">Cidade:</span> <?php echo e(optional($enderecoLotacao)->cidade); ?> <?php if(isset($enderecoLotacao->cidade)): ?> - <?php endif; ?> <?php echo e(optional($enderecoLotacao)->estado); ?></div>
            <div class="col-2"><span class="label">CEP:</span> <?php echo e(optional($enderecoLotacao)->cep); ?></div>
        </div>
        <div class="form-row">
            <div class="col-4"><span class="label">Registro Funcional:</span> <?php echo e($registro->numero); ?></div>
            <div class="col-4"><span class="label">Regime:</span> <?php echo e($registro->regime); ?></div>
            <div class="col-4"><span class="label">Setor:</span> <?php echo e($nomeSetor); ?></div>
        </div>
        <div class="form-row">
            <div class="col-4"><span class="label">Tel. Setor:</span> <?php echo e($telefoneSetor); ?></div>
            <div class="col-4"><span class="label">Nível Salarial:</span> <?php echo e($nivelSalarial); ?></div>
            <div class="col-4"><span class="label">Cargo:</span> <?php echo e(optional($cargo)->nome); ?></div>
        </div>
        <div class="form-row">
            <div class="col-6"><span class="label">Readaptado?</span> <?php echo e($registro->readaptado ? 'Sim' : 'Não'); ?></div>
            <div class="col-6"><span class="label">Em qual função:</span> <?php echo e(optional($registro->cargo_readaptado)->nome); ?></div>
        </div>
        <div class="form-row">
            <div class="col-6"><span class="label">Data aposentadoria:</span> <?php echo e(optional($registro->data_aposentadoria)->format('d/m/Y')); ?></div>
            <div class="col-6">
                <label>CP <input type="checkbox" name="paridade" disabled value="CP" <?php if($registro->data_aposentadoria && $registro->paridade): ?> checked <?php endif; ?>></label>
                <label>NP <input type="checkbox" name="paridade" disabled value="NP" <?php if($registro->data_aposentadoria && ! $registro->paridade): ?> checked <?php endif; ?>></label>
            </div>
        </div>
        <?php if($dependentes->count() > 0): ?>
        <table class="col-12">
            <thead>
                <tr>
                    <th>Dependentes</th>
                    <th>Data de nascimento</th>
                    <th>Grau de parentesco</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $dependentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dependente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($dependente->nome); ?></td>
                    <td><?php echo e($dependente->data_nascimento->format('d/m/Y')); ?></td>
                    <td><?php echo e($dependente->grau_parentesco->getValue()); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php endif; ?>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Sócio Proponente
            </div>

            <div class="assinatura">
                ______________________________________<br>
                SINDSERV / SECRETARIA
            </div>
        </div>

        <div class="page-break"></div>

        <?php $__env->startComponent('components.impressos.cabecalho'); ?><?php echo $__env->renderComponent(); ?>

        <h1>AUTORIZAÇÃO PARA DESCONTO</h1>
        <p>
            Eu, <?php echo e($servidor->nome); ?>, Registro Nº <?php echo e($registro->numero); ?>, Regime: <?php echo e($registro->regime); ?>,
            Secretaria: <?php echo e($secretaria); ?>, pela presente, autorizo a <?php echo e($empresa); ?> a descontar do meu SALÁRIO,
            mensalidades no valor R$ <?php echo e($mensalidade ? number_format($mensalidade->valor, 2, ',', '.') : "0,00"); ?>,
            ref. nível <?php echo e($nivelSalarial); ?> do Sindicato dos Servidores
            Públicos Municipais de Santos, à partir do mês de <?php echo e($mesDesconto); ?>.
        </p>
        <p>Tal desconto refere-se à mensalidade sindical.</p>
        <p class="mt-4">Santos, ___________ de _____________________ de 20__________</p>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                ASSINATURA
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/impressos/ficha-inscricao.blade.php ENDPATH**/ ?>