<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;

Auth::routes(['register' => false]);

Route::middleware(['auth'])->group(function () {
    Route::prefix('admin')->group(function () {
        Route::get('perfil', 'Admin\PerfilController@index')->name('admin.perfil.index');
        Route::get('perfil/alterar-senha', 'Admin\PerfilController@alterarSenhaForm')->name('admin.perfil.alterar-senha');
        Route::put('perfil/alterar-senha', 'Admin\PerfilController@updateSenha')->name('admin.perfil.update-senha');

        Route::get('usuarios/{usuario}/alterar-senha', 'Admin\UsuariosController@alteraSenhaForm')->name('admin.usuarios.alterar-senha');
        Route::put('usuarios/{usuario}/alterar-senha', 'Admin\UsuariosController@alteraSenha')->name('admin.usuarios.update-senha');
        Route::resource('usuarios', 'Admin\UsuariosController', ['as' => 'admin']);

        Route::resource('usuarios.perfis', 'Admin\PerfisUsuarioController', ['as' => 'admin'])
            ->parameters(['perfis' => 'perfil']);

        Route::resource('cargos', 'Admin\CargoController', ['as' => 'admin']);

        Route::get('unidades-organizacionais/{superior}/create', 'Admin\UnidadeOrganizacionalController@create')
            ->name('admin.unidades-organizacionais-create-subordinada');
        Route::get('unidades-organizacionais/{unidade}/transferir', 'Admin\UnidadeOrganizacionalController@transferirForm')
            ->name('admin.unidades-organizacionais.transferir-form');
        Route::put('unidades-organizacionais/{unidadeTransferir}/transferir/{unidadeDestino?}', 'Admin\UnidadeOrganizacionalController@transferir')
            ->name('admin.unidades-organizacionais.transferir');
        Route::resource('unidades-organizacionais', 'Admin\UnidadeOrganizacionalController', ['as' => 'admin'])
            ->parameters(['unidades-organizacionais' => 'unidade']);

        Route::get('contas-pagar-receber', 'Admin\ContaPagarReceberController@index')->name('admin.contas-pagar-receber.index');
        Route::delete('contas-pagar-receber/{conta}', 'Admin\ContaPagarReceberController@destroy')->name('admin.contas-pagar-receber.destroy');

        Route::get('contas-pagar/create', 'Admin\ContaPagarReceberController@createPagar')->name('admin.contas-pagar.create');
        Route::post('contas-pagar', 'Admin\ContaPagarReceberController@storePagar')->name('admin.contas-pagar.store');
        Route::get('contas-pagar/{conta}/edit', 'Admin\ContaPagarReceberController@editPagar')->name('admin.contas-pagar.edit');
        Route::put('contas-pagar/{conta}', 'Admin\ContaPagarReceberController@updatePagar')->name('admin.contas-pagar.update');

        Route::get('contas-receber/create', 'Admin\ContaPagarReceberController@createReceber')->name('admin.contas-receber.create');
        Route::post('contas-receber', 'Admin\ContaPagarReceberController@storeReceber')->name('admin.contas-receber.store');
        Route::get('contas-receber/{conta}/edit', 'Admin\ContaPagarReceberController@editReceber')->name('admin.contas-receber.edit');
        Route::put('contas-receber/{conta}', 'Admin\ContaPagarReceberController@updateReceber')->name('admin.contas-receber.update');

        Route::resource('planos-contas', 'Admin\PlanoContaController', ['as' => 'admin'])
            ->parameters(['planos-contas' => 'plano']);
        Route::resource('planos-contas.classificacoes', 'Admin\ClassificacaoContaController', ['as' => 'admin'])
            ->parameters(['planos-contas' => 'plano', 'classificacoes' => 'classificacao']);

        Route::get('feriados/load', 'Admin\FeriadoController@load')->name('admin.feriados.load');
        Route::resource('feriados', 'Admin\FeriadoController', ['as' => 'admin']);

        Route::get('agenda-diretoria/load', 'Admin\AgendaDiretoriaController@load')->name('admin.agenda-diretoria.load');
        Route::resource('agenda-diretoria', 'Admin\AgendaDiretoriaController', ['as' => 'admin'])
            ->parameters(['agenda-diretoria' => 'evento']);

        Route::resource('motivos-cancelamentos-agendamentos', 'Admin\MotivoCancelamentoAgendamentoController', ['names' => 'admin.motivos-cancelamentos-agendamentos'])
            ->parameters(['motivos-cancelamentos-agendamentos' => 'motivo']);

        Route::get('agendamentos-atendimentos/data-indisponivel', 'Admin\AgendamentoAtendimentoController@obtemDataIndisponivel')->name('admin.agendamentos-atendimentos.obtem-data-indisponivel');
        Route::get('agendamentos-atendimentos/busca-pessoa', 'Admin\AgendamentoAtendimentoController@buscaPessoa')->name('admin.agendamentos-atendimentos.busca-pessoa');
        Route::get('agendamentos-atendimentos/busca-pessoa/{tipo}/{id}', 'Admin\AgendamentoAtendimentoController@buscaPessoaPorTipoId')->name('admin.agendamentos-atendimentos.busca-pessoa-tipo-id');
        Route::get('agendamentos-atendimentos/busca', 'Admin\AgendamentoAtendimentoController@busca')->name('admin.agendamentos-atendimentos.busca');
        Route::post('agendamentos-atendimentos/{agendamento}/desmarcar', 'Admin\AgendamentoAtendimentoController@desmarcar')->name('admin.agendamentos-atendimentos.desmarcar');
        Route::post('agendamentos-atendimentos/{agendamento}/faltou', 'Admin\AgendamentoAtendimentoController@faltou')->name('admin.agendamentos-atendimentos.faltou');
        Route::post('agendamentos-atendimentos/{agendamento}/esperando', 'Admin\AgendamentoAtendimentoController@esperando')->name('admin.agendamentos-atendimentos.esperando');
        Route::get('agendamentos-atendimentos/load', 'Admin\AgendamentoAtendimentoController@load')->name('admin.agendamentos-atendimentos.load');
        Route::resource('agendamentos-atendimentos', 'Admin\AgendamentoAtendimentoController', ['names' => 'admin.agendamentos-atendimentos'])
            ->parameters(['agendamentos-atendimentos' => 'agendamento']);

        Route::get('agendamentos-atendimentos/atendimentos-odontologicos/anamnese/{pessoa}/tipo/{tipo}/create-edit', 'Admin\AnamneseAtendimentoController@createEdit')->name('admin.anamnese-atendimento.create-edit');
        Route::post('agendamentos-atendimentos/atendimentos-odontologicos/anamnese/', 'Admin\AnamneseAtendimentoController@store')->name('admin.anamnese-atendimento.store');
        Route::get('agendamentos-atendimentos/atendimentos-odontologicos/anamnese/{pessoa}/tipo/{tipo}/impressao', 'Admin\AnamneseAtendimentoController@impressao')->name('admin.anamnese-atendimento.impressao');

        Route::get('agendamentos-atendimentos/{agendamento}/atendimentos-odontologicos/paciente', 'Admin\AtendimentoOdontologicoController@paciente')->name('admin.atendimentos-odontologicos.paciente');
        Route::get('agendamentos-atendimentos/{agendamento}/atendimentos-odontologicos/historico', 'Admin\AtendimentoOdontologicoController@historico')->name('admin.atendimentos-odontologicos.historico');
        Route::resource('agendamentos-atendimentos.atendimentos-odontologicos', 'Admin\AtendimentoOdontologicoController', ['names' => 'admin.atendimentos-odontologicos'])
            ->parameters(['atendimentos-odontologicos' => 'atendimento', 'agendamentos-atendimentos' => 'agendamento']);
        Route::get('agendamentos-atendimentos/atendimentos-odontologicos/index', 'Admin\AtendimentoOdontologicoController@index')->name('admin.atendimentos-odontologicos.index');

        Route::get('agendamentos-atendimentos/{agendamento}/atendimentos-juridicos/processos/{processo}/create', 'Admin\AtendimentoJuridicoController@create')->name('admin.atendimentos-juridicos.create');
        Route::post('agendamentos-atendimentos/{agendamento}/atendimentos-juridicos/processos/{processo}', 'Admin\AtendimentoJuridicoController@store')->name('admin.atendimentos-juridicos.store');
        Route::get('agendamentos-atendimentos/{agendamento}/atendimentos-juridicos/processos/{processo}/{atendimento}/edit', 'Admin\AtendimentoJuridicoController@edit')->name('admin.atendimentos-juridicos.edit');
        Route::put('agendamentos-atendimentos/{agendamento}/atendimentos-juridicos/processos/{processo}/{atendimento}', 'Admin\AtendimentoJuridicoController@update')->name('admin.atendimentos-juridicos.update');
        Route::get('agendamentos-atendimentos/atendimentos-juridicos/processos/{processo}/historico', 'Admin\AtendimentoJuridicoController@historico')->name('admin.atendimentos-juridicos.historico');

        Route::get('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos', 'Admin\ProcessoJuridicoController@index')->name('admin.processos-juridicos.index');
        Route::get('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos/create', 'Admin\ProcessoJuridicoController@create')->name('admin.processos-juridicos.create');
        Route::post('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos', 'Admin\ProcessoJuridicoController@store')->name('admin.processos-juridicos.store');
        Route::get('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos/{id}/edit', 'Admin\ProcessoJuridicoController@edit')->name('admin.processos-juridicos.edit');
        Route::put('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos/{id}', 'Admin\ProcessoJuridicoController@update')->name('admin.processos-juridicos.update');
        Route::delete('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos/{id}', 'Admin\ProcessoJuridicoController@destroy')->name('admin.processos-juridicos.destroy');

        Route::get('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos/{idProcesso}/anexos/create', 'Admin\AnexoProcessoJuridicoController@create')->name('admin.anexos-processos-juridicos.create');
        Route::post('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos/{idProcesso}/anexos', 'Admin\AnexoProcessoJuridicoController@store')->name('admin.anexos-processos-juridicos.store');
        Route::get('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos/{idProcesso}/anexos/{id}/edit', 'Admin\AnexoProcessoJuridicoController@edit')->name('admin.anexos-processos-juridicos.edit');
        Route::put('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos/{idProcesso}/anexos/{id}', 'Admin\AnexoProcessoJuridicoController@update')->name('admin.anexos-processos-juridicos.update');
        Route::get('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos/{idProcesso}/anexos/{id}/download', 'Admin\AnexoProcessoJuridicoController@download')->name('admin.anexos-processos-juridicos.download');
        Route::delete('atendimentos-juridicos/{pessoa}/tipo/{tipo}/processos/{idProcesso}/anexos/{id}', 'Admin\AnexoProcessoJuridicoController@destroy')->name('admin.anexos-processos-juridicos.destroy');

        Route::resource('tipos-documentos', 'Admin\TipoDocumentoController', ['as' => 'admin'])
            ->parameters(['tipos-documentos' => 'tipo']);

        Route::get('dependentes', 'Admin\BuscaDependenteController@index')->name('admin.dependentes.busca');

        Route::get('formularios/servidores/{servidor}/desfiliacao', 'Admin\FormularioController@desfiliacao')->name('admin.formularios.servidores.desfiliacao');
        Route::get('formularios/servidores/{servidor}/desfiliacaoRenunciaPoderesAdvogados', 'Admin\FormularioController@desfiliacaoRenunciaPoderesAdvogados')->name('admin.formularios.servidores.desfiliacao-renuncia-poderes-advogados');
        Route::get('formularios/servidores/{servidor}/cancelamento-seguro', 'Admin\FormularioController@cancelamentoSeguro')->name('admin.formularios.servidores.cancelamento-seguro');
        Route::get('formularios/servidores/{servidor}/cancelamento-osan', 'Admin\FormularioController@cancelamentoOsan')->name('admin.formularios.servidores.cancelamento-osan');
        Route::get('formularios/servidores/{servidor}/{dependente}/cancelamento-osan', 'Admin\FormularioController@cancelamentoOsanDependente')->name('admin.formularios.servidores.cancelamento-osan-dependente');
        Route::get('formularios/servidores/{servidor}/ficha-inscricao', 'Admin\FormularioController@fichaInscricao')->name('admin.formularios.servidores.ficha-inscricao');
        Route::get('formularios/servidores/{servidor}/declaracao-idade-acima-limite', 'Admin\FormularioController@declaracaoAcimaIdadeLimite')->name('admin.formularios.servidores.declaracao-idade-acima-limite');

        Route::get('servidores/{servidor}/afilia', 'Admin\Servidor\ServidorController@afiliaForm')->name('admin.servidores.afilia-form');
        Route::post('servidores/{servidor}/afilia', 'Admin\Servidor\ServidorController@afilia')->name('admin.servidores.afilia');
        Route::get('servidores/{servidor}/desfilia', 'Admin\Servidor\ServidorController@desfiliaForm')->name('admin.servidores.desfilia-form');
        Route::post('servidores/{servidor}/desfilia', 'Admin\Servidor\ServidorController@desfilia')->name('admin.servidores.desfilia');
        Route::get('servidores/{servidor}/religamento-extraordinario', 'Admin\Servidor\ServidorController@religamentoExtraordinarioForm')->name('admin.servidores.religamento-extraordinario-form');
        Route::post('servidores/{servidor}/religa', 'Admin\Servidor\ServidorController@religaExtraordinariamente')->name('admin.servidores.religamento-extraordinario');
        Route::get('servidores/{servidor}/falecimento', 'Admin\Servidor\ServidorController@falecimentoForm')->name('admin.servidores.falecimento-form');
        Route::post('servidores/{servidor}/falecimento', 'Admin\Servidor\ServidorController@atualizaFalecimento')->name('admin.servidores.atualiza-falecimento');

        Route::post('servidores/{servidor}/restore', 'Admin\Servidor\ServidorController@restore')->name('admin.servidores.restore');
        Route::get('servidores/create/simplificado', 'Admin\Servidor\ServidorController@createSimplificado')->name('admin.servidores.create-simplificado');
        Route::get('servidores/api/endereco-uor/{idUnidade}', 'Admin\Servidor\ServidorController@getEnderecoUnidadeOrganizacional')->name('admin.servidores.api.endereco-uor');
        Route::resource('servidores', 'Admin\Servidor\ServidorController', ['as' => 'admin'])
            ->parameters(['servidores' => 'servidor']);
        Route::resource('servidores.dependentes', 'Admin\Servidor\DependenteServidorController', ['as' => 'admin'])
            ->parameters(['servidores' => 'servidor']);
        Route::resource('servidores.enderecos', 'Admin\Servidor\EnderecoServidorController', ['as' => 'admin'])
            ->parameters(['servidores' => 'servidor']);
        Route::resource('servidores.convenios', 'Admin\Servidor\ConvenioServidorController', ['as' => 'admin'])
            ->parameters(['servidores' => 'servidor']);
        Route::resource('servidores.dependentes.convenios', 'Admin\Servidor\ConvenioDependenteController', ['as' => 'admin'])
            ->parameters(['servidores' => 'servidor']);
        Route::resource('servidores.registros', 'Admin\Servidor\RegistroServidorController', ['as' => 'admin'])
            ->parameters(['servidores' => 'servidor']);
        Route::resource('servidores.movimentacoes', 'Admin\Servidor\MovimentacaoServidorController', ['as' => 'admin'])
            ->parameters(['servidores' => 'servidor', 'movimentacoes' => 'movimentacao']);

        Route::get('servidores/{servidor}/documentos/{documento}/download', 'Admin\Servidor\DocumentoAssociadoController@download')->name('admin.servidores.documentos.download');
        Route::resource('servidores.documentos', 'Admin\Servidor\DocumentoAssociadoController', ['as' => 'admin'])
            ->parameters(['servidores' => 'servidor', 'documentos' => 'documento']);

        Route::resource('auditoria', 'Admin\AuditoriaController', ['as' => 'admin'])
            ->only(['index', 'show'])
            ->parameters(['auditoria' => 'log']);

        Route::get('movimento-caixa', 'Admin\MovimentoCaixaController@index')->name('admin.movimento-caixa.index');

        Route::resource('prestadores-servicos', 'Admin\PrestadorServicoController', ['as' => 'admin'])
            ->parameters(['prestadores-servicos' => 'prestador']);
        Route::resource('prestadores-servicos.horarios-trabalho', 'Admin\HorarioTrabalhoPrestadorController', ['as' => 'admin'])
            ->parameters(['prestadores-servicos' => 'prestador', 'horarios-trabalho' => 'horario']);

        Route::resource('servicos-atendimentos', 'Admin\ServicoAtendimentoController', ['as' => 'admin'])
            ->parameters(['servicos-atendimentos' => 'servico']);
        Route::resource('servicos-atendimentos.horarios-trabalho', 'Admin\HorarioTrabalhoServicoAtendimentoController', ['as' => 'admin'])
            ->parameters(['servicos-atendimentos' => 'servico', 'horarios-trabalho' => 'horario']);

        Route::resource('funcionarios', 'Admin\Funcionario\FuncionarioController', ['as' => 'admin']);
        Route::resource('funcionarios.dependentes', 'Admin\Funcionario\DependenteFuncionarioController', ['as' => 'admin']);
        Route::resource('funcionarios.convenios', 'Admin\Funcionario\ConvenioFuncionarioController', ['as' => 'admin'])
            ->parameters(['funcionarios' => 'funcionario']);
        Route::resource('funcionarios.dependentes.convenios', 'Admin\Funcionario\ConvenioDependenteController', ['as' => 'admin'])
            ->parameters(['funcionarios' => 'funcionario']);
        Route::resource('funcionarios.dependentes.convenios', 'Admin\Funcionario\ConvenioDependenteController', ['as' => 'admin'])
            ->parameters(['funcionarios' => 'funcionario']);

        Route::resource('especialidades-convenios', 'Admin\EspecialidadeConvenioController', ['as' => 'admin'])
            ->parameters(['especialidades-convenios' => 'especialidade']);

        Route::resource('convenios', 'Admin\ConvenioController', ['as' => 'admin']);

        Route::post('perguntas-anamnese/{pergunta}/restore', 'Admin\PerguntaAnamneseController@restore')->name('admin.perguntas-anamnese.restore');
        Route::resource('perguntas-anamnese', 'Admin\PerguntaAnamneseController', ['as' => 'admin'])
            ->parameters(['perguntas-anamnese' => 'pergunta']);

        Route::get('envio-sms', 'Admin\EnvioSMSController@mensagensEnviadas')
            ->name('admin.envio-sms.mensagens-enviadas');
        Route::get('envio-sms/escrever-mensagem', 'Admin\EnvioSMSController@escreverMensagemForm')
            ->name('admin.envio-sms.escrever-mensagem-form');
        Route::post('envio-sms/escrever-mensagem', 'Admin\EnvioSMSController@armazenaMensagem')
            ->name('admin.envio-sms.armazena-mensagem');
        Route::get('envio-sms/selecao-contatos', 'Admin\EnvioSMSController@selecaoContatosForm')
            ->name('admin.envio-sms.selecao-contatos-form');
        Route::post('envio-sms/selecao-contatos', 'Admin\EnvioSMSController@armazenaContatos')
            ->name('admin.envio-sms.armazena-contatos');
        Route::get('envio-sms/envia', 'Admin\EnvioSMSController@enviaForm')
            ->name('admin.envio-sms.envia-form');
        Route::post('envio-sms/envia', 'Admin\EnvioSMSController@envia')
            ->name('admin.envio-sms.envia');

        Route::resource('motivos-registros-atendimento', 'Admin\MotivoRegistroAtendimentoController', ['as' => 'admin'])
            ->parameters(['motivos-registros-atendimento' => 'motivo']);

        Route::resource('motivos-filiacao', 'Admin\MotivoFiliacaoController', ['as' => 'admin'])
            ->parameters(['motivos-filiacao' => 'motivo']);

        Route::get('guia-atendimento/buscar', 'Admin\GuiaAtendimentoController@buscar')->name('admin.guia-atendimento.buscar');
        Route::get('guia-atendimento', 'Admin\GuiaAtendimentoController@index')->name('admin.guia-atendimento.index');
        Route::get('guia-atendimento/{atendimento}/edit', 'Admin\GuiaAtendimentoController@edit')->name('admin.guia-atendimento.edit');
        Route::put('guia-atendimento/{atendimento}', 'Admin\GuiaAtendimentoController@update')->name('admin.guia-atendimento.update');
        Route::get('guia-atendimento/atender/{servidor}', 'Admin\GuiaAtendimentoController@create')->name('admin.guia-atendimento.create');
        Route::post('guia-atendimento/atender/{servidor}', 'Admin\GuiaAtendimentoController@store')->name('admin.guia-atendimento.store');
        Route::get('guia-atendimento/buscar-servidor', 'Admin\GuiaAtendimentoController@buscaServidor')->name('admin.guia-atendimento.busca-servidor');

        Route::get('/geracao-carteirinha', 'Admin\GeracaoCarteirinhaController@index')->name('admin.geracao-carteirinha.index');
        Route::post('/geracao-carteirinha', 'Admin\GeracaoCarteirinhaController@gera')->name('admin.geracao-carteirinha.gera');

        Route::get('exportacao-csv', 'Admin\ExportacaoCSVController@index')->name('admin.exportacao-csv.index');
        Route::post('exportacao-csv', 'Admin\ExportacaoCSVController@exporta')->name('admin.exportacao-csv.exporta');

        Route::resource('mensalidades', 'Admin\MensalidadeNivelController', ['as' => 'admin']);

        Route::resource('configuracoes', 'Admin\ConfiguracaoController', ['as' => 'admin'])
            ->parameters(['configuracoes' => 'configuracao']);

        Route::resource('niveis-salariais', 'Admin\NivelSalarialController', ['as' => 'admin'])
            ->parameters(['niveis-salariais' => 'nivel']);

        Route::resource('tipos-acoes-processos', 'Admin\TipoAcaoProcessoController', ['as' => 'admin'])
            ->parameters(['tipos-acoes-processos' => 'tipo']);
        Route::resource('competencias-processos', 'Admin\CompetenciaProcessoController', ['as' => 'admin'])
            ->parameters(['competencias-processos' => 'competencia']);

        Route::get('/', 'Admin\HomeController@index')->name('admin.home');
    });
});
