@php
    $tipoTelefone = $tipoTelefone ?? 'fixo';
    $name = $name ?? 'telefone[]';
    $label = $label ?? "Telefone {$tipoTelefone}";
    $valor = $valor ?? '';
    $observacoes = $observacoes ?? '';
    $obrigatorio = $obrigatorio ?? false;
    $malaDiretaChecked = $malaDiretaChecked ?? false;
    $malaDireta = $malaDireta ?? false;
@endphp
<div class="form-group col-3">
    <label for="{{ $name.'[numero]' }}">{{ $label }} {{ $obrigatorio ? '*' : '' }}</label>
    <input {{ $obrigatorio ? 'required' : '' }} type="text" name="{{ $name.'[numero]' }}" class="form-control telefone-{{ $tipoTelefone }} @error($name) is-invalid @enderror" value="{{ old('name') ?? $valor}}">
    <input type="text" name="{{ $name.'[observacoes]' }}" class="form-control" value="{{ old('name') ?? $observacoes}}" maxlength="50" placeholder="Observações">

    @if ($tipoTelefone == 'celular' && $malaDireta)
    <div class="form-check">
        <input class="form-check-input" type="checkbox" value="" id="check-mala-direta" name="{{ $name.'[mala_direta]' }}" {{ $malaDiretaChecked ? 'checked' : '' }}>
        <label class="form-check-label" for="check-mala-direta">
            Enviar mala direta?
        </label>
    </div>
    @endif
</div>