<table class="table mt-3">
    <thead>
        <tr>
            <th>Número</th>
            <th>Regime</th>
            <th>Cargo</th>
            <th>Nível</th>
            <th>Data admissão</th>
            <th>Unidade</th>
            <th>Centro custo</th>
            <th class="w-25">Ação</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($registros as $registro)
        @php
        $nivelSalarial = null;
        if ($registro->cargoReadaptado) {
        $nivelSalarial = $this->cargoReadaptado->nivelSalarial;
        }
        else if ($registro->cargo) {
        $nivelSalarial = $registro->cargo->nivelSalarial;
        }

        @endphp
        <tr>
            <td>{{ $registro->numero }}</td>
            <td>{{ $registro->regime->getValue() }}</td>
            <td>{{ optional($registro->cargo)->nome }}</td>
            <td>{{ optional($nivelSalarial)->nome }}</td>
            <td>{{ optional($registro->data_admissao)->format('d/m/Y') }}</td>
            <td>{{ optional($registro->unidadeOrganizacional)->hierarquiaExtenso() }}</td>
            <td>{{ optional($registro->unidadeOrganizacional)->centro_custo }}</td>
            <td>
                @button([
                'route' => 'admin.servidores.registros.edit',
                'routeParams' => ['servidor' => $servidor, 'registro' => $registro],
                'class' => 'btn-primary',
                'label' => 'Visualizar/Editar',
                'icon' => 'edit'
                ])
                @endbutton
                @button([
                'class' => 'btn-danger btn-excluir-registro',
                'icon' => 'x',
                'label' => 'Excluir',
                'route' => 'admin.servidores.registros.destroy',
                'routeParams' => ['servidor' => $servidor, 'registro' => $registro],
                ])
                @endbutton
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
