@php
$container = $container ?? 'col-12 row';
$obrigatorio = $obrigatorio ?? false;
$malaDireta = $malaDireta ?? false;
$malaDiretaChecked = $malaDiretaChecked ?? false;
@endphp

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/endereco.js') }}"></script>
@endpush

<input type="hidden" id="hidden-url-logradouro-api-cep" value="{{ route('api.logradouro-api.busca-cep') }}">
<div class="{{ $container }} endereco">
    <div class="col-3">
        <label for="cep">CEP {{ $obrigatorio ? '*' : '' }}</label>
        <div class="input-group">
            <input type="text" id="text-cep" data-mask="00000-000" data-mask-clearifnotmatch="true" {{ $obrigatorio ? 'required' : '' }} name="cep" maxlength="8" class="form-control cep @error('cep') is-invalid @enderror" value="{{ old('cep') ?? $endereco->cep ?? '' }}">
            <div class="input-group-append">
                <button class="btn btn-outline-secondary" type="button" id="btn-busca-cep"><i data-feather="search"></i></button>
            </div>
        </div>
    </div>
    <div class="form-group col-4">
        <label for="logradouro">Logradouro {{ $obrigatorio ? '*' : '' }}</label>
        <input type="text" {{ $obrigatorio ? 'required' : '' }} id="text-logradouro" name="logradouro" maxlength="150" class="form-control logradouro @error('logradouro') is-invalid @enderror" value="{{ old('logradouro') ?? $endereco->logradouro ?? '' }}">
    </div>
    <div class="form-group col-2">
        <label for="numero">Número {{ $obrigatorio ? '*' : '' }}</label>
        <input type="text" {{ $obrigatorio ? 'required' : '' }} id="text-numero" name="numero" maxlength="150" class="form-control numero @error('numero') is-invalid @enderror" value="{{ old('numero') ?? $endereco->numero ?? '' }}">
    </div>
    <div class="form-group col-3">
        <label for="complemento">Complemento</label>
        <input type="text" name="complemento" maxlength="50" class="form-control complemento_endereco @error('complemento') is-invalid @enderror" value="{{ old('complemento') ?? $endereco->complemento ?? '' }}">
    </div>
    <div class="form-group col-3">
        <label for="bairro">Bairro {{ $obrigatorio ? '*' : '' }}</label>
        <input type="text" {{ $obrigatorio ? 'required' : '' }} id="text-bairro" name="bairro" maxlength="50" class="form-control bairro @error('bairro') is-invalid @enderror" value="{{ old('bairro') ?? $endereco->bairro ?? '' }}">
    </div>
    <div class="form-group col-4">
        <label for="cidade">Cidade {{ $obrigatorio ? '*' : '' }}</label>
        <input type="text" {{ $obrigatorio ? 'required' : '' }} id="text-cidade" name="cidade" maxlength="100" class="form-control cidade @error('cidade') is-invalid @enderror" value="{{ old('cidade') ?? $endereco->cidade ?? '' }}">
    </div>
    <div class="form-group col-2">
        <label for="estado">Estado {{ $obrigatorio ? '*' : '' }}</label>
        <select name="estado" {{ $obrigatorio ? 'required' : '' }} id="select-estado" class="form-control estado @error('estado') is-invalid @enderror">
            @php
            $estadoSelecionado = old('estado', 'SP') ?? optional($endereco->estado);
            @endphp
            @foreach ($estados as $estado)
            <option value="{{ $estado->ufe_sg }}" {{ $estadoSelecionado == $estado->ufe_sg ? 'selected' : '' }}>{{ $estado->ufe_sg }}</option>
            @endforeach
        </select>
    </div>
    <div class="form-group col-3">
        <label for="observacoes_endereco">Obs. endereço</label>
        <input type="text" name="observacoes_endereco" maxlength="100" class="form-control observacoes_endereco @error('observacoes_endereco') is-invalid @enderror" value="{{ old('observacoes_endereco') ?? $endereco->observacoes ?? '' }}">
    </div>
    @if ($malaDireta)
    <div class="form-check col-4">
        <label for="check-mala-direta" class="">
            Enviar mala direta?
        </label>
        <input type="checkbox" id="check-mala-direta" name="aceita_mala_direta" {{ $malaDiretaChecked ? 'checked' : '' }}>
    </div>
    @endif
</div>
<div class="modal fade" id="modal-busca-logradouro" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
        <input type="hidden" id="hidden-url-busca-logradouro-api" value="{{ route('api.logradouro-api.busca-logradouro') }}">
        @csrf
        <div class="modal-content">
            <div class="modal-header">
                <h4>Busca de logradouro</h4>
            </div>
            <div class="modal-body">
                <div id="div-alert" class="alert alert-danger alert-dismissible" role="alert">
                    <p></p>
                </div>

                <div class="form-row">
                    <div class="form-group col-10">
                        <label for="busca-logradouro">Logradouro *</label>
                        <input type="text" id="text-busca-logradouro" name="busca-logradouro" maxlength="150" class="form-control">
                    </div>
                    <div class="form-group col-2">
                        <label for="busca-numero">Número</label>
                        <input type="text" id="text-busca-numero" name="busca-numero" maxlength="150" class="form-control numero @error('numero') is-invalid @enderror">
                    </div>
                </div>
                <div class="form-row" id="div-resultado">
                    <table class="table mt-3" id="table-resultado">
                        <thead>
                            <tr>
                                <th>Logradouro</th>
                                <th>Bairro</th>
                                <th>Cidade</th>
                                <th>Estado</th>
                                <th>CEP</th>
                                <th class="w-25">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-busca-logradouro" class="btn btn-primary">Buscar</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>