@extends('layouts.admin-guest')

@section('title')
    Redefina sua senha
@endsection

@section('content')
<!-- Main Content -->
    <div class="hk-pg-wrapper hk-auth-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12 pa-0">
                    <div class="auth-form-wrap pt-xl-0 pt-70">
                        <div class="auth-form w-xl-30 w-sm-50 w-100">
                            <form method="POST" action="{{ route('password.email') }}">
                                <h1 class="display-5 mb-30 text-center">Redefina sua senha</h1>

                                @alerts
                                @endalerts

                                @csrf
                                <div class="form-group">
                                    <input name="email" id="email" class="form-control @error('email') is-invalid @enderror" placeholder="E-mail" type="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <button class="btn btn-primary btn-block mb-20" type="submit">Redefinir</button>
                                <p class="text-right"><a href="{{ route('login') }}">Voltar para login</a></p>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
