@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/usuarios/perfis.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page">Usuários</li>
        <li class="breadcrumb-item" aria-current="page">{{ $usuario->name }}</li>
        <li class="breadcrumb-item active" aria-current="page">Perfis</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Perfis
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @button([
                'route' => 'admin.usuarios.perfis.create',
                'routeParams' => ['usuario' => $usuario],
                'icon' => 'plus',
                'label' => 'Incluir perfil',
                'class' => 'btn-primary'
                ])
                @endbutton

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Perfil</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($perfis as $perfil)
                        <tr>
                            <td>{{ Str::ucfirst($perfil->name) }}</td>
                            <td>
                                @button([
                                'class' => 'btn-danger btn-excluir-perfil',
                                'route' => 'admin.usuarios.perfis.destroy',
                                'routeParams' => ['usuario' => $usuario, 'perfil' => $perfil],
                                'icon' => 'x',
                                'label' => 'Excluir',
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-perfil" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-perfil">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o perfil?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection