@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/usuarios.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Usuários</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Usuários
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @button([
                'route' => 'admin.usuarios.create',
                'icon' => 'plus',
                'label' => 'Novo Usuário',
                'class' => 'btn-primary'
                ])
                @endbutton

                @busca([
                'route' => 'admin.usuarios.index',
                'busca' => $busca
                ])
                @endbusca

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>E-mail</th>
                            <th>Funcionário</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($users as $user)
                        <tr>
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td>{{ $user->funcionario->nome ?? '' }}</td>
                            <td>
                                @button([
                                'route' => 'admin.usuarios.edit',
                                'routeParams' => ['usuario' => $user],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-usuario',
                                'route' => 'admin.usuarios.destroy',
                                'routeParams' => ['usuario' => $user],
                                'icon' => 'x',
                                'label' => 'Excluir',
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $users->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-usuario" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-usuario">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o usuário?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection