@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.usuarios.index') }}">Usuários</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar usuário
        </h4>
    </div>
    <!-- /Title -->

    <form action="{{ route('admin.usuarios.update', ['usuario' => $usuario]) }}" method="post">
        @csrf
        @method('PUT')
        @alerts
        @endalerts
        <section class="hk-sec-wrapper">
            <div class="form-row">
                <div class="form-group col-12 col-md-4">
                    <label for="name">Nome *</label>
                    <input type="text" autofocus name="name" class="form-control @error('name') is-invalid @enderror" value="{{ $usuario->name }}">
                </div>
                <div class="form-group col-12 col-md-4">
                    <label for="email">E-mail *</label>
                    <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ $usuario->email }}">
                </div>
                <div class="form-group col-12 col-md-4">
                    <label for="funcionario_id">Funcionário</label>
                    <select name="funcionario_id" class="form-control @error('funcionario_id') is-invalid @enderror">
                        <option value=""></option>
                        @foreach ($funcionarios as $funcionario)
                        <option value="{{ $funcionario->id }}" {{ isset($usuario->funcionario) && $usuario->funcionario->id == $funcionario->id ? 'selected' : '' }}>{{ $funcionario->nome }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-12 col-md-4">
                    <label for="prestador_servico_id">Prestador</label>
                    <select name="prestador_servico_id" class="form-control @error('prestador_servico_id') is-invalid @enderror">
                        <option value=""></option>
                        @foreach ($prestadores as $prestador)
                        <option value="{{ $prestador->id }}" {{ isset($usuario->prestador) && $usuario->prestador->id == $prestador->id ? 'selected' : '' }}>{{ $prestador->nome }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <hr>
            @button([
            'icon' => 'save',
            'label' => 'Salvar',
            'class' => 'btn-primary'
            ])
            @endbutton
            @button([
            'route' => 'admin.usuarios.alterar-senha',
            'routeParams' => ['usuario' => $usuario],
            'icon' => 'user',
            'label' => 'Alterar senha',
            'class' => 'btn-primary'
            ])
            @endbutton
            @button([
            'route' => 'admin.usuarios.perfis.index',
            'routeParams' => ['usuario' => $usuario],
            'icon' => 'list',
            'label' => 'Perfis',
            'class' => 'btn-primary'
            ])
            @endbutton
            @button([
            'route' => 'admin.usuarios.index',
            'icon' => 'arrow-left',
            'label' => 'Voltar',
            'class' => 'btn-secondary'
            ])
            @endbutton
        </section>
    </form>
</div>
@endsection