@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/usuarios/alterar-senha.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.usuarios.index') }}">Usuário</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.usuarios.edit', ['usuario' => $usuario]) }}">{{ $usuario->name }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Alterar senha</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Alterar senha
        </h4>
    </div>
    <!-- /Title -->

    <form action="{{ route('admin.usuarios.alterar-senha', ['usuario' => $usuario]) }}" method="post">
        @csrf
        @method('PUT')

        @alerts
        @endalerts
        <div class="form-row">
            <div class="form-group col-6">
                <label for="senha_nova">Senha nova (min. 8 caracteres) *</label>
                <input id="senha_nova" name="senha_nova" type="password" class="form-control @error('senha_nova') is-invalid @enderror">
            </div>
            <div class="form-group col-6">
                <label for="senha_nova_confirmation">Confirmação *</label>
                <input id="senha_nova_confirmation" name="senha_nova_confirmation" type="password" class="form-control @error('senha_nova_confirmation') is-invalid @enderror">
            </div>
        </div>
        @button([
        'icon' => 'save',
        'label' => 'Alterar senha',
        'class' => 'btn-primary'
        ])
        @endbutton
        @button([
        'route' => 'admin.usuarios.edit',
        'routeParams' => ['usuario' => $usuario],
        'class' => 'btn-secondary',
        'label' => 'Voltar',
        'icon' => 'arrow-left'
        ])
        @endbutton
    </form>
</div>
@endsection