@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.unidades-organizacionais.index') }}">Unidade Organizacional</a></li>
        <li class="breadcrumb-item active" aria-current="page"><a href="{{ route('admin.unidades-organizacionais.edit', ['unidade' => $unidade]) }}">Editar</a></li>
        <li class="breadcrumb-item active" aria-current="page">Transferir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Transferir unidade organizacional
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts
                @include('admin.unidades-organizacionais.listagem-transferencia', ['unidades' => $unidades, 'unidadeTransferir' => $unidade])

                <hr>
                @button([
                'icon' => 'save',
                'label' => 'Salvar',
                'class' => 'btn-primary'
                ])
                @endbutton
                @if ($unidade->superior)
                @button([
                'route' => 'admin.unidades-organizacionais.edit',
                'routeParams' => ['unidade' => $unidade->superior],
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ])
                @endbutton
                @else
                @button([
                'route' => 'admin.unidades-organizacionais.index',
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ])
                @endbutton
                @endif
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5>{{ session('status') }}</h5>
            </div>
            <div class="modal-body">
                <p>Deseja continuar e editar a unidade ou voltar para página anterior?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="btn-continuar">Continuar e editar</button>
                <button type="button" class="btn btn-secondary" id="btn-voltar">Voltar</button>
            </div>
        </div>
    </div>
</div>
@endsection
