@push('js')
<script src="{{ asset('js/admin/unidades-organizacionais/listagem.js') }}"></script>
@endpush

<table class="table mt-3">
    <thead>
        <tr>
            <th>Nome</th>
            <th>Sigla</th>
            <th>Hierarquia</th>
            <th>Centro de custo</th>
            <th class="w-25">Ação</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($unidades as $unidade)
        <tr>
            <td>{{ $unidade->nome }}</td>
            <td>{{ $unidade->sigla }}</td>
            <td>{{ $unidade->hierarquiaExtenso() }}</td>
            <td>{{ $unidade->centro_custo }}</td>
            <td>
                @button([
                'route' => 'admin.unidades-organizacionais.edit',
                'routeParams' => ['unidade' => $unidade],
                'class' => 'btn-primary',
                'label' => 'Visualizar/Editar',
                'icon' => 'edit'
                ])
                @endbutton
                @button([
                'class' => 'btn-danger btn-excluir-unidade',
                'icon' => 'x',
                'label' => 'Excluir',
                'route' => 'admin.unidades-organizacionais.destroy',
                'routeParams' => ['unidade' => $unidade],
                ])
                @endbutton
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
<div class="modal fade" id="modal-excluir-unidade" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-unidade">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir a unidade?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
{{ $unidades->links() }}
