@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/unidades-organizacionais/create-edit.js') }}"></script>
<script src="{{ asset('js/admin/telefones.js') }}"></script>
<script src="{{ asset('js/admin/emails.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.unidades-organizacionais.index') }}">Unidade Organizacional</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar unidade organizacional
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.unidades-organizacionais.update', ['unidade' => $unidade]) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <input type="hidden" id="hidden-sucesso" value="{{ session('sucesso') }}">
                    <input type="hidden" id="hidden-rota-voltar" value="{{ session('rotaVoltar') }}">

                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="nome">Nome *</label>
                            <input type="text" autofocus name="nome" maxlength="100" class="form-control @error('nome') is-invalid @enderror" value="{{ $unidade->nome }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="sigla">Sigla</label>
                            <input type="text" name="sigla" maxlength="15" class="form-control @error('sigla') is-invalid @enderror" value="{{ $unidade->sigla }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="centro_custo">Centro de custo</label>
                            <input type="text" name="centro_custo" maxlength="11" class="form-control @error('centro_custo') is-invalid @enderror" value="{{ $unidade->centro_custo }}">
                        </div>
                        @include('components.endereco', ['container' => 'form-row', 'obrigatorio' => false, 'endereco' => $unidade->enderecos->first()])
                        <div class="form-group col-5">
                            <label for="hierarquia">Hierarquia</label>
                            <input type="text" readonly name="hierarquia" class="form-control-plaintext" value="{{ $unidade->hierarquiaExtenso() }}">
                        </div>
                        @include('components.telefones', ['telefones' => $unidade->contatos()->telefones()->get(), 'malaDireta' => true, 'container' => 'form-row col-12'])
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    <button id="btn-incluir-fixo" type="button" class="btn btn-primary"><i data-feather="plus"></i> Telefone fixo</button>
                    <button id="btn-incluir-celular" type="button" class="btn btn-primary"><i data-feather="plus"></i> Telefone celular</button>
                    @button([
                    'route' => 'admin.unidades-organizacionais.transferir-form',
                    'routeParams' => ['unidade' => $unidade],
                    'icon' => 'move',
                    'label' => 'Transferir',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @if ($unidade->superior)
                    @button([
                    'route' => 'admin.unidades-organizacionais.edit',
                    'routeParams' => ['unidade' => $unidade->superior],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @else
                    @button([
                    'route' => 'admin.unidades-organizacionais.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @endif
                </form>
            </section>
            <section class="hk-sec-wrapper">
                <div class="hk-pg-header">
                    <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
                        Unidades abaixo
                    </h4>
                </div>
                @button([
                'route' => 'admin.unidades-organizacionais-create-subordinada',
                'routeParams' => ['superior' => $unidade],
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                @include('admin.unidades-organizacionais.listagem', ['unidades' => $unidade->subordinada()->paginate()])
            </section>



        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5>{{ session('status') }}</h5>
            </div>
            <div class="modal-body">
                <p>Deseja continuar e editar a unidade ou voltar para página anterior?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="btn-continuar">Continuar e editar</button>
                <button type="button" class="btn btn-secondary" id="btn-voltar">Voltar</button>
            </div>
        </div>
    </div>
</div>
@endsection
