@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/servidores/registros/create-edit.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidor</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $servidor]) }}">{{ $servidor->nome }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.movimentacoes.index', ['servidor' => $servidor]) }}">Movimentações</a></li>
        <li class="breadcrumb-item active" aria-current="page">Exibir movimentação</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Exibir movimentação
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <div class="form-row">
                    <div class="form-group col-3">
                        <label for="evento">Evento</label>
                        <input type="text" name="evento" class="form-control-plaintext" value="{{ $movimentacao->evento }}">
                    </div>
                    <div class="form-group col-4">
                        <label for="user">Usuário</label>
                        <input type="text" name="user" class="form-control-plaintext" value="{{ $movimentacao->user->name }}">
                    </div>
                    <div class="form-group col-2">
                        <label for="data">Data/hora</label>
                        <input type="text" name="data" class="form-control-plaintext" value="{{ $movimentacao->created_at->format('d/m/Y H:i:s') }}">
                    </div>
                    <div class="form-group col-6">
                        <label>
                            @if ($movimentacao->evento->isEdicao())
                                Alterações
                            @elseif ($movimentacao->evento->isInclusao())
                                Cadastro
                            @endif
                        </label>
                        <div class="text-dark">
                            @foreach ($movimentacao->payload as $campo => $valor)
                                <p>{{ $campo }}: {{ $valor }}</p>
                            @endforeach
                        </div>
                    </div>
                </div>

                <hr>
                @button([
                'route' => 'admin.servidores.movimentacoes.index',
                'routeParams' => ['servidor' => $servidor],
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ])
                @endbutton
            </section>
        </div>
    </div>
</div>
@endsection