@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/servidores/registros/create-edit.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidor</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $servidor]) }}">{{ $servidor->nome }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Movimentações</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Movimentações
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Descrição</th>
                            <th>Informação</th>
                            <th>Data</th>
                            <th>Usuário</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($movimentacoes as $movimentacao)
                        <tr>
                            <td>{{ $movimentacao->descricao }}</td>
                            <td>
                                @if ($movimentacao->evento->isEdicao())
                                @foreach ($movimentacao->payload as $campo => $valor)
                                {{ $campo }}: {{ $valor }}
                                @endforeach
                                @endif
                            </td>
                            <td>{{ $movimentacao->created_at->format('d/m/Y H:i:s') }}</td>
                            <td>{{ $movimentacao->user->name }}</td>
                            <td>
                                @button([
                                'route' => 'admin.servidores.movimentacoes.show',
                                'routeParams' => ['servidor' => $servidor, 'movimentacao' => $movimentacao],
                                'class' => 'btn-primary',
                                'label' => 'Exibir',
                                'icon' => 'eye'
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $movimentacoes->links() }}

                <hr>
                @button([
                'route' => 'admin.servidores.edit',
                'routeParams' => ['servidor' => $servidor],
                'icon' => 'arrow-left',
                'label' => 'Voltar',
                'class' => 'btn-secondary'
                ])
                @endbutton
            </section>
        </div>
    </div>
</div>
@endsection
