@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/documentos-associados.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidor</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $servidor]) }}">{{ $servidor->nome }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar documento</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Documentos
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @button([
                'route' => 'admin.servidores.documentos.create',
                'routeParams' => ['servidor' => $servidor],
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Tipo</th>
                            <th>Observações</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($documentos as $documento)
                        <tr>
                            <td>{{ $documento->tipo->nome }}</td>
                            <td>{{ $documento->observacoes }}</td>
                            <td>
                                @button([
                                'route' => 'admin.servidores.documentos.edit',
                                'routeParams' => ['documento' => $documento, 'servidor' => $servidor],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'route' => 'admin.servidores.documentos.download',
                                'routeParams' => ['documento' => $documento, 'servidor' => $servidor],
                                'class' => 'btn-primary',
                                'label' => 'Baixar',
                                'icon' => 'download'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-documento',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.servidores.documentos.destroy',
                                'routeParams' => ['documento' => $documento, 'servidor' => $servidor],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $documentos->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-documento" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-documento">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o documento?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection