@extends('layouts.admin')

@push('css')
<link href="{{ asset('css/admin/servidores-create-edit.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/servidores/desfilia.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidores</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $servidor]) }}">{{ $servidor->nome }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Desfiliar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Desfiliar servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.servidores.desfilia', ['servidor' => $servidor]) }}" method="post">
                    @csrf

                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="matricula">Matrícula</label>
                            <input type="text" name="matricula" maxlength="100" readonly class="form-control-plaintext" value="{{ $matricula->id }}">
                        </div>
                        @if ($servidor->eAssociado())
                        <div class="form-group col-2">
                            <label for="tipo_desligamento">Tipo *</label>
                            <select name="tipo_desligamento" id="tipo_desligamento" class="form-control">
                                @foreach ($tipos as $tipo)
                                <option value="{{ $tipo->getIndex() }}" @if(old('tipo_desligamento')==$tipo->getIndex()) selected @endif>{{ $tipo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-4" id="div-motivo-temporario">
                            <label for="motivo_desligamento_temporario">Motivo *</label>
                            <select class="form-control" id="motivo_desligamento_temporario" name="motivo_desligamento_temporario">
                                <option value=""></option>
                                @foreach ($motivosTemporario as $motivo)
                                <option value="{{ $motivo->getIndex() }}" @if(old('motivo_desligamento_temporario')==$motivo->getindex()) selected @endif>{{ $motivo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-4" id="div-motivo-definitivo">
                            <label for="motivo_desligamento_definitivo">Motivo *</label>
                            <select class="form-control" id="motivo_desligamento_definitivo" name="motivo_desligamento_definitivo">
                                <option value=""></option>
                                @foreach ($motivosDefinitivo as $motivo)
                                <option value="{{ $motivo->getIndex() }}" @if(old('motivo_desligamento_definitivo')==$motivo->getindex()) selected @endif>{{ $motivo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        @elseif ($servidor->desfiliadoTemporariamente())
                        <div class="form-group col-6" id="div-motivo-definitivo">
                            <label for="motivo_desligamento_definitivo">Motivo *</label>
                            <select class="form-control" id="motivo_desligamento_definitivo" name="motivo_desligamento_definitivo">
                                <option value=""></option>
                                @foreach ($motivosDefinitivo as $motivo)
                                <option value="{{ $motivo->getIndex() }}" @if(old('motivo_desligamento_definitivo')==$motivo->getindex()) selected @endif>{{ $motivo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        @endif
                        <div class="form-group col-2">
                            <label for="data_desligamento">Data *</label>
                            <input type="text" required name="data_desligamento" data-mask="00/00/0000" data-mask-clearifnotmatch="true" class="form-control  @error('data_desligamento') is-invalid @enderror" value="{{ old('data_desligamento', today()->format('d/m/Y')) }}">
                        </div>
                        <div class="form-group col-2" id="div-data-falecimento">
                            <label for="data_falecimento">Data falecimento</label>
                            <input type="text" name="data_falecimento" data-mask="00/00/0000" data-mask-clearifnotmatch="true" class="form-control  @error('data_falecimento') is-invalid @enderror" value="{{ old('data_falecimento') }}">
                        </div>
                        <div class="form-group col-2" id="div-data-publicacao-portaria">
                            <label for="data_publicacao_portaria">Data portaria</label>
                            <input type="text" name="data_publicacao_portaria" data-mask="00/00/0000" data-mask-clearifnotmatch="true" class="form-control  @error('data_publicacao_portaria') is-invalid @enderror" value="{{ old('data_publicacao_portaria') }}">
                        </div>
                        <div class="form-group col-3" id="div-mes-ano-parou-desconto">
                            <label for="mes_ano_parou_desconto">Mês/ano parou desconto</label>
                            <input type="text" name="mes_ano_parou_desconto" data-mask="00/0000" data-mask-clearifnotmatch="true" class="form-control  @error('mes_ano_parou_desconto') is-invalid @enderror" value="{{ old('mes_ano_parou_desconto') }}">
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Desfiliar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton

                    @button([
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection
