@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('css/admin/registros-servidores-create-edit.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('css/admin/servidores-create-edit.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('vendors/select2/dist/js/select2.full.min.js') }}"></script>
<script src="{{ asset('js/admin/servidores/create.js') }}"></script>
<script src="{{ asset('js/admin/telefones.js') }}"></script>
<script src="{{ asset('js/admin/emails.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidores</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form id="form-servidor" action="{{ route('admin.servidores.store') }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <input type="hidden" name="redirect_to" value="{{ $redirectTo }}">
                    <input type="hidden" id="hidden-url-api-endereco-uor" value="{{ url('admin/servidores/api/endereco-uor') }}">

                    <h5 class="hk-pg-title">
                        Dados gerais
                    </h5>
                    <hr>
                    <div class="form-row">
                        <div class="col-9">
                            <div class="form-row">
                                <div class="form-group col-6">
                                    <label for="nome">Nome *</label>
                                    <input type="text" autofocus name="nome" maxlength="150" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome') }}">
                                </div>
                                <div class="form-group col-6">
                                    <label for="nome_social">Nome social</label>
                                    <input type="text" name="nome_social" maxlength="150" class="form-control @error('nome_social') is-invalid @enderror" value="{{ old('nome_social') }}">
                                </div>
                                <div class="form-group col-4">
                                    <label for="cpf">CPF *</label>
                                    <input type="text" name="cpf" required maxlength="14" class="cpf form-control @error('cpf') is-invalid @enderror" value="{{ old('cpf') }}">
                                </div>
                                <div class="form-group col-4">
                                    <label for="rg">RG</label>
                                    <input type="text" name="rg" maxlength="15" class="form-control @error('rg') is-invalid @enderror" value="{{ old('rg') }}">
                                </div>
                                <div class="form-group col-4">
                                    <label for="estado_civil">Estado civil</label>
                                    <select name="estado_civil" class="form-control @error('estado_civil') is-invalid @enderror" value="{{ old('estado_civil') }}">
                                        <option value=""></option>
                                        @foreach ($estadosCivis as $estadoCivil)
                                        <option value="{{ $estadoCivil->getIndex() }}">{{ $estadoCivil->getValue() }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-3">
                                    <label for="sexo">Sexo</label>
                                    <select name="sexo" class="form-control @error('sexo') is-invalid @enderror" value="{{ old('sexo') }}">
                                        <option value=""></option>
                                        @foreach ($sexos as $sexo)
                                        <option value="{{ $sexo->getIndex() }}">{{ $sexo->getValue() }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-3">
                                    <label for="data_nascimento">Data de nascimento</label>
                                    <input type="text" name="data_nascimento" maxlength="10" class="data form-control @error('data_nascimento') is-invalid @enderror" value="{{ old('data_nascimento') }}">
                                </div>
                                <div class="form-group col-4">
                                    <label for="naturalidade">Naturalidade</label>
                                    <input type="text" id="naturalidade" name="naturalidade" maxlength="150" class="form-control @error('naturalidade') is-invalid @enderror" value="{{ old('naturalidade') }}">
                                </div>
                                <div class="form-group col-2">
                                    <label for="naturalidade_uf">Naturalidade/UF</label>
                                    <select name="naturalidade_uf" class="form-control @error('naturalidade_uf') is-invalid @enderror">
                                        <option value="" @if (old('naturalidade_uf')==null) selected @endif></option>
                                        @foreach ($estados as $estado)
                                        <option value="{{ $estado->ufe_sg }}" {{ old('naturalidade_uf') == $estado->ufe_sg ? 'selected' : '' }}>{{ $estado->ufe_sg }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-3" id="div-foto">
                            <img src='{{ old("imagem_camera") }}' />
                            <input type="hidden" id="hidden-imagem-camera" name="imagem_camera" value="{{ old('imagem_camera') }}">
                            <div id="div-botoes-foto">
                                <button type="button" id="btn-abrir-captura-foto" class="btn btn-outline-primary btn-sm" alt="Obter foto pela webcam"><i data-feather="camera"></i></button>
                                <button type="button" id="btn-remover-foto" class="btn btn-outline-primary btn-sm" alt="Remover foto"><i data-feather="x"></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-4">
                            <label for="nacionalidade">Nacionalidade</label>
                            <input type="text" name="nacionalidade" maxlength="150" class="form-control @error('nacionalidade') is-invalid @enderror" value="{{ old('nacionalidade') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="nao_perturbe">Não perturbar</label>
                            <select required name="nao_perturbe" class="form-control @error('nao_perturbe') is-invalid @enderror" value="{{ old('nao_perturbe') }}">
                                <option value="0" @if (! old('nao_perturbe')) selected @endif>NÃO</option>
                                <option value="1" @if ( old('nao_perturbe')) selected @endif>SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="nivel_ensino">Nível de ensino</label>
                            <select name="nivel_ensino" class="form-control @error('nivel_ensino') is-invalid @enderror" value="{{ old('nivel_ensino') }}">
                                <option value=""></option>
                                @foreach ($niveisEnsino as $nivel)
                                <option value="{{ $nivel->getIndex() }}" @if (old('nivel_ensino')==$nivel->getIndex()) selected @endif>{{ $nivel->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-5">
                            <label for="nome_mae">Nome da mãe</label>
                            <input type="text" name="nome_mae" maxlength="150" class="form-control @error('nome_mae') is-invalid @enderror" value="{{ old('nome_mae') }}">
                        </div>
                        <div class="form-group col-5">
                            <label for="nome_pai">Nome do pai</label>
                            <input type="text" name="nome_pai" maxlength="150" class="form-control @error('nome_pai') is-invalid @enderror" value="{{ old('nome_pai') }}">
                        </div>
                    </div>

                    <h5 class="hk-pg-title">
                        Dados Funcionais
                    </h5>
                    <hr>
                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="numero_registro">Registro *</label>
                            <input type="text" required name="numero_registro" maxlength="6" class="form-control registro @error('numero_registro') is-invalid @enderror" value="{{ old('numero_registro') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="regime">Regime *</label>
                            <select required id="select-regime" name="regime" class="form-control @error('regime') is-invalid @enderror">
                                @foreach ($regimes as $regime)
                                <option value="{{ $regime->getIndex() }}" @if (old('regime')==$regime->getIndex()) selected @endif>{{ $regime->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="data_admissao">Data de admissão Prefeitura</label>
                            <input type="text" name="data_admissao" class="data form-control @error('data_admissao') is-invalid @enderror" value="{{ old('data_admissao') }}">
                        </div>
                        <div class="form-group col-5">
                            <label for="cargo_id">Cargo</label>
                            <select name="cargo_id" class="form-control @error('cargo_id') is-invalid @enderror">
                                <option value=""></option>
                                @foreach ($cargos as $cargo)
                                <option value="{{ $cargo->id }}">{{ $cargo->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div id="div-aposentado" class="form-row">
                        <div class="form-group col-2">
                            <label for="paridade">Paridade</label>
                            <select id="select-paridade" name="paridade" class="form-control @error('paridade') is-invalid @enderror">
                                <option value="" {{  old('paridade') === '' ? 'selected' : '' }}></option>
                                <option value="1" {{ old('paridade') === '1' ? 'selected' : '' }}>Com</option>
                                <option value="0" {{ old('paridade') === '0' ? 'selected' : '' }}>Sem</option>
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="proventos">Proventos</label>
                            <select name="proventos" class="form-control @error('proventos') is-invalid @enderror">
                                <option value=""></option>
                                @foreach ($proventos as $provento)
                                <option value="{{ $provento->getIndex() }}" @if (old('proventos')==$provento->getIndex()) selected @endif>{{ $provento->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="tipo_aposentadoria">Tipo</label>
                            <select name="tipo_aposentadoria" class="form-control @error('tipo') is-invalid @enderror">
                                <option value=""></option>
                                @foreach ($tiposAposentadoria as $tipo)
                                <option value="{{ $tipo->getIndex() }}" @if (old('tipo_aposentadoria')==$tipo->getIndex()) selected @endif>{{ $tipo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="data_aposentadoria">Data aposentadoria</label>
                            <input type="text" name="data_aposentadoria" class="data form-control @error('data_aposentadoria') is-invalid @enderror" value="{{ old('data_aposentadoria') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="portaria_aposentadoria">Portaria</label>
                            <input type="text" name="portaria_aposentadoria" class="form-control @error('portaria_aposentadoria') is-invalid @enderror" maxlength="20" value="{{ old('portaria_aposentadoria') }}">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="unidadeorganizacional_id">Unidade Organizacional</label>
                            <select name="unidadeorganizacional_id" class="form-control" id="select-unidade-organizacional" @error('unidadeorganizacional_id') is-invalid @enderror">
                                <option value=""></option>
                                @foreach ($unidades as $unidade)
                                <option value="{{ $unidade->id }}" @if (old('unidadeorganizacional_id')==$unidade->id) selected @endif data-secretaria="{{ optional($unidade->secretaria())->sigla_nome }}">{{ $unidade->sigla_nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-6">
                            <label for="secretaria">Secretaria</label>
                            <input readonly class="form-control-plaintext" value="{{ old('secretaria') }}" id="text-secretaria">
                        </div>
                        <div class="form-group col-6">
                            <label for="endereco-lotacao">Lotação</label>
                            <input id="endereco-lotacao" readonly class="form-control-plaintext" value="{{ old('endereco_lotacao') }}" name="endereco_lotacao">
                        </div>
                        <div class="form-group col-2">
                            <label class="d-block">&nbsp;</label>
                            <button type="button" id="btn-escolher-endereco-lotacao" class="btn btn-outline-primary">Escolher outro</button>
                        </div>
                        <div class="form-group col-2" id="div-data-desligamento">
                            <label for="data_desligamento">Data de desligamento</label>
                            <input type="text" name="data_desligamento" id="text-data-desligamento" class="data form-control @error('data_desligamento') is-invalid @enderror" value="{{ old('data_desligamento') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="readaptado">É readaptado</label>
                            <select id="select-readaptado" name="readaptado" class="form-control @error('readaptado') is-invalid @enderror">
                                <option value=""></option>
                                <option value="0" {{ ! old('readaptado') ? 'selected' : '' }}>NÃO</option>
                                <option value="1" {{   old('readaptado') ? 'selected' : '' }}>SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-3" id="div-cargo-readaptado">
                            <label for="cargoreadaptado_id">Cargo readaptado *</label>
                            <select id="select-cargo-readaptado" name="cargoreadaptado_id" class="form-control @error('cargoreadaptado_id') is-invalid @enderror">
                                @foreach ($cargos as $cargo)
                                <option value="{{ $cargo->id }}">{{ $cargo->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="nivel_salarial_id">Nivel Salarial</label>
                            <select name="nivel_salarial_id" class="form-control @error('nivel_salarial_id') is-invalid @enderror">
                                <option value="">&nbsp;</option>
                                @foreach ($niveisSalariais as $nivelSalarial)
                                <option value="{{ $nivelSalarial->id }}" @if (old('nivel_salarial_id')==$nivelSalarial->id) selected @endif>{{ $nivelSalarial->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <h5 class="hk-pg-title">
                        Endereço
                    </h5>
                    <hr>
                    @include('components.endereco', ['container' => 'form-row', 'obrigatorio' => false, 'malaDireta' => true,
                    'malaDiretaChecked' => old('cep') ? old('aceita_mala_direta') : true
                    ])

                    <h5 class="hk-pg-title">
                        Contatos
                    </h5>
                    <hr>
                    <div class="my-10">
                        <button id="btn-incluir-fixo" type="button" class="btn btn-primary"><i data-feather="plus"></i> Telefone fixo</button>
                        <button id="btn-incluir-celular" type="button" class="btn btn-primary"><i data-feather="plus"></i> Telefone celular</button>
                        <button id="btn-incluir-email" type="button" class="btn btn-primary"><i data-feather="plus"></i> E-mail</button>
                    </div>
                    <div class="div-telefones form-row">
                        @include('components.telefone', ['name' => 'telefone[0]', 'tipoTelefone' => 'celular', 'obrigatorio' => true, 'malaDireta' => true,
                        'valor' => old('telefone.0.numero'), 'malaDiretaChecked' => old('telefone.0') ? key_exists('mala_direta', old('telefone.0')) : true
                        ])
                        @include('components.telefone', ['name' => 'telefone[1]', 'valor' => old('telefone.1.numero')])
                    </div>
                    <div class="div-emails form-row">
                        @include('components.email', ['name' => 'email[0]', 'obrigatorio' => false, 'malaDireta' => true,
                        'valor' => old('email.0.endereco'), 'malaDiretaChecked' => old('email.0') ? key_exists('mala_direta', old('email.0')) : true
                        ])
                        @include('components.email', ['name' => 'email[1]', 'obrigatorio' => false, 'malaDireta' => true,
                        'valor' => old('email.1.endereco'), 'malaDiretaChecked' => old('email.1') ? key_exists('mala_direta', old('email.1')) : true
                        ])
                    </div>

                    <div class="form-row">
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea name="observacoes" class="form-control @error('observacoes') is-invalid @enderror">{{ old('observacoes') }}</textarea>
                        </div>
                    </div>

                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.servidores.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-captura-foto" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Capturar foto</h3>
            </div>
            <div class="modal-body">
                <video autoplay></video>
            </div>
            <div class="modal-footer">
                <button id="btn-captura-foto" type="button" class="btn btn-primary">Capturar</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
@include('components.modal-endereco-lotacao', ['container' => 'form-row', 'obrigatorio' => false])
@endsection
