@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidores</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $servidor]) }}">{{ $servidor->nome }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.convenios.index', ['servidor' => $servidor]) }}">Convênios</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir convênio
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.servidores.convenios.store', ['servidor' => $servidor]) }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-4">
                            <label for="convenio_id">Convênio *</label>
                            <select name="convenio_id" required id="select-convenio" class="form-control convenio @error('convenio') is-invalid @enderror">
                                @foreach ($convenios as $convenio)
                                <option value="{{ $convenio->id }}" {{ old('convenio_id') == $convenio->id ? 'selected' : '' }}>{{ $convenio->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.servidores.convenios.index',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection