@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO']) }}">Atendimento Jurídico</a></li>
        @if (request()->tipo == 'associado')
            <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => request()->pessoa]) }}">{{ $pessoa->nome }}</a></li>
        @else
            <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.edit', ['funcionario' => request()->pessoa]) }}">{{ $pessoa->nome }}</a></li>
        @endif
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO']) }}">Atendimento Jurídico</a></li>
        <li class="breadcrumb-item active" aria-current="page">Processos</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Processos
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @button([
                    'route' => 'admin.processos-juridicos.create',
                    'routeParams' => ['tipo' => request()->tipo, 'pessoa' => request()->pessoa, 'agendamento' => request()->agendamento],
                    'icon' => 'plus',
                    'label' => 'Incluir',
                    'class' => 'btn-primary'
                    ])
                @endbutton

                @if (request()->tipo == 'associado')
                    @button([
                        'route' => 'admin.servidores.edit',
                        'routeParams' => ['servidor' => request()->pessoa],
                        'icon' => 'arrow-left',
                        'label' => 'Associado',
                        'class' => 'btn-secondary'
                    ])
                    @endbutton
                @else
                    @button([
                        'route' => 'admin.funcionarios.edit',
                        'routeParams' => ['funcionario' => request()->pessoa],
                        'icon' => 'arrow-left',
                        'label' => 'Funcionário',
                        'class' => 'btn-secondary'
                    ])
                    @endbutton
                @endif

                @if (request()->agendamento)
                    @button([
                        'route' => 'admin.agendamentos-atendimentos.show',
                        'routeParams' => ['agendamento' => request()->agendamento],
                        'icon' => 'arrow-left',
                        'label' => 'Agendamento',
                        'class' => 'btn-secondary'
                    ])
                    @endbutton
                @endif

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Número</th>
                            <th>Vara</th>
                            <th>Competência</th>
                            <th>Tipo</th>
                            <th>Resultado</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($processos as $processo)
                        <tr>
                            <td>{{ $processo->numero }}</td>
                            <td>{{ $processo->vara }}</td>
                            <td>{{ $processo->competencia->descricao }}</td>
                            <td>{{ $processo->tipoAcao->descricao }}</td>
                            <td>{{ optional($processo->resultado)->getValue() }}</td>
                            <td>
                                @button([
                                'route' => 'admin.processos-juridicos.edit',
                                'routeParams' => ['id' => $processo->id, 'pessoa' => request()->pessoa, 'tipo' => request()->tipo, 'agendamento' => request()->agendamento],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.processos-juridicos.destroy',
                                'routeParams' => ['id' => $processo->id, 'pessoa' => request()->pessoa, 'tipo' => request()->tipo],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $processos->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o processo?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection