@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
  <ol class="breadcrumb breadcrumb-light bg-transparent">
    <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO']) }}">Atendimento Jurídico</a></li>
    @if ($processo->agendavel->tipo() == 'associado')
      <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => request()->pessoa]) }}">{{ $processo->agendavel->nome }}</a></li>
    @else
      <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.edit', ['funcionario' => request()->pessoa]) }}">{{ $processo->agendavel->nome }}</a></li>
    @endif
    <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO']) }}">Atendimento Jurídico</a></li>
    <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.processos-juridicos.index', ['tipo' => request()->tipo, 'pessoa' => request()->pessoa]) }}">Processos</a></li>
    <li class="breadcrumb-item active" aria-current="page">Editar</li>
  </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
  <!-- Title -->
  <div class="hk-pg-header">
    <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
      Editar processo
    </h4>
  </div>
  <!-- /Title -->
  <div class="row">
    <div class="col-xl-12">
      <section class="hk-sec-wrapper">
        <form action="{{ route('admin.processos-juridicos.update', ['tipo' => request()->tipo, 'pessoa' => request()->pessoa, 'id' => $processo->id]) }}" method="post">
          @csrf
          @method('PUT')

          @alerts
          @endalerts

          <div class="form-row">
            <div class="form-group col-2">
              <label for="numero">Número *</label>
              <input type="text" required autofocus name="numero" maxlength="30" class="form-control @error('numero') is-invalid @enderror" value="{{ old('numero') ?? $processo->numero }}">
            </div>
            <div class="form-group col-2">
              <label for="vara">Vara</label>
              <input type="text" name="vara" maxlength="10" data-mask="0999999999" data-mask-reverse="true" data-mask-clearifnotmatch="true" class="form-control @error('vara') is-invalid @enderror" value="{{ old('vara') ?? $processo->vara }}">
            </div>
            <div class="form-group col-4">
              <label for="competencia_id">Competência *</label>
              <select name="competencia_id" class="form-control">
                @foreach ($competencias as $competencia)
                <option value="{{ $competencia->id }}" @if (old('competencia_id', $processo->competencia->id) == $competencia->id) selected @endif>{{ $competencia->descricao }}</option>
                @endforeach
              </select>
            </div>
            <div class="form-group col-4">
              <label for="tipo_acao_id">Tipo *</label>
              <select name="tipo_acao_id" class="form-control">
                @foreach ($tiposAcoes as $tipo)
                <option value="{{ $tipo->id }}" @if (old('tipo_acao_id', $processo->tipoAcao->id) == $tipo->id) selected @endif>{{ $tipo->descricao }}</option>
                @endforeach
              </select>
            </div>
            <div class="form-group col-3">
              <label for="resultado">Resultado</label>
              <select name="resultado" class="form-control">
                <option value=""></option>
                @foreach ($resultados as $resultado)
                <option value="{{ $resultado->getIndex() }}" @if (old('resultado', optional($processo->resultado)->getIndex()) == $resultado->getIndex()) selected @endif>{{ $resultado->getValue() }}</option>
                @endforeach
              </select>
            </div>
            <div class="form-group col-2">
              <label for="extinto">Extinto *</label>
              <select required name="extinto" class="form-control">
                <option value="0" @if (!old('extinto') ?? !$processo->extinto) selected @endif)>NÃO</option>
                <option value="1" @if (old('extinto') ?? $processo->extinto) selected @endif>SIM</option>
              </select>
            </div>
            <div class="form-group col-2">
              <label for="pago">Pago *</label>
              <select required name="pago" class="form-control">
                <option value="0" @if (!old('pago') ?? !$processo->pago) selected @endif>NÃO</option>
                <option value="1" @if (old('pago') ?? $processo->pago) selected @endif>SIM</option>
              </select>
            </div>
            <div class="form-group col-3">
              <label for="valor_pago">Valor pago</label>
              <input type="text" name="valor_pago" data-mask="###.##0,00" data-mask-reverse="true" data-mask-clearifnotmatch="true" class="form-control @error('valor_pago') is-invalid @enderror" value="{{ old('valor_pago') ?? $processo->valor_pago }}">
            </div>
            <div class="form-group col-2">
              <label for="data_pagamento">Data pagamento</label>
              <input type="text" name="data_pagamento" data-mask="00/00/0000" data-mask-clearifnotmatch="true" class="form-control @error('data_pagamento') is-invalid @enderror" value="{{ old('data_pagamento') ?? optional($processo->data_pagamento)->format('d/m/Y') }}">
            </div>
            <div class="form-group col-12">
              <label for="anotacoes">Anotações</label>
              <textarea name="anotacoes" class="form-control" rows=5>{{ old('anotacoes') ?? $processo->anotacoes }}</textarea>
            </div>
          </div>

          <h5 class="hk-pg-title">
            Anexos
          </h5>
          <hr>
          @button([
          'route' => 'admin.anexos-processos-juridicos.create',
          'routeParams' => ['idProcesso' => $processo->id, 'pessoa' => request()->pessoa, 'tipo' => request()->tipo],
          'icon' => 'plus',
          'label' => 'Incluir',
          'class' => 'btn-primary'
          ])
          @endbutton

          <div class="form-row">
            @include('components.listagem-anexos-processos', ['anexos' => $processo->anexos])
          </div>

          <h5 class="hk-pg-title">
            Atendimentos
          </h5>
          <hr>
          <div class="form-row">
            @include('components.listagem-atendimentos-juridicos', ['atendimentos' => $atendimentos])
          </div>

          <hr>
          @button([
          'icon' => 'save',
          'label' => 'Salvar',
          'class' => 'btn-primary'
          ])
          @endbutton
          @if (isset($agendamento) && $agendamento->tipo->isJuridico() && $agendamento->podeSerAtendido() && $agendamento->agendavel->tipo() != 'dependente')
          @button([
          'icon' => 'clipboard',
          'label' => 'Atender',
          'class' => 'btn-primary',
          'route' => 'admin.atendimentos-juridicos.create',
          'routeParams' => ['agendamento' => $agendamento, 'processo' => $processo]
          ])
          @endbutton
          @endif
          @button([
          'route' => 'admin.atendimentos-juridicos.historico',
          'routeParams' => ['processo' => $processo, 'agendamento' => request()->agendamento],
          'icon' => 'list',
          'label' => 'Histórico de Atendimentos',
          'class' => 'btn-primary'
          ])
          @endbutton
          @button([
          'route' => 'admin.processos-juridicos.index',
          'routeParams' => ['tipo' => request()->tipo, 'pessoa' => request()->pessoa, 'agendamento' => request()->agendamento],
          'icon' => 'arrow-left',
          'label' => 'Voltar',
          'class' => 'btn-secondary'
          ])
          @endbutton
        </form>
      </section>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-excluir" tabindex="-1" role="dialog">
  <form method="POST" id="form-excluir">
    @csrf
    @method('DELETE')
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-body">
          <p>Deseja realmente excluir o anexo do processo?</p>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Sim</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
        </div>
      </div>
    </div>
  </form>
</div>
@endsection