@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
  <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO']) }}">Atendimento Jurídico</a></li>
    @if (request()->tipo == 'associado')
            <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => request()->pessoa]) }}">{{ $pessoa->nome }}</a></li>
        @else
            <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.funcionarios.edit', ['funcionario' => request()->pessoa]) }}">{{ $pessoa->nome }}</a></li>
        @endif
    <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.processos-juridicos.index', ['tipo' => request()->tipo, 'pessoa' => request()->pessoa]) }}">Processos</a></li>
    <li class="breadcrumb-item active" aria-current="page">Incluir</li>
  </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
  <!-- Title -->
  <div class="hk-pg-header">
    <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
      Incluir processo
    </h4>
  </div>
  <!-- /Title -->
  <div class="row">
    <div class="col-xl-12">
      <section class="hk-sec-wrapper">
        <form action="{{ route('admin.processos-juridicos.store', ['tipo' => request()->tipo, 'pessoa' => request()->pessoa]) }}" method="post">
          @csrf
          @alerts
          @endalerts

          <input type="hidden" name="agendamento" value="{{ request()->agendamento }}">

          <div class="form-row">
            <div class="form-group col-2">
              <label for="numero">Número *</label>
              <input type="text" required autofocus name="numero" maxlength="30" class="form-control @error('numero') is-invalid @enderror" value="{{ old('numero') }}">
            </div>
            <div class="form-group col-2">
              <label for="vara">Vara</label>
              <input type="text" name="vara" maxlength="10" data-mask="0999999999" data-mask-reverse="true" data-mask-clearifnotmatch="true" class="form-control @error('vara') is-invalid @enderror" value="{{ old('vara') }}">
            </div>
            <div class="form-group col-4">
              <label for="competencia_id">Competência *</label>
              <select name="competencia_id" class="form-control">
                @foreach ($competencias as $competencia)
                <option value="{{ $competencia->id }}" @if (old('competencia_id')==$competencia->id) selected @endif>{{ $competencia->descricao }}</option>
                @endforeach
              </select>
            </div>
            <div class="form-group col-4">
              <label for="tipo_acao_id">Tipo *</label>
              <select name="tipo_acao_id" class="form-control">
                @foreach ($tiposAcoes as $tipo)
                <option value="{{ $tipo->id }}" @if (old('tipo_acao_id')==$tipo->id) selected @endif>{{ $tipo->descricao }}</option>
                @endforeach
              </select>
            </div>
            <div class="form-group col-3">
              <label for="resultado">Resultado</label>
              <select name="resultado" class="form-control">
                <option value=""></option>
                @foreach ($resultados as $resultado)
                <option value="{{ $resultado->getIndex() }}" @if (old('resultado')==$resultado->getIndex()) selected @endif>{{ $resultado->getValue() }}</option>
                @endforeach
              </select>
            </div>
            <div class="form-group col-2">
              <label for="extinto">Extinto *</label>
              <select required name="extinto" class="form-control">
                <option value="0" @if (! old('extinto')) selected @endif>NÃO</option>
                <option value="1" @if (old('extinto')) selected @endif>SIM</option>
              </select>
            </div>
            <div class="form-group col-2">
              <label for="pago">Pago *</label>
              <select required name="pago" class="form-control">
                <option value="0" @if (! old('pago')) selected @endif>NÃO</option>
                <option value="1" @if (old('pago')) selected @endif>SIM</option>
              </select>
            </div>
            <div class="form-group col-3">
              <label for="valor_pago">Valor pago</label>
              <input type="text" name="valor_pago" class="form-control @error('valor_pago') is-invalid @enderror" data-mask="###.##0,00" data-mask-reverse="true" data-mask-clearifnotmatch="true" value="{{ old('valor_pago') }}">
            </div>
            <div class="form-group col-2">
              <label for="data_pagamento">Data pagamento</label>
              <input type="text" name="data_pagamento" class="form-control @error('data_pagamento') is-invalid @enderror" data-mask="00/00/0000" data-mask-clearifnotmatch="true" value="{{ old('data_pagamento') }}">
            </div>
            <div class="form-group col-12">
              <label for="anotacoes">Anotações</label>
              <textarea name="anotacoes" class="form-control" rows=5>{{ old('anotacoes') }}</textarea>
            </div>
          </div>
          <hr>
          @button([
          'icon' => 'save',
          'label' => 'Salvar',
          'class' => 'btn-primary'
          ])
          @endbutton
          @button([
          'route' => 'admin.processos-juridicos.index',
          'routeParams' => ['tipo' => request()->tipo, 'pessoa' => request()->pessoa, 'agendamento' => request()->agendamento],
          'icon' => 'arrow-left',
          'label' => 'Voltar',
          'class' => 'btn-secondary'
          ])
          @endbutton
        </form>
      </section>
    </div>
  </div>
</div>
@endsection
