@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/prestadores-servicos/create-edit.js') }}"></script>
<script src="{{ asset('js/admin/telefones.js') }}"></script>
<script src="{{ asset('js/admin/emails.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.prestadores-servicos.index') }}">Prestadores de serviços</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar prestador de serviços
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.prestadores-servicos.update', ['prestador' => $prestador]) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <input type="hidden" id="hidden-sucesso" value="{{ session('sucesso') }}">

                    <div class="form-row">
                        <div class="form-group col-5">
                            <label for="nome">Nome *</label>
                            <input type="text" autofocus required name="nome" maxlength="150" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome') ?? $prestador->nome }}">
                        </div>
                        <div class="form-group col-4">
                            <label for="funcao">Função</label>
                            <input type="text" name="funcao" maxlength="50" class="form-control @error('funcao') is-invalid @enderror" value="{{ old('funcao') ?? $prestador->funcao }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="tipo">Tipo</label>
                            <select name="tipo" id="select-tipo" class="form-control @error('tipo') is-invalid @enderror">
                                <option value="" {{ ! $prestador->tipo ? 'selected' : '' }}></option>
                                @foreach ($tipos as $tipo)
                                <option value="{{ $tipo->getIndex() }}" {{ $prestador->tipo && $prestador->tipo->isEqual($tipo) ? 'selected' : '' }}>{{ $tipo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="especialidade">Especialidade *</label>
                            <select name="especialidade" id="select-especialidade" class="form-control @error('especialidade') is-invalid @enderror">
                                <option value="" {{ ! $prestador->especialidade ? 'selected' : '' }}></option>
                                @foreach ($especialidades as $especialidade)
                                <option value="{{ $especialidade->getIndex() }}" {{ $prestador->especialidade && $prestador->especialidade->isEqual($especialidade) ? 'selected' : '' }}>{{ $especialidade->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="sexo">Sexo</label>
                            <select name="sexo" class="form-control @error('sexo') is-invalid @enderror">
                                <option value="" {{ ! $prestador->sexo ? 'selected' : '' }}></option>
                                @foreach ($sexos as $sexo)
                                <option value="{{ $sexo->getIndex() }}" {{ $prestador->sexo && $prestador->sexo->isEqual($sexo) ? 'selected' : '' }}>{{ $sexo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="rg">RG</label>
                            <input type="text" name="rg" maxlength="10" class="form-control rg @error('rg') is-invalid @enderror" value="{{ old('rg') ?? $prestador->rg }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="cpf">CPF</label>
                            <input type="text" name="cpf" class="form-control cpf @error('cpf') is-invalid @enderror" value="{{ old('cpf') ?? $prestador->cpf }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="cnpj">CNPJ</label>
                            <input type="text" name="cnpj" class="form-control cnpj @error('cnpj') is-invalid @enderror" value="{{ old('cnpj') ?? $prestador->cnpj }}">
                        </div>
                        @include('components.endereco', ['endereco' => $prestador->endereco ?? null])
                        @include('components.telefones', ['telefones' => $prestador->contatos()->telefones()->get(), 'container' => 'form-row col-12'])
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea name="observacoes" class="form-control @error('observacoes') is-invalid @enderror">{{ old('observacoes') ?? $prestador->observacoes }}</textarea>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    <button id="btn-incluir-fixo" type="button" class="btn btn-secondary"><i data-feather="plus"></i> Telefone fixo</button>
                    <button id="btn-incluir-celular" type="button" class="btn btn-secondary"><i data-feather="plus"></i> Telefone celular</button>
                    @button([
                    'route' => 'admin.prestadores-servicos.horarios-trabalho.index',
                    'routeParams' => ['prestador' => $prestador],
                    'icon' => 'calendar',
                    'label' => 'Horários',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.prestadores-servicos.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5>{{ session('status') }}</h5>
            </div>
            <div class="modal-body">
                <p>Deseja continuar e editar o prestador ou voltar para página anterior?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Continuar e editar</button>
                <a href="{{ route('admin.prestadores-servicos.index') }}" class="btn btn-secondary">Voltar</a>
            </div>
        </div>
    </div>
</div>
@endsection
