@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/perguntas-anamnese/index.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Perguntas da anamnese</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Perguntas da anamnese
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts
                
                @button([
                'route' => 'admin.perguntas-anamnese.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                @busca([
                'route' => 'admin.perguntas-anamnese.index',
                'busca' => $busca ?? '',
                'inativos' => true
                ])
                @endbusca

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Pergunta</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($perguntas as $pergunta)
                        <tr>
                            <td>{{ $pergunta->descricao }}</td>
                            <td>
                                @button([
                                'route' => 'admin.perguntas-anamnese.edit',
                                'routeParams' => ['pergunta' => $pergunta],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-pergunta',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.perguntas-anamnese.destroy',
                                'routeParams' => ['pergunta' => $pergunta],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $perguntas->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-pergunta" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-pergunta">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir a pergunta?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection