@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Perfil</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Meu perfil
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <div class="form-row">
                    <div class="form-group col-6">
                        <label for="nome">Nome</label>
                        <input name="nome" type="text" readonly class="form-control" value="{{ $usuario->name }}">
                    </div>
                    <div class="form-group col-6">
                        <label for="email">E-mail</label>
                        <input name="email" type="text" readonly class="form-control" value="{{ $usuario->email }}">
                    </div>
                </div>
                @button([
                'route' => 'admin.perfil.alterar-senha',
                'icon' => 'user',
                'label' => 'Alterar senha',
                'class' => 'btn-primary'
                ])
                @endbutton

            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-excluir-categoria" tabindex="-1" role="dialog">
    <form method="categoria" id="form-excluir-categoria">
        @csrf()
        @method('DELETE')
        <input type="hidden" id="categoria-excluir">
        <input type="hidden" id="csrf-token" value="{{ csrf_token() }}">
        <input type="hidden" id="form-excluir-action" value='{{ url("admin/categorias") }}'>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir a categoria?</p>
                </div>
                <div class="mensagem-erro"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="btn-excluir-categoria">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection