@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/perfil/alterar-senha.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.perfil.index') }}">Perfil</a></li>
        <li class="breadcrumb-item active" aria-current="page">Alterar senha</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Alterar senha
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                <form action="{{ route('admin.perfil.update-senha') }}" method="post">
                    @csrf
                    @method('PUT')
                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="senha_atual">Senha atual (min. 8 caracteres) *</label>
                            <input name="senha_atual" type="password" class="form-control">
                            @error('senha_atual')
                            <div class="alert alert-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="senha_nova">Senha nova *</label>
                            <input id="senha_nova" name="senha_nova" type="password" class="form-control">
                            @error('senha_nova')
                            <div class="alert alert-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-group col-6">
                            <label for="senha_nova_confirmation">Confirmação *</label>
                            <input id="senha_nova_confirmation" name="senha_nova_confirmation" type="password" class="form-control">
                            @error('senha_nova_confirmation')
                            <div class="alert alert-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    @button([
                    'icon' => 'save',
                    'label' => 'Alterar senha',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection