@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/daterangepicker/daterangepicker.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('vendors/moment/min/moment-with-locales.min.js') }}"></script>
<script src="{{ asset('vendors/daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('js/admin/movimento-caixa/index.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Movimento de Caixa</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Movimento de Caixa
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <div class="row">
                    <div class="col-10 offset-md-2">
                        <div class="form-inline float-right mx-2">
                            <button class="btn btn-outline-primary" type="submit" form="filtro">Filtrar</button>
                            <button id="btn-limpar" class="btn btn-outline-secondary mx-1" type="button" form="filtro">Limpar</button>
                        </div>
                        <div class="form-inline float-right mx-2">
                            <label for="periodo" class="mr-1">Período</label>
                            <input type="text" form="filtro" autocomplete="off" value="{{ $periodo }}" name="periodo" class="form-control periodo @error('periodo') is-invalid @enderror" value="{{ old('periodo') }}">
                        </div>
                        <div class="form-inline float-right mx-2">
                            <label for="nota_fiscal" class="mr-1">Nota fiscal</label>
                            <input type="text" form="filtro" value="{{ $notaFiscal }}" name="nota_fiscal" class="form-control @error('nota_fiscal') is-invalid @enderror" value="{{ old('nota_fiscal') }}">
                        </div>
                    </div>
                </div>

                <form id="filtro">
                </form>

                <table class="table table-sm mt-3 table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Descrição</th>
                            <th>Valor venc.(R$)</th>
                            <th>Valor pago (R$)</th>
                            <th>Data</th>
                            <th>Tipo</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($movimentos as $movimento)
                        <tr>
                            <td>{{ $movimento->id }}</td>
                            <td>{{ $movimento->descricao }}</td>
                            <td>{{ number_format($movimento->valor, 2, ',', '.') }}</td>
                            <td>{{ number_format($movimento->valor_pago, 2, ',', '.') }}</td>
                            <td>{{ $movimento->data_pagamento->format('d/m/Y') }}</td>
                            <td>{{ $movimento->tipo->getValue() }}</td>
                            <td>
                                @if ($movimento->tipo->isEntrada())
                                @button([
                                'route' => 'admin.contas-receber.edit',
                                'routeParams' => ['conta' => $movimento],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @else
                                @button([
                                'route' => 'admin.contas-pagar.edit',
                                'routeParams' => ['conta' => $movimento],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $movimentos->links() }}

                <hr>
                <table class="table table-sm col-4 float-right">
                    <tr>
                        <th>Entrada</th>
                        <td class="table-success">R$ {{ number_format($saldo->entrada, 2, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <th>Saída</th>
                        <td class="table-danger">R$ {{ number_format($saldo->saida, 2, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <th>Saldo</th>
                        <td class="{{ $saldo->saldo > 0 ? 'table-info' : 'table-danger' }}">
                            R$ {{ number_format($saldo->saldo, 2, ',', '.') }}
                        </td>
                    </tr>
                </table>
                <div class="clearfix"></div>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-movimento" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-movimento">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o movimento?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
