@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/mensalidades.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Mensalidades</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Mensalidades
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <div class="row">
                    <div class="col-2">
                        @button([
                        'route' => 'admin.mensalidades.create',
                        'icon' => 'plus',
                        'label' => 'Incluir',
                        'class' => 'btn-primary'
                        ])
                        @endbutton
                    </div>

                    <div class="offset-md-3">
                        <div class="btn-group btn-group-toggle" data-toggle="buttons">
                            @foreach ($statuses as $status)
                                @php
                                    $enabled = $status->isEqual($filtroStatus);
                                    $checked = $enabled ? 'checked' : '';
                                    $active = $enabled ? 'active' : '';
                                @endphp
                                <label class="btn btn-outline-secondary {{ $active }}">
                                    <input class="status" form="filtro" name="status" value="{{ $status }}" type="radio" {{ $checked }}> {{ $status }}
                                </label>
                            @endforeach
                        </div>
                    </div>
                    <div class="col-3">
                        <div class="form-inline mx-2">
                            <button class="btn btn-outline-primary" type="submit" form="filtro">Filtrar</button>
                            <button id="btn-limpar" class="btn btn-outline-secondary mx-1" type="button" form="filtro">Limpar</button>
                        </div>
                    </div>
                </div>

                <form id="filtro">
                </form>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nivel</th>
                            <th>Valor</th>
                            <th>Início</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($mensalidades as $mensalidade)
                        <tr>
                            <td>{{ $mensalidade->nivelSalarial->nome }}</td>
                            <td>{{ number_format($mensalidade->valor, 2, ',', '.') }}</td>
                            <td>{{ $mensalidade->inicio_vigencia->format('d/m/Y') }} @if ($mensalidade->termino_vigencia) - {{ $mensalidade->termino_vigencia->format('d/m/Y') }} @endif</td>
                            <td>
                                @button([
                                'route' => 'admin.mensalidades.edit',
                                'routeParams' => ['mensalidade' => $mensalidade],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-mensalidade',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.mensalidades.destroy',
                                'routeParams' => ['mensalidade' => $mensalidade],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $mensalidades->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-mensalidade" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-mensalidade">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir a mensalidade?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection