@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.mensalidades.index') }}">Mensalidades</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir mensalidade
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.mensalidades.store') }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="nivel_salarial_id">Nivel *</label>
                            <select name="nivel_salarial_id" class="form-control" required autofocus>
                                @foreach ($niveis as $nivel) {
                                <option value="{{ $nivel->id }}" @if (old('nivel_salarial_id') == $nivel->id) selected @endif>{{ $nivel->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="valor">Valor *</label>
                            <input type="text" required name="valor" data-mask="###.##0,00" data-mask-reverse="true" data-mask-clearifnotmatch="true" class="form-control @error('valor') is-invalid @enderror" value="{{ old('valor') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="inicio_vigencia">Início vigência *</label>
                            <input type="text" required name="inicio_vigencia" data-mask="00/00/0000" data-mask-clearifnotmatch="true" class="form-control @error('inicio_vigencia') is-invalid @enderror" value="{{ old('inicio_vigencia', today()->format('d/m/Y')) }}">
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.mensalidades.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection