@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/horarios-trabalho/index.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['trabalhavel']['index']['route']) }}">{{ $trabalhavel }}</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route($routes['trabalhavel']['edit']['route'], $routes['trabalhavel']['edit']['params']) }}">Editar</a></li>
        <li class="breadcrumb-item active" aria-current="page">Horários de trabalho</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Horários de trabalho
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <form action="{{ route($routes['horario']['store']['route'], $routes['horario']['store']['params']) }}" method="post">
                    @csrf
                    <table class="table mt-3">
                        <thead>
                            <tr>
                                <th class="col-3">Dia semana</th>
                                <th>Entrada</th>
                                <th>Saída</th>
                                <th>Entrada</th>
                                <th>Saída</th>
                            </tr>
                        </thead>
                        <tbody>

                            @foreach ($diasSemana as $diaSemana)
                            <tr>
                                <td>{{ $diaSemana }}</td>
                                <td>
                                    <input type="text" class="form-control horario" value='
                                                @if (old("horarios.{$diaSemana->getName()}.0.inicio")))
                                                    {{ old("horarios.{$diaSemana->getName()}.0.inicio") }}
                                                @elseif (isset($horarios[$diaSemana->getName()][0])) 
                                                    {{ $horarios[$diaSemana->getName()][0]["inicio"]->format("H:i") }}
                                                @else 
                                                    ""
                                                @endif' name='{{ "horarios[{$diaSemana->getName()}][0][inicio]" }}'>
                                </td>
                                <td>
                                    <input type="text" class="form-control horario" value='
                                                @if (old("horarios.{$diaSemana->getName()}.0.fim")))
                                                    {{ old("horarios.{$diaSemana->getName()}.0.fim") }}
                                                @elseif (isset($horarios[$diaSemana->getName()][0])) 
                                                    {{ $horarios[$diaSemana->getName()][0]["fim"]->format("H:i") }}
                                                @else 
                                                    ""
                                                @endif' name='{{ "horarios[{$diaSemana->getName()}][0][fim]" }}'>
                                </td>
                                <td>
                                    <input type="text" class="form-control horario" value='
                                                @if (old("horarios.{$diaSemana->getName()}.1.inicio")))
                                                    {{ old("horarios.{$diaSemana->getName()}.1.inicio") }}
                                                @elseif (isset($horarios[$diaSemana->getName()][1])) 
                                                    {{ $horarios[$diaSemana->getName()][1]["inicio"]->format("H:i") }}
                                                @else 
                                                    ""
                                                @endif' name='{{ "horarios[{$diaSemana->getName()}][1][inicio]" }}'>
                                </td>
                                <td>
                                    <input type="text" class="form-control horario" value='
                                                @if (old("horarios.{$diaSemana->getName()}.1.fim")))
                                                    {{ old("horarios.{$diaSemana->getName()}.1.fim") }}
                                                @elseif (isset($horarios[$diaSemana->getName()][1])) 
                                                    {{ $horarios[$diaSemana->getName()][1]["fim"]->format("H:i") }}
                                                @else 
                                                    ""
                                                @endif' name='{{ "horarios[{$diaSemana->getName()}][1][fim]" }}'>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection