@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.guia-atendimento.index') }}">Guia de atendimento</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar atendimento - {{ $atendimento->servidor->nome }}
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.guia-atendimento.update', ['atendimento' => $atendimento]) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-12">
                            <label for="atendimento">Atendimento *</label>
                            <textarea rows="5" type="text" required autofocus name="atendimento" class="form-control @error('atendimento') is-invalid @enderror">{{ $atendimento->atendimento }}</textarea>
                        </div>
                        <div class="form-group col-4">
                            <label for="motivo_id">Motivo *</label>
                            <select name="motivo_id" class="form-control">
                                @foreach ($motivos as $motivo)
                                <option value="{{ $motivo->id }}" @if ($motivo->id == optional($atendimento->motivo)->id) selected @endif>{{ $motivo->descricao }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="resolvido">Resolvido *</label>
                            <select name="resolvido" class="form-control">
                                <option value="1" {{ $atendimento->resolvido ? 'selected' : '' }}>SIM</option>
                                <option value="0" {{ ! $atendimento->resolvido ? 'selected' : '' }}>NÃO</option>
                            </select>
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.guia-atendimento.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5>{{ session('status') }}</h5>
            </div>
            <div class="modal-body">
                <p>Deseja continuar e editar o prestador ou voltar para página anterior?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Continuar e editar</button>
                <a href="{{ route('admin.guia-atendimento.index') }}" class="btn btn-secondary">Voltar</a>
            </div>
        </div>
    </div>
</div>
@endsection